/*
 * Decompiled with CFR 0.152.
 */
package vin.controller;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Optional;
import java.util.ResourceBundle;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.control.Alert;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.TextField;
import javafx.scene.control.TextInputDialog;
import javafx.scene.control.cell.PropertyValueFactory;
import javafx.util.Callback;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import vin.Class.ColumnTableGridVigneti;
import vin.Comunicator.Sk1SrvCommunicator;
import vin.Uility.JsonUtils;
import vin.Uility.Utility;
import vin.controller.FXMLDocumentController;
import vin.controller.ToastFXMessages;

public class AnagVignetiController
implements Initializable {
    Utility util;
    ObservableList<ColumnTableGridVigneti> lista_tablegridvin = null;
    String data_select = "";
    Sk1SrvCommunicator sk1Comm = new Sk1SrvCommunicator();
    JsonUtils jsonUtil = new JsonUtils();
    ToastFXMessages toast = new ToastFXMessages();
    @FXML
    TableView<ColumnTableGridVigneti> table;
    @FXML
    TableColumn<ColumnTableGridVigneti, Integer> column_id;
    @FXML
    TableColumn<ColumnTableGridVigneti, String> column_codice;
    @FXML
    TableColumn<ColumnTableGridVigneti, String> column_descrizione;
    @FXML
    TextField editText_codice;
    @FXML
    TextField editText_descrizione;

    public void initialize(URL url, ResourceBundle rb) {
        try {
            this.lista_tablegridvin = FXCollections.observableArrayList();
            this.util = new Utility();
            this.column_id.setCellValueFactory((Callback)new PropertyValueFactory("column_id"));
            this.column_codice.setCellValueFactory((Callback)new PropertyValueFactory("column_codice"));
            this.column_descrizione.setCellValueFactory((Callback)new PropertyValueFactory("column_descrizione"));
            ArrayList<String> tipo = new ArrayList<String>();
            ArrayList<String> strSQL = new ArrayList<String>();
            tipo.add("select");
            strSQL.add("SELECT id,codice,descrizione FROM gen_vigneti_ana WHERE azienda='" + FXMLDocumentController.GLOBAL_AZIENDA + "' AND sotto_az='" + FXMLDocumentController.GLOBAL_SOTTOAZZ + "'  GROUP BY codice\nORDER BY id DESC");
            ArrayList<Boolean> last_ID = new ArrayList<Boolean>();
            last_ID.add(false);
            String str = this.util.makeStringJsonDB("OFF", tipo, strSQL, null, null, last_ID, null);
            this.data_select = this.sk1Comm.ServerEsecuteRequest(FXMLDocumentController.GLOBAL_IP, FXMLDocumentController.GLOBAL_PORT, "dbInteraction#@" + str);
            if (!this.data_select.contains("#ERR:")) {
                JSONArray arrayJson = this.jsonUtil.strJsonToJSONArray(this.data_select);
                for (int i = 0; i < arrayJson.length(); ++i) {
                    try {
                        JSONObject rec = arrayJson.getJSONObject(i);
                        this.lista_tablegridvin.add((Object)new ColumnTableGridVigneti(rec.getInt("id"), rec.getString("codice"), rec.getString("descrizione")));
                        continue;
                    }
                    catch (JSONException ex) {
                        this.util.alertWindow(Alert.AlertType.ERROR, "ERRORE", "", ex.toString());
                    }
                }
            }
            this.table.setItems(this.lista_tablegridvin);
        }
        catch (IOException | JSONException ex) {
            this.util.alertWindow(Alert.AlertType.ERROR, "ERRORE", "", ex.toString());
        }
    }

    @FXML
    public void btnElimina() throws JSONException {
        int selected = ((ColumnTableGridVigneti)this.table.getSelectionModel().getSelectedItem()).getColumn_id();
        ArrayList<Boolean> last_ID = new ArrayList<Boolean>();
        String str = "";
        ArrayList<String> tipo = new ArrayList<String>();
        ArrayList<String> strSQL = new ArrayList<String>();
        if (selected > 0) {
            String codice = ((ColumnTableGridVigneti)this.table.getSelectionModel().getSelectedItem()).getColumn_codice();
            tipo = new ArrayList();
            strSQL = new ArrayList();
            tipo.add("select");
            strSQL.add("SELECT id FROM gen_tipo_vino_ana WHERE sian_cod_vigna='" + codice + "'");
            last_ID = new ArrayList();
            last_ID.add(false);
            str = this.util.makeStringJsonDB("OFF", tipo, strSQL, null, null, last_ID, null);
            this.data_select = this.sk1Comm.ServerEsecuteRequest(FXMLDocumentController.GLOBAL_IP, FXMLDocumentController.GLOBAL_PORT, "dbInteraction#@" + str);
            if (!this.data_select.contains("#ERR:")) {
                if (!this.data_select.equals("[]")) {
                    this.util.alertWindow(Alert.AlertType.ERROR, "ERRORE", "", "Vigna gi\u00e0 utilizzata impossibile da cancellare !");
                    return;
                }
            } else {
                this.util.alertWindow(Alert.AlertType.ERROR, "ERRORE", "", this.data_select);
            }
            TextInputDialog dialog = new TextInputDialog("");
            dialog.setTitle("SICUREZZA");
            dialog.setHeaderText("Confermare cancellazione vigneto.\nConfermi la cancellazione del Vigneto ?");
            dialog.setContentText("Password: (PROCEDI)");
            Optional result = dialog.showAndWait();
            if (result.isPresent() && ((String)result.get()).toString().trim().equals("PROCEDI")) {
                tipo.add("delete");
                strSQL.add("DELETE FROM gen_vigneti_ana WHERE id=" + selected);
                last_ID.add(false);
                str = this.util.makeStringJsonDB("OFF", tipo, strSQL, null, null, last_ID, null);
                this.data_select = this.sk1Comm.ServerEsecuteRequest(FXMLDocumentController.GLOBAL_IP, FXMLDocumentController.GLOBAL_PORT, "dbInteraction#@" + str);
                if (!this.data_select.contains("#ERR:")) {
                    this.lista_tablegridvin.clear();
                    tipo = new ArrayList();
                    strSQL = new ArrayList();
                    tipo.add("select");
                    strSQL.add("SELECT id,codice,descrizione FROM gen_vigneti_ana ORDER BY id DESC");
                    last_ID = new ArrayList();
                    last_ID.add(false);
                    str = this.util.makeStringJsonDB("OFF", tipo, strSQL, null, null, last_ID, null);
                    this.data_select = this.sk1Comm.ServerEsecuteRequest(FXMLDocumentController.GLOBAL_IP, FXMLDocumentController.GLOBAL_PORT, "dbInteraction#@" + str);
                    if (!this.data_select.contains("#ERR:")) {
                        JSONArray arrayJson = this.jsonUtil.strJsonToJSONArray(this.data_select);
                        for (int i = 0; i < arrayJson.length(); ++i) {
                            try {
                                JSONObject rec = arrayJson.getJSONObject(i);
                                this.lista_tablegridvin.add((Object)new ColumnTableGridVigneti(rec.getInt("id"), rec.getString("codice"), rec.getString("descrizione")));
                                continue;
                            }
                            catch (JSONException ex) {
                                this.util.alertWindow(Alert.AlertType.ERROR, "ERRORE", "", ex.toString());
                            }
                        }
                    } else {
                        this.util.alertWindow(Alert.AlertType.ERROR, "ERRORE", "", this.data_select);
                    }
                    this.table.setItems(this.lista_tablegridvin);
                    this.toast.startToast("Vigneto cancellato", "SUCCESSO", "SUCCESSO");
                }
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @FXML
    public void btnSalva() throws JSONException {
        String codice = this.editText_codice.getText().trim();
        String descrizione = this.editText_descrizione.getText().trim();
        if (codice.equals("")) {
            this.util.alertWindow(Alert.AlertType.ERROR, "ERRORE", "", "Campo codice obbligatorio");
            return;
        }
        if (descrizione.equals("")) {
            this.util.alertWindow(Alert.AlertType.ERROR, "ERRORE", "", "Campo descrizione obbligatorio");
            return;
        }
        ArrayList<String> tipo = new ArrayList<String>();
        ArrayList<String> strSQL = new ArrayList<String>();
        String[][] tipo_ins = new String[1][6];
        String[][] valore = new String[1][6];
        ArrayList<Boolean> last_ID = new ArrayList<Boolean>();
        ArrayList<Integer> lenghtBidimensionalArray = new ArrayList<Integer>();
        lenghtBidimensionalArray.add(6);
        last_ID.add(false);
        tipo_ins[0][0] = "string";
        tipo_ins[0][1] = "string";
        tipo_ins[0][2] = "string";
        tipo_ins[0][3] = "string";
        tipo_ins[0][4] = "string";
        tipo_ins[0][5] = "string";
        valore[0][0] = codice;
        valore[0][1] = descrizione;
        valore[0][2] = FXMLDocumentController.GLOBAL_AZIENDA;
        valore[0][3] = FXMLDocumentController.GLOBAL_SOTTOAZZ;
        valore[0][4] = FXMLDocumentController.GLOBAL_ICQRF;
        valore[0][5] = FXMLDocumentController.GLOBAL_CODCOMM;
        tipo.add("insert");
        strSQL.add("INSERT INTO gen_vigneti_ana (codice,descrizione,azienda,sotto_az,icqrf,cod_committente) VALUES(?,?,?,?,?,?)");
        last_ID = new ArrayList();
        last_ID.add(false);
        String str = this.util.makeStringJsonDB("OFF", tipo, strSQL, tipo_ins, valore, last_ID, lenghtBidimensionalArray);
        this.data_select = this.sk1Comm.ServerEsecuteRequest(FXMLDocumentController.GLOBAL_IP, FXMLDocumentController.GLOBAL_PORT, "dbInteraction#@" + str);
        if (this.data_select.contains("#ERR:")) {
            this.util.alertWindow(Alert.AlertType.ERROR, "ERRORE", "", "ATTENZIONE!\n" + this.data_select);
            return;
        }
        this.editText_codice.setText("");
        this.editText_descrizione.setText("");
        this.lista_tablegridvin.clear();
        tipo = new ArrayList();
        strSQL = new ArrayList();
        tipo.add("select");
        strSQL.add("SELECT id,codice,descrizione FROM gen_vigneti_ana WHERE azienda='" + FXMLDocumentController.GLOBAL_AZIENDA + "' AND sotto_az='" + FXMLDocumentController.GLOBAL_SOTTOAZZ + "'  ORDER BY id DESC");
        last_ID = new ArrayList();
        last_ID.add(false);
        str = this.util.makeStringJsonDB("OFF", tipo, strSQL, null, null, last_ID, null);
        this.data_select = this.sk1Comm.ServerEsecuteRequest(FXMLDocumentController.GLOBAL_IP, FXMLDocumentController.GLOBAL_PORT, "dbInteraction#@" + str);
        if (!this.data_select.contains("#ERR:")) {
            JSONArray arrayJson = this.jsonUtil.strJsonToJSONArray(this.data_select);
            for (int i = 0; i < arrayJson.length(); ++i) {
                try {
                    JSONObject rec = arrayJson.getJSONObject(i);
                    this.lista_tablegridvin.add((Object)new ColumnTableGridVigneti(rec.getInt("id"), rec.getString("codice"), rec.getString("descrizione")));
                    continue;
                }
                catch (JSONException ex) {
                    this.util.alertWindow(Alert.AlertType.ERROR, "ERRORE", "", ex.toString());
                }
            }
        }
        this.table.setItems(this.lista_tablegridvin);
        this.toast.startToast("Vigneto inserito", "SUCCESSO", "SUCCESSO");
    }
}

