/*
 * Decompiled with CFR 0.152.
 */
package vin.controller;

import com.jfoenix.controls.JFXCheckBox;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.application.Platform;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.collections.transformation.FilteredList;
import javafx.collections.transformation.SortedList;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.fxml.FXML;
import javafx.fxml.FXMLLoader;
import javafx.fxml.Initializable;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Alert;
import javafx.scene.control.Button;
import javafx.scene.control.CheckBox;
import javafx.scene.control.ComboBox;
import javafx.scene.control.TableCell;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.TextField;
import javafx.scene.control.TextInputDialog;
import javafx.scene.control.cell.PropertyValueFactory;
import javafx.stage.Modality;
import javafx.stage.Stage;
import javafx.stage.WindowEvent;
import javafx.util.Callback;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import vin.Class.CodiceDescrizione;
import vin.Class.ColumnTableGridVasiVinari;
import vin.Class.EditingCellBoolean;
import vin.Class.WorkIndicatorDialog;
import vin.Uility.JasperReport;
import vin.controller.AnagGeneraSoggettiT;
import vin.controller.FXMLDocumentController;
import vin.controller.StampaMovimentiController;

public class AnagVasiVinariController
implements Initializable {
    ObservableList<ColumnTableGridVasiVinari> lista_tablegridvaso = null;
    ObservableList<CodiceDescrizione> lista_tipovaso = null;
    String data_select = "";
    JasperReport jasperReport = new JasperReport();
    @FXML
    private TextField editText_codicevaso;
    @FXML
    TableView<ColumnTableGridVasiVinari> table_vaso;
    @FXML
    TableColumn<ColumnTableGridVasiVinari, Integer> column_id;
    @FXML
    TableColumn<ColumnTableGridVasiVinari, String> column_codicevaso;
    @FXML
    TableColumn<ColumnTableGridVasiVinari, String> column_tipovaso;
    @FXML
    TableColumn<ColumnTableGridVasiVinari, String> column_descrizione;
    @FXML
    TableColumn<ColumnTableGridVasiVinari, Double> column_capacita;
    @FXML
    TableColumn<ColumnTableGridVasiVinari, Double> column_giacenzainiziale;
    @FXML
    TableColumn<ColumnTableGridVasiVinari, String> column_tipoprodotto;
    @FXML
    TableColumn<ColumnTableGridVasiVinari, Boolean> column_reale;
    @FXML
    TableColumn<ColumnTableGridVasiVinari, Boolean> column_test;
    @FXML
    TextField editText_searcharticolo;
    @FXML
    ComboBox cmbx_tipovaso;
    @FXML
    TextField editText_descrizione;
    @FXML
    TextField editText_capacita;
    boolean flag_modifica = false;
    @FXML
    CheckBox chk_gruppo;
    @FXML
    Button btnazzera;
    int id_selected = 0;
    FilteredList<ColumnTableGridVasiVinari> filteredData = null;
    @FXML
    private TextField editText_searchDescrizione;
    @FXML
    private TextField editText_searchTipoVaso;
    @FXML
    private JFXCheckBox check_select;
    WorkIndicatorDialog wd = null;

    public void initialize(URL url, ResourceBundle rb) {
        try {
            this.lista_tablegridvaso = FXCollections.observableArrayList();
            this.lista_tipovaso = FXCollections.observableArrayList();
            this.column_id.setCellValueFactory((Callback)new PropertyValueFactory("column_id"));
            this.column_codicevaso.setCellValueFactory((Callback)new PropertyValueFactory("column_codicevaso"));
            this.column_tipovaso.setCellValueFactory((Callback)new PropertyValueFactory("column_tipovaso"));
            this.column_descrizione.setCellValueFactory((Callback)new PropertyValueFactory("column_descrizione"));
            this.column_capacita.setCellValueFactory((Callback)new PropertyValueFactory("column_capacita"));
            this.column_giacenzainiziale.setCellValueFactory((Callback)new PropertyValueFactory("column_giacenzainiziale"));
            this.column_tipoprodotto.setCellValueFactory((Callback)new PropertyValueFactory("column_tipoprodotto"));
            this.column_test.setCellValueFactory((Callback)new PropertyValueFactory("column_presenzatest"));
            this.column_reale.setCellValueFactory((Callback)new PropertyValueFactory("column_presenzareale"));
            Callback<TableColumn<ColumnTableGridVasiVinari, Boolean>, TableCell<ColumnTableGridVasiVinari, Boolean>> invioflag = new Callback<TableColumn<ColumnTableGridVasiVinari, Boolean>, TableCell<ColumnTableGridVasiVinari, Boolean>>(){

                public TableCell call(TableColumn p) {
                    return new EditingCellBoolean();
                }
            };
            this.column_test.setCellFactory((Callback)invioflag);
            this.column_test.setOnEditCommit((EventHandler)new EventHandler<TableColumn.CellEditEvent<ColumnTableGridVasiVinari, Boolean>>(){

                public void handle(TableColumn.CellEditEvent<ColumnTableGridVasiVinari, Boolean> t) {
                    ((ColumnTableGridVasiVinari)t.getTableView().getItems().get(t.getTablePosition().getRow())).setColumn_presenzatest((Boolean)t.getNewValue());
                }
            });
            this.column_reale.setCellFactory((Callback)invioflag);
            this.column_reale.setOnEditCommit((EventHandler)new EventHandler<TableColumn.CellEditEvent<ColumnTableGridVasiVinari, Boolean>>(){

                public void handle(TableColumn.CellEditEvent<ColumnTableGridVasiVinari, Boolean> t) {
                    ((ColumnTableGridVasiVinari)t.getTableView().getItems().get(t.getTablePosition().getRow())).setColumn_presenzareale((Boolean)t.getNewValue());
                }
            });
            try {
                this.fillecombo();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.cmbx_tipovaso.setItems(this.lista_tipovaso);
            this.editText_codicevaso.lengthProperty().addListener((ChangeListener)new ChangeListener<Number>(){

                public void changed(ObservableValue<? extends Number> observable, Number oldValue, Number newValue) {
                    if (newValue.intValue() > oldValue.intValue() && AnagVasiVinariController.this.editText_codicevaso.getText().length() >= 30) {
                        AnagVasiVinariController.this.editText_codicevaso.setText(AnagVasiVinariController.this.editText_codicevaso.getText().substring(0, 30));
                    }
                }
            });
            FXMLDocumentController.util.addTextLimiterAll(this.editText_codicevaso, 20);
            this.check_select.selectedProperty().addListener((ChangeListener)new ChangeListener<Boolean>(){

                public void changed(ObservableValue<? extends Boolean> observable, Boolean oldValue, Boolean newValue) {
                    if (newValue.booleanValue()) {
                        try {
                            AnagVasiVinariController.this.refreshListaRaggruppata();
                            for (int i = 0; i < AnagVasiVinariController.this.lista_tablegridvaso.size(); ++i) {
                                ((ColumnTableGridVasiVinari)AnagVasiVinariController.this.lista_tablegridvaso.get(i)).setColumn_tipoprodotto("");
                                ((ColumnTableGridVasiVinari)AnagVasiVinariController.this.lista_tablegridvaso.get(i)).setColumn_giacenzainiziale(0.0);
                                ((ColumnTableGridVasiVinari)AnagVasiVinariController.this.lista_tablegridvaso.get(i)).setColumn_giacenza(0.0);
                            }
                            AnagVasiVinariController.this.table_vaso.refresh();
                        }
                        catch (JSONException ex) {
                            Logger.getLogger(AnagVasiVinariController.class.getName()).log(Level.SEVERE, null, ex);
                        }
                    } else {
                        try {
                            AnagVasiVinariController.this.refreshLista(false);
                        }
                        catch (JSONException ex) {
                            Logger.getLogger(AnagVasiVinariController.class.getName()).log(Level.SEVERE, null, ex);
                        }
                    }
                }
            });
            Platform.runLater((Runnable)new Runnable(){

                @Override
                public void run() {
                    try {
                        AnagVasiVinariController.this.refreshLista(false);
                    }
                    catch (JSONException ex) {
                        Logger.getLogger(AnagGeneraSoggettiT.class.getName()).log(Level.SEVERE, null, ex);
                    }
                }
            });
            this.filteredData = new FilteredList(this.lista_tablegridvaso, p -> true);
            this.editText_searcharticolo.textProperty().addListener((observable, oldValue, newValue) -> this.filteredData.setPredicate(person -> {
                if (newValue == null || newValue.isEmpty()) {
                    return true;
                }
                String lowerCaseFilter = newValue.toLowerCase();
                return person.getColumn_codicevaso().toLowerCase().contains(lowerCaseFilter);
            }));
            this.editText_searchTipoVaso.textProperty().addListener((observable, oldValue, newValue) -> this.filteredData.setPredicate(person -> {
                if (newValue == null || newValue.isEmpty()) {
                    return true;
                }
                String lowerCaseFilter = newValue.toLowerCase();
                return person.getColumn_tipovaso().toLowerCase().contains(lowerCaseFilter);
            }));
            this.editText_searchDescrizione.textProperty().addListener((observable, oldValue, newValue) -> this.filteredData.setPredicate(person -> {
                if (newValue == null || newValue.isEmpty()) {
                    return true;
                }
                String lowerCaseFilter = newValue.toLowerCase();
                return person.getColumn_descrizione().toLowerCase().contains(lowerCaseFilter);
            }));
            SortedList sortedData = new SortedList(this.filteredData);
            sortedData.comparatorProperty().bind((ObservableValue)this.table_vaso.comparatorProperty());
            this.table_vaso.setItems((ObservableList)sortedData);
        }
        catch (Exception ex) {
            FXMLDocumentController.util.alertWindow(Alert.AlertType.ERROR, "ERRORE", "", ex.toString());
        }
    }

    @FXML
    void btnMIPAAFSIAN(ActionEvent event) {
        try {
            this.refreshLista(true);
        }
        catch (JSONException ex) {
            Logger.getLogger(AnagVasiVinariController.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    private void fillecombo() throws JSONException {
        ArrayList<String> tipo = new ArrayList<String>();
        ArrayList<String> strSQL = new ArrayList<String>();
        ArrayList<Boolean> last_ID = new ArrayList<Boolean>();
        tipo.add("select");
        strSQL.add("SELECT codice,descrizione FROM sian_t_tipo_vaso");
        last_ID.add(false);
        String str = FXMLDocumentController.util.makeStringJsonDB("OFF", tipo, strSQL, null, null, last_ID, null);
        this.data_select = FXMLDocumentController.sk1Comm.ServerEsecuteRequest(FXMLDocumentController.GLOBAL_IP, FXMLDocumentController.GLOBAL_PORT, "dbInteraction#@" + str);
        this.lista_tipovaso.clear();
        if (!this.data_select.contains("#ERR:")) {
            this.lista_tipovaso.add(null);
            JSONArray arrayJson = FXMLDocumentController.jsonUtil.strJsonToJSONArray(this.data_select);
            for (int i = 0; i < arrayJson.length(); ++i) {
                try {
                    JSONObject rec = arrayJson.getJSONObject(i);
                    this.lista_tipovaso.add((Object)new CodiceDescrizione(rec.getString("codice"), rec.getString("descrizione")));
                    continue;
                }
                catch (JSONException ex) {
                    FXMLDocumentController.util.alertWindow(Alert.AlertType.ERROR, "ERRORE", "", ex.toString());
                }
            }
        }
    }

    @FXML
    public void btnAzzeramento() throws JSONException, IOException {
        FXMLLoader loader = new FXMLLoader(this.getClass().getResource("/vin/view/AzzeramentoVasche.fxml"));
        Parent rootLayout = (Parent)loader.load();
        Scene scene = new Scene(rootLayout);
        Stage stage = new Stage();
        stage.setOnCloseRequest((EventHandler)new EventHandler<WindowEvent>(){

            public void handle(WindowEvent event) {
                try {
                    AnagVasiVinariController.this.refreshLista(false);
                }
                catch (JSONException ex) {
                    Logger.getLogger(AnagVasiVinariController.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
        });
        stage.setMaximized(false);
        stage.setTitle("AZZERAMENTO");
        stage.setScene(scene);
        stage.initModality(Modality.APPLICATION_MODAL);
        stage.setResizable(false);
        stage.showAndWait();
    }

    @FXML
    public void btnStampa() throws JSONException {
        try {
            ArrayList<String> key = new ArrayList<String>();
            ArrayList<Object> value = new ArrayList<Object>();
            int tipoStampa = 1;
            boolean tipoStampa2 = false;
            String stato_fisico = "";
            String nomeFileJRXML = "";
            key.add("AZIENDA");
            key.add("SOTTO_AZ");
            key.add("ICQRF");
            key.add("COD_COMMITTENTE");
            value.add(FXMLDocumentController.GLOBAL_AZIENDA);
            value.add(FXMLDocumentController.GLOBAL_SOTTOAZZ);
            value.add(FXMLDocumentController.GLOBAL_ICQRF);
            value.add(FXMLDocumentController.GLOBAL_CODCOMM);
            nomeFileJRXML = "ana_vasi_vinari.jrxml";
            String resp = this.jasperReport.JSONjr(nomeFileJRXML, key, value, tipoStampa, "");
            String nomeFile = FXMLDocumentController.sk1Comm.ServerEsecuteRequest(FXMLDocumentController.GLOBAL_IP, FXMLDocumentController.GLOBAL_PORT, "JasperReport#@" + resp);
            FXMLDocumentController.util.downloadFileTemp(nomeFile);
        }
        catch (IOException ex) {
            Logger.getLogger(AnagVasiVinariController.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    private String selectStampeVasi() {
        String ret = "SELECT a.codice_vaso,a.descr_vaso,a.capacita,b.DESCRIZIONE AS tipo_vaso FROM gen_vasi_vinari_ana AS a LEFT JOIN  sian_t_tipo_vaso AS b ON a.tipo_vaso=b.CODICE WHERE azienda='" + FXMLDocumentController.GLOBAL_AZIENDA + "' AND sotto_az='" + FXMLDocumentController.GLOBAL_SOTTOAZZ + "' AND icqrf='" + FXMLDocumentController.GLOBAL_ICQRF + "' AND cod_committente='" + FXMLDocumentController.GLOBAL_CODCOMM + "'";
        return ret;
    }

    @FXML
    public void btnElimina() throws JSONException {
        int selected = ((ColumnTableGridVasiVinari)this.table_vaso.getSelectionModel().getSelectedItem()).getColumn_id();
        if (selected <= 0) {
            FXMLDocumentController.toast.startToast("Selezionare prima un vaso vinario.", "INFORMAZIONE", "INFORMAZIONE");
        } else {
            ArrayList<String> tipo = new ArrayList<String>();
            ArrayList<String> strSQL = new ArrayList<String>();
            ArrayList<Boolean> last_ID = new ArrayList<Boolean>();
            tipo.add("select");
            strSQL.add("SELECT COUNT(id) AS giacenza FROM gen_vasi_vinari_mov WHERE id_vaso=" + selected);
            last_ID.add(false);
            Double giainizi = 0.0;
            String str = FXMLDocumentController.util.makeStringJsonDB("ON", tipo, strSQL, null, null, last_ID, null);
            this.data_select = FXMLDocumentController.sk1Comm.ServerEsecuteRequest(FXMLDocumentController.GLOBAL_IP, FXMLDocumentController.GLOBAL_PORT, "dbInteraction#@" + str);
            if (!this.data_select.contains("#ERR:")) {
                JSONArray arrayJson = FXMLDocumentController.jsonUtil.strJsonToJSONArray(this.data_select);
                for (int i = 0; i < arrayJson.length(); ++i) {
                    try {
                        JSONObject rec = arrayJson.getJSONObject(i);
                        giainizi = rec.getDouble("giacenza");
                        if (giainizi != null) continue;
                        giainizi = 0.0;
                        continue;
                    }
                    catch (JSONException ex) {
                        FXMLDocumentController.util.alertWindow(Alert.AlertType.ERROR, "ERRORE", "", ex.toString());
                    }
                }
                if (giainizi <= 0.0) {
                    TextInputDialog dialog = new TextInputDialog("");
                    dialog.setTitle("SICUREZZA");
                    dialog.setHeaderText("Confermare cancellazione tipo vino.\n Confermi la cancellazione del Tipo Vino ?");
                    dialog.setContentText("Password(PROCEDI):");
                    Optional result = dialog.showAndWait();
                    if (result.isPresent() && ((String)result.get()).trim().equals("PROCEDI")) {
                        tipo = new ArrayList();
                        strSQL = new ArrayList();
                        last_ID = new ArrayList();
                        tipo.add("delete");
                        strSQL.add("DELETE FROM gen_vasi_vinari_ana WHERE id=" + selected);
                        last_ID.add(false);
                        str = FXMLDocumentController.util.makeStringJsonDB("ON", tipo, strSQL, null, null, last_ID, null);
                        this.data_select = FXMLDocumentController.sk1Comm.ServerEsecuteRequest(FXMLDocumentController.GLOBAL_IP, FXMLDocumentController.GLOBAL_PORT, "dbInteraction#@" + str);
                        if (!this.data_select.contains("#ERR:")) {
                            this.refreshLista(false);
                            this.editText_capacita.setText("");
                            this.editText_codicevaso.setText("");
                            this.editText_descrizione.setText("");
                            this.editText_capacita.setEditable(true);
                            this.editText_codicevaso.setEditable(true);
                            this.cmbx_tipovaso.getSelectionModel().selectFirst();
                            this.id_selected = 0;
                            FXMLDocumentController.toast.startToast("Vaso Vinario cancellato", "SUCCESSO", "SUCCESSO");
                        }
                    }
                } else {
                    FXMLDocumentController.util.alertWindow(Alert.AlertType.ERROR, "ERRORE", "", "Vaso con giacenza, impossibile cancellare.");
                }
            } else {
                FXMLDocumentController.util.alertWindow(Alert.AlertType.ERROR, "ERRORE", "", this.data_select);
            }
        }
    }

    @FXML
    public void btnNuovo() throws JSONException {
        this.resetta();
    }

    private void resetta() {
        this.editText_capacita.setText("");
        this.editText_codicevaso.setText("");
        this.editText_descrizione.setText("");
        this.editText_capacita.setEditable(true);
        this.editText_codicevaso.setEditable(true);
        this.cmbx_tipovaso.getSelectionModel().selectFirst();
        this.flag_modifica = false;
        this.chk_gruppo.setSelected(false);
        this.chk_gruppo.setDisable(false);
        this.id_selected = 0;
    }

    @FXML
    public void btnModifica() throws JSONException {
        int selected = ((ColumnTableGridVasiVinari)this.table_vaso.getSelectionModel().getSelectedItem()).getColumn_id();
        if (selected <= 0) {
            FXMLDocumentController.toast.startToast("Selezionare prima un vaso vinario.", "INFORMAZIONE", "INFORMAZIONE");
        } else {
            JSONObject recs;
            int ie;
            JSONArray arrayJsons;
            this.flag_modifica = true;
            this.chk_gruppo.setDisable(true);
            this.id_selected = ((ColumnTableGridVasiVinari)this.table_vaso.getSelectionModel().getSelectedItem()).getColumn_id();
            if (((ColumnTableGridVasiVinari)this.table_vaso.getSelectionModel().getSelectedItem()).getColumn_giacenzainiziale() > 0.0) {
                this.editText_codicevaso.setEditable(false);
            } else {
                this.editText_codicevaso.setEditable(true);
            }
            this.editText_capacita.setText(((ColumnTableGridVasiVinari)this.table_vaso.getSelectionModel().getSelectedItem()).getColumn_capacita() + "");
            this.editText_codicevaso.setText(((ColumnTableGridVasiVinari)this.table_vaso.getSelectionModel().getSelectedItem()).getColumn_codicevaso());
            this.editText_descrizione.setText(((ColumnTableGridVasiVinari)this.table_vaso.getSelectionModel().getSelectedItem()).getColumn_descrizione());
            String t = ((ColumnTableGridVasiVinari)this.table_vaso.getSelectionModel().getSelectedItem()).getColumn_tipovaso();
            ArrayList<String> tipo = new ArrayList<String>();
            ArrayList<String> strSQL = new ArrayList<String>();
            ArrayList<Boolean> last_ID = new ArrayList<Boolean>();
            tipo.add("select");
            strSQL.add("SELECT codice,descrizione FROM sian_t_tipo_vaso WHERE descrizione='" + t + "'");
            last_ID.add(false);
            String str = FXMLDocumentController.util.makeStringJsonDB("OFF", tipo, strSQL, null, null, last_ID, null);
            this.data_select = FXMLDocumentController.sk1Comm.ServerEsecuteRequest(FXMLDocumentController.GLOBAL_IP, FXMLDocumentController.GLOBAL_PORT, "dbInteraction#@" + str);
            if (!this.data_select.contains("#ERR:")) {
                arrayJsons = FXMLDocumentController.jsonUtil.strJsonToJSONArray(this.data_select);
                for (ie = 0; ie < arrayJsons.length(); ++ie) {
                    try {
                        recs = arrayJsons.getJSONObject(ie);
                        this.cmbx_tipovaso.getSelectionModel().select((Object)new CodiceDescrizione(recs.getString("codice"), recs.getString("descrizione")));
                        continue;
                    }
                    catch (JSONException ex) {
                        FXMLDocumentController.util.alertWindow(Alert.AlertType.ERROR, "ERRORE", "", ex.toString());
                    }
                }
            }
            tipo = new ArrayList();
            strSQL = new ArrayList();
            last_ID = new ArrayList();
            tipo.add("select");
            strSQL.add("SELECT IFNULL(flg_no_invio_sian,0) AS flg_no_invio_sian,IFNULL(flg_gruppo,0) AS flg_gruppo FROM gen_vasi_vinari_ana WHERE id=" + this.id_selected);
            last_ID.add(false);
            str = FXMLDocumentController.util.makeStringJsonDB("OFF", tipo, strSQL, null, null, last_ID, null);
            this.data_select = FXMLDocumentController.sk1Comm.ServerEsecuteRequest(FXMLDocumentController.GLOBAL_IP, FXMLDocumentController.GLOBAL_PORT, "dbInteraction#@" + str);
            if (!this.data_select.contains("#ERR:")) {
                arrayJsons = FXMLDocumentController.jsonUtil.strJsonToJSONArray(this.data_select);
                for (ie = 0; ie < arrayJsons.length(); ++ie) {
                    recs = arrayJsons.getJSONObject(ie);
                    int id_no_sian = recs.getInt("flg_no_invio_sian");
                    int gruppo = recs.getInt("flg_gruppo");
                    if (gruppo == 1) {
                        this.chk_gruppo.setSelected(true);
                        continue;
                    }
                    this.chk_gruppo.setSelected(false);
                }
            } else {
                FXMLDocumentController.util.alertWindow(Alert.AlertType.ERROR, "ERRORE", "", this.data_select);
            }
        }
    }

    @FXML
    public void btnDuplica() throws JSONException {
        int id_remove = this.table_vaso.getSelectionModel().getSelectedIndex();
        if (id_remove != -1) {
            this.flag_modifica = false;
            this.id_selected = ((ColumnTableGridVasiVinari)this.table_vaso.getSelectionModel().getSelectedItem()).getColumn_id();
            this.editText_capacita.setEditable(true);
            this.editText_codicevaso.setEditable(true);
            this.editText_capacita.setText(((ColumnTableGridVasiVinari)this.table_vaso.getSelectionModel().getSelectedItem()).getColumn_capacita() + "");
            this.editText_codicevaso.setText(((ColumnTableGridVasiVinari)this.table_vaso.getSelectionModel().getSelectedItem()).getColumn_codicevaso());
            this.editText_descrizione.setText(((ColumnTableGridVasiVinari)this.table_vaso.getSelectionModel().getSelectedItem()).getColumn_descrizione());
            String t = ((ColumnTableGridVasiVinari)this.table_vaso.getSelectionModel().getSelectedItem()).getColumn_tipovaso();
            ArrayList<String> tipo = new ArrayList<String>();
            ArrayList<String> strSQL = new ArrayList<String>();
            ArrayList<Boolean> last_ID = new ArrayList<Boolean>();
            tipo.add("select");
            strSQL.add("SELECT codice,descrizione FROM sian_t_tipo_vaso WHERE descrizione='" + t + "'");
            last_ID.add(false);
            String str = FXMLDocumentController.util.makeStringJsonDB("OFF", tipo, strSQL, null, null, last_ID, null);
            this.data_select = FXMLDocumentController.sk1Comm.ServerEsecuteRequest(FXMLDocumentController.GLOBAL_IP, FXMLDocumentController.GLOBAL_PORT, "dbInteraction#@" + str);
            if (!this.data_select.contains("#ERR:")) {
                JSONArray arrayJsons = FXMLDocumentController.jsonUtil.strJsonToJSONArray(this.data_select);
                for (int ie = 0; ie < arrayJsons.length(); ++ie) {
                    try {
                        JSONObject recs = arrayJsons.getJSONObject(ie);
                        this.cmbx_tipovaso.getSelectionModel().select((Object)new CodiceDescrizione(recs.getString("codice"), recs.getString("descrizione")));
                        continue;
                    }
                    catch (JSONException ex) {
                        FXMLDocumentController.util.alertWindow(Alert.AlertType.ERROR, "ERRORE", "", ex.toString());
                    }
                }
            }
            this.chk_gruppo.setSelected(false);
        }
    }

    @FXML
    public void btnSalva() throws JSONException, IOException, FileNotFoundException, URISyntaxException {
        String capacita = this.editText_capacita.getText().trim();
        String codicevaso = this.editText_codicevaso.getText().trim().toUpperCase();
        String descrizione = this.editText_descrizione.getText().trim();
        int no_invio_sian = 0;
        int gruppo = 0;
        if (this.chk_gruppo.isSelected()) {
            gruppo = 1;
        }
        CodiceDescrizione obs = (CodiceDescrizione)this.cmbx_tipovaso.getSelectionModel().getSelectedItem();
        String tipovaso = "";
        if (obs != null) {
            tipovaso = obs.getCodice();
        }
        if (!capacita.equals("")) {
            if (!codicevaso.equals("")) {
                if (!tipovaso.equals("")) {
                    if (!descrizione.equals("")) {
                        if (!this.flag_modifica) {
                            ArrayList<String> tipo = new ArrayList<String>();
                            ArrayList<String> strSQL = new ArrayList<String>();
                            ArrayList<Boolean> last_ID = new ArrayList<Boolean>();
                            last_ID.add(false);
                            tipo.add("select");
                            int count = 0;
                            strSQL.add("SELECT COUNT(id) AS count FROM gen_vasi_vinari_ana WHERE codice_vaso='" + codicevaso + "' AND azienda='" + FXMLDocumentController.GLOBAL_AZIENDA + "' AND sotto_az='" + FXMLDocumentController.GLOBAL_SOTTOAZZ + "' AND icqrf='" + FXMLDocumentController.GLOBAL_ICQRF + "' ORDER BY id DESC ");
                            String str = FXMLDocumentController.util.makeStringJsonDB("ON", tipo, strSQL, null, null, last_ID, null);
                            this.data_select = FXMLDocumentController.sk1Comm.ServerEsecuteRequest(FXMLDocumentController.GLOBAL_IP, FXMLDocumentController.GLOBAL_PORT, "dbInteraction#@" + str);
                            if (!this.data_select.contains("#ERR:")) {
                                JSONArray arrayJsons = FXMLDocumentController.jsonUtil.strJsonToJSONArray(this.data_select);
                                for (int ie = 0; ie < arrayJsons.length(); ++ie) {
                                    try {
                                        JSONObject recs = arrayJsons.getJSONObject(ie);
                                        count = recs.getInt("count");
                                        continue;
                                    }
                                    catch (JSONException ex) {
                                        FXMLDocumentController.util.alertWindow(Alert.AlertType.ERROR, "ERRORE", "", ex.toString());
                                    }
                                }
                                if (count <= 0) {
                                    tipo = new ArrayList();
                                    strSQL = new ArrayList();
                                    String[][] tipo_ins = new String[1][10];
                                    String[][] valore = new String[1][10];
                                    last_ID = new ArrayList();
                                    ArrayList<Integer> lenghtBidimensionalArray = new ArrayList<Integer>();
                                    lenghtBidimensionalArray.add(10);
                                    last_ID.add(false);
                                    tipo_ins[0][0] = "string";
                                    tipo_ins[0][1] = "string";
                                    tipo_ins[0][2] = "string";
                                    tipo_ins[0][3] = "string";
                                    tipo_ins[0][4] = "string";
                                    tipo_ins[0][5] = "double";
                                    tipo_ins[0][6] = "string";
                                    tipo_ins[0][7] = "string";
                                    tipo_ins[0][8] = "int";
                                    tipo_ins[0][9] = "int";
                                    valore[0][0] = FXMLDocumentController.GLOBAL_AZIENDA;
                                    valore[0][1] = FXMLDocumentController.GLOBAL_SOTTOAZZ;
                                    valore[0][2] = codicevaso;
                                    valore[0][3] = tipovaso;
                                    valore[0][4] = descrizione;
                                    valore[0][5] = capacita;
                                    valore[0][6] = FXMLDocumentController.GLOBAL_ICQRF;
                                    valore[0][7] = FXMLDocumentController.GLOBAL_CODCOMM;
                                    valore[0][8] = no_invio_sian + "";
                                    valore[0][9] = gruppo + "";
                                    tipo.add("insert");
                                    strSQL.add("INSERT INTO gen_vasi_vinari_ana (azienda,sotto_az,codice_vaso,tipo_vaso,descr_vaso,capacita,icqrf,cod_committente,flg_no_invio_sian,flg_gruppo)VALUES(?,?,?,?,?,?,?,?,?,?)");
                                    str = FXMLDocumentController.util.makeStringJsonDB("ON", tipo, strSQL, tipo_ins, valore, last_ID, lenghtBidimensionalArray);
                                    this.data_select = FXMLDocumentController.sk1Comm.ServerEsecuteRequest(FXMLDocumentController.GLOBAL_IP, FXMLDocumentController.GLOBAL_PORT, "dbInteraction#@" + str);
                                    if (!this.data_select.contains("#ERR:")) {
                                        this.resetta();
                                        this.refreshLista(false);
                                        FXMLDocumentController.toast.startToast("Vaso Vinario inserito", "SUCCESSO", "SUCCESSO");
                                    } else {
                                        FXMLDocumentController.util.alertWindow(Alert.AlertType.ERROR, "ERRORE", "", "ATTENZIONE!\n" + this.data_select);
                                    }
                                } else {
                                    FXMLDocumentController.toast.startToast("Codice Vaso gi\u00e0 inserito.", "ERRORE", "ERRORE");
                                }
                            } else {
                                FXMLDocumentController.util.alertWindow(Alert.AlertType.ERROR, "ERRORE", "", "ATTENZIONE!\n" + this.data_select);
                            }
                        } else {
                            HashMap lis = FXMLDocumentController.util.getParameters();
                            boolean GESTIONE_VASCHE = (Boolean)lis.get("GESTIONE_VASCHE");
                            ArrayList<String> tipo = new ArrayList<String>();
                            ArrayList<String> strSQL = new ArrayList<String>();
                            ArrayList<Boolean> last_ID = new ArrayList<Boolean>();
                            if (GESTIONE_VASCHE) {
                                JSONArray array = FXMLDocumentController.ricerca.giacenzaVasi("", " WHERE id=" + this.id_selected + "  GROUP BY id ", true);
                                double giacenza = 0.0;
                                for (int j = 0; j < array.length(); ++j) {
                                    JSONObject recde = array.getJSONObject(j);
                                    int id_p = recde.getInt("id");
                                    double ert = recde.getDouble("giacenza") / 100.0;
                                    giacenza = FXMLDocumentController.util.MyMathRound(ert, 3);
                                }
                                if (giacenza > Double.parseDouble(capacita)) {
                                    FXMLDocumentController.toast.startToast("Fare prima delle operazioni di \n svuotamento per ridurre la capacit\u00e0 del vaso.", "ERRORE", "ERRORE");
                                    return;
                                }
                                boolean res = false;
                                tipo.add("select");
                                strSQL.add("SELECT IF(a.invio_sian_data='0000-00-00',null,a.invio_sian_data) AS invio_sian_data FROM c_operazioni AS a LEFT JOIN c_movimenti AS b ON a.id=b.id_oper LEFT JOIN gen_vasi_vinari_mov AS f ON b.id=f.id_mov WHERE f.id_vaso=" + this.id_selected + " AND a.cod_oper<>'TR' AND a.cod_oper<>'AZZERAMENTO'  ");
                                last_ID.add(false);
                                String str = FXMLDocumentController.util.makeStringJsonDB("OFF", tipo, strSQL, null, null, last_ID, null);
                                this.data_select = FXMLDocumentController.sk1Comm.ServerEsecuteRequest(FXMLDocumentController.GLOBAL_IP, FXMLDocumentController.GLOBAL_PORT, "dbInteraction#@" + str);
                                if (!this.data_select.contains("#ERR:")) {
                                    JSONArray arrayJsofn = FXMLDocumentController.jsonUtil.strJsonToJSONArray(this.data_select);
                                    for (int i = 0; i < arrayJsofn.length(); ++i) {
                                        JSONObject obg = arrayJsofn.getJSONObject(i);
                                        String ret = obg.getString("invio_sian_data").replace("null", "");
                                        if (!ret.equals("")) continue;
                                        res = true;
                                    }
                                } else {
                                    FXMLDocumentController.util.alertWindow(Alert.AlertType.ERROR, "ERRORE", "", "ATTENZIONE!\n" + this.data_select);
                                    return;
                                }
                                if (res) {
                                    FXMLDocumentController.toast.startToast("Inviare prima al SIAN tutte le relative\n operazioni per questo vaso.", "ERRORE", "ERRORE");
                                    return;
                                }
                            }
                            tipo = new ArrayList();
                            strSQL = new ArrayList();
                            last_ID = new ArrayList();
                            tipo.add("update");
                            strSQL.add("UPDATE gen_vasi_vinari_ana SET tipo_vaso='" + tipovaso + "',descr_vaso='" + descrizione + "',capacita=" + capacita + "  WHERE id=" + this.id_selected + " AND azienda='" + FXMLDocumentController.GLOBAL_AZIENDA + "' AND sotto_az='" + FXMLDocumentController.GLOBAL_SOTTOAZZ + "' AND ICQRF='" + FXMLDocumentController.GLOBAL_ICQRF + "' AND cod_committente='" + FXMLDocumentController.GLOBAL_CODCOMM + "' ");
                            last_ID.add(false);
                            String str = FXMLDocumentController.util.makeStringJsonDB("OFF", tipo, strSQL, null, null, last_ID, null);
                            this.data_select = FXMLDocumentController.sk1Comm.ServerEsecuteRequest(FXMLDocumentController.GLOBAL_IP, FXMLDocumentController.GLOBAL_PORT, "dbInteraction#@" + str);
                            if (!this.data_select.contains("#ERR:")) {
                                this.refreshLista(false);
                                this.resetta();
                                FXMLDocumentController.toast.startToast("Salvataggio avvenuto con successo.", "SUCCESSO", "SUCCESSO");
                            } else {
                                FXMLDocumentController.util.alertWindow(Alert.AlertType.ERROR, "ERRORE", "", "ATTENZIONE!\n" + this.data_select);
                            }
                        }
                    } else {
                        FXMLDocumentController.util.alertWindow(Alert.AlertType.ERROR, "ERRORE", "", "Campo Descizione obbligatorio");
                    }
                } else {
                    FXMLDocumentController.util.alertWindow(Alert.AlertType.ERROR, "ERRORE", "", "Campo Tipo Vaso obbligatorio");
                }
            } else {
                FXMLDocumentController.util.alertWindow(Alert.AlertType.ERROR, "ERRORE", "", "Campo Codice Vaso obbligatorio");
            }
        } else {
            FXMLDocumentController.util.alertWindow(Alert.AlertType.ERROR, "ERRORE", "", "Campo Capacit\u00e0 Vaso obbligatorio");
        }
    }

    private void refreshListaRaggruppata() throws JSONException {
        this.wd = new WorkIndicatorDialog(this.table_vaso.getScene().getWindow(), "Caricamento in corso...");
        this.wd.addTaskEndNotification(result -> {
            try {
                this.wd = null;
            }
            catch (Exception ex) {
                Logger.getLogger(AnagGeneraSoggettiT.class.getName()).log(Level.SEVERE, null, ex);
            }
        });
        this.wd.exec("123", inputParam -> {
            try {
                List<String> vasitest = this.getCodiciSIAN("TEST");
                List<String> vasireale = this.getCodiciSIAN("REALE");
                ArrayList<String> tipo = new ArrayList<String>();
                ArrayList<String> strSQL = new ArrayList<String>();
                ArrayList<Boolean> last_ID = new ArrayList<Boolean>();
                tipo.add("select");
                strSQL.add("SELECT * FROM (SELECT  cancellato_reale,icqrf, cod_committente, azienda, sotto_az, id, codice_vaso, descr_vaso, tipo_vaso, capacita, cod_tipo_vino, giacenza FROM ( SELECT  a.cancellato_reale,a.icqrf AS icqrf, b.cod_committente AS cod_committente, a.azienda AS azienda, a.sotto_az AS sotto_az, a.id AS id, a.codice_vaso AS codice_vaso, a.descr_vaso AS descr_vaso, d.DESCRIZIONE AS tipo_vaso, a.capacita AS capacita, c.codice AS cod_tipo_vino, SUM(b.qta_mov) AS giacenza FROM gen_vasi_vinari_ana AS a LEFT JOIN gen_vasi_vinari_mov AS b ON a.id = b.id_vaso AND a.azienda = b.azienda AND a.sotto_az = b.sotto_az AND a.icqrf = b.icqrf LEFT JOIN gen_tipo_vino_ana AS c ON b.cod_tipo_vino = c.codice AND b.azienda = c.azienda AND b.sotto_az = c.sotto_az AND b.icqrf = c.icqrf AND b.cod_committente = c.cod_committente LEFT JOIN sian_t_tipo_vaso AS d ON a.tipo_vaso = d.CODICE  WHERE  a.codice_vaso<>'@VASOWBS@' AND b.azienda='" + FXMLDocumentController.GLOBAL_AZIENDA + "' AND b.sotto_az='" + FXMLDocumentController.GLOBAL_SOTTOAZZ + "' AND b.icqrf='" + FXMLDocumentController.GLOBAL_ICQRF + "' AND b.cod_committente='" + FXMLDocumentController.GLOBAL_CODCOMM + "' GROUP BY a.codice_vaso, c.codice ORDER BY a.codice_vaso ) AS a WHERE GIACENZA <> 0 OR ID NOT IN (SELECT id FROM ( SELECT  a.cancellato_reale,a.icqrf AS icqrf, b.cod_committente AS cod_committente, a.azienda AS azienda, a.sotto_az AS sotto_az, a.id AS id, a.codice_vaso AS codice_vaso, a.descr_vaso AS descr_vaso, d.DESCRIZIONE AS tipo_vaso, a.capacita AS capacita, c.codice AS cod_tipo_vino, SUM(b.qta_mov) AS giacenza FROM gen_vasi_vinari_ana AS a LEFT JOIN gen_vasi_vinari_mov AS b ON a.id = b.id_vaso AND a.azienda = b.azienda AND a.sotto_az = b.sotto_az AND a.icqrf = b.icqrf LEFT JOIN gen_tipo_vino_ana AS c ON b.cod_tipo_vino = c.codice AND b.azienda = c.azienda AND b.sotto_az = c.sotto_az AND b.icqrf = c.icqrf AND b.cod_committente = c.cod_committente LEFT JOIN sian_t_tipo_vaso AS d ON a.tipo_vaso = d.CODICE  WHERE  a.codice_vaso<>'@VASOWBS@' AND b.azienda='" + FXMLDocumentController.GLOBAL_AZIENDA + "' AND b.sotto_az='" + FXMLDocumentController.GLOBAL_SOTTOAZZ + "' AND b.icqrf='" + FXMLDocumentController.GLOBAL_ICQRF + "' AND b.cod_committente='" + FXMLDocumentController.GLOBAL_CODCOMM + "' GROUP BY a.codice_vaso, c.codice ORDER BY a.codice_vaso ) AS a WHERE GIACENZA <> 0)   UNION SELECT * FROM ( SELECT  a.cancellato_reale,a.icqrf AS icqrf, b.cod_committente AS cod_committente, a.azienda AS azienda, a.sotto_az AS sotto_az, a.id AS id, a.codice_vaso AS codice_vaso, a.descr_vaso AS descr_vaso, d.DESCRIZIONE AS tipo_vaso, a.capacita AS capacita, c.codice AS cod_tipo_vino, SUM(IFNULL(b.qta_mov,0)) AS giacenza FROM gen_vasi_vinari_ana AS a LEFT JOIN gen_vasi_vinari_mov AS b ON a.id = b.id_vaso AND a.azienda = b.azienda AND a.sotto_az = b.sotto_az AND a.icqrf = b.icqrf LEFT JOIN gen_tipo_vino_ana AS c ON b.cod_tipo_vino = c.codice AND a.azienda = c.azienda AND a.sotto_az = c.sotto_az AND a.icqrf = c.icqrf AND a.cod_committente = c.cod_committente LEFT JOIN sian_t_tipo_vaso AS d ON a.tipo_vaso = d.CODICE LEFT JOIN c_movimenti AS e ON b.id_mov = e.id WHERE  a.codice_vaso<>'@VASOWBS@' AND a.azienda='" + FXMLDocumentController.GLOBAL_AZIENDA + "' AND a.sotto_az='" + FXMLDocumentController.GLOBAL_SOTTOAZZ + "' AND a.icqrf='" + FXMLDocumentController.GLOBAL_ICQRF + "' GROUP BY c.codice, a.codice_vaso ORDER BY a.codice_vaso ) AS b WHERE b.ID NOT IN ( SELECT id_vaso FROM gen_vasi_vinari_mov ) ) AS a WHERE a.cancellato_reale='' OR a.cancellato_reale='false' OR ISNULL(a.cancellato_reale) GROUP BY a.codice_vaso ");
                last_ID.add(false);
                String str = FXMLDocumentController.util.makeStringJsonDB("OFF", tipo, strSQL, null, null, last_ID, null);
                this.data_select = FXMLDocumentController.sk1Comm.ServerEsecuteRequest(FXMLDocumentController.GLOBAL_IP, FXMLDocumentController.GLOBAL_PORT, "dbInteraction#@" + str);
                if (!this.data_select.contains("#ERR:")) {
                    this.lista_tablegridvaso.clear();
                    JSONArray arrayJson = FXMLDocumentController.jsonUtil.strJsonToJSONArray(this.data_select);
                    for (int i = 0; i < arrayJson.length(); ++i) {
                        try {
                            JSONObject rec = arrayJson.getJSONObject(i);
                            String tipov = rec.getString("tipo_vaso");
                            Double giainizi = rec.getDouble("giacenza");
                            giainizi = giainizi == null ? Double.valueOf(0.0) : Double.valueOf(FXMLDocumentController.util.MyMathRound(giainizi, 3));
                            String cod_vino = rec.getString("cod_tipo_vino");
                            if (cod_vino.equals("null")) {
                                cod_vino = "";
                            }
                            boolean realevaso = false;
                            for (int j = 0; j < vasireale.size(); ++j) {
                                if (!vasireale.equals(rec.getString("codice_vaso"))) continue;
                                realevaso = true;
                            }
                            boolean testvaso = false;
                            for (int j = 0; j < vasitest.size(); ++j) {
                                if (!vasitest.equals(rec.getString("codice_vaso"))) continue;
                                testvaso = true;
                            }
                            this.lista_tablegridvaso.add((Object)new ColumnTableGridVasiVinari(rec.getInt("id"), rec.getString("codice_vaso"), tipov, rec.getString("descr_vaso"), rec.getDouble("capacita"), giainizi, cod_vino, 0.0, false, "", "", "", "", false, false, testvaso, realevaso));
                            continue;
                        }
                        catch (JSONException ex) {
                            FXMLDocumentController.util.alertWindow(Alert.AlertType.ERROR, "ERRORE", "", ex.toString());
                        }
                    }
                }
            }
            catch (Exception ex) {
                Logger.getLogger(StampaMovimentiController.class.getName()).log(Level.SEVERE, null, ex);
            }
            return 1;
        });
    }

    private List<String> getCodiciSIAN(String tipo) throws JSONException {
        ArrayList<String> listas = new ArrayList<String>();
        String data_select = "";
        data_select = tipo.toLowerCase().contains("test") ? FXMLDocumentController.sk1Comm.ServerEsecuteRequest(FXMLDocumentController.GLOBAL_IP, FXMLDocumentController.GLOBAL_PORT, "TESTVisVasiSiRPV#@" + FXMLDocumentController.GLOBAL_AZIENDA + "#@" + FXMLDocumentController.GLOBAL_SOTTOAZZ + "#@" + FXMLDocumentController.GLOBAL_ICQRF + "#@") : FXMLDocumentController.sk1Comm.ServerEsecuteRequest(FXMLDocumentController.GLOBAL_IP, FXMLDocumentController.GLOBAL_PORT, "VisVasiSiRPV#@" + FXMLDocumentController.GLOBAL_AZIENDA + "#@" + FXMLDocumentController.GLOBAL_SOTTOAZZ + "#@" + FXMLDocumentController.GLOBAL_ICQRF + "#@");
        if (!data_select.contains("#ERR:")) {
            JSONObject rec = new JSONObject(data_select);
            String codice = rec.get("codice").toString();
            String messaggio = rec.get("messaggio").toString();
            JSONArray lista = rec.getJSONArray("lista");
            if (lista != null) {
                boolean ch = false;
                for (int j = 0; j < lista.length(); ++j) {
                    JSONObject obj = lista.getJSONObject(j);
                    String codiceSogg = obj.getString("codice");
                    listas.add(codiceSogg);
                }
            }
        }
        return listas;
    }

    private String selectReportVasiVinari() {
        String res = "";
        String r = "";
        res = "SELECT  a.id, a.codice_vaso, descr_vaso,tipo_vaso, '' AS cod_tipo_vino, '' AS DESCR_VINO,\n'' AS PROTOCOLLO, '' AS ENTE, '' AS DATA, \n0 AS GIACENZA, IFNULL(a.cod_committente,'') AS COMMI , IFNULL(CONCAT(IFNULL(b.commit_nome,''), ' ', IFNULL(b.commit_cognome,'')),'') AS NOME, \n IFNULL(b.commit_rag_soc,'') AS RAG_SOC,a.capacita \n FROM gen_vasi_vinari_ana AS a \n LEFT JOIN gen_t_icqrf_mxmag AS b ON a.icqrf = b.icqrf AND a.cod_committente = b.cod_committente \nWHERE a.azienda='" + FXMLDocumentController.GLOBAL_AZIENDA + "' AND a.sotto_az='" + FXMLDocumentController.GLOBAL_SOTTOAZZ + "' AND a.icqrf='" + FXMLDocumentController.GLOBAL_ICQRF + "'  AND a.codice_vaso<>'@VASOWBS@' ORDER BY  IFNULL(a.codice_vaso,'')  ";
        return res;
    }

    private void refreshLista(boolean SIAN) throws JSONException {
        this.wd = new WorkIndicatorDialog(this.table_vaso.getScene().getWindow(), "Caricamento in corso...");
        this.wd.addTaskEndNotification(result -> {
            if (this.wd.labelWord != null && !this.wd.labelWord.equals("")) {
                FXMLDocumentController.toast.startToast(this.wd.labelWord, "ERRORE", "ERRORE");
            }
            this.wd = null;
            this.table_vaso.refresh();
        });
        this.wd.exec("123", inputParam -> {
            try {
                List<Object> vasitest = new ArrayList();
                List<Object> vasireale = new ArrayList();
                ArrayList<String> tipo = new ArrayList<String>();
                ArrayList<String> strSQL = new ArrayList<String>();
                ArrayList<Boolean> last_ID = new ArrayList<Boolean>();
                if (SIAN) {
                    vasitest = this.getCodiciSIAN("TEST");
                    vasireale = this.getCodiciSIAN("REALE");
                }
                tipo.add("selectRS");
                strSQL.add(this.selectReportVasiVinari());
                last_ID.add(false);
                String str = FXMLDocumentController.util.makeStringJsonDB("OFF", tipo, strSQL, null, null, last_ID, null);
                this.data_select = FXMLDocumentController.sk1Comm.ServerEsecuteRequest(FXMLDocumentController.GLOBAL_IP, FXMLDocumentController.GLOBAL_PORT, "dbInteraction#@" + str);
                if (!this.data_select.contains("#ERR:")) {
                    this.lista_tablegridvaso.clear();
                    JSONArray arrayJson = FXMLDocumentController.jsonUtil.strJsonToJSONArray(this.data_select);
                    for (int i = 0; i < arrayJson.length(); ++i) {
                        try {
                            JSONObject rec = arrayJson.getJSONObject(i);
                            String tipov = rec.getString("tipo_vaso");
                            Double giainizi = rec.getDouble("giacenza");
                            giainizi = giainizi == null ? Double.valueOf(0.0) : Double.valueOf(FXMLDocumentController.util.MyMathRound(giainizi, 3));
                            String cod_vino = rec.getString("cod_tipo_vino");
                            if (cod_vino.equals("null")) {
                                cod_vino = "";
                            }
                            boolean realevaso = false;
                            for (int j = 0; j < vasireale.size(); ++j) {
                                if (!vasireale.equals(rec.getString("codice_vaso"))) continue;
                                realevaso = true;
                            }
                            boolean testvaso = false;
                            for (int j = 0; j < vasitest.size(); ++j) {
                                if (!vasitest.equals(rec.getString("codice_vaso"))) continue;
                                testvaso = true;
                            }
                            this.lista_tablegridvaso.add((Object)new ColumnTableGridVasiVinari(rec.getInt("id"), rec.getString("codice_vaso"), tipov, rec.getString("descr_vaso"), rec.getDouble("capacita"), giainizi, cod_vino, 0.0, false, "", "", "", "", false, false, testvaso, realevaso));
                            continue;
                        }
                        catch (JSONException ex) {
                            FXMLDocumentController.util.alertWindow(Alert.AlertType.ERROR, "ERRORE", "", ex.toString());
                        }
                    }
                }
            }
            catch (Exception ex) {
                this.wd.labelWord = ex.getMessage();
            }
            return 1;
        });
    }
}

