/*
 * Decompiled with CFR 0.152.
 */
package vin.controller;

import com.jfoenix.controls.JFXTextField;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.ResourceBundle;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.collections.transformation.FilteredList;
import javafx.collections.transformation.SortedList;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.control.Alert;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.TextField;
import javafx.scene.control.cell.PropertyValueFactory;
import javafx.util.Callback;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import vin.Class.CodiceEnteCertificatore;
import vin.Uility.JasperReport;
import vin.controller.FXMLDocumentController;

public class AnagEnteCertificatoreController
implements Initializable {
    @FXML
    private JFXTextField editText_ricerca;
    String data_select = "";
    JasperReport jasperReport = new JasperReport();
    ObservableList<CodiceEnteCertificatore> lista = FXCollections.observableArrayList();
    @FXML
    private TextField editText_descrizione;
    @FXML
    private TableView<CodiceEnteCertificatore> table;
    @FXML
    private TableColumn<CodiceEnteCertificatore, Integer> column_id;
    @FXML
    private TableColumn<CodiceEnteCertificatore, String> column_descrizione;
    int id_memory = 0;
    FilteredList<CodiceEnteCertificatore> filteredData = null;
    boolean flag_modifica = false;

    public void initialize(URL url, ResourceBundle rb) {
        try {
            this.column_id.setCellValueFactory((Callback)new PropertyValueFactory("column_id"));
            this.column_descrizione.setCellValueFactory((Callback)new PropertyValueFactory("column_descrizione"));
            this.filteredData = new FilteredList(this.lista, p -> true);
            this.editText_ricerca.textProperty().addListener((observable, oldValue, newValue) -> this.filteredData.setPredicate(person -> {
                if (newValue == null || newValue.isEmpty()) {
                    return true;
                }
                String lowerCaseFilter = newValue.toLowerCase();
                return person.getColumn_descrizione().toLowerCase().contains(lowerCaseFilter);
            }));
            SortedList sortedData = new SortedList(this.filteredData);
            sortedData.comparatorProperty().bind((ObservableValue)this.table.comparatorProperty());
            this.table.setItems((ObservableList)sortedData);
            this.refreshLista();
        }
        catch (Exception ex) {
            FXMLDocumentController.util.alertWindow(Alert.AlertType.ERROR, "ERRORE", "", ex.toString());
        }
    }

    @FXML
    public void btnElimina() throws JSONException {
        int rr = ((CodiceEnteCertificatore)((Object)this.table.getSelectionModel().getSelectedItem())).getColumn_id();
        if (rr <= 0) {
            FXMLDocumentController.toast.startToast("Selezionare prima una riga.", "INFORMAZIONE", "INFORMAZIONE");
        } else {
            ArrayList<String> tipo = new ArrayList<String>();
            ArrayList<String> strSQL = new ArrayList<String>();
            ArrayList<Boolean> last_ID = new ArrayList<Boolean>();
            tipo.add("delete");
            strSQL.add("DELETE  FROM ente_certificatore WHERE id=" + rr);
            last_ID.add(false);
            Double giainizi = 0.0;
            String str = FXMLDocumentController.util.makeStringJsonDB("ON", tipo, strSQL, null, null, last_ID, null);
            this.data_select = FXMLDocumentController.sk1Comm.ServerEsecuteRequest(FXMLDocumentController.GLOBAL_IP, FXMLDocumentController.GLOBAL_PORT, "dbInteraction#@" + str);
            if (!this.data_select.contains("#ERR:")) {
                this.refreshLista();
                this.editText_descrizione.setText("");
                this.flag_modifica = false;
                this.id_memory = 0;
            } else {
                FXMLDocumentController.util.alertWindow(Alert.AlertType.ERROR, "ERRORE", "", this.data_select);
            }
        }
    }

    @FXML
    public void btnResetta() throws JSONException {
        this.editText_descrizione.setText("");
        this.flag_modifica = false;
        this.id_memory = 0;
    }

    @FXML
    public void btnModifica() throws JSONException {
        int rr = ((CodiceEnteCertificatore)((Object)this.table.getSelectionModel().getSelectedItem())).getColumn_id();
        if (rr <= 0) {
            FXMLDocumentController.toast.startToast("Selezionare prima un vaso vinario.", "INFORMAZIONE", "INFORMAZIONE");
        } else {
            this.flag_modifica = true;
            this.id_memory = rr;
            this.editText_descrizione.setText(((CodiceEnteCertificatore)((Object)this.table.getSelectionModel().getSelectedItem())).getColumn_descrizione());
        }
    }

    @FXML
    public void btnSalva() throws JSONException, IOException, FileNotFoundException, URISyntaxException {
        ArrayList<String> tipoSQL = new ArrayList<String>();
        ArrayList<String> strSQL = new ArrayList<String>();
        ArrayList<Boolean> last_ID = new ArrayList<Boolean>();
        String descrizione = this.editText_descrizione.getText().trim();
        if (!this.flag_modifica && !descrizione.equals("")) {
            tipoSQL = new ArrayList();
            strSQL = new ArrayList();
            String[][] tipo_ins = new String[1][10];
            String[][] valore = new String[1][10];
            last_ID = new ArrayList();
            ArrayList<Integer> lenghtBidimensionalArray = new ArrayList<Integer>();
            FXMLDocumentController.sqlUtil.insert_ente_certificatore(FXMLDocumentController.GLOBAL_AZIENDA, FXMLDocumentController.GLOBAL_SOTTOAZZ, descrizione);
            strSQL.addAll(FXMLDocumentController.sqlUtil.strSQL);
            tipoSQL.addAll(FXMLDocumentController.sqlUtil.tipoinsSQL);
            lenghtBidimensionalArray.addAll(FXMLDocumentController.sqlUtil.lengthSQL);
            last_ID.addAll(FXMLDocumentController.sqlUtil.lastID);
            tipo_ins[0] = FXMLDocumentController.sqlUtil.tipovaloreSQL.toArray(new String[0]);
            valore[0] = FXMLDocumentController.sqlUtil.valoreSQL.toArray(new String[0]);
            String str = FXMLDocumentController.util.makeStringJsonDB("ON", tipoSQL, strSQL, tipo_ins, valore, last_ID, lenghtBidimensionalArray);
            this.data_select = FXMLDocumentController.sk1Comm.ServerEsecuteRequest(FXMLDocumentController.GLOBAL_IP, FXMLDocumentController.GLOBAL_PORT, "dbInteraction#@" + str);
            if (!this.data_select.contains("#ERR:")) {
                this.editText_descrizione.setText("");
                this.flag_modifica = false;
                this.id_memory = 0;
                this.refreshLista();
                FXMLDocumentController.toast.startToast("Ente Certificatore inserito", "SUCCESSO", "SUCCESSO");
            } else {
                FXMLDocumentController.util.alertWindow(Alert.AlertType.ERROR, "ERRORE", "", "ATTENZIONE!\n" + this.data_select);
            }
        } else if (this.flag_modifica && !descrizione.equals("")) {
            tipoSQL = new ArrayList();
            strSQL = new ArrayList();
            last_ID = new ArrayList();
            tipoSQL.add("update");
            strSQL.add("UPDATE ente_certificatore SET descrizione='" + descrizione + "'  WHERE id=" + this.id_memory + " AND azienda='" + FXMLDocumentController.GLOBAL_AZIENDA + "' AND sotto_az='" + FXMLDocumentController.GLOBAL_SOTTOAZZ + "' ");
            last_ID.add(false);
            String str = FXMLDocumentController.util.makeStringJsonDB("OFF", tipoSQL, strSQL, null, null, last_ID, null);
            this.data_select = FXMLDocumentController.sk1Comm.ServerEsecuteRequest(FXMLDocumentController.GLOBAL_IP, FXMLDocumentController.GLOBAL_PORT, "dbInteraction#@" + str);
            if (!this.data_select.contains("#ERR:")) {
                this.refreshLista();
                this.editText_descrizione.setText("");
                this.flag_modifica = false;
                this.id_memory = 0;
                FXMLDocumentController.toast.startToast("Salvataggio avvenuto con successo.", "SUCCESSO", "SUCCESSO");
            } else {
                FXMLDocumentController.util.alertWindow(Alert.AlertType.ERROR, "ERRORE", "", "ATTENZIONE!\n" + this.data_select);
            }
        }
    }

    private void refreshLista() throws JSONException {
        ArrayList<String> tipo = new ArrayList<String>();
        ArrayList<String> strSQL = new ArrayList<String>();
        ArrayList<Boolean> last_ID = new ArrayList<Boolean>();
        tipo.add("select");
        strSQL.add("SELECT descrizione,id FROM ente_certificatore  WHERE  azienda='" + FXMLDocumentController.GLOBAL_AZIENDA + "' AND sotto_az='" + FXMLDocumentController.GLOBAL_SOTTOAZZ + "' ");
        last_ID.add(false);
        String str = FXMLDocumentController.util.makeStringJsonDB("OFF", tipo, strSQL, null, null, last_ID, null);
        this.data_select = FXMLDocumentController.sk1Comm.ServerEsecuteRequest(FXMLDocumentController.GLOBAL_IP, FXMLDocumentController.GLOBAL_PORT, "dbInteraction#@" + str);
        if (!this.data_select.contains("#ERR:")) {
            this.lista.clear();
            JSONArray arrayJson = FXMLDocumentController.jsonUtil.strJsonToJSONArray(this.data_select);
            for (int i = 0; i < arrayJson.length(); ++i) {
                try {
                    JSONObject rec = arrayJson.getJSONObject(i);
                    tipo = new ArrayList();
                    strSQL = new ArrayList();
                    last_ID = new ArrayList();
                    int id = Integer.parseInt(rec.get("id").toString().replace("null", "0"));
                    String descrizione = rec.get("descrizione").toString().replace("null", "");
                    this.lista.add((Object)new CodiceEnteCertificatore(id, descrizione));
                    continue;
                }
                catch (JSONException ex) {
                    FXMLDocumentController.util.alertWindow(Alert.AlertType.ERROR, "ERRORE", "", ex.toString());
                }
            }
        }
        this.table.refresh();
    }
}

