/*
 * Decompiled with CFR 0.152.
 */
package vin.conf;

import com.jfoenix.controls.JFXButton;
import com.jfoenix.controls.JFXDialog;
import com.jfoenix.controls.JFXDialogLayout;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.fxml.FXML;
import javafx.fxml.FXMLLoader;
import javafx.fxml.Initializable;
import javafx.scene.Cursor;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Alert;
import javafx.scene.control.TableCell;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableRow;
import javafx.scene.control.TableView;
import javafx.scene.control.cell.PropertyValueFactory;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.Pane;
import javafx.scene.layout.Region;
import javafx.scene.layout.StackPane;
import javafx.scene.text.Text;
import javafx.stage.Modality;
import javafx.stage.Stage;
import javafx.stage.StageStyle;
import javafx.util.Callback;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import vin.Class.ColumnTabellaObbiettivi;
import vin.controller.FXMLDocumentController;
import vin.controller.FinestraObbiettivoController;

public class ConfTabellaObbiettiviController
implements Initializable {
    public ObservableList<ColumnTabellaObbiettivi> lista = FXCollections.observableArrayList();
    @FXML
    private TableView<ColumnTabellaObbiettivi> table;
    @FXML
    private TableColumn<ColumnTabellaObbiettivi, Integer> column_id;
    @FXML
    private TableColumn<ColumnTabellaObbiettivi, String> column_categoria;
    @FXML
    private TableColumn<ColumnTabellaObbiettivi, String> column_kgceppo;
    @FXML
    private TableColumn<ColumnTabellaObbiettivi, String> column_grado;
    @FXML
    private TableColumn<ColumnTabellaObbiettivi, String> column_percpiu;
    @FXML
    private TableColumn<ColumnTabellaObbiettivi, String> column_percmeno;
    @FXML
    private TableColumn<ColumnTabellaObbiettivi, String> column_supperc;
    @FXML
    private TableColumn<ColumnTabellaObbiettivi, String> column_prezzo;
    @FXML
    private TableColumn<ColumnTabellaObbiettivi, String> column_obbiettivo;
    @FXML
    private TableColumn<ColumnTabellaObbiettivi, String> column_datamod;
    @FXML
    private StackPane stack;

    @FXML
    void btnAggiungi(ActionEvent event) throws IOException, FileNotFoundException, URISyntaxException, JSONException {
        FXMLLoader loader = new FXMLLoader(this.getClass().getResource("/vin/view/FinestraObbiettivo.fxml"));
        Stage stage = new Stage();
        stage.setMaximized(false);
        stage.setTitle("OBBIETTIVO");
        stage.setScene(new Scene((Parent)((Pane)loader.load())));
        stage.initModality(Modality.APPLICATION_MODAL);
        stage.initStyle(StageStyle.UNDECORATED);
        stage.setResizable(false);
        stage.showAndWait();
        this.refreshLista();
    }

    private void refreshLista() throws JSONException {
        ArrayList<String> tipoSQL = new ArrayList<String>();
        ArrayList<String> strSQL = new ArrayList<String>();
        ArrayList<Integer> lenghtBidimensionalArray = new ArrayList<Integer>();
        ArrayList<Boolean> lastID = new ArrayList<Boolean>();
        String data_select = "";
        lastID.add(false);
        int year = Calendar.getInstance().get(1);
        String str = "SELECT a.id,a.obbiettivo,b.descrizione AS colore,a.kg_ceppo,a.grado_min,a.perc_piu,a.perc_meno,a.sup_perc,a.prezzo,a.data_mod,a.classificazione,l.descrizione AS classificazionedescr FROM f_ana_obbiettivi AS a LEFT JOIN sian_t_colore AS b ON a.colore=b.CODICE LEFT JOIN sian_t_classificazione AS l ON a.classificazione=l.CODICE WHERE  a.azienda='" + FXMLDocumentController.GLOBAL_AZIENDA + "' AND a.sotto_az='" + FXMLDocumentController.GLOBAL_SOTTOAZZ + "' AND a.icqrf='" + FXMLDocumentController.GLOBAL_ICQRF + "' ";
        strSQL.add(str);
        tipoSQL.add("select");
        lenghtBidimensionalArray.add(0);
        String strJson = FXMLDocumentController.util.makeStringJsonDB("ON", tipoSQL, strSQL, null, null, lastID, lenghtBidimensionalArray);
        data_select = FXMLDocumentController.sk1Comm.ServerEsecuteRequest(FXMLDocumentController.GLOBAL_IP, FXMLDocumentController.GLOBAL_PORT, "dbInteraction#@" + strJson);
        if (!data_select.contains("#ERR:")) {
            this.lista.clear();
            JSONArray arrayJson = FXMLDocumentController.jsonUtil.strJsonToJSONArray(data_select);
            for (int i = 0; i < arrayJson.length(); ++i) {
                try {
                    JSONObject rec = arrayJson.getJSONObject(i);
                    this.lista.add((Object)new ColumnTabellaObbiettivi(rec.getInt("id"), rec.getString("obbiettivo"), rec.getString("colore"), rec.getString("data_mod").replace("null", ""), rec.getDouble("kg_ceppo") + "", rec.getDouble("grado_min") + "", rec.getDouble("perc_piu") + "", rec.getDouble("perc_meno") + "", rec.getDouble("sup_perc") + "", rec.getDouble("prezzo") + "", 0.0, 0.0, rec.getString("classificazione"), rec.getString("classificazionedescr")));
                    continue;
                }
                catch (Exception ex) {
                    FXMLDocumentController.util.alertWindow(Alert.AlertType.ERROR, "ERRORE", "", ex.toString());
                }
            }
        } else {
            FXMLDocumentController.util.alertWindow(Alert.AlertType.ERROR, "ERRORE", "", data_select);
        }
        this.table.refresh();
    }

    @FXML
    void btnModifica(ActionEvent event) throws IOException, JSONException {
        ColumnTabellaObbiettivi obj = (ColumnTabellaObbiettivi)this.table.getSelectionModel().getSelectedItem();
        if (obj != null && obj.getColumn_anno().equals("")) {
            FXMLLoader loader = new FXMLLoader(this.getClass().getResource("/vin/view/FinestraObbiettivo.fxml"));
            Stage stage = new Stage();
            stage.setMaximized(false);
            stage.setTitle("OBBIETTIVO");
            stage.setScene(new Scene((Parent)((Pane)loader.load())));
            FinestraObbiettivoController controller = (FinestraObbiettivoController)loader.getController();
            controller.setFlg_modifica(true);
            controller.setId_mod(String.valueOf(obj.getColumn_id()));
            controller.setLoadField();
            stage.initModality(Modality.APPLICATION_MODAL);
            stage.initStyle(StageStyle.UNDECORATED);
            stage.setResizable(false);
            stage.showAndWait();
            this.refreshLista();
        }
    }

    @FXML
    void btnElimina(ActionEvent event) {
        final ColumnTabellaObbiettivi obj = (ColumnTabellaObbiettivi)this.table.getSelectionModel().getSelectedItem();
        if (obj != null) {
            JFXDialogLayout dialogLayout = new JFXDialogLayout();
            dialogLayout.setHeading(new Node[]{new Text("")});
            dialogLayout.setBody(new Node[]{new Text("Confermi eliminazione obbiettivo " + obj.getColumn_obbiettivo() + " ?")});
            final JFXDialog dialog = new JFXDialog(this.stack, (Region)dialogLayout, JFXDialog.DialogTransition.CENTER);
            dialog.setStyle("-fx-background-color: rgba(221,75,57,0.7);");
            JFXButton btn = new JFXButton("OK");
            JFXButton btn2 = new JFXButton("ANNULLA");
            btn.setStyle("-fx-font-weight: bold;");
            btn2.setStyle("-fx-font-weight: bold;");
            btn.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

                public void handle(ActionEvent event) {
                    try {
                        ConfTabellaObbiettiviController.this.elimina(obj.getColumn_id());
                        ConfTabellaObbiettiviController.this.refreshLista();
                        dialog.close();
                    }
                    catch (JSONException ex) {
                        Logger.getLogger(ConfTabellaObbiettiviController.class.getName()).log(Level.SEVERE, null, ex);
                    }
                }
            });
            btn2.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

                public void handle(ActionEvent event) {
                    dialog.close();
                }
            });
            btn.setOnMouseEntered((EventHandler)new EventHandler<MouseEvent>(){

                public void handle(MouseEvent event) {
                    ((Node)event.getSource()).setCursor(Cursor.HAND);
                }
            });
            btn.setOnMouseExited((EventHandler)new EventHandler<MouseEvent>(){

                public void handle(MouseEvent event) {
                    ((Node)event.getSource()).setCursor(Cursor.DEFAULT);
                }
            });
            dialogLayout.setActions(new Node[]{btn, btn2});
            dialog.setDialogContainer(this.stack);
            dialog.show();
        }
    }

    private void elimina(int id) throws JSONException {
        ArrayList<String> strSQL = new ArrayList<String>();
        ArrayList<String> tipoSQL = new ArrayList<String>();
        ArrayList<Boolean> lastID = new ArrayList<Boolean>();
        ArrayList lenghtBidimensionalArray = new ArrayList();
        int iterator = 0;
        lastID.add(false);
        strSQL.add("DELETE FROM f_ana_obbiettivi WHERE id=" + id);
        tipoSQL.add("delete");
        ++iterator;
        String strJson = FXMLDocumentController.util.makeStringJsonDB("ON", tipoSQL, strSQL, null, null, lastID, null);
        String data_select = FXMLDocumentController.sk1Comm.ServerEsecuteRequest(FXMLDocumentController.GLOBAL_IP, FXMLDocumentController.GLOBAL_PORT, "dbInteraction#@" + strJson);
        if (!data_select.contains("#ERR:")) {
            FXMLDocumentController.toast.startToast("Operazione completata.", "SUCCESSO", "SUCCESSO");
        } else {
            FXMLDocumentController.util.alertWindow(Alert.AlertType.ERROR, "ERRORE", "", data_select);
        }
    }

    public void initialize(URL url, ResourceBundle rb) {
        try {
            this.column_id.setCellValueFactory((Callback)new PropertyValueFactory("column_id"));
            this.column_categoria.setCellValueFactory((Callback)new PropertyValueFactory("column_categoria"));
            this.column_grado.setCellValueFactory((Callback)new PropertyValueFactory("column_gradomin"));
            this.column_kgceppo.setCellValueFactory((Callback)new PropertyValueFactory("column_kgceppo"));
            this.column_obbiettivo.setCellValueFactory((Callback)new PropertyValueFactory("column_obbiettivo"));
            this.column_percmeno.setCellValueFactory((Callback)new PropertyValueFactory("column_percmeno"));
            this.column_percpiu.setCellValueFactory((Callback)new PropertyValueFactory("column_percpiu"));
            this.column_prezzo.setCellValueFactory((Callback)new PropertyValueFactory("column_prezzo"));
            this.column_supperc.setCellValueFactory((Callback)new PropertyValueFactory("column_supperc"));
            this.column_datamod.setCellValueFactory((Callback)new PropertyValueFactory("column_anno"));
            this.column_datamod.setCellFactory(column -> new TableCell<ColumnTabellaObbiettivi, String>(){

                protected void updateItem(String item, boolean empty) {
                    super.updateItem((Object)item, empty);
                    this.setText(empty ? "" : ((String)this.getItem()).toString());
                    this.setGraphic(null);
                    TableRow currentRow = this.getTableRow();
                    if (!this.isEmpty()) {
                        String rower = item.toString().replace("null", "");
                        if (currentRow.getItem() != null) {
                            if (!rower.equals("")) {
                                currentRow.setStyle("-fx-background-color:#F39C12;");
                            } else {
                                currentRow.setStyle("-fx-background-color: lightgreen");
                            }
                        }
                    }
                }
            });
            this.table.setItems(this.lista);
            this.refreshLista();
        }
        catch (JSONException ex) {
            Logger.getLogger(ConfTabellaObbiettiviController.class.getName()).log(Level.SEVERE, null, ex);
        }
    }
}

