/*
 * Decompiled with CFR 0.152.
 */
package vin.Uility;

import com.jfoenix.controls.JFXComboBox;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.event.EventHandler;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;

public class AutoCompleteComboBoxListenerJFX<T>
implements EventHandler<KeyEvent> {
    private JFXComboBox<T> comboBox;
    private ObservableList<T> data;
    private boolean moveCaretToPos = false;
    private int caretPos;

    AutoCompleteComboBoxListenerJFX(JFXComboBox<T> comboBox) {
        this.comboBox = comboBox;
        this.data = comboBox.getItems();
        this.comboBox.setEditable(true);
        this.comboBox.setOnKeyPressed(t -> comboBox.hide());
        this.comboBox.setOnKeyReleased((EventHandler)this);
    }

    public void handle(KeyEvent event) {
        if (event.getCode() == KeyCode.UP) {
            this.caretPos = -1;
            this.moveCaret(this.comboBox.getEditor().getText().length());
            return;
        }
        if (event.getCode() == KeyCode.DOWN) {
            if (!this.comboBox.isShowing()) {
                this.comboBox.show();
            }
            this.caretPos = -1;
            this.moveCaret(this.comboBox.getEditor().getText().length());
            return;
        }
        if (event.getCode() == KeyCode.BACK_SPACE) {
            this.moveCaretToPos = true;
            this.caretPos = this.comboBox.getEditor().getCaretPosition();
        } else if (event.getCode() == KeyCode.DELETE) {
            this.moveCaretToPos = true;
            this.caretPos = this.comboBox.getEditor().getCaretPosition();
        }
        if (event.getCharacter().matches("[a-z]")) {
            this.comboBox.setValue((Object)String.valueOf(this.comboBox.getValue()).toUpperCase());
        }
        if (event.getCode() == KeyCode.RIGHT || event.getCode() == KeyCode.LEFT || event.isControlDown() || event.getCode() == KeyCode.HOME || event.getCode() == KeyCode.END || event.getCode() == KeyCode.TAB) {
            return;
        }
        ObservableList list = FXCollections.observableArrayList();
        for (Object aData : this.data) {
            if (!String.valueOf(aData).toLowerCase().startsWith(this.comboBox.getEditor().getText().toLowerCase())) continue;
            list.add(aData);
        }
        String t = this.comboBox.getEditor().getText();
        this.comboBox.setItems(list);
        this.comboBox.getEditor().setText(t);
        if (!this.moveCaretToPos) {
            this.caretPos = -1;
        }
        this.moveCaret(t.length());
        if (!list.isEmpty()) {
            this.comboBox.show();
        }
    }

    private void moveCaret(int textLength) {
        if (this.caretPos == -1) {
            this.comboBox.getEditor().positionCaret(textLength);
        } else {
            this.comboBox.getEditor().positionCaret(this.caretPos);
        }
        this.moveCaretToPos = false;
    }
}

