/*
 * Decompiled with CFR 0.152.
 */
package vin.Uility;

import com.sun.javafx.scene.control.skin.ComboBoxListViewSkin;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.event.EventHandler;
import javafx.scene.control.ComboBox;
import javafx.scene.control.ListView;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.scene.input.MouseButton;
import javafx.scene.input.MouseEvent;
import vin.Class.CodiceDescrizione;

public class AutoCompleteComboBoxListener<t>
implements EventHandler<KeyEvent> {
    private ComboBox<CodiceDescrizione> comboBox;
    private StringBuilder sb;
    private ObservableList<CodiceDescrizione> data;
    private boolean moveCaretToPos = false;
    private int caretPos;

    public AutoCompleteComboBoxListener(final ComboBox<CodiceDescrizione> comboBox) {
        this.comboBox = comboBox;
        this.sb = new StringBuilder();
        this.data = FXCollections.observableArrayList();
        this.data = comboBox.getItems();
        this.comboBox.setEditable(true);
        this.comboBox.getEditor().setOnMouseClicked((EventHandler)new EventHandler<MouseEvent>(){

            public void handle(MouseEvent mouseEvent) {
                if (mouseEvent.getButton().equals((Object)MouseButton.PRIMARY) && mouseEvent.getClickCount() == 2) {
                    AutoCompleteComboBoxListener.this.comboBox.getEditor().setEditable(true);
                    AutoCompleteComboBoxListener.this.comboBox.getEditor().setText("");
                    AutoCompleteComboBoxListener.this.comboBox.getSelectionModel().selectFirst();
                }
            }
        });
        this.comboBox.getSelectionModel().selectedItemProperty().addListener((ChangeListener)new ChangeListener<CodiceDescrizione>(){

            public void changed(ObservableValue<? extends CodiceDescrizione> arg0, CodiceDescrizione arg1, CodiceDescrizione arg2) {
                if (arg2 != null && !arg2.getDescrizione().trim().equals("")) {
                    AutoCompleteComboBoxListener.this.comboBox.getEditor().setEditable(false);
                }
            }
        });
        this.comboBox.setOnKeyPressed((EventHandler)new EventHandler<KeyEvent>(){

            public void handle(KeyEvent t) {
                comboBox.hide();
            }
        });
        this.comboBox.setOnKeyReleased((EventHandler)this);
    }

    public void handle(KeyEvent event) {
        ListView lv = ((ComboBoxListViewSkin)this.comboBox.getSkin()).getListView();
        if (event.getCode() == KeyCode.UP) {
            this.caretPos = -1;
            this.moveCaret(this.comboBox.getEditor().getText().length());
            return;
        }
        if (event.getCode() == KeyCode.DOWN) {
            if (!this.comboBox.isShowing()) {
                this.comboBox.show();
            }
            this.caretPos = -1;
            this.moveCaret(this.comboBox.getEditor().getText().length());
            return;
        }
        if (event.getCode() == KeyCode.BACK_SPACE) {
            this.moveCaretToPos = true;
            this.caretPos = this.comboBox.getEditor().getCaretPosition();
        } else if (event.getCode() == KeyCode.DELETE) {
            this.moveCaretToPos = true;
            this.caretPos = this.comboBox.getEditor().getCaretPosition();
        }
        if (event.getCode() == KeyCode.RIGHT || event.getCode() == KeyCode.LEFT || event.isControlDown() || event.getCode() == KeyCode.HOME || event.getCode() == KeyCode.END || event.getCode() == KeyCode.TAB) {
            return;
        }
        ObservableList list = FXCollections.observableArrayList();
        list.add(null);
        for (int i = 1; i < this.data.size(); ++i) {
            String campra = ((CodiceDescrizione)this.data.get(i)).getDescrizione().toString().replace("null", "").toLowerCase();
            String campra3 = ((CodiceDescrizione)this.data.get(i)).getCodice().toString().replace("null", "").toLowerCase();
            String compare = this.comboBox.getEditor().getText().toLowerCase();
            if (campra.contains(compare)) {
                list.add(this.data.get(i));
            }
            if (!campra3.contains(compare)) continue;
            list.add(this.data.get(i));
        }
        String t = this.comboBox.getEditor().getText();
        this.comboBox.setItems(list);
        this.comboBox.getEditor().setText(t);
        if (!this.moveCaretToPos) {
            this.caretPos = -1;
        }
        this.moveCaret(t.length());
        if (!list.isEmpty()) {
            this.comboBox.show();
        }
    }

    private void moveCaret(int textLength) {
        if (this.caretPos == -1) {
            this.comboBox.getEditor().positionCaret(textLength);
        } else {
            this.comboBox.getEditor().positionCaret(this.caretPos);
        }
        this.moveCaretToPos = false;
    }

    public static <T> T getComboBoxValue(ComboBox<T> comboBox) {
        if (comboBox.getSelectionModel().getSelectedIndex() < 0) {
            return null;
        }
        return (T)comboBox.getItems().get(comboBox.getSelectionModel().getSelectedIndex());
    }
}

