/*
 * Decompiled with CFR 0.152.
 */
package vin.Class;

import javafx.application.Platform;
import javafx.scene.Node;
import javafx.scene.control.Spinner;
import javafx.scene.control.SpinnerValueFactory;
import javafx.scene.control.TableCell;
import javafx.scene.input.KeyCode;

public class SpinnerTableCell<S, Integer>
extends TableCell<S, Integer> {
    private final Spinner<Integer> spinner = new Spinner();

    public SpinnerTableCell(int min, int max) {
        SpinnerValueFactory.IntegerSpinnerValueFactory sdf = new SpinnerValueFactory.IntegerSpinnerValueFactory(min, max);
        this.spinner.setValueFactory((SpinnerValueFactory)sdf);
        this.setEditable(true);
    }

    public SpinnerTableCell(int min, int max, int initial, int step) {
        SpinnerValueFactory.IntegerSpinnerValueFactory sdf = new SpinnerValueFactory.IntegerSpinnerValueFactory(min, max, initial, step);
        this.spinner.setValueFactory((SpinnerValueFactory)sdf);
        this.setEditable(true);
    }

    public void startEdit() {
        if (!this.isEmpty()) {
            super.startEdit();
            this.spinner.getValueFactory().setValue(this.getItem());
            this.setOnKeyPressed(event -> {
                if (event.getCode() == KeyCode.ENTER) {
                    Platform.runLater(() -> this.commitEdit(this.spinner.getValue()));
                }
            });
            this.setText(null);
            this.setGraphic((Node)this.spinner);
        }
    }

    public void cancelEdit() {
        super.cancelEdit();
        this.setText(this.getItem().toString());
        this.setGraphic(null);
    }

    public void updateItem(Integer item, boolean empty) {
        super.updateItem(item, empty);
        if (empty) {
            this.setText(null);
            this.setGraphic(null);
        } else if (this.isEditing()) {
            this.setText(null);
            this.setGraphic((Node)this.spinner);
        } else {
            this.setText(this.getItem().toString());
            this.setGraphic(null);
        }
    }
}

