/*
 * Decompiled with CFR 0.152.
 */
package vin.Class;

import java.io.IOException;
import java.text.ParseException;
import java.time.LocalDate;
import java.time.LocalTime;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.scene.control.Alert;
import org.apache.commons.lang3.StringUtils;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import vin.Class.CodiceDescrizioneComboBox;
import vin.Class.ColumnTableComunicazioni;
import vin.Class.ColumnTableMovimentiFascette;
import vin.Class.ColumnTableOperazioniCantina;
import vin.Class.ColumnTableSearchComponenteMexal;
import vin.Comunicator.Sk1SrvCommunicator;
import vin.Uility.JsonUtils;
import vin.Uility.Utility;
import vin.controller.FXMLDocumentController;
import vin.controller.ToastFXMessages;

public class Ricerca {
    public Sk1SrvCommunicator sk1Comm = new Sk1SrvCommunicator();
    public JsonUtils jsonUtil = new JsonUtils();
    public ToastFXMessages toast = new ToastFXMessages();
    Utility util = null;

    public List<ColumnTableMovimentiFascette> getMovimentiFascette(String id) throws JSONException {
        ArrayList<ColumnTableMovimentiFascette> ret = new ArrayList<ColumnTableMovimentiFascette>();
        ArrayList<String> strSQL = new ArrayList<String>();
        ArrayList<String> tipoSQL = new ArrayList<String>();
        ArrayList<Boolean> lastID = new ArrayList<Boolean>();
        strSQL = new ArrayList();
        tipoSQL = new ArrayList();
        lastID = new ArrayList();
        lastID.add(false);
        strSQL.add("SELECT data_operazione,sigla,codice_prodotto,num_protocollo,data_ido,ente_cert,serie,da_numero,a_numero,lotto FROM movimenti_fascette AS s WHERE id_oper=" + id + " ");
        tipoSQL.add("select");
        String strJson = this.util.makeStringJsonDB("OFF", tipoSQL, strSQL, null, null, lastID, null);
        String data_select = this.sk1Comm.ServerEsecuteRequest(FXMLDocumentController.GLOBAL_IP, FXMLDocumentController.GLOBAL_PORT, "dbInteraction#@" + strJson);
        if (!data_select.contains("#ERR:")) {
            JSONArray arrayJson = this.jsonUtil.strJsonToJSONArray(data_select);
            for (int i = 0; i < arrayJson.length(); ++i) {
                JSONObject rec = arrayJson.getJSONObject(i);
                String data_operazione = rec.get("data_operazione").toString();
                String sigla = rec.get("sigla").toString();
                String codice_prodotto = rec.get("codice_prodotto").toString();
                String num_protocollo = rec.get("num_protocollo").toString();
                String data_ido = rec.get("data_ido").toString();
                String ente_cert = rec.get("ente_cert").toString();
                String serie = rec.get("serie").toString();
                String da_numero = rec.get("da_numero").toString();
                String a_numero = rec.get("a_numero").toString();
                String lotto = rec.get("lotto").toString();
                ret.add(new ColumnTableMovimentiFascette(data_operazione, sigla, codice_prodotto, num_protocollo, ente_cert, data_ido, serie, da_numero, a_numero, lotto, "0"));
            }
        }
        return ret;
    }

    public List<String> getCommittentiFromDB(String azienda, String sotto_az, String icqrf) throws JSONException {
        ArrayList<String> ret = new ArrayList<String>();
        ArrayList<String> strSQL = new ArrayList<String>();
        ArrayList<String> tipoSQL = new ArrayList<String>();
        ArrayList<Boolean> lastID = new ArrayList<Boolean>();
        strSQL = new ArrayList();
        tipoSQL = new ArrayList();
        lastID = new ArrayList();
        lastID.add(false);
        strSQL.add("SELECT cod_committente FROM gen_t_icqrf_mxmag  WHERE azienda=" + azienda + " AND sotto_az='" + sotto_az + "' AND icqrf='" + icqrf + "' ");
        tipoSQL.add("select");
        String strJson = this.util.makeStringJsonDB("OFF", tipoSQL, strSQL, null, null, lastID, null);
        String data_select = this.sk1Comm.ServerEsecuteRequest(FXMLDocumentController.GLOBAL_IP, FXMLDocumentController.GLOBAL_PORT, "dbInteraction#@" + strJson);
        if (!data_select.contains("#ERR:")) {
            JSONArray arrayJson = this.jsonUtil.strJsonToJSONArray(data_select);
            for (int i = 0; i < arrayJson.length(); ++i) {
                JSONObject rec = arrayJson.getJSONObject(i);
                String cod_committente = rec.get("cod_committente").toString();
                ret.add(cod_committente);
            }
        }
        return ret;
    }

    public String getTotaleSerieIniziale(String serie, String codice, String num_prot, String ente_cert, String data_ido, String da_data, String a_data) throws JSONException {
        String ret = "0";
        ArrayList json = new ArrayList();
        ArrayList<String> strSQL = new ArrayList<String>();
        ArrayList<String> tipoSQL = new ArrayList<String>();
        ArrayList<Boolean> lastID = new ArrayList<Boolean>();
        strSQL = new ArrayList();
        tipoSQL = new ArrayList();
        lastID = new ArrayList();
        lastID.add(false);
        strSQL.add("SELECT (a_numero-da_numero)+1 AS numero FROM movimenti_fascette AS s LEFT JOIN c_movimenti_lotti AS b ON s.id=b.id_mov WHERE s.codice_prodotto='" + codice + "' AND s.azienda='" + FXMLDocumentController.GLOBAL_AZIENDA + "' AND s.sotto_az='" + FXMLDocumentController.GLOBAL_SOTTOAZZ + "' AND s.icqrf='" + FXMLDocumentController.GLOBAL_ICQRF + "' AND s.cod_committente='" + FXMLDocumentController.GLOBAL_CODCOMM + "' AND s.num_protocollo='" + num_prot + "' AND s.ente_cert='" + ente_cert + "' AND s.data_ido='" + data_ido + "' AND serie='" + serie + "' AND sigla='FA' AND (data_operazione<='" + a_data + "' AND data_operazione>='" + da_data + "') ");
        tipoSQL.add("select");
        String strJson = this.util.makeStringJsonDB("OFF", tipoSQL, strSQL, null, null, lastID, null);
        String data_select = this.sk1Comm.ServerEsecuteRequest(FXMLDocumentController.GLOBAL_IP, FXMLDocumentController.GLOBAL_PORT, "dbInteraction#@" + strJson);
        if (!data_select.contains("#ERR:")) {
            JSONArray arrayJson = this.jsonUtil.strJsonToJSONArray(data_select);
            for (int i = 0; i < arrayJson.length(); ++i) {
                JSONObject rec = arrayJson.getJSONObject(i);
                ret = rec.get("numero").toString();
            }
        }
        return ret;
    }

    public String getSerieLotto(String serie, String codice, String num_prot, String ente_cert, String data_ido, String da_data, String a_data, String da_numero, String a_numero) throws JSONException {
        String ret = "";
        ArrayList json = new ArrayList();
        ArrayList<String> strSQL = new ArrayList<String>();
        ArrayList<String> tipoSQL = new ArrayList<String>();
        ArrayList<Boolean> lastID = new ArrayList<Boolean>();
        strSQL = new ArrayList();
        tipoSQL = new ArrayList();
        lastID = new ArrayList();
        lastID.add(false);
        strSQL.add("SELECT lotto AS  lotto FROM movimenti_fascette AS s LEFT JOIN c_movimenti_lotti AS b ON s.id=b.id_mov WHERE s.codice_prodotto='" + codice + "' AND s.azienda='" + FXMLDocumentController.GLOBAL_AZIENDA + "' AND s.sotto_az='" + FXMLDocumentController.GLOBAL_SOTTOAZZ + "' AND s.icqrf='" + FXMLDocumentController.GLOBAL_ICQRF + "' AND s.cod_committente='" + FXMLDocumentController.GLOBAL_CODCOMM + "' AND s.num_protocollo='" + num_prot + "' AND s.ente_cert='" + ente_cert + "' AND s.data_ido='" + data_ido + "' AND serie='" + serie + "' AND sigla='FA' AND da_numero=" + da_numero + " AND a_numero=" + a_numero + " AND (data_operazione<='" + a_data + "' AND data_operazione>='" + da_data + "') ");
        tipoSQL.add("select");
        String strJson = this.util.makeStringJsonDB("OFF", tipoSQL, strSQL, null, null, lastID, null);
        String data_select = this.sk1Comm.ServerEsecuteRequest(FXMLDocumentController.GLOBAL_IP, FXMLDocumentController.GLOBAL_PORT, "dbInteraction#@" + strJson);
        if (!data_select.contains("#ERR:")) {
            JSONArray arrayJson = this.jsonUtil.strJsonToJSONArray(data_select);
            for (int i = 0; i < arrayJson.length(); ++i) {
                JSONObject rec = arrayJson.getJSONObject(i);
                ret = rec.get("lotto").toString();
            }
        }
        return ret;
    }

    public String getSerieFascette_DA(String serie, String codice, String num_prot, String ente_cert, String data_ido, String da_data, String a_data) throws JSONException {
        String ret = "0";
        ArrayList json = new ArrayList();
        ArrayList<String> strSQL = new ArrayList<String>();
        ArrayList<String> tipoSQL = new ArrayList<String>();
        ArrayList<Boolean> lastID = new ArrayList<Boolean>();
        strSQL = new ArrayList();
        tipoSQL = new ArrayList();
        lastID = new ArrayList();
        lastID.add(false);
        strSQL.add("SELECT da_numero AS  numero FROM movimenti_fascette AS s LEFT JOIN c_movimenti_lotti AS b ON s.id=b.id_mov WHERE s.codice_prodotto='" + codice + "' AND s.azienda='" + FXMLDocumentController.GLOBAL_AZIENDA + "' AND s.sotto_az='" + FXMLDocumentController.GLOBAL_SOTTOAZZ + "' AND s.icqrf='" + FXMLDocumentController.GLOBAL_ICQRF + "' AND s.cod_committente='" + FXMLDocumentController.GLOBAL_CODCOMM + "' AND s.num_protocollo='" + num_prot + "' AND s.ente_cert='" + ente_cert + "' AND s.data_ido='" + data_ido + "' AND serie='" + serie + "' AND sigla='FA' AND (data_operazione<='" + a_data + "' AND data_operazione>='" + da_data + "') ");
        tipoSQL.add("select");
        String strJson = this.util.makeStringJsonDB("OFF", tipoSQL, strSQL, null, null, lastID, null);
        String data_select = this.sk1Comm.ServerEsecuteRequest(FXMLDocumentController.GLOBAL_IP, FXMLDocumentController.GLOBAL_PORT, "dbInteraction#@" + strJson);
        if (!data_select.contains("#ERR:")) {
            JSONArray arrayJson = this.jsonUtil.strJsonToJSONArray(data_select);
            for (int i = 0; i < arrayJson.length(); ++i) {
                JSONObject rec = arrayJson.getJSONObject(i);
                ret = rec.get("numero").toString();
            }
        }
        return ret;
    }

    public String getSerieFascette_A(String serie, String codice, String num_prot, String ente_cert, String data_ido, String da_data, String a_data) throws JSONException {
        String ret = "0";
        ArrayList json = new ArrayList();
        ArrayList<String> strSQL = new ArrayList<String>();
        ArrayList<String> tipoSQL = new ArrayList<String>();
        ArrayList<Boolean> lastID = new ArrayList<Boolean>();
        strSQL = new ArrayList();
        tipoSQL = new ArrayList();
        lastID = new ArrayList();
        lastID.add(false);
        strSQL.add("SELECT a_numero AS  numero FROM movimenti_fascette AS s LEFT JOIN c_movimenti_lotti AS b ON s.id=b.id_mov WHERE s.codice_prodotto='" + codice + "' AND s.azienda='" + FXMLDocumentController.GLOBAL_AZIENDA + "' AND s.sotto_az='" + FXMLDocumentController.GLOBAL_SOTTOAZZ + "' AND s.icqrf='" + FXMLDocumentController.GLOBAL_ICQRF + "' AND s.cod_committente='" + FXMLDocumentController.GLOBAL_CODCOMM + "' AND s.num_protocollo='" + num_prot + "' AND s.ente_cert='" + ente_cert + "' AND s.data_ido='" + data_ido + "' AND serie='" + serie + "' AND sigla='FA' AND (data_operazione<='" + a_data + "' AND data_operazione>='" + da_data + "') ");
        tipoSQL.add("select");
        String strJson = this.util.makeStringJsonDB("OFF", tipoSQL, strSQL, null, null, lastID, null);
        String data_select = this.sk1Comm.ServerEsecuteRequest(FXMLDocumentController.GLOBAL_IP, FXMLDocumentController.GLOBAL_PORT, "dbInteraction#@" + strJson);
        if (!data_select.contains("#ERR:")) {
            JSONArray arrayJson = this.jsonUtil.strJsonToJSONArray(data_select);
            for (int i = 0; i < arrayJson.length(); ++i) {
                JSONObject rec = arrayJson.getJSONObject(i);
                ret = rec.get("numero").toString();
            }
        }
        return ret;
    }

    public String getCertificazioniFromLotto(String codice, String lotto) throws JSONException {
        String ret = null;
        ArrayList<String> json = new ArrayList<String>();
        ArrayList<String> strSQL = new ArrayList<String>();
        ArrayList<String> tipoSQL = new ArrayList<String>();
        ArrayList<Boolean> lastID = new ArrayList<Boolean>();
        strSQL = new ArrayList();
        tipoSQL = new ArrayList();
        lastID = new ArrayList();
        lastID.add(false);
        strSQL.add("SELECT s.num_prot_ido AS num_prot,s.data_ido,s.ente_cert,SUM(s.litri) AS litri FROM c_movimenti AS s LEFT JOIN c_movimenti_lotti AS b ON s.id=b.id_mov WHERE s.cod_tipo_vino='" + codice.replace("'", "\\'") + "' AND s.azienda='" + FXMLDocumentController.GLOBAL_AZIENDA + "' AND s.sotto_az='" + FXMLDocumentController.GLOBAL_SOTTOAZZ + "' AND s.icqrf='" + FXMLDocumentController.GLOBAL_ICQRF + "' AND s.cod_committente='" + FXMLDocumentController.GLOBAL_CODCOMM + "' AND b.cod_lotto='" + lotto + "' GROUP BY s.num_prot_ido,s.data_ido,s.ente_cert ");
        tipoSQL.add("select");
        String strJson = this.util.makeStringJsonDB("OFF", tipoSQL, strSQL, null, null, lastID, null);
        String data_select = this.sk1Comm.ServerEsecuteRequest(FXMLDocumentController.GLOBAL_IP, FXMLDocumentController.GLOBAL_PORT, "dbInteraction#@" + strJson);
        if (!data_select.contains("#ERR:")) {
            JSONArray arrayJson = this.jsonUtil.strJsonToJSONArray(data_select);
            for (int i = 0; i < arrayJson.length(); ++i) {
                JSONObject rec = arrayJson.getJSONObject(i);
                json.add(rec.getString("num_prot").trim() + "#@" + rec.getString("data_ido").trim() + "#@" + rec.getString("ente_cert").trim());
            }
            ret = ((Object)json).toString();
        } else {
            ret = data_select;
        }
        return ret;
    }

    public String getDallaDataInizioAnno() throws JSONException {
        String ret = "";
        ArrayList<String> tipoSQL = new ArrayList<String>();
        ArrayList<String> strSQL = new ArrayList<String>();
        ArrayList<Integer> lenghtBidimensionalArray = new ArrayList<Integer>();
        ArrayList<Boolean> lastID = new ArrayList<Boolean>();
        String data_select = "";
        lastID.add(false);
        String str = "SELECT IFNULL(MAX(adata),'2017-01-01') AS dadata \nFROM gen_t_chiusurewbs AS a WHERE azienda='" + FXMLDocumentController.GLOBAL_AZIENDA + "' AND sotto_az='" + FXMLDocumentController.GLOBAL_SOTTOAZZ + "' AND icqrf='" + FXMLDocumentController.GLOBAL_ICQRF + "'";
        strSQL.add(str);
        tipoSQL.add("select");
        lenghtBidimensionalArray.add(0);
        String strJson = this.util.makeStringJsonDB("OFF", tipoSQL, strSQL, null, null, lastID, lenghtBidimensionalArray);
        data_select = this.sk1Comm.ServerEsecuteRequest(FXMLDocumentController.GLOBAL_IP, FXMLDocumentController.GLOBAL_PORT, "dbInteraction#@" + strJson);
        if (!data_select.contains("#ERR:")) {
            JSONArray arrayJson = this.jsonUtil.strJsonToJSONArray(data_select);
            for (int i = 0; i < arrayJson.length(); ++i) {
                JSONObject rec = arrayJson.getJSONObject(i);
                ret = rec.get("dadata").toString();
            }
            if (ret.equals("")) {
                ret = "2017-01-01";
            }
        }
        return ret;
    }

    public String getDataValidazioneROR(String arc) throws JSONException {
        String ret = "";
        ArrayList<String> tipoSQL = new ArrayList<String>();
        ArrayList<String> strSQL = new ArrayList<String>();
        ArrayList<Integer> lenghtBidimensionalArray = new ArrayList<Integer>();
        ArrayList<Boolean> lastID = new ArrayList<Boolean>();
        String data_select = "";
        lastID.add(false);
        String str = "SELECT IFNULL(data_validazione,'') AS dadata \nFROM a_testata_ie818 AS a WHERE azienda='" + FXMLDocumentController.GLOBAL_AZIENDA + "' AND sotto_az='" + FXMLDocumentController.GLOBAL_SOTTOAZZ + "' AND cod_accisa='" + FXMLDocumentController.GLOBAL_ICQRF + "' AND arc='" + arc + "'";
        strSQL.add(str);
        tipoSQL.add("select");
        lenghtBidimensionalArray.add(0);
        String strJson = this.util.makeStringJsonDB("OFF", tipoSQL, strSQL, null, null, lastID, lenghtBidimensionalArray);
        data_select = this.sk1Comm.ServerEsecuteRequest(FXMLDocumentController.GLOBAL_IP, FXMLDocumentController.GLOBAL_PORT, "dbInteraction#@" + strJson);
        if (!data_select.contains("#ERR:")) {
            JSONArray arrayJson = this.jsonUtil.strJsonToJSONArray(data_select);
            for (int i = 0; i < arrayJson.length(); ++i) {
                JSONObject rec = arrayJson.getJSONObject(i);
                ret = rec.get("dadata").toString();
            }
        }
        return ret;
    }

    public String getImportoDispAccisaID_RECORDF(String id) throws JSONException {
        String ret = "";
        ArrayList<String> tipoSQL = new ArrayList<String>();
        ArrayList<String> strSQL = new ArrayList<String>();
        ArrayList<Integer> lenghtBidimensionalArray = new ArrayList<Integer>();
        ArrayList<Boolean> lastID = new ArrayList<Boolean>();
        String data_select = "";
        lastID.add(false);
        String str = "SELECT IFNULL(importo_iniziale,0) AS importo_iniziale \nFROM a_alcoav_f AS a WHERE id='" + id + "'";
        strSQL.add(str);
        tipoSQL.add("select");
        lenghtBidimensionalArray.add(0);
        String strJson = this.util.makeStringJsonDB("OFF", tipoSQL, strSQL, null, null, lastID, lenghtBidimensionalArray);
        data_select = this.sk1Comm.ServerEsecuteRequest(FXMLDocumentController.GLOBAL_IP, FXMLDocumentController.GLOBAL_PORT, "dbInteraction#@" + strJson);
        if (!data_select.contains("#ERR:")) {
            JSONArray arrayJson = this.jsonUtil.strJsonToJSONArray(data_select);
            for (int i = 0; i < arrayJson.length(); ++i) {
                JSONObject rec = arrayJson.getJSONObject(i);
                ret = rec.get("importo_iniziale").toString();
            }
            if (ret.equals("")) {
                ret = "0";
            }
        }
        return ret;
    }

    public List<String> getCodiciCommittente(String icqrf) throws JSONException {
        ArrayList<String> ret = new ArrayList<String>();
        ArrayList<String> tipoSQL = new ArrayList<String>();
        ArrayList<String> strSQL = new ArrayList<String>();
        ArrayList<Integer> lenghtBidimensionalArray = new ArrayList<Integer>();
        ArrayList<Boolean> lastID = new ArrayList<Boolean>();
        String data_select = "";
        lastID.add(false);
        String str = "SELECT cod_committente \nFROM gen_t_icqrf_mx_mag AS a WHERE azienda='" + FXMLDocumentController.GLOBAL_AZIENDA + "' AND sotto_az='" + FXMLDocumentController.GLOBAL_SOTTOAZZ + "' AND icqrf='" + icqrf + "'";
        strSQL.add(str);
        tipoSQL.add("select");
        lenghtBidimensionalArray.add(0);
        String strJson = this.util.makeStringJsonDB("OFF", tipoSQL, strSQL, null, null, lastID, lenghtBidimensionalArray);
        data_select = this.sk1Comm.ServerEsecuteRequest(FXMLDocumentController.GLOBAL_IP, FXMLDocumentController.GLOBAL_PORT, "dbInteraction#@" + strJson);
        if (!data_select.contains("#ERR:")) {
            JSONArray arrayJson = this.jsonUtil.strJsonToJSONArray(data_select);
            for (int i = 0; i < arrayJson.length(); ++i) {
                JSONObject rec = arrayJson.getJSONObject(i);
                ret.add(rec.get("cod_committente").toString());
            }
        }
        return ret;
    }

    public String getDescrizioneCommittenteFromcodSian(String codice_sian) throws JSONException {
        String ret = "";
        ArrayList<String> tipoSQL = new ArrayList<String>();
        ArrayList<String> strSQL = new ArrayList<String>();
        ArrayList<Integer> lenghtBidimensionalArray = new ArrayList<Integer>();
        ArrayList<Boolean> lastID = new ArrayList<Boolean>();
        String data_select = "";
        lastID.add(false);
        String str = "SELECT codice,rag_soc FROM(SELECT IF(cod_sian='',codice,cod_sian) AS codice,IF(IFNULL(rag_soc,'')='',CONCAT(cognome,' ',nome),rag_soc) AS rag_soc FROM gen_ana_clifor WHERE azienda='" + FXMLDocumentController.GLOBAL_AZIENDA + "' AND sotto_az='" + FXMLDocumentController.GLOBAL_SOTTOAZZ + "'  ) AS a \nWHERE codice='" + codice_sian + "' ";
        strSQL.add(str);
        tipoSQL.add("select");
        lenghtBidimensionalArray.add(0);
        String strJson = this.util.makeStringJsonDB("OFF", tipoSQL, strSQL, null, null, lastID, lenghtBidimensionalArray);
        data_select = this.sk1Comm.ServerEsecuteRequest(FXMLDocumentController.GLOBAL_IP, FXMLDocumentController.GLOBAL_PORT, "dbInteraction#@" + strJson);
        if (!data_select.contains("#ERR:")) {
            JSONArray arrayJson = this.jsonUtil.strJsonToJSONArray(data_select);
            for (int i = 0; i < arrayJson.length(); ++i) {
                JSONObject rec = arrayJson.getJSONObject(i);
                ret = rec.get("rag_soc").toString();
            }
        }
        return ret;
    }

    public String getTipoDestinazioneIE815(String id) throws JSONException {
        String ret = "";
        ArrayList<String> tipoSQL = new ArrayList<String>();
        ArrayList<String> strSQL = new ArrayList<String>();
        ArrayList<Integer> lenghtBidimensionalArray = new ArrayList<Integer>();
        ArrayList<Boolean> lastID = new ArrayList<Boolean>();
        String data_select = "";
        lastID.add(false);
        String str = "SELECT tipo_destinazione FROM a_testata_ie815  WHERE id=" + id;
        strSQL.add(str);
        tipoSQL.add("select");
        lenghtBidimensionalArray.add(0);
        String strJson = this.util.makeStringJsonDB("OFF", tipoSQL, strSQL, null, null, lastID, lenghtBidimensionalArray);
        data_select = this.sk1Comm.ServerEsecuteRequest(FXMLDocumentController.GLOBAL_IP, FXMLDocumentController.GLOBAL_PORT, "dbInteraction#@" + strJson);
        if (!data_select.contains("#ERR:")) {
            JSONArray arrayJson = this.jsonUtil.strJsonToJSONArray(data_select);
            for (int i = 0; i < arrayJson.length(); ++i) {
                JSONObject rec = arrayJson.getJSONObject(i);
                ret = rec.get("tipo_destinazione").toString();
            }
        }
        return ret;
    }

    public String getVolumeNominale(String prodotto) throws JSONException {
        String ret = "";
        ArrayList<String> tipoSQL = new ArrayList<String>();
        ArrayList<String> strSQL = new ArrayList<String>();
        ArrayList<Integer> lenghtBidimensionalArray = new ArrayList<Integer>();
        ArrayList<Boolean> lastID = new ArrayList<Boolean>();
        String data_select = "";
        lastID.add(false);
        String str = "SELECT sian_volume_nominale FROM gen_tipo_vino_ana  WHERE codice='" + prodotto + "' AND azienda='" + FXMLDocumentController.GLOBAL_AZIENDA + "' AND sotto_az='" + FXMLDocumentController.GLOBAL_SOTTOAZZ + "' AND icqrf='" + FXMLDocumentController.GLOBAL_ICQRF + "' ANd cod_committente='" + FXMLDocumentController.GLOBAL_CODCOMM + "'";
        strSQL.add(str);
        tipoSQL.add("select");
        lenghtBidimensionalArray.add(0);
        String strJson = this.util.makeStringJsonDB("OFF", tipoSQL, strSQL, null, null, lastID, lenghtBidimensionalArray);
        data_select = this.sk1Comm.ServerEsecuteRequest(FXMLDocumentController.GLOBAL_IP, FXMLDocumentController.GLOBAL_PORT, "dbInteraction#@" + strJson);
        if (!data_select.contains("#ERR:")) {
            JSONArray arrayJson = this.jsonUtil.strJsonToJSONArray(data_select);
            for (int i = 0; i < arrayJson.length(); ++i) {
                JSONObject rec = arrayJson.getJSONObject(i);
                ret = rec.get("sian_volume_nominale").toString();
            }
        }
        return ret;
    }

    public String getStatofisico(String prodotto) throws JSONException {
        String ret = "";
        ArrayList<String> tipoSQL = new ArrayList<String>();
        ArrayList<String> strSQL = new ArrayList<String>();
        ArrayList<Integer> lenghtBidimensionalArray = new ArrayList<Integer>();
        ArrayList<Boolean> lastID = new ArrayList<Boolean>();
        String data_select = "";
        lastID.add(false);
        String str = "SELECT sian_cod_stato_fisico FROM gen_tipo_vino_ana  WHERE codice='" + prodotto + "' AND azienda='" + FXMLDocumentController.GLOBAL_AZIENDA + "' AND sotto_az='" + FXMLDocumentController.GLOBAL_SOTTOAZZ + "' AND icqrf='" + FXMLDocumentController.GLOBAL_ICQRF + "' ANd cod_committente='" + FXMLDocumentController.GLOBAL_CODCOMM + "'";
        strSQL.add(str);
        tipoSQL.add("select");
        lenghtBidimensionalArray.add(0);
        String strJson = this.util.makeStringJsonDB("OFF", tipoSQL, strSQL, null, null, lastID, lenghtBidimensionalArray);
        data_select = this.sk1Comm.ServerEsecuteRequest(FXMLDocumentController.GLOBAL_IP, FXMLDocumentController.GLOBAL_PORT, "dbInteraction#@" + strJson);
        if (!data_select.contains("#ERR:")) {
            JSONArray arrayJson = this.jsonUtil.strJsonToJSONArray(data_select);
            for (int i = 0; i < arrayJson.length(); ++i) {
                JSONObject rec = arrayJson.getJSONObject(i);
                ret = rec.get("sian_cod_stato_fisico").toString();
            }
        }
        return ret;
    }

    public String getDataPerStampaDallaPrima(String anno) throws JSONException {
        String ret = "";
        ArrayList<String> tipoSQL = new ArrayList<String>();
        ArrayList<String> strSQL = new ArrayList<String>();
        ArrayList<Integer> lenghtBidimensionalArray = new ArrayList<Integer>();
        ArrayList<Boolean> lastID = new ArrayList<Boolean>();
        String data_select = "";
        lastID.add(false);
        String str = "SELECT IF(prima_chiusura=1,'2017-01-01',IFNULL(dadata,'')) AS dadata \nFROM gen_t_chiusurewbs AS a WHERE azienda='" + FXMLDocumentController.GLOBAL_AZIENDA + "' AND sotto_az='" + FXMLDocumentController.GLOBAL_SOTTOAZZ + "' AND icqrf='" + FXMLDocumentController.GLOBAL_ICQRF + "' AND YEAR(dadata)=" + anno;
        strSQL.add(str);
        tipoSQL.add("select");
        lenghtBidimensionalArray.add(0);
        String strJson = this.util.makeStringJsonDB("OFF", tipoSQL, strSQL, null, null, lastID, lenghtBidimensionalArray);
        data_select = this.sk1Comm.ServerEsecuteRequest(FXMLDocumentController.GLOBAL_IP, FXMLDocumentController.GLOBAL_PORT, "dbInteraction#@" + strJson);
        if (!data_select.contains("#ERR:")) {
            JSONArray arrayJson = this.jsonUtil.strJsonToJSONArray(data_select);
            for (int i = 0; i < arrayJson.length(); ++i) {
                JSONObject rec = arrayJson.getJSONObject(i);
                ret = rec.get("dadata").toString();
            }
        }
        return ret;
    }

    public String getDataPerStampaDalla(String anno) throws JSONException {
        String ret = "";
        ArrayList<String> tipoSQL = new ArrayList<String>();
        ArrayList<String> strSQL = new ArrayList<String>();
        ArrayList<Integer> lenghtBidimensionalArray = new ArrayList<Integer>();
        ArrayList<Boolean> lastID = new ArrayList<Boolean>();
        String data_select = "";
        lastID.add(false);
        String str = "SELECT IF(prima_chiusura=1,'2017-01-01',IFNULL(dadata,'')) AS dadata \nFROM gen_t_chiusurewbs AS a WHERE azienda='" + FXMLDocumentController.GLOBAL_AZIENDA + "' AND sotto_az='" + FXMLDocumentController.GLOBAL_SOTTOAZZ + "' AND icqrf='" + FXMLDocumentController.GLOBAL_ICQRF + "' AND YEAR(adata)=" + anno;
        strSQL.add(str);
        tipoSQL.add("select");
        lenghtBidimensionalArray.add(0);
        String strJson = this.util.makeStringJsonDB("OFF", tipoSQL, strSQL, null, null, lastID, lenghtBidimensionalArray);
        data_select = this.sk1Comm.ServerEsecuteRequest(FXMLDocumentController.GLOBAL_IP, FXMLDocumentController.GLOBAL_PORT, "dbInteraction#@" + strJson);
        if (!data_select.contains("#ERR:")) {
            JSONArray arrayJson = this.jsonUtil.strJsonToJSONArray(data_select);
            for (int i = 0; i < arrayJson.length(); ++i) {
                JSONObject rec = arrayJson.getJSONObject(i);
                ret = rec.get("dadata").toString();
            }
        }
        return ret;
    }

    public String getDataPerStampaDallaNoPrima(String anno) throws JSONException {
        String ret = "";
        ArrayList<String> tipoSQL = new ArrayList<String>();
        ArrayList<String> strSQL = new ArrayList<String>();
        ArrayList<Integer> lenghtBidimensionalArray = new ArrayList<Integer>();
        ArrayList<Boolean> lastID = new ArrayList<Boolean>();
        String data_select = "";
        lastID.add(false);
        String str = "SELECT IFNULL(dadata,'') AS dadata \nFROM gen_t_chiusurewbs AS a WHERE azienda='" + FXMLDocumentController.GLOBAL_AZIENDA + "' AND sotto_az='" + FXMLDocumentController.GLOBAL_SOTTOAZZ + "' AND icqrf='" + FXMLDocumentController.GLOBAL_ICQRF + "' AND YEAR(adata)=" + anno;
        strSQL.add(str);
        tipoSQL.add("select");
        lenghtBidimensionalArray.add(0);
        String strJson = this.util.makeStringJsonDB("OFF", tipoSQL, strSQL, null, null, lastID, lenghtBidimensionalArray);
        data_select = this.sk1Comm.ServerEsecuteRequest(FXMLDocumentController.GLOBAL_IP, FXMLDocumentController.GLOBAL_PORT, "dbInteraction#@" + strJson);
        if (!data_select.contains("#ERR:")) {
            JSONArray arrayJson = this.jsonUtil.strJsonToJSONArray(data_select);
            for (int i = 0; i < arrayJson.length(); ++i) {
                JSONObject rec = arrayJson.getJSONObject(i);
                ret = rec.get("dadata").toString();
            }
        }
        return ret;
    }

    public String getMinRangeDateOperInvio(String id_trasmissione) throws JSONException {
        String ret = "";
        ArrayList<String> tipoSQL = new ArrayList<String>();
        ArrayList<String> strSQL = new ArrayList<String>();
        ArrayList<Integer> lenghtBidimensionalArray = new ArrayList<Integer>();
        ArrayList<Boolean> lastID = new ArrayList<Boolean>();
        String data_select = "";
        lastID.add(false);
        String str = "SELECT MIN(b.data_oper) AS miner \nFROM gen_t_invii_opers AS a \nLEFT JOIN c_operazioni AS b ON a.id_oper=b.id\n WHERE id_trasmissione='" + id_trasmissione + "' ";
        strSQL.add(str);
        tipoSQL.add("select");
        lenghtBidimensionalArray.add(0);
        String strJson = this.util.makeStringJsonDB("OFF", tipoSQL, strSQL, null, null, lastID, lenghtBidimensionalArray);
        data_select = this.sk1Comm.ServerEsecuteRequest(FXMLDocumentController.GLOBAL_IP, FXMLDocumentController.GLOBAL_PORT, "dbInteraction#@" + strJson);
        if (!data_select.contains("#ERR:")) {
            JSONArray arrayJson = this.jsonUtil.strJsonToJSONArray(data_select);
            for (int i = 0; i < arrayJson.length(); ++i) {
                JSONObject rec = arrayJson.getJSONObject(i);
                ret = rec.get("miner").toString();
            }
        }
        return ret;
    }

    public String getMaxRangeDateOperInvio(String id_trasmissione) throws JSONException {
        String ret = "";
        ArrayList<String> tipoSQL = new ArrayList<String>();
        ArrayList<String> strSQL = new ArrayList<String>();
        ArrayList<Integer> lenghtBidimensionalArray = new ArrayList<Integer>();
        ArrayList<Boolean> lastID = new ArrayList<Boolean>();
        String data_select = "";
        lastID.add(false);
        String str = "SELECT MAX(b.data_oper) AS maxer \nFROM gen_t_invii_opers AS a \nLEFT JOIN c_operazioni AS b ON a.id_oper=b.id\n WHERE id_trasmissione='" + id_trasmissione + "' ";
        strSQL.add(str);
        tipoSQL.add("select");
        lenghtBidimensionalArray.add(0);
        String strJson = this.util.makeStringJsonDB("OFF", tipoSQL, strSQL, null, null, lastID, lenghtBidimensionalArray);
        data_select = this.sk1Comm.ServerEsecuteRequest(FXMLDocumentController.GLOBAL_IP, FXMLDocumentController.GLOBAL_PORT, "dbInteraction#@" + strJson);
        if (!data_select.contains("#ERR:")) {
            JSONArray arrayJson = this.jsonUtil.strJsonToJSONArray(data_select);
            for (int i = 0; i < arrayJson.length(); ++i) {
                JSONObject rec = arrayJson.getJSONObject(i);
                ret = rec.get("maxer").toString();
            }
        }
        return ret;
    }

    public String getNrVolumeLibroSoci(String codice_socio) throws JSONException {
        String ret = "";
        ArrayList<String> tipoSQL = new ArrayList<String>();
        ArrayList<String> strSQL = new ArrayList<String>();
        ArrayList<Integer> lenghtBidimensionalArray = new ArrayList<Integer>();
        ArrayList<Boolean> lastID = new ArrayList<Boolean>();
        String data_select = "";
        lastID.add(false);
        String str = "SELECT IFNULL(n_volume,'') AS n_volume \nFROM f_socio_libro AS a WHERE codice_socio='" + codice_socio + "' AND azienda='" + FXMLDocumentController.GLOBAL_AZIENDA + "' AND sotto_az='" + FXMLDocumentController.GLOBAL_SOTTOAZZ + "' AND icqrf='" + FXMLDocumentController.GLOBAL_ICQRF + "'";
        strSQL.add(str);
        tipoSQL.add("select");
        lenghtBidimensionalArray.add(0);
        String strJson = this.util.makeStringJsonDB("OFF", tipoSQL, strSQL, null, null, lastID, lenghtBidimensionalArray);
        data_select = this.sk1Comm.ServerEsecuteRequest(FXMLDocumentController.GLOBAL_IP, FXMLDocumentController.GLOBAL_PORT, "dbInteraction#@" + strJson);
        if (!data_select.contains("#ERR:")) {
            JSONArray arrayJson = this.jsonUtil.strJsonToJSONArray(data_select);
            for (int i = 0; i < arrayJson.length(); ++i) {
                JSONObject rec = arrayJson.getJSONObject(i);
                ret = rec.get("n_volume").toString();
            }
        }
        return ret;
    }

    public String getNrPaginaLibroSoci(String codice_socio) throws JSONException {
        String ret = "";
        ArrayList<String> tipoSQL = new ArrayList<String>();
        ArrayList<String> strSQL = new ArrayList<String>();
        ArrayList<Integer> lenghtBidimensionalArray = new ArrayList<Integer>();
        ArrayList<Boolean> lastID = new ArrayList<Boolean>();
        String data_select = "";
        lastID.add(false);
        String str = "SELECT IFNULL(n_pagina,'') AS n_pagina \nFROM f_socio_libro AS a WHERE codice_socio='" + codice_socio + "' AND azienda='" + FXMLDocumentController.GLOBAL_AZIENDA + "' AND sotto_az='" + FXMLDocumentController.GLOBAL_SOTTOAZZ + "' AND icqrf='" + FXMLDocumentController.GLOBAL_ICQRF + "'";
        strSQL.add(str);
        tipoSQL.add("select");
        lenghtBidimensionalArray.add(0);
        String strJson = this.util.makeStringJsonDB("OFF", tipoSQL, strSQL, null, null, lastID, lenghtBidimensionalArray);
        data_select = this.sk1Comm.ServerEsecuteRequest(FXMLDocumentController.GLOBAL_IP, FXMLDocumentController.GLOBAL_PORT, "dbInteraction#@" + strJson);
        if (!data_select.contains("#ERR:")) {
            JSONArray arrayJson = this.jsonUtil.strJsonToJSONArray(data_select);
            for (int i = 0; i < arrayJson.length(); ++i) {
                JSONObject rec = arrayJson.getJSONObject(i);
                ret = rec.get("n_pagina").toString();
            }
        }
        return ret;
    }

    public String getCodiceVinificazioneAutomatica(String padre) throws JSONException {
        JSONArray arrayJson;
        String ret = "";
        switch (padre) {
            case "01": {
                padre = "UVA";
                break;
            }
            case "16": {
                padre = "VIN";
                break;
            }
            case "15": {
                padre = "FEC";
                break;
            }
            case "18": {
                padre = "RAS";
                break;
            }
            case "21": {
                padre = "VSF";
                break;
            }
            case "23": {
                padre = "VNF";
                break;
            }
            case "08": {
                padre = "MPF";
                break;
            }
            case "41": {
                padre = "MOS";
                break;
            }
            case "07": {
                padre = "MSK";
            }
        }
        ArrayList<String> tipoSQL = new ArrayList<String>();
        ArrayList<String> strSQL = new ArrayList<String>();
        ArrayList<Integer> lenghtBidimensionalArray = new ArrayList<Integer>();
        ArrayList<Boolean> lastID = new ArrayList<Boolean>();
        String data_select = "";
        String str = "";
        tipoSQL = new ArrayList();
        strSQL = new ArrayList();
        lenghtBidimensionalArray = new ArrayList();
        lastID = new ArrayList();
        boolean exist = false;
        lastID.add(false);
        str = "SELECT IFNULL(padre,'') AS padre FROM table_codgenerator WHERE  padre='" + padre + "' AND azienda='" + FXMLDocumentController.GLOBAL_AZIENDA + "' AND sotto_az='" + FXMLDocumentController.GLOBAL_SOTTOAZZ + "' AND icqrf='" + FXMLDocumentController.GLOBAL_ICQRF + "' AND cod_committente='" + FXMLDocumentController.GLOBAL_CODCOMM + "' ;";
        strSQL.add(str);
        tipoSQL.add("selectRS");
        lenghtBidimensionalArray.add(0);
        String strJson = this.util.makeStringJsonDB("OFF", tipoSQL, strSQL, null, null, lastID, lenghtBidimensionalArray);
        data_select = this.sk1Comm.ServerEsecuteRequest(FXMLDocumentController.GLOBAL_IP, FXMLDocumentController.GLOBAL_PORT, "dbInteraction#@" + strJson);
        if (!data_select.contains("#ERR:") && (arrayJson = this.jsonUtil.strJsonToJSONArray(data_select)).length() > 0) {
            exist = true;
        }
        if (!exist) {
            tipoSQL = new ArrayList();
            strSQL = new ArrayList();
            lenghtBidimensionalArray = new ArrayList();
            lastID = new ArrayList();
            lastID.add(false);
            str = "INSERT INTO table_codgenerator (azienda,sotto_az,icqrf,cod_committente,padre,anno,lettera,number) VALUES ('" + FXMLDocumentController.GLOBAL_AZIENDA + "','" + FXMLDocumentController.GLOBAL_SOTTOAZZ + "','" + FXMLDocumentController.GLOBAL_ICQRF + "','" + FXMLDocumentController.GLOBAL_CODCOMM + "','" + padre + "',DATE_FORMAT(NOW(), \"%y\"),0,0); ";
            strSQL.add(str);
            tipoSQL.add("selectRS");
            lenghtBidimensionalArray.add(0);
            strJson = this.util.makeStringJsonDB("OFF", tipoSQL, strSQL, null, null, lastID, lenghtBidimensionalArray);
            data_select = this.sk1Comm.ServerEsecuteRequest(FXMLDocumentController.GLOBAL_IP, FXMLDocumentController.GLOBAL_PORT, "dbInteraction#@" + strJson);
        }
        tipoSQL = new ArrayList();
        strSQL = new ArrayList();
        lenghtBidimensionalArray = new ArrayList();
        lastID = new ArrayList();
        lastID.add(false);
        str = "SELECT padre,DATE_FORMAT(NOW(), \"%y\") AS anno,IF(lettera=26,1,IF(number=99,lettera+1,lettera)) AS lettera,LPAD(CAST(IF(number=99,1,NUMBER+1) AS CHAR),2,'0') AS number\nFROM table_codgenerator \nWHERE padre='" + padre + "' AND azienda='" + FXMLDocumentController.GLOBAL_AZIENDA + "' AND sotto_az='" + FXMLDocumentController.GLOBAL_SOTTOAZZ + "' AND icqrf='" + FXMLDocumentController.GLOBAL_ICQRF + "' AND cod_committente='" + FXMLDocumentController.GLOBAL_CODCOMM + "'  ";
        strSQL.add(str);
        tipoSQL.add("select");
        lenghtBidimensionalArray.add(0);
        strJson = this.util.makeStringJsonDB("OFF", tipoSQL, strSQL, null, null, lastID, lenghtBidimensionalArray);
        data_select = this.sk1Comm.ServerEsecuteRequest(FXMLDocumentController.GLOBAL_IP, FXMLDocumentController.GLOBAL_PORT, "dbInteraction#@" + strJson);
        if (!data_select.contains("#ERR:")) {
            arrayJson = this.jsonUtil.strJsonToJSONArray(data_select);
            for (int i = 0; i < arrayJson.length(); ++i) {
                JSONObject rec = arrayJson.getJSONObject(i);
                String padres = rec.get("padre").toString();
                String anno = rec.get("anno").toString();
                String letteras = rec.get("lettera").toString();
                if (letteras.equals("0")) {
                    letteras = "1";
                }
                String number = rec.get("number").toString();
                String lettera = this.util.getCharForNumber(Integer.parseInt(letteras));
                ret = padres + anno + lettera + number;
                tipoSQL = new ArrayList();
                strSQL = new ArrayList();
                lenghtBidimensionalArray = new ArrayList();
                lastID = new ArrayList();
                lastID.add(false);
                str = "UPDATE table_codgenerator SET anno=" + anno + ",lettera=" + letteras + ",number=" + number + " \nWHERE  padre='" + padre + "' AND azienda='" + FXMLDocumentController.GLOBAL_AZIENDA + "' AND sotto_az='" + FXMLDocumentController.GLOBAL_SOTTOAZZ + "' AND icqrf='" + FXMLDocumentController.GLOBAL_ICQRF + "' AND cod_committente='" + FXMLDocumentController.GLOBAL_CODCOMM + "' ;";
                strSQL.add(str);
                tipoSQL.add("selectRS");
                lenghtBidimensionalArray.add(0);
                strJson = this.util.makeStringJsonDB("OFF", tipoSQL, strSQL, null, null, lastID, lenghtBidimensionalArray);
                data_select = this.sk1Comm.ServerEsecuteRequest(FXMLDocumentController.GLOBAL_IP, FXMLDocumentController.GLOBAL_PORT, "dbInteraction#@" + strJson);
            }
        }
        return ret;
    }

    public String checkIfExistProdottoSianAnagraficaWBS(String sian_cat_prodotto, String sian_cod_stato_fisico, String sian_classificazione, String sian_atto_certificato, String sian_codice_dop_igp, String sian_colore, String sian_biologico, String sian_cod_ebac, String sian_origine_uve, String sian_paese, String sian_paese_provenienza, String sian_cod_zona_viticola, String sian_varieta, String sian_perc_varieta, String sian_altre_varieta, String sian_cod_sottozona, String sian_cod_vigna, String sian_menzioni, String sian_pratiche_eno, String sian_massa_volumica, String sian_annata, String sian_annata_percentuale, String sian_cod_partita_gg_inv) throws JSONException {
        String ret = "";
        ArrayList<String> tipoSQL = new ArrayList<String>();
        ArrayList<String> strSQL = new ArrayList<String>();
        ArrayList<Integer> lenghtBidimensionalArray = new ArrayList<Integer>();
        ArrayList<Boolean> lastID = new ArrayList<Boolean>();
        String data_select = "";
        lastID.add(false);
        String str = "SELECT IFNULL(c.codice,'') AS codice \nFROM gen_tipo_vino_ana AS c \nWHERE c.azienda='" + FXMLDocumentController.GLOBAL_AZIENDA + "' AND c.sotto_az='" + FXMLDocumentController.GLOBAL_SOTTOAZZ + "' AND c.icqrf='" + FXMLDocumentController.GLOBAL_ICQRF + "' AND c.cod_committente='" + FXMLDocumentController.GLOBAL_CODCOMM + "' AND c.sian_cat_prodotto='" + sian_cat_prodotto + "' \nAND c.sian_cod_stato_fisico='" + sian_cod_stato_fisico + "' AND c.sian_annata='" + sian_annata + "' AND c.sian_classificazione='" + sian_classificazione + "' AND c.sian_atto_certificato='" + sian_atto_certificato + "' AND c.sian_codice_dop_igp='" + sian_codice_dop_igp + "' \nAND c.sian_colore='" + sian_colore + "' AND c.sian_biologico='" + sian_biologico + "' AND c.sian_cod_ebac='" + sian_cod_ebac + "' AND c.sian_origine_uve='" + sian_origine_uve + "' AND c.sian_paese='" + sian_paese + "' AND c.sian_paese_provenienza='" + sian_paese_provenienza + "' AND sian_cod_zona_viticola='" + sian_cod_zona_viticola + "' \nAND c.sian_varieta='" + sian_varieta + "' AND c.sian_perc_varieta='" + sian_perc_varieta + "' AND sian_altre_varieta='" + sian_altre_varieta + "' AND c.sian_cod_sottozona='" + sian_cod_sottozona + "' \nAND c.sian_cod_vigna='" + sian_cod_vigna + "' AND c.sian_menzioni='" + sian_menzioni + "' AND  c.sian_pratiche_eno='" + sian_pratiche_eno + "' AND c.sian_massa_volumica='" + sian_massa_volumica + "' \nAND c.sian_annata_percentuale='" + sian_annata_percentuale + "' AND c.sian_cod_partita_gg_inv='" + sian_cod_partita_gg_inv + "'  ";
        strSQL.add(str);
        tipoSQL.add("select");
        lenghtBidimensionalArray.add(0);
        String strJson = this.util.makeStringJsonDB("OFF", tipoSQL, strSQL, null, null, lastID, lenghtBidimensionalArray);
        data_select = this.sk1Comm.ServerEsecuteRequest(FXMLDocumentController.GLOBAL_IP, FXMLDocumentController.GLOBAL_PORT, "dbInteraction#@" + strJson);
        if (!data_select.contains("#ERR:")) {
            JSONArray arrayJson = this.jsonUtil.strJsonToJSONArray(data_select);
            for (int i = 0; i < arrayJson.length(); ++i) {
                JSONObject rec = arrayJson.getJSONObject(i);
                ret = rec.get("codice").toString();
            }
        }
        return ret;
    }

    public String getCodCommittenteFromInviiiEff(String id_trasmissione, String numero_progressivo, String data_oper) throws JSONException {
        String ret = "";
        ArrayList<String> tipoSQL = new ArrayList<String>();
        ArrayList<String> strSQL = new ArrayList<String>();
        ArrayList<Integer> lenghtBidimensionalArray = new ArrayList<Integer>();
        ArrayList<Boolean> lastID = new ArrayList<Boolean>();
        String data_select = "";
        lastID.add(false);
        String str = "SELECT IF(IFNULL(cod_committente,'')='','',CONCAT(cod_committente,' - ',b.rag_soc)) AS cod_committente \nFROM(\nSELECT c.cod_committente,c.azienda,c.sotto_az\nFROM gen_t_invii AS a \nLEFT JOIN gen_t_invii_opers AS b ON a.id_trasmissione=b.id_trasmissione\nLEFT JOIN c_operazioni AS c ON b.id_oper=c.id\nWHERE a.id_trasmissione='" + id_trasmissione + "'  AND c.invio_sian_id='" + numero_progressivo + "' AND c.data_oper='" + data_oper + "' \n) AS a LEFT JOIN gen_ana_clifor AS b ON a.azienda=b.azienda AND a.sotto_az=b.sotto_az AND a.cod_committente=b.codice  ";
        strSQL.add(str);
        tipoSQL.add("select");
        lenghtBidimensionalArray.add(0);
        String strJson = this.util.makeStringJsonDB("OFF", tipoSQL, strSQL, null, null, lastID, lenghtBidimensionalArray);
        data_select = this.sk1Comm.ServerEsecuteRequest(FXMLDocumentController.GLOBAL_IP, FXMLDocumentController.GLOBAL_PORT, "dbInteraction#@" + strJson);
        if (!data_select.contains("#ERR:")) {
            JSONArray arrayJson = this.jsonUtil.strJsonToJSONArray(data_select);
            for (int i = 0; i < arrayJson.length(); ++i) {
                JSONObject rec = arrayJson.getJSONObject(i);
                ret = rec.get("cod_committente").toString();
            }
        }
        return ret;
    }

    public String getCodiceIdentificativo7a(String codice, String azienda, String sotto_az) throws JSONException {
        String ret = "";
        ArrayList<String> tipoSQL = new ArrayList<String>();
        ArrayList<String> strSQL = new ArrayList<String>();
        ArrayList<Integer> lenghtBidimensionalArray = new ArrayList<Integer>();
        ArrayList<Boolean> lastID = new ArrayList<Boolean>();
        String data_select = "";
        lastID.add(false);
        String str = " SELECT IFNULL(codice_identificativo7a,'') AS codice_identificativo7a  FROM v01.gen_ana_clifor  \n WHERE azienda='" + azienda + "' AND sotto_az='" + sotto_az + "' AND codice='" + codice + "'  ";
        strSQL.add(str);
        tipoSQL.add("select");
        lenghtBidimensionalArray.add(0);
        String strJson = this.util.makeStringJsonDB("OFF", tipoSQL, strSQL, null, null, lastID, lenghtBidimensionalArray);
        data_select = this.sk1Comm.ServerEsecuteRequest(FXMLDocumentController.GLOBAL_IP, FXMLDocumentController.GLOBAL_PORT, "dbInteraction#@" + strJson);
        if (!data_select.contains("#ERR:")) {
            JSONArray arrayJson = this.jsonUtil.strJsonToJSONArray(data_select);
            for (int i = 0; i < arrayJson.length(); ++i) {
                JSONObject rec = arrayJson.getJSONObject(i);
                ret = rec.get("codice_identificativo7a").toString();
            }
        }
        return ret;
    }

    public String getTipoGarantiDefault(String azienda, String sotto_az, String cod_accisa) throws JSONException {
        String ret = "";
        ArrayList<String> tipoSQL = new ArrayList<String>();
        ArrayList<String> strSQL = new ArrayList<String>();
        ArrayList<Integer> lenghtBidimensionalArray = new ArrayList<Integer>();
        ArrayList<Boolean> lastID = new ArrayList<Boolean>();
        String data_select = "";
        lastID.add(false);
        String str = "SELECT a.id,a.azienda,a.sotto_az,a.cod_accisa,a.mx_nmag AS magazzino,a.descrizione,piva_u_autorizzato,codice_ufficio,codice_contogaranzia,postazione_abilitata,numero_registro,anno_registro,codice_u_autorizzato,password,path_certfirma,IFNULL(tipo_reg,'') AS tipo_reg,utente_on,password_on,causale_mov,tipo_destinazione,responsabile_trasp,unita_trasp,durata_trasp,codice_modalitatrap,garac_tipologiagara,IFNULL(codice_tipgaranti,0) AS codice_tipgaranti FROM gen_t_accise_mxmag AS a WHERE azienda='" + azienda + "' AND sotto_az='" + sotto_az + "' AND cod_accisa='" + cod_accisa + "'";
        strSQL.add(str);
        tipoSQL.add("select");
        lenghtBidimensionalArray.add(0);
        String strJson = this.util.makeStringJsonDB("OFF", tipoSQL, strSQL, null, null, lastID, lenghtBidimensionalArray);
        data_select = this.sk1Comm.ServerEsecuteRequest(FXMLDocumentController.GLOBAL_IP, FXMLDocumentController.GLOBAL_PORT, "dbInteraction#@" + strJson);
        if (!data_select.contains("#ERR:")) {
            JSONArray arrayJson = this.jsonUtil.strJsonToJSONArray(data_select);
            for (int i = 0; i < arrayJson.length(); ++i) {
                JSONObject rec = arrayJson.getJSONObject(i);
                ret = rec.get("codice_tipgaranti").toString();
            }
        }
        return ret;
    }

    public String getPesoLordoAccise(String azienda, String sotto_az, String cod_accisa, String codice) throws JSONException {
        String ret = "0";
        ArrayList<String> tipoSQL = new ArrayList<String>();
        ArrayList<String> strSQL = new ArrayList<String>();
        ArrayList<Integer> lenghtBidimensionalArray = new ArrayList<Integer>();
        ArrayList<Boolean> lastID = new ArrayList<Boolean>();
        String data_select = "";
        lastID.add(false);
        String str = "SELECT peso_lordo FROM gen_ana_accise_articoli AS a WHERE azienda='" + azienda + "' AND sotto_az='" + sotto_az + "' AND cod_accisa='" + cod_accisa + "' AND codice='" + codice + "' ";
        strSQL.add(str);
        tipoSQL.add("select");
        lenghtBidimensionalArray.add(0);
        String strJson = this.util.makeStringJsonDB("OFF", tipoSQL, strSQL, null, null, lastID, lenghtBidimensionalArray);
        data_select = this.sk1Comm.ServerEsecuteRequest(FXMLDocumentController.GLOBAL_IP, FXMLDocumentController.GLOBAL_PORT, "dbInteraction#@" + strJson);
        if (!data_select.contains("#ERR:")) {
            JSONArray arrayJson = this.jsonUtil.strJsonToJSONArray(data_select);
            for (int i = 0; i < arrayJson.length(); ++i) {
                JSONObject rec = arrayJson.getJSONObject(i);
                ret = rec.get("peso_lordo").toString();
            }
        }
        return ret;
    }

    public String getPesoNettoAccise(String azienda, String sotto_az, String cod_accisa, String codice) throws JSONException {
        String ret = "0";
        ArrayList<String> tipoSQL = new ArrayList<String>();
        ArrayList<String> strSQL = new ArrayList<String>();
        ArrayList<Integer> lenghtBidimensionalArray = new ArrayList<Integer>();
        ArrayList<Boolean> lastID = new ArrayList<Boolean>();
        String data_select = "";
        lastID.add(false);
        String str = "SELECT peso_netto FROM gen_ana_accise_articoli AS a WHERE azienda='" + azienda + "' AND sotto_az='" + sotto_az + "' AND cod_accisa='" + cod_accisa + "' AND codice='" + codice + "' ";
        strSQL.add(str);
        tipoSQL.add("select");
        lenghtBidimensionalArray.add(0);
        String strJson = this.util.makeStringJsonDB("OFF", tipoSQL, strSQL, null, null, lastID, lenghtBidimensionalArray);
        data_select = this.sk1Comm.ServerEsecuteRequest(FXMLDocumentController.GLOBAL_IP, FXMLDocumentController.GLOBAL_PORT, "dbInteraction#@" + strJson);
        if (!data_select.contains("#ERR:")) {
            JSONArray arrayJson = this.jsonUtil.strJsonToJSONArray(data_select);
            for (int i = 0; i < arrayJson.length(); ++i) {
                JSONObject rec = arrayJson.getJSONObject(i);
                ret = rec.get("peso_netto").toString();
            }
        }
        return ret;
    }

    public boolean controlloCodiceCommittenteExist(String azienda, String sotto_az, String icqrf, String codice) throws JSONException {
        boolean ret = false;
        ArrayList<String> tipoSQL = new ArrayList<String>();
        ArrayList<String> strSQL = new ArrayList<String>();
        ArrayList<Integer> lenghtBidimensionalArray = new ArrayList<Integer>();
        ArrayList<Boolean> lastID = new ArrayList<Boolean>();
        String data_select = "";
        lastID.add(false);
        String str = "SELECT IFNULL(COUNT(id),0) AS countr FROM gen_tipo_vino_ana WHERE codice='" + codice + "'  ";
        strSQL.add(str);
        tipoSQL.add("select");
        lenghtBidimensionalArray.add(0);
        String strJson = this.util.makeStringJsonDB("OFF", tipoSQL, strSQL, null, null, lastID, lenghtBidimensionalArray);
        data_select = this.sk1Comm.ServerEsecuteRequest(FXMLDocumentController.GLOBAL_IP, FXMLDocumentController.GLOBAL_PORT, "dbInteraction#@" + strJson);
        if (!data_select.contains("#ERR:")) {
            JSONArray arrayJson = this.jsonUtil.strJsonToJSONArray(data_select);
            for (int i = 0; i < arrayJson.length(); ++i) {
                JSONObject rec = arrayJson.getJSONObject(i);
                int countr = rec.getInt("countr");
                if (countr <= 1) continue;
                ret = true;
            }
        }
        return ret;
    }

    public boolean controlloCodiceCommittenteExistMagazzino(String azienda, String sotto_az, String icqrf, String cod_committente, String codice) throws JSONException {
        boolean ret = false;
        ArrayList<String> tipoSQL = new ArrayList<String>();
        ArrayList<String> strSQL = new ArrayList<String>();
        ArrayList<Integer> lenghtBidimensionalArray = new ArrayList<Integer>();
        ArrayList<Boolean> lastID = new ArrayList<Boolean>();
        String data_select = "";
        lastID.add(false);
        String str = "SELECT IFNULL(COUNT(id),0) AS countr FROM gen_tipo_vino_ana WHERE codice='" + codice + "' AND azienda='" + azienda + "' AND sotto_az='" + sotto_az + "' AND icqrf='" + icqrf + "' AND cod_committente='" + cod_committente + "' ";
        strSQL.add(str);
        tipoSQL.add("select");
        lenghtBidimensionalArray.add(0);
        String strJson = this.util.makeStringJsonDB("OFF", tipoSQL, strSQL, null, null, lastID, lenghtBidimensionalArray);
        data_select = this.sk1Comm.ServerEsecuteRequest(FXMLDocumentController.GLOBAL_IP, FXMLDocumentController.GLOBAL_PORT, "dbInteraction#@" + strJson);
        if (!data_select.contains("#ERR:")) {
            JSONArray arrayJson = this.jsonUtil.strJsonToJSONArray(data_select);
            for (int i = 0; i < arrayJson.length(); ++i) {
                JSONObject rec = arrayJson.getJSONObject(i);
                int countr = rec.getInt("countr");
                if (countr <= 0) continue;
                ret = true;
            }
        }
        return ret;
    }

    public List<String> getMagazziniFromIcqrf(String azienda, String sotto_az, String icqrf, String cod_committente) throws JSONException {
        ArrayList<String> ret = new ArrayList<String>();
        ArrayList<String> tipoSQL = new ArrayList<String>();
        ArrayList<String> strSQL = new ArrayList<String>();
        ArrayList<Integer> lenghtBidimensionalArray = new ArrayList<Integer>();
        ArrayList<Boolean> lastID = new ArrayList<Boolean>();
        String data_select = "";
        lastID.add(false);
        String str = "SELECT cod_committente FROM gen_t_icqrf_mxmag WHERE  azienda='" + azienda + "' AND sotto_az='" + sotto_az + "' AND icqrf='" + icqrf + "'";
        strSQL.add(str);
        tipoSQL.add("select");
        lenghtBidimensionalArray.add(0);
        String strJson = this.util.makeStringJsonDB("OFF", tipoSQL, strSQL, null, null, lastID, lenghtBidimensionalArray);
        data_select = this.sk1Comm.ServerEsecuteRequest(FXMLDocumentController.GLOBAL_IP, FXMLDocumentController.GLOBAL_PORT, "dbInteraction#@" + strJson);
        if (!data_select.contains("#ERR:")) {
            JSONArray arrayJson = this.jsonUtil.strJsonToJSONArray(data_select);
            for (int i = 0; i < arrayJson.length(); ++i) {
                JSONObject rec = arrayJson.getJSONObject(i);
                String c = rec.get("cod_committente").toString();
                ret.add(c);
            }
        }
        return ret;
    }

    public boolean aggiornaProdottoSuTuttoDB(String azienda, String sotto_az, String icqrf, String codice, String descrizione, String sian_cat_prodotto, String sian_cod_stato_fisico, String sian_annata, String sian_classificazione, String sian_atto_certificato, String sian_codice_dop_igp, String sian_colore, String sian_biologico, String sian_cod_ebac, String sian_origine_uve, String sian_paese, String sian_paese_provenienza, String sian_cod_zona_viticola, String sian_varieta, String sian_perc_varieta, String sian_altre_varieta, String sian_cod_sottozona, String sian_cod_vigna, String sian_menzioni, String sian_pratiche_eno, String sian_massa_volumica, String sian_annata_percentuale, String sian_volume_nominale, String sian_cod_partita_gg_inv, String altre_raspi, String altre_vinacce, String altre_cali_uva, String altre_cali_mosto, String sian_metodo_pratica_eno, ObservableList<ColumnTableSearchComponenteMexal> lista_table_search_art_mexal) throws JSONException {
        boolean ret = false;
        ArrayList<String> tipoSQL = new ArrayList<String>();
        ArrayList<String> strSQL = new ArrayList<String>();
        ArrayList<Integer> lenghtBidimensionalArray = new ArrayList<Integer>();
        ArrayList<Boolean> lastID = new ArrayList<Boolean>();
        String data_select = "";
        lastID.add(false);
        String str = "SELECT  cod_committente,IFNULL(a.altre_raspi,0) AS altre_raspi,IFNULL(a.altre_vinacce,0) AS altre_vinacce,a.id,a.sian_perc_varieta,a.codice,a.descrizione,a.sian_cat_prodotto,a.sian_cod_stato_fisico,a.sian_annata,a.sian_classificazione,a.sian_atto_certificato,a.sian_codice_dop_igp,a.sian_percentuale_igp,a.sian_colore,a.sian_biologico,a.sian_cod_ebac,a.sian_origine_uve,a.sian_paese,a.sian_paese_provenienza,a.sian_cod_zona_viticola,a.sian_varieta,a.sian_altre_varieta,a.sian_cod_sottozona,a.sian_cod_vigna,a.sian_menzioni,a.sian_cod_tenore_zuccherino,a.sian_pratiche_eno,a.sian_metodo_pratica_eno,a.sian_massa_volumica,a.sian_annata_percentuale,a.sian_volume_nominale,a.sian_cod_partita_gg_inv FROM gen_tipo_vino_ana AS a WHERE codice='" + codice + "' AND cod_committente<>'' ";
        strSQL.add(str);
        tipoSQL.add("select");
        lenghtBidimensionalArray.add(0);
        String strJson = this.util.makeStringJsonDB("OFF", tipoSQL, strSQL, null, null, lastID, lenghtBidimensionalArray);
        data_select = this.sk1Comm.ServerEsecuteRequest(FXMLDocumentController.GLOBAL_IP, FXMLDocumentController.GLOBAL_PORT, "dbInteraction#@" + strJson);
        if (!data_select.contains("#ERR:")) {
            JSONArray arrayJson = this.jsonUtil.strJsonToJSONArray(data_select);
            ArrayList<String> tipoSQLs = new ArrayList<String>();
            ArrayList<String> strSQLs = new ArrayList<String>();
            ArrayList<Integer> lenghtBidimensionalArrays = new ArrayList<Integer>();
            ArrayList<Boolean> lastIDs = new ArrayList<Boolean>();
            int iterator = 0;
            String[][] tipo_ins = null;
            String[][] valore = null;
            HashMap<Integer, String[]> ipos = new HashMap<Integer, String[]>();
            HashMap<Integer, String[]> alores = new HashMap<Integer, String[]>();
            String[] res = new String[1];
            for (int i = 0; i < arrayJson.length(); ++i) {
                JSONObject rec = arrayJson.getJSONObject(i);
                String id = rec.get("id").toString();
                String cod_committente = rec.get("cod_committente").toString();
                FXMLDocumentController.sqlUtil.update_gen_tipo_vino_ana(id, azienda, sotto_az, icqrf, cod_committente, descrizione, sian_cat_prodotto, sian_cod_stato_fisico, sian_annata, sian_classificazione, sian_atto_certificato, sian_codice_dop_igp, sian_colore, sian_biologico, sian_cod_ebac, sian_origine_uve, sian_paese, sian_paese_provenienza, sian_cod_zona_viticola, sian_varieta, sian_perc_varieta, sian_altre_varieta, sian_cod_sottozona, sian_cod_vigna, sian_menzioni, sian_pratiche_eno, sian_massa_volumica, sian_annata_percentuale, sian_volume_nominale, sian_cod_partita_gg_inv, altre_raspi, altre_vinacce, altre_cali_uva, altre_cali_mosto, sian_metodo_pratica_eno);
                strSQLs.addAll(FXMLDocumentController.sqlUtil.strSQL);
                tipoSQLs.addAll(FXMLDocumentController.sqlUtil.tipoinsSQL);
                lenghtBidimensionalArrays.addAll(FXMLDocumentController.sqlUtil.lengthSQL);
                lastIDs.addAll(FXMLDocumentController.sqlUtil.lastID);
                ipos.put(iterator, FXMLDocumentController.sqlUtil.tipovaloreSQL.toArray(new String[0]));
                alores.put(iterator, FXMLDocumentController.sqlUtil.valoreSQL.toArray(new String[0]));
                ++iterator;
                FXMLDocumentController.sqlUtil.delete_gen_tipo_vino_ana_mxFromidTesta(id);
                strSQLs.addAll(FXMLDocumentController.sqlUtil.strSQL);
                tipoSQLs.addAll(FXMLDocumentController.sqlUtil.tipoinsSQL);
                lenghtBidimensionalArrays.addAll(FXMLDocumentController.sqlUtil.lengthSQL);
                lastIDs.addAll(FXMLDocumentController.sqlUtil.lastID);
                ipos.put(iterator, FXMLDocumentController.sqlUtil.tipovaloreSQL.toArray(new String[0]));
                alores.put(iterator, FXMLDocumentController.sqlUtil.valoreSQL.toArray(new String[0]));
                ++iterator;
                for (int ui = 0; ui < lista_table_search_art_mexal.size(); ++ui) {
                    String codicex = ((ColumnTableSearchComponenteMexal)lista_table_search_art_mexal.get(ui)).getColumn_codice();
                    String descrx = ((ColumnTableSearchComponenteMexal)lista_table_search_art_mexal.get(ui)).getColumn_descrizione();
                    String ivax = ((ColumnTableSearchComponenteMexal)lista_table_search_art_mexal.get(ui)).getColumn_iva();
                    String umx = ((ColumnTableSearchComponenteMexal)lista_table_search_art_mexal.get(ui)).getColumn_um();
                    String codaltx = ((ColumnTableSearchComponenteMexal)lista_table_search_art_mexal.get(ui)).getColumn_codalt();
                    FXMLDocumentController.sqlUtil.insert_gen_tipo_vino_ana_mx(FXMLDocumentController.GLOBAL_AZIENDA, FXMLDocumentController.GLOBAL_SOTTOAZZ, id, codicex, descrx, ivax, umx, codaltx, FXMLDocumentController.GLOBAL_ICQRF, cod_committente);
                    strSQLs.addAll(FXMLDocumentController.sqlUtil.strSQL);
                    tipoSQLs.addAll(FXMLDocumentController.sqlUtil.tipoinsSQL);
                    lenghtBidimensionalArrays.addAll(FXMLDocumentController.sqlUtil.lengthSQL);
                    lastIDs.addAll(FXMLDocumentController.sqlUtil.lastID);
                    ipos.put(iterator, FXMLDocumentController.sqlUtil.tipovaloreSQL.toArray(new String[0]));
                    alores.put(iterator, FXMLDocumentController.sqlUtil.valoreSQL.toArray(new String[0]));
                    ++iterator;
                }
                ipos.put(iterator, FXMLDocumentController.sqlUtil.tipovaloreSQL.toArray(new String[0]));
                alores.put(iterator, FXMLDocumentController.sqlUtil.valoreSQL.toArray(new String[0]));
                ++iterator;
                if (ipos.size() <= 0) continue;
                tipo_ins = this.util.HashMapBidimensionalTOArrayBidimensional(ipos);
                valore = this.util.HashMapBidimensionalTOArrayBidimensional(alores);
                strJson = this.util.makeStringJsonDB("OFF", tipoSQLs, strSQLs, tipo_ins, valore, lastIDs, lenghtBidimensionalArrays);
                data_select = this.sk1Comm.ServerEsecuteRequest(FXMLDocumentController.GLOBAL_IP, FXMLDocumentController.GLOBAL_PORT, "dbInteraction#@" + strJson);
                if (data_select.contains("#ERR:")) continue;
                ipos.clear();
                alores.clear();
                strSQLs.clear();
                tipoSQLs.clear();
                lastIDs.clear();
                lenghtBidimensionalArrays.clear();
                iterator = 0;
            }
            FXMLDocumentController.sqlUtil.insert_logger(azienda, sotto_az, "INSERIMENTO ARTICOLO SU TUTTI COMMITTENTI DA MODIFICA PRODOTTO", LocalDate.now().toString(), LocalTime.now().toString(), FXMLDocumentController.GLOBAL_UTENTE.toUpperCase(), "FUNZ_MODCREA_ART_SU_COMM");
            strSQLs.addAll(FXMLDocumentController.sqlUtil.strSQL);
            tipoSQLs.addAll(FXMLDocumentController.sqlUtil.tipoinsSQL);
            lenghtBidimensionalArrays.addAll(FXMLDocumentController.sqlUtil.lengthSQL);
            lastIDs.addAll(FXMLDocumentController.sqlUtil.lastID);
            ipos.put(iterator, FXMLDocumentController.sqlUtil.tipovaloreSQL.toArray(new String[0]));
            alores.put(iterator, FXMLDocumentController.sqlUtil.valoreSQL.toArray(new String[0]));
            ++iterator;
            if (ipos.size() > 0) {
                tipo_ins = this.util.HashMapBidimensionalTOArrayBidimensional(ipos);
                valore = this.util.HashMapBidimensionalTOArrayBidimensional(alores);
                strJson = this.util.makeStringJsonDB("OFF", tipoSQLs, strSQLs, tipo_ins, valore, lastIDs, lenghtBidimensionalArrays);
                data_select = this.sk1Comm.ServerEsecuteRequest(FXMLDocumentController.GLOBAL_IP, FXMLDocumentController.GLOBAL_PORT, "dbInteraction#@" + strJson);
                if (!data_select.contains("#ERR:")) {
                    // empty if block
                }
            }
        }
        return ret;
    }

    public boolean inserisciProdottoSuTuttoDB(String azienda, String sotto_az, String icqrf, String cod_committente, String codice, String descrizione, String sian_cat_prodotto, String sian_cod_stato_fisico, String sian_annata, String sian_classificazione, String sian_atto_certificato, String sian_codice_dop_igp, String sian_colore, String sian_biologico, String sian_cod_ebac, String sian_origine_uve, String sian_paese, String sian_paese_provenienza, String sian_cod_zona_viticola, String sian_varieta, String sian_perc_varieta, String sian_altre_varieta, String sian_cod_sottozona, String sian_cod_vigna, String sian_menzioni, String sian_pratiche_eno, String sian_massa_volumica, String sian_annata_percentuale, String sian_volume_nominale, String sian_cod_partita_gg_inv, String altre_raspi, String altre_vinacce, String altre_cali_uva, String altre_cali_mosto, String sian_metodo_pratica_eno, ObservableList<ColumnTableSearchComponenteMexal> lista_table_search_art_mexal) throws JSONException {
        boolean ret = false;
        ArrayList<String> tipoSQLs = new ArrayList<String>();
        ArrayList<String> strSQLs = new ArrayList<String>();
        ArrayList<Integer> lenghtBidimensionalArrays = new ArrayList<Integer>();
        ArrayList<Boolean> lastIDs = new ArrayList<Boolean>();
        int iterator = 0;
        String[][] tipo_ins = null;
        String[][] valore = null;
        HashMap<Integer, String[]> ipos = new HashMap<Integer, String[]>();
        HashMap<Integer, String[]> alores = new HashMap<Integer, String[]>();
        String[] res = new String[]{""};
        List<String> committenti = this.getCodiciCommittente(FXMLDocumentController.GLOBAL_ICQRF);
        FXMLDocumentController.sqlUtil.insert_gen_tipo_vino_ana("", azienda, sotto_az, icqrf, cod_committente, codice, descrizione, sian_cat_prodotto, sian_cod_stato_fisico, sian_annata, sian_classificazione, sian_atto_certificato, sian_codice_dop_igp, sian_colore, sian_biologico, sian_cod_ebac, sian_origine_uve, sian_paese, sian_paese_provenienza, sian_cod_zona_viticola, sian_varieta, sian_perc_varieta, sian_altre_varieta, sian_cod_sottozona, sian_cod_vigna, sian_menzioni, sian_pratiche_eno, sian_massa_volumica, sian_annata_percentuale, sian_volume_nominale, sian_cod_partita_gg_inv, altre_raspi, altre_vinacce, altre_cali_uva, altre_cali_mosto, sian_metodo_pratica_eno, altre_raspi, altre_vinacce);
        strSQLs.addAll(FXMLDocumentController.sqlUtil.strSQL);
        tipoSQLs.addAll(FXMLDocumentController.sqlUtil.tipoinsSQL);
        lenghtBidimensionalArrays.addAll(FXMLDocumentController.sqlUtil.lengthSQL);
        lastIDs.addAll(FXMLDocumentController.sqlUtil.lastID);
        ipos.put(iterator, FXMLDocumentController.sqlUtil.tipovaloreSQL.toArray(new String[0]));
        alores.put(iterator, FXMLDocumentController.sqlUtil.valoreSQL.toArray(new String[0]));
        ++iterator;
        lastIDs.add(false);
        tipoSQLs.add("insert");
        strSQLs.add("SET @id_oper:=(LAST_INSERT_ID());");
        lenghtBidimensionalArrays.add(0);
        ipos.put(iterator, res);
        alores.put(iterator, res);
        ++iterator;
        for (int ui = 0; ui < lista_table_search_art_mexal.size(); ++ui) {
            String codicex = ((ColumnTableSearchComponenteMexal)lista_table_search_art_mexal.get(ui)).getColumn_codice();
            String descrx = ((ColumnTableSearchComponenteMexal)lista_table_search_art_mexal.get(ui)).getColumn_descrizione();
            String ivax = ((ColumnTableSearchComponenteMexal)lista_table_search_art_mexal.get(ui)).getColumn_iva();
            String umx = ((ColumnTableSearchComponenteMexal)lista_table_search_art_mexal.get(ui)).getColumn_um();
            String codaltx = ((ColumnTableSearchComponenteMexal)lista_table_search_art_mexal.get(ui)).getColumn_codalt();
            FXMLDocumentController.sqlUtil.insert_gen_tipo_vino_ana_mx(FXMLDocumentController.GLOBAL_AZIENDA, FXMLDocumentController.GLOBAL_SOTTOAZZ, "@id_oper", codicex, descrx, ivax, umx, codaltx, FXMLDocumentController.GLOBAL_ICQRF, cod_committente);
            strSQLs.addAll(FXMLDocumentController.sqlUtil.strSQL);
            tipoSQLs.addAll(FXMLDocumentController.sqlUtil.tipoinsSQL);
            lenghtBidimensionalArrays.addAll(FXMLDocumentController.sqlUtil.lengthSQL);
            lastIDs.addAll(FXMLDocumentController.sqlUtil.lastID);
            ipos.put(iterator, FXMLDocumentController.sqlUtil.tipovaloreSQL.toArray(new String[0]));
            alores.put(iterator, FXMLDocumentController.sqlUtil.valoreSQL.toArray(new String[0]));
            ++iterator;
        }
        FXMLDocumentController.sqlUtil.insert_logger(azienda, sotto_az, "INSERIMENTO ARTICOLO SU TUTTI COMMITTENTI DA CREA PRODOTTO " + codice + " COMM." + cod_committente, LocalDate.now().toString(), LocalTime.now().toString(), FXMLDocumentController.GLOBAL_UTENTE.toUpperCase(), "FUNZ_CREA_ART_SU_COMM");
        strSQLs.addAll(FXMLDocumentController.sqlUtil.strSQL);
        tipoSQLs.addAll(FXMLDocumentController.sqlUtil.tipoinsSQL);
        lenghtBidimensionalArrays.addAll(FXMLDocumentController.sqlUtil.lengthSQL);
        lastIDs.addAll(FXMLDocumentController.sqlUtil.lastID);
        ipos.put(iterator, FXMLDocumentController.sqlUtil.tipovaloreSQL.toArray(new String[0]));
        alores.put(iterator, FXMLDocumentController.sqlUtil.valoreSQL.toArray(new String[0]));
        ++iterator;
        if (ipos.size() > 0) {
            tipo_ins = this.util.HashMapBidimensionalTOArrayBidimensional(ipos);
            valore = this.util.HashMapBidimensionalTOArrayBidimensional(alores);
            String strJson = this.util.makeStringJsonDB("ON", tipoSQLs, strSQLs, tipo_ins, valore, lastIDs, lenghtBidimensionalArrays);
            String data_select = this.sk1Comm.ServerEsecuteRequest(FXMLDocumentController.GLOBAL_IP, FXMLDocumentController.GLOBAL_PORT, "dbInteraction#@" + strJson);
            if (!data_select.contains("#ERR:")) {
                ret = true;
            }
        }
        return ret;
    }

    public boolean getIfChiusuraNeverWBS(String azienda, String sotto_az, String icqrf) throws JSONException {
        boolean ret = false;
        ArrayList<String> tipoSQL = new ArrayList<String>();
        ArrayList<String> strSQL = new ArrayList<String>();
        ArrayList<Integer> lenghtBidimensionalArray = new ArrayList<Integer>();
        ArrayList<Boolean> lastID = new ArrayList<Boolean>();
        String data_select = "";
        lastID.add(false);
        String str = "SELECT IFNULL(COUNT(id),0) AS id FROM gen_t_chiusurewbs WHERE azienda='" + azienda + "' AND sotto_az='" + sotto_az + "' AND icqrf='" + icqrf + "' ";
        strSQL.add(str);
        tipoSQL.add("select");
        lenghtBidimensionalArray.add(0);
        String strJson = this.util.makeStringJsonDB("OFF", tipoSQL, strSQL, null, null, lastID, lenghtBidimensionalArray);
        data_select = this.sk1Comm.ServerEsecuteRequest(FXMLDocumentController.GLOBAL_IP, FXMLDocumentController.GLOBAL_PORT, "dbInteraction#@" + strJson);
        if (!data_select.contains("#ERR:")) {
            JSONArray arrayJson = this.jsonUtil.strJsonToJSONArray(data_select);
            for (int i = 0; i < arrayJson.length(); ++i) {
                JSONObject rec = arrayJson.getJSONObject(i);
                String id = rec.get("id").toString();
                if (Double.parseDouble(id) != 0.0) continue;
                ret = true;
            }
        }
        return ret;
    }

    public boolean getIfChiusuraPrima(String azienda, String sotto_az, String icqrf) throws JSONException {
        boolean ret = false;
        ArrayList<String> tipoSQL = new ArrayList<String>();
        ArrayList<String> strSQL = new ArrayList<String>();
        ArrayList<Integer> lenghtBidimensionalArray = new ArrayList<Integer>();
        ArrayList<Boolean> lastID = new ArrayList<Boolean>();
        String data_select = "";
        lastID.add(false);
        String str = "SELECT IFNULL(COUNT(id),0) AS id FROM gen_t_chiusuragiacenze WHERE azienda='" + azienda + "' AND sotto_az='" + sotto_az + "' AND icqrf='" + icqrf + "' ";
        strSQL.add(str);
        tipoSQL.add("select");
        lenghtBidimensionalArray.add(0);
        String strJson = this.util.makeStringJsonDB("OFF", tipoSQL, strSQL, null, null, lastID, lenghtBidimensionalArray);
        data_select = this.sk1Comm.ServerEsecuteRequest(FXMLDocumentController.GLOBAL_IP, FXMLDocumentController.GLOBAL_PORT, "dbInteraction#@" + strJson);
        if (!data_select.contains("#ERR:")) {
            JSONArray arrayJson = this.jsonUtil.strJsonToJSONArray(data_select);
            for (int i = 0; i < arrayJson.length(); ++i) {
                JSONObject rec = arrayJson.getJSONObject(i);
                String id = rec.get("id").toString();
                if (!(Double.parseDouble(id) > 0.0)) continue;
                ret = true;
            }
        }
        return ret;
    }

    public boolean getIfChiusuraExist(String azienda, String sotto_az, String icqrf, String dadata, String adata) throws JSONException {
        boolean ret = false;
        ArrayList<String> tipoSQL = new ArrayList<String>();
        ArrayList<String> strSQL = new ArrayList<String>();
        ArrayList<Integer> lenghtBidimensionalArray = new ArrayList<Integer>();
        ArrayList<Boolean> lastID = new ArrayList<Boolean>();
        String data_select = "";
        lastID.add(false);
        String str = "SELECT IFNULL(COUNT(id),0) AS id FROM gen_t_chiusuragiacenze WHERE azienda='" + azienda + "' AND sotto_az='" + sotto_az + "' AND icqrf='" + icqrf + "' AND adata='" + adata + "' AND dadata='" + dadata + "' ";
        strSQL.add(str);
        tipoSQL.add("select");
        lenghtBidimensionalArray.add(0);
        String strJson = this.util.makeStringJsonDB("OFF", tipoSQL, strSQL, null, null, lastID, lenghtBidimensionalArray);
        data_select = this.sk1Comm.ServerEsecuteRequest(FXMLDocumentController.GLOBAL_IP, FXMLDocumentController.GLOBAL_PORT, "dbInteraction#@" + strJson);
        if (!data_select.contains("#ERR:")) {
            JSONArray arrayJson = this.jsonUtil.strJsonToJSONArray(data_select);
            for (int i = 0; i < arrayJson.length(); ++i) {
                JSONObject rec = arrayJson.getJSONObject(i);
                String id = rec.get("id").toString();
                if (!(Double.parseDouble(id) > 0.0)) continue;
                ret = true;
            }
        }
        return ret;
    }

    public boolean getIfChiusuraExistWBS(String azienda, String sotto_az, String icqrf, String dadata, String adata) throws JSONException {
        boolean ret = false;
        ArrayList<String> tipoSQL = new ArrayList<String>();
        ArrayList<String> strSQL = new ArrayList<String>();
        ArrayList<Integer> lenghtBidimensionalArray = new ArrayList<Integer>();
        ArrayList<Boolean> lastID = new ArrayList<Boolean>();
        String data_select = "";
        lastID.add(false);
        String str = "SELECT IFNULL(COUNT(id),0) AS id FROM gen_t_chiusurewbs WHERE azienda='" + azienda + "' AND sotto_az='" + sotto_az + "' AND icqrf='" + icqrf + "' AND adata='" + adata + "' AND dadata='" + dadata + "' ";
        strSQL.add(str);
        tipoSQL.add("select");
        lenghtBidimensionalArray.add(0);
        String strJson = this.util.makeStringJsonDB("OFF", tipoSQL, strSQL, null, null, lastID, lenghtBidimensionalArray);
        data_select = this.sk1Comm.ServerEsecuteRequest(FXMLDocumentController.GLOBAL_IP, FXMLDocumentController.GLOBAL_PORT, "dbInteraction#@" + strJson);
        if (!data_select.contains("#ERR:")) {
            JSONArray arrayJson = this.jsonUtil.strJsonToJSONArray(data_select);
            for (int i = 0; i < arrayJson.length(); ++i) {
                JSONObject rec = arrayJson.getJSONObject(i);
                String id = rec.get("id").toString();
                if (!(Double.parseDouble(id) > 0.0)) continue;
                ret = true;
            }
        }
        return ret;
    }

    public boolean getIfChiusuraExistSIAN(String azienda, String sotto_az, String icqrf, String dadata, String adata) throws JSONException {
        boolean ret = false;
        ArrayList<String> tipoSQL = new ArrayList<String>();
        ArrayList<String> strSQL = new ArrayList<String>();
        ArrayList<Integer> lenghtBidimensionalArray = new ArrayList<Integer>();
        ArrayList<Boolean> lastID = new ArrayList<Boolean>();
        String data_select = "";
        lastID.add(false);
        String str = "SELECT IFNULL(codice,'') AS codice FROM gen_t_chiusuragiacenze WHERE azienda='" + azienda + "' AND sotto_az='" + sotto_az + "' AND icqrf='" + icqrf + "' AND adata='" + adata + "' AND dadata='" + dadata + "' AND id=(SELECT IFNULL(MAX(id),0) FROM gen_t_chiusuragiacenze WHERE azienda='" + azienda + "' AND sotto_az='" + sotto_az + "' AND icqrf='" + icqrf + "' AND adata='" + adata + "' AND dadata='" + dadata + "' ) ";
        strSQL.add(str);
        tipoSQL.add("select");
        lenghtBidimensionalArray.add(0);
        String strJson = this.util.makeStringJsonDB("OFF", tipoSQL, strSQL, null, null, lastID, lenghtBidimensionalArray);
        data_select = this.sk1Comm.ServerEsecuteRequest(FXMLDocumentController.GLOBAL_IP, FXMLDocumentController.GLOBAL_PORT, "dbInteraction#@" + strJson);
        if (!data_select.contains("#ERR:")) {
            JSONArray arrayJson = this.jsonUtil.strJsonToJSONArray(data_select);
            for (int i = 0; i < arrayJson.length(); ++i) {
                JSONObject rec = arrayJson.getJSONObject(i);
                String codice = rec.get("codice").toString();
                if (!codice.equals("H68") && !codice.equals("H65")) continue;
                ret = true;
            }
        }
        return ret;
    }

    public int getCountChiusureGiacenzaWBS(String azienda, String sotto_az, String icqrf) throws JSONException {
        int ret = 0;
        ArrayList<String> tipoSQL = new ArrayList<String>();
        ArrayList<String> strSQL = new ArrayList<String>();
        ArrayList<Integer> lenghtBidimensionalArray = new ArrayList<Integer>();
        ArrayList<Boolean> lastID = new ArrayList<Boolean>();
        String data_select = "";
        lastID.add(false);
        String str = "SELECT IFNULL(COUNT(id),0) AS id FROM gen_t_chiusurewbs WHERE azienda='" + azienda + "' AND sotto_az='" + sotto_az + "' AND icqrf='" + icqrf + "'  ";
        strSQL.add(str);
        tipoSQL.add("select");
        lenghtBidimensionalArray.add(0);
        String strJson = this.util.makeStringJsonDB("OFF", tipoSQL, strSQL, null, null, lastID, lenghtBidimensionalArray);
        data_select = this.sk1Comm.ServerEsecuteRequest(FXMLDocumentController.GLOBAL_IP, FXMLDocumentController.GLOBAL_PORT, "dbInteraction#@" + strJson);
        if (!data_select.contains("#ERR:")) {
            JSONArray arrayJson = this.jsonUtil.strJsonToJSONArray(data_select);
            for (int i = 0; i < arrayJson.length(); ++i) {
                JSONObject rec = arrayJson.getJSONObject(i);
                ret = rec.getInt("id");
            }
        }
        return ret;
    }

    public List<Integer> ritornaFascetteSerie(String codice_prodotto, String num_protocollo, String ente_cert, String data_ido) throws JSONException {
        ArrayList<Integer> numbers = new ArrayList<Integer>();
        int number = 4;
        ArrayList<String> tipoSQL = new ArrayList<String>();
        ArrayList<String> strSQL = new ArrayList<String>();
        ArrayList lenghtBidimensionalArray = new ArrayList();
        ArrayList<Boolean> lastID = new ArrayList<Boolean>();
        lastID.add(false);
        tipoSQL.add("select");
        String strSQLs = "  SELECT serie,numero,counter\n FROM(\n SELECT serie,numero,COUNT(numero) AS counter\n FROM(\n SELECT a.codice,a.numero \n FROM movimenti_fascette_numeri_c AS a\n WHERE azienda='" + FXMLDocumentController.GLOBAL_AZIENDA + "' AND sotto_az='" + FXMLDocumentController.GLOBAL_SOTTOAZZ + "' AND icqrf='" + FXMLDocumentController.GLOBAL_ICQRF + "' AND codice_prodotto='" + codice_prodotto + "' AND num_protocollo='" + num_protocollo + "' AND ente_cert='" + ente_cert + "' AND data_ido='" + data_ido + "'  GROUP BY  serie,numero,\n UNION ALL\n SELECT  serie,numero,\n FROM movimenti_fascette_numeri_s AS a \n WHERE azienda='" + FXMLDocumentController.GLOBAL_AZIENDA + "' AND sotto_az='" + FXMLDocumentController.GLOBAL_SOTTOAZZ + "' AND icqrf='" + FXMLDocumentController.GLOBAL_ICQRF + "' AND codice_prodotto='" + codice_prodotto + "' AND num_protocollo='" + num_protocollo + "' AND ente_cert='" + ente_cert + "' AND data_ido='" + data_ido + "'  GROUP BY  serie,numero,\n) AS a\nGROUP BY  serie,numero,) AS a ";
        strSQL.add(strSQLs);
        String str = this.util.makeStringJsonDB("OFF", tipoSQL, strSQL, null, null, lastID, null);
        String data_select = this.sk1Comm.ServerEsecuteRequest(FXMLDocumentController.GLOBAL_IP, FXMLDocumentController.GLOBAL_PORT, "dbInteraction#@" + str);
        if (!data_select.contains("#ERR:")) {
            JSONArray array = this.jsonUtil.strJsonToJSONArray(data_select);
            if (array.length() > 0) {
                for (int i = 0; i < array.length(); ++i) {
                    JSONObject obj = array.getJSONObject(i);
                    String serie = obj.get("serie").toString();
                    String numero = obj.get("numero").toString();
                    String string = obj.get("counter").toString();
                }
            }
        } else {
            this.util.alertWindow(Alert.AlertType.ERROR, "ERRORE", "", data_select);
        }
        return numbers;
    }

    public boolean controllaFascettaSeEsiste(String serie, int number) throws JSONException {
        ArrayList<String> tipoSQL = new ArrayList<String>();
        ArrayList<String> strSQL = new ArrayList<String>();
        ArrayList lenghtBidimensionalArray = new ArrayList();
        ArrayList<Boolean> lastID = new ArrayList<Boolean>();
        lastID.add(false);
        tipoSQL.add("select");
        String strSQLs = "SELECT * \nFROM v01.fascette\nWHERE azienda='" + FXMLDocumentController.GLOBAL_AZIENDA + "' AND sotto_az='" + FXMLDocumentController.GLOBAL_SOTTOAZZ + "' AND icqrf='" + FXMLDocumentController.GLOBAL_ICQRF + "' AND serie='" + serie + "'  ";
        strSQL.add(strSQLs);
        String str = this.util.makeStringJsonDB("OFF", tipoSQL, strSQL, null, null, lastID, null);
        String data_select = this.sk1Comm.ServerEsecuteRequest(FXMLDocumentController.GLOBAL_IP, FXMLDocumentController.GLOBAL_PORT, "dbInteraction#@" + str);
        if (!data_select.contains("#ERR:")) {
            int i;
            JSONArray array = this.jsonUtil.strJsonToJSONArray(data_select);
            ArrayList<Integer> numbers = new ArrayList<Integer>();
            ArrayList<Integer> numbers_scarico = new ArrayList<Integer>();
            if (array.length() > 0) {
                for (i = 0; i < array.length(); ++i) {
                    int j;
                    int a_numero;
                    int da_numero;
                    JSONObject obj = array.getJSONObject(i);
                    String tipo = obj.get("tipo").toString();
                    if (tipo.equals("C")) {
                        da_numero = obj.getInt("da_numero");
                        a_numero = obj.getInt("a_numero");
                        for (j = da_numero; j <= a_numero; ++j) {
                            numbers.add(j);
                        }
                        continue;
                    }
                    da_numero = obj.getInt("da_numero");
                    a_numero = obj.getInt("a_numero");
                    for (j = da_numero; j <= a_numero; ++j) {
                        numbers_scarico.add(j);
                    }
                }
            }
            for (i = 0; i < numbers_scarico.size(); ++i) {
                numbers.remove(numbers_scarico.get(i));
            }
            return numbers.contains(number);
        }
        this.util.alertWindow(Alert.AlertType.ERROR, "ERRORE", "", data_select);
        return false;
    }

    public boolean checkIFExistsIE815(String arc) throws JSONException {
        boolean ret = false;
        ArrayList<String> tipoSQL = new ArrayList<String>();
        ArrayList<String> strSQL = new ArrayList<String>();
        ArrayList<Integer> lenghtBidimensionalArray = new ArrayList<Integer>();
        ArrayList<Boolean> lastID = new ArrayList<Boolean>();
        String data_select = "";
        lastID.add(false);
        String str = "SELECT IFNULL(id,0) AS id FROM a_testata_ie815 WHERE arc='" + arc + "'";
        strSQL.add(str);
        tipoSQL.add("select");
        lenghtBidimensionalArray.add(0);
        String strJson = this.util.makeStringJsonDB("OFF", tipoSQL, strSQL, null, null, lastID, lenghtBidimensionalArray);
        data_select = this.sk1Comm.ServerEsecuteRequest(FXMLDocumentController.GLOBAL_IP, FXMLDocumentController.GLOBAL_PORT, "dbInteraction#@" + strJson);
        if (!data_select.contains("#ERR:")) {
            JSONArray arrayJson = this.jsonUtil.strJsonToJSONArray(data_select);
            for (int i = 0; i < arrayJson.length(); ++i) {
                JSONObject rec = arrayJson.getJSONObject(i);
                String id = rec.get("id").toString();
                if (!(Double.parseDouble(id) > 0.0)) continue;
                ret = true;
            }
        }
        return ret;
    }

    public boolean checkIFExistsIE818(String arc) throws JSONException {
        boolean ret = false;
        ArrayList<String> tipoSQL = new ArrayList<String>();
        ArrayList<String> strSQL = new ArrayList<String>();
        ArrayList<Integer> lenghtBidimensionalArray = new ArrayList<Integer>();
        ArrayList<Boolean> lastID = new ArrayList<Boolean>();
        String data_select = "";
        lastID.add(false);
        String str = "SELECT IFNULL(id,0) AS id FROM a_testata_ie818 WHERE arc='" + arc + "'";
        strSQL.add(str);
        tipoSQL.add("select");
        lenghtBidimensionalArray.add(0);
        String strJson = this.util.makeStringJsonDB("OFF", tipoSQL, strSQL, null, null, lastID, lenghtBidimensionalArray);
        data_select = this.sk1Comm.ServerEsecuteRequest(FXMLDocumentController.GLOBAL_IP, FXMLDocumentController.GLOBAL_PORT, "dbInteraction#@" + strJson);
        if (!data_select.contains("#ERR:")) {
            JSONArray arrayJson = this.jsonUtil.strJsonToJSONArray(data_select);
            for (int i = 0; i < arrayJson.length(); ++i) {
                JSONObject rec = arrayJson.getJSONObject(i);
                String id = rec.get("id").toString();
                if (!(Double.parseDouble(id) > 0.0)) continue;
                ret = true;
            }
        }
        return ret;
    }

    public String getDescrizioneTa03(String codice) throws JSONException {
        String ret = "";
        ArrayList<String> tipoSQL = new ArrayList<String>();
        ArrayList<String> strSQL = new ArrayList<String>();
        ArrayList<Integer> lenghtBidimensionalArray = new ArrayList<Integer>();
        ArrayList<Boolean> lastID = new ArrayList<Boolean>();
        String data_select = "";
        lastID.add(false);
        String str = "SELECT descrizione FROM accise_t_a03 WHERE codice='" + codice + "'ORDER BY descrizione ASC";
        strSQL.add(str);
        tipoSQL.add("select");
        lenghtBidimensionalArray.add(0);
        String strJson = this.util.makeStringJsonDB("OFF", tipoSQL, strSQL, null, null, lastID, lenghtBidimensionalArray);
        data_select = this.sk1Comm.ServerEsecuteRequest(FXMLDocumentController.GLOBAL_IP, FXMLDocumentController.GLOBAL_PORT, "dbInteraction#@" + strJson);
        if (!data_select.contains("#ERR:")) {
            JSONArray arrayJson = this.jsonUtil.strJsonToJSONArray(data_select);
            for (int i = 0; i < arrayJson.length(); ++i) {
                JSONObject rec = arrayJson.getJSONObject(i);
                ret = rec.getString("descrizione");
            }
        }
        return ret;
    }

    public String getIdFromEnteCert(String codice, String azienda) throws JSONException {
        String ret = "";
        ArrayList<String> tipoSQL = new ArrayList<String>();
        ArrayList<String> strSQL = new ArrayList<String>();
        ArrayList<Integer> lenghtBidimensionalArray = new ArrayList<Integer>();
        ArrayList<Boolean> lastID = new ArrayList<Boolean>();
        String data_select = "";
        lastID.add(false);
        String str = "SELECT IFNULL(id,0) AS id FROM ente_certificatore WHERE descrizione='" + codice + "' AND azienda='" + azienda + "'";
        strSQL.add(str);
        tipoSQL.add("select");
        lenghtBidimensionalArray.add(0);
        String strJson = this.util.makeStringJsonDB("OFF", tipoSQL, strSQL, null, null, lastID, lenghtBidimensionalArray);
        data_select = this.sk1Comm.ServerEsecuteRequest(FXMLDocumentController.GLOBAL_IP, FXMLDocumentController.GLOBAL_PORT, "dbInteraction#@" + strJson);
        if (!data_select.contains("#ERR:")) {
            JSONArray arrayJson = this.jsonUtil.strJsonToJSONArray(data_select);
            for (int i = 0; i < arrayJson.length(); ++i) {
                JSONObject rec = arrayJson.getJSONObject(i);
                ret = String.valueOf(rec.get("id"));
            }
        }
        return ret;
    }

    public String getDescrizioneTa28(String codice) throws JSONException {
        String ret = "";
        ArrayList<String> tipoSQL = new ArrayList<String>();
        ArrayList<String> strSQL = new ArrayList<String>();
        ArrayList<Integer> lenghtBidimensionalArray = new ArrayList<Integer>();
        ArrayList<Boolean> lastID = new ArrayList<Boolean>();
        String data_select = "";
        lastID.add(false);
        String str = "SELECT descrizione FROM accise_t_a28 WHERE codice='" + codice + "' ORDER BY descrizione ASC";
        strSQL.add(str);
        tipoSQL.add("select");
        lenghtBidimensionalArray.add(0);
        String strJson = this.util.makeStringJsonDB("OFF", tipoSQL, strSQL, null, null, lastID, lenghtBidimensionalArray);
        data_select = this.sk1Comm.ServerEsecuteRequest(FXMLDocumentController.GLOBAL_IP, FXMLDocumentController.GLOBAL_PORT, "dbInteraction#@" + strJson);
        if (!data_select.contains("#ERR:")) {
            JSONArray arrayJson = this.jsonUtil.strJsonToJSONArray(data_select);
            for (int i = 0; i < arrayJson.length(); ++i) {
                JSONObject rec = arrayJson.getJSONObject(i);
                ret = rec.getString("descrizione");
            }
        }
        return ret;
    }

    public String getCodiceContoAccise(String accisa) throws JSONException {
        String ret = "";
        ArrayList<String> tipoSQL = new ArrayList<String>();
        ArrayList<String> strSQL = new ArrayList<String>();
        ArrayList<Integer> lenghtBidimensionalArray = new ArrayList<Integer>();
        ArrayList<Boolean> lastID = new ArrayList<Boolean>();
        String data_select = "";
        lastID.add(false);
        String str = "SELECT IFNULL(codice_contogaranzia,'') AS codice_contogaranzia FROM gen_t_accise_mxmag WHERE cod_accisa='" + accisa + "'";
        strSQL.add(str);
        tipoSQL.add("select");
        lenghtBidimensionalArray.add(0);
        String strJson = this.util.makeStringJsonDB("OFF", tipoSQL, strSQL, null, null, lastID, lenghtBidimensionalArray);
        data_select = this.sk1Comm.ServerEsecuteRequest(FXMLDocumentController.GLOBAL_IP, FXMLDocumentController.GLOBAL_PORT, "dbInteraction#@" + strJson);
        if (!data_select.contains("#ERR:")) {
            JSONArray arrayJson = this.jsonUtil.strJsonToJSONArray(data_select);
            for (int i = 0; i < arrayJson.length(); ++i) {
                JSONObject rec = arrayJson.getJSONObject(i);
                ret = rec.getString("codice_contogaranzia");
            }
        }
        return ret;
    }

    public String getCodiceTipoContoAccise(String accisa) throws JSONException {
        String ret = "";
        ArrayList<String> tipoSQL = new ArrayList<String>();
        ArrayList<String> strSQL = new ArrayList<String>();
        ArrayList<Integer> lenghtBidimensionalArray = new ArrayList<Integer>();
        ArrayList<Boolean> lastID = new ArrayList<Boolean>();
        String data_select = "";
        lastID.add(false);
        String str = "SELECT IFNULL(garac_tipologiagara,'') AS garac_tipologiagara FROM gen_t_accise_mxmag WHERE cod_accisa='" + accisa + "'";
        strSQL.add(str);
        tipoSQL.add("select");
        lenghtBidimensionalArray.add(0);
        String strJson = this.util.makeStringJsonDB("OFF", tipoSQL, strSQL, null, null, lastID, lenghtBidimensionalArray);
        data_select = this.sk1Comm.ServerEsecuteRequest(FXMLDocumentController.GLOBAL_IP, FXMLDocumentController.GLOBAL_PORT, "dbInteraction#@" + strJson);
        if (!data_select.contains("#ERR:")) {
            JSONArray arrayJson = this.jsonUtil.strJsonToJSONArray(data_select);
            for (int i = 0; i < arrayJson.length(); ++i) {
                JSONObject rec = arrayJson.getJSONObject(i);
                ret = rec.get("garac_tipologiagara").toString();
            }
        }
        return ret;
    }

    public String getDescrizioneFromErroriFormali(String codice) throws JSONException {
        String ret = "";
        ArrayList<String> tipoSQL = new ArrayList<String>();
        ArrayList<String> strSQL = new ArrayList<String>();
        ArrayList<Integer> lenghtBidimensionalArray = new ArrayList<Integer>();
        ArrayList<Boolean> lastID = new ArrayList<Boolean>();
        String data_select = "";
        lastID.add(false);
        String str = "SELECT IFNULL(descrizione,'') AS descrizione FROM accise_t_erroriformali WHERE codice='" + codice + "'";
        tipoSQL.add("selectRS");
        strSQL.add(str);
        lenghtBidimensionalArray.add(0);
        String strJson = this.util.makeStringJsonDB("OFF", tipoSQL, strSQL, null, null, lastID, lenghtBidimensionalArray);
        data_select = this.sk1Comm.ServerEsecuteRequest(FXMLDocumentController.GLOBAL_IP, FXMLDocumentController.GLOBAL_PORT, "dbInteraction#@" + strJson);
        if (!data_select.contains("#ERR:")) {
            JSONArray arrayJson = this.jsonUtil.strJsonToJSONArray(data_select);
            for (int i = 0; i < arrayJson.length(); ++i) {
                try {
                    JSONObject rec = arrayJson.getJSONObject(i);
                    ret = rec.get("descrizione").toString().trim();
                    continue;
                }
                catch (JSONException ex) {
                    return null;
                }
            }
        } else {
            return null;
        }
        return ret;
    }

    public List<String> getDocumentiFromID(String id) throws JSONException {
        ArrayList<String> ret = new ArrayList<String>();
        ArrayList<String> tipoSQL = new ArrayList<String>();
        ArrayList<String> strSQL = new ArrayList<String>();
        ArrayList<Integer> lenghtBidimensionalArray = new ArrayList<Integer>();
        ArrayList<Boolean> lastID = new ArrayList<Boolean>();
        String data_select = "";
        lastID.add(false);
        String str = "SELECT  mx_doc_sigla,mx_doc_ser,mx_doc_data,tipo_mov,mx_doc_causale,mx_doc_magazzino,mx_doc_num FROM c_movimenti_mx WHERE id_oper='" + id + "'";
        tipoSQL.add("selectRS");
        strSQL.add(str);
        lenghtBidimensionalArray.add(0);
        String strJson = this.util.makeStringJsonDB("OFF", tipoSQL, strSQL, null, null, lastID, lenghtBidimensionalArray);
        data_select = this.sk1Comm.ServerEsecuteRequest(FXMLDocumentController.GLOBAL_IP, FXMLDocumentController.GLOBAL_PORT, "dbInteraction#@" + strJson);
        if (!data_select.contains("#ERR:")) {
            JSONArray arrayJson = this.jsonUtil.strJsonToJSONArray(data_select);
            for (int i = 0; i < arrayJson.length(); ++i) {
                try {
                    JSONObject rec = arrayJson.getJSONObject(i);
                    String sigla = rec.get("mx_doc_sigla").toString().trim();
                    String serie = rec.get("mx_doc_ser").toString().trim();
                    String data_oper = rec.get("mx_doc_data").toString().trim();
                    String tipo_mov = rec.get("tipo_mov").toString().trim();
                    String cod_causale = rec.get("mx_doc_causale").toString().trim();
                    String mag_da = rec.get("mx_doc_magazzino").toString().trim();
                    String mx_doc_num = rec.get("mx_doc_num").toString().trim();
                    String sty = sigla + "|" + serie + "|" + mx_doc_num + "|" + data_oper + "|" + tipo_mov + "|" + cod_causale + "|" + mag_da;
                    ret.add(sty);
                    continue;
                }
                catch (JSONException ex) {
                    return null;
                }
            }
        } else {
            return null;
        }
        return ret;
    }

    public String getProgressivoFromARCData(String arc) throws JSONException {
        String ret = "";
        ArrayList<String> tipoSQL = new ArrayList<String>();
        ArrayList<String> strSQL = new ArrayList<String>();
        ArrayList<Integer> lenghtBidimensionalArray = new ArrayList<Integer>();
        ArrayList<Boolean> lastID = new ArrayList<Boolean>();
        String data_select = "";
        lastID.add(false);
        String str = "SELECT SUM(a.counter)+1 AS progressivo FROM(SELECT IFNULL(COUNT(id),0) AS counter FROM a_testata_ie815 WHERE arc='" + arc + "' UNION SELECT IFNULL(COUNT(id),0) AS counter FROM a_testata_ie813 WHERE arc='" + arc + "' UNION SELECT IFNULL(COUNT(id),0) AS counter FROM a_testata_ie819 WHERE arc='" + arc + "' UNION SELECT IFNULL(COUNT(id),0) AS counter FROM a_testata_ie818 WHERE arc='" + arc + "' ) AS a";
        tipoSQL.add("selectRS");
        strSQL.add(str);
        lenghtBidimensionalArray.add(0);
        String strJson = this.util.makeStringJsonDB("OFF", tipoSQL, strSQL, null, null, lastID, lenghtBidimensionalArray);
        data_select = this.sk1Comm.ServerEsecuteRequest(FXMLDocumentController.GLOBAL_IP, FXMLDocumentController.GLOBAL_PORT, "dbInteraction#@" + strJson);
        if (!data_select.contains("#ERR:")) {
            JSONArray arrayJson = this.jsonUtil.strJsonToJSONArray(data_select);
            for (int i = 0; i < arrayJson.length(); ++i) {
                try {
                    JSONObject rec = arrayJson.getJSONObject(i);
                    ret = rec.get("progressivo").toString().trim();
                    continue;
                }
                catch (JSONException ex) {
                    return null;
                }
            }
        } else {
            return null;
        }
        return ret;
    }

    public String getTipoDestFromIe815(String id) throws JSONException {
        String ret = "";
        ArrayList<String> tipoSQL = new ArrayList<String>();
        ArrayList<String> strSQL = new ArrayList<String>();
        ArrayList<Integer> lenghtBidimensionalArray = new ArrayList<Integer>();
        ArrayList<Boolean> lastID = new ArrayList<Boolean>();
        String data_select = "";
        lastID.add(false);
        String str = "SELECT tipo_destinazione FROM a_testata_ie815 where id='" + id + "'";
        tipoSQL.add("selectRS");
        strSQL.add(str);
        lenghtBidimensionalArray.add(0);
        String strJson = this.util.makeStringJsonDB("OFF", tipoSQL, strSQL, null, null, lastID, lenghtBidimensionalArray);
        data_select = this.sk1Comm.ServerEsecuteRequest(FXMLDocumentController.GLOBAL_IP, FXMLDocumentController.GLOBAL_PORT, "dbInteraction#@" + strJson);
        if (!data_select.contains("#ERR:")) {
            JSONArray arrayJson = this.jsonUtil.strJsonToJSONArray(data_select);
            for (int i = 0; i < arrayJson.length(); ++i) {
                try {
                    String descrizione;
                    JSONObject rec = arrayJson.getJSONObject(i);
                    ret = descrizione = rec.get("tipo_destinazione").toString().trim();
                    continue;
                }
                catch (JSONException ex) {
                    return null;
                }
            }
        } else {
            return null;
        }
        return ret;
    }

    public String getNumeroLocaleFromIe815ARC(String arc) throws JSONException {
        String ret = "";
        ArrayList<String> tipoSQL = new ArrayList<String>();
        ArrayList<String> strSQL = new ArrayList<String>();
        ArrayList<Integer> lenghtBidimensionalArray = new ArrayList<Integer>();
        ArrayList<Boolean> lastID = new ArrayList<Boolean>();
        String data_select = "";
        lastID.add(false);
        String str = "SELECT numero_localedraftdaa FROM a_testata_ie815 where arc='" + arc + "'";
        tipoSQL.add("selectRS");
        strSQL.add(str);
        lenghtBidimensionalArray.add(0);
        String strJson = this.util.makeStringJsonDB("OFF", tipoSQL, strSQL, null, null, lastID, lenghtBidimensionalArray);
        data_select = this.sk1Comm.ServerEsecuteRequest(FXMLDocumentController.GLOBAL_IP, FXMLDocumentController.GLOBAL_PORT, "dbInteraction#@" + strJson);
        if (!data_select.contains("#ERR:")) {
            JSONArray arrayJson = this.jsonUtil.strJsonToJSONArray(data_select);
            for (int i = 0; i < arrayJson.length(); ++i) {
                try {
                    String descrizione;
                    JSONObject rec = arrayJson.getJSONObject(i);
                    ret = descrizione = rec.get("numero_localedraftdaa").toString().trim();
                    continue;
                }
                catch (JSONException ex) {
                    return null;
                }
            }
        } else {
            return null;
        }
        return ret;
    }

    public String getTipoDestFromIe815ARC(String arc) throws JSONException {
        String ret = "";
        ArrayList<String> tipoSQL = new ArrayList<String>();
        ArrayList<String> strSQL = new ArrayList<String>();
        ArrayList<Integer> lenghtBidimensionalArray = new ArrayList<Integer>();
        ArrayList<Boolean> lastID = new ArrayList<Boolean>();
        String data_select = "";
        lastID.add(false);
        String str = "SELECT tipo_destinazione FROM a_testata_ie815 where arc='" + arc + "'";
        tipoSQL.add("selectRS");
        strSQL.add(str);
        lenghtBidimensionalArray.add(0);
        String strJson = this.util.makeStringJsonDB("OFF", tipoSQL, strSQL, null, null, lastID, lenghtBidimensionalArray);
        data_select = this.sk1Comm.ServerEsecuteRequest(FXMLDocumentController.GLOBAL_IP, FXMLDocumentController.GLOBAL_PORT, "dbInteraction#@" + strJson);
        if (!data_select.contains("#ERR:")) {
            JSONArray arrayJson = this.jsonUtil.strJsonToJSONArray(data_select);
            for (int i = 0; i < arrayJson.length(); ++i) {
                try {
                    String descrizione;
                    JSONObject rec = arrayJson.getJSONObject(i);
                    ret = descrizione = rec.get("tipo_destinazione").toString().trim();
                    continue;
                }
                catch (JSONException ex) {
                    return null;
                }
            }
        } else {
            return null;
        }
        return ret;
    }

    public String getIdOperazione815ARC(String arc) throws JSONException {
        String ret = "";
        ArrayList<String> tipoSQL = new ArrayList<String>();
        ArrayList<String> strSQL = new ArrayList<String>();
        ArrayList<Integer> lenghtBidimensionalArray = new ArrayList<Integer>();
        ArrayList<Boolean> lastID = new ArrayList<Boolean>();
        String data_select = "";
        lastID.add(false);
        String str = "SELECT id FROM a_testata_ie815 where arc='" + arc + "'";
        tipoSQL.add("selectRS");
        strSQL.add(str);
        lenghtBidimensionalArray.add(0);
        String strJson = this.util.makeStringJsonDB("OFF", tipoSQL, strSQL, null, null, lastID, lenghtBidimensionalArray);
        data_select = this.sk1Comm.ServerEsecuteRequest(FXMLDocumentController.GLOBAL_IP, FXMLDocumentController.GLOBAL_PORT, "dbInteraction#@" + strJson);
        if (!data_select.contains("#ERR:")) {
            JSONArray arrayJson = this.jsonUtil.strJsonToJSONArray(data_select);
            for (int i = 0; i < arrayJson.length(); ++i) {
                try {
                    String descrizione;
                    JSONObject rec = arrayJson.getJSONObject(i);
                    ret = descrizione = rec.get("id").toString().trim();
                    continue;
                }
                catch (JSONException ex) {
                    return null;
                }
            }
        } else {
            return null;
        }
        return ret;
    }

    public String getEnteCertDescrizione(String codice) throws JSONException {
        String ret = "";
        ArrayList<String> tipoSQL = new ArrayList<String>();
        ArrayList<String> strSQL = new ArrayList<String>();
        ArrayList<Integer> lenghtBidimensionalArray = new ArrayList<Integer>();
        ArrayList<Boolean> lastID = new ArrayList<Boolean>();
        String data_select = "";
        lastID.add(false);
        String str = "SELECT id FROM ente_certificatore where descrizione='" + codice + "'";
        tipoSQL.add("selectRS");
        strSQL.add(str);
        lenghtBidimensionalArray.add(0);
        String strJson = this.util.makeStringJsonDB("OFF", tipoSQL, strSQL, null, null, lastID, lenghtBidimensionalArray);
        data_select = this.sk1Comm.ServerEsecuteRequest(FXMLDocumentController.GLOBAL_IP, FXMLDocumentController.GLOBAL_PORT, "dbInteraction#@" + strJson);
        if (!data_select.contains("#ERR:")) {
            JSONArray arrayJson = this.jsonUtil.strJsonToJSONArray(data_select);
            for (int i = 0; i < arrayJson.length(); ++i) {
                try {
                    String descrizione;
                    JSONObject rec = arrayJson.getJSONObject(i);
                    ret = descrizione = rec.get("tipo_destinazione").toString().trim();
                    continue;
                }
                catch (JSONException ex) {
                    return null;
                }
            }
        } else {
            return null;
        }
        return ret;
    }

    public String getCategoriaCPA(String cpa) throws JSONException {
        String ret = "";
        ArrayList<String> tipoSQL = new ArrayList<String>();
        ArrayList<String> strSQL = new ArrayList<String>();
        ArrayList<Integer> lenghtBidimensionalArray = new ArrayList<Integer>();
        ArrayList<Boolean> lastID = new ArrayList<Boolean>();
        String data_select = "";
        lastID.add(false);
        String str = "SELECT cat FROM accise_t_012 where cpa='" + cpa + "'";
        tipoSQL.add("selectRS");
        strSQL.add(str);
        lenghtBidimensionalArray.add(0);
        String strJson = this.util.makeStringJsonDB("OFF", tipoSQL, strSQL, null, null, lastID, lenghtBidimensionalArray);
        data_select = this.sk1Comm.ServerEsecuteRequest(FXMLDocumentController.GLOBAL_IP, FXMLDocumentController.GLOBAL_PORT, "dbInteraction#@" + strJson);
        if (!data_select.contains("#ERR:")) {
            JSONArray arrayJson = this.jsonUtil.strJsonToJSONArray(data_select);
            for (int i = 0; i < arrayJson.length(); ++i) {
                try {
                    String descrizione;
                    JSONObject rec = arrayJson.getJSONObject(i);
                    ret = descrizione = rec.get("cat").toString().trim();
                    continue;
                }
                catch (JSONException ex) {
                    return null;
                }
            }
        } else {
            return null;
        }
        return ret;
    }

    public String getIfEADOrdinario(String id_ie815) throws JSONException {
        String ret = "";
        ArrayList<String> tipoSQL = new ArrayList<String>();
        ArrayList<String> strSQL = new ArrayList<String>();
        ArrayList<Integer> lenghtBidimensionalArray = new ArrayList<Integer>();
        ArrayList<Boolean> lastID = new ArrayList<Boolean>();
        String data_select = "";
        lastID.add(false);
        String str = "SELECT flg_differita FROM a_testata_ie815 where id='" + id_ie815 + "'";
        tipoSQL.add("selectRS");
        strSQL.add(str);
        lenghtBidimensionalArray.add(0);
        String strJson = this.util.makeStringJsonDB("OFF", tipoSQL, strSQL, null, null, lastID, lenghtBidimensionalArray);
        data_select = this.sk1Comm.ServerEsecuteRequest(FXMLDocumentController.GLOBAL_IP, FXMLDocumentController.GLOBAL_PORT, "dbInteraction#@" + strJson);
        if (!data_select.contains("#ERR:")) {
            JSONArray arrayJson = this.jsonUtil.strJsonToJSONArray(data_select);
            for (int i = 0; i < arrayJson.length(); ++i) {
                try {
                    String descrizione;
                    JSONObject rec = arrayJson.getJSONObject(i);
                    ret = descrizione = rec.get("flg_differita").toString().trim();
                    continue;
                }
                catch (JSONException ex) {
                    return null;
                }
            }
        } else {
            return null;
        }
        return ret;
    }

    public String getTipoDocFromFlusso() {
        String ret;
        block12: {
            ret = "";
            try {
                ArrayList<String> tipoSQL = new ArrayList<String>();
                ArrayList<String> strSQL = new ArrayList<String>();
                ArrayList<Integer> lenghtBidimensionalArray = new ArrayList<Integer>();
                ArrayList<Boolean> lastID = new ArrayList<Boolean>();
                String data_select = "";
                lastID.add(false);
                String str = "SELECT IFNULL(a.tipo_flusso,'') AS tipo_flusso FROM gen_t_accise_mxmag AS a  WHERE a.azienda='" + FXMLDocumentController.GLOBAL_AZIENDA + "' AND a.sotto_az='" + FXMLDocumentController.GLOBAL_SOTTOAZZ + "' AND a.cod_accisa='" + FXMLDocumentController.GLOBAL_ICQRF + "'";
                tipoSQL.add("selectRS");
                strSQL.add(str);
                lenghtBidimensionalArray.add(0);
                String strJson = this.util.makeStringJsonDB("OFF", tipoSQL, strSQL, null, null, lastID, lenghtBidimensionalArray);
                data_select = this.sk1Comm.ServerEsecuteRequest(FXMLDocumentController.GLOBAL_IP, FXMLDocumentController.GLOBAL_PORT, "dbInteraction#@" + strJson);
                if (!data_select.contains("#ERR:")) {
                    JSONArray arrayJson = this.jsonUtil.strJsonToJSONArray(data_select);
                    for (int i = 0; i < arrayJson.length(); ++i) {
                        try {
                            String tipo_flusso;
                            JSONObject rec = arrayJson.getJSONObject(i);
                            switch (tipo_flusso = rec.get("tipo_flusso").toString().trim()) {
                                case "ALCOAV": {
                                    ret = "EAD";
                                }
                            }
                            continue;
                        }
                        catch (JSONException ex) {
                            return null;
                        }
                    }
                    break block12;
                }
                return null;
            }
            catch (JSONException ex) {
                Logger.getLogger(Ricerca.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        return ret;
    }

    public String getImportoAccisa(String stato_accisa, String cpa, String grado) throws JSONException {
        String ret = "0";
        ArrayList<String> tipoSQL = new ArrayList<String>();
        ArrayList<String> strSQL = new ArrayList<String>();
        ArrayList<Integer> lenghtBidimensionalArray = new ArrayList<Integer>();
        ArrayList<Boolean> lastID = new ArrayList<Boolean>();
        String data_select = "";
        lastID.add(false);
        String str = "SELECT IFNULL(aliquota,0) AS aliquota FROM accise_t_accisanazione WHERE cpa='" + cpa + "' AND nazione='" + stato_accisa + "' AND (grado_min<=" + grado + " AND grado_max>=" + grado + ") ";
        tipoSQL.add("selectRS");
        strSQL.add(str);
        lenghtBidimensionalArray.add(0);
        String strJson = this.util.makeStringJsonDB("OFF", tipoSQL, strSQL, null, null, lastID, lenghtBidimensionalArray);
        data_select = this.sk1Comm.ServerEsecuteRequest(FXMLDocumentController.GLOBAL_IP, FXMLDocumentController.GLOBAL_PORT, "dbInteraction#@" + strJson);
        if (!data_select.contains("#ERR:")) {
            JSONArray arrayJson = this.jsonUtil.strJsonToJSONArray(data_select);
            for (int i = 0; i < arrayJson.length(); ++i) {
                try {
                    String descrizione;
                    JSONObject rec = arrayJson.getJSONObject(i);
                    ret = descrizione = rec.get("aliquota").toString().trim();
                    continue;
                }
                catch (JSONException ex) {
                    return "0";
                }
            }
        } else {
            return "0";
        }
        return ret;
    }

    public String getCodiceUfficio(String azienda, String sotto_az, String codice_accisa) throws JSONException {
        String ret = "";
        ArrayList<String> tipoSQL = new ArrayList<String>();
        ArrayList<String> strSQL = new ArrayList<String>();
        ArrayList<Integer> lenghtBidimensionalArray = new ArrayList<Integer>();
        ArrayList<Boolean> lastID = new ArrayList<Boolean>();
        String data_select = "";
        lastID.add(false);
        String str = "SELECT codice_ufficio FROM gen_t_accise_mxmag where azienda='" + azienda + "' AND sotto_az='" + sotto_az + "' AND cod_accisa='" + codice_accisa + "' ";
        tipoSQL.add("selectRS");
        strSQL.add(str);
        lenghtBidimensionalArray.add(0);
        String strJson = this.util.makeStringJsonDB("OFF", tipoSQL, strSQL, null, null, lastID, lenghtBidimensionalArray);
        data_select = this.sk1Comm.ServerEsecuteRequest(FXMLDocumentController.GLOBAL_IP, FXMLDocumentController.GLOBAL_PORT, "dbInteraction#@" + strJson);
        if (!data_select.contains("#ERR:")) {
            JSONArray arrayJson = this.jsonUtil.strJsonToJSONArray(data_select);
            for (int i = 0; i < arrayJson.length(); ++i) {
                try {
                    String descrizione;
                    JSONObject rec = arrayJson.getJSONObject(i);
                    ret = descrizione = rec.get("codice_ufficio").toString().trim();
                    continue;
                }
                catch (JSONException ex) {
                    return null;
                }
            }
        } else {
            return null;
        }
        return ret;
    }

    public String getNumeroAutorizzato(String azienda, String sotto_az, String codice_accisa) throws JSONException {
        String ret = "";
        ArrayList<String> tipoSQL = new ArrayList<String>();
        ArrayList<String> strSQL = new ArrayList<String>();
        ArrayList<Integer> lenghtBidimensionalArray = new ArrayList<Integer>();
        ArrayList<Boolean> lastID = new ArrayList<Boolean>();
        String data_select = "";
        lastID.add(false);
        String str = "SELECT codice_u_autorizzato FROM gen_t_accise_mxmag where azienda='" + azienda + "' AND sotto_az='" + sotto_az + "' AND cod_accisa='" + codice_accisa + "' ";
        tipoSQL.add("selectRS");
        strSQL.add(str);
        lenghtBidimensionalArray.add(0);
        String strJson = this.util.makeStringJsonDB("OFF", tipoSQL, strSQL, null, null, lastID, lenghtBidimensionalArray);
        data_select = this.sk1Comm.ServerEsecuteRequest(FXMLDocumentController.GLOBAL_IP, FXMLDocumentController.GLOBAL_PORT, "dbInteraction#@" + strJson);
        if (!data_select.contains("#ERR:")) {
            JSONArray arrayJson = this.jsonUtil.strJsonToJSONArray(data_select);
            for (int i = 0; i < arrayJson.length(); ++i) {
                try {
                    String descrizione;
                    JSONObject rec = arrayJson.getJSONObject(i);
                    ret = descrizione = rec.get("codice_u_autorizzato").toString().trim();
                    continue;
                }
                catch (JSONException ex) {
                    return null;
                }
            }
        } else {
            return null;
        }
        return ret;
    }

    public String getPivaAutorizzato(String azienda, String sotto_az, String codice_accisa) throws JSONException {
        String ret = "";
        ArrayList<String> tipoSQL = new ArrayList<String>();
        ArrayList<String> strSQL = new ArrayList<String>();
        ArrayList<Integer> lenghtBidimensionalArray = new ArrayList<Integer>();
        ArrayList<Boolean> lastID = new ArrayList<Boolean>();
        String data_select = "";
        lastID.add(false);
        String str = "SELECT piva_u_autorizzato FROM gen_t_accise_mxmag where azienda='" + azienda + "' AND sotto_az='" + sotto_az + "' AND cod_accisa='" + codice_accisa + "' ";
        tipoSQL.add("selectRS");
        strSQL.add(str);
        lenghtBidimensionalArray.add(0);
        String strJson = this.util.makeStringJsonDB("OFF", tipoSQL, strSQL, null, null, lastID, lenghtBidimensionalArray);
        data_select = this.sk1Comm.ServerEsecuteRequest(FXMLDocumentController.GLOBAL_IP, FXMLDocumentController.GLOBAL_PORT, "dbInteraction#@" + strJson);
        if (!data_select.contains("#ERR:")) {
            JSONArray arrayJson = this.jsonUtil.strJsonToJSONArray(data_select);
            for (int i = 0; i < arrayJson.length(); ++i) {
                try {
                    String descrizione;
                    JSONObject rec = arrayJson.getJSONObject(i);
                    ret = descrizione = rec.get("piva_u_autorizzato").toString().trim();
                    continue;
                }
                catch (JSONException ex) {
                    return null;
                }
            }
        } else {
            return null;
        }
        return ret;
    }

    public String getT012A(String cpa) throws JSONException {
        String ret = "";
        ArrayList<String> tipoSQL = new ArrayList<String>();
        ArrayList<String> strSQL = new ArrayList<String>();
        ArrayList<Integer> lenghtBidimensionalArray = new ArrayList<Integer>();
        ArrayList<Boolean> lastID = new ArrayList<Boolean>();
        String data_select = "";
        lastID.add(false);
        String str = "SELECT a FROM accise_t_012 where cpa='" + cpa + "'";
        tipoSQL.add("selectRS");
        strSQL.add(str);
        lenghtBidimensionalArray.add(0);
        String strJson = this.util.makeStringJsonDB("OFF", tipoSQL, strSQL, null, null, lastID, lenghtBidimensionalArray);
        data_select = this.sk1Comm.ServerEsecuteRequest(FXMLDocumentController.GLOBAL_IP, FXMLDocumentController.GLOBAL_PORT, "dbInteraction#@" + strJson);
        if (!data_select.contains("#ERR:")) {
            JSONArray arrayJson = this.jsonUtil.strJsonToJSONArray(data_select);
            for (int i = 0; i < arrayJson.length(); ++i) {
                try {
                    String descrizione;
                    JSONObject rec = arrayJson.getJSONObject(i);
                    ret = descrizione = rec.get("a").toString().trim();
                    continue;
                }
                catch (JSONException ex) {
                    return null;
                }
            }
        } else {
            return null;
        }
        return ret;
    }

    public String getT012D(String cpa) throws JSONException {
        String ret = "";
        ArrayList<String> tipoSQL = new ArrayList<String>();
        ArrayList<String> strSQL = new ArrayList<String>();
        ArrayList<Integer> lenghtBidimensionalArray = new ArrayList<Integer>();
        ArrayList<Boolean> lastID = new ArrayList<Boolean>();
        String data_select = "";
        lastID.add(false);
        String str = "SELECT d FROM accise_t_012 where cpa='" + cpa + "'";
        tipoSQL.add("selectRS");
        strSQL.add(str);
        lenghtBidimensionalArray.add(0);
        String strJson = this.util.makeStringJsonDB("OFF", tipoSQL, strSQL, null, null, lastID, lenghtBidimensionalArray);
        data_select = this.sk1Comm.ServerEsecuteRequest(FXMLDocumentController.GLOBAL_IP, FXMLDocumentController.GLOBAL_PORT, "dbInteraction#@" + strJson);
        if (!data_select.contains("#ERR:")) {
            JSONArray arrayJson = this.jsonUtil.strJsonToJSONArray(data_select);
            for (int i = 0; i < arrayJson.length(); ++i) {
                try {
                    String descrizione;
                    JSONObject rec = arrayJson.getJSONObject(i);
                    ret = descrizione = rec.get("d").toString().trim();
                    continue;
                }
                catch (JSONException ex) {
                    return null;
                }
            }
        } else {
            return null;
        }
        return ret;
    }

    public String getDescrizioneT008(String codice) throws JSONException {
        String ret = "";
        ArrayList<String> tipoSQL = new ArrayList<String>();
        ArrayList<String> strSQL = new ArrayList<String>();
        ArrayList<Integer> lenghtBidimensionalArray = new ArrayList<Integer>();
        ArrayList<Boolean> lastID = new ArrayList<Boolean>();
        String data_select = "";
        lastID.add(false);
        String str = "SELECT codice,descrizione FROM accise_t_008 where codice='" + codice + "'";
        tipoSQL.add("selectRS");
        strSQL.add(str);
        lenghtBidimensionalArray.add(0);
        String strJson = this.util.makeStringJsonDB("OFF", tipoSQL, strSQL, null, null, lastID, lenghtBidimensionalArray);
        data_select = this.sk1Comm.ServerEsecuteRequest(FXMLDocumentController.GLOBAL_IP, FXMLDocumentController.GLOBAL_PORT, "dbInteraction#@" + strJson);
        if (!data_select.contains("#ERR:")) {
            JSONArray arrayJson = this.jsonUtil.strJsonToJSONArray(data_select);
            for (int i = 0; i < arrayJson.length(); ++i) {
                try {
                    String descrizione;
                    JSONObject rec = arrayJson.getJSONObject(i);
                    ret = descrizione = rec.get("descrizione").toString().trim();
                    continue;
                }
                catch (JSONException ex) {
                    return null;
                }
            }
        } else {
            return null;
        }
        return ret;
    }

    public String getDescrizioneT025(String codice) throws JSONException {
        String ret = "";
        ArrayList<String> tipoSQL = new ArrayList<String>();
        ArrayList<String> strSQL = new ArrayList<String>();
        ArrayList<Integer> lenghtBidimensionalArray = new ArrayList<Integer>();
        ArrayList<Boolean> lastID = new ArrayList<Boolean>();
        String data_select = "";
        lastID.add(false);
        String str = "SELECT codice,descrizione FROM accise_t_025 where codice='" + codice + "'";
        tipoSQL.add("selectRS");
        strSQL.add(str);
        lenghtBidimensionalArray.add(0);
        String strJson = this.util.makeStringJsonDB("OFF", tipoSQL, strSQL, null, null, lastID, lenghtBidimensionalArray);
        data_select = this.sk1Comm.ServerEsecuteRequest(FXMLDocumentController.GLOBAL_IP, FXMLDocumentController.GLOBAL_PORT, "dbInteraction#@" + strJson);
        if (!data_select.contains("#ERR:")) {
            JSONArray arrayJson = this.jsonUtil.strJsonToJSONArray(data_select);
            for (int i = 0; i < arrayJson.length(); ++i) {
                try {
                    String descrizione;
                    JSONObject rec = arrayJson.getJSONObject(i);
                    ret = descrizione = rec.get("descrizione").toString().trim();
                    continue;
                }
                catch (JSONException ex) {
                    return null;
                }
            }
        } else {
            return null;
        }
        return ret;
    }

    public String getDescrizioneT012(String codice) throws JSONException {
        String ret = "";
        ArrayList<String> tipoSQL = new ArrayList<String>();
        ArrayList<String> strSQL = new ArrayList<String>();
        ArrayList<Integer> lenghtBidimensionalArray = new ArrayList<Integer>();
        ArrayList<Boolean> lastID = new ArrayList<Boolean>();
        String data_select = "";
        lastID.add(false);
        String str = "SELECT cpa,descrizione FROM accise_t_012 where cpa='" + codice + "'";
        tipoSQL.add("selectRS");
        strSQL.add(str);
        lenghtBidimensionalArray.add(0);
        String strJson = this.util.makeStringJsonDB("OFF", tipoSQL, strSQL, null, null, lastID, lenghtBidimensionalArray);
        data_select = this.sk1Comm.ServerEsecuteRequest(FXMLDocumentController.GLOBAL_IP, FXMLDocumentController.GLOBAL_PORT, "dbInteraction#@" + strJson);
        if (!data_select.contains("#ERR:")) {
            JSONArray arrayJson = this.jsonUtil.strJsonToJSONArray(data_select);
            for (int i = 0; i < arrayJson.length(); ++i) {
                try {
                    String descrizione;
                    JSONObject rec = arrayJson.getJSONObject(i);
                    ret = descrizione = rec.get("descrizione").toString().trim();
                    continue;
                }
                catch (JSONException ex) {
                    return null;
                }
            }
        } else {
            return null;
        }
        return ret;
    }

    public String getDescrizioneT011(String codice) throws JSONException {
        String ret = "";
        ArrayList<String> tipoSQL = new ArrayList<String>();
        ArrayList<String> strSQL = new ArrayList<String>();
        ArrayList<Integer> lenghtBidimensionalArray = new ArrayList<Integer>();
        ArrayList<Boolean> lastID = new ArrayList<Boolean>();
        String data_select = "";
        lastID.add(false);
        String str = "SELECT codice,descrizione FROM accise_t_011 where codice='" + codice + "'";
        tipoSQL.add("selectRS");
        strSQL.add(str);
        lenghtBidimensionalArray.add(0);
        String strJson = this.util.makeStringJsonDB("OFF", tipoSQL, strSQL, null, null, lastID, lenghtBidimensionalArray);
        data_select = this.sk1Comm.ServerEsecuteRequest(FXMLDocumentController.GLOBAL_IP, FXMLDocumentController.GLOBAL_PORT, "dbInteraction#@" + strJson);
        if (!data_select.contains("#ERR:")) {
            JSONArray arrayJson = this.jsonUtil.strJsonToJSONArray(data_select);
            for (int i = 0; i < arrayJson.length(); ++i) {
                try {
                    String descrizione;
                    JSONObject rec = arrayJson.getJSONObject(i);
                    ret = descrizione = rec.get("descrizione").toString().trim();
                    continue;
                }
                catch (JSONException ex) {
                    return null;
                }
            }
        } else {
            return null;
        }
        return ret;
    }

    public String getDescrizioneT010(String codice) throws JSONException {
        String ret = "";
        ArrayList<String> tipoSQL = new ArrayList<String>();
        ArrayList<String> strSQL = new ArrayList<String>();
        ArrayList<Integer> lenghtBidimensionalArray = new ArrayList<Integer>();
        ArrayList<Boolean> lastID = new ArrayList<Boolean>();
        String data_select = "";
        lastID.add(false);
        String str = "SELECT codice,descrizione_italiana AS descrizione FROM accise_t_010 where codice='" + codice + "'";
        tipoSQL.add("selectRS");
        strSQL.add(str);
        lenghtBidimensionalArray.add(0);
        String strJson = this.util.makeStringJsonDB("OFF", tipoSQL, strSQL, null, null, lastID, lenghtBidimensionalArray);
        data_select = this.sk1Comm.ServerEsecuteRequest(FXMLDocumentController.GLOBAL_IP, FXMLDocumentController.GLOBAL_PORT, "dbInteraction#@" + strJson);
        if (!data_select.contains("#ERR:")) {
            JSONArray arrayJson = this.jsonUtil.strJsonToJSONArray(data_select);
            for (int i = 0; i < arrayJson.length(); ++i) {
                try {
                    String descrizione;
                    JSONObject rec = arrayJson.getJSONObject(i);
                    ret = descrizione = rec.get("descrizione").toString().trim();
                    continue;
                }
                catch (JSONException ex) {
                    return null;
                }
            }
        } else {
            return null;
        }
        return ret;
    }

    public String getDescrizioneT002(String codice) throws JSONException {
        String ret = "";
        ArrayList<String> tipoSQL = new ArrayList<String>();
        ArrayList<String> strSQL = new ArrayList<String>();
        ArrayList<Integer> lenghtBidimensionalArray = new ArrayList<Integer>();
        ArrayList<Boolean> lastID = new ArrayList<Boolean>();
        String data_select = "";
        lastID.add(false);
        String str = "SELECT codice,descrizione FROM accise_t_002 where codice='" + codice + "'";
        tipoSQL.add("selectRS");
        strSQL.add(str);
        lenghtBidimensionalArray.add(0);
        String strJson = this.util.makeStringJsonDB("OFF", tipoSQL, strSQL, null, null, lastID, lenghtBidimensionalArray);
        data_select = this.sk1Comm.ServerEsecuteRequest(FXMLDocumentController.GLOBAL_IP, FXMLDocumentController.GLOBAL_PORT, "dbInteraction#@" + strJson);
        if (!data_select.contains("#ERR:")) {
            JSONArray arrayJson = this.jsonUtil.strJsonToJSONArray(data_select);
            for (int i = 0; i < arrayJson.length(); ++i) {
                try {
                    String descrizione;
                    JSONObject rec = arrayJson.getJSONObject(i);
                    ret = descrizione = rec.get("descrizione").toString().trim();
                    continue;
                }
                catch (JSONException ex) {
                    return null;
                }
            }
        } else {
            return null;
        }
        return ret;
    }

    public String getDescrizioneT007(String codice) throws JSONException {
        String ret = "";
        ArrayList<String> tipoSQL = new ArrayList<String>();
        ArrayList<String> strSQL = new ArrayList<String>();
        ArrayList<Integer> lenghtBidimensionalArray = new ArrayList<Integer>();
        ArrayList<Boolean> lastID = new ArrayList<Boolean>();
        String data_select = "";
        lastID.add(false);
        String str = "SELECT codice,descrizione FROM accise_t_007 where codice='" + codice + "'";
        tipoSQL.add("selectRS");
        strSQL.add(str);
        lenghtBidimensionalArray.add(0);
        String strJson = this.util.makeStringJsonDB("OFF", tipoSQL, strSQL, null, null, lastID, lenghtBidimensionalArray);
        data_select = this.sk1Comm.ServerEsecuteRequest(FXMLDocumentController.GLOBAL_IP, FXMLDocumentController.GLOBAL_PORT, "dbInteraction#@" + strJson);
        if (!data_select.contains("#ERR:")) {
            JSONArray arrayJson = this.jsonUtil.strJsonToJSONArray(data_select);
            for (int i = 0; i < arrayJson.length(); ++i) {
                try {
                    String descrizione;
                    JSONObject rec = arrayJson.getJSONObject(i);
                    ret = descrizione = rec.get("descrizione").toString().trim();
                    continue;
                }
                catch (JSONException ex) {
                    return null;
                }
            }
        } else {
            return null;
        }
        return ret;
    }

    public String getDescrizioneT016(String codice) throws JSONException {
        String ret = "";
        ArrayList<String> tipoSQL = new ArrayList<String>();
        ArrayList<String> strSQL = new ArrayList<String>();
        ArrayList<Integer> lenghtBidimensionalArray = new ArrayList<Integer>();
        ArrayList<Boolean> lastID = new ArrayList<Boolean>();
        String data_select = "";
        lastID.add(false);
        String str = "SELECT codice,descrizione FROM accise_t_016 where codice='" + codice + "'";
        tipoSQL.add("selectRS");
        strSQL.add(str);
        lenghtBidimensionalArray.add(0);
        String strJson = this.util.makeStringJsonDB("OFF", tipoSQL, strSQL, null, null, lastID, lenghtBidimensionalArray);
        data_select = this.sk1Comm.ServerEsecuteRequest(FXMLDocumentController.GLOBAL_IP, FXMLDocumentController.GLOBAL_PORT, "dbInteraction#@" + strJson);
        if (!data_select.contains("#ERR:")) {
            JSONArray arrayJson = this.jsonUtil.strJsonToJSONArray(data_select);
            for (int i = 0; i < arrayJson.length(); ++i) {
                try {
                    String descrizione;
                    JSONObject rec = arrayJson.getJSONObject(i);
                    ret = descrizione = rec.get("descrizione").toString().trim();
                    continue;
                }
                catch (JSONException ex) {
                    return null;
                }
            }
        } else {
            return null;
        }
        return ret;
    }

    public String getDescrizioneT017(String codice) throws JSONException {
        String ret = "";
        ArrayList<String> tipoSQL = new ArrayList<String>();
        ArrayList<String> strSQL = new ArrayList<String>();
        ArrayList<Integer> lenghtBidimensionalArray = new ArrayList<Integer>();
        ArrayList<Boolean> lastID = new ArrayList<Boolean>();
        String data_select = "";
        lastID.add(false);
        String str = "SELECT codice,descrizione FROM accise_t_017 where codice='" + codice + "'";
        tipoSQL.add("selectRS");
        strSQL.add(str);
        lenghtBidimensionalArray.add(0);
        String strJson = this.util.makeStringJsonDB("OFF", tipoSQL, strSQL, null, null, lastID, lenghtBidimensionalArray);
        data_select = this.sk1Comm.ServerEsecuteRequest(FXMLDocumentController.GLOBAL_IP, FXMLDocumentController.GLOBAL_PORT, "dbInteraction#@" + strJson);
        if (!data_select.contains("#ERR:")) {
            JSONArray arrayJson = this.jsonUtil.strJsonToJSONArray(data_select);
            for (int i = 0; i < arrayJson.length(); ++i) {
                try {
                    String descrizione;
                    JSONObject rec = arrayJson.getJSONObject(i);
                    ret = descrizione = rec.get("descrizione").toString().trim();
                    continue;
                }
                catch (JSONException ex) {
                    return null;
                }
            }
        } else {
            return null;
        }
        return ret;
    }

    public String getDescrizioneT005(String codice) throws JSONException {
        String ret = "";
        ArrayList<String> tipoSQL = new ArrayList<String>();
        ArrayList<String> strSQL = new ArrayList<String>();
        ArrayList<Integer> lenghtBidimensionalArray = new ArrayList<Integer>();
        ArrayList<Boolean> lastID = new ArrayList<Boolean>();
        String data_select = "";
        lastID.add(false);
        String str = "SELECT codice,descrizione FROM accise_t_005 where codice='" + codice + "'";
        tipoSQL.add("selectRS");
        strSQL.add(str);
        lenghtBidimensionalArray.add(0);
        String strJson = this.util.makeStringJsonDB("OFF", tipoSQL, strSQL, null, null, lastID, lenghtBidimensionalArray);
        data_select = this.sk1Comm.ServerEsecuteRequest(FXMLDocumentController.GLOBAL_IP, FXMLDocumentController.GLOBAL_PORT, "dbInteraction#@" + strJson);
        if (!data_select.contains("#ERR:")) {
            JSONArray arrayJson = this.jsonUtil.strJsonToJSONArray(data_select);
            for (int i = 0; i < arrayJson.length(); ++i) {
                try {
                    String descrizione;
                    JSONObject rec = arrayJson.getJSONObject(i);
                    ret = descrizione = rec.get("descrizione").toString().trim();
                    continue;
                }
                catch (JSONException ex) {
                    return null;
                }
            }
        } else {
            return null;
        }
        return ret;
    }

    public String getDescrizioneTa05(String codice) throws JSONException {
        String ret = "";
        ArrayList<String> tipoSQL = new ArrayList<String>();
        ArrayList<String> strSQL = new ArrayList<String>();
        ArrayList<Integer> lenghtBidimensionalArray = new ArrayList<Integer>();
        ArrayList<Boolean> lastID = new ArrayList<Boolean>();
        String data_select = "";
        lastID.add(false);
        String str = "SELECT codice,descrizione FROM accise_t_a05 where codice='" + codice + "'";
        tipoSQL.add("selectRS");
        strSQL.add(str);
        lenghtBidimensionalArray.add(0);
        String strJson = this.util.makeStringJsonDB("OFF", tipoSQL, strSQL, null, null, lastID, lenghtBidimensionalArray);
        data_select = this.sk1Comm.ServerEsecuteRequest(FXMLDocumentController.GLOBAL_IP, FXMLDocumentController.GLOBAL_PORT, "dbInteraction#@" + strJson);
        if (!data_select.contains("#ERR:")) {
            JSONArray arrayJson = this.jsonUtil.strJsonToJSONArray(data_select);
            for (int i = 0; i < arrayJson.length(); ++i) {
                try {
                    String descrizione;
                    JSONObject rec = arrayJson.getJSONObject(i);
                    ret = descrizione = rec.get("descrizione").toString().trim();
                    continue;
                }
                catch (JSONException ex) {
                    return null;
                }
            }
        } else {
            return null;
        }
        return ret;
    }

    public String getDescrizioneT015(String codice) throws JSONException {
        String ret = "";
        ArrayList<String> tipoSQL = new ArrayList<String>();
        ArrayList<String> strSQL = new ArrayList<String>();
        ArrayList<Integer> lenghtBidimensionalArray = new ArrayList<Integer>();
        ArrayList<Boolean> lastID = new ArrayList<Boolean>();
        String data_select = "";
        lastID.add(false);
        String str = "SELECT codice,descrizione FROM accise_t_015 where codice='" + codice + "'";
        tipoSQL.add("selectRS");
        strSQL.add(str);
        lenghtBidimensionalArray.add(0);
        String strJson = this.util.makeStringJsonDB("OFF", tipoSQL, strSQL, null, null, lastID, lenghtBidimensionalArray);
        data_select = this.sk1Comm.ServerEsecuteRequest(FXMLDocumentController.GLOBAL_IP, FXMLDocumentController.GLOBAL_PORT, "dbInteraction#@" + strJson);
        if (!data_select.contains("#ERR:")) {
            JSONArray arrayJson = this.jsonUtil.strJsonToJSONArray(data_select);
            for (int i = 0; i < arrayJson.length(); ++i) {
                try {
                    String descrizione;
                    JSONObject rec = arrayJson.getJSONObject(i);
                    ret = descrizione = rec.get("descrizione").toString().trim();
                    continue;
                }
                catch (JSONException ex) {
                    return null;
                }
            }
        } else {
            return null;
        }
        return ret;
    }

    public String getDescrizioneT014(String codice) throws JSONException {
        String ret = "";
        ArrayList<String> tipoSQL = new ArrayList<String>();
        ArrayList<String> strSQL = new ArrayList<String>();
        ArrayList<Integer> lenghtBidimensionalArray = new ArrayList<Integer>();
        ArrayList<Boolean> lastID = new ArrayList<Boolean>();
        String data_select = "";
        lastID.add(false);
        String str = "SELECT codice,descrizione FROM accise_t_014 where codice='" + codice + "'";
        tipoSQL.add("selectRS");
        strSQL.add(str);
        lenghtBidimensionalArray.add(0);
        String strJson = this.util.makeStringJsonDB("OFF", tipoSQL, strSQL, null, null, lastID, lenghtBidimensionalArray);
        data_select = this.sk1Comm.ServerEsecuteRequest(FXMLDocumentController.GLOBAL_IP, FXMLDocumentController.GLOBAL_PORT, "dbInteraction#@" + strJson);
        if (!data_select.contains("#ERR:")) {
            JSONArray arrayJson = this.jsonUtil.strJsonToJSONArray(data_select);
            for (int i = 0; i < arrayJson.length(); ++i) {
                try {
                    String descrizione;
                    JSONObject rec = arrayJson.getJSONObject(i);
                    ret = descrizione = rec.get("descrizione").toString().trim();
                    continue;
                }
                catch (JSONException ex) {
                    return null;
                }
            }
        } else {
            return null;
        }
        return ret;
    }

    public String getDescrizioneCategoriaVino(String codice) throws JSONException {
        String ret = "";
        ArrayList<String> tipoSQL = new ArrayList<String>();
        ArrayList<String> strSQL = new ArrayList<String>();
        ArrayList<Integer> lenghtBidimensionalArray = new ArrayList<Integer>();
        ArrayList<Boolean> lastID = new ArrayList<Boolean>();
        String data_select = "";
        lastID.add(false);
        strSQL.add("SELECT descrizione FROM accise_t_018 WHERE codice='" + codice + "'");
        tipoSQL.add("selectRS");
        lenghtBidimensionalArray.add(0);
        String strJson = this.util.makeStringJsonDB("OFF", tipoSQL, strSQL, null, null, lastID, lenghtBidimensionalArray);
        data_select = this.sk1Comm.ServerEsecuteRequest(FXMLDocumentController.GLOBAL_IP, FXMLDocumentController.GLOBAL_PORT, "dbInteraction#@" + strJson);
        if (!data_select.contains("#ERR:")) {
            JSONArray arrayJson = this.jsonUtil.strJsonToJSONArray(data_select);
            for (int i = 0; i < arrayJson.length(); ++i) {
                try {
                    String descrizione;
                    JSONObject rec = arrayJson.getJSONObject(i);
                    ret = descrizione = rec.get("descrizione").toString().trim();
                    continue;
                }
                catch (JSONException ex) {
                    return null;
                }
            }
        } else {
            return null;
        }
        return ret;
    }

    public String getDescrizionePaeseTerzo(String codice) throws JSONException {
        String ret = "";
        ArrayList<String> tipoSQL = new ArrayList<String>();
        ArrayList<String> strSQL = new ArrayList<String>();
        ArrayList<Integer> lenghtBidimensionalArray = new ArrayList<Integer>();
        ArrayList<Boolean> lastID = new ArrayList<Boolean>();
        String data_select = "";
        lastID.add(false);
        strSQL.add("SELECT descrizione FROM accise_t_005 WHERE codice='" + codice + "'");
        tipoSQL.add("selectRS");
        lenghtBidimensionalArray.add(0);
        String strJson = this.util.makeStringJsonDB("OFF", tipoSQL, strSQL, null, null, lastID, lenghtBidimensionalArray);
        data_select = this.sk1Comm.ServerEsecuteRequest(FXMLDocumentController.GLOBAL_IP, FXMLDocumentController.GLOBAL_PORT, "dbInteraction#@" + strJson);
        if (!data_select.contains("#ERR:")) {
            JSONArray arrayJson = this.jsonUtil.strJsonToJSONArray(data_select);
            for (int i = 0; i < arrayJson.length(); ++i) {
                try {
                    String descrizione;
                    JSONObject rec = arrayJson.getJSONObject(i);
                    ret = descrizione = rec.get("descrizione").toString().trim();
                    continue;
                }
                catch (JSONException ex) {
                    return null;
                }
            }
        } else {
            return null;
        }
        return ret;
    }

    public String getDescrizioneT001(String codice) throws JSONException {
        String ret = "";
        ArrayList<String> tipoSQL = new ArrayList<String>();
        ArrayList<String> strSQL = new ArrayList<String>();
        ArrayList<Integer> lenghtBidimensionalArray = new ArrayList<Integer>();
        ArrayList<Boolean> lastID = new ArrayList<Boolean>();
        String data_select = "";
        lastID.add(false);
        strSQL.add("SELECT descrizione FROM accise_t_001 WHERE codice='" + codice + "'");
        tipoSQL.add("selectRS");
        lenghtBidimensionalArray.add(0);
        String strJson = this.util.makeStringJsonDB("OFF", tipoSQL, strSQL, null, null, lastID, lenghtBidimensionalArray);
        data_select = this.sk1Comm.ServerEsecuteRequest(FXMLDocumentController.GLOBAL_IP, FXMLDocumentController.GLOBAL_PORT, "dbInteraction#@" + strJson);
        if (!data_select.contains("#ERR:")) {
            JSONArray arrayJson = this.jsonUtil.strJsonToJSONArray(data_select);
            for (int i = 0; i < arrayJson.length(); ++i) {
                try {
                    String descrizione;
                    JSONObject rec = arrayJson.getJSONObject(i);
                    ret = descrizione = rec.get("descrizione").toString().trim();
                    continue;
                }
                catch (JSONException ex) {
                    return null;
                }
            }
        } else {
            return null;
        }
        return ret;
    }

    public String getDescrizionePraticheEnologiche(String codice) throws JSONException {
        String ret = "";
        ArrayList<String> tipoSQL = new ArrayList<String>();
        ArrayList<String> strSQL = new ArrayList<String>();
        ArrayList<Integer> lenghtBidimensionalArray = new ArrayList<Integer>();
        ArrayList<Boolean> lastID = new ArrayList<Boolean>();
        String data_select = "";
        lastID.add(false);
        strSQL.add("SELECT DESCRIZIONE As descrizione FROM sian_t_pratiche_enologiche WHERE CODICE='" + codice + "'");
        tipoSQL.add("selectRS");
        lenghtBidimensionalArray.add(0);
        String strJson = this.util.makeStringJsonDB("OFF", tipoSQL, strSQL, null, null, lastID, lenghtBidimensionalArray);
        data_select = this.sk1Comm.ServerEsecuteRequest(FXMLDocumentController.GLOBAL_IP, FXMLDocumentController.GLOBAL_PORT, "dbInteraction#@" + strJson);
        if (!data_select.contains("#ERR:")) {
            JSONArray arrayJson = this.jsonUtil.strJsonToJSONArray(data_select);
            for (int i = 0; i < arrayJson.length(); ++i) {
                try {
                    String descrizione;
                    JSONObject rec = arrayJson.getJSONObject(i);
                    ret = descrizione = rec.get("descrizione").toString().trim();
                    continue;
                }
                catch (JSONException ex) {
                    return null;
                }
            }
        } else {
            return null;
        }
        return ret;
    }

    public String getDescrizionePaeseProv(String codice) throws JSONException {
        String ret = "";
        ArrayList<String> tipoSQL = new ArrayList<String>();
        ArrayList<String> strSQL = new ArrayList<String>();
        ArrayList<Integer> lenghtBidimensionalArray = new ArrayList<Integer>();
        ArrayList<Boolean> lastID = new ArrayList<Boolean>();
        String data_select = "";
        lastID.add(false);
        strSQL.add("SELECT DESCRIZIONE AS descrizione FROM sian_t_provenienza WHERE CODICE='" + codice + "'");
        tipoSQL.add("selectRS");
        lenghtBidimensionalArray.add(0);
        String strJson = this.util.makeStringJsonDB("OFF", tipoSQL, strSQL, null, null, lastID, lenghtBidimensionalArray);
        data_select = this.sk1Comm.ServerEsecuteRequest(FXMLDocumentController.GLOBAL_IP, FXMLDocumentController.GLOBAL_PORT, "dbInteraction#@" + strJson);
        if (!data_select.contains("#ERR:")) {
            JSONArray arrayJson = this.jsonUtil.strJsonToJSONArray(data_select);
            for (int i = 0; i < arrayJson.length(); ++i) {
                try {
                    String descrizione;
                    JSONObject rec = arrayJson.getJSONObject(i);
                    ret = descrizione = rec.get("descrizione").toString().trim();
                    continue;
                }
                catch (JSONException ex) {
                    return null;
                }
            }
        } else {
            return null;
        }
        return ret;
    }

    public String getDescrizioneVarieta(String codice) throws JSONException {
        String ret = "";
        ArrayList<String> tipoSQL = new ArrayList<String>();
        ArrayList<String> strSQL = new ArrayList<String>();
        ArrayList<Integer> lenghtBidimensionalArray = new ArrayList<Integer>();
        ArrayList<Boolean> lastID = new ArrayList<Boolean>();
        String data_select = "";
        lastID.add(false);
        strSQL.add("SELECT DESCRIZIONE AS descrizione FROM sian_t_varieta WHERE CODICE='" + codice + "'");
        tipoSQL.add("selectRS");
        lenghtBidimensionalArray.add(0);
        String strJson = this.util.makeStringJsonDB("OFF", tipoSQL, strSQL, null, null, lastID, lenghtBidimensionalArray);
        data_select = this.sk1Comm.ServerEsecuteRequest(FXMLDocumentController.GLOBAL_IP, FXMLDocumentController.GLOBAL_PORT, "dbInteraction#@" + strJson);
        if (!data_select.contains("#ERR:")) {
            JSONArray arrayJson = this.jsonUtil.strJsonToJSONArray(data_select);
            for (int i = 0; i < arrayJson.length(); ++i) {
                try {
                    String descrizione;
                    JSONObject rec = arrayJson.getJSONObject(i);
                    ret = descrizione = rec.get("descrizione").toString().trim();
                    continue;
                }
                catch (JSONException ex) {
                    return null;
                }
            }
        } else {
            return null;
        }
        return ret;
    }

    public String getDescrizioneT023(String codice) throws JSONException {
        String ret = "";
        ArrayList<String> tipoSQL = new ArrayList<String>();
        ArrayList<String> strSQL = new ArrayList<String>();
        ArrayList<Integer> lenghtBidimensionalArray = new ArrayList<Integer>();
        ArrayList<Boolean> lastID = new ArrayList<Boolean>();
        String data_select = "";
        lastID.add(false);
        strSQL.add("SELECT descrizione FROM accise_t_023 WHERE codice='" + codice + "'");
        tipoSQL.add("selectRS");
        lenghtBidimensionalArray.add(0);
        String strJson = this.util.makeStringJsonDB("OFF", tipoSQL, strSQL, null, null, lastID, lenghtBidimensionalArray);
        data_select = this.sk1Comm.ServerEsecuteRequest(FXMLDocumentController.GLOBAL_IP, FXMLDocumentController.GLOBAL_PORT, "dbInteraction#@" + strJson);
        if (!data_select.contains("#ERR:")) {
            JSONArray arrayJson = this.jsonUtil.strJsonToJSONArray(data_select);
            for (int i = 0; i < arrayJson.length(); ++i) {
                try {
                    String descrizione;
                    JSONObject rec = arrayJson.getJSONObject(i);
                    ret = descrizione = rec.get("descrizione").toString().trim();
                    continue;
                }
                catch (JSONException ex) {
                    return null;
                }
            }
        } else {
            return null;
        }
        return ret;
    }

    public String getDescrizioneZonaColtivazione(String codice) throws JSONException {
        String ret = "";
        ArrayList<String> tipoSQL = new ArrayList<String>();
        ArrayList<String> strSQL = new ArrayList<String>();
        ArrayList<Integer> lenghtBidimensionalArray = new ArrayList<Integer>();
        ArrayList<Boolean> lastID = new ArrayList<Boolean>();
        String data_select = "";
        lastID.add(false);
        strSQL.add("SELECT descrizione FROM accise_t_019 WHERE codice='" + codice + "'");
        tipoSQL.add("selectRS");
        lenghtBidimensionalArray.add(0);
        String strJson = this.util.makeStringJsonDB("OFF", tipoSQL, strSQL, null, null, lastID, lenghtBidimensionalArray);
        data_select = this.sk1Comm.ServerEsecuteRequest(FXMLDocumentController.GLOBAL_IP, FXMLDocumentController.GLOBAL_PORT, "dbInteraction#@" + strJson);
        if (!data_select.contains("#ERR:")) {
            JSONArray arrayJson = this.jsonUtil.strJsonToJSONArray(data_select);
            for (int i = 0; i < arrayJson.length(); ++i) {
                try {
                    String descrizione;
                    JSONObject rec = arrayJson.getJSONObject(i);
                    ret = descrizione = rec.get("descrizione").toString().trim();
                    continue;
                }
                catch (JSONException ex) {
                    return null;
                }
            }
        } else {
            return null;
        }
        return ret;
    }

    public String getDescrizioneTipoStoccaggio(String codice) throws JSONException {
        String ret = "";
        ArrayList<String> tipoSQL = new ArrayList<String>();
        ArrayList<String> strSQL = new ArrayList<String>();
        ArrayList<Integer> lenghtBidimensionalArray = new ArrayList<Integer>();
        ArrayList<Boolean> lastID = new ArrayList<Boolean>();
        String data_select = "";
        lastID.add(false);
        strSQL.add("SELECT descrizione FROM accise_t_a16 WHERE codice='" + codice + "'");
        tipoSQL.add("selectRS");
        lenghtBidimensionalArray.add(0);
        String strJson = this.util.makeStringJsonDB("OFF", tipoSQL, strSQL, null, null, lastID, lenghtBidimensionalArray);
        data_select = this.sk1Comm.ServerEsecuteRequest(FXMLDocumentController.GLOBAL_IP, FXMLDocumentController.GLOBAL_PORT, "dbInteraction#@" + strJson);
        if (!data_select.contains("#ERR:")) {
            JSONArray arrayJson = this.jsonUtil.strJsonToJSONArray(data_select);
            for (int i = 0; i < arrayJson.length(); ++i) {
                try {
                    String descrizione;
                    JSONObject rec = arrayJson.getJSONObject(i);
                    ret = descrizione = rec.get("descrizione").toString().trim();
                    continue;
                }
                catch (JSONException ex) {
                    return null;
                }
            }
        } else {
            return null;
        }
        return ret;
    }

    public List<CodiceDescrizioneComboBox> fillCodiceInstMexal() throws JSONException {
        ArrayList<CodiceDescrizioneComboBox> lista_codinstmexal = new ArrayList<CodiceDescrizioneComboBox>();
        ArrayList<String> tipoSQL = new ArrayList<String>();
        ArrayList<String> strSQL = new ArrayList<String>();
        ArrayList<Integer> lenghtBidimensionalArray = new ArrayList<Integer>();
        ArrayList<Boolean> lastID = new ArrayList<Boolean>();
        String data_select = "";
        lastID.add(false);
        strSQL.add("USE mxdbr;SELECT IFNULL(a.id_installazione,0) AS id_installazione,IF(IFNULL(a.ragsoc,'')='',a.nome,a.ragsoc) AS rag_soc,IFNULL(a.indirizzo,'') AS indirizzo FROM azie_ana AS a GROUP BY a.id_installazione ");
        tipoSQL.add("selectRS");
        lenghtBidimensionalArray.add(0);
        String strJson = this.util.makeStringJsonDB("OFF", tipoSQL, strSQL, null, null, lastID, lenghtBidimensionalArray);
        data_select = this.sk1Comm.ServerEsecuteRequest(FXMLDocumentController.GLOBAL_IP, FXMLDocumentController.GLOBAL_PORT, "dbInteraction#@" + strJson);
        if (!data_select.contains("#ERR:")) {
            JSONArray arrayJson = this.jsonUtil.strJsonToJSONArray(data_select);
            for (int i = 0; i < arrayJson.length(); ++i) {
                try {
                    JSONObject rec = arrayJson.getJSONObject(i);
                    String id_installazione = rec.get("id_installazione").toString();
                    String rag_soc = rec.getString("rag_soc");
                    String indirizzo = rec.getString("indirizzo");
                    lista_codinstmexal.add(new CodiceDescrizioneComboBox(id_installazione, id_installazione + " - " + rag_soc));
                    continue;
                }
                catch (JSONException ex) {
                    return null;
                }
            }
        } else {
            return null;
        }
        return lista_codinstmexal;
    }

    public Integer getMaxProgressivoData(String icqrf, String data) throws JSONException {
        Integer ret = 0;
        ArrayList<String> strSQL = new ArrayList<String>();
        ArrayList<String> tipoSQL = new ArrayList<String>();
        ArrayList<Boolean> lastID = new ArrayList<Boolean>();
        strSQL = new ArrayList();
        tipoSQL = new ArrayList();
        lastID = new ArrayList();
        lastID.add(false);
        strSQL.add("SELECT IFNULL(max(id),0) AS id FROM sian_send_counter WHERE icqrf='" + icqrf + "' AND data='" + data + "' ");
        tipoSQL.add("select");
        String strJson = this.util.makeStringJsonDB("OFF", tipoSQL, strSQL, null, null, lastID, null);
        String data_select = this.sk1Comm.ServerEsecuteRequest(FXMLDocumentController.GLOBAL_IP, FXMLDocumentController.GLOBAL_PORT, "dbInteraction#@" + strJson);
        if (!data_select.contains("#ERR:")) {
            JSONArray arrayJson = this.jsonUtil.strJsonToJSONArray(data_select);
            for (int i = 0; i < arrayJson.length(); ++i) {
                ret = arrayJson.getJSONObject(i).getInt("id");
            }
        }
        return ret;
    }

    public String getSiglaFromOperazione(String id) throws JSONException {
        String ret = "";
        ArrayList<String> strSQL = new ArrayList<String>();
        ArrayList<String> tipoSQL = new ArrayList<String>();
        ArrayList<Boolean> lastID = new ArrayList<Boolean>();
        strSQL = new ArrayList();
        tipoSQL = new ArrayList();
        lastID = new ArrayList();
        lastID.add(false);
        strSQL.add("SELECT mx_doc_sigla FROM c_operazioni WHERE id=" + id);
        tipoSQL.add("select");
        String strJson = this.util.makeStringJsonDB("OFF", tipoSQL, strSQL, null, null, lastID, null);
        String data_select = this.sk1Comm.ServerEsecuteRequest(FXMLDocumentController.GLOBAL_IP, FXMLDocumentController.GLOBAL_PORT, "dbInteraction#@" + strJson);
        if (!data_select.contains("#ERR:")) {
            JSONArray arrayJson = this.jsonUtil.strJsonToJSONArray(data_select);
            for (int i = 0; i < arrayJson.length(); ++i) {
                ret = arrayJson.getJSONObject(i).getString("mx_doc_sigla");
            }
        }
        return ret;
    }

    public String getIdentificativoComunicazione(String anno, String operazione, String numeratore) throws JSONException {
        String ret = "0";
        ArrayList<String> tipoSQL = new ArrayList<String>();
        ArrayList<String> strSQL = new ArrayList<String>();
        ArrayList<Integer> lenghtBidimensionalArray = new ArrayList<Integer>();
        ArrayList<Boolean> lastID = new ArrayList<Boolean>();
        String data_select = "";
        lastID.add(false);
        String str = "SELECT IFNULL(numeratore,0) AS numeratore FROM t_numeratori_comunicazioni WHERE anno='" + anno + "' AND icqrf='" + FXMLDocumentController.GLOBAL_ICQRF + "' AND azienda='" + FXMLDocumentController.GLOBAL_AZIENDA + "' AND sotto_az='" + FXMLDocumentController.GLOBAL_SOTTOAZZ + "' AND operazione='" + operazione + "' ";
        strSQL.add(str);
        tipoSQL.add("select");
        lenghtBidimensionalArray.add(0);
        String strJson = this.util.makeStringJsonDB("ON", tipoSQL, strSQL, null, null, lastID, lenghtBidimensionalArray);
        data_select = this.sk1Comm.ServerEsecuteRequest(FXMLDocumentController.GLOBAL_IP, FXMLDocumentController.GLOBAL_PORT, "dbInteraction#@" + strJson);
        if (!data_select.contains("#ERR:")) {
            JSONArray arrayJson = this.jsonUtil.strJsonToJSONArray(data_select);
            for (int i = 0; i < arrayJson.length(); ++i) {
                try {
                    JSONObject rec = arrayJson.getJSONObject(i);
                    ret = rec.get("numeratore").toString();
                    continue;
                }
                catch (Exception ex) {
                    this.util.alertWindow(Alert.AlertType.ERROR, "ERRORE", "", ex.toString());
                }
            }
        } else {
            this.util.alertWindow(Alert.AlertType.ERROR, "ERRORE", "", data_select);
        }
        return ret;
    }

    public boolean getIfIdentificativoComunicazioneExist(String anno, String operazione, String numeratore) throws JSONException {
        boolean ret = false;
        ArrayList<String> tipoSQL = new ArrayList<String>();
        ArrayList<String> strSQL = new ArrayList<String>();
        ArrayList<Integer> lenghtBidimensionalArray = new ArrayList<Integer>();
        ArrayList<Boolean> lastID = new ArrayList<Boolean>();
        String data_select = "";
        lastID.add(false);
        String str = "SELECT IFNULL(numeratore,0) AS numeratore FROM t_numeratori_comunicazioni WHERE anno='" + anno + "' AND icqrf='" + FXMLDocumentController.GLOBAL_ICQRF + "' AND azienda='" + FXMLDocumentController.GLOBAL_AZIENDA + "' AND sotto_az='" + FXMLDocumentController.GLOBAL_SOTTOAZZ + "' AND operazione='" + operazione + "' AND numeratore='" + numeratore + "' ";
        strSQL.add(str);
        tipoSQL.add("select");
        lenghtBidimensionalArray.add(0);
        String strJson = this.util.makeStringJsonDB("ON", tipoSQL, strSQL, null, null, lastID, lenghtBidimensionalArray);
        data_select = this.sk1Comm.ServerEsecuteRequest(FXMLDocumentController.GLOBAL_IP, FXMLDocumentController.GLOBAL_PORT, "dbInteraction#@" + strJson);
        if (!data_select.contains("#ERR:")) {
            JSONArray arrayJson = this.jsonUtil.strJsonToJSONArray(data_select);
            for (int i = 0; i < arrayJson.length(); ++i) {
                try {
                    JSONObject rec = arrayJson.getJSONObject(i);
                    ret = true;
                    continue;
                }
                catch (Exception ex) {
                    this.util.alertWindow(Alert.AlertType.ERROR, "ERRORE", "", ex.toString());
                }
            }
        } else {
            this.util.alertWindow(Alert.AlertType.ERROR, "ERRORE", "", data_select);
        }
        return ret;
    }

    public boolean getOperazioneComunicazioniStatoVuoto(String azienda, String sotto_az, String icqrf, String id_oper) throws JSONException {
        boolean ret = false;
        ArrayList<String> tipoSQL = new ArrayList<String>();
        ArrayList<String> strSQL = new ArrayList<String>();
        ArrayList<Integer> lenghtBidimensionalArray = new ArrayList<Integer>();
        ArrayList<Boolean> lastID = new ArrayList<Boolean>();
        String data_select = "";
        lastID.add(false);
        String str = "SELECT IFNULL(stato,'') AS stato FROM t_testata_comunicazioni WHERE azienda='" + azienda + "' AND sotto_az='" + sotto_az + "' AND icqrf='" + icqrf + "' AND id=" + id_oper;
        strSQL.add(str);
        tipoSQL.add("select");
        lenghtBidimensionalArray.add(0);
        String strJson = this.util.makeStringJsonDB("ON", tipoSQL, strSQL, null, null, lastID, lenghtBidimensionalArray);
        data_select = this.sk1Comm.ServerEsecuteRequest(FXMLDocumentController.GLOBAL_IP, FXMLDocumentController.GLOBAL_PORT, "dbInteraction#@" + strJson);
        if (!data_select.contains("#ERR:")) {
            JSONArray arrayJson = this.jsonUtil.strJsonToJSONArray(data_select);
            for (int i = 0; i < arrayJson.length(); ++i) {
                try {
                    JSONObject rec = arrayJson.getJSONObject(i);
                    String jhret = rec.get("stato").toString().trim();
                    if (!jhret.equals("")) continue;
                    ret = true;
                    continue;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        return ret;
    }

    public ObservableList<ColumnTableComunicazioni> refreshListaOperazioniComunicazione(String oper, int WBS_SHOW_LISTE_OPERAZIONI) throws JSONException {
        ObservableList lista_operazioni = FXCollections.observableArrayList();
        ArrayList<String> tipoSQL = new ArrayList<String>();
        ArrayList<String> strSQL = new ArrayList<String>();
        ArrayList<Integer> lenghtBidimensionalArray = new ArrayList<Integer>();
        ArrayList<Boolean> lastID = new ArrayList<Boolean>();
        String data_select = "";
        lastID.add(false);
        LocalDate data_back = this.util.getDateBeforeDate(WBS_SHOW_LISTE_OPERAZIONI);
        LocalDate data_ora = LocalDate.now();
        String str = "SELECT id,codice,data_oper,operazione FROM t_testata_comunicazioni AS a WHERE operazione='" + oper + "' AND a.azienda='" + FXMLDocumentController.GLOBAL_AZIENDA + "' AND a.icqrf='" + FXMLDocumentController.GLOBAL_ICQRF + "' AND a.sotto_az='" + FXMLDocumentController.GLOBAL_SOTTOAZZ + "' AND a.data_oper>='" + data_back.toString() + "' ORDER BY a.data_oper DESC,a.id DESC";
        strSQL.add(str);
        tipoSQL.add("select");
        lenghtBidimensionalArray.add(0);
        String strJson = this.util.makeStringJsonDB("ON", tipoSQL, strSQL, null, null, lastID, lenghtBidimensionalArray);
        data_select = this.sk1Comm.ServerEsecuteRequest(FXMLDocumentController.GLOBAL_IP, FXMLDocumentController.GLOBAL_PORT, "dbInteraction#@" + strJson);
        if (!data_select.contains("#ERR:")) {
            lista_operazioni.clear();
            JSONArray arrayJson = this.jsonUtil.strJsonToJSONArray(data_select);
            for (int i = 0; i < arrayJson.length(); ++i) {
                try {
                    JSONObject rec = arrayJson.getJSONObject(i);
                    String currentDate = this.util.AnnoMeseGiornoTOGiornoMeseAnno(rec.getString("data_oper"));
                    lista_operazioni.add((Object)new ColumnTableComunicazioni(rec.getInt("id"), rec.getString("codice"), rec.getString("operazione"), currentDate));
                    continue;
                }
                catch (ParseException | JSONException ex) {
                    this.util.alertWindow(Alert.AlertType.ERROR, "ERRORE", "", ex.toString());
                }
            }
        } else {
            this.util.alertWindow(Alert.AlertType.ERROR, "ERRORE", "", data_select);
        }
        return lista_operazioni;
    }

    public Ricerca() {
        try {
            this.util = new Utility();
        }
        catch (IOException ex) {
            Logger.getLogger(Ricerca.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public String getSianVolumeNominaleProdotto(String codice) throws JSONException {
        String ret = "0.0";
        ArrayList<String> strSQL = new ArrayList<String>();
        ArrayList<String> tipoSQL = new ArrayList<String>();
        ArrayList<Boolean> lastID = new ArrayList<Boolean>();
        strSQL = new ArrayList();
        tipoSQL = new ArrayList();
        lastID = new ArrayList();
        lastID.add(false);
        strSQL.add("SELECT a.sian_volume_nominale FROM gen_tipo_vino_ana AS a  LEFT JOIN gen_tipo_vino_ana_mx AS b ON a.id=b.id_tipo_vino_ana  WHERE a.codice='" + codice.replace("'", "\\'") + "' AND a.azienda='" + FXMLDocumentController.GLOBAL_AZIENDA + "' AND a.sotto_az='" + FXMLDocumentController.GLOBAL_SOTTOAZZ + "' AND a.icqrf='" + FXMLDocumentController.GLOBAL_ICQRF + "' AND a.cod_committente='" + FXMLDocumentController.GLOBAL_CODCOMM + "'");
        tipoSQL.add("select");
        String strJson = this.util.makeStringJsonDB("OFF", tipoSQL, strSQL, null, null, lastID, null);
        String data_select = this.sk1Comm.ServerEsecuteRequest(FXMLDocumentController.GLOBAL_IP, FXMLDocumentController.GLOBAL_PORT, "dbInteraction#@" + strJson);
        if (!data_select.contains("#ERR:")) {
            JSONArray arrayJson = this.jsonUtil.strJsonToJSONArray(data_select);
            for (int i = 0; i < arrayJson.length(); ++i) {
                JSONObject obj = arrayJson.getJSONObject(i);
                ret = obj.get("sian_volume_nominale").toString();
            }
        }
        return ret;
    }

    public String getCodiceSianAnagraficaCliente(String codice) throws JSONException {
        String ret = "";
        ArrayList<String> strSQL = new ArrayList<String>();
        ArrayList<String> tipoSQL = new ArrayList<String>();
        ArrayList<Boolean> lastID = new ArrayList<Boolean>();
        strSQL = new ArrayList();
        tipoSQL = new ArrayList();
        lastID = new ArrayList();
        lastID.add(false);
        strSQL.add("SELECT IFNULL(a.cod_sian,'') AS cod_sian FROM gen_ana_clifor AS a  WHERE a.codice='" + codice.replace("'", "\\'") + "' AND a.azienda='" + FXMLDocumentController.GLOBAL_AZIENDA + "' AND a.sotto_az='" + FXMLDocumentController.GLOBAL_SOTTOAZZ + "'");
        tipoSQL.add("select");
        String strJson = this.util.makeStringJsonDB("OFF", tipoSQL, strSQL, null, null, lastID, null);
        String data_select = this.sk1Comm.ServerEsecuteRequest(FXMLDocumentController.GLOBAL_IP, FXMLDocumentController.GLOBAL_PORT, "dbInteraction#@" + strJson);
        if (!data_select.contains("#ERR:")) {
            JSONArray arrayJson = this.jsonUtil.strJsonToJSONArray(data_select);
            for (int i = 0; i < arrayJson.length(); ++i) {
                JSONObject obj = arrayJson.getJSONObject(i);
                ret = obj.get("cod_sian").toString();
            }
        }
        return ret;
    }

    public String getProdottoFromCaratteristicheSenzaCert(String sian_codstatofisico, String sian_attocert, String sian_classificazione, String sian_altrevarieta, String sian_biologico, String sian_codcategoria, String sian_codcolore, String sian_coddopigp, String sian_codebacchus, String sian_codpartita, String sian_codsottozona, String sian_codvigna, String codzonaviticola, String sian_massavol, String origine_uve, String sian_annata, String sian_percannata, String sian_varieta, String sian_percvarieta, String volume_nominale, String provenienza, String sian_menzioni, String sian_paeseprovenienza, String praticheenologiche) throws JSONException {
        String ret = "";
        ArrayList<String> tipoSQL = new ArrayList<String>();
        ArrayList<String> strSQL = new ArrayList<String>();
        ArrayList<Integer> lenghtBidimensionalArray = new ArrayList<Integer>();
        ArrayList<Boolean> lastID = new ArrayList<Boolean>();
        String data_select = "";
        lastID.add(false);
        String str = "SELECT codice FROM gen_tipo_vino_ana WHERE sian_cod_stato_fisico='" + sian_codstatofisico + "' AND sian_codice_dop_igp='" + sian_coddopigp + "' AND sian_altre_varieta='" + sian_altrevarieta + "' AND sian_annata='" + sian_annata + "' AND sian_annata_percentuale='" + sian_percannata + "'  AND sian_atto_certificato='" + sian_attocert + "' AND sian_biologico='" + sian_biologico + "' AND sian_cat_prodotto='" + sian_codcategoria + "' AND sian_classificazione='" + sian_classificazione + "' AND sian_cod_ebac='" + sian_codebacchus + "' AND sian_cod_partita_gg_inv='" + sian_codpartita + "' AND sian_cod_sottozona='" + sian_codsottozona + "'  AND sian_cod_vigna='" + sian_codvigna + "' AND sian_cod_zona_viticola='" + codzonaviticola + "' AND sian_colore='" + sian_codcolore + "' AND sian_massa_volumica='" + sian_massavol + "' AND sian_menzioni='" + sian_menzioni + "' AND sian_origine_uve='" + origine_uve + "' AND sian_paese='" + provenienza + "' AND sian_paese_provenienza='" + sian_paeseprovenienza + "' ANd sian_pratiche_eno='" + praticheenologiche + "' AND sian_perc_varieta='" + sian_percvarieta + "' AND sian_varieta='" + sian_varieta + "' AND sian_volume_nominale='" + volume_nominale + "' AND azienda='" + FXMLDocumentController.GLOBAL_AZIENDA + "' AND sotto_az='" + FXMLDocumentController.GLOBAL_SOTTOAZZ + "' AND icqrf='" + FXMLDocumentController.GLOBAL_ICQRF + "' AND cod_committente='' ";
        strSQL.add(str);
        tipoSQL.add("select");
        lenghtBidimensionalArray.add(0);
        String strJson = this.util.makeStringJsonDB("ON", tipoSQL, strSQL, null, null, lastID, lenghtBidimensionalArray);
        data_select = this.sk1Comm.ServerEsecuteRequest(FXMLDocumentController.GLOBAL_IP, FXMLDocumentController.GLOBAL_PORT, "dbInteraction#@" + strJson);
        if (!data_select.contains("#ERR:")) {
            JSONArray arrayJson = this.jsonUtil.strJsonToJSONArray(data_select);
            for (int i = 0; i < arrayJson.length(); ++i) {
                try {
                    JSONObject rec = arrayJson.getJSONObject(i);
                    ret = rec.get("codice").toString();
                    continue;
                }
                catch (Exception ex) {
                    this.util.alertWindow(Alert.AlertType.ERROR, "ERRORE", "", ex.toString());
                }
            }
        } else {
            this.util.alertWindow(Alert.AlertType.ERROR, "ERRORE", "", data_select);
        }
        return ret;
    }

    public String getPercPiuFromConf(int id) throws JSONException {
        String ret = "";
        ArrayList<String> tipoSQL = new ArrayList<String>();
        ArrayList<String> strSQL = new ArrayList<String>();
        ArrayList<Integer> lenghtBidimensionalArray = new ArrayList<Integer>();
        ArrayList<Boolean> lastID = new ArrayList<Boolean>();
        String data_select = "";
        lastID.add(false);
        String str = "SELECT percpiu FROM f_movimenti WHERE id=" + id;
        strSQL.add(str);
        tipoSQL.add("select");
        lenghtBidimensionalArray.add(0);
        String strJson = this.util.makeStringJsonDB("ON", tipoSQL, strSQL, null, null, lastID, lenghtBidimensionalArray);
        data_select = this.sk1Comm.ServerEsecuteRequest(FXMLDocumentController.GLOBAL_IP, FXMLDocumentController.GLOBAL_PORT, "dbInteraction#@" + strJson);
        if (!data_select.contains("#ERR:")) {
            JSONArray arrayJson = this.jsonUtil.strJsonToJSONArray(data_select);
            for (int i = 0; i < arrayJson.length(); ++i) {
                try {
                    JSONObject rec = arrayJson.getJSONObject(i);
                    ret = rec.get("percpiu").toString();
                    continue;
                }
                catch (Exception ex) {
                    this.util.alertWindow(Alert.AlertType.ERROR, "ERRORE", "", ex.toString());
                }
            }
        } else {
            this.util.alertWindow(Alert.AlertType.ERROR, "ERRORE", "", data_select);
        }
        return ret;
    }

    public String getProdottoMXFromAccise(String codice) throws JSONException {
        String ret = "";
        ArrayList<String> tipoSQL = new ArrayList<String>();
        ArrayList<String> strSQL = new ArrayList<String>();
        ArrayList<Integer> lenghtBidimensionalArray = new ArrayList<Integer>();
        ArrayList<Boolean> lastID = new ArrayList<Boolean>();
        String data_select = "";
        lastID.add(false);
        String str = "SELECT IFNULL(b.codice,'') AS codice FROM gen_ana_accise_articoli AS a LEFT JOIN gen_ana_accise_articoli_mx AS b ON a.id=b.id_tipo_vino_ana WHERE a.codice='" + codice + "' AND a.azienda='" + FXMLDocumentController.GLOBAL_AZIENDA + "' AND a.sotto_az='" + FXMLDocumentController.GLOBAL_SOTTOAZZ + "' AND a.cod_accisa='" + FXMLDocumentController.GLOBAL_ICQRF + "' ";
        strSQL.add(str);
        tipoSQL.add("select");
        lenghtBidimensionalArray.add(0);
        String strJson = this.util.makeStringJsonDB("ON", tipoSQL, strSQL, null, null, lastID, lenghtBidimensionalArray);
        data_select = this.sk1Comm.ServerEsecuteRequest(FXMLDocumentController.GLOBAL_IP, FXMLDocumentController.GLOBAL_PORT, "dbInteraction#@" + strJson);
        if (!data_select.contains("#ERR:")) {
            JSONArray arrayJson = this.jsonUtil.strJsonToJSONArray(data_select);
            for (int i = 0; i < arrayJson.length(); ++i) {
                try {
                    JSONObject rec = arrayJson.getJSONObject(i);
                    ret = rec.get("codice").toString();
                    continue;
                }
                catch (Exception ex) {
                    this.util.alertWindow(Alert.AlertType.ERROR, "ERRORE", "", ex.toString());
                }
            }
        } else {
            ret = data_select;
        }
        return ret;
    }

    public String getProdottoMXFromWBS(String codice) throws JSONException {
        String ret = "";
        ArrayList<String> tipoSQL = new ArrayList<String>();
        ArrayList<String> strSQL = new ArrayList<String>();
        ArrayList<Integer> lenghtBidimensionalArray = new ArrayList<Integer>();
        ArrayList<Boolean> lastID = new ArrayList<Boolean>();
        String data_select = "";
        lastID.add(false);
        String str = "SELECT IFNULL(b.codice,'') AS codice FROM gen_tipo_vino_ana AS a LEFT JOIN gen_tipo_vino_ana_mx AS b ON a.id=b.id_tipo_vino_ana WHERE a.codice='" + codice + "' AND a.azienda='" + FXMLDocumentController.GLOBAL_AZIENDA + "' AND a.sotto_az='" + FXMLDocumentController.GLOBAL_SOTTOAZZ + "' AND a.icqrf='" + FXMLDocumentController.GLOBAL_ICQRF + "' AND a.cod_committente='" + FXMLDocumentController.GLOBAL_CODCOMM + "' ";
        strSQL.add(str);
        tipoSQL.add("select");
        lenghtBidimensionalArray.add(0);
        String strJson = this.util.makeStringJsonDB("ON", tipoSQL, strSQL, null, null, lastID, lenghtBidimensionalArray);
        data_select = this.sk1Comm.ServerEsecuteRequest(FXMLDocumentController.GLOBAL_IP, FXMLDocumentController.GLOBAL_PORT, "dbInteraction#@" + strJson);
        if (!data_select.contains("#ERR:")) {
            JSONArray arrayJson = this.jsonUtil.strJsonToJSONArray(data_select);
            for (int i = 0; i < arrayJson.length(); ++i) {
                try {
                    JSONObject rec = arrayJson.getJSONObject(i);
                    ret = rec.get("codice").toString();
                    continue;
                }
                catch (Exception ex) {
                    this.util.alertWindow(Alert.AlertType.ERROR, "ERRORE", "", ex.toString());
                }
            }
        } else {
            ret = data_select;
        }
        return ret;
    }

    public String getNumeroDocumentoMXAccise(String sigla, String tipo_mov, int id) throws JSONException {
        String ret = "0";
        ArrayList<String> tipoSQL = new ArrayList<String>();
        ArrayList<String> strSQL = new ArrayList<String>();
        ArrayList<Integer> lenghtBidimensionalArray = new ArrayList<Integer>();
        ArrayList<Boolean> lastID = new ArrayList<Boolean>();
        String data_select = "";
        lastID.add(false);
        String str = "SELECT IFNULL(b.numero,0) AS numero FROM a_testata_ie815 AS a LEFT JOIN a_testataie815_mx AS b ON a.id=b.id_testata WHERE a.id=" + id + " AND b.sigla='" + sigla + "' ";
        strSQL.add(str);
        tipoSQL.add("select");
        lenghtBidimensionalArray.add(0);
        String strJson = this.util.makeStringJsonDB("ON", tipoSQL, strSQL, null, null, lastID, lenghtBidimensionalArray);
        data_select = this.sk1Comm.ServerEsecuteRequest(FXMLDocumentController.GLOBAL_IP, FXMLDocumentController.GLOBAL_PORT, "dbInteraction#@" + strJson);
        if (!data_select.contains("#ERR:")) {
            JSONArray arrayJson = this.jsonUtil.strJsonToJSONArray(data_select);
            for (int i = 0; i < arrayJson.length(); ++i) {
                try {
                    JSONObject rec = arrayJson.getJSONObject(i);
                    ret = rec.get("numero").toString();
                    continue;
                }
                catch (Exception ex) {
                    ret = ex.toString();
                }
            }
        } else {
            ret = data_select;
        }
        return ret;
    }

    public String getNumeroDocumentoMX(String sigla, String tipo_mov, int id) throws JSONException {
        String ret = "0";
        ArrayList<String> tipoSQL = new ArrayList<String>();
        ArrayList<String> strSQL = new ArrayList<String>();
        ArrayList<Integer> lenghtBidimensionalArray = new ArrayList<Integer>();
        ArrayList<Boolean> lastID = new ArrayList<Boolean>();
        String data_select = "";
        lastID.add(false);
        String str = "SELECT IFNULL(b.mx_doc_num,0) AS numero FROM c_operazioni AS a LEFT JOIN c_movimenti_mx AS b ON a.id=b.id_oper WHERE a.id=" + id + " AND b.mx_doc_sigla='" + sigla + "' AND b.tipo_mov='" + tipo_mov + "' ";
        strSQL.add(str);
        tipoSQL.add("select");
        lenghtBidimensionalArray.add(0);
        String strJson = this.util.makeStringJsonDB("ON", tipoSQL, strSQL, null, null, lastID, lenghtBidimensionalArray);
        data_select = this.sk1Comm.ServerEsecuteRequest(FXMLDocumentController.GLOBAL_IP, FXMLDocumentController.GLOBAL_PORT, "dbInteraction#@" + strJson);
        if (!data_select.contains("#ERR:")) {
            JSONArray arrayJson = this.jsonUtil.strJsonToJSONArray(data_select);
            for (int i = 0; i < arrayJson.length(); ++i) {
                try {
                    JSONObject rec = arrayJson.getJSONObject(i);
                    ret = rec.get("numero").toString();
                    continue;
                }
                catch (Exception ex) {
                    ret = ex.toString();
                }
            }
        } else {
            ret = data_select;
        }
        return ret;
    }

    public int getNumeroSerie(String azienda, String sotto_az, String serie, String sigla, String anno) throws JSONException {
        int ret = 0;
        ArrayList<String> tipoSQL = new ArrayList<String>();
        ArrayList<String> strSQL = new ArrayList<String>();
        ArrayList<Integer> lenghtBidimensionalArray = new ArrayList<Integer>();
        ArrayList<Boolean> lastID = new ArrayList<Boolean>();
        String data_select = "";
        lastID.add(false);
        String str = "SELECT IFNULL(numero,0) AS numero FROM f_numeratori_doc WHERE azienda='" + azienda + "' AND sotto_az='" + sotto_az + "' AND serie='" + serie + "' ANd sigla='" + sigla + "' AND anno=" + anno + " ";
        strSQL.add(str);
        tipoSQL.add("select");
        lenghtBidimensionalArray.add(0);
        String strJson = this.util.makeStringJsonDB("ON", tipoSQL, strSQL, null, null, lastID, lenghtBidimensionalArray);
        data_select = this.sk1Comm.ServerEsecuteRequest(FXMLDocumentController.GLOBAL_IP, FXMLDocumentController.GLOBAL_PORT, "dbInteraction#@" + strJson);
        if (!data_select.contains("#ERR:")) {
            JSONArray arrayJson = this.jsonUtil.strJsonToJSONArray(data_select);
            for (int i = 0; i < arrayJson.length(); ++i) {
                try {
                    JSONObject rec = arrayJson.getJSONObject(i);
                    ret = Integer.parseInt(rec.get("numero").toString());
                    continue;
                }
                catch (Exception ex) {
                    this.util.alertWindow(Alert.AlertType.ERROR, "ERRORE", "", ex.toString());
                }
            }
        } else {
            this.util.alertWindow(Alert.AlertType.ERROR, "ERRORE", "", data_select);
        }
        return ret;
    }

    public String getSerieDefault(boolean autofattura, String azienda, String sotto_az) throws JSONException {
        String ret = "";
        ArrayList<String> tipoSQL = new ArrayList<String>();
        ArrayList<String> strSQL = new ArrayList<String>();
        ArrayList<Integer> lenghtBidimensionalArray = new ArrayList<Integer>();
        ArrayList<Boolean> lastID = new ArrayList<Boolean>();
        String data_select = "";
        lastID.add(false);
        String cerca = "";
        cerca = autofattura ? "WBS_SERIE_AUTOFATTUREPN_DEFAULT" : "WBS_SERIE_FATTUREPN_DEFAULT";
        String str = "SELECT valore FROM gen_ini WHERE azienda='" + azienda + "' AND sotto_az='" + sotto_az + "' AND codice='" + cerca + "'";
        strSQL.add(str);
        tipoSQL.add("select");
        lenghtBidimensionalArray.add(0);
        String strJson = this.util.makeStringJsonDB("ON", tipoSQL, strSQL, null, null, lastID, lenghtBidimensionalArray);
        data_select = this.sk1Comm.ServerEsecuteRequest(FXMLDocumentController.GLOBAL_IP, FXMLDocumentController.GLOBAL_PORT, "dbInteraction#@" + strJson);
        if (!data_select.contains("#ERR:")) {
            JSONArray arrayJson = this.jsonUtil.strJsonToJSONArray(data_select);
            for (int i = 0; i < arrayJson.length(); ++i) {
                try {
                    JSONObject rec = arrayJson.getJSONObject(i);
                    ret = rec.get("valore").toString();
                    continue;
                }
                catch (Exception ex) {
                    this.util.alertWindow(Alert.AlertType.ERROR, "ERRORE", "", ex.toString());
                }
            }
        } else {
            this.util.alertWindow(Alert.AlertType.ERROR, "ERRORE", "", data_select);
        }
        return ret;
    }

    public String getIVADefault(boolean autofattura, String azienda, String sotto_az) throws JSONException {
        String ret = "";
        ArrayList<String> tipoSQL = new ArrayList<String>();
        ArrayList<String> strSQL = new ArrayList<String>();
        ArrayList<Integer> lenghtBidimensionalArray = new ArrayList<Integer>();
        ArrayList<Boolean> lastID = new ArrayList<Boolean>();
        String data_select = "";
        lastID.add(false);
        String cerca = "";
        cerca = autofattura ? "WBS_ALIQ_IVA_AUTOFATTURA" : "WBS_ALIQ_IVA_FATTURA";
        String str = "SELECT valore FROM gen_ini WHERE azienda='" + azienda + "' AND sotto_az='" + sotto_az + "' AND codice='" + cerca + "'";
        strSQL.add(str);
        tipoSQL.add("select");
        lenghtBidimensionalArray.add(0);
        String strJson = this.util.makeStringJsonDB("ON", tipoSQL, strSQL, null, null, lastID, lenghtBidimensionalArray);
        data_select = this.sk1Comm.ServerEsecuteRequest(FXMLDocumentController.GLOBAL_IP, FXMLDocumentController.GLOBAL_PORT, "dbInteraction#@" + strJson);
        if (!data_select.contains("#ERR:")) {
            JSONArray arrayJson = this.jsonUtil.strJsonToJSONArray(data_select);
            for (int i = 0; i < arrayJson.length(); ++i) {
                try {
                    JSONObject rec = arrayJson.getJSONObject(i);
                    ret = rec.get("valore").toString();
                    continue;
                }
                catch (Exception ex) {
                    this.util.alertWindow(Alert.AlertType.ERROR, "ERRORE", "", ex.toString());
                }
            }
        } else {
            this.util.alertWindow(Alert.AlertType.ERROR, "ERRORE", "", data_select);
        }
        return ret;
    }

    public String getIVADefaultCliente(String azienda, String sotto_az, String codice) throws JSONException {
        String ret = "";
        ArrayList<String> tipoSQL = new ArrayList<String>();
        ArrayList<String> strSQL = new ArrayList<String>();
        ArrayList<Integer> lenghtBidimensionalArray = new ArrayList<Integer>();
        ArrayList<Boolean> lastID = new ArrayList<Boolean>();
        String data_select = "";
        lastID.add(false);
        String str = "SELECT iva FROM gen_ana_clifor WHERE azienda='" + azienda + "' AND sotto_az='" + sotto_az + "' AND codice='" + codice + "'";
        strSQL.add(str);
        tipoSQL.add("select");
        lenghtBidimensionalArray.add(0);
        String strJson = this.util.makeStringJsonDB("ON", tipoSQL, strSQL, null, null, lastID, lenghtBidimensionalArray);
        data_select = this.sk1Comm.ServerEsecuteRequest(FXMLDocumentController.GLOBAL_IP, FXMLDocumentController.GLOBAL_PORT, "dbInteraction#@" + strJson);
        if (!data_select.contains("#ERR:")) {
            JSONArray arrayJson = this.jsonUtil.strJsonToJSONArray(data_select);
            for (int i = 0; i < arrayJson.length(); ++i) {
                try {
                    JSONObject rec = arrayJson.getJSONObject(i);
                    ret = rec.get("iva").toString().trim();
                    boolean oo = StringUtils.isNumeric((CharSequence)ret);
                    if (oo) continue;
                    ret = "";
                    continue;
                }
                catch (Exception ex) {
                    this.util.alertWindow(Alert.AlertType.ERROR, "ERRORE", "", ex.toString());
                }
            }
        } else {
            this.util.alertWindow(Alert.AlertType.ERROR, "ERRORE", "", data_select);
        }
        return ret;
    }

    public boolean getAutofatturaCliente(String codice, String azienda, String sotto_az) throws JSONException {
        Boolean res = false;
        String ret = "";
        ArrayList<String> tipoSQL = new ArrayList<String>();
        ArrayList<String> strSQL = new ArrayList<String>();
        ArrayList<Integer> lenghtBidimensionalArray = new ArrayList<Integer>();
        ArrayList<Boolean> lastID = new ArrayList<Boolean>();
        String data_select = "";
        lastID.add(false);
        String str = "SELECT autofattura FROM f_ana_fornitore WHERE cod_forn='" + codice + "' AND azienda='" + azienda + "' AND sotto_az='" + sotto_az + "' ";
        strSQL.add(str);
        tipoSQL.add("select");
        lenghtBidimensionalArray.add(0);
        String strJson = this.util.makeStringJsonDB("ON", tipoSQL, strSQL, null, null, lastID, lenghtBidimensionalArray);
        data_select = this.sk1Comm.ServerEsecuteRequest(FXMLDocumentController.GLOBAL_IP, FXMLDocumentController.GLOBAL_PORT, "dbInteraction#@" + strJson);
        if (!data_select.contains("#ERR:")) {
            JSONArray arrayJson = this.jsonUtil.strJsonToJSONArray(data_select);
            for (int i = 0; i < arrayJson.length(); ++i) {
                try {
                    JSONObject rec = arrayJson.getJSONObject(i);
                    res = Boolean.parseBoolean(rec.get("autofattura").toString());
                    continue;
                }
                catch (Exception ex) {
                    this.util.alertWindow(Alert.AlertType.ERROR, "ERRORE", "", ex.toString());
                }
            }
        } else {
            this.util.alertWindow(Alert.AlertType.ERROR, "ERRORE", "", data_select);
        }
        return res;
    }

    public Map<String, String> getCommittenteCampi(String codice, String azienda, String sotto_az) throws JSONException {
        HashMap<String, String> ret = new HashMap<String, String>();
        ArrayList<String> tipoSQL = new ArrayList<String>();
        ArrayList<String> strSQL = new ArrayList<String>();
        ArrayList<Integer> lenghtBidimensionalArray = new ArrayList<Integer>();
        ArrayList<Boolean> lastID = new ArrayList<Boolean>();
        String data_select = "";
        lastID.add(false);
        String str = "SELECT rag_soc,p_iva,nome,cognome,cod_fisc,indirizzo,pers_fisica,cap,localita,provincia,paese_iso,cod_istat_prov_comume,stato FROM gen_ana_clifor WHERE codice='" + codice + "' AND azienda='" + azienda + "' AND sotto_az='" + sotto_az + "' ";
        strSQL.add(str);
        tipoSQL.add("select");
        lenghtBidimensionalArray.add(0);
        String strJson = this.util.makeStringJsonDB("ON", tipoSQL, strSQL, null, null, lastID, lenghtBidimensionalArray);
        data_select = this.sk1Comm.ServerEsecuteRequest(FXMLDocumentController.GLOBAL_IP, FXMLDocumentController.GLOBAL_PORT, "dbInteraction#@" + strJson);
        if (!data_select.contains("#ERR:")) {
            JSONArray arrayJson = this.jsonUtil.strJsonToJSONArray(data_select);
            for (int i = 0; i < arrayJson.length(); ++i) {
                try {
                    JSONObject rec = arrayJson.getJSONObject(i);
                    ret.put("rag_soc", rec.get("rag_soc").toString());
                    ret.put("nome", rec.get("nome").toString());
                    ret.put("cognome", rec.get("cognome").toString());
                    ret.put("p_iva", rec.get("p_iva").toString());
                    ret.put("cod_fisc", rec.get("cod_fisc").toString());
                    ret.put("pers_fisica", rec.get("pers_fisica").toString());
                    ret.put("indirizzo", rec.get("indirizzo").toString());
                    ret.put("cap", rec.get("cap").toString());
                    ret.put("localita", rec.get("localita").toString());
                    ret.put("provincia", rec.get("provincia").toString());
                    ret.put("paese_iso", rec.get("paese_iso").toString());
                    ret.put("cod_istat_prov_comune", rec.get("cod_istat_prov_comume").toString());
                    ret.put("stato", rec.get("stato").toString());
                    continue;
                }
                catch (Exception ex) {
                    this.util.alertWindow(Alert.AlertType.ERROR, "ERRORE", "", ex.toString());
                }
            }
        } else {
            this.util.alertWindow(Alert.AlertType.ERROR, "ERRORE", "", data_select);
        }
        return ret;
    }

    public String getPrezzoFromObb(String obbiettivo) throws JSONException {
        String ret = "";
        ArrayList<String> tipoSQL = new ArrayList<String>();
        ArrayList<String> strSQL = new ArrayList<String>();
        ArrayList<Integer> lenghtBidimensionalArray = new ArrayList<Integer>();
        ArrayList<Boolean> lastID = new ArrayList<Boolean>();
        String data_select = "";
        lastID.add(false);
        String str = "SELECT IFNULL(prezzo,0) AS prezzo FROM f_ana_obbiettivi WHERE obbiettivo='" + obbiettivo + "'";
        strSQL.add(str);
        tipoSQL.add("select");
        lenghtBidimensionalArray.add(0);
        String strJson = this.util.makeStringJsonDB("OFF", tipoSQL, strSQL, null, null, lastID, lenghtBidimensionalArray);
        data_select = this.sk1Comm.ServerEsecuteRequest(FXMLDocumentController.GLOBAL_IP, FXMLDocumentController.GLOBAL_PORT, "dbInteraction#@" + strJson);
        if (!data_select.contains("#ERR:")) {
            JSONArray arrayJson = this.jsonUtil.strJsonToJSONArray(data_select);
            for (int i = 0; i < arrayJson.length(); ++i) {
                try {
                    JSONObject rec = arrayJson.getJSONObject(i);
                    ret = String.valueOf(rec.getDouble("prezzo"));
                    continue;
                }
                catch (Exception ex) {
                    this.util.alertWindow(Alert.AlertType.ERROR, "ERRORE", "", ex.toString());
                }
            }
        } else {
            this.util.alertWindow(Alert.AlertType.ERROR, "ERRORE", "", data_select);
        }
        return ret;
    }

    public Boolean checkIfSoggettoExistMIPAAF(String codiceSoggetto, String azienda, String sotto_az, String icqrf) {
        Boolean ret = false;
        try {
            String d = this.sk1Comm.ServerEsecuteRequest(FXMLDocumentController.GLOBAL_IP, FXMLDocumentController.GLOBAL_PORT, "VisSoggSiRPV#@" + azienda + "#@" + sotto_az + "#@" + icqrf);
            if (!d.contains("#ERR:")) {
                JSONObject res = new JSONObject(d);
                String codice = res.getString("codice");
                String messaggio = res.getString("messaggio");
                if (codice.equals("")) {
                    JSONArray ar = res.getJSONArray("lista");
                    for (int i = 0; i < ar.length(); ++i) {
                        JSONObject et = ar.getJSONObject(i);
                        if (!et.getString("codice").equals(codiceSoggetto)) continue;
                        ret = true;
                    }
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return ret;
    }

    public Boolean checkIfTrasportatoreExistMIPAAF(String codiceSoggetto, String azienda, String sotto_az, String icqrf) {
        Boolean ret = false;
        try {
            String d = this.sk1Comm.ServerEsecuteRequest(FXMLDocumentController.GLOBAL_IP, FXMLDocumentController.GLOBAL_PORT, "VisSoggSiRPV#@" + azienda + "#@" + sotto_az + "#@" + icqrf + "#@" + codiceSoggetto);
            if (!d.contains("#ERR:")) {
                JSONArray ar;
                JSONObject res = new JSONObject(d);
                String codicemx = res.getString("codice");
                String messaggio = res.getString("messaggio");
                if (codicemx.equals("") && (ar = res.getJSONArray("lista")).length() > 0) {
                    ret = true;
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return ret;
    }

    public String getCatalogoSoggettiMIPAAF(String azienda, String sotto_az, String icqrf) {
        String ret = "";
        try {
            String d = this.sk1Comm.ServerEsecuteRequest(FXMLDocumentController.GLOBAL_IP, FXMLDocumentController.GLOBAL_PORT, "VisSoggSiRPV#@" + azienda + "#@" + sotto_az + "#@" + icqrf);
            if (!d.contains("#ERR:")) {
                JSONObject res = new JSONObject(d);
                String codice = res.getString("codice");
                String messaggio = res.getString("messaggio");
                if (codice.equals("")) {
                    JSONArray ar = res.getJSONArray("lista");
                    ret = ar.toString();
                } else {
                    ret = "#ERR: " + codice + " - " + messaggio;
                }
            }
        }
        catch (Exception e) {
            ret = "#ERR:" + e.getMessage();
        }
        return ret;
    }

    public String getCatalogoTrasportatoriMIPAAF(String azienda, String sotto_az, String icqrf) {
        String ret = "";
        try {
            String d = this.sk1Comm.ServerEsecuteRequest(FXMLDocumentController.GLOBAL_IP, FXMLDocumentController.GLOBAL_PORT, "VisSoggSiRPV#@" + azienda + "#@" + sotto_az + "#@" + icqrf + "#@");
            if (!d.contains("#ERR:")) {
                JSONObject res = new JSONObject(d);
                String codice = res.getString("codice");
                String messaggio = res.getString("messaggio");
                if (codice.equals("")) {
                    JSONArray ar = res.getJSONArray("lista");
                    ret = ar.toString();
                } else {
                    ret = "#ERR: " + codice + " - " + messaggio;
                }
            }
        }
        catch (Exception e) {
            ret = "#ERR:" + e.getMessage();
        }
        return ret;
    }

    public String getIDVasoWBS(String azienda, String sotto_az, String icqrf) throws JSONException {
        String ret = "";
        ArrayList<String> tipoSQL = new ArrayList<String>();
        ArrayList<String> strSQL = new ArrayList<String>();
        ArrayList<Integer> lenghtBidimensionalArray = new ArrayList<Integer>();
        ArrayList<Boolean> lastID = new ArrayList<Boolean>();
        String data_select = "";
        lastID.add(false);
        String str = "SELECT id FROM gen_vasi_vinari_ana  WHERE azienda='" + azienda + "' AND sotto_az='" + sotto_az + "' AND icqrf='" + icqrf + "' AND codice_vaso='@VASOWBS@'";
        strSQL.add(str);
        tipoSQL.add("select");
        lenghtBidimensionalArray.add(0);
        String strJson = this.util.makeStringJsonDB("ON", tipoSQL, strSQL, null, null, lastID, lenghtBidimensionalArray);
        data_select = this.sk1Comm.ServerEsecuteRequest(FXMLDocumentController.GLOBAL_IP, FXMLDocumentController.GLOBAL_PORT, "dbInteraction#@" + strJson);
        if (!data_select.contains("#ERR:")) {
            JSONArray arrayJson = this.jsonUtil.strJsonToJSONArray(data_select);
            for (int i = 0; i < arrayJson.length(); ++i) {
                try {
                    JSONObject rec = arrayJson.getJSONObject(i);
                    ret = rec.get("id").toString().replace("null", "");
                    continue;
                }
                catch (Exception ex) {
                    this.util.alertWindow(Alert.AlertType.ERROR, "ERRORE", "", ex.toString());
                }
            }
        } else {
            this.util.alertWindow(Alert.AlertType.ERROR, "ERRORE", "", data_select);
        }
        return ret;
    }

    public boolean isConfAutoFattura(String azienda, String sotto_az, String icqrf, String conferente) throws JSONException {
        boolean ret = false;
        ArrayList<String> tipoSQL = new ArrayList<String>();
        ArrayList<String> strSQL = new ArrayList<String>();
        ArrayList<Integer> lenghtBidimensionalArray = new ArrayList<Integer>();
        ArrayList<Boolean> lastID = new ArrayList<Boolean>();
        String data_select = "";
        lastID.add(false);
        String str = "SELECT autofattura FROM f_ana_fornitore WHERE azienda='" + azienda + "' AND sotto_az='" + sotto_az + "' AND icqrf='" + icqrf + "' AND cod_forn='" + conferente + "'";
        strSQL.add(str);
        tipoSQL.add("select");
        lenghtBidimensionalArray.add(0);
        String strJson = this.util.makeStringJsonDB("ON", tipoSQL, strSQL, null, null, lastID, lenghtBidimensionalArray);
        data_select = this.sk1Comm.ServerEsecuteRequest(FXMLDocumentController.GLOBAL_IP, FXMLDocumentController.GLOBAL_PORT, "dbInteraction#@" + strJson);
        if (!data_select.contains("#ERR:")) {
            JSONArray arrayJson = this.jsonUtil.strJsonToJSONArray(data_select);
            for (int i = 0; i < arrayJson.length(); ++i) {
                try {
                    JSONObject rec = arrayJson.getJSONObject(i);
                    ret = Boolean.parseBoolean(rec.get("autofattura").toString());
                    continue;
                }
                catch (Exception ex) {
                    this.util.alertWindow(Alert.AlertType.ERROR, "ERRORE", "", ex.toString());
                }
            }
        } else {
            this.util.alertWindow(Alert.AlertType.ERROR, "ERRORE", "", data_select);
        }
        return ret;
    }

    public boolean getOperazioneConfSIAN(String azienda, String sotto_az, String icqrf, String id_oper) throws JSONException {
        boolean ret = false;
        ArrayList<String> tipoSQL = new ArrayList<String>();
        ArrayList<String> strSQL = new ArrayList<String>();
        ArrayList<Integer> lenghtBidimensionalArray = new ArrayList<Integer>();
        ArrayList<Boolean> lastID = new ArrayList<Boolean>();
        String data_select = "";
        lastID.add(false);
        String str = "SELECT IFNULL(invio_sian_id,0) AS invio_sian_id FROM c_operazioni WHERE azienda='" + azienda + "' AND sotto_az='" + sotto_az + "' AND icqrf='" + icqrf + "' AND id_conferimento=" + id_oper;
        strSQL.add(str);
        tipoSQL.add("select");
        lenghtBidimensionalArray.add(0);
        String strJson = this.util.makeStringJsonDB("ON", tipoSQL, strSQL, null, null, lastID, lenghtBidimensionalArray);
        data_select = this.sk1Comm.ServerEsecuteRequest(FXMLDocumentController.GLOBAL_IP, FXMLDocumentController.GLOBAL_PORT, "dbInteraction#@" + strJson);
        if (!data_select.contains("#ERR:")) {
            JSONArray arrayJson = this.jsonUtil.strJsonToJSONArray(data_select);
            for (int i = 0; i < arrayJson.length(); ++i) {
                try {
                    JSONObject rec = arrayJson.getJSONObject(i);
                    String jhret = rec.get("invio_sian_id").toString();
                    if (jhret.equals("0")) {
                        ret = false;
                        continue;
                    }
                    ret = true;
                    continue;
                }
                catch (Exception ex) {
                    this.util.alertWindow(Alert.AlertType.ERROR, "ERRORE", "", ex.toString());
                }
            }
        } else {
            this.util.alertWindow(Alert.AlertType.ERROR, "ERRORE", "", data_select);
        }
        return ret;
    }

    public String getAliqAutofattura(String azienda, String sotto_az) throws JSONException {
        String ret = "";
        ArrayList<String> tipoSQL = new ArrayList<String>();
        ArrayList<String> strSQL = new ArrayList<String>();
        ArrayList<Integer> lenghtBidimensionalArray = new ArrayList<Integer>();
        ArrayList<Boolean> lastID = new ArrayList<Boolean>();
        String data_select = "";
        lastID.add(false);
        String str = "SELECT valore FROM gen_ini WHERE azienda='" + azienda + "' AND sotto_az='" + sotto_az + "' AND codice='WBS_ALIQ_IVA_AUTOFATTURA'";
        strSQL.add(str);
        tipoSQL.add("select");
        lenghtBidimensionalArray.add(0);
        String strJson = this.util.makeStringJsonDB("ON", tipoSQL, strSQL, null, null, lastID, lenghtBidimensionalArray);
        data_select = this.sk1Comm.ServerEsecuteRequest(FXMLDocumentController.GLOBAL_IP, FXMLDocumentController.GLOBAL_PORT, "dbInteraction#@" + strJson);
        if (!data_select.contains("#ERR:")) {
            JSONArray arrayJson = this.jsonUtil.strJsonToJSONArray(data_select);
            for (int i = 0; i < arrayJson.length(); ++i) {
                try {
                    JSONObject rec = arrayJson.getJSONObject(i);
                    ret = rec.get("valore").toString();
                    continue;
                }
                catch (Exception ex) {
                    this.util.alertWindow(Alert.AlertType.ERROR, "ERRORE", "", ex.toString());
                }
            }
        } else {
            this.util.alertWindow(Alert.AlertType.ERROR, "ERRORE", "", data_select);
        }
        return ret;
    }

    public String getContoIva(String azienda, String sotto_az) throws JSONException {
        String ret = "";
        ArrayList<String> tipoSQL = new ArrayList<String>();
        ArrayList<String> strSQL = new ArrayList<String>();
        ArrayList<Integer> lenghtBidimensionalArray = new ArrayList<Integer>();
        ArrayList<Boolean> lastID = new ArrayList<Boolean>();
        String data_select = "";
        lastID.add(false);
        String str = "SELECT valore FROM gen_ini WHERE azienda='" + azienda + "' AND sotto_az='" + sotto_az + "' AND codice='WBS_COD_CONTROPARTITA_IVA'";
        strSQL.add(str);
        tipoSQL.add("select");
        lenghtBidimensionalArray.add(0);
        String strJson = this.util.makeStringJsonDB("ON", tipoSQL, strSQL, null, null, lastID, lenghtBidimensionalArray);
        data_select = this.sk1Comm.ServerEsecuteRequest(FXMLDocumentController.GLOBAL_IP, FXMLDocumentController.GLOBAL_PORT, "dbInteraction#@" + strJson);
        if (!data_select.contains("#ERR:")) {
            JSONArray arrayJson = this.jsonUtil.strJsonToJSONArray(data_select);
            for (int i = 0; i < arrayJson.length(); ++i) {
                try {
                    JSONObject rec = arrayJson.getJSONObject(i);
                    ret = rec.get("valore").toString();
                    continue;
                }
                catch (Exception ex) {
                    this.util.alertWindow(Alert.AlertType.ERROR, "ERRORE", "", ex.toString());
                }
            }
        } else {
            this.util.alertWindow(Alert.AlertType.ERROR, "ERRORE", "", data_select);
        }
        return ret;
    }

    public boolean getMexalLiquidazione(String azienda, String sotto_az) throws JSONException {
        boolean ret = false;
        ArrayList<String> tipoSQL = new ArrayList<String>();
        ArrayList<String> strSQL = new ArrayList<String>();
        ArrayList<Integer> lenghtBidimensionalArray = new ArrayList<Integer>();
        ArrayList<Boolean> lastID = new ArrayList<Boolean>();
        String data_select = "";
        lastID.add(false);
        String str = "SELECT valore FROM gen_ini WHERE azienda='" + azienda + "' AND sotto_az='" + sotto_az + "' AND codice='MEXAL_LIQUIDAZIONE'";
        strSQL.add(str);
        tipoSQL.add("select");
        lenghtBidimensionalArray.add(0);
        String strJson = this.util.makeStringJsonDB("ON", tipoSQL, strSQL, null, null, lastID, lenghtBidimensionalArray);
        data_select = this.sk1Comm.ServerEsecuteRequest(FXMLDocumentController.GLOBAL_IP, FXMLDocumentController.GLOBAL_PORT, "dbInteraction#@" + strJson);
        if (!data_select.contains("#ERR:")) {
            JSONArray arrayJson = this.jsonUtil.strJsonToJSONArray(data_select);
            for (int i = 0; i < arrayJson.length(); ++i) {
                try {
                    JSONObject rec = arrayJson.getJSONObject(i);
                    if (Integer.parseInt(rec.get("valore").toString()) <= 0) continue;
                    ret = true;
                    continue;
                }
                catch (Exception ex) {
                    this.util.alertWindow(Alert.AlertType.ERROR, "ERRORE", "", ex.toString());
                }
            }
        } else {
            this.util.alertWindow(Alert.AlertType.ERROR, "ERRORE", "", data_select);
        }
        return ret;
    }

    public String getCodiceClienteFornFromPIVA(String azienda, String sotto_az, String piva, String tipo) throws JSONException {
        String ret = "";
        ArrayList<String> tipoSQL = new ArrayList<String>();
        ArrayList<String> strSQL = new ArrayList<String>();
        ArrayList<Integer> lenghtBidimensionalArray = new ArrayList<Integer>();
        ArrayList<Boolean> lastID = new ArrayList<Boolean>();
        String data_select = "";
        lastID.add(false);
        String str = "SELECT codice FROM gen_ana_clifor WHERE azienda='" + azienda + "' AND sotto_az='" + sotto_az + "' AND p_iva='" + piva + "'";
        strSQL.add(str);
        tipoSQL.add("select");
        lenghtBidimensionalArray.add(0);
        String strJson = this.util.makeStringJsonDB("ON", tipoSQL, strSQL, null, null, lastID, lenghtBidimensionalArray);
        data_select = this.sk1Comm.ServerEsecuteRequest(FXMLDocumentController.GLOBAL_IP, FXMLDocumentController.GLOBAL_PORT, "dbInteraction#@" + strJson);
        if (!data_select.contains("#ERR:")) {
            JSONArray arrayJson = this.jsonUtil.strJsonToJSONArray(data_select);
            for (int i = 0; i < arrayJson.length(); ++i) {
                try {
                    JSONObject rec = arrayJson.getJSONObject(i);
                    ret = rec.get("codice").toString();
                    continue;
                }
                catch (Exception ex) {
                    this.util.alertWindow(Alert.AlertType.ERROR, "ERRORE", "", ex.toString());
                }
            }
        } else {
            this.util.alertWindow(Alert.AlertType.ERROR, "ERRORE", "", data_select);
        }
        return ret;
    }

    public String getCodiceClienteFornFromCFisc(String azienda, String sotto_az, String cod_fisc, String tipo) throws JSONException {
        String ret = "";
        ArrayList<String> tipoSQL = new ArrayList<String>();
        ArrayList<String> strSQL = new ArrayList<String>();
        ArrayList<Integer> lenghtBidimensionalArray = new ArrayList<Integer>();
        ArrayList<Boolean> lastID = new ArrayList<Boolean>();
        String data_select = "";
        lastID.add(false);
        String str = "SELECT codice FROM gen_ana_clifor WHERE azienda='" + azienda + "' AND sotto_az='" + sotto_az + "' AND cod_fisc='" + cod_fisc + "' AND tipo='" + tipo + "'";
        strSQL.add(str);
        tipoSQL.add("select");
        lenghtBidimensionalArray.add(0);
        String strJson = this.util.makeStringJsonDB("ON", tipoSQL, strSQL, null, null, lastID, lenghtBidimensionalArray);
        data_select = this.sk1Comm.ServerEsecuteRequest(FXMLDocumentController.GLOBAL_IP, FXMLDocumentController.GLOBAL_PORT, "dbInteraction#@" + strJson);
        if (!data_select.contains("#ERR:")) {
            JSONArray arrayJson = this.jsonUtil.strJsonToJSONArray(data_select);
            for (int i = 0; i < arrayJson.length(); ++i) {
                try {
                    JSONObject rec = arrayJson.getJSONObject(i);
                    ret = rec.get("codice").toString();
                    continue;
                }
                catch (Exception ex) {
                    this.util.alertWindow(Alert.AlertType.ERROR, "ERRORE", "", ex.toString());
                }
            }
        } else {
            this.util.alertWindow(Alert.AlertType.ERROR, "ERRORE", "", data_select);
        }
        return ret;
    }

    public String getContoAcconto(String azienda, String sotto_az) throws JSONException {
        String ret = "";
        ArrayList<String> tipoSQL = new ArrayList<String>();
        ArrayList<String> strSQL = new ArrayList<String>();
        ArrayList<Integer> lenghtBidimensionalArray = new ArrayList<Integer>();
        ArrayList<Boolean> lastID = new ArrayList<Boolean>();
        String data_select = "";
        lastID.add(false);
        String str = "SELECT valore FROM gen_ini WHERE azienda='" + azienda + "' AND sotto_az='" + sotto_az + "' AND codice='WBS_COD_CONTROPARTITA_ACCONTO'";
        strSQL.add(str);
        tipoSQL.add("select");
        lenghtBidimensionalArray.add(0);
        String strJson = this.util.makeStringJsonDB("ON", tipoSQL, strSQL, null, null, lastID, lenghtBidimensionalArray);
        data_select = this.sk1Comm.ServerEsecuteRequest(FXMLDocumentController.GLOBAL_IP, FXMLDocumentController.GLOBAL_PORT, "dbInteraction#@" + strJson);
        if (!data_select.contains("#ERR:")) {
            JSONArray arrayJson = this.jsonUtil.strJsonToJSONArray(data_select);
            for (int i = 0; i < arrayJson.length(); ++i) {
                try {
                    JSONObject rec = arrayJson.getJSONObject(i);
                    ret = rec.get("valore").toString();
                    continue;
                }
                catch (Exception ex) {
                    this.util.alertWindow(Alert.AlertType.ERROR, "ERRORE", "", ex.toString());
                }
            }
        } else {
            this.util.alertWindow(Alert.AlertType.ERROR, "ERRORE", "", data_select);
        }
        return ret;
    }

    public String getContoSaldo(String azienda, String sotto_az) throws JSONException {
        String ret = "";
        ArrayList<String> tipoSQL = new ArrayList<String>();
        ArrayList<String> strSQL = new ArrayList<String>();
        ArrayList<Integer> lenghtBidimensionalArray = new ArrayList<Integer>();
        ArrayList<Boolean> lastID = new ArrayList<Boolean>();
        String data_select = "";
        lastID.add(false);
        String str = "SELECT valore FROM gen_ini WHERE azienda='" + azienda + "' AND sotto_az='" + sotto_az + "' AND codice='WBS_COD_CONTROPARTITA_SALDO'";
        strSQL.add(str);
        tipoSQL.add("select");
        lenghtBidimensionalArray.add(0);
        String strJson = this.util.makeStringJsonDB("ON", tipoSQL, strSQL, null, null, lastID, lenghtBidimensionalArray);
        data_select = this.sk1Comm.ServerEsecuteRequest(FXMLDocumentController.GLOBAL_IP, FXMLDocumentController.GLOBAL_PORT, "dbInteraction#@" + strJson);
        if (!data_select.contains("#ERR:")) {
            JSONArray arrayJson = this.jsonUtil.strJsonToJSONArray(data_select);
            for (int i = 0; i < arrayJson.length(); ++i) {
                try {
                    JSONObject rec = arrayJson.getJSONObject(i);
                    ret = rec.get("valore").toString();
                    continue;
                }
                catch (Exception ex) {
                    this.util.alertWindow(Alert.AlertType.ERROR, "ERRORE", "", ex.toString());
                }
            }
        } else {
            this.util.alertWindow(Alert.AlertType.ERROR, "ERRORE", "", data_select);
        }
        return ret;
    }

    public String getAliqFattura(String azienda, String sotto_az) throws JSONException {
        String ret = "";
        ArrayList<String> tipoSQL = new ArrayList<String>();
        ArrayList<String> strSQL = new ArrayList<String>();
        ArrayList<Integer> lenghtBidimensionalArray = new ArrayList<Integer>();
        ArrayList<Boolean> lastID = new ArrayList<Boolean>();
        String data_select = "";
        lastID.add(false);
        String str = "SELECT valore FROM gen_ini WHERE azienda='" + azienda + "' AND sotto_az='" + sotto_az + "' AND codice='WBS_ALIQ_IVA_FATTURA'";
        strSQL.add(str);
        tipoSQL.add("select");
        lenghtBidimensionalArray.add(0);
        String strJson = this.util.makeStringJsonDB("ON", tipoSQL, strSQL, null, null, lastID, lenghtBidimensionalArray);
        data_select = this.sk1Comm.ServerEsecuteRequest(FXMLDocumentController.GLOBAL_IP, FXMLDocumentController.GLOBAL_PORT, "dbInteraction#@" + strJson);
        if (!data_select.contains("#ERR:")) {
            JSONArray arrayJson = this.jsonUtil.strJsonToJSONArray(data_select);
            for (int i = 0; i < arrayJson.length(); ++i) {
                try {
                    JSONObject rec = arrayJson.getJSONObject(i);
                    ret = rec.get("valore").toString();
                    continue;
                }
                catch (Exception ex) {
                    this.util.alertWindow(Alert.AlertType.ERROR, "ERRORE", "", ex.toString());
                }
            }
        } else {
            this.util.alertWindow(Alert.AlertType.ERROR, "ERRORE", "", data_select);
        }
        return ret;
    }

    public String getPercMenoFromConf(int id) throws JSONException {
        String ret = "";
        ArrayList<String> tipoSQL = new ArrayList<String>();
        ArrayList<String> strSQL = new ArrayList<String>();
        ArrayList<Integer> lenghtBidimensionalArray = new ArrayList<Integer>();
        ArrayList<Boolean> lastID = new ArrayList<Boolean>();
        String data_select = "";
        lastID.add(false);
        String str = "SELECT percmeno FROM f_movimenti WHERE id=" + id;
        strSQL.add(str);
        tipoSQL.add("select");
        lenghtBidimensionalArray.add(0);
        String strJson = this.util.makeStringJsonDB("ON", tipoSQL, strSQL, null, null, lastID, lenghtBidimensionalArray);
        data_select = this.sk1Comm.ServerEsecuteRequest(FXMLDocumentController.GLOBAL_IP, FXMLDocumentController.GLOBAL_PORT, "dbInteraction#@" + strJson);
        if (!data_select.contains("#ERR:")) {
            JSONArray arrayJson = this.jsonUtil.strJsonToJSONArray(data_select);
            for (int i = 0; i < arrayJson.length(); ++i) {
                try {
                    JSONObject rec = arrayJson.getJSONObject(i);
                    ret = rec.get("percmeno").toString();
                    continue;
                }
                catch (Exception ex) {
                    this.util.alertWindow(Alert.AlertType.ERROR, "ERRORE", "", ex.toString());
                }
            }
        } else {
            this.util.alertWindow(Alert.AlertType.ERROR, "ERRORE", "", data_select);
        }
        return ret;
    }

    public ObservableList<ColumnTableOperazioniCantina> refreshListaOperazioni(String oper, int WBS_SHOW_LISTE_OPERAZIONI) throws JSONException {
        ObservableList lista_operazioni = FXCollections.observableArrayList();
        ArrayList<String> tipoSQL = new ArrayList<String>();
        ArrayList<String> strSQL = new ArrayList<String>();
        ArrayList<Integer> lenghtBidimensionalArray = new ArrayList<Integer>();
        ArrayList<Boolean> lastID = new ArrayList<Boolean>();
        String data_select = "";
        lastID.add(false);
        LocalDate data_back = this.util.getDateBeforeDate(WBS_SHOW_LISTE_OPERAZIONI);
        LocalDate data_ora = LocalDate.now();
        String str = "SELECT k.sian_cod_oper AS cod_oper,IFNULL(a.invio_sian_id,0) AS invio_sian_id,a.id,a.data_oper,b.cod_tipo_vino,a.icqrf,a.azienda,a.sotto_az,IFNULL(b.qta,0) AS qta,IFNULL(b.litri,0) AS litri,b.volume,num_prot_ido FROM c_operazioni AS a LEFT JOIN c_movimenti AS b ON a.id=b.id_oper LEFT JOIN gen_t_oper_sian AS k ON k.tipo_oper=a.cod_oper WHERE a.cod_oper='" + oper + "' AND (a.tipo_oper='' OR a.tipo_oper IS NULL) AND a.azienda='" + FXMLDocumentController.GLOBAL_AZIENDA + "' AND a.icqrf='" + FXMLDocumentController.GLOBAL_ICQRF + "' AND a.sotto_az='" + FXMLDocumentController.GLOBAL_SOTTOAZZ + "' AND a.cod_committente='" + FXMLDocumentController.GLOBAL_CODCOMM + "' AND a.data_oper>='" + data_back.toString() + "' ORDER BY a.data_oper DESC,a.id DESC";
        strSQL.add(str);
        tipoSQL.add("select");
        lenghtBidimensionalArray.add(0);
        String strJson = FXMLDocumentController.util.makeStringJsonDB("ON", tipoSQL, strSQL, null, null, lastID, lenghtBidimensionalArray);
        data_select = FXMLDocumentController.sk1Comm.ServerEsecuteRequest(FXMLDocumentController.GLOBAL_IP, FXMLDocumentController.GLOBAL_PORT, "dbInteraction#@" + strJson);
        if (!data_select.contains("#ERR:")) {
            lista_operazioni.clear();
            JSONArray arrayJson = FXMLDocumentController.jsonUtil.strJsonToJSONArray(data_select);
            for (int i = 0; i < arrayJson.length(); ++i) {
                try {
                    JSONObject rec = arrayJson.getJSONObject(i);
                    String currentDate = FXMLDocumentController.util.AnnoMeseGiornoTOGiornoMeseAnno(rec.getString("data_oper"));
                    lista_operazioni.add((Object)new ColumnTableOperazioniCantina(false, rec.getInt("id"), currentDate, rec.getString("cod_oper"), rec.getDouble("qta"), rec.getString("cod_tipo_vino"), rec.getInt("invio_sian_id")));
                    continue;
                }
                catch (ParseException | JSONException ex) {
                    FXMLDocumentController.util.alertWindow(Alert.AlertType.ERROR, "ERRORE", "", ex.toString());
                }
            }
        } else {
            FXMLDocumentController.util.alertWindow(Alert.AlertType.ERROR, "ERRORE", "", data_select);
        }
        return lista_operazioni;
    }

    public Integer getMagazzino(String azienda, String sotto_az, String icqrf) throws JSONException {
        Integer mag = 0;
        ArrayList<String> tipoSQL = new ArrayList<String>();
        ArrayList<String> strSQL = new ArrayList<String>();
        ArrayList<Integer> lenghtBidimensionalArray = new ArrayList<Integer>();
        ArrayList<Boolean> lastID = new ArrayList<Boolean>();
        String data_select = "";
        lastID.add(false);
        String str = "SELECT mx_nmag FROM gen_t_icqrf_mxmag WHERE azienda='" + azienda + "' AND sotto_az='" + sotto_az + "' AND icqrf='" + icqrf + "' GROUP BY azienda,sotto_az,icqrf,mx_nmag";
        strSQL.add(str);
        tipoSQL.add("select");
        lenghtBidimensionalArray.add(0);
        String strJson = this.util.makeStringJsonDB("ON", tipoSQL, strSQL, null, null, lastID, lenghtBidimensionalArray);
        data_select = this.sk1Comm.ServerEsecuteRequest(FXMLDocumentController.GLOBAL_IP, FXMLDocumentController.GLOBAL_PORT, "dbInteraction#@" + strJson);
        if (!data_select.contains("#ERR:")) {
            JSONArray arrayJson = this.jsonUtil.strJsonToJSONArray(data_select);
            for (int i = 0; i < arrayJson.length(); ++i) {
                try {
                    JSONObject rec = arrayJson.getJSONObject(i);
                    mag = rec.getInt("mx_nmag");
                    continue;
                }
                catch (Exception ex) {
                    this.util.alertWindow(Alert.AlertType.ERROR, "ERRORE", "", ex.toString());
                }
            }
        } else {
            this.util.alertWindow(Alert.AlertType.ERROR, "ERRORE", "", data_select);
        }
        return mag;
    }

    public boolean checkIfProdottoExist(String prodotto) throws JSONException {
        boolean ret = false;
        ArrayList json = new ArrayList();
        ArrayList<String> strSQL = new ArrayList<String>();
        ArrayList<String> tipoSQL = new ArrayList<String>();
        ArrayList<Boolean> lastID = new ArrayList<Boolean>();
        strSQL = new ArrayList();
        tipoSQL = new ArrayList();
        lastID = new ArrayList();
        lastID.add(false);
        strSQL.add("SELECT id FROM gen_tipo_vino_ana WHERE codice='" + prodotto.replace("'", "\\'") + "' AND azienda='" + FXMLDocumentController.GLOBAL_AZIENDA + "' AND sotto_az='" + FXMLDocumentController.GLOBAL_SOTTOAZZ + "' AND icqrf='" + FXMLDocumentController.GLOBAL_ICQRF + "' AND cod_committente='" + FXMLDocumentController.GLOBAL_CODCOMM + "'");
        tipoSQL.add("select");
        String strJson = this.util.makeStringJsonDB("OFF", tipoSQL, strSQL, null, null, lastID, null);
        String data_select = this.sk1Comm.ServerEsecuteRequest(FXMLDocumentController.GLOBAL_IP, FXMLDocumentController.GLOBAL_PORT, "dbInteraction#@" + strJson);
        ret = !data_select.contains("#ERR:") ? !data_select.equals("[]") : false;
        return ret;
    }

    public String getIdoneitaLotto(String cod_lotto) throws JSONException {
        String ret = null;
        ArrayList json = new ArrayList();
        ArrayList<String> strSQL = new ArrayList<String>();
        ArrayList<String> tipoSQL = new ArrayList<String>();
        ArrayList<Boolean> lastID = new ArrayList<Boolean>();
        strSQL = new ArrayList();
        tipoSQL = new ArrayList();
        lastID = new ArrayList();
        lastID.add(false);
        strSQL.add("SELECT a.num_prot_ido,a.data_ido,a.ente_cert FROM c_movimenti AS a LEFT JOIN c_movimenti_lotti AS b ON a.id=b.id_mov AND a.azienda=b.azienda AND a.sotto_az=b.sotto_az AND a.icqrf=b.icqrf AND a.cod_committente=b.cod_committente WHERE b.cod_lotto='" + cod_lotto + "' GROUP BY b.cod_lotto");
        tipoSQL.add("select");
        String strJson = FXMLDocumentController.util.makeStringJsonDB("OFF", tipoSQL, strSQL, null, null, lastID, null);
        String data_select = FXMLDocumentController.sk1Comm.ServerEsecuteRequest(FXMLDocumentController.GLOBAL_IP, FXMLDocumentController.GLOBAL_PORT, "dbInteraction#@" + strJson);
        if (!data_select.contains("#ERR:")) {
            JSONArray arrayJson = FXMLDocumentController.jsonUtil.strJsonToJSONArray(data_select);
            ret = arrayJson.toString();
        } else {
            ret = data_select;
        }
        return ret;
    }

    public String getMassaFromProdotto(String prodotto) throws JSONException {
        String ret = null;
        ArrayList json = new ArrayList();
        ArrayList<String> strSQL = new ArrayList<String>();
        ArrayList<String> tipoSQL = new ArrayList<String>();
        ArrayList<Boolean> lastID = new ArrayList<Boolean>();
        strSQL = new ArrayList();
        tipoSQL = new ArrayList();
        lastID = new ArrayList();
        lastID.add(false);
        strSQL.add("SELECT sian_massa_volumica FROM gen_tipo_vino_ana WHERE codice='" + prodotto.replace("'", "\\'") + "' AND azienda='" + FXMLDocumentController.GLOBAL_AZIENDA + "' AND sotto_az='" + FXMLDocumentController.GLOBAL_SOTTOAZZ + "' AND icqrf='" + FXMLDocumentController.GLOBAL_ICQRF + "' AND cod_committente='" + FXMLDocumentController.GLOBAL_CODCOMM + "'");
        tipoSQL.add("select");
        String strJson = this.util.makeStringJsonDB("OFF", tipoSQL, strSQL, null, null, lastID, null);
        String data_select = this.sk1Comm.ServerEsecuteRequest(FXMLDocumentController.GLOBAL_IP, FXMLDocumentController.GLOBAL_PORT, "dbInteraction#@" + strJson);
        if (!data_select.contains("#ERR:")) {
            JSONArray arrayJson = this.jsonUtil.strJsonToJSONArray(data_select);
            ret = arrayJson.toString();
        } else {
            ret = data_select;
        }
        return ret;
    }

    public Double getMassaFromProdottoReturn(String prodotto) throws JSONException {
        Double ret = 0.0;
        ArrayList json = new ArrayList();
        ArrayList<String> strSQL = new ArrayList<String>();
        ArrayList<String> tipoSQL = new ArrayList<String>();
        ArrayList<Boolean> lastID = new ArrayList<Boolean>();
        strSQL = new ArrayList();
        tipoSQL = new ArrayList();
        lastID = new ArrayList();
        lastID.add(false);
        strSQL.add("SELECT sian_massa_volumica FROM gen_tipo_vino_ana WHERE codice='" + prodotto.replace("'", "\\'") + "' AND azienda='" + FXMLDocumentController.GLOBAL_AZIENDA + "' AND sotto_az='" + FXMLDocumentController.GLOBAL_SOTTOAZZ + "' AND icqrf='" + FXMLDocumentController.GLOBAL_ICQRF + "' AND cod_committente='" + FXMLDocumentController.GLOBAL_CODCOMM + "'");
        tipoSQL.add("select");
        String strJson = this.util.makeStringJsonDB("OFF", tipoSQL, strSQL, null, null, lastID, null);
        String data_select = this.sk1Comm.ServerEsecuteRequest(FXMLDocumentController.GLOBAL_IP, FXMLDocumentController.GLOBAL_PORT, "dbInteraction#@" + strJson);
        if (!data_select.contains("#ERR:")) {
            JSONArray arrayJson = this.jsonUtil.strJsonToJSONArray(data_select);
            for (int i = 0; i < arrayJson.length(); ++i) {
                ret = arrayJson.getJSONObject(i).getDouble("sian_massa_volumica");
            }
        }
        return ret;
    }

    public String getDescrizioneFromUmImballi(String codice) throws JSONException {
        String ret = "";
        ArrayList json = new ArrayList();
        ArrayList<String> strSQL = new ArrayList<String>();
        ArrayList<String> tipoSQL = new ArrayList<String>();
        ArrayList<Boolean> lastID = new ArrayList<Boolean>();
        strSQL = new ArrayList();
        tipoSQL = new ArrayList();
        lastID = new ArrayList();
        lastID.add(false);
        strSQL.add("SELECT descrizione FROM mvv_um WHERE sigla='" + codice + "' ");
        tipoSQL.add("select");
        String strJson = this.util.makeStringJsonDB("OFF", tipoSQL, strSQL, null, null, lastID, null);
        String data_select = this.sk1Comm.ServerEsecuteRequest(FXMLDocumentController.GLOBAL_IP, FXMLDocumentController.GLOBAL_PORT, "dbInteraction#@" + strJson);
        if (!data_select.contains("#ERR:")) {
            JSONArray arrayJson = this.jsonUtil.strJsonToJSONArray(data_select);
            for (int i = 0; i < arrayJson.length(); ++i) {
                ret = arrayJson.getJSONObject(i).get("descrizione").toString();
            }
        }
        return ret;
    }

    public String getIdEnteCertificatore(String ente) throws JSONException {
        String ret = "";
        ArrayList json = new ArrayList();
        ArrayList<String> strSQL = new ArrayList<String>();
        ArrayList<String> tipoSQL = new ArrayList<String>();
        ArrayList<Boolean> lastID = new ArrayList<Boolean>();
        strSQL = new ArrayList();
        tipoSQL = new ArrayList();
        lastID = new ArrayList();
        lastID.add(false);
        strSQL.add("SELECT id FROM ente_certificatore WHERE descrizione='" + ente.replace("'", "\\'") + "' AND azienda='" + FXMLDocumentController.GLOBAL_AZIENDA + "' AND sotto_az='" + FXMLDocumentController.GLOBAL_SOTTOAZZ + "' ");
        tipoSQL.add("select");
        String strJson = this.util.makeStringJsonDB("OFF", tipoSQL, strSQL, null, null, lastID, null);
        String data_select = this.sk1Comm.ServerEsecuteRequest(FXMLDocumentController.GLOBAL_IP, FXMLDocumentController.GLOBAL_PORT, "dbInteraction#@" + strJson);
        if (!data_select.contains("#ERR:")) {
            JSONArray arrayJson = this.jsonUtil.strJsonToJSONArray(data_select);
            for (int i = 0; i < arrayJson.length(); ++i) {
                ret = arrayJson.getJSONObject(i).get("id").toString().replace("null", "");
            }
        }
        return ret;
    }

    public String selectProdotto(String id) throws JSONException {
        String ret = null;
        ArrayList json = new ArrayList();
        ArrayList<String> strSQL = new ArrayList<String>();
        ArrayList<String> tipoSQL = new ArrayList<String>();
        ArrayList<Boolean> lastID = new ArrayList<Boolean>();
        strSQL = new ArrayList();
        tipoSQL = new ArrayList();
        lastID = new ArrayList();
        lastID.add(false);
        strSQL.add("SELECT s.num_prot_ido AS num_prot,s.data_ido,s.ente_cert,SUM(s.litri) AS litri FROM gen_tipo_vino_ana AS a LEFT JOIN gen_tipo_vino_ana_mx AS bON a.id=b.id_tipo_vino_ana AND a.azienda=b.azienda AND a.sotto_az=b.sotto_az AND a.icqrf=b.icqrf AND a.cod_committente=b.cod_committente LEFT JOIN gen_tipo_vino_ana_mx_comp AS c ON a.id=c.id_tipo_vino_ana AND a.azienda=c.azienda AND a.sotto_az=c.sotto_az AND a.icqrf=c.icqrf AND a.cod_committente=c.cod_committente WHERE id=" + id + " AND a.azienda='" + FXMLDocumentController.GLOBAL_AZIENDA + "' AND a.sotto_az='" + FXMLDocumentController.GLOBAL_SOTTOAZZ + "' AND a.icqrf='" + FXMLDocumentController.GLOBAL_ICQRF + "' AND a.cod_committente='" + FXMLDocumentController.GLOBAL_CODCOMM + "' ");
        tipoSQL.add("select");
        String strJson = FXMLDocumentController.util.makeStringJsonDB("OFF", tipoSQL, strSQL, null, null, lastID, null);
        String data_select = FXMLDocumentController.sk1Comm.ServerEsecuteRequest(FXMLDocumentController.GLOBAL_IP, FXMLDocumentController.GLOBAL_PORT, "dbInteraction#@" + strJson);
        if (!data_select.contains("#ERR:")) {
            JSONArray arrayJson = FXMLDocumentController.jsonUtil.strJsonToJSONArray(data_select);
            ret = arrayJson.toString();
        } else {
            ret = data_select;
        }
        return ret;
    }

    public String idoneitaAnagGiacenza(String codice) throws JSONException {
        String ret = null;
        ArrayList<String> json = new ArrayList<String>();
        ArrayList<String> strSQL = new ArrayList<String>();
        ArrayList<String> tipoSQL = new ArrayList<String>();
        ArrayList<Boolean> lastID = new ArrayList<Boolean>();
        strSQL = new ArrayList();
        tipoSQL = new ArrayList();
        lastID = new ArrayList();
        lastID.add(false);
        strSQL.add("SELECT s.num_prot_ido AS num_prot,s.data_ido,s.ente_cert,SUM(s.litri) AS litri FROM c_movimenti AS s WHERE cod_tipo_vino='" + codice.replace("'", "\\'") + "' AND azienda='" + FXMLDocumentController.GLOBAL_AZIENDA + "' AND sotto_az='" + FXMLDocumentController.GLOBAL_SOTTOAZZ + "' AND icqrf='" + FXMLDocumentController.GLOBAL_ICQRF + "' AND cod_committente='" + FXMLDocumentController.GLOBAL_CODCOMM + "' GROUP BY s.num_prot_ido,s.data_ido,s.ente_cert ");
        tipoSQL.add("select");
        String strJson = this.util.makeStringJsonDB("OFF", tipoSQL, strSQL, null, null, lastID, null);
        String data_select = this.sk1Comm.ServerEsecuteRequest(FXMLDocumentController.GLOBAL_IP, FXMLDocumentController.GLOBAL_PORT, "dbInteraction#@" + strJson);
        if (!data_select.contains("#ERR:")) {
            JSONArray arrayJson = this.jsonUtil.strJsonToJSONArray(data_select);
            for (int i = 0; i < arrayJson.length(); ++i) {
                JSONObject rec = arrayJson.getJSONObject(i);
                json.add(rec.getString("num_prot").trim() + "#@" + rec.getString("data_ido").trim() + "#@" + rec.getString("ente_cert").trim());
            }
            ret = ((Object)json).toString();
        } else {
            ret = data_select;
        }
        return ret;
    }

    public String getDescrizioneFromCODOPIGP(String codice) throws JSONException {
        String ret = null;
        ArrayList json = new ArrayList();
        ArrayList<String> strSQL = new ArrayList<String>();
        ArrayList<String> tipoSQL = new ArrayList<String>();
        ArrayList<Boolean> lastID = new ArrayList<Boolean>();
        strSQL = new ArrayList();
        tipoSQL = new ArrayList();
        lastID = new ArrayList();
        lastID.add(false);
        strSQL.add("SELECT Descrizione AS descrizione FROM sian_t_dopigp WHERE codice='" + codice + "' AND progressivo='' ");
        tipoSQL.add("select");
        String strJson = this.util.makeStringJsonDB("OFF", tipoSQL, strSQL, null, null, lastID, null);
        String data_select = this.sk1Comm.ServerEsecuteRequest(FXMLDocumentController.GLOBAL_IP, FXMLDocumentController.GLOBAL_PORT, "dbInteraction#@" + strJson);
        if (!data_select.contains("#ERR:")) {
            JSONArray arrayJson = this.jsonUtil.strJsonToJSONArray(data_select);
            for (int i = 0; i < arrayJson.length(); ++i) {
                JSONObject rec = arrayJson.getJSONObject(i);
                ret = rec.getString("descrizione");
            }
        } else {
            ret = data_select;
        }
        return ret;
    }

    public String getDescrizioneFromTipoProdotto(String codice) throws JSONException {
        String ret = null;
        ArrayList json = new ArrayList();
        ArrayList<String> strSQL = new ArrayList<String>();
        ArrayList<String> tipoSQL = new ArrayList<String>();
        ArrayList<Boolean> lastID = new ArrayList<Boolean>();
        strSQL = new ArrayList();
        tipoSQL = new ArrayList();
        lastID = new ArrayList();
        lastID.add(false);
        strSQL.add("SELECT descr_tipo_prod AS descrizione FROM mvv_tipoprodotto WHERE cod_tipo_prod='" + codice + "'");
        tipoSQL.add("select");
        String strJson = this.util.makeStringJsonDB("OFF", tipoSQL, strSQL, null, null, lastID, null);
        String data_select = this.sk1Comm.ServerEsecuteRequest(FXMLDocumentController.GLOBAL_IP, FXMLDocumentController.GLOBAL_PORT, "dbInteraction#@" + strJson);
        if (!data_select.contains("#ERR:")) {
            JSONArray arrayJson = this.jsonUtil.strJsonToJSONArray(data_select);
            for (int i = 0; i < arrayJson.length(); ++i) {
                JSONObject rec = arrayJson.getJSONObject(i);
                ret = rec.getString("descrizione");
            }
        } else {
            ret = data_select;
        }
        return ret;
    }

    public String getDescrizioneFromUm(String codice) throws JSONException {
        String ret = null;
        ArrayList json = new ArrayList();
        ArrayList<String> strSQL = new ArrayList<String>();
        ArrayList<String> tipoSQL = new ArrayList<String>();
        ArrayList<Boolean> lastID = new ArrayList<Boolean>();
        strSQL = new ArrayList();
        tipoSQL = new ArrayList();
        lastID = new ArrayList();
        lastID.add(false);
        strSQL.add("SELECT descrizione FROM mvv_um WHERE sigla='" + codice + "'");
        tipoSQL.add("select");
        String strJson = this.util.makeStringJsonDB("OFF", tipoSQL, strSQL, null, null, lastID, null);
        String data_select = this.sk1Comm.ServerEsecuteRequest(FXMLDocumentController.GLOBAL_IP, FXMLDocumentController.GLOBAL_PORT, "dbInteraction#@" + strJson);
        if (!data_select.contains("#ERR:")) {
            JSONArray arrayJson = this.jsonUtil.strJsonToJSONArray(data_select);
            for (int i = 0; i < arrayJson.length(); ++i) {
                JSONObject rec = arrayJson.getJSONObject(i);
                ret = rec.getString("descrizione");
            }
        } else {
            ret = data_select;
        }
        return ret;
    }

    public String getCodOperFromSIANCOD(String codice) throws JSONException {
        String ret = null;
        ArrayList json = new ArrayList();
        ArrayList<String> strSQL = new ArrayList<String>();
        ArrayList<String> tipoSQL = new ArrayList<String>();
        ArrayList<Boolean> lastID = new ArrayList<Boolean>();
        strSQL = new ArrayList();
        tipoSQL = new ArrayList();
        lastID = new ArrayList();
        lastID.add(false);
        strSQL.add("SELECt tipo_oper FROM gen_t_oper_sian WHERE sian_cod_oper='" + codice + "' LIMIT 1");
        tipoSQL.add("select");
        String strJson = this.util.makeStringJsonDB("OFF", tipoSQL, strSQL, null, null, lastID, null);
        String data_select = this.sk1Comm.ServerEsecuteRequest(FXMLDocumentController.GLOBAL_IP, FXMLDocumentController.GLOBAL_PORT, "dbInteraction#@" + strJson);
        if (!data_select.contains("#ERR:")) {
            JSONArray arrayJson = this.jsonUtil.strJsonToJSONArray(data_select);
            for (int i = 0; i < arrayJson.length(); ++i) {
                JSONObject rec = arrayJson.getJSONObject(i);
                ret = rec.getString("tipo_oper");
            }
        } else {
            ret = data_select;
        }
        return ret;
    }

    public String getLottiFromTableCMovimentiLotti(String codiceArticolo) throws JSONException {
        String data_select;
        String ret = null;
        ArrayList json = new ArrayList();
        ArrayList<String> strSQL = new ArrayList<String>();
        ArrayList<String> tipoSQL = new ArrayList<String>();
        ArrayList<Boolean> lastID = new ArrayList<Boolean>();
        strSQL = new ArrayList();
        tipoSQL = new ArrayList();
        lastID = new ArrayList();
        lastID.add(false);
        strSQL.add("SELECT b.id AS id,a.cod_tipo_vino,b.cod_lotto AS cod_lotto FROM c_movimenti AS a LEFT JOIN c_movimenti_lotti AS b ON a.id=b.id_mov WHERE a.cod_tipo_vino='" + codiceArticolo.replace("'", "\\'") + "' GROUP BY a.cod_tipo_vino,b.cod_lotto");
        tipoSQL.add("select");
        String strJson = this.util.makeStringJsonDB("OFF", tipoSQL, strSQL, null, null, lastID, null);
        ret = data_select = this.sk1Comm.ServerEsecuteRequest(FXMLDocumentController.GLOBAL_IP, FXMLDocumentController.GLOBAL_PORT, "dbInteraction#@" + strJson);
        return ret;
    }

    public String checkVinoCert(String codice) throws JSONException {
        String ret = "";
        ArrayList<String> strSQL = new ArrayList<String>();
        ArrayList<String> tipoSQL = new ArrayList<String>();
        ArrayList<Boolean> lastID = new ArrayList<Boolean>();
        strSQL = new ArrayList();
        tipoSQL = new ArrayList();
        lastID = new ArrayList();
        lastID.add(false);
        strSQL.add("SELECT sian_atto_certificato FROM gen_tipo_vino_ana WHERE codice='" + codice.replace("'", "\\'") + "' AND azienda='" + FXMLDocumentController.GLOBAL_AZIENDA + "' AND sotto_az='" + FXMLDocumentController.GLOBAL_SOTTOAZZ + "' AND icqrf='" + FXMLDocumentController.GLOBAL_ICQRF + "' AND cod_committente='" + FXMLDocumentController.GLOBAL_CODCOMM + "'");
        tipoSQL.add("select");
        String strJson = FXMLDocumentController.util.makeStringJsonDB("OFF", tipoSQL, strSQL, null, null, lastID, null);
        String data_select = FXMLDocumentController.sk1Comm.ServerEsecuteRequest(FXMLDocumentController.GLOBAL_IP, FXMLDocumentController.GLOBAL_PORT, "dbInteraction#@" + strJson);
        if (!data_select.contains("#ERR:")) {
            JSONArray arrayJson = FXMLDocumentController.jsonUtil.strJsonToJSONArray(data_select);
            for (int i = 0; i < arrayJson.length(); ++i) {
                JSONObject rec = arrayJson.getJSONObject(i);
                ret = rec.getString("sian_atto_certificato");
            }
        } else {
            ret = data_select;
        }
        return ret;
    }

    public Double getCapacitaVasca(int id) throws JSONException {
        double ret = 0.0;
        ArrayList<String> strSQL = new ArrayList<String>();
        ArrayList<String> tipoSQL = new ArrayList<String>();
        ArrayList<Boolean> lastID = new ArrayList<Boolean>();
        strSQL = new ArrayList();
        tipoSQL = new ArrayList();
        lastID = new ArrayList();
        lastID.add(false);
        strSQL.add("SELECT capacita FROM gen_vasi_vinari_ana  WHERE id=" + id + " ");
        tipoSQL.add("select");
        String strJson = this.util.makeStringJsonDB("OFF", tipoSQL, strSQL, null, null, lastID, null);
        String data_select = this.sk1Comm.ServerEsecuteRequest(FXMLDocumentController.GLOBAL_IP, FXMLDocumentController.GLOBAL_PORT, "dbInteraction#@" + strJson);
        if (!data_select.contains("#ERR:")) {
            JSONArray arrayJson = this.jsonUtil.strJsonToJSONArray(data_select);
            for (int i = 0; i < arrayJson.length(); ++i) {
                ret = arrayJson.getJSONObject(i).getDouble("capacita");
            }
        }
        return ret;
    }

    public String getSianAnaProdotto(String codice) throws JSONException {
        String ret = "";
        ArrayList<String> strSQL = new ArrayList<String>();
        ArrayList<String> tipoSQL = new ArrayList<String>();
        ArrayList<Boolean> lastID = new ArrayList<Boolean>();
        strSQL = new ArrayList();
        tipoSQL = new ArrayList();
        lastID = new ArrayList();
        lastID.add(false);
        strSQL.add("SELECT a.altre_raspi,a.altre_vinacce,a.sian_pratiche_eno,a.sian_cod_zona_viticola,a.descrizione,a.sian_classificazione,a.sian_atto_certificato,a.sian_cod_stato_fisico,a.sian_cat_prodotto,a.sian_massa_volumica,a.sian_volume_nominale,b.codice AS mx_art FROM gen_tipo_vino_ana AS a  LEFT JOIN gen_tipo_vino_ana_mx AS b ON a.id=b.id_tipo_vino_ana  WHERE a.codice='" + codice.replace("'", "\\'") + "' AND a.azienda='" + FXMLDocumentController.GLOBAL_AZIENDA + "' AND a.sotto_az='" + FXMLDocumentController.GLOBAL_SOTTOAZZ + "' AND a.icqrf='" + FXMLDocumentController.GLOBAL_ICQRF + "' AND a.cod_committente='" + FXMLDocumentController.GLOBAL_CODCOMM + "'");
        tipoSQL.add("select");
        String strJson = this.util.makeStringJsonDB("OFF", tipoSQL, strSQL, null, null, lastID, null);
        String data_select = this.sk1Comm.ServerEsecuteRequest(FXMLDocumentController.GLOBAL_IP, FXMLDocumentController.GLOBAL_PORT, "dbInteraction#@" + strJson);
        if (!data_select.contains("#ERR:")) {
            JSONArray arrayJson = this.jsonUtil.strJsonToJSONArray(data_select);
            ret = arrayJson.toString();
        } else {
            ret = data_select;
        }
        return ret;
    }

    public String getDescrizioneFromStatoIstat(String codice) throws JSONException {
        String ret = "";
        ArrayList<String> strSQL = new ArrayList<String>();
        ArrayList<String> tipoSQL = new ArrayList<String>();
        ArrayList<Boolean> lastID = new ArrayList<Boolean>();
        strSQL = new ArrayList();
        tipoSQL = new ArrayList();
        lastID = new ArrayList();
        lastID.add(false);
        strSQL.add("SELECT name AS descrizione FROM sian_t_paesiiso WHERE ISO3166_1_numeric='" + codice + "'");
        tipoSQL.add("select");
        String strJson = this.util.makeStringJsonDB("OFF", tipoSQL, strSQL, null, null, lastID, null);
        String data_select = this.sk1Comm.ServerEsecuteRequest(FXMLDocumentController.GLOBAL_IP, FXMLDocumentController.GLOBAL_PORT, "dbInteraction#@" + strJson);
        if (!data_select.contains("#ERR:")) {
            JSONArray arrayJson = this.jsonUtil.strJsonToJSONArray(data_select);
            for (int i = 0; i < arrayJson.length(); ++i) {
                JSONObject obj = arrayJson.getJSONObject(i);
                ret = obj.get("descrizione").toString().replace("null", "");
            }
        }
        return ret;
    }

    public String getDescrizioneFromProvinciaIstat(String codice) throws JSONException {
        String ret = "";
        ArrayList<String> strSQL = new ArrayList<String>();
        ArrayList<String> tipoSQL = new ArrayList<String>();
        ArrayList<Boolean> lastID = new ArrayList<Boolean>();
        strSQL = new ArrayList();
        tipoSQL = new ArrayList();
        lastID = new ArrayList();
        lastID.add(false);
        strSQL.add("SELECT Descrizione AS descrizione FROM sian_t_istat_province  WHERE LPAD(CodiceProvincia,3,'0')='" + codice + "'");
        tipoSQL.add("select");
        String strJson = this.util.makeStringJsonDB("OFF", tipoSQL, strSQL, null, null, lastID, null);
        String data_select = this.sk1Comm.ServerEsecuteRequest(FXMLDocumentController.GLOBAL_IP, FXMLDocumentController.GLOBAL_PORT, "dbInteraction#@" + strJson);
        if (!data_select.contains("#ERR:")) {
            JSONArray arrayJson = this.jsonUtil.strJsonToJSONArray(data_select);
            for (int i = 0; i < arrayJson.length(); ++i) {
                JSONObject obj = arrayJson.getJSONObject(i);
                ret = obj.get("descrizione").toString().replace("null", "");
            }
        }
        return ret;
    }

    public String getDescrizioneFromCodiceStatoVal(String codice) throws JSONException {
        String ret = "";
        ArrayList<String> strSQL = new ArrayList<String>();
        ArrayList<String> tipoSQL = new ArrayList<String>();
        ArrayList<Boolean> lastID = new ArrayList<Boolean>();
        strSQL = new ArrayList();
        tipoSQL = new ArrayList();
        lastID = new ArrayList();
        lastID.add(false);
        strSQL.add("SELECT IFNULL(descrizione,'') AS descrizione FROM mvv_statovalidazione  WHERE codice='" + codice + "'");
        tipoSQL.add("select");
        String strJson = this.util.makeStringJsonDB("OFF", tipoSQL, strSQL, null, null, lastID, null);
        String data_select = this.sk1Comm.ServerEsecuteRequest(FXMLDocumentController.GLOBAL_IP, FXMLDocumentController.GLOBAL_PORT, "dbInteraction#@" + strJson);
        if (!data_select.contains("#ERR:")) {
            JSONArray arrayJson = this.jsonUtil.strJsonToJSONArray(data_select);
            for (int i = 0; i < arrayJson.length(); ++i) {
                JSONObject obj = arrayJson.getJSONObject(i);
                ret = obj.get("descrizione").toString();
            }
        }
        return ret;
    }

    public String getDescrizioneFromTipologiaMezzo(String codice) throws JSONException {
        String ret = "";
        ArrayList<String> strSQL = new ArrayList<String>();
        ArrayList<String> tipoSQL = new ArrayList<String>();
        ArrayList<Boolean> lastID = new ArrayList<Boolean>();
        strSQL = new ArrayList();
        tipoSQL = new ArrayList();
        lastID = new ArrayList();
        lastID.add(false);
        strSQL.add("SELECT descrizione FROM mvv_mezzot  WHERE codice='" + codice + "'");
        tipoSQL.add("select");
        String strJson = this.util.makeStringJsonDB("OFF", tipoSQL, strSQL, null, null, lastID, null);
        String data_select = this.sk1Comm.ServerEsecuteRequest(FXMLDocumentController.GLOBAL_IP, FXMLDocumentController.GLOBAL_PORT, "dbInteraction#@" + strJson);
        if (!data_select.contains("#ERR:")) {
            JSONArray arrayJson = this.jsonUtil.strJsonToJSONArray(data_select);
            for (int i = 0; i < arrayJson.length(); ++i) {
                JSONObject obj = arrayJson.getJSONObject(i);
                ret = obj.get("descrizione").toString().replace("null", "");
            }
        }
        return ret;
    }

    public String getDescrizioneFromTenoreZucchero(String codice) throws JSONException {
        String ret = "";
        ArrayList<String> strSQL = new ArrayList<String>();
        ArrayList<String> tipoSQL = new ArrayList<String>();
        ArrayList<Boolean> lastID = new ArrayList<Boolean>();
        strSQL = new ArrayList();
        tipoSQL = new ArrayList();
        lastID = new ArrayList();
        lastID.add(false);
        strSQL.add("SELECT DESCRIZIONE AS descrizione FROM sian_t_tenore_zuccheri  WHERE CODICE='" + codice + "'");
        tipoSQL.add("select");
        String strJson = this.util.makeStringJsonDB("OFF", tipoSQL, strSQL, null, null, lastID, null);
        String data_select = this.sk1Comm.ServerEsecuteRequest(FXMLDocumentController.GLOBAL_IP, FXMLDocumentController.GLOBAL_PORT, "dbInteraction#@" + strJson);
        if (!data_select.contains("#ERR:")) {
            JSONArray arrayJson = this.jsonUtil.strJsonToJSONArray(data_select);
            for (int i = 0; i < arrayJson.length(); ++i) {
                JSONObject obj = arrayJson.getJSONObject(i);
                ret = obj.get("descrizione").toString().replace("null", "");
            }
        }
        return ret;
    }

    public String getDescrizioneFromCodiceNomenclatura(String codice1, String codice2, String codice3) throws JSONException {
        String ret = "";
        ArrayList<String> strSQL = new ArrayList<String>();
        ArrayList<String> tipoSQL = new ArrayList<String>();
        ArrayList<Boolean> lastID = new ArrayList<Boolean>();
        strSQL = new ArrayList();
        tipoSQL = new ArrayList();
        lastID = new ArrayList();
        lastID.add(false);
        strSQL.add("SELECT descrizione FROM mvv_codnomcomb  WHERE codice_nc_1='" + codice1 + "' AND codice_nc_2='" + codice2 + "' AND codice_nc_3='" + codice3 + "' ");
        tipoSQL.add("select");
        String strJson = this.util.makeStringJsonDB("OFF", tipoSQL, strSQL, null, null, lastID, null);
        String data_select = this.sk1Comm.ServerEsecuteRequest(FXMLDocumentController.GLOBAL_IP, FXMLDocumentController.GLOBAL_PORT, "dbInteraction#@" + strJson);
        if (!data_select.contains("#ERR:")) {
            JSONArray arrayJson = this.jsonUtil.strJsonToJSONArray(data_select);
            for (int i = 0; i < arrayJson.length(); ++i) {
                JSONObject obj = arrayJson.getJSONObject(i);
                ret = obj.get("descrizione").toString().replace("null", "");
            }
        }
        return ret;
    }

    public String getDescrizioneFromProdotto(String codice, String azienda, String sotto_az, String icqrf) throws JSONException {
        String ret = "";
        ArrayList<String> strSQL = new ArrayList<String>();
        ArrayList<String> tipoSQL = new ArrayList<String>();
        ArrayList<Boolean> lastID = new ArrayList<Boolean>();
        strSQL = new ArrayList();
        tipoSQL = new ArrayList();
        lastID = new ArrayList();
        lastID.add(false);
        strSQL.add("SELECT descrizione FROM gen_tipo_vino_ana  WHERE codice='" + codice + "' AND azienda='" + azienda + "' AND icqrf='" + icqrf + "' AND sotto_az='" + sotto_az + "'");
        tipoSQL.add("select");
        String strJson = this.util.makeStringJsonDB("OFF", tipoSQL, strSQL, null, null, lastID, null);
        String data_select = this.sk1Comm.ServerEsecuteRequest(FXMLDocumentController.GLOBAL_IP, FXMLDocumentController.GLOBAL_PORT, "dbInteraction#@" + strJson);
        if (!data_select.contains("#ERR:")) {
            JSONArray arrayJson = this.jsonUtil.strJsonToJSONArray(data_select);
            for (int i = 0; i < arrayJson.length(); ++i) {
                JSONObject obj = arrayJson.getJSONObject(i);
                ret = obj.get("descrizione").toString().replace("null", "");
            }
        }
        return ret;
    }

    public String getDescrizioneFromComuneIstat(String codiceProvincia, String codiceComune) throws JSONException {
        String ret = "";
        ArrayList<String> strSQL = new ArrayList<String>();
        ArrayList<String> tipoSQL = new ArrayList<String>();
        ArrayList<Boolean> lastID = new ArrayList<Boolean>();
        strSQL = new ArrayList();
        tipoSQL = new ArrayList();
        lastID = new ArrayList();
        lastID.add(false);
        strSQL.add("SELECT Descrizione AS descrizione FROM sian_t_istat_comuni  WHERE CodiceProvincia='" + codiceProvincia + "' AND CodiceComune='" + codiceComune + "'");
        tipoSQL.add("select");
        String strJson = this.util.makeStringJsonDB("OFF", tipoSQL, strSQL, null, null, lastID, null);
        String data_select = this.sk1Comm.ServerEsecuteRequest(FXMLDocumentController.GLOBAL_IP, FXMLDocumentController.GLOBAL_PORT, "dbInteraction#@" + strJson);
        if (!data_select.contains("#ERR:")) {
            JSONArray arrayJson = this.jsonUtil.strJsonToJSONArray(data_select);
            for (int i = 0; i < arrayJson.length(); ++i) {
                JSONObject obj = arrayJson.getJSONObject(i);
                ret = obj.get("descrizione").toString().replace("null", "");
            }
        }
        return ret;
    }

    public String getDescrizioneFromCausaleTrasporto(String codice) throws JSONException {
        String ret = "";
        ArrayList<String> strSQL = new ArrayList<String>();
        ArrayList<String> tipoSQL = new ArrayList<String>();
        ArrayList<Boolean> lastID = new ArrayList<Boolean>();
        strSQL = new ArrayList();
        tipoSQL = new ArrayList();
        lastID = new ArrayList();
        lastID.add(false);
        strSQL.add("SELECT descrizione FROM mvv_causalemt  WHERE codice='" + codice + "' ");
        tipoSQL.add("select");
        String strJson = this.util.makeStringJsonDB("OFF", tipoSQL, strSQL, null, null, lastID, null);
        String data_select = this.sk1Comm.ServerEsecuteRequest(FXMLDocumentController.GLOBAL_IP, FXMLDocumentController.GLOBAL_PORT, "dbInteraction#@" + strJson);
        if (!data_select.contains("#ERR:")) {
            JSONArray arrayJson = this.jsonUtil.strJsonToJSONArray(data_select);
            for (int i = 0; i < arrayJson.length(); ++i) {
                JSONObject obj = arrayJson.getJSONObject(i);
                ret = obj.get("descrizione").toString().replace("null", "");
            }
        }
        return ret;
    }

    public String getSianAnaProdottoFromMX(String prodottoMX) throws JSONException {
        String ret = "";
        ArrayList<String> strSQL = new ArrayList<String>();
        ArrayList<String> tipoSQL = new ArrayList<String>();
        ArrayList<Boolean> lastID = new ArrayList<Boolean>();
        strSQL = new ArrayList();
        tipoSQL = new ArrayList();
        lastID = new ArrayList();
        lastID.add(false);
        strSQL.add("SELECT a.altre_raspi,a.altre_vinacce,a.sian_pratiche_eno,a.sian_cod_zona_viticola,a.descrizione,a.sian_classificazione,a.sian_atto_certificato,a.sian_cod_stato_fisico,a.sian_cat_prodotto,a.sian_massa_volumica,a.sian_volume_nominale,b.codice AS mx_art FROM gen_tipo_vino_ana AS a  LEFT JOIN gen_tipo_vino_ana_mx AS b ON a.id=b.id_tipo_vino_ana  WHERE b.codice='" + prodottoMX.replace("'", "\\'") + "' AND a.azienda='" + FXMLDocumentController.GLOBAL_AZIENDA + "' AND a.sotto_az='" + FXMLDocumentController.GLOBAL_SOTTOAZZ + "' AND a.icqrf='" + FXMLDocumentController.GLOBAL_ICQRF + "' AND a.cod_committente='" + FXMLDocumentController.GLOBAL_CODCOMM + "'");
        tipoSQL.add("select");
        String strJson = this.util.makeStringJsonDB("OFF", tipoSQL, strSQL, null, null, lastID, null);
        String data_select = this.sk1Comm.ServerEsecuteRequest(FXMLDocumentController.GLOBAL_IP, FXMLDocumentController.GLOBAL_PORT, "dbInteraction#@" + strJson);
        if (!data_select.contains("#ERR:")) {
            JSONArray arrayJson = this.jsonUtil.strJsonToJSONArray(data_select);
            ret = arrayJson.toString();
        } else {
            ret = data_select;
        }
        return ret;
    }

    public String getMXProdottoFromProdotto(String prodotto) throws JSONException {
        String ret = "";
        ArrayList<String> strSQL = new ArrayList<String>();
        ArrayList<String> tipoSQL = new ArrayList<String>();
        ArrayList<Boolean> lastID = new ArrayList<Boolean>();
        strSQL = new ArrayList();
        tipoSQL = new ArrayList();
        lastID = new ArrayList();
        lastID.add(false);
        strSQL.add("SELECT b.codice FROM gen_tipo_vino_ana AS a LEFT JOIN gen_tipo_vino_ana_mx AS b ON a.id=b.id_tipo_vino_ana  WHERE a.codice='" + prodotto.replace("'", "\\'") + "' AND a.azienda='" + FXMLDocumentController.GLOBAL_AZIENDA + "' AND a.sotto_az='" + FXMLDocumentController.GLOBAL_SOTTOAZZ + "' AND a.icqrf='" + FXMLDocumentController.GLOBAL_ICQRF + "' AND a.cod_committente='" + FXMLDocumentController.GLOBAL_CODCOMM + "'");
        tipoSQL.add("select");
        String strJson = this.util.makeStringJsonDB("OFF", tipoSQL, strSQL, null, null, lastID, null);
        String data_select = this.sk1Comm.ServerEsecuteRequest(FXMLDocumentController.GLOBAL_IP, FXMLDocumentController.GLOBAL_PORT, "dbInteraction#@" + strJson);
        if (!data_select.contains("#ERR:")) {
            JSONArray arrayJson = this.jsonUtil.strJsonToJSONArray(data_select);
            for (int i = 0; i < arrayJson.length(); ++i) {
                JSONObject obj = arrayJson.getJSONObject(i);
                ret = obj.getString("codice");
            }
        } else {
            ret = data_select;
        }
        return ret;
    }

    public String getProdottoFromProdottoMX(String prodotto, String azienda, String sotto_az, String icqrf, String cod_committente) throws JSONException {
        String ret = "";
        ArrayList<String> strSQL = new ArrayList<String>();
        ArrayList<String> tipoSQL = new ArrayList<String>();
        ArrayList<Boolean> lastID = new ArrayList<Boolean>();
        strSQL = new ArrayList();
        tipoSQL = new ArrayList();
        lastID = new ArrayList();
        lastID.add(false);
        strSQL.add("SELECT a.codice FROM gen_tipo_vino_ana AS a LEFT JOIN gen_tipo_vino_ana_mx AS b ON a.id=b.id_tipo_vino_ana  WHERE b.codice='" + prodotto.replace("'", "\\'") + "' AND a.azienda='" + azienda + "' AND a.sotto_az='" + sotto_az + "' AND a.icqrf='" + icqrf + "' AND a.cod_committente='" + cod_committente + "' LIMIT 1");
        tipoSQL.add("select");
        String strJson = this.util.makeStringJsonDB("OFF", tipoSQL, strSQL, null, null, lastID, null);
        String data_select = this.sk1Comm.ServerEsecuteRequest(FXMLDocumentController.GLOBAL_IP, FXMLDocumentController.GLOBAL_PORT, "dbInteraction#@" + strJson);
        if (!data_select.contains("#ERR:")) {
            JSONArray arrayJson = this.jsonUtil.strJsonToJSONArray(data_select);
            for (int i = 0; i < arrayJson.length(); ++i) {
                JSONObject obj = arrayJson.getJSONObject(i);
                ret = obj.getString("codice");
            }
        } else {
            ret = data_select;
        }
        return ret;
    }

    public JSONArray giacenzaVasiOperazione(String where, String dadata, String adata) throws JSONException {
        JSONArray ret = null;
        ArrayList<String> strSQL = new ArrayList<String>();
        ArrayList<String> tipoSQL = new ArrayList<String>();
        ArrayList<Boolean> lastID = new ArrayList<Boolean>();
        strSQL = new ArrayList();
        tipoSQL = new ArrayList();
        lastID = new ArrayList();
        lastID.add(false);
        String str = "DROP TEMPORARY TABLE IF EXISTS tb1;\nCREATE TEMPORARY TABLE IF NOT EXISTS tb1(\nid_vaso BIGINT(20),\ngiacenza DECIMAL(22,4),\ncod_tipo_vino VARCHAR(255),\ncapacita DECIMAL(18,4),\nnum_prot_ido VARCHAR(255),\nente_cert VARCHAR(255),\ndata_ido DATE,\nazienda VARCHAR(10),\nsotto_az VARCHAR(15),\nicqrf VARCHAR(10),\ncod_committente VARCHAR(15)\n);\nINSERT INTO tb1( SELECT b.id_vaso,SUM(b.qta_mov) AS giacenza,b.cod_tipo_vino,c.capacita,a.num_prot_ido,a.ente_cert,a.data_ido,a.azienda,a.sotto_az,a.icqrf,a.cod_committente \nFROM c_movimenti AS a\nLEFT JOIN gen_vasi_vinari_mov AS b ON a.id=b.id_mov\nLEFT JOIN gen_vasi_vinari_ana AS c ON b.id_vaso=c.id\nLEFT JOIN c_operazioni AS aa ON a.id_oper=aa.id \nWHERE a.azienda='" + FXMLDocumentController.GLOBAL_AZIENDA + "' AND a.sotto_az='" + FXMLDocumentController.GLOBAL_SOTTOAZZ + "' AND a.icqrf='" + FXMLDocumentController.GLOBAL_ICQRF + "'  AND aa.data_oper>='" + dadata + "' AND aa.data_oper<='" + adata + "'\nGROUP BY a.cod_committente,b.id_vaso,a.cod_tipo_vino,a.num_prot_ido,a.ente_cert,a.data_ido);\nCREATE INDEX index_name_4\nON tb1 (id_vaso);\n\nDROP TEMPORARY TABLE IF EXISTS tb2;\nCREATE TEMPORARY TABLE IF NOT EXISTS tb2(\nid_vaso BIGINT(20),\ncod_tipo_vino VARCHAR(255),\nnum_prot_ido VARCHAR(255),\nente_cert VARCHAR(255),\ndata_ido DATE,\nazienda VARCHAR(10),\nsotto_az VARCHAR(15),\nicqrf VARCHAR(10),\ncod_committente VARCHAR(15)\n);\nINSERT INTO tb2(SELECT   b.id_vaso,a.cod_tipo_vino,a.num_prot_ido,a.ente_cert,a.data_ido,a.azienda,a.sotto_az,a.icqrf,a.cod_committente\nFROM c_movimenti AS a \nLEFT JOIN gen_vasi_vinari_mov AS b ON a.id=b.id_mov\nLEFT JOIN gen_vasi_vinari_ana AS c ON b.id_vaso=c.id\nLEFT JOIN c_operazioni AS aa ON a.id_oper=aa.id \nWHERE b.id_vaso IS NOT NULL AND b.id_vaso<>''  AND  a.azienda='" + FXMLDocumentController.GLOBAL_AZIENDA + "' AND a.sotto_az='" + FXMLDocumentController.GLOBAL_SOTTOAZZ + "' AND a.icqrf='" + FXMLDocumentController.GLOBAL_ICQRF + "' \nAND aa.data_oper>='" + dadata + "' AND aa.data_oper<='" + adata + "'\nGROUP BY a.cod_committente,b.id_vaso,a.cod_tipo_vino,a.num_prot_ido,a.ente_cert,a.data_ido);\nCREATE INDEX index_name_3\nON tb2 (id_vaso);\n\nDROP TEMPORARY TABLE IF EXISTS tb3;\nCREATE TEMPORARY TABLE IF NOT EXISTS tb3(\nid_vaso BIGINT(20),\ncod_tipo_vino VARCHAR(255),\ngiacenza DECIMAL(22,4),\nnum_prot_ido VARCHAR(255),\nente_cert VARCHAR(255),\ndata_ido DATE,\nazienda VARCHAR(10),\nsotto_az VARCHAR(15),\nicqrf VARCHAR(10),\ncod_committente VARCHAR(15)\n);\n\n\nINSERT INTO tb3(SELECT a.id_vaso,a.cod_tipo_vino,a.giacenza,a.num_prot_ido,a.ente_cert,a.data_ido,a.azienda,a.sotto_az,a.icqrf,a.cod_committente \nFROM tb1 AS a \nLEFT JOIN tb2 AS b ON a.id_vaso=b.id_vaso AND a.cod_tipo_vino=b.cod_tipo_vino \nAND a.num_prot_ido=b.num_prot_ido AND a.ente_cert=b.ente_cert AND a.data_ido=b.data_ido \nAND a.azienda=b.azienda AND a.sotto_az=b.sotto_az AND a.icqrf=b.icqrf AND a.cod_committente=b.cod_committente\n);\n\n\nDROP TEMPORARY TABLE IF EXISTS tb4;\nCREATE TEMPORARY TABLE IF NOT EXISTS tb4(\nid_vaso BIGINT(20),\ncod_tipo_vino VARCHAR(255),\ngiacenza DECIMAL(22,4),\nnum_prot_ido VARCHAR(255),\nente_cert VARCHAR(255),\ndata_ido DATE,\nazienda VARCHAR(10),\nsotto_az VARCHAR(15),\nicqrf VARCHAR(10),\ncod_committente VARCHAR(15)\n);\nINSERT INTO tb4(SELECT \na.id_vaso,\na.cod_tipo_vino,\na.giacenza,\na.num_prot_ido,\na.ente_cert,\na.data_ido,\na.azienda,\na.sotto_az,\na.icqrf,\na.cod_committente \nFROM tb3 AS a\nWHERE a.id_vaso IS NOT NULL AND a.id_vaso<>'');\nCREATE INDEX index_name_1\nON tb4 (id_vaso);\n\nDROP TEMPORARY TABLE IF EXISTS tb5;\nCREATE TEMPORARY TABLE IF NOT EXISTS tb5(\ngiacenza DECIMAL(22,4),\ncapacita DECIMAL(18,4),\nid_vaso BIGINT(20)\n);\nINSERT INTO tb5(SELECT SUM(b.qta_mov) AS giacenza,(c.capacita * 100) AS capacita,b.id_vaso  \nFROM c_movimenti AS a \nLEFT JOIN gen_vasi_vinari_mov AS b ON a.id=b.id_mov\nLEFT JOIN gen_vasi_vinari_ana AS c ON b.id_vaso=c.id\nLEFT JOIN c_operazioni AS aa ON a.id_oper=aa.id \nWHERE a.azienda='" + FXMLDocumentController.GLOBAL_AZIENDA + "' AND a.sotto_az='" + FXMLDocumentController.GLOBAL_SOTTOAZZ + "' AND a.icqrf='" + FXMLDocumentController.GLOBAL_ICQRF + "'AND aa.data_oper>='" + dadata + "' AND aa.data_oper<='" + adata + "'\nGROUP BY a.azienda,a.sotto_az,a.icqrf,a.cod_committente,b.id_vaso\n);\n\n\nDROP TEMPORARY TABLE IF EXISTS tb6;\nCREATE TEMPORARY TABLE IF NOT EXISTS tb6(\nresiduo DECIMAL(22,4),\nid_vaso BIGINT(20)\n);\nINSERT INTO tb6(SELECT (a.capacita-a.giacenza)/100 AS residuo,a.id_vaso \nFROM tb5 AS a);\nCREATE INDEX index_name_2\nON tb6 (id_vaso);\n\nDROP TEMPORARY TABLE IF EXISTS tb7;\nCREATE TEMPORARY TABLE IF NOT EXISTS tb7(\nid BIGINT(20),\ncodice_vaso VARCHAR(255),\ndescr_vaso VARCHAR(255),\ntipo_vaso VARCHAR(50),\ncapacita DECIMAL(18,4),\ngiacenza DECIMAL(22,4),\nresiduo DECIMAL(22,4),\nflg_gruppo INT(1),\ncod_tipo_vino VARCHAR(255),\nazienda VARCHAR(10),\nsotto_az VARCHAR(15),\nicqrf VARCHAR(10),\ncod_committente VARCHAR(15),\nnum_prot_ido VARCHAR(255),\nente_cert VARCHAR(255),\ndata_ido VARCHAR(20)\n);\nINSERT INTO tb7(SELECT a.id,a.codice_vaso,a.descr_vaso,a.tipo_vaso,a.capacita,IFNULL(b.giacenza,0) AS giacenza,\nIFNULL(c.residuo,a.capacita) AS residuo,a.flg_gruppo,IFNULL(b.cod_tipo_vino,'') AS cod_tipo_vino,a.azienda,a.sotto_az,\na.icqrf,IFNULL(b.cod_committente,'') AS cod_committente,IFNULL(b.num_prot_ido,'') AS num_prot_ido,IFNULL(b.ente_cert,'') AS ente_cert,\nIF(IFNULL(b.data_ido,'')='0000-00-00','',IFNULL(b.data_ido,'')) AS data_ido \n FROM gen_vasi_vinari_ana AS a \n LEFT JOIN tb4 AS b ON a.id=b.id_vaso \nLEFT JOIN tb6 AS c ON a.id=c.id_vaso);\n\n\nSELECT a.id,a.codice_vaso,a.descr_vaso,a.tipo_vaso,a.capacita,a.giacenza,a.residuo,a.flg_gruppo,a.cod_tipo_vino,\na.azienda,a.sotto_az,a.icqrf,a.cod_committente,a.num_prot_ido,a.ente_cert,a.data_ido \nFROM tb7 AS a \n";
        if (!where.equals("")) {
            str = str + where;
        }
        strSQL.add(str);
        tipoSQL.add("selectRS");
        String strJson = this.util.makeStringJsonDB("OFF", tipoSQL, strSQL, null, null, lastID, null);
        String data_select = this.sk1Comm.ServerEsecuteRequest(FXMLDocumentController.GLOBAL_IP, FXMLDocumentController.GLOBAL_PORT, "dbInteraction#@" + strJson);
        if (!data_select.contains("#ERR:")) {
            ret = this.jsonUtil.strJsonToJSONArray(data_select);
        }
        return ret;
    }

    public JSONArray giacenzaVasi(String where, String where_key, boolean having) throws JSONException {
        JSONArray ret = null;
        ArrayList<String> strSQL = new ArrayList<String>();
        ArrayList<String> tipoSQL = new ArrayList<String>();
        ArrayList<Boolean> lastID = new ArrayList<Boolean>();
        strSQL = new ArrayList();
        tipoSQL = new ArrayList();
        lastID = new ArrayList();
        lastID.add(false);
        String str = "";
        if (!where.equals("") && where_key.equals("")) {
            str = this.selectBuilder(where, false, "a");
        }
        if (where.equals("") && !where_key.equals("")) {
            str = this.selectBuilder2(where_key, having);
        }
        if (!where.equals("") && !where_key.equals("")) {
            str = this.selectBuilder(where, false, "a");
            str = str + " UNION ALL ";
            str = str + this.selectBuilder(where_key, true, "b");
        }
        strSQL.add(str);
        tipoSQL.add("selectRS");
        String strJson = this.util.makeStringJsonDB("OFF", tipoSQL, strSQL, null, null, lastID, null);
        String data_select = this.sk1Comm.ServerEsecuteRequest(FXMLDocumentController.GLOBAL_IP, FXMLDocumentController.GLOBAL_PORT, "dbInteraction#@" + strJson);
        if (!data_select.contains("#ERR:")) {
            ret = this.jsonUtil.strJsonToJSONArray(data_select);
        }
        return ret;
    }

    private String selectBuilder2(String where, boolean having) {
        String ret = " DROP TEMPORARY TABLE IF EXISTS table_base;\n DROP TEMPORARY TABLE IF EXISTS table_sopraint;\n DROP TEMPORARY TABLE IF EXISTS table_sopramezzo;\n DROP TEMPORARY TABLE IF EXISTS table_sottomez;\n DROP TEMPORARY TABLE IF EXISTS table_sottomezjoin;\n DROP TEMPORARY TABLE IF EXISTS table_sottomezjoinss;\n DROP TEMPORARY TABLE IF EXISTS table_asopra;\n DROP TEMPORARY TABLE IF EXISTS table_bsopra;\n \n DROP TEMPORARY TABLE IF EXISTS table_intb;\n DROP TEMPORARY TABLE IF EXISTS table_intbsopra;\n DROP TEMPORARY TABLE IF EXISTS table_intbjoin;\n DROP TEMPORARY TABLE IF EXISTS table_intbjoins;\n DROP TEMPORARY TABLE IF EXISTS table_sottomezjoin;\n DROP TEMPORARY TABLE IF EXISTS table_sottomezjoinss;\n DROP TEMPORARY TABLE IF EXISTS table_bsotto;\n DROP TEMPORARY TABLE IF EXISTS table_bsottojoin;\n \n DROP TEMPORARY TABLE IF EXISTS table_final;\n \nCREATE TEMPORARY TABLE IF NOT EXISTS table_base(\ncancellato_reale VARCHAR(10),\nflg_gruppo INT(1),\ncod_committente VARCHAR(15),\nazienda VARCHAR(15),\nsotto_az VARCHAR(15),\nid BIGINT(20),\ncodice_vaso VARCHAR(60),\ntipo_vaso VARCHAR(2),\ndescr_vaso VARCHAR(255),\ncapacita VARCHAR(255),\ncod_tipo_vino VARCHAR(100),\ngiacenza DECIMAL(18,5),\nnum_prot_ido VARCHAR(255),\ndata_ido DATE,\nente_cert VARCHAR(255)\n)ENGINE=INNODB DEFAULT CHARSET=latin1;\nCREATE TEMPORARY TABLE IF NOT EXISTS table_sopraint(\ncancellato_reale VARCHAR(10),\nflg_gruppo INT(1),\ncod_committente VARCHAR(15),\nazienda VARCHAR(15),\nsotto_az VARCHAR(15),\nid BIGINT(20),\ncodice_vaso VARCHAR(60),\ntipo_vaso VARCHAR(2),\ndescr_vaso VARCHAR(255),\ncapacita VARCHAR(255),\ncod_tipo_vino VARCHAR(100),\ngiacenza DECIMAL(18,5),\nnum_prot_ido VARCHAR(255),\ndata_ido DATE,\nente_cert VARCHAR(255)\n)ENGINE=INNODB DEFAULT CHARSET=latin1;\nCREATE TEMPORARY TABLE IF NOT EXISTS table_sopramezzo(\ncod_committente VARCHAR(15),\nazienda VARCHAR(15),\nsotto_az VARCHAR(15),\nid BIGINT(20),\ncodice_vaso VARCHAR(255),\ntipo_vaso VARCHAR(255),\ndescr_vaso VARCHAR(255),\ncapacita DECIMAL(18,5),\ncod_tipo_vino VARCHAR(100),\nnum_prot_ido VARCHAR(255),\ndata_ido VARCHAR(255),\nente_cert VARCHAR(255),\ngiacenza DECIMAL(18,5)\n)ENGINE=INNODB DEFAULT CHARSET=latin1;\nCREATE TEMPORARY TABLE IF NOT EXISTS table_sottomez(\nid_vaso BIGINT(20),\ncod_tipo_vino VARCHAR(100),\nnum_prot_ido VARCHAR(255),\ndata_ido DATE,\nente_cert VARCHAR(255),\nqta_vaso DECIMAL(18,5)\n)ENGINE=INNODB DEFAULT CHARSET=latin1;\nCREATE TEMPORARY TABLE IF NOT EXISTS table_sottomezjoin(\nid_vaso BIGINT(20),\ncod_tipo_vino VARCHAR(100),\nnum_prot_ido VARCHAR(255),\ndata_ido DATE,\nente_cert VARCHAR(255),\nqta_vaso DECIMAL(18,5)\n)ENGINE=INNODB DEFAULT CHARSET=latin1;\nCREATE TEMPORARY TABLE IF NOT EXISTS table_asopra(\ncod_committente VARCHAR(15),\nazienda VARCHAR(15),\nsotto_az VARCHAR(15),\nid BIGINT(20),\ncodice_vaso VARCHAR(255),\ntipo_vaso VARCHAR(255),\ndescr_vaso VARCHAR(255),\ncapacita DECIMAL(18,5),\ncod_tipo_vino VARCHAR(100),\ngiacenza DECIMAL(18,5),\nnum_prot_ido VARCHAR(255),\ndata_ido VARCHAR(255),\nente_cert VARCHAR(255)\n)ENGINE=INNODB DEFAULT CHARSET=latin1;\n\nCREATE TEMPORARY TABLE IF NOT EXISTS table_bsopra(\ncancellato_reale VARCHAR(10),\nflg_gruppo INT(1),\ncodice_vaso VARCHAR(60),\ntotale_giacenza DECIMAL(18,5)\n)ENGINE=INNODB DEFAULT CHARSET=latin1;\nCREATE TEMPORARY TABLE IF NOT EXISTS table_final(\ncancellato_reale VARCHAR(10),\nflg_gruppo INT(1),\nresiduo DECIMAL(18,5),\ntotale_giacenza DECIMAL(18,5),\ncod_committente VARCHAR(15),\nazienda VARCHAR(15),\nsotto_az VARCHAR(15),\nid BIGINT(20),\ncodice_vaso VARCHAR(60),\ntipo_vaso VARCHAR(2),\ndescr_vaso VARCHAR(255),\ncapacita VARCHAR(255),\ncod_tipo_vino VARCHAR(100),\ngiacenza DECIMAL(18,5),\nnum_prot_ido VARCHAR(255),\ndata_ido VARCHAR(255),\nente_cert VARCHAR(255)\n)ENGINE=INNODB DEFAULT CHARSET=latin1; \nCREATE TEMPORARY TABLE IF NOT EXISTS table_sottomezjoinss(\ncodice_vaso VARCHAR(255),\ncod_tipo_vino VARCHAR(100),\nnum_prot_ido VARCHAR(255),\ndata_ido DATE,\nente_cert VARCHAR(255),\nqta_vaso DECIMAL(18,5)\n)ENGINE=INNODB DEFAULT CHARSET=latin1;\n\nCREATE INDEX index_name\nON table_sottomezjoinss (codice_vaso, cod_tipo_vino, num_prot_ido,data_ido,ente_cert);\nCREATE INDEX index_names\nON table_sottomezjoinss (codice_vaso);\nCREATE INDEX index_names\nON table_asopra (codice_vaso);\nCREATE INDEX index_name\nON table_asopra (codice_vaso, cod_tipo_vino, num_prot_ido,data_ido,ente_cert);\n\nINSERT INTO table_base(SELECT a.cancellato_reale,a.flg_gruppo,a.cod_committente,a.azienda,a.sotto_az,a.id,a.codice_vaso,a.tipo_vaso,a.descr_vaso,a.capacita,b.cod_tipo_vino,IF(ISNULL(SUM(b.qta_mov)),0,SUM(b.qta_mov)) AS giacenza ,c.num_prot_ido,c.data_ido,c.ente_cert\nFROM gen_vasi_vinari_ana AS a \nLEFT JOIN gen_vasi_vinari_mov AS b ON a.id=b.id_vaso  \nLEFT JOIN c_movimenti AS c ON  b.id_mov=c.id\nWHERE b.azienda='" + FXMLDocumentController.GLOBAL_AZIENDA + "' AND b.sotto_az='" + FXMLDocumentController.GLOBAL_SOTTOAZZ + "' AND b.icqrf='" + FXMLDocumentController.GLOBAL_ICQRF + "' AND b.cod_committente='" + FXMLDocumentController.GLOBAL_CODCOMM + "' AND a.flg_gruppo<>1 \nGROUP BY a.codice_vaso,c.cod_tipo_vino,c.num_prot_ido,c.data_ido,c.ente_cert\nORDER BY c.cod_tipo_vino);\nINSERT INTO table_sopraint(SELECT a.cancellato_reale,a.flg_gruppo,a.cod_committente,a.azienda,a.sotto_az,a.id,a.codice_vaso,a.tipo_vaso,\na.descr_vaso,a.capacita,IF(a.giacenza=0,'',a.cod_tipo_vino) AS cod_tipo_vino,a.giacenza,num_prot_ido,data_ido,ente_cert \nFROM table_base AS a\nGROUP BY codice_vaso,cod_tipo_vino,num_prot_ido,data_ido,ente_cert";
        if (having) {
            ret = ret + " HAVING a.giacenza>0 ";
        }
        ret = ret + ");\nINSERT INTO table_sopramezzo (SELECT a.cod_committente,a.azienda,a.sotto_az,a.id,a.codice_vaso,a.tipo_vaso,a.descr_vaso,a.capacita,\na.cod_tipo_vino,num_prot_ido,data_ido,ente_cert,a.giacenza \nFROM table_sopraint AS a );\nINSERT INTO table_sottomez(SELECT b.id_vaso,a.cod_tipo_vino,a.num_prot_ido,a.data_ido,a.ente_cert,SUM(b.qta_mov) AS qta_vaso \nFROM c_movimenti AS a LEFT JOIN gen_vasi_vinari_mov AS b ON a.id=b.id_mov \nWHERE a.num_prot_ido<>'' AND b.azienda='" + FXMLDocumentController.GLOBAL_AZIENDA + "' AND b.sotto_az='" + FXMLDocumentController.GLOBAL_SOTTOAZZ + "' AND b.icqrf='" + FXMLDocumentController.GLOBAL_ICQRF + "' AND b.cod_committente='" + FXMLDocumentController.GLOBAL_CODCOMM + "' \nGROUP BY b.id_vaso,a.cod_tipo_vino,a.num_prot_ido,a.data_ido,a.ente_cert);\nINSERT INTO table_sottomezjoin(\nSELECT b.id_vaso,a.cod_tipo_vino,a.num_prot_ido,a.data_ido,a.ente_cert,SUM(b.qta_mov) AS qta_vaso \nFROM c_movimenti AS a \nLEFT JOIN gen_vasi_vinari_mov AS b ON a.id=b.id_mov \nWHERE b.azienda='" + FXMLDocumentController.GLOBAL_AZIENDA + "' AND b.sotto_az='" + FXMLDocumentController.GLOBAL_SOTTOAZZ + "' AND b.icqrf='" + FXMLDocumentController.GLOBAL_ICQRF + "' AND b.cod_committente='" + FXMLDocumentController.GLOBAL_CODCOMM + "' GROUP BY b.id_vaso,a.cod_tipo_vino,a.num_prot_ido,a.data_ido,a.ente_cert);\nINSERT INTO table_sottomezjoinss(SELECT b.codice_vaso,a.cod_tipo_vino,a.num_prot_ido,a.data_ido,a.ente_cert,a.qta_vaso \nFROM table_sottomezjoin AS a \nLEFT JOIN gen_vasi_vinari_ana AS b ON a.id_vaso=b.id);\nINSERT INTO table_asopra(SELECT a.cod_committente,a.azienda,a.sotto_az,a.id,a.codice_vaso,a.tipo_vaso,a.descr_vaso,a.capacita,\na.cod_tipo_vino,a.giacenza, IFNULL(b.num_prot_ido,'') AS num_prot_ido,IFNULL(b.data_ido,'') AS data_ido,IFNULL(b.ente_cert,'') AS ente_cert \nFROM table_sopramezzo AS a \nLEFT JOIN table_sottomezjoinss AS b ON b.codice_vaso=a.codice_vaso AND b.cod_tipo_vino=a.cod_tipo_vino AND a.num_prot_ido=b.num_prot_ido AND a.data_ido=b.data_ido AND a.ente_cert=b.ente_cert);\nINSERT INTO table_bsopra( SELECT a.cancellato_reale,a.flg_gruppo,a.codice_vaso,IF(ISNULL(SUM(b.qta_mov)),0,SUM(b.qta_mov)) AS totale_giacenza \nFROM gen_vasi_vinari_ana AS a \nLEFT JOIN gen_vasi_vinari_mov AS b ON a.id=b.id_vaso  \nWHERE b.azienda='" + FXMLDocumentController.GLOBAL_AZIENDA + "' AND b.sotto_az='" + FXMLDocumentController.GLOBAL_SOTTOAZZ + "' AND b.icqrf='" + FXMLDocumentController.GLOBAL_ICQRF + "' AND b.cod_committente='" + FXMLDocumentController.GLOBAL_CODCOMM + "' AND a.flg_gruppo<>1 \nGROUP BY a.codice_vaso);\nINSERT INTO table_final(\nSELECT b.cancellato_reale,b.flg_gruppo,((a.capacita*100)-b.totale_giacenza)/100 AS residuo,b.totale_giacenza,a.cod_committente,a.azienda,a.sotto_az,a.id,a.codice_vaso,a.tipo_vaso,a.descr_vaso,a.capacita,a.cod_tipo_vino,a.giacenza, a.num_prot_ido,a.data_ido,a.ente_cert \nFROM table_asopra AS a \nLEFT JOIN table_bsopra AS b ON a.codice_vaso=b.codice_vaso);\n\n\n\nCREATE TEMPORARY TABLE IF NOT EXISTS table_intb(\ncancellato_reale VARCHAR(10),\nflg_gruppo INT(1),\ncod_committente VARCHAR(15),\nazienda VARCHAR(15),\nsotto_az VARCHAR(15),\nicqrf VARCHAR(15),\nid BIGINT(20),\ncodice_vaso VARCHAR(60),\ntipo_vaso VARCHAR(2),\ndescr_vaso VARCHAR(255),\ncapacita VARCHAR(255),\ncod_tipo_vino VARCHAR(100),\ngiacenza DECIMAL(18,5),\nnum_prot_ido VARCHAR(255),\ndata_ido DATE,\nente_cert VARCHAR(255)\n)ENGINE=INNODB DEFAULT CHARSET=latin1;\nCREATE TEMPORARY TABLE IF NOT EXISTS table_intbsopra(\ncancellato_reale VARCHAR(10),\nflg_gruppo INT(1),\ncod_committente VARCHAR(15),\nazienda VARCHAR(15),\nsotto_az VARCHAR(15),\nicqrf VARCHAR(15),\nid BIGINT(20),\ncodice_vaso VARCHAR(60),\ntipo_vaso VARCHAR(2),\ndescr_vaso VARCHAR(255),\ncapacita VARCHAR(255),\ncod_tipo_vino VARCHAR(100),\ngiacenza DECIMAL(18,5),\nnum_prot_ido VARCHAR(255),\ndata_ido DATE,\nente_cert VARCHAR(255)\n)ENGINE=INNODB DEFAULT CHARSET=latin1;\nCREATE TEMPORARY TABLE IF NOT EXISTS table_intbjoin(\nid_vaso BIGINT(20),\ncod_tipo_vino VARCHAR(100),\nnum_prot_ido VARCHAR(255),\ndata_ido DATE,\nente_cert VARCHAR(255),\nqta_vaso DECIMAL(18,5)\n)ENGINE=INNODB DEFAULT CHARSET=latin1;\nCREATE TEMPORARY TABLE IF NOT EXISTS table_intbjoins(\ncodice_vaso VARCHAR(255),\ncod_tipo_vino VARCHAR(100),\nnum_prot_ido VARCHAR(255),\ndata_ido DATE,\nente_cert VARCHAR(255),\nqta_vaso DECIMAL(18,5)\n)ENGINE=INNODB DEFAULT CHARSET=latin1;\nCREATE TEMPORARY TABLE IF NOT EXISTS table_bsotto(\ncod_committente VARCHAR(15),\nazienda VARCHAR(15),\nsotto_az VARCHAR(15),\nid BIGINT(20),\ncodice_vaso VARCHAR(255),\ntipo_vaso VARCHAR(255),\ndescr_vaso VARCHAR(255),\ncapacita DECIMAL(18,5),\ncod_tipo_vino VARCHAR(100),\ngiacenza DECIMAL(18,5),\nnum_prot_ido VARCHAR(255),\ndata_ido VARCHAR(255),\nente_cert VARCHAR(255)\n)ENGINE=INNODB DEFAULT CHARSET=latin1;\n\nCREATE TEMPORARY TABLE IF NOT EXISTS table_bsottojoin(\ncancellato_reale VARCHAR(10),\nflg_gruppo INT(1),\ncodice_vaso VARCHAR(60),\ntotale_giacenza DECIMAL(18,5)\n)ENGINE=INNODB DEFAULT CHARSET=latin1;\n\nCREATE INDEX index_name\nON table_intbjoins (codice_vaso, cod_tipo_vino, num_prot_ido,data_ido,ente_cert);\nCREATE INDEX index_names\nON table_intbjoins (codice_vaso);\nCREATE INDEX index_names\nON table_bsotto (codice_vaso);\nCREATE INDEX index_name\nON table_bsotto (codice_vaso, cod_tipo_vino, num_prot_ido,data_ido,ente_cert);\n\nINSERT INTO table_intb(SELECT a.cancellato_reale,a.flg_gruppo,a.cod_committente,a.azienda,a.sotto_az,a.icqrf,a.id,a.codice_vaso,a.tipo_vaso,a.descr_vaso,a.capacita,b.cod_tipo_vino,IF(ISNULL(SUM(b.qta_mov)),0,SUM(b.qta_mov)) AS giacenza ,num_prot_ido,data_ido,ente_cert\n FROM gen_vasi_vinari_ana AS a \n LEFT JOIN gen_vasi_vinari_mov AS b ON a.id=b.id_vaso  \n LEFT JOIN c_movimenti AS c ON b.id_mov=c.id \nWHERE b.azienda='" + FXMLDocumentController.GLOBAL_AZIENDA + "' AND b.sotto_az='" + FXMLDocumentController.GLOBAL_SOTTOAZZ + "' AND b.icqrf='" + FXMLDocumentController.GLOBAL_ICQRF + "' AND b.cod_committente='" + FXMLDocumentController.GLOBAL_CODCOMM + "' AND a.flg_gruppo=1 \n GROUP BY a.codice_vaso,cod_tipo_vino,num_prot_ido,data_ido,ente_cert);\nINSERT INTO table_intbsopra(SELECT a.cancellato_reale,a.flg_gruppo,a.cod_committente,a.azienda,a.sotto_az,a.icqrf,a.id,a.codice_vaso,a.tipo_vaso,a.descr_vaso,a.capacita,a.cod_tipo_vino,a.giacenza AS giacenza ,num_prot_ido,data_ido,ente_cert\n FROM  table_intb AS a ";
        if (having) {
            ret = ret + "HAVING a.giacenza>0";
        }
        ret = ret + ");\n INSERT INTO table_intbjoin(SELECT b.id_vaso,a.cod_tipo_vino,a.num_prot_ido,a.data_ido,a.ente_cert,SUM(b.qta_mov) AS qta_vaso FROM c_movimenti AS a LEFT JOIN gen_vasi_vinari_mov AS b ON a.id=b.id_mov WHERE a.num_prot_ido<>'' AND b.azienda='" + FXMLDocumentController.GLOBAL_AZIENDA + "' AND b.sotto_az='" + FXMLDocumentController.GLOBAL_SOTTOAZZ + "' AND b.icqrf='" + FXMLDocumentController.GLOBAL_ICQRF + "' AND b.cod_committente='" + FXMLDocumentController.GLOBAL_CODCOMM + "'  \nGROUP BY b.id_vaso,a.cod_tipo_vino,a.num_prot_ido,a.data_ido,a.ente_cert );\nINSERT INTO table_intbjoins(SELECT b.codice_vaso,a.cod_tipo_vino,a.num_prot_ido,a.data_ido,a.ente_cert,a.qta_vaso \n FROM table_intbjoin AS a \n LEFT JOIN gen_vasi_vinari_ana AS b ON a.id_vaso=b.id WHERE b.flg_gruppo=1);\nINSERT INTO table_bsotto(SELECT a.cod_committente,a.azienda,a.sotto_az,a.id,a.codice_vaso,a.tipo_vaso,a.descr_vaso,a.capacita,\na.cod_tipo_vino,a.giacenza, IFNULL(b.num_prot_ido,'') AS num_prot_ido,IFNULL(b.data_ido,'') AS data_ido,IFNULL(b.ente_cert,'') AS ente_cert  \n FROM table_intbsopra AS a \n LEFT JOIN table_intbjoins AS b ON b.codice_vaso=a.codice_vaso AND b.cod_tipo_vino=a.cod_tipo_vino AND a.num_prot_ido=b.num_prot_ido AND a.data_ido=b.data_ido AND a.ente_cert=b.ente_cert);\n INSERT INTO table_bsottojoin(SELECT a.cancellato_reale,a.flg_gruppo,a.codice_vaso,IF(ISNULL(SUM(b.qta_mov)),0,SUM(b.qta_mov)) AS totale_giacenza \n FROM gen_vasi_vinari_ana AS a \n LEFT JOIN gen_vasi_vinari_mov AS b ON a.id=b.id_vaso  \nWHERE b.azienda='" + FXMLDocumentController.GLOBAL_AZIENDA + "' AND b.sotto_az='" + FXMLDocumentController.GLOBAL_SOTTOAZZ + "' AND b.icqrf='" + FXMLDocumentController.GLOBAL_ICQRF + "' AND b.cod_committente='" + FXMLDocumentController.GLOBAL_CODCOMM + "' AND a.flg_gruppo=1 \nGROUP BY a.codice_vaso);\nINSERT INTO table_final(\nSELECT b.cancellato_reale,b.flg_gruppo,((a.capacita*100)-totale_giacenza)/100 AS residuo,b.totale_giacenza,a.cod_committente,a.azienda,a.sotto_az,a.id,a.codice_vaso,a.tipo_vaso,a.descr_vaso,a.capacita,a.cod_tipo_vino,a.giacenza, a.num_prot_ido,a.data_ido,a.ente_cert \nFROM table_bsotto AS a\nLEFT JOIN table_bsottojoin AS b ON a.codice_vaso=b.codice_vaso);\n\nSELECT  a.cancellato_reale,a.flg_gruppo,a.residuo,a.totale_giacenza,a.cod_committente,a.azienda,a.sotto_az,a.id,a.codice_vaso,a.tipo_vaso,\na.descr_vaso,a.capacita,a.cod_tipo_vino,a.giacenza, a.num_prot_ido,a.data_ido,a.ente_cert \nFROM table_final AS a \n";
        if (!where.equals("")) {
            ret = ret + where;
        }
        ret = ret + " HAVING codice_vaso<>'@VASOWBS@' AND (cancellato_reale='' OR cancellato_reale='false' OR ISNULL(cancellato_reale)) ";
        return ret;
    }

    private String selectBuilder2FUNZIONANTE(String where, boolean having) {
        String ret = "SELECT  a.cancellato_reale,a.flg_gruppo,a.residuo,a.totale_giacenza,a.cod_committente,a.azienda,a.sotto_az,a.id,a.codice_vaso,a.tipo_vaso,a.descr_vaso,a.capacita,a.cod_tipo_vino,a.giacenza, a.num_prot_ido,a.data_ido,a.ente_cert \nFROM (\n\nSELECT b.cancellato_reale,b.flg_gruppo,((a.capacita*100)-b.totale_giacenza)/100 AS residuo,b.totale_giacenza,a.cod_committente,a.azienda,a.sotto_az,a.id,a.codice_vaso,a.tipo_vaso,a.descr_vaso,a.capacita,a.cod_tipo_vino,a.giacenza, a.num_prot_ido,a.data_ido,a.ente_cert \nFROM (\nSELECT a.cod_committente,a.azienda,a.sotto_az,a.id,a.codice_vaso,a.tipo_vaso,a.descr_vaso,a.capacita,a.cod_tipo_vino,a.giacenza, IFNULL(b.num_prot_ido,'') AS num_prot_ido,IFNULL(b.data_ido,'') AS data_ido,IFNULL(b.ente_cert,'') AS ente_cert \nFROM (SELECT a.cod_committente,a.azienda,a.sotto_az,a.id,a.codice_vaso,a.tipo_vaso,a.descr_vaso,a.capacita,a.cod_tipo_vino,num_prot_ido,data_ido,ente_cert,a.giacenza \nFROM (SELECT a.cancellato_reale,a.flg_gruppo,a.cod_committente,a.azienda,a.sotto_az,a.id,a.codice_vaso,a.tipo_vaso,a.descr_vaso,a.capacita,IF(a.giacenza=0,'',a.cod_tipo_vino) AS cod_tipo_vino,a.giacenza,num_prot_ido,data_ido,ente_cert \nFROM (SELECT a.cancellato_reale,a.flg_gruppo,a.cod_committente,a.azienda,a.sotto_az,a.id,a.codice_vaso,a.tipo_vaso,a.descr_vaso,a.capacita,b.cod_tipo_vino,IF(ISNULL(SUM(b.qta_mov)),0,SUM(b.qta_mov)) AS giacenza ,c.num_prot_ido,c.data_ido,c.ente_cert\nFROM gen_vasi_vinari_ana AS a \nLEFT JOIN gen_vasi_vinari_mov AS b ON a.id=b.id_vaso  \nLEFT JOIN c_movimenti AS c ON  b.id_mov=c.id\nWHERE b.azienda='" + FXMLDocumentController.GLOBAL_AZIENDA + "' AND b.sotto_az='" + FXMLDocumentController.GLOBAL_SOTTOAZZ + "' AND b.icqrf='" + FXMLDocumentController.GLOBAL_ICQRF + "' AND b.cod_committente='" + FXMLDocumentController.GLOBAL_CODCOMM + "' AND a.flg_gruppo<>1 \nGROUP BY a.codice_vaso,c.cod_tipo_vino,c.num_prot_ido,c.data_ido,c.ente_cert\nORDER BY c.cod_tipo_vino) AS a\nGROUP BY codice_vaso,cod_tipo_vino,num_prot_ido,data_ido,ente_cert\n";
        if (having) {
            ret = ret + "HAVING a.giacenza>0";
        }
        ret = ret + ") AS a \n) AS a \nLEFT JOIN (SELECT b.codice_vaso,a.cod_tipo_vino,a.num_prot_ido,a.data_ido,a.ente_cert,a.qta_vaso FROM (SELECT b.id_vaso,a.cod_tipo_vino,a.num_prot_ido,a.data_ido,a.ente_cert,SUM(b.qta_mov) AS qta_vaso FROM c_movimenti AS a LEFT JOIN gen_vasi_vinari_mov AS b ON a.id=b.id_mov WHERE a.num_prot_ido<>'' AND b.azienda='" + FXMLDocumentController.GLOBAL_AZIENDA + "' AND b.sotto_az='" + FXMLDocumentController.GLOBAL_SOTTOAZZ + "' AND b.icqrf='" + FXMLDocumentController.GLOBAL_ICQRF + "' AND b.cod_committente='" + FXMLDocumentController.GLOBAL_CODCOMM + "' \nGROUP BY b.id_vaso,a.cod_tipo_vino,a.num_prot_ido,a.data_ido,a.ente_cert ) AS a LEFT JOIN gen_vasi_vinari_ana AS b ON a.id_vaso=b.id) AS b ON b.codice_vaso=a.codice_vaso AND b.cod_tipo_vino=a.cod_tipo_vino AND a.num_prot_ido=b.num_prot_ido AND a.data_ido=b.data_ido AND a.ente_cert=b.ente_cert\n) AS a \nLEFT JOIN ( SELECT a.cancellato_reale,a.flg_gruppo,a.codice_vaso,if(ISNULL(SUM(b.qta_mov)),0,SUM(b.qta_mov)) AS totale_giacenza FROM gen_vasi_vinari_ana AS a \nLEFT JOIN gen_vasi_vinari_mov AS b ON a.id=b.id_vaso  WHERE b.azienda='" + FXMLDocumentController.GLOBAL_AZIENDA + "' AND b.sotto_az='" + FXMLDocumentController.GLOBAL_SOTTOAZZ + "' AND b.icqrf='" + FXMLDocumentController.GLOBAL_ICQRF + "' AND b.cod_committente='" + FXMLDocumentController.GLOBAL_CODCOMM + "' AND a.flg_gruppo<>1 \nGROUP BY a.codice_vaso ) AS b ON a.codice_vaso=b.codice_vaso    \n\nUNION         \n\n SELECT b.cancellato_reale,b.flg_gruppo,((a.capacita*100)-totale_giacenza)/100 AS residuo,b.totale_giacenza,a.cod_committente,a.azienda,a.sotto_az,a.id,a.codice_vaso,a.tipo_vaso,a.descr_vaso,a.capacita,a.cod_tipo_vino,a.giacenza, a.num_prot_ido,a.data_ido,a.ente_cert \n FROM( \n \n SELECT a.cod_committente,a.azienda,a.sotto_az,a.id,a.codice_vaso,a.tipo_vaso,a.descr_vaso,a.capacita,a.cod_tipo_vino,a.giacenza, IFNULL(b.num_prot_ido,'') AS num_prot_ido,IFNULL(b.data_ido,'') AS data_ido,IFNULL(b.ente_cert,'') AS ente_cert  \n FROM (SELECT a.cancellato_reale,a.flg_gruppo,a.cod_committente,a.azienda,a.sotto_az,a.icqrf,a.id,a.codice_vaso,a.tipo_vaso,a.descr_vaso,a.capacita,a.cod_tipo_vino,a.giacenza AS giacenza ,num_prot_ido,data_ido,ente_cert\n FROM  (SELECT a.cancellato_reale,a.flg_gruppo,a.cod_committente,a.azienda,a.sotto_az,a.icqrf,a.id,a.codice_vaso,a.tipo_vaso,a.descr_vaso,a.capacita,b.cod_tipo_vino,if(ISNULL(SUM(b.qta_mov)),0,SUM(b.qta_mov)) AS giacenza ,num_prot_ido,data_ido,ente_cert\n FROM gen_vasi_vinari_ana AS a \n LEFT JOIN gen_vasi_vinari_mov AS b ON a.id=b.id_vaso  \n LEFT JOIN c_movimenti AS c ON b.id_mov=c.id \nWHERE b.azienda='" + FXMLDocumentController.GLOBAL_AZIENDA + "' AND b.sotto_az='" + FXMLDocumentController.GLOBAL_SOTTOAZZ + "' AND b.icqrf='" + FXMLDocumentController.GLOBAL_ICQRF + "' AND b.cod_committente='" + FXMLDocumentController.GLOBAL_CODCOMM + "' AND a.flg_gruppo=1 \n GROUP BY a.codice_vaso,cod_tipo_vino,num_prot_ido,data_ido,ente_cert\n ) AS a\n";
        if (having) {
            ret = ret + "HAVING a.giacenza>0";
        }
        ret = ret + " \n ) AS a \n LEFT JOIN (SELECT b.codice_vaso,a.cod_tipo_vino,a.num_prot_ido,a.data_ido,a.ente_cert,a.qta_vaso \n FROM (SELECT b.id_vaso,a.cod_tipo_vino,a.num_prot_ido,a.data_ido,a.ente_cert,SUM(b.qta_mov) AS qta_vaso FROM c_movimenti AS a LEFT JOIN gen_vasi_vinari_mov AS b ON a.id=b.id_mov WHERE a.num_prot_ido<>'' AND b.azienda='" + FXMLDocumentController.GLOBAL_AZIENDA + "' AND b.sotto_az='" + FXMLDocumentController.GLOBAL_SOTTOAZZ + "' AND b.icqrf='" + FXMLDocumentController.GLOBAL_ICQRF + "' AND b.cod_committente='" + FXMLDocumentController.GLOBAL_CODCOMM + "'  \nGROUP BY b.id_vaso,a.cod_tipo_vino,a.num_prot_ido,a.data_ido,a.ente_cert ) AS a \n LEFT JOIN gen_vasi_vinari_ana AS b ON a.id_vaso=b.id WHERE b.flg_gruppo=1) AS b ON b.codice_vaso=a.codice_vaso AND b.cod_tipo_vino=a.cod_tipo_vino AND a.num_prot_ido=b.num_prot_ido AND a.data_ido=b.data_ido AND a.ente_cert=b.ente_cert\n ) AS a\n \n  LEFT JOIN ( SELECT a.cancellato_reale,a.flg_gruppo,a.codice_vaso,if(ISNULL(SUM(b.qta_mov)),0,SUM(b.qta_mov)) AS totale_giacenza FROM gen_vasi_vinari_ana AS a LEFT JOIN gen_vasi_vinari_mov AS b ON a.id=b.id_vaso  WHERE b.azienda='" + FXMLDocumentController.GLOBAL_AZIENDA + "' AND b.sotto_az='" + FXMLDocumentController.GLOBAL_SOTTOAZZ + "' AND b.icqrf='" + FXMLDocumentController.GLOBAL_ICQRF + "' AND b.cod_committente='" + FXMLDocumentController.GLOBAL_CODCOMM + "' AND a.flg_gruppo=1 \nGROUP BY a.codice_vaso ) AS b ON a.codice_vaso=b.codice_vaso ) AS a  \n\n";
        if (!where.equals("")) {
            ret = ret + where;
        }
        ret = ret + " HAVING codice_vaso<>'@VASOWBS@' AND (cancellato_reale='' OR cancellato_reale='false' OR ISNULL(cancellato_reale)) ";
        return ret;
    }

    private String selectBuilder(String where, boolean key_committente, String key_alias) {
        String str = "(SELECT  a.cancellato_reale,a.flg_gruppo,a.residuo,a.totale_giacenza,a.cod_committente,a.azienda,a.sotto_az,a.id,a.codice_vaso,a.tipo_vaso,a.descr_vaso,a.capacita,a.cod_tipo_vino,a.giacenza, a.num_prot_ido,a.data_ido,a.ente_cert FROM (SELECT b.cancellato_reale,b.flg_gruppo,((a.capacita*100)-b.totale_giacenza)/100 AS residuo,b.totale_giacenza,a.cod_committente,a.azienda,a.sotto_az,a.id,a.codice_vaso,a.tipo_vaso,a.descr_vaso,a.capacita,a.cod_tipo_vino,a.giacenza, a.num_prot_ido,a.data_ido,a.ente_cert FROM (SELECT a.cod_committente,a.azienda,a.sotto_az,a.id,a.codice_vaso,a.tipo_vaso,a.descr_vaso,a.capacita,a.cod_tipo_vino,a.giacenza, IFNULL(b.num_prot_ido,'') AS num_prot_ido,IFNULL(b.data_ido,'') AS data_ido,IFNULL(b.ente_cert,'') AS ente_cert FROM (SELECT a.cod_committente,a.azienda,a.sotto_az,a.id,a.codice_vaso,a.tipo_vaso,a.descr_vaso,a.capacita,b.cod_tipo_vino,a.giacenza FROM (SELECT a.cancellato_reale,a.flg_gruppo,a.cod_committente,a.azienda,a.sotto_az,a.id,a.codice_vaso,a.tipo_vaso,a.descr_vaso,a.capacita,IF(a.giacenza=0,'',a.cod_tipo_vino) AS cod_tipo_vino,a.giacenza FROM (SELECT a.cancellato_reale,a.flg_gruppo,a.cod_committente,a.azienda,a.sotto_az,a.id,a.codice_vaso,a.tipo_vaso,a.descr_vaso,a.capacita,b.cod_tipo_vino,IF(ISNULL(SUM(b.qta_mov)),0,SUM(b.qta_mov)) AS giacenza FROM gen_vasi_vinari_ana AS a LEFT JOIN gen_vasi_vinari_mov AS b ON a.id=b.id_vaso  ";
        str = key_alias.equals("a") ? str + "WHERE a.azienda='" + FXMLDocumentController.GLOBAL_AZIENDA + "' AND a.sotto_az='" + FXMLDocumentController.GLOBAL_SOTTOAZZ + "' AND a.icqrf='" + FXMLDocumentController.GLOBAL_ICQRF + "' " : str + "WHERE b.azienda='" + FXMLDocumentController.GLOBAL_AZIENDA + "' AND b.sotto_az='" + FXMLDocumentController.GLOBAL_SOTTOAZZ + "' AND b.icqrf='" + FXMLDocumentController.GLOBAL_ICQRF + "' ";
        if (key_committente) {
            str = key_alias.equals("a") ? str + "AND a.cod_committente='" + FXMLDocumentController.GLOBAL_CODCOMM + "' " : str + "AND b.cod_committente='" + FXMLDocumentController.GLOBAL_CODCOMM + "' ";
        }
        str = str + "GROUP BY a.codice_vaso) AS a) AS a LEFT JOIN (SELECT a.cancellato_reale,a.flg_gruppo,a.cod_committente,a.azienda,a.sotto_az,a.icqrf,a.codice_vaso,a.cod_tipo_vino FROM (SELECT a.cancellato_reale,a.flg_gruppo,a.cod_committente,a.azienda,a.sotto_az,a.icqrf,a.id,a.codice_vaso,a.tipo_vaso,a.descr_vaso,a.capacita,a.cod_tipo_vino,MAX(a.giacenza) AS giacenza FROM (SELECT a.cancellato_reale,a.flg_gruppo,a.cod_committente,a.azienda,a.sotto_az,a.icqrf,a.id,a.codice_vaso,a.tipo_vaso,a.descr_vaso,a.capacita,a.cod_tipo_vino,a.giacenza AS giacenza FROM (SELECT a.cancellato_reale,a.flg_gruppo,a.cod_committente,a.azienda,a.sotto_az,a.icqrf,a.id,a.codice_vaso,a.tipo_vaso,a.descr_vaso,a.capacita,b.cod_tipo_vino,if(ISNULL(SUM(b.qta_mov)),0,SUM(b.qta_mov)) AS giacenza FROM gen_vasi_vinari_ana AS a LEFT JOIN gen_vasi_vinari_mov AS b ON a.id=b.id_vaso  ";
        str = key_alias.equals("a") ? str + "WHERE a.azienda='" + FXMLDocumentController.GLOBAL_AZIENDA + "' AND a.sotto_az='" + FXMLDocumentController.GLOBAL_SOTTOAZZ + "' AND a.icqrf='" + FXMLDocumentController.GLOBAL_ICQRF + "' " : str + "WHERE b.azienda='" + FXMLDocumentController.GLOBAL_AZIENDA + "' AND b.sotto_az='" + FXMLDocumentController.GLOBAL_SOTTOAZZ + "' AND b.icqrf='" + FXMLDocumentController.GLOBAL_ICQRF + "' ";
        if (key_committente) {
            str = key_alias.equals("a") ? str + "AND a.cod_committente='" + FXMLDocumentController.GLOBAL_CODCOMM + "' " : str + "AND b.cod_committente='" + FXMLDocumentController.GLOBAL_CODCOMM + "' ";
        }
        str = str + "GROUP BY a.codice_vaso,cod_tipo_vino HAVING giacenza>0 ) AS a) AS a GROUP BY a.codice_vaso) AS a ) AS b ON a.codice_vaso=b.codice_vaso WHERE a.flg_gruppo<>1 ) AS a LEFT JOIN (SELECT b.codice_vaso,a.cod_tipo_vino,a.num_prot_ido,a.data_ido,a.ente_cert,a.qta_vaso FROM (SELECT b.id_vaso,a.cod_tipo_vino,a.num_prot_ido,a.data_ido,a.ente_cert,SUM(b.qta_mov) AS qta_vaso FROM c_movimenti AS a LEFT JOIN gen_vasi_vinari_mov AS b ON a.id=b.id_mov WHERE a.num_prot_ido<>'' ";
        str = key_alias.equals("a") ? str + "AND a.azienda='" + FXMLDocumentController.GLOBAL_AZIENDA + "' AND a.sotto_az='" + FXMLDocumentController.GLOBAL_SOTTOAZZ + "' AND a.icqrf='" + FXMLDocumentController.GLOBAL_ICQRF + "' " : str + "AND b.azienda='" + FXMLDocumentController.GLOBAL_AZIENDA + "' AND b.sotto_az='" + FXMLDocumentController.GLOBAL_SOTTOAZZ + "' AND b.icqrf='" + FXMLDocumentController.GLOBAL_ICQRF + "' ";
        if (key_committente) {
            str = key_alias.equals("a") ? str + "AND a.cod_committente='" + FXMLDocumentController.GLOBAL_CODCOMM + "' " : str + "AND b.cod_committente='" + FXMLDocumentController.GLOBAL_CODCOMM + "' ";
        }
        str = str + "GROUP BY b.id_vaso,a.cod_tipo_vino,a.num_prot_ido,a.data_ido,a.ente_cert ) AS a LEFT JOIN gen_vasi_vinari_ana AS b ON a.id_vaso=b.id) AS b ON b.codice_vaso=a.codice_vaso AND b.cod_tipo_vino=a.cod_tipo_vino) AS a LEFT JOIN ( SELECT a.cancellato_reale,a.flg_gruppo,a.codice_vaso,if(ISNULL(SUM(b.qta_mov)),0,SUM(b.qta_mov)) AS totale_giacenza FROM gen_vasi_vinari_ana AS a LEFT JOIN gen_vasi_vinari_mov AS b ON a.id=b.id_vaso  WHERE a.flg_gruppo<>'1' ";
        str = key_alias.equals("a") ? str + "AND a.azienda='" + FXMLDocumentController.GLOBAL_AZIENDA + "' AND a.sotto_az='" + FXMLDocumentController.GLOBAL_SOTTOAZZ + "' AND a.icqrf='" + FXMLDocumentController.GLOBAL_ICQRF + "' " : str + "AND b.azienda='" + FXMLDocumentController.GLOBAL_AZIENDA + "' AND b.sotto_az='" + FXMLDocumentController.GLOBAL_SOTTOAZZ + "' AND b.icqrf='" + FXMLDocumentController.GLOBAL_ICQRF + "' ";
        if (key_committente) {
            str = key_alias.equals("a") ? str + "AND a.cod_committente='" + FXMLDocumentController.GLOBAL_CODCOMM + "' " : str + "AND b.cod_committente='" + FXMLDocumentController.GLOBAL_CODCOMM + "' ";
        }
        str = str + "GROUP BY a.codice_vaso ) AS b ON a.codice_vaso=b.codice_vaso    UNION          SELECT b.cancellato_reale,b.flg_gruppo,((a.capacita*100)-totale_giacenza)/100 AS residuo,b.totale_giacenza,a.cod_committente,a.azienda,a.sotto_az,a.id,a.codice_vaso,a.tipo_vaso,a.descr_vaso,a.capacita,a.cod_tipo_vino,a.giacenza, a.num_prot_ido,a.data_ido,a.ente_cert  FROM( SELECT a.cod_committente,a.azienda,a.sotto_az,a.id,a.codice_vaso,a.tipo_vaso,a.descr_vaso,a.capacita,a.cod_tipo_vino,a.giacenza, IFNULL(b.num_prot_ido,'') AS num_prot_ido,IFNULL(b.data_ido,'') AS data_ido,IFNULL(b.ente_cert,'') AS ente_cert  FROM (SELECT a.cancellato_reale,a.flg_gruppo, a.cod_committente,a.azienda,a.sotto_az,a.id,a.codice_vaso,a.tipo_vaso,a.descr_vaso,a.capacita,a.cod_tipo_vino,a.giacenza  FROM  (SELECT a.cancellato_reale,a.flg_gruppo,a.cod_committente,a.azienda,a.sotto_az,a.icqrf,a.codice_vaso,a.cod_tipo_vino,a.giacenza,a.capacita,a.id,a.tipo_vaso,a.descr_vaso  FROM  (SELECT a.cancellato_reale,a.flg_gruppo,a.cod_committente,a.azienda,a.sotto_az,a.icqrf,a.id,a.codice_vaso,a.tipo_vaso,a.descr_vaso,a.capacita,a.cod_tipo_vino,MAX(a.giacenza) AS giacenza FROM  (SELECT a.cancellato_reale,a.flg_gruppo,a.cod_committente,a.azienda,a.sotto_az,a.icqrf,a.id,a.codice_vaso,a.tipo_vaso,a.descr_vaso,a.capacita,a.cod_tipo_vino,a.giacenza AS giacenza FROM  (SELECT a.cancellato_reale,a.flg_gruppo,a.cod_committente,a.azienda,a.sotto_az,a.icqrf,a.id,a.codice_vaso,a.tipo_vaso,a.descr_vaso,a.capacita,b.cod_tipo_vino,if(ISNULL(SUM(b.qta_mov)),0,SUM(b.qta_mov)) AS giacenza FROM gen_vasi_vinari_ana AS a LEFT JOIN gen_vasi_vinari_mov AS b ON a.id=b.id_vaso  ";
        str = key_alias.equals("a") ? str + "WHERE a.azienda='" + FXMLDocumentController.GLOBAL_AZIENDA + "' AND a.sotto_az='" + FXMLDocumentController.GLOBAL_SOTTOAZZ + "' AND a.icqrf='" + FXMLDocumentController.GLOBAL_ICQRF + "' " : str + "WHERE b.azienda='" + FXMLDocumentController.GLOBAL_AZIENDA + "' AND b.sotto_az='" + FXMLDocumentController.GLOBAL_SOTTOAZZ + "' AND b.icqrf='" + FXMLDocumentController.GLOBAL_ICQRF + "' ";
        if (key_committente) {
            str = key_alias.equals("a") ? str + "AND a.cod_committente='" + FXMLDocumentController.GLOBAL_CODCOMM + "' " : str + "AND b.cod_committente='" + FXMLDocumentController.GLOBAL_CODCOMM + "' ";
        }
        str = str + "GROUP BY a.codice_vaso,cod_tipo_vino) AS a) AS a GROUP BY a.codice_vaso,a.cod_tipo_vino) AS a ) AS a  WHERE a.flg_gruppo=1) AS a LEFT JOIN (SELECT b.codice_vaso,a.cod_tipo_vino,a.num_prot_ido,a.data_ido,a.ente_cert,a.qta_vaso FROM (SELECT b.id_vaso,a.cod_tipo_vino,a.num_prot_ido,a.data_ido,a.ente_cert,SUM(b.qta_mov) AS qta_vaso FROM c_movimenti AS a LEFT JOIN gen_vasi_vinari_mov AS b ON a.id=b.id_mov WHERE a.num_prot_ido<>'' ";
        str = key_alias.equals("a") ? str + "AND a.azienda='" + FXMLDocumentController.GLOBAL_AZIENDA + "' AND a.sotto_az='" + FXMLDocumentController.GLOBAL_SOTTOAZZ + "' AND a.icqrf='" + FXMLDocumentController.GLOBAL_ICQRF + "' " : str + "AND b.azienda='" + FXMLDocumentController.GLOBAL_AZIENDA + "' AND b.sotto_az='" + FXMLDocumentController.GLOBAL_SOTTOAZZ + "' AND b.icqrf='" + FXMLDocumentController.GLOBAL_ICQRF + "' ";
        if (key_committente) {
            str = key_alias.equals("a") ? str + "AND a.cod_committente='" + FXMLDocumentController.GLOBAL_CODCOMM + "' " : str + "AND b.cod_committente='" + FXMLDocumentController.GLOBAL_CODCOMM + "' ";
        }
        str = str + "GROUP BY b.id_vaso,a.cod_tipo_vino,a.num_prot_ido,a.data_ido,a.ente_cert ) AS a LEFT JOIN gen_vasi_vinari_ana AS b ON a.id_vaso=b.id WHERE b.flg_gruppo=1) AS b ON b.codice_vaso=a.codice_vaso AND b.cod_tipo_vino=a.cod_tipo_vino) AS a LEFT JOIN ( SELECT a.cancellato_reale,a.flg_gruppo,a.codice_vaso,if(ISNULL(SUM(b.qta_mov)),0,SUM(b.qta_mov)) AS totale_giacenza FROM gen_vasi_vinari_ana AS a LEFT JOIN gen_vasi_vinari_mov AS b ON a.id=b.id_vaso  WHERE a.flg_gruppo='1' ";
        str = key_alias.equals("a") ? str + "AND a.azienda='" + FXMLDocumentController.GLOBAL_AZIENDA + "' AND a.sotto_az='" + FXMLDocumentController.GLOBAL_SOTTOAZZ + "' AND a.icqrf='" + FXMLDocumentController.GLOBAL_ICQRF + "' " : str + "AND b.azienda='" + FXMLDocumentController.GLOBAL_AZIENDA + "' AND b.sotto_az='" + FXMLDocumentController.GLOBAL_SOTTOAZZ + "' AND b.icqrf='" + FXMLDocumentController.GLOBAL_ICQRF + "' ";
        if (key_committente) {
            str = key_alias.equals("a") ? str + "AND a.cod_committente='" + FXMLDocumentController.GLOBAL_CODCOMM + "' " : str + "AND b.cod_committente='" + FXMLDocumentController.GLOBAL_CODCOMM + "' ";
        }
        str = str + "GROUP BY a.codice_vaso ) AS b ON a.codice_vaso=b.codice_vaso ) AS a ";
        if (!where.equals("")) {
            str = str + where;
        }
        str = str + " HAVING codice_vaso<>'@VASOWBS@' AND (cancellato_reale='' OR cancellato_reale='false' OR ISNULL(cancellato_reale)) ) ";
        return str;
    }

    public JSONArray giacenzaVinoMX(String codiceRicerca, String where, String wherelitri) throws JSONException {
        JSONArray ret = null;
        ArrayList<String> strSQL = new ArrayList<String>();
        ArrayList<String> tipoSQL = new ArrayList<String>();
        ArrayList<Boolean> lastID = new ArrayList<Boolean>();
        strSQL = new ArrayList();
        tipoSQL = new ArrayList();
        lastID = new ArrayList();
        lastID.add(false);
        String str = "SELECT IFNULL(a.cod_prod_mx,'') AS cod_prod_mx,a.sian_classificazione,a.cod_committente,a.id,a.codice,a.sian_cat_prodotto,a.sian_cod_stato_fisico,a.azienda, a.sotto_az,a.icqrf,a.sian_volume_nominale, a.sian_annata,a.data_oper,a.descrizione,a.pezzi,a.sian_atto_certificato,a.litri FROM (SELECT a.cod_prod_mx,a.sian_classificazione,a.cod_committente,a.codice,a.sian_cat_prodotto,a.id,a.sian_cod_stato_fisico,a.azienda,a.sotto_az,a.icqrf,a.sian_volume_nominale, a.sian_annata,a.data_oper,a.descrizione,a.pezzi,a.sian_atto_certificato,COALESCE(a.litri,0) AS litri FROM (SELECT a.cod_prod_mx,a.sian_classificazione,x.cod_committente,x.codice,x.sian_cat_prodotto,a.id,x.sian_cod_stato_fisico,x.azienda,x.sotto_az,x.icqrf,x.sian_volume_nominale, x.sian_annata,a.data_oper,x.descrizione,a.pezzi,x.sian_atto_certificato,a.litri FROM gen_tipo_vino_ana AS x LEFT JOIN (SELECT IFNULL(a.cod_prod_mx,'') AS cod_prod_mx,a.sian_classificazione,a.cod_committente,a.sian_cat_prodotto,a.id,a.sian_cod_stato_fisico,a.azienda,a.sotto_az,a.icqrf,a.sian_volume_nominale, a.sian_annata,a.data_oper,a.codice,a.descrizione,a.pezzi,a.sian_atto_certificato,a.litri FROM (SELECT b.cod_prod_mx,c.sian_classificazione,a.cod_committente,c.sian_cat_prodotto,b.id,c.sian_cod_stato_fisico,a.azienda,a.sotto_az,a.icqrf, c.sian_volume_nominale,c.sian_annata,a.data_oper,c.codice,c.descrizione,SUM(b.litri) AS litri,SUM(b.confez) AS pezzi, c.sian_atto_certificato FROM c_operazioni AS a LEFT JOIN c_movimenti AS b ON a.id=b.id_oper LEFT JOIN gen_tipo_vino_ana AS c ON b.cod_tipo_vino=c.codice  AND b.azienda=c.azienda AND b.sotto_az=c.sotto_az AND b.icqrf=c.icqrf AND b.cod_committente=c.cod_committente WHERE a.azienda='" + FXMLDocumentController.GLOBAL_AZIENDA + "' AND a.sotto_az='" + FXMLDocumentController.GLOBAL_SOTTOAZZ + "' AND a.icqrf='" + FXMLDocumentController.GLOBAL_ICQRF + "' AND a.cod_committente='" + FXMLDocumentController.GLOBAL_CODCOMM + "' GROUP BY b.cod_tipo_vino,b.azienda,b.sotto_az,b.icqrf,b.cod_committente,b.cod_prod_mx) AS a ORDER BY a.codice) AS a ON x.codice=a.codice AND x.azienda=a.azienda AND  x.sotto_az=a.sotto_az AND x.icqrf=a.icqrf AND x.cod_committente=a.cod_committente) AS a ";
        if (!wherelitri.equals("")) {
            str = str + "HAVING COALESCE(litri,0)" + wherelitri + " ";
        }
        str = str + ") AS a WHERE (a.descrizione LIKE '%" + codiceRicerca.replace("'", "\\'") + "%' OR a.codice LIKE '%" + codiceRicerca.replace("'", "\\'") + "%') AND a.azienda='" + FXMLDocumentController.GLOBAL_AZIENDA + "' AND a.sotto_az='" + FXMLDocumentController.GLOBAL_SOTTOAZZ + "' AND a.icqrf='" + FXMLDocumentController.GLOBAL_ICQRF + "' AND a.cod_committente='" + FXMLDocumentController.GLOBAL_CODCOMM + "' ";
        if (!where.equals("")) {
            str = str + where;
        }
        strSQL.add(str);
        tipoSQL.add("select");
        String strJson = this.util.makeStringJsonDB("OFF", tipoSQL, strSQL, null, null, lastID, null);
        String data_select = this.sk1Comm.ServerEsecuteRequest(FXMLDocumentController.GLOBAL_IP, FXMLDocumentController.GLOBAL_PORT, "dbInteraction#@" + strJson);
        if (!data_select.contains("#ERR:")) {
            ret = this.jsonUtil.strJsonToJSONArray(data_select);
        }
        return ret;
    }

    public JSONArray giacenzaVino(String codiceRicerca, String where, String wherelitri, boolean art_mexal) throws JSONException {
        JSONArray ret = null;
        ArrayList<String> strSQL = new ArrayList<String>();
        ArrayList<String> tipoSQL = new ArrayList<String>();
        ArrayList<Boolean> lastID = new ArrayList<Boolean>();
        strSQL = new ArrayList();
        tipoSQL = new ArrayList();
        lastID = new ArrayList();
        lastID.add(false);
        String dadata = "";
        LocalDate dtpo = LocalDate.parse(this.getDallaDataInizioAnno());
        dadata = dtpo.toString().equals("2017-01-01") ? dtpo.toString() : dtpo.plusDays(1L).toString();
        String str = "DROP TEMPORARY TABLE IF EXISTS tb1;\nCREATE TEMPORARY TABLE IF NOT EXISTS tb1(\ncod_prod_mx VARCHAR(60),\nsian_massa_volumica DOUBLE,\nsian_classificazione VARCHAR(100),\ncod_committente VARCHAR(15),\nsian_cat_prodotto VARCHAR(100),\nid BIGINT(20),\nsian_cod_stato_fisico VARCHAR(5),\nazienda VARCHAR(10),\nsotto_az VARCHAR(15),\nicqrf VARCHAR(10),\nsian_volume_nominale DOUBLE,\nsian_annata VARCHAR(10),\ndata_oper DATE,\ncodice VARCHAR(255),\ndescrizione VARCHAR(255),\nlitri DECIMAL(22,4),\npezzi DECIMAL(18,2),\nsian_atto_certificato VARCHAR(50)\n);\nINSERT INTO tb1(SELECT IFNULL(b.cod_prod_mx,'') AS cod_prod_mx,c.sian_massa_volumica,c.sian_classificazione,a.cod_committente,\nc.sian_cat_prodotto,b.id,c.sian_cod_stato_fisico,a.azienda,a.sotto_az,a.icqrf, c.sian_volume_nominale,\nc.sian_annata,a.data_oper,c.codice,c.descrizione,SUM(b.litri) AS litri,\nSUM(b.confez) AS pezzi, c.sian_atto_certificato \nFROM c_operazioni AS a \nLEFT JOIN c_movimenti AS b ON a.id=b.id_oper \nLEFT JOIN gen_tipo_vino_ana AS c ON b.cod_tipo_vino=c.codice  AND b.azienda=c.azienda AND b.sotto_az=c.sotto_az \nAND b.icqrf=c.icqrf AND b.cod_committente=c.cod_committente \nWHERE a.azienda='" + FXMLDocumentController.GLOBAL_AZIENDA + "' AND a.sotto_az='" + FXMLDocumentController.GLOBAL_SOTTOAZZ + "' AND a.icqrf='" + FXMLDocumentController.GLOBAL_ICQRF + "'  AND a.cod_committente='" + FXMLDocumentController.GLOBAL_CODCOMM + "' AND data_oper>='" + dadata + "'  \nGROUP BY b.cod_tipo_vino,b.azienda,b.sotto_az,b.icqrf,b.cod_committente \nORDER BY c.codice);\nCREATE INDEX index_table_2 ON tb1(codice,azienda,sotto_az,icqrf,cod_committente);\n\nDROP TEMPORARY TABLE IF EXISTS tb2;\nCREATE TEMPORARY TABLE IF NOT EXISTS tb2(\nsian_massa_volumica DOUBLE,\nsian_classificazione VARCHAR(100),\ncod_committente VARCHAR(15),\ncodice VARCHAR(255),\nsian_cat_prodotto VARCHAR(100),\nid BIGINT(20),\nsian_cod_stato_fisico VARCHAR(5),\nazienda VARCHAR(10),\nsotto_az VARCHAR(15),\nicqrf VARCHAR(10),\nsian_volume_nominale DOUBLE,\nsian_annata VARCHAR(10),\ndata_oper DATE,\ndescrizione VARCHAR(255),\npezzi DECIMAL(18,2),\nsian_atto_certificato VARCHAR(50),\nlitri DECIMAL(22,4)\n);\nINSERT INTO tb2(\nSELECT xx.sian_massa_volumica,a.sian_classificazione,xx.cod_committente,xx.codice,xx.sian_cat_prodotto,a.id,\nxx.sian_cod_stato_fisico,xx.azienda,xx.sotto_az,xx.icqrf,xx.sian_volume_nominale, xx.sian_annata,a.data_oper,\nxx.descrizione,a.pezzi,xx.sian_atto_certificato,a.litri \nFROM gen_tipo_vino_ana AS xx \nLEFT JOIN tb1 AS a ON xx.codice=a.codice AND xx.azienda=a.azienda AND  xx.sotto_az=a.sotto_az \nAND xx.icqrf=a.icqrf AND xx.cod_committente=a.cod_committente);\nCREATE INDEX index_table_1 ON tb2(codice,azienda,sotto_az,icqrf,cod_committente);\n\n\nDROP TEMPORARY TABLE IF EXISTS tb3;\nCREATE TEMPORARY TABLE IF NOT EXISTS tb3(\nsian_um VARCHAR(100),\nsian_massa_volumica DOUBLE,\nsian_classificazione VARCHAR(100),\ncod_committente VARCHAR(15),\ncodice VARCHAR(255),\nsian_cat_prodotto VARCHAR(100),\nid BIGINT(20),\nsian_cod_stato_fisico VARCHAR(5),\nazienda VARCHAR(10),\nsotto_az VARCHAR(15),\nicqrf VARCHAR(10),\nsian_volume_nominale DOUBLE,\nsian_annata VARCHAR(10),\ndata_oper DATE,\ndescrizione VARCHAR(255),\npezzi DECIMAL(18,2),\nsian_atto_certificato VARCHAR(50),\nlitri DECIMAL(22,4)\n);\nINSERT INTO tb3(SELECT b.UNITA_DI_MISURA AS sian_um,IFNULL(a.sian_massa_volumica,0) AS sian_massa_volumica,\na.sian_classificazione,a.cod_committente,a.codice,a.sian_cat_prodotto,a.id,a.sian_cod_stato_fisico,\na.azienda,a.sotto_az,a.icqrf,a.sian_volume_nominale, a.sian_annata,a.data_oper,a.descrizione,a.pezzi,\na.sian_atto_certificato,COALESCE(a.litri,0) AS litri \nFROM tb2 AS a \nLEFT JOIN sian_t_categoria AS b ON a.sian_cat_prodotto=b.CODICE \nWHERE a.azienda='" + FXMLDocumentController.GLOBAL_AZIENDA + "' AND a.sotto_az='" + FXMLDocumentController.GLOBAL_SOTTOAZZ + "' AND a.icqrf='" + FXMLDocumentController.GLOBAL_ICQRF + "'  AND a.cod_committente='" + FXMLDocumentController.GLOBAL_CODCOMM + "' );\n\n\nDROP TEMPORARY TABLE IF EXISTS tb4;\nCREATE TEMPORARY TABLE IF NOT EXISTS tb4(\nsian_varieta VARCHAR(100),\ncancellato VARCHAR(10),\ncod_prod_mx VARCHAR(255),\nsian_um VARCHAR(100),\nsian_massa_volumica DOUBLE,\nsian_classificazione VARCHAR(100),\ncod_committente VARCHAR(15),\nid BIGINT(20),\ncodice VARCHAR(255),\nsian_cat_prodotto VARCHAR(100),\nsian_cod_stato_fisico VARCHAR(5),\nazienda VARCHAR(10),\nsotto_az VARCHAR(15),\nicqrf VARCHAR(10),\nsian_volume_nominale DOUBLE,\nsian_annata VARCHAR(10),\ndata_oper DATE,\ndescrizione VARCHAR(255),\npezzi DECIMAL(18,2),\nsian_atto_certificato VARCHAR(50),\nlitri DECIMAL(22,4)\n);\nINSERT INTO tb4(SELECT b.sian_varieta,b.cancellato,c.codice AS cod_prod_mx,a.sian_um,b.sian_massa_volumica,b.sian_classificazione,\na.cod_committente,a.id,a.codice,a.sian_cat_prodotto,a.sian_cod_stato_fisico,a.azienda, a.sotto_az,\na.icqrf,a.sian_volume_nominale, a.sian_annata,a.data_oper,a.descrizione,a.pezzi,a.sian_atto_certificato,a.litri  \nFROM tb3 AS a \nINNER JOIN gen_tipo_vino_ana AS b ON a.codice=b.codice AND a.azienda=b.azienda AND a.icqrf=b.icqrf \nAND a.cod_committente=b.cod_committente \nLEFT JOIN gen_tipo_vino_ana_mx AS c ON b.id=c.id_tipo_vino_ana \n\n";
        if (!wherelitri.equals("")) {
            str = str + "HAVING COALESCE(litri,0)" + wherelitri + " ";
        }
        str = str + "\n);\n\nSELECT a.sian_varieta,a.cancellato,a.cod_prod_mx,a.sian_um,a.sian_massa_volumica,a.sian_classificazione,a.cod_committente,a.id,a.codice,a.sian_cat_prodotto,\na.sian_cod_stato_fisico,a.azienda, a.sotto_az,a.icqrf,a.sian_volume_nominale, a.sian_annata,a.data_oper,a.descrizione,a.pezzi,a.sian_atto_certificato,a.litri  \nFROM tb4 AS a \nWHERE ";
        if (art_mexal) {
            if (!codiceRicerca.equals("")) {
                str = str + "(a.descrizione LIKE '%" + codiceRicerca.replace("'", "\\'") + "%' OR a.cod_prod_mx LIKE '%" + codiceRicerca.replace("'", "\\'") + "%') AND";
            }
        } else if (!codiceRicerca.equals("")) {
            str = str + "(a.descrizione LIKE '%" + codiceRicerca.replace("'", "\\'") + "%' OR a.codice LIKE '%" + codiceRicerca.replace("'", "\\'") + "%') AND";
        }
        str = str + " a.azienda='" + FXMLDocumentController.GLOBAL_AZIENDA + "' AND a.sotto_az='" + FXMLDocumentController.GLOBAL_SOTTOAZZ + "' AND a.icqrf='" + FXMLDocumentController.GLOBAL_ICQRF + "' AND a.cod_committente='" + FXMLDocumentController.GLOBAL_CODCOMM + "' AND a.cancellato=0 ";
        if (!where.equals("")) {
            str = str + where;
        }
        if (!codiceRicerca.equals("")) {
            str = str + " LIMIT 0,50";
        }
        strSQL.add(str);
        tipoSQL.add("selectRS");
        String strJson = this.util.makeStringJsonDB("OFF", tipoSQL, strSQL, null, null, lastID, null);
        String data_select = this.sk1Comm.ServerEsecuteRequest(FXMLDocumentController.GLOBAL_IP, FXMLDocumentController.GLOBAL_PORT, "dbInteraction#@" + strJson);
        if (!data_select.contains("#ERR:")) {
            ret = this.jsonUtil.strJsonToJSONArray(data_select);
        }
        return ret;
    }

    public JSONArray giacenzaVinoPerMexal(String codiceRicerca, String where, boolean chk_mexal) throws JSONException {
        JSONArray ret = null;
        ArrayList<String> strSQL = new ArrayList<String>();
        ArrayList<String> tipoSQL = new ArrayList<String>();
        ArrayList<Boolean> lastID = new ArrayList<Boolean>();
        strSQL = new ArrayList();
        tipoSQL = new ArrayList();
        lastID = new ArrayList();
        lastID.add(false);
        String rew = "SELECT a.cancellato,IFNULL(b.codice,'') AS cod_prod_mx,a.descrizione,a.codice,a.id,a.sian_cod_stato_fisico,a.sian_atto_certificato,a.sian_annata,a.sian_volume_nominale,a.sian_cat_prodotto FROM gen_tipo_vino_ana AS a LEFT JOIN gen_tipo_vino_ana_mx AS b ON a.id=b.id_tipo_vino_ana ";
        rew = !chk_mexal ? rew + "WHERE (a.descrizione LIKE '%" + codiceRicerca.replace("'", "\\'") + "%' OR a.codice LIKE '%" + codiceRicerca.replace("'", "\\'") + "%') " : rew + "WHERE (b.descrizione LIKE '%" + codiceRicerca.replace("'", "\\'") + "%' OR b.codice LIKE '%" + codiceRicerca.replace("'", "\\'") + "%') ";
        rew = rew + "AND a.azienda='" + FXMLDocumentController.GLOBAL_AZIENDA + "' AND a.sotto_az='" + FXMLDocumentController.GLOBAL_SOTTOAZZ + "' AND a.icqrf='" + FXMLDocumentController.GLOBAL_ICQRF + "' AND a.cod_committente='" + FXMLDocumentController.GLOBAL_CODCOMM + "' " + where;
        strSQL.add(rew);
        tipoSQL.add("select");
        String strJson = this.util.makeStringJsonDB("OFF", tipoSQL, strSQL, null, null, lastID, null);
        String data_select = this.sk1Comm.ServerEsecuteRequest(FXMLDocumentController.GLOBAL_IP, FXMLDocumentController.GLOBAL_PORT, "dbInteraction#@" + strJson);
        if (!data_select.contains("#ERR:")) {
            ret = this.jsonUtil.strJsonToJSONArray(data_select);
        }
        return ret;
    }

    public String getVaschea0eVascheNonPiene(String where) throws JSONException {
        String data_select;
        String ret = "";
        ArrayList<String> strSQL = new ArrayList<String>();
        ArrayList<String> tipoSQL = new ArrayList<String>();
        ArrayList<Boolean> lastID = new ArrayList<Boolean>();
        strSQL = new ArrayList();
        tipoSQL = new ArrayList();
        lastID = new ArrayList();
        lastID.add(false);
        String str = "SELECT ente_cert,data_ido,num_prot,cod_committente,azienda,sotto_az,id,codice_vaso,tipo_vaso,descr_vaso,capacita,cod_tipo_vino,giacenza FROM( SELECT ente_cert,data_ido,num_prot,cod_committente,azienda,sotto_az,id,codice_vaso,tipo_vaso,descr_vaso,capacita,cod_tipo_vino,giacenza FROM (SELECT a.ente_cert,a.data_ido,a.num_prot,a.cod_committente,a.azienda,a.sotto_az,a.id,a.codice_vaso,a.tipo_vaso,a.descr_vaso,a.capacita,a.cod_tipo_vino,a.giacenza FROM (SELECT b.ente_cert,b.data_ido,b.num_prot,a.cod_committente,a.azienda,a.sotto_az,a.id,a.codice_vaso,a.tipo_vaso,a.descr_vaso,a.capacita,b.cod_tipo_vino,a.giacenza FROM (SELECT a.cod_committente,a.azienda,a.sotto_az,a.id,a.codice_vaso,a.tipo_vaso,a.descr_vaso,a.capacita,IF(a.giacenza=0,'',a.cod_tipo_vino) AS cod_tipo_vino,a.giacenza FROM (SELECT a.cod_committente,a.azienda,a.sotto_az,a.id,a.codice_vaso,a.tipo_vaso,a.descr_vaso,a.capacita,b.cod_tipo_vino,if(ISNULL(SUM(b.qta_mov)),0,SUM(b.qta_mov)) AS giacenza FROM gen_vasi_vinari_ana AS a LEFT JOIN gen_vasi_vinari_mov AS b ON a.id=b.id_vaso WHERE a.azienda='" + FXMLDocumentController.GLOBAL_AZIENDA + "' AND a.sotto_az='" + FXMLDocumentController.GLOBAL_SOTTOAZZ + "' AND a.icqrf='" + FXMLDocumentController.GLOBAL_ICQRF + "'  GROUP BY a.codice_vaso) AS a) AS a LEFT JOIN (SELECT ente_cert,data_ido,num_prot,a.cod_committente,a.azienda,a.sotto_az,a.icqrf,a.codice_vaso,a.cod_tipo_vino FROM (SELECT ente_cert,data_ido,num_prot,a.cod_committente,a.azienda,a.sotto_az,a.icqrf,a.id,a.codice_vaso,a.tipo_vaso,a.descr_vaso,a.capacita,IF(MAX(a.giacenza)=0,'',a.cod_tipo_vino) AS cod_tipo_vino,MAX(a.giacenza) AS giacenza FROM(SELECT ente_cert,data_ido,num_prot,a.cod_committente,a.azienda,a.sotto_az,a.icqrf,a.id,a.codice_vaso,a.tipo_vaso,a.descr_vaso,a.capacita,a.cod_tipo_vino,a.giacenza AS giacenza FROM(SELECT '' AS ente_cert,'' AS data_ido,'' AS num_prot,a.cod_committente,a.azienda,a.sotto_az,a.icqrf,a.id,a.codice_vaso,a.tipo_vaso,a.descr_vaso,a.capacita,b.cod_tipo_vino,if(ISNULL(SUM(b.qta_mov)),0,SUM(b.qta_mov)) AS giacenza FROM gen_vasi_vinari_ana AS a LEFT JOIN gen_vasi_vinari_mov AS b ON a.id=b.id_vaso WHERE a.azienda='" + FXMLDocumentController.GLOBAL_AZIENDA + "' AND a.sotto_az='" + FXMLDocumentController.GLOBAL_SOTTOAZZ + "' AND a.icqrf='" + FXMLDocumentController.GLOBAL_ICQRF + "'  GROUP BY a.codice_vaso,cod_tipo_vino) AS a) AS a GROUP BY a.codice_vaso) AS a ) AS b ON a.codice_vaso=b.codice_vaso) AS a WHERE a.giacenza=0) AS a UNION  SELECT a.ente_cert,a.data_ido,a.num_prot_ido,a.cod_committente,a.azienda,a.sotto_az,a.id,a.codice_vaso,a.tipo_vaso,a.descr_vaso,a.capacita,a.cod_tipo_vino,a.giacenza  FROM ( SELECT b.ente_cert,b.data_ido,b.num_prot_ido,a.cod_committente,a.azienda,a.sotto_az,a.id,a.codice_vaso,a.tipo_vaso,a.descr_vaso,a.capacita,b.cod_tipo_vino,a.giacenza FROM ( SELECT a.cod_committente,a.azienda,a.sotto_az,a.id,a.codice_vaso,a.tipo_vaso,a.descr_vaso,a.capacita,IF(a.giacenza=0,'',a.cod_tipo_vino) AS cod_tipo_vino,a.giacenza FROM ( SELECT a.cod_committente,a.azienda,a.sotto_az,a.id,a.codice_vaso,a.tipo_vaso,a.descr_vaso,a.capacita,b.cod_tipo_vino,if(ISNULL(SUM(b.qta_mov)),0,SUM(b.qta_mov)) AS giacenza FROM gen_vasi_vinari_ana AS a LEFT JOIN gen_vasi_vinari_mov AS b ON a.id=b.id_vaso WHERE b.azienda='" + FXMLDocumentController.GLOBAL_AZIENDA + "' AND b.sotto_az='" + FXMLDocumentController.GLOBAL_SOTTOAZZ + "' AND b.icqrf='" + FXMLDocumentController.GLOBAL_ICQRF + "' AND b.cod_committente='" + FXMLDocumentController.GLOBAL_CODCOMM + "'  GROUP BY a.codice_vaso,b.cod_tipo_vino HAVING if(ISNULL(SUM(b.qta_mov)),0,SUM(b.qta_mov))>0) AS a ) AS a LEFT JOIN  ( SELECT a.ente_cert,a.data_ido,a.num_prot_ido,a.cod_committente,a.azienda,a.sotto_az,a.icqrf,a.codice_vaso,a.cod_tipo_vino FROM ( SELECT a.ente_cert,a.data_ido,a.num_prot_ido,a.cod_committente,a.azienda,a.sotto_az,a.icqrf,a.id,a.codice_vaso,a.tipo_vaso,a.descr_vaso,a.capacita,IF(MAX(a.giacenza)=0,'',a.cod_tipo_vino) AS cod_tipo_vino,MAX(a.giacenza) AS giacenza FROM( SELECT a.ente_cert,a.data_ido,a.num_prot_ido,a.cod_committente,a.azienda,a.sotto_az,a.icqrf,a.id,a.codice_vaso,a.tipo_vaso,a.descr_vaso,a.capacita,a.cod_tipo_vino,a.giacenza AS giacenza FROM( SELECT y.ente_cert,y.data_ido,y.num_prot_ido,a.cod_committente,a.azienda,a.sotto_az,a.icqrf,a.id,a.codice_vaso,a.tipo_vaso,a.descr_vaso,a.capacita,b.cod_tipo_vino,if(ISNULL(SUM(b.qta_mov)),0,SUM(b.qta_mov)) AS giacenza FROM gen_vasi_vinari_ana AS a LEFT JOIN gen_vasi_vinari_mov AS b ON a.id=b.id_vaso LEFT JOIN c_movimenti AS y ON b.id_mov=y.id  WHERE b.azienda='" + FXMLDocumentController.GLOBAL_AZIENDA + "' AND b.sotto_az='" + FXMLDocumentController.GLOBAL_SOTTOAZZ + "' AND b.icqrf='" + FXMLDocumentController.GLOBAL_ICQRF + "' AND b.cod_committente='" + FXMLDocumentController.GLOBAL_CODCOMM + "'  GROUP BY a.codice_vaso,b.cod_tipo_vino,y.num_prot_ido,y.data_ido,y.ente_cert HAVING if(ISNULL(SUM(b.qta_mov)),0,SUM(b.qta_mov))>0 ) AS a ) AS a GROUP BY a.codice_vaso) AS a ) AS b ON a.codice_vaso=b.codice_vaso) AS a ";
        str = str + where;
        str = str + "HAVING if((a.capacita*100)>a.giacenza,a.giacenza,0)>0 ) AS c";
        strSQL.add(str);
        tipoSQL.add("select");
        String strJson = this.util.makeStringJsonDB("OFF", tipoSQL, strSQL, null, null, lastID, null);
        ret = data_select = this.sk1Comm.ServerEsecuteRequest(FXMLDocumentController.GLOBAL_IP, FXMLDocumentController.GLOBAL_PORT, "dbInteraction#@" + strJson);
        return ret;
    }

    public String giacenzaLottiArticoloMexal(String codiceDescrArticolo, String where, boolean cod_art_mx) throws JSONException {
        String data_select;
        String ret = "";
        ArrayList<String> strSQL = new ArrayList<String>();
        ArrayList<String> tipoSQL = new ArrayList<String>();
        ArrayList<Boolean> lastID = new ArrayList<Boolean>();
        strSQL = new ArrayList();
        tipoSQL = new ArrayList();
        lastID = new ArrayList();
        lastID.add(false);
        String str = "SELECT a.data_ido,a.ente_cert,a.num_prot_ido,a.cod_tipo_vino,IFNULL(a.mx_art,'') AS cod_prod_mx,a.qta_lotto,a.cod_lotto,IFNULL(b.descrizione,'') AS descrizione FROM (SELECT a.azienda,a.sotto_az,a.icqrf,a.cod_committente,a.data_ido,a.ente_cert,a.num_prot_ido,a.cod_tipo_vino,b.mx_art,SUM(b.qta) AS qta_lotto,b.cod_lotto FROM c_movimenti AS a LEFT JOIN c_movimenti_lotti AS b  ON b.id_mov=a.id WHERE a.azienda='" + FXMLDocumentController.GLOBAL_AZIENDA + "' AND a.sotto_az='" + FXMLDocumentController.GLOBAL_SOTTOAZZ + "' AND a.icqrf='" + FXMLDocumentController.GLOBAL_ICQRF + "' AND a.cod_committente='" + FXMLDocumentController.GLOBAL_CODCOMM + "' GROUP BY a.cod_tipo_vino,b.cod_lotto,b.mx_art) AS a LEFT JOIN gen_tipo_vino_ana_mx AS b ON a.mx_art=b.codice WHERE (descrizione LIKE '%" + codiceDescrArticolo.replace("'", "\\'") + "%' OR a.cod_tipo_vino LIKE '%" + codiceDescrArticolo.replace("'", "\\'") + "%' ";
        if (cod_art_mx) {
            str = str + "OR a.mx_art LIKE '%" + codiceDescrArticolo.replace("'", "\\'") + "%'";
        }
        str = str + ")AND a.azienda='" + FXMLDocumentController.GLOBAL_AZIENDA + "' AND a.sotto_az='" + FXMLDocumentController.GLOBAL_SOTTOAZZ + "' AND a.icqrf='" + FXMLDocumentController.GLOBAL_ICQRF + "' AND a.cod_committente='" + FXMLDocumentController.GLOBAL_CODCOMM + "' ";
        if (!where.equals("")) {
            str = str + where;
        }
        strSQL.add(str);
        tipoSQL.add("select");
        String strJson = this.util.makeStringJsonDB("OFF", tipoSQL, strSQL, null, null, lastID, null);
        ret = data_select = this.sk1Comm.ServerEsecuteRequest(FXMLDocumentController.GLOBAL_IP, FXMLDocumentController.GLOBAL_PORT, "dbInteraction#@" + strJson);
        return ret;
    }

    public String ricercaIdoFromCodLotto(String cod_lotto) throws JSONException {
        String data_select;
        String ret = "";
        ArrayList<String> strSQL = new ArrayList<String>();
        ArrayList<String> tipoSQL = new ArrayList<String>();
        ArrayList<Boolean> lastID = new ArrayList<Boolean>();
        strSQL = new ArrayList();
        tipoSQL = new ArrayList();
        lastID = new ArrayList();
        lastID.add(false);
        String str = "SELECT b.num_prot_ido,b.ente_cert,b.data_ido FROM c_movimenti_lotti as a LEFT JOIN c_movimenti as b on a.id_mov=b.id WHERE a.azienda='" + FXMLDocumentController.GLOBAL_AZIENDA + "' AND a.sotto_az='" + FXMLDocumentController.GLOBAL_SOTTOAZZ + "' AND a.icqrf='" + FXMLDocumentController.GLOBAL_ICQRF + "' AND a.cod_committente='" + FXMLDocumentController.GLOBAL_CODCOMM + "' AND a.cod_lotto='" + cod_lotto + "' AND b.num_prot_ido<>''GROUP BY b.num_prot_ido,b.ente_cert,b.data_ido ";
        strSQL.add(str);
        tipoSQL.add("select");
        String strJson = this.util.makeStringJsonDB("OFF", tipoSQL, strSQL, null, null, lastID, null);
        ret = data_select = this.sk1Comm.ServerEsecuteRequest(FXMLDocumentController.GLOBAL_IP, FXMLDocumentController.GLOBAL_PORT, "dbInteraction#@" + strJson);
        return ret;
    }

    public String getUMfromCategoriaProdotto(String codice) throws JSONException {
        String ret = "";
        ArrayList<String> strSQL = new ArrayList<String>();
        ArrayList<String> tipoSQL = new ArrayList<String>();
        ArrayList<Boolean> lastID = new ArrayList<Boolean>();
        strSQL = new ArrayList();
        tipoSQL = new ArrayList();
        lastID = new ArrayList();
        lastID.add(false);
        strSQL.add("SELECT unita_di_misura FROM sian_t_categoria WHERE codice='" + codice.replace("'", "\\'") + "'");
        tipoSQL.add("select");
        String strJson = this.util.makeStringJsonDB("OFF", tipoSQL, strSQL, null, null, lastID, null);
        String data_select = this.sk1Comm.ServerEsecuteRequest(FXMLDocumentController.GLOBAL_IP, FXMLDocumentController.GLOBAL_PORT, "dbInteraction#@" + strJson);
        if (!data_select.contains("#ERR:")) {
            JSONArray arrayJson = this.jsonUtil.strJsonToJSONArray(data_select);
            for (int i = 0; i < arrayJson.length(); ++i) {
                JSONObject rec = arrayJson.getJSONObject(i);
                ret = rec.getString("unita_di_misura");
            }
        } else {
            ret = data_select;
        }
        return ret;
    }

    public String getCategoriaProdottofromProdotto(String prodotto) throws JSONException {
        String ret = "";
        ArrayList<String> strSQL = new ArrayList<String>();
        ArrayList<String> tipoSQL = new ArrayList<String>();
        ArrayList<Boolean> lastID = new ArrayList<Boolean>();
        strSQL = new ArrayList();
        tipoSQL = new ArrayList();
        lastID = new ArrayList();
        lastID.add(false);
        strSQL.add("SELECT sian_cat_prodotto FROM gen_tipo_vino_ana WHERE codice='" + prodotto.replace("'", "\\'") + "' AND azienda='" + FXMLDocumentController.GLOBAL_AZIENDA + "' AND sotto_az='" + FXMLDocumentController.GLOBAL_SOTTOAZZ + "' AND icqrf='" + FXMLDocumentController.GLOBAL_ICQRF + "' AND cod_committente='" + FXMLDocumentController.GLOBAL_CODCOMM + "'");
        tipoSQL.add("select");
        String strJson = this.util.makeStringJsonDB("OFF", tipoSQL, strSQL, null, null, lastID, null);
        String data_select = this.sk1Comm.ServerEsecuteRequest(FXMLDocumentController.GLOBAL_IP, FXMLDocumentController.GLOBAL_PORT, "dbInteraction#@" + strJson);
        if (!data_select.contains("#ERR:")) {
            JSONArray arrayJson = this.jsonUtil.strJsonToJSONArray(data_select);
            for (int i = 0; i < arrayJson.length(); ++i) {
                JSONObject rec = arrayJson.getJSONObject(i);
                ret = rec.getString("sian_cat_prodotto");
            }
        } else {
            ret = data_select;
        }
        return ret;
    }
}

