/*
 * Decompiled with CFR 0.152.
 */
package vin.Class;

import java.io.IOException;
import javafx.application.Application;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.concurrent.Task;
import javafx.fxml.FXMLLoader;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Alert;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.control.ProgressBar;
import javafx.scene.image.Image;
import javafx.stage.Modality;
import javafx.stage.Stage;
import vin.Class.ColumnDocumentiLotti;
import vin.Class.ColumnDocumentiRighe;
import vin.Class.ColumnDocumentiTestata;
import vin.Class.ColumnDocumentiVasche;
import vin.Wbs;
import vin.controller.FXMLDocumentController;

public class ProgressImportDBEsterno
extends Application {
    public ObservableList<ColumnDocumentiTestata> lista_documenti_testata = null;
    public ObservableList<ColumnDocumentiRighe> lista_documenti_righe = null;
    public ObservableList<ColumnDocumentiVasche> lista_documenti_vasche = null;
    public ObservableList<ColumnDocumentiLotti> lista_documenti_lotti = null;
    Task copyWorker;
    Button btn_ok = null;
    Alert.AlertType typeAlert = Alert.AlertType.ERROR;

    public static void main(String[] args) {
        Application.launch((String[])args);
    }

    public void start(final Stage primaryStage) throws IOException {
        this.lista_documenti_testata = FXCollections.observableArrayList();
        this.lista_documenti_righe = FXCollections.observableArrayList();
        this.lista_documenti_vasche = FXCollections.observableArrayList();
        this.lista_documenti_lotti = FXCollections.observableArrayList();
        FXMLLoader loader = new FXMLLoader(((Object)((Object)this)).getClass().getResource("/vin/view/ProgressImportDBEsterno.fxml"));
        Parent rootLayout = (Parent)loader.load();
        Scene scene = new Scene(rootLayout);
        primaryStage.setTitle("IMPORT " + Wbs.labelAziendale);
        primaryStage.getIcons().add((Object)new Image(((Object)((Object)this)).getClass().getResourceAsStream("/vin/images/registry.png")));
        primaryStage.setScene(scene);
        primaryStage.initModality(Modality.APPLICATION_MODAL);
        primaryStage.setResizable(false);
        Label label_text = (Label)scene.lookup("#label_text");
        Label label_title = (Label)scene.lookup("#label_title");
        label_text.setText("Import in corso....");
        label_title.setText("Import");
        final ProgressBar progressBar = (ProgressBar)scene.lookup("#progressbar");
        progressBar.setProgress(0.0);
        this.copyWorker = this.createWorker();
        progressBar.progressProperty().unbind();
        progressBar.progressProperty().bind((ObservableValue)this.copyWorker.progressProperty());
        this.copyWorker.messageProperty().addListener((ChangeListener)new ChangeListener<String>(){

            public void changed(ObservableValue<? extends String> observable, String oldValue, String newValue) {
                if (newValue.equals("Import completato con successo")) {
                    ProgressImportDBEsterno.this.copyWorker.cancel(true);
                    progressBar.progressProperty().unbind();
                    progressBar.setProgress(0.0);
                    primaryStage.close();
                }
                FXMLDocumentController.util.alertWindow(ProgressImportDBEsterno.this.typeAlert, "ERRORE", "", newValue);
            }
        });
        new Thread((Runnable)this.copyWorker).start();
        primaryStage.setScene(scene);
        primaryStage.showAndWait();
    }

    public Task createWorker() {
        return new Task(){

            protected Object call() throws Exception {
                try {
                    String data_select = FXMLDocumentController.sk1Comm.ServerEsecuteRequest(FXMLDocumentController.GLOBAL_IP, FXMLDocumentController.GLOBAL_PORT, "ImportTabelleEsterne#@");
                    if (data_select.contains("#OK") || data_select.trim().equals("")) {
                        ProgressImportDBEsterno.this.typeAlert = Alert.AlertType.INFORMATION;
                        this.updateMessage("Import completato con successo");
                    } else {
                        ProgressImportDBEsterno.this.typeAlert = Alert.AlertType.ERROR;
                        this.updateMessage(data_select);
                    }
                }
                catch (Exception e) {
                    this.updateMessage(e.toString());
                }
                return true;
            }
        };
    }
}

