/*
 * Decompiled with CFR 0.152.
 */
package vin.Class;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.List;
import javafx.application.Application;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.concurrent.Task;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.fxml.FXMLLoader;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Alert;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.control.ProgressBar;
import javafx.scene.image.Image;
import javafx.scene.text.Text;
import javafx.stage.FileChooser;
import javafx.stage.Modality;
import javafx.stage.Stage;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import vin.Class.ColumnDocumentiLotti;
import vin.Class.ColumnDocumentiRighe;
import vin.Class.ColumnDocumentiTestata;
import vin.Class.ColumnDocumentiVasche;
import vin.Class.Ricerca;
import vin.Comunicator.Sk1SrvCommunicator;
import vin.Uility.JsonUtils;
import vin.Uility.Utility;
import vin.Wbs;
import vin.controller.FXMLDocumentController;
import vin.controller.ToastFXMessages;

public class ProgressBAr
extends Application {
    public Utility util;
    public Sk1SrvCommunicator sk1Comm = new Sk1SrvCommunicator();
    public JsonUtils jsonUtil = new JsonUtils();
    public ToastFXMessages toast = new ToastFXMessages();
    public Ricerca ricerca = new Ricerca();
    public ObservableList<ColumnDocumentiTestata> lista_documenti_testata = null;
    public ObservableList<ColumnDocumentiRighe> lista_documenti_righe = null;
    public ObservableList<ColumnDocumentiVasche> lista_documenti_vasche = null;
    public ObservableList<ColumnDocumentiLotti> lista_documenti_lotti = null;
    Task copyWorker;
    Button btn_ok = null;
    Alert.AlertType typeAlert = Alert.AlertType.ERROR;
    Text txt_progress = null;
    Button btn_error = null;

    public static void main(String[] args) {
        Application.launch((String[])args);
    }

    public void start(Stage primaryStage) throws IOException {
        this.util = new Utility();
        this.lista_documenti_testata = FXCollections.observableArrayList();
        this.lista_documenti_righe = FXCollections.observableArrayList();
        this.lista_documenti_vasche = FXCollections.observableArrayList();
        this.lista_documenti_lotti = FXCollections.observableArrayList();
        FXMLLoader loader = new FXMLLoader(((Object)((Object)this)).getClass().getResource("/vin/view/ProgressBar.fxml"));
        Parent rootLayout = (Parent)loader.load();
        final Scene scene = new Scene(rootLayout);
        primaryStage.setTitle("IMPORT " + Wbs.labelAziendale);
        primaryStage.getIcons().add((Object)new Image(((Object)((Object)this)).getClass().getResourceAsStream("/vin/images/registry.png")));
        primaryStage.setScene(scene);
        primaryStage.initModality(Modality.APPLICATION_MODAL);
        primaryStage.setResizable(false);
        this.btn_ok = (Button)scene.lookup("#btn_ok");
        this.btn_ok.setText("START");
        this.btn_error = (Button)scene.lookup("#btn_error");
        this.btn_error.setText("CANCEL");
        this.txt_progress = (Text)scene.lookup("#txt_progress");
        Label label_text = (Label)scene.lookup("#label_text");
        Label label_title = (Label)scene.lookup("#label_title");
        label_text.setText("Import in corso....");
        label_title.setText("Import");
        final ProgressBar progressBar = (ProgressBar)scene.lookup("#progressbar");
        this.btn_error.setDisable(true);
        this.btn_ok.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent event) {
                ProgressBAr.this.btn_ok.setDisable(true);
                progressBar.setProgress(0.0);
                ProgressBAr.this.btn_error.setDisable(false);
                FileChooser fileChooser = new FileChooser();
                ProgressBAr.configureFileChooser(fileChooser);
                List list = fileChooser.showOpenMultipleDialog(scene.getWindow());
                if (list != null) {
                    ProgressBAr.this.copyWorker = ProgressBAr.this.createWorker(list);
                    progressBar.progressProperty().unbind();
                    progressBar.progressProperty().bind((ObservableValue)ProgressBAr.this.copyWorker.progressProperty());
                    ProgressBAr.this.copyWorker.messageProperty().addListener((ChangeListener)new ChangeListener<String>(){

                        public void changed(ObservableValue<? extends String> observable, String oldValue, String newValue) {
                            ProgressBAr.this.util.alertWindow(ProgressBAr.this.typeAlert, "ERRORE", "", newValue);
                        }
                    });
                    new Thread((Runnable)ProgressBAr.this.copyWorker).start();
                }
            }
        });
        this.btn_error.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent event) {
                ProgressBAr.this.btn_ok.setDisable(false);
                ProgressBAr.this.btn_error.setDisable(true);
                ProgressBAr.this.copyWorker.cancel(true);
                progressBar.progressProperty().unbind();
                progressBar.setProgress(0.0);
                System.out.println("cancelled.");
            }
        });
        primaryStage.setScene(scene);
        primaryStage.showAndWait();
    }

    public Task createWorker(final List<File> list) {
        return new Task(){

            protected Object call() throws Exception {
                try {
                    for (File file : list) {
                        String ret;
                        String fileName = file.getName();
                        if (fileName.equals("LOTTI_DOCUMENTI.csv")) {
                            ret = ProgressBAr.this.ImportFileLotti(file.getAbsolutePath());
                            if (!ret.equals("")) {
                                ProgressBAr.this.typeAlert = Alert.AlertType.ERROR;
                                this.updateMessage(ret);
                                break;
                            }
                            this.updateProgress(5L, 100L);
                            ProgressBAr.this.txt_progress.setText("5%");
                        } else if (fileName.equals("RIGHE_DOCUMENTI.csv")) {
                            ret = ProgressBAr.this.ImportFileRighe(file.getAbsolutePath());
                            if (!ret.equals("")) {
                                ProgressBAr.this.typeAlert = Alert.AlertType.ERROR;
                                this.updateMessage(ret);
                                break;
                            }
                            this.updateProgress(10L, 100L);
                            ProgressBAr.this.txt_progress.setText("10%");
                        } else if (fileName.equals("TESTATA_DOCUMENTI.csv")) {
                            ret = ProgressBAr.this.ImportFileTestata(file.getAbsolutePath());
                            if (!ret.equals("")) {
                                ProgressBAr.this.typeAlert = Alert.AlertType.ERROR;
                                this.updateMessage(ret);
                                break;
                            }
                            this.updateProgress(15L, 100L);
                            ProgressBAr.this.txt_progress.setText("15%");
                        } else if (fileName.equals("VASCHE_DOCUMENTI.csv")) {
                            ret = ProgressBAr.this.ImportFileVasche(file.getAbsolutePath());
                            if (!ret.equals("")) {
                                ProgressBAr.this.typeAlert = Alert.AlertType.ERROR;
                                this.updateMessage(ret);
                                break;
                            }
                            this.updateProgress(20L, 100L);
                            ProgressBAr.this.txt_progress.setText("20%");
                        }
                        Thread.sleep(1000L);
                    }
                    String strJson = ProgressBAr.this.fromObservableListToDB();
                    this.updateProgress(100L, 100L);
                    ProgressBAr.this.txt_progress.setText("100%");
                    if (strJson.contains("#OK")) {
                        ProgressBAr.this.typeAlert = Alert.AlertType.INFORMATION;
                        this.updateMessage("Import completato con successo");
                    } else {
                        ProgressBAr.this.typeAlert = Alert.AlertType.ERROR;
                        this.updateMessage("Errore caricamento import");
                    }
                }
                catch (Exception e) {
                    this.updateMessage(e.toString());
                }
                return true;
            }
        };
    }

    private String fromObservableListToDB() throws JSONException {
        String ret = "";
        boolean iteratorProdotto = false;
        ArrayList<String> tipoSQL = new ArrayList<String>();
        ArrayList<String> strSQL = new ArrayList<String>();
        ArrayList<Integer> lenghtBidimensionalArray = new ArrayList<Integer>();
        ArrayList<Boolean> lastID = new ArrayList<Boolean>();
        String str = "";
        String data_select = "";
        String[][] tipo_ins = new String[this.lista_documenti_lotti.size() + this.lista_documenti_righe.size() + this.lista_documenti_testata.size() + this.lista_documenti_vasche.size()][30];
        String[][] valore = new String[this.lista_documenti_lotti.size() + this.lista_documenti_righe.size() + this.lista_documenti_testata.size() + this.lista_documenti_vasche.size()][30];
        int iterator = 0;
        for (int i = 0; i < this.lista_documenti_testata.size(); ++i) {
            int id = ((ColumnDocumentiTestata)this.lista_documenti_testata.get(i)).getId();
            String codice_operazione = ((ColumnDocumentiTestata)this.lista_documenti_testata.get(i)).getCodice_operazione();
            String azienda = ((ColumnDocumentiTestata)this.lista_documenti_testata.get(i)).getAzienda();
            String sotto_az = ((ColumnDocumentiTestata)this.lista_documenti_testata.get(i)).getSotto_azienda();
            String icqrf = ((ColumnDocumentiTestata)this.lista_documenti_testata.get(i)).getIcqrf();
            String codice_committente = ((ColumnDocumentiTestata)this.lista_documenti_testata.get(i)).getCodice_committente();
            String data_operazione = ((ColumnDocumentiTestata)this.lista_documenti_testata.get(i)).getData_operazione();
            String sigla_documento = ((ColumnDocumentiTestata)this.lista_documenti_testata.get(i)).getSigla_documento();
            int serie_documento = ((ColumnDocumentiTestata)this.lista_documenti_testata.get(i)).getSerie_documento();
            int numero_documento = ((ColumnDocumentiTestata)this.lista_documenti_testata.get(i)).getNumero_documento();
            int causale_documento = ((ColumnDocumentiTestata)this.lista_documenti_testata.get(i)).getCausale_documento();
            int codice_magazzino = ((ColumnDocumentiTestata)this.lista_documenti_testata.get(i)).getMagazzino_documento();
            String codCliente = ((ColumnDocumentiTestata)this.lista_documenti_testata.get(i)).getCliente_documento();
            String persona_giuridica = ((ColumnDocumentiTestata)this.lista_documenti_testata.get(i)).getPersonaGiuridica_documento();
            String rag_soc = ((ColumnDocumentiTestata)this.lista_documenti_testata.get(i)).getRagsoc_documento();
            String nomeCli = ((ColumnDocumentiTestata)this.lista_documenti_testata.get(i)).getNomeCli_documento();
            String cognomeCli = ((ColumnDocumentiTestata)this.lista_documenti_testata.get(i)).getCognomeCli_documento();
            String indirizzoCli = ((ColumnDocumentiTestata)this.lista_documenti_testata.get(i)).getIndirizzoCli_documento();
            String capCli = ((ColumnDocumentiTestata)this.lista_documenti_testata.get(i)).getCapCli_documento();
            String codiceIstat = ((ColumnDocumentiTestata)this.lista_documenti_testata.get(i)).getCodiceIstat_documento();
            String codiceISO = ((ColumnDocumentiTestata)this.lista_documenti_testata.get(i)).getCodiceISO_documento();
            String codiceFiscale = ((ColumnDocumentiTestata)this.lista_documenti_testata.get(i)).getCodiceFiscale_documento();
            String pivaCli = ((ColumnDocumentiTestata)this.lista_documenti_testata.get(i)).getPivaCli_documento();
            String note_documento = ((ColumnDocumentiTestata)this.lista_documenti_testata.get(i)).getNote_documento();
            String tipo_cliente = ((ColumnDocumentiTestata)this.lista_documenti_testata.get(i)).getTipoCli_documento();
            if (!codice_operazione.toUpperCase().equals("VE") && !codice_operazione.toUpperCase().equals("AQ") && !codice_operazione.toUpperCase().equals("AU") || azienda != FXMLDocumentController.GLOBAL_AZIENDA || sotto_az != FXMLDocumentController.GLOBAL_SOTTOAZZ || icqrf != FXMLDocumentController.GLOBAL_ICQRF || codice_committente != FXMLDocumentController.GLOBAL_CODCOMM) continue;
            for (int j = 0; j < this.lista_documenti_righe.size(); ++j) {
                int k;
                int id_testata = ((ColumnDocumentiRighe)this.lista_documenti_righe.get(j)).getId_testata();
                int id_riga = ((ColumnDocumentiRighe)this.lista_documenti_righe.get(j)).getId();
                String tipo_movimento = ((ColumnDocumentiRighe)this.lista_documenti_righe.get(j)).getTipo_movimento();
                String prodotto = ((ColumnDocumentiRighe)this.lista_documenti_righe.get(j)).getCodice_prodotto();
                String numero_protocollo = ((ColumnDocumentiRighe)this.lista_documenti_righe.get(j)).getNprotocollo_cert();
                double confezioni = ((ColumnDocumentiRighe)this.lista_documenti_righe.get(j)).getConfezioni();
                double qta_riga = ((ColumnDocumentiRighe)this.lista_documenti_righe.get(j)).getQta();
                double litri = ((ColumnDocumentiRighe)this.lista_documenti_righe.get(j)).getLitri();
                String data_cert = ((ColumnDocumentiRighe)this.lista_documenti_righe.get(j)).getData_cert();
                String ente_cert = ((ColumnDocumentiRighe)this.lista_documenti_righe.get(j)).getEnte_cert();
                boolean res = this.ricerca.checkIfProdottoExist(prodotto);
                if (!res) continue;
                String categoria = this.ricerca.getCategoriaProdottofromProdotto(prodotto);
                String um = this.ricerca.getUMfromCategoriaProdotto(categoria);
                String sian = this.ricerca.getSianAnaProdotto(prodotto);
                String stato_fisico = "";
                double volume_nominale = 0.0;
                if (sian.contains("#ERR")) continue;
                JSONArray ar = this.jsonUtil.strJsonToJSONArray(sian);
                for (int k2 = 0; k2 < ar.length(); ++k2) {
                    JSONObject o = ar.getJSONObject(k2);
                    volume_nominale = o.getDouble("sian_volume_nominale");
                    stato_fisico = o.getString("sian_cod_stato_fisico");
                }
                String lel = this.ricerca.getMassaFromProdotto(prodotto);
                double massa_volumica = 0.0;
                Double Hlitri = 0.0;
                if (lel.contains("#ERR")) continue;
                JSONArray arr = this.jsonUtil.strJsonToJSONArray(lel);
                for (int l = 0; l < arr.length(); ++l) {
                    JSONObject rec = arr.getJSONObject(l);
                    massa_volumica = rec.getDouble("sian_massa_volumica");
                }
                int id_vasoCollegato = 0;
                int id_vasca = 0;
                String prodotto_vasca = "";
                double qta_vasca = 0.0;
                int id_lotto = 0;
                String codice_lotto = "";
                String codice_artgestionale = "";
                double qta_lotto = 0.0;
                if (id != id_testata || ((ColumnDocumentiRighe)this.lista_documenti_righe.get(j)).getAzienda() != FXMLDocumentController.GLOBAL_AZIENDA || ((ColumnDocumentiRighe)this.lista_documenti_righe.get(j)).getSotto_azienda() != FXMLDocumentController.GLOBAL_SOTTOAZZ || ((ColumnDocumentiRighe)this.lista_documenti_righe.get(j)).getIcqrf() != FXMLDocumentController.GLOBAL_ICQRF || ((ColumnDocumentiRighe)this.lista_documenti_righe.get(j)).getCodice_committente() != FXMLDocumentController.GLOBAL_CODCOMM) continue;
                strSQL.add("INSERT INTO c_operazioni (azienda,sotto_az,icqrf,cod_committente,cali,cod_oper,data_oper,mx_doc_sigla,mx_doc_ser,mx_doc_num,mx_doc_causale,mx_doc_clifor,mx_doc_magazzino,mx_doc_cli_cognome,mx_doc_cli_nome,mx_doc_cli_ragsoc,mx_doc_cli_indirizzo,mx_doc_cli_cap,mx_doc_cli_cod_istat,mx_doc_cli_cod_iso,mx_doc_cli_cod_fiscale,mx_doc_cli_piva,mx_doc_cli_pers_giuridica,mx_doc_cli_note,mx_doc_cli_tipo) VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)");
                tipoSQL.add("insert");
                lastID.add(false);
                lenghtBidimensionalArray.add(25);
                tipo_ins[iterator][0] = "string";
                tipo_ins[iterator][1] = "string";
                tipo_ins[iterator][2] = "string";
                tipo_ins[iterator][3] = "string";
                tipo_ins[iterator][4] = "double";
                tipo_ins[iterator][5] = "string";
                tipo_ins[iterator][6] = "date";
                tipo_ins[iterator][7] = "string";
                tipo_ins[iterator][8] = "int";
                tipo_ins[iterator][9] = "int";
                tipo_ins[iterator][10] = "int";
                tipo_ins[iterator][11] = "string";
                tipo_ins[iterator][12] = "int";
                tipo_ins[iterator][13] = "string";
                tipo_ins[iterator][14] = "string";
                tipo_ins[iterator][15] = "string";
                tipo_ins[iterator][16] = "string";
                tipo_ins[iterator][17] = "string";
                tipo_ins[iterator][18] = "string";
                tipo_ins[iterator][19] = "string";
                tipo_ins[iterator][20] = "string";
                tipo_ins[iterator][21] = "string";
                tipo_ins[iterator][22] = "string";
                tipo_ins[iterator][23] = "string";
                tipo_ins[iterator][24] = "string";
                valore[iterator][0] = azienda;
                valore[iterator][1] = sotto_az;
                valore[iterator][2] = icqrf;
                valore[iterator][3] = codice_committente;
                valore[iterator][4] = "0";
                valore[iterator][5] = codice_operazione;
                valore[iterator][6] = data_operazione;
                valore[iterator][7] = sigla_documento;
                valore[iterator][8] = serie_documento + "";
                valore[iterator][9] = numero_documento + "";
                valore[iterator][11] = codCliente;
                valore[iterator][12] = codice_magazzino + "";
                valore[iterator][13] = cognomeCli;
                valore[iterator][14] = nomeCli;
                valore[iterator][15] = rag_soc;
                valore[iterator][16] = indirizzoCli;
                valore[iterator][17] = capCli;
                valore[iterator][18] = codiceIstat;
                valore[iterator][19] = codiceISO;
                valore[iterator][20] = codiceFiscale;
                valore[iterator][21] = pivaCli;
                valore[iterator][22] = persona_giuridica;
                valore[iterator][23] = note_documento;
                valore[iterator][24] = tipo_cliente;
                ++iterator;
                lastID.add(false);
                tipoSQL.add("insert");
                strSQL.add("SET @id_oper:=(LAST_INSERT_ID());");
                lenghtBidimensionalArray.add(0);
                tipo_ins[iterator][0] = "";
                valore[iterator][0] = "";
                ++iterator;
                if (um.toLowerCase().equals("l")) {
                    strSQL.add("INSERT INTO c_movimenti (azienda,sotto_az,id_oper,tipo_mov,cod_tipo_vino,num_prot_ido,confez,volume,qta,litri,cod_stato_fisico,icqrf,prod_stato,ente_cert,data_ido,cod_committente) VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)");
                    tipoSQL.add("insert");
                    lenghtBidimensionalArray.add(16);
                    lastID.add(false);
                    tipo_ins[iterator][0] = "string";
                    tipo_ins[iterator][1] = "string";
                    tipo_ins[iterator][2] = "int";
                    tipo_ins[iterator][3] = "string";
                    tipo_ins[iterator][4] = "string";
                    tipo_ins[iterator][5] = "string";
                    tipo_ins[iterator][6] = "double";
                    tipo_ins[iterator][7] = "double";
                    tipo_ins[iterator][8] = "double";
                    tipo_ins[iterator][9] = "double";
                    tipo_ins[iterator][10] = "string";
                    tipo_ins[iterator][11] = "string";
                    tipo_ins[iterator][12] = "string";
                    tipo_ins[iterator][13] = "string";
                    tipo_ins[iterator][14] = "date";
                    tipo_ins[iterator][15] = "string";
                    valore[iterator][0] = azienda;
                    valore[iterator][1] = sotto_az;
                    valore[iterator][2] = "@id_oper";
                    valore[iterator][3] = "C";
                    valore[iterator][4] = prodotto_vasca;
                    valore[iterator][5] = numero_protocollo;
                    valore[iterator][6] = stato_fisico.equals("1") ? "0" : confezioni + "";
                    valore[iterator][7] = volume_nominale + "";
                    if (codice_operazione.toUpperCase().equals("VE")) {
                        valore[iterator][8] = -1.0 * qta_riga + "";
                        valore[iterator][9] = -1.0 * qta_riga + "";
                    } else if (codice_operazione.toUpperCase().equals("AQ")) {
                        valore[iterator][8] = qta_riga + "";
                        valore[iterator][9] = qta_riga + "";
                    } else if (codice_operazione.toUpperCase().equals("AU")) {
                        valore[iterator][8] = -1.0 * qta_riga + "";
                        valore[iterator][9] = -1.0 * qta_riga + "";
                    }
                    valore[iterator][10] = stato_fisico + "";
                    valore[iterator][11] = icqrf;
                    valore[iterator][12] = "B";
                    valore[iterator][13] = ente_cert;
                    valore[iterator][14] = data_cert;
                    valore[iterator][15] = codice_committente;
                    ++iterator;
                } else if (um.toLowerCase().equals("kg")) {
                    strSQL.add("INSERT INTO c_movimenti (azienda,sotto_az,id_oper,tipo_mov,cod_tipo_vino,num_prot_ido,confez,volume,qta,litri,cod_stato_fisico,icqrf,prod_stato,ente_cert,data_ido,cod_committente) VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)");
                    tipoSQL.add("insert");
                    lenghtBidimensionalArray.add(16);
                    lastID.add(false);
                    tipo_ins[iterator][0] = "string";
                    tipo_ins[iterator][1] = "string";
                    tipo_ins[iterator][2] = "int";
                    tipo_ins[iterator][3] = "string";
                    tipo_ins[iterator][4] = "string";
                    tipo_ins[iterator][5] = "string";
                    tipo_ins[iterator][6] = "double";
                    tipo_ins[iterator][7] = "double";
                    tipo_ins[iterator][8] = "double";
                    tipo_ins[iterator][9] = "double";
                    tipo_ins[iterator][10] = "string";
                    tipo_ins[iterator][11] = "string";
                    tipo_ins[iterator][12] = "string";
                    tipo_ins[iterator][13] = "string";
                    tipo_ins[iterator][14] = "date";
                    tipo_ins[iterator][15] = "string";
                    valore[iterator][0] = azienda;
                    valore[iterator][1] = sotto_az;
                    valore[iterator][2] = "@id_oper";
                    valore[iterator][3] = "C";
                    valore[iterator][4] = prodotto_vasca;
                    valore[iterator][5] = numero_protocollo;
                    valore[iterator][6] = "0";
                    valore[iterator][7] = volume_nominale + "";
                    if (codice_operazione.toUpperCase().equals("VE")) {
                        valore[iterator][8] = -1.0 * qta_riga + "";
                        valore[iterator][9] = -1.0 * (qta_riga * massa_volumica) + "";
                    } else if (codice_operazione.toUpperCase().equals("AQ")) {
                        valore[iterator][8] = qta_riga + "";
                        valore[iterator][9] = qta_riga * massa_volumica + "";
                    } else if (codice_operazione.toUpperCase().equals("AU")) {
                        valore[iterator][8] = -1.0 * qta_riga + "";
                        valore[iterator][9] = -1.0 * (qta_riga * massa_volumica) + "";
                    }
                    valore[iterator][10] = stato_fisico + "";
                    valore[iterator][11] = icqrf;
                    valore[iterator][12] = "B";
                    valore[iterator][13] = ente_cert;
                    valore[iterator][14] = data_cert;
                    valore[iterator][15] = codice_committente;
                    ++iterator;
                }
                lastID.add(false);
                tipoSQL.add("insert");
                strSQL.add("SET @id_mov:=(LAST_INSERT_ID());");
                lenghtBidimensionalArray.add(0);
                tipo_ins[iterator][0] = "";
                valore[iterator][0] = "";
                ++iterator;
                for (k = 0; k < this.lista_documenti_vasche.size(); ++k) {
                    int id_rigadavasca;
                    if (((ColumnDocumentiVasche)this.lista_documenti_vasche.get(j)).getAzienda() != FXMLDocumentController.GLOBAL_AZIENDA || ((ColumnDocumentiVasche)this.lista_documenti_vasche.get(j)).getSotto_azienda() != FXMLDocumentController.GLOBAL_SOTTOAZZ || ((ColumnDocumentiVasche)this.lista_documenti_vasche.get(j)).getIcqrf() != FXMLDocumentController.GLOBAL_ICQRF || ((ColumnDocumentiVasche)this.lista_documenti_vasche.get(j)).getCodice_committente() != FXMLDocumentController.GLOBAL_CODCOMM || (id_rigadavasca = ((ColumnDocumentiVasche)this.lista_documenti_vasche.get(k)).getId_riga()) != id_riga) continue;
                    id_vasoCollegato = ((ColumnDocumentiVasche)this.lista_documenti_vasche.get(k)).getId_vaso();
                    id_vasca = ((ColumnDocumentiVasche)this.lista_documenti_vasche.get(k)).getId();
                    prodotto_vasca = ((ColumnDocumentiVasche)this.lista_documenti_vasche.get(k)).getCodice_prodotto();
                    qta_vasca = ((ColumnDocumentiVasche)this.lista_documenti_vasche.get(k)).getQta();
                    strSQL.add("INSERT INTO gen_vasi_vinari_mov (azienda,sotto_az,id_mov,id_vaso,tipo_mov,cod_oper,cod_tipo_vino,qta_mov,icqrf,cod_committente) VALUES (?,?,?,?,?,?,?,?,?,?)");
                    tipoSQL.add("insert");
                    lenghtBidimensionalArray.add(10);
                    lastID.add(false);
                    tipo_ins[iterator][0] = "string";
                    tipo_ins[iterator][1] = "string";
                    tipo_ins[iterator][2] = "int";
                    tipo_ins[iterator][3] = "int";
                    tipo_ins[iterator][4] = "int";
                    tipo_ins[iterator][5] = "string";
                    tipo_ins[iterator][6] = "string";
                    tipo_ins[iterator][7] = "double";
                    tipo_ins[iterator][8] = "string";
                    tipo_ins[iterator][9] = "string";
                    valore[iterator][0] = azienda;
                    valore[iterator][1] = sotto_az;
                    valore[iterator][2] = "@id_mov";
                    valore[iterator][3] = id_vasca + "";
                    valore[iterator][4] = "0";
                    valore[iterator][5] = codice_operazione;
                    valore[iterator][6] = prodotto_vasca;
                    if (codice_operazione.toUpperCase().equals("VE")) {
                        valore[iterator][7] = -1.0 * qta_vasca + "";
                    } else if (codice_operazione.toUpperCase().equals("AQ")) {
                        valore[iterator][7] = qta_vasca + "";
                    } else if (codice_operazione.toUpperCase().equals("AU")) {
                        valore[iterator][7] = -1.0 * qta_vasca + "";
                    }
                    valore[iterator][8] = icqrf;
                    valore[iterator][9] = codice_committente;
                    ++iterator;
                }
                for (k = 0; k < this.lista_documenti_lotti.size(); ++k) {
                    int id_rigadalotto;
                    if (((ColumnDocumentiLotti)this.lista_documenti_lotti.get(j)).getAzienda() != FXMLDocumentController.GLOBAL_AZIENDA || ((ColumnDocumentiLotti)this.lista_documenti_lotti.get(j)).getSotto_azienda() != FXMLDocumentController.GLOBAL_SOTTOAZZ || ((ColumnDocumentiLotti)this.lista_documenti_lotti.get(j)).getIcqrf() != FXMLDocumentController.GLOBAL_ICQRF || ((ColumnDocumentiLotti)this.lista_documenti_lotti.get(j)).getCodice_committente() != FXMLDocumentController.GLOBAL_CODCOMM || id_riga != (id_rigadalotto = ((ColumnDocumentiLotti)this.lista_documenti_lotti.get(k)).getId_riga())) continue;
                    id_lotto = ((ColumnDocumentiLotti)this.lista_documenti_lotti.get(k)).getId();
                    codice_lotto = ((ColumnDocumentiLotti)this.lista_documenti_lotti.get(k)).getCodice_lotto();
                    codice_artgestionale = ((ColumnDocumentiLotti)this.lista_documenti_lotti.get(k)).getCodice_articolo_gestionale();
                    qta_lotto = ((ColumnDocumentiLotti)this.lista_documenti_lotti.get(k)).getQta();
                    strSQL.add("INSERT INTO c_movimenti_lotti (azienda,sotto_az,icqrf,cod_committente,id_mov,cod_lotto,qta,mx_art) VALUES (?,?,?,?,?,?,?,?)");
                    tipoSQL.add("insert");
                    lenghtBidimensionalArray.add(8);
                    lastID.add(false);
                    tipo_ins[iterator][0] = "string";
                    tipo_ins[iterator][1] = "string";
                    tipo_ins[iterator][2] = "string";
                    tipo_ins[iterator][3] = "string";
                    tipo_ins[iterator][4] = "int";
                    tipo_ins[iterator][5] = "string";
                    tipo_ins[iterator][6] = "double";
                    tipo_ins[iterator][7] = "string";
                    valore[iterator][0] = azienda;
                    valore[iterator][1] = sotto_az;
                    valore[iterator][2] = icqrf;
                    valore[iterator][3] = codice_committente;
                    valore[iterator][4] = "@id_mov";
                    valore[iterator][5] = codice_lotto;
                    if (codice_operazione.toUpperCase().equals("VE")) {
                        valore[iterator][6] = -1.0 * qta_lotto + "";
                    } else if (codice_operazione.toUpperCase().equals("AQ")) {
                        valore[iterator][6] = qta_lotto + "";
                    } else if (codice_operazione.toUpperCase().equals("AU")) {
                        valore[iterator][6] = -1.0 * qta_lotto + "";
                    }
                    valore[iterator][7] = codice_artgestionale;
                    ++iterator;
                }
            }
        }
        String strJson = this.util.makeStringJsonDB("ON", tipoSQL, strSQL, tipo_ins, valore, lastID, lenghtBidimensionalArray);
        data_select = this.sk1Comm.ServerEsecuteRequest(FXMLDocumentController.GLOBAL_IP, FXMLDocumentController.GLOBAL_PORT, "dbInteraction#@" + strJson);
        ret = !data_select.contains("#ERR:") ? "#OK" : data_select;
        return ret;
    }

    private String ImportFileTestata(String csvFile) {
        this.lista_documenti_testata.clear();
        String ret = "";
        String line = "";
        String cvsSplitBy = ";";
        try (BufferedReader br = new BufferedReader(new FileReader(csvFile));){
            int count = 0;
            while ((line = br.readLine()) != null) {
                String[] testata;
                if (count > 0 && (testata = line.split(cvsSplitBy, -1)).length == 25) {
                    try {
                        int id = Integer.parseInt(testata[0]);
                        String codice_operazione = testata[1];
                        String azienda = testata[2];
                        String sotto_azienda = testata[3];
                        String icqrf = testata[4];
                        String cod_committente = testata[5];
                        String data_operazione = testata[6];
                        String sigla_documento = testata[7];
                        int serie_documento = Integer.parseInt(testata[8]);
                        int numero_documento = Integer.parseInt(testata[9]);
                        int causale_documento = Integer.parseInt(testata[10]);
                        int magazzino_documento = Integer.parseInt(testata[11]);
                        String codiceCli_documento = testata[12];
                        String personaGiuridica_documento = testata[13];
                        String ragsoc_documento = testata[14];
                        String nomeCli_documento = testata[15];
                        String cognomeCli_documento = testata[16];
                        String indirizzoCli_documento = testata[17];
                        String capCli_documento = testata[18];
                        String codiceIstat_documento = testata[19];
                        String codiceISO_documento = testata[20];
                        String codiceFiscale = testata[21];
                        String pivaCli = testata[22];
                        String note_documento = testata[23];
                        String tipoCli_documento = testata[24];
                        if (codice_operazione.equals("")) {
                            ret = "Codice operazione mancante  (Riga:" + count + " Foglio: Testata)";
                            break;
                        }
                        if (azienda.equals("")) {
                            ret = "Azienda mancante  (Riga:" + count + " Foglio: Testata)";
                            break;
                        }
                        if (sotto_azienda.equals("")) {
                            ret = "Sotto azienda mancante  (Riga:" + count + " Foglio: Testata)";
                            break;
                        }
                        if (icqrf.equals("")) {
                            ret = "ICQRF mancante  (Riga:" + count + " Foglio: Testata)";
                            break;
                        }
                        if (cod_committente.equals("")) {
                            ret = "Codice committente mancante  (Riga:" + count + " Foglio: Testata)";
                            break;
                        }
                        if (data_operazione.equals("")) {
                            ret = "Data operazione mancante  (Riga:" + count + " Foglio: Testata)";
                            break;
                        }
                        data_operazione = String.valueOf(LocalDate.parse(data_operazione));
                        this.lista_documenti_testata.add((Object)new ColumnDocumentiTestata(id, codice_operazione, azienda, sotto_azienda, icqrf, cod_committente, data_operazione, sigla_documento, serie_documento, numero_documento, causale_documento, magazzino_documento, codiceCli_documento, personaGiuridica_documento, ragsoc_documento, nomeCli_documento, cognomeCli_documento, indirizzoCli_documento, capCli_documento, codiceIstat_documento, codiceISO_documento, codiceIstat_documento, tipoCli_documento, note_documento, tipoCli_documento));
                    }
                    catch (Exception ex) {
                        ret = ex.toString() + " (Riga:" + count + "";
                        break;
                    }
                }
                ++count;
            }
        }
        catch (IOException ex) {
            ret = ex.toString();
        }
        return ret;
    }

    private String ImportFileRighe(String csvFile) {
        this.lista_documenti_righe.clear();
        String ret = "";
        String line = "";
        String cvsSplitBy = ";";
        try (BufferedReader br = new BufferedReader(new FileReader(csvFile));){
            int count = 0;
            while ((line = br.readLine()) != null) {
                String[] testata;
                if (count > 0 && (testata = line.split(cvsSplitBy, -1)).length == 15) {
                    try {
                        int id_testata = Integer.parseInt(testata[0]);
                        int id = Integer.parseInt(testata[1]);
                        String azienda = testata[2];
                        String sotto_azienda = testata[3];
                        String icqrf = testata[4];
                        String cod_committente = testata[5];
                        String tipo_movimento = testata[6];
                        String codice_prodotto = testata[7];
                        String nprotocollo_cert = testata[8];
                        int confezioni = Integer.parseInt(testata[9]);
                        Float volume_nominale = Float.valueOf(Float.parseFloat(testata[10]));
                        double qta = Double.parseDouble(testata[11]);
                        double litri = Double.parseDouble(testata[12]);
                        String data_cert = testata[13];
                        String ente_cert = testata[14];
                        if (azienda.equals("")) {
                            ret = "Azienda mancante  (Riga:" + count + " Foglio: Righe)";
                            break;
                        }
                        if (sotto_azienda.equals("")) {
                            ret = "Sotto azienda mancante  (Riga:" + count + " Foglio: Righe)";
                            break;
                        }
                        if (icqrf.equals("")) {
                            ret = "ICQRF mancante  (Riga:" + count + " Foglio: Righe)";
                            break;
                        }
                        if (cod_committente.equals("")) {
                            ret = "Codice committente mancante  (Riga:" + count + " Foglio: Righe)";
                            break;
                        }
                        if (tipo_movimento.equals("")) {
                            ret = "Tipo movimento mancante  (Riga:" + count + " Foglio: Righe)";
                            break;
                        }
                        if (codice_prodotto.equals("")) {
                            ret = "Codice prodotto mancante  (Riga:" + count + " Foglio: Righe)";
                            break;
                        }
                        this.lista_documenti_righe.add((Object)new ColumnDocumentiRighe(id_testata, id, azienda, sotto_azienda, icqrf, cod_committente, tipo_movimento, codice_prodotto, nprotocollo_cert, confezioni, volume_nominale, qta, litri, data_cert, ente_cert));
                    }
                    catch (Exception ex) {
                        ret = ex.toString() + " (Riga:" + count + " Foglio: Righe)";
                        break;
                    }
                }
                ++count;
            }
        }
        catch (IOException ex) {
            ret = ex.toString();
        }
        return ret;
    }

    private String ImportFileVasche(String csvFile) {
        this.lista_documenti_vasche.clear();
        String ret = "";
        String line = "";
        String cvsSplitBy = ";";
        try (BufferedReader br = new BufferedReader(new FileReader(csvFile));){
            int count = 0;
            while ((line = br.readLine()) != null) {
                String[] testata;
                if (count > 0 && (testata = line.split(cvsSplitBy, -1)).length == 9) {
                    try {
                        int id_riga = Integer.parseInt(testata[0]);
                        int id_vaso = Integer.parseInt(testata[1]);
                        int id = Integer.parseInt(testata[2]);
                        String azienda = testata[3];
                        String sotto_azienda = testata[4];
                        String icqrf = testata[5];
                        String cod_committente = testata[6];
                        String codice_prodotto = testata[7];
                        double qta = Double.parseDouble(testata[8]);
                        if (azienda.equals("")) {
                            ret = "Azienda mancante  (Riga:" + count + " Foglio: Righe)";
                            break;
                        }
                        if (sotto_azienda.equals("")) {
                            ret = "Sotto azienda mancante  (Riga:" + count + " Foglio: Righe)";
                            break;
                        }
                        if (icqrf.equals("")) {
                            ret = "ICQRF mancante  (Riga:" + count + " Foglio: Righe)";
                            break;
                        }
                        if (cod_committente.equals("")) {
                            ret = "Codice committente mancante  (Riga:" + count + " Foglio: Righe)";
                            break;
                        }
                        if (codice_prodotto.equals("")) {
                            ret = "Codice prodotto mancante  (Riga:" + count + " Foglio: Righe)";
                            break;
                        }
                        this.lista_documenti_vasche.add((Object)new ColumnDocumentiVasche(id_riga, id_vaso, id, azienda, sotto_azienda, icqrf, cod_committente, codice_prodotto, qta));
                    }
                    catch (Exception ex) {
                        ret = ex.toString() + " (Riga:" + count + " Foglio: Righe)";
                        break;
                    }
                }
                ++count;
            }
        }
        catch (IOException ex) {
            ret = ex.toString();
        }
        return ret;
    }

    private String ImportFileLotti(String csvFile) {
        this.lista_documenti_lotti.clear();
        String ret = "";
        String line = "";
        String cvsSplitBy = ";";
        try (BufferedReader br = new BufferedReader(new FileReader(csvFile));){
            int count = 0;
            while ((line = br.readLine()) != null) {
                String[] testata;
                if (count > 0 && (testata = line.split(cvsSplitBy, -1)).length == 9) {
                    try {
                        int id_riga = Integer.parseInt(testata[0]);
                        int id = Integer.parseInt(testata[1]);
                        String azienda = testata[2];
                        String sotto_azienda = testata[3];
                        String icqrf = testata[4];
                        String cod_committente = testata[5];
                        String codice_lotto = testata[6];
                        String codice_articolo_gestionale = testata[7];
                        double qta = Double.parseDouble(testata[8]);
                        if (azienda.equals("")) {
                            ret = "Azienda mancante  (Riga:" + count + " Foglio: Righe)";
                            break;
                        }
                        if (sotto_azienda.equals("")) {
                            ret = "Sotto azienda mancante  (Riga:" + count + " Foglio: Righe)";
                            break;
                        }
                        if (icqrf.equals("")) {
                            ret = "ICQRF mancante  (Riga:" + count + " Foglio: Righe)";
                            break;
                        }
                        if (cod_committente.equals("")) {
                            ret = "Codice committente mancante  (Riga:" + count + " Foglio: Righe)";
                            break;
                        }
                        if (codice_lotto.equals("")) {
                            ret = "Codice prodotto mancante  (Riga:" + count + " Foglio: Righe)";
                            break;
                        }
                        this.lista_documenti_lotti.add((Object)new ColumnDocumentiLotti(id_riga, id, azienda, sotto_azienda, icqrf, cod_committente, codice_lotto, codice_articolo_gestionale, qta));
                    }
                    catch (Exception ex) {
                        ret = ex.toString() + " (Riga:" + count + " Foglio: Righe)";
                        break;
                    }
                }
                ++count;
            }
        }
        catch (IOException ex) {
            ret = ex.toString();
        }
        return ret;
    }

    private static void configureFileChooser(FileChooser fileChooser) {
        fileChooser.setTitle("IMPORT FILE DOCUMENTI WBS");
        fileChooser.setInitialDirectory(new File(System.getProperty("user.home")));
        fileChooser.getExtensionFilters().addAll((Object[])new FileChooser.ExtensionFilter[]{new FileChooser.ExtensionFilter("CSV", new String[]{"*.csv"})});
    }
}

