/*
 * Decompiled with CFR 0.152.
 */
package vin.Class;

import javafx.application.Application;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.concurrent.Worker;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.ButtonBuilder;
import javafx.scene.control.LabelBuilder;
import javafx.scene.effect.BoxBlur;
import javafx.scene.effect.Effect;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.HBoxBuilder;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.web.WebView;
import javafx.stage.Modality;
import javafx.stage.Stage;
import javafx.stage.StageStyle;
import javafx.stage.Window;

public class ModalConfirmExample
extends Application {
    public static void main(String[] args) {
        ModalConfirmExample.launch((String[])args);
    }

    public void start(final Stage primaryStage) {
        primaryStage.setTitle("Modal Confirm Example");
        final WebView webView = new WebView();
        webView.getEngine().load("http://docs.oracle.com/javafx/");
        primaryStage.setScene(new Scene((Parent)webView));
        primaryStage.show();
        final Stage dialog = new Stage(StageStyle.TRANSPARENT);
        dialog.initModality(Modality.WINDOW_MODAL);
        dialog.initOwner((Window)primaryStage);
        dialog.setScene(new Scene((Parent)((HBoxBuilder)((HBoxBuilder)HBoxBuilder.create().styleClass(new String[]{"modal-dialog"})).children(new Node[]{((LabelBuilder)LabelBuilder.create().text("Will you like this page?")).build(), ((ButtonBuilder)((ButtonBuilder)ButtonBuilder.create().text("Yes")).defaultButton(true).onAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent actionEvent) {
                System.out.println("Liked: " + webView.getEngine().getTitle());
                primaryStage.getScene().getRoot().setEffect(null);
                dialog.close();
            }
        })).build(), ((ButtonBuilder)((ButtonBuilder)ButtonBuilder.create().text("No")).cancelButton(true).onAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent actionEvent) {
                System.out.println("Disliked: " + webView.getEngine().getTitle());
                primaryStage.getScene().getRoot().setEffect(null);
                dialog.close();
            }
        })).build()})).build(), (Paint)Color.TRANSPARENT));
        dialog.getScene().getStylesheets().add((Object)((Object)((Object)this)).getClass().getResource("modal-dialog.css").toExternalForm());
        Parent root = dialog.getScene().getRoot();
        final Delta dragDelta = new Delta();
        root.setOnMousePressed((EventHandler)new EventHandler<MouseEvent>(){

            public void handle(MouseEvent mouseEvent) {
                dragDelta.x = dialog.getX() - mouseEvent.getScreenX();
                dragDelta.y = dialog.getY() - mouseEvent.getScreenY();
            }
        });
        root.setOnMouseDragged((EventHandler)new EventHandler<MouseEvent>(){

            public void handle(MouseEvent mouseEvent) {
                dialog.setX(mouseEvent.getScreenX() + dragDelta.x);
                dialog.setY(mouseEvent.getScreenY() + dragDelta.y);
            }
        });
        webView.getEngine().getLoadWorker().stateProperty().addListener((ChangeListener)new ChangeListener<Worker.State>(){

            public void changed(ObservableValue<? extends Worker.State> observableValue, Worker.State state, Worker.State newState) {
                if (newState.equals((Object)Worker.State.SUCCEEDED)) {
                    primaryStage.getScene().getRoot().setEffect((Effect)new BoxBlur());
                    dialog.show();
                }
            }
        });
    }

    class Delta {
        double x;
        double y;

        Delta() {
        }
    }
}

