/*
 * Decompiled with CFR 0.152.
 */
package vin.Class;

import javafx.application.Platform;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.scene.control.ComboBox;
import javafx.scene.control.TextField;

public class FilteredComboBox
extends ComboBox<String> {
    private ObservableList<String> initialList;
    private ObservableList<String> bufferList = FXCollections.observableArrayList();
    private String previousValue = "";

    public FilteredComboBox(ObservableList<String> items) {
        super(items);
        super.setEditable(true);
        this.initialList = items;
        this.configAutoFilterListener();
    }

    private void configAutoFilterListener() {
        final FilteredComboBox currentInstance = this;
        this.getEditor().textProperty().addListener((ChangeListener)new ChangeListener<String>(){

            public void changed(ObservableValue<? extends String> observable, String oldValue, String newValue) {
                FilteredComboBox.this.previousValue = oldValue;
                TextField editor = currentInstance.getEditor();
                String selected = (String)currentInstance.getSelectionModel().getSelectedItem();
                if (selected == null || !selected.equals(editor.getText())) {
                    FilteredComboBox.this.filterItems(newValue, (ComboBox<String>)currentInstance);
                    currentInstance.show();
                    if (currentInstance.getItems().size() == 1) {
                        FilteredComboBox.this.setUserInputToOnlyOption((ComboBox<String>)currentInstance, editor);
                    }
                }
            }
        });
    }

    private void filterItems(String filter, ComboBox<String> comboBox) {
        if (filter.startsWith(this.previousValue) && !this.previousValue.isEmpty()) {
            ObservableList<String> filteredList = this.readFromList(filter, this.bufferList);
            this.bufferList.clear();
            this.bufferList = filteredList;
        } else {
            this.bufferList = this.readFromList(filter, this.initialList);
        }
        comboBox.setItems(this.bufferList);
    }

    private ObservableList<String> readFromList(String filter, ObservableList<String> originalList) {
        ObservableList filteredList = FXCollections.observableArrayList();
        for (String item : originalList) {
            if (!item.toLowerCase().startsWith(filter.toLowerCase())) continue;
            filteredList.add((Object)item);
        }
        return filteredList;
    }

    private void setUserInputToOnlyOption(ComboBox<String> currentInstance, final TextField editor) {
        final String onlyOption = (String)currentInstance.getItems().get(0);
        final String currentText = editor.getText();
        if (onlyOption.length() > currentText.length()) {
            editor.setText(onlyOption);
            Platform.runLater((Runnable)new Runnable(){

                @Override
                public void run() {
                    editor.selectRange(currentText.length(), onlyOption.length());
                }
            });
        }
    }
}

