/*
 * Decompiled with CFR 0.152.
 */
package vin.Class;

import java.util.ArrayList;
import java.util.Collection;
import javafx.application.Platform;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.scene.control.ComboBox;

public class FilterComboBox<T>
extends ComboBox<T> {
    private Collection<T> initialList = new ArrayList<T>();
    private final boolean startsWithCheck;

    public FilterComboBox(boolean startsWithCheck) {
        this.startsWithCheck = startsWithCheck;
        super.setEditable(true);
        this.configAutoFilterListener();
    }

    public FilterComboBox(ObservableList<T> items, boolean startsWithCheck) {
        super(items);
        this.startsWithCheck = startsWithCheck;
        super.setEditable(true);
        this.initialList = items;
        this.configAutoFilterListener();
    }

    public void setInitialItems(Collection<T> initial) {
        super.getItems().clear();
        super.getItems().addAll(initial);
        this.initialList = initial;
    }

    private void configAutoFilterListener() {
        this.getEditor().textProperty().addListener((ChangeListener)new ChangeListener<String>(){

            public void changed(ObservableValue<? extends String> observable, String oldValue, String newValue) {
                Object selected = FilterComboBox.this.getSelectionModel().getSelectedItem();
                if (selected == null || !FilterComboBox.this.getConverter().toString(selected).equals(FilterComboBox.this.getEditor().getText())) {
                    FilterComboBox.this.filterItems(newValue);
                    if (FilterComboBox.this.getItems().size() == 1) {
                        FilterComboBox.this.setUserInputToOnlyOption();
                        FilterComboBox.this.hide();
                    } else if (!FilterComboBox.this.getItems().isEmpty()) {
                        FilterComboBox.this.show();
                    }
                }
            }
        });
    }

    private void filterItems(String filter) {
        ObservableList filteredList = FXCollections.observableArrayList();
        for (T item : this.initialList) {
            if (this.startsWithCheck && this.getConverter().toString(item).toLowerCase().startsWith(filter.toLowerCase())) {
                filteredList.add(item);
                continue;
            }
            if (this.startsWithCheck || !this.getConverter().toString(item).toLowerCase().contains(filter.toLowerCase())) continue;
            filteredList.add(item);
        }
        this.setItems(filteredList);
    }

    private void setUserInputToOnlyOption() {
        String onlyOption = this.getConverter().toString(this.getItems().get(0));
        String currentText = this.getEditor().getText();
        if (onlyOption.length() > currentText.length()) {
            this.getEditor().setText(onlyOption);
            Platform.runLater((Runnable)new Runnable(){

                @Override
                public void run() {
                    FilterComboBox.this.getEditor().selectAll();
                }
            });
        }
    }
}

