/*
 * Decompiled with CFR 0.152.
 */
package vin.Class;

import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.event.EventHandler;
import javafx.scene.Node;
import javafx.scene.control.ContentDisplay;
import javafx.scene.control.Label;
import javafx.scene.control.TableCell;
import javafx.scene.control.TextField;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import vin.Class.ColumnTablePoolCompleta;
import vin.operazioni.TabGIINController;

public class EditingCellLottoGiacenza
extends TableCell<ColumnTablePoolCompleta, Double> {
    private TextField textField;
    private Label fieldControl;
    private Label fieldControl2;
    private Label fieldControl3;
    public String error = "";
    Double esistenza = 0.0;
    TabGIINController controller = null;

    public EditingCellLottoGiacenza(Label primoLabel, Label secondoLabel, Label terzoLabel, TabGIINController controller) {
        try {
            this.fieldControl = primoLabel;
            this.fieldControl2 = secondoLabel;
            this.fieldControl3 = terzoLabel;
            this.controller = controller;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void startEdit() {
        super.startEdit();
        if (this.textField == null) {
            this.createTextField();
        }
        this.setText(null);
        this.setGraphic((Node)this.textField);
        this.setContentDisplay(ContentDisplay.GRAPHIC_ONLY);
        this.textField.requestFocus();
    }

    public void cancelEdit() {
        super.cancelEdit();
        this.setText(String.valueOf(this.getItem()));
        this.setContentDisplay(ContentDisplay.TEXT_ONLY);
        this.setGraphic(null);
    }

    public void updateItem(Double item, boolean empty) {
        super.updateItem((Object)item, empty);
        if (empty) {
            this.setText(null);
            this.setGraphic(null);
        } else {
            String h = "";
            if (this.isEditing()) {
                if (this.textField != null) {
                    this.textField.setText(this.getString());
                }
                this.setText(null);
                this.setGraphic((Node)this.textField);
                this.setContentDisplay(ContentDisplay.GRAPHIC_ONLY);
            } else {
                this.setText(this.getString());
                this.setContentDisplay(ContentDisplay.TEXT_ONLY);
            }
        }
    }

    private void createTextField() {
        this.textField = new TextField(this.getString());
        this.textField.setMinWidth(this.getWidth() - this.getGraphicTextGap() * 2.0);
        this.textField.textProperty().addListener((ChangeListener)new ChangeListener<String>(){

            public void changed(ObservableValue<? extends String> observable, String oldValue, String newValue) {
                String val = newValue.replaceAll("[A-z,]", "");
                EditingCellLottoGiacenza.this.textField.setText(val);
            }
        });
        this.textField.setOnKeyReleased((EventHandler)new EventHandler<KeyEvent>(){

            public void handle(KeyEvent t) {
                if (t.getCode() == KeyCode.ENTER) {
                    EditingCellLottoGiacenza.this.commitEdit(Double.parseDouble(EditingCellLottoGiacenza.this.textField.getText()));
                    EditingCellLottoGiacenza.this.textField.setText("0.0");
                    Double valore = 0.0;
                    for (int i = 0; i < EditingCellLottoGiacenza.this.controller.lista_table_lotto_giacenza.size(); ++i) {
                        valore = valore + ((ColumnTablePoolCompleta)EditingCellLottoGiacenza.this.controller.lista_table_lotto_giacenza.get(i)).getColumn_nconfez();
                    }
                    EditingCellLottoGiacenza.this.fieldControl.setText(valore + "");
                    EditingCellLottoGiacenza.this.fieldControl2.setText(valore * Double.parseDouble(EditingCellLottoGiacenza.this.fieldControl3.getText()) + "");
                } else if (t.getCode() == KeyCode.ESCAPE) {
                    EditingCellLottoGiacenza.this.cancelEdit();
                    EditingCellLottoGiacenza.this.textField.setText("0.0");
                }
            }
        });
        this.textField.focusedProperty().addListener((ChangeListener)new ChangeListener<Boolean>(){

            public void changed(ObservableValue<? extends Boolean> observable, Boolean oldValue, Boolean newValue) {
                if (!newValue.booleanValue() && EditingCellLottoGiacenza.this.textField != null) {
                    EditingCellLottoGiacenza.this.commitEdit(Double.parseDouble(EditingCellLottoGiacenza.this.textField.getText()));
                    EditingCellLottoGiacenza.this.textField.setText("0.0");
                    Double valore = 0.0;
                    for (int i = 0; i < EditingCellLottoGiacenza.this.controller.lista_table_lotto_giacenza.size(); ++i) {
                        valore = valore + ((ColumnTablePoolCompleta)EditingCellLottoGiacenza.this.controller.lista_table_lotto_giacenza.get(i)).getColumn_nconfez();
                    }
                    EditingCellLottoGiacenza.this.fieldControl.setText(valore + "");
                    EditingCellLottoGiacenza.this.fieldControl2.setText(valore * Double.parseDouble(EditingCellLottoGiacenza.this.fieldControl3.getText()) + "");
                }
            }
        });
    }

    private String getString() {
        return this.getItem() == null ? "" : ((Double)this.getItem()).toString();
    }
}

