/*
 * Decompiled with CFR 0.152.
 */
package vin.Class;

import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.event.EventHandler;
import javafx.scene.Node;
import javafx.scene.control.ContentDisplay;
import javafx.scene.control.TableCell;
import javafx.scene.control.TextField;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import vin.Class.ColumnTablePoolCompleta;
import vin.Uility.Utility;
import vin.controller.ToastFXMessages;

public class EditingCellIntegerAPool
extends TableCell<ColumnTablePoolCompleta, String> {
    private TextField textField;
    public String error = "";
    ToastFXMessages tx = new ToastFXMessages();
    Utility util;
    Double esistenza = 0.0;

    public EditingCellIntegerAPool() {
        try {
            this.util = new Utility();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void startEdit() {
        super.startEdit();
        if (this.textField == null) {
            this.createTextField();
        }
        this.setText(null);
        this.setGraphic((Node)this.textField);
        this.setContentDisplay(ContentDisplay.GRAPHIC_ONLY);
        this.textField.requestFocus();
    }

    public void cancelEdit() {
        super.cancelEdit();
        this.setText(String.valueOf(this.getItem()));
        this.setContentDisplay(ContentDisplay.TEXT_ONLY);
        this.setGraphic(null);
    }

    public void updateItem(String item, boolean empty) {
        super.updateItem((Object)item, empty);
        if (empty) {
            this.setText(null);
            this.setGraphic(null);
        } else {
            String h = "";
            if (this.isEditing()) {
                if (this.textField != null) {
                    this.textField.setText(this.getString());
                }
                this.setText(null);
                this.setGraphic((Node)this.textField);
                this.setContentDisplay(ContentDisplay.GRAPHIC_ONLY);
            } else {
                this.setText(this.getString());
                this.setContentDisplay(ContentDisplay.TEXT_ONLY);
            }
        }
    }

    private void createTextField() {
        this.textField = new TextField(this.getString());
        this.textField.setMinWidth(this.getWidth() - this.getGraphicTextGap() * 2.0);
        this.textField.textProperty().addListener((ChangeListener)new ChangeListener<String>(){

            public void changed(ObservableValue<? extends String> observable, String oldValue, String newValue) {
                String val = newValue.replaceAll("[A-z,.:;*/_+-]", "");
                EditingCellIntegerAPool.this.textField.setText(val);
            }
        });
        this.textField.setOnKeyReleased((EventHandler)new EventHandler<KeyEvent>(){

            public void handle(KeyEvent t) {
                if (t.getCode() == KeyCode.ENTER) {
                    EditingCellIntegerAPool.this.getTableView().requestFocus();
                } else if (t.getCode() == KeyCode.ESCAPE) {
                    EditingCellIntegerAPool.this.cancelEdit();
                    EditingCellIntegerAPool.this.textField.setText("0");
                }
            }
        });
        this.textField.focusedProperty().addListener((ChangeListener)new ChangeListener<Boolean>(){

            public void changed(ObservableValue<? extends Boolean> observable, Boolean oldValue, Boolean newValue) {
                if (!newValue.booleanValue() && EditingCellIntegerAPool.this.textField != null) {
                    int intero;
                    String val = EditingCellIntegerAPool.this.textField.getText();
                    if (!val.equals("") && (intero = Integer.parseInt(val)) > 0) {
                        String rt = ((ColumnTablePoolCompleta)EditingCellIntegerAPool.this.getTableView().getSelectionModel().getSelectedItem()).getColumn_da();
                        if (rt.equals("")) {
                            rt = "0";
                        }
                        int diff = intero - Integer.parseInt(rt);
                        int res = diff + 1;
                        EditingCellIntegerAPool.this.commitEdit(intero + "");
                        ((ColumnTablePoolCompleta)EditingCellIntegerAPool.this.getTableView().getSelectionModel().getSelectedItem()).setColumn_totale(String.valueOf(res));
                        ((ColumnTablePoolCompleta)EditingCellIntegerAPool.this.getTableView().getSelectionModel().getSelectedItem()).setColumn_a(val);
                        EditingCellIntegerAPool.this.getTableView().refresh();
                    }
                    EditingCellIntegerAPool.this.textField.setText("0");
                }
            }
        });
    }

    private String getString() {
        return this.getItem() == null ? "" : ((String)this.getItem()).toString();
    }
}

