/*
 * Decompiled with CFR 0.152.
 */
package vin.Class;

import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.event.EventHandler;
import javafx.scene.Node;
import javafx.scene.control.ContentDisplay;
import javafx.scene.control.Label;
import javafx.scene.control.TableCell;
import javafx.scene.control.TextField;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import vin.Class.ColumnTableFascetteGiacenza;
import vin.Uility.Utility;
import vin.controller.ToastFXMessages;

public class EditingCellIntegerAFascette
extends TableCell<ColumnTableFascetteGiacenza, Integer> {
    private TextField textField;
    private TextField fieldControl;
    public String error = "";
    ToastFXMessages tx = new ToastFXMessages();
    Label qta_tot;
    Label qta_totlitri;
    Utility util;
    Double esistenza = 0.0;

    public EditingCellIntegerAFascette(TextField controlField, Label qta_totfa, Label qta_totlitri) {
        try {
            this.util = new Utility();
            this.fieldControl = controlField;
            this.qta_tot = qta_totfa;
            this.qta_totlitri = qta_totlitri;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void startEdit() {
        super.startEdit();
        if (this.textField == null) {
            this.createTextField();
        }
        this.setText(null);
        this.setGraphic((Node)this.textField);
        this.setContentDisplay(ContentDisplay.GRAPHIC_ONLY);
        this.textField.requestFocus();
    }

    public void cancelEdit() {
        super.cancelEdit();
        this.setText(String.valueOf(this.getItem()));
        this.setContentDisplay(ContentDisplay.TEXT_ONLY);
        this.setGraphic(null);
    }

    public void updateItem(Integer item, boolean empty) {
        super.updateItem((Object)item, empty);
        if (empty) {
            this.setText(null);
            this.setGraphic(null);
        } else {
            String h = "";
            if (this.isEditing()) {
                if (this.textField != null) {
                    this.textField.setText(this.getString());
                }
                this.setText(null);
                this.setGraphic((Node)this.textField);
                this.setContentDisplay(ContentDisplay.GRAPHIC_ONLY);
            } else {
                this.setText(this.getString());
                this.setContentDisplay(ContentDisplay.TEXT_ONLY);
            }
        }
    }

    private void createTextField() {
        this.textField = new TextField(this.getString());
        this.textField.setMinWidth(this.getWidth() - this.getGraphicTextGap() * 2.0);
        this.textField.textProperty().addListener((ChangeListener)new ChangeListener<String>(){

            public void changed(ObservableValue<? extends String> observable, String oldValue, String newValue) {
                String val = newValue.replaceAll("[A-z,.:;*/_+-]", "");
                EditingCellIntegerAFascette.this.textField.setText(val);
            }
        });
        this.textField.setOnKeyReleased((EventHandler)new EventHandler<KeyEvent>(){

            public void handle(KeyEvent t) {
                if (t.getCode() == KeyCode.ENTER) {
                    if (EditingCellIntegerAFascette.this.textField.getText().equals("") || Integer.parseInt(EditingCellIntegerAFascette.this.textField.getText()) > 0) {
                        // empty if block
                    }
                    EditingCellIntegerAFascette.this.textField.setText("0.0");
                } else if (t.getCode() == KeyCode.ESCAPE) {
                    EditingCellIntegerAFascette.this.cancelEdit();
                    EditingCellIntegerAFascette.this.textField.setText("0.0");
                }
            }
        });
        this.textField.focusedProperty().addListener((ChangeListener)new ChangeListener<Boolean>(){

            public void changed(ObservableValue<? extends Boolean> observable, Boolean oldValue, Boolean newValue) {
                if (!newValue.booleanValue() && EditingCellIntegerAFascette.this.textField != null && Integer.parseInt(EditingCellIntegerAFascette.this.textField.getText()) > 0) {
                    EditingCellIntegerAFascette.this.textField.setText("");
                }
            }
        });
    }

    private String getString() {
        return this.getItem() == null ? "" : ((Integer)this.getItem()).toString();
    }
}

