/*
 * Decompiled with CFR 0.152.
 */
package vin.Class;

import java.io.IOException;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.event.EventHandler;
import javafx.scene.Node;
import javafx.scene.control.ContentDisplay;
import javafx.scene.control.TableCell;
import javafx.scene.control.TextField;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import vin.Class.ColumnTablePoolCompleta;
import vin.Uility.Utility;
import vin.controller.FXMLDocumentController;
import vin.operazioni.TabIMBOController;

public class EditingCellDoubleVascheImbL
extends TableCell {
    private TextField textField;
    public String error = "";
    Utility util;
    Double esistenza = 0.0;
    TabIMBOController controller = null;

    public EditingCellDoubleVascheImbL(TabIMBOController controller) {
        try {
            this.util = new Utility();
            this.controller = controller;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void startEdit() {
        super.startEdit();
        if (this.textField == null) {
            this.createTextField();
        }
        this.setText(null);
        this.setGraphic((Node)this.textField);
        this.setContentDisplay(ContentDisplay.GRAPHIC_ONLY);
        this.textField.requestFocus();
    }

    public void cancelEdit() {
        super.cancelEdit();
        this.setText(String.valueOf(this.getItem()));
        this.setContentDisplay(ContentDisplay.TEXT_ONLY);
        this.setGraphic(null);
    }

    public void updateItem(Object item, boolean empty) {
        super.updateItem(item, empty);
        if (empty) {
            this.setText(null);
            this.setGraphic(null);
        } else {
            String h = "";
            if (this.isEditing()) {
                if (this.textField != null) {
                    this.textField.setText(this.getString());
                }
                this.setText(null);
                this.setGraphic((Node)this.textField);
                this.setContentDisplay(ContentDisplay.GRAPHIC_ONLY);
            } else {
                this.setText(this.getString());
                this.setContentDisplay(ContentDisplay.TEXT_ONLY);
            }
        }
    }

    private void createTextField() {
        this.textField = new TextField(this.getString());
        this.textField.setMinWidth(this.getWidth() - this.getGraphicTextGap() * 2.0);
        this.textField.textProperty().addListener((ChangeListener)new ChangeListener<String>(){

            public void changed(ObservableValue<? extends String> observable, String oldValue, String newValue) {
                String val = newValue.replaceAll("[A-z,]", "");
                EditingCellDoubleVascheImbL.this.textField.setText(val);
            }
        });
        this.textField.setOnKeyReleased((EventHandler)new EventHandler<KeyEvent>(){

            public void handle(KeyEvent t) {
                if (t.getCode() == KeyCode.ENTER) {
                    EditingCellDoubleVascheImbL.this.controller.table_1.requestFocus();
                } else if (t.getCode() == KeyCode.ESCAPE) {
                    EditingCellDoubleVascheImbL.this.cancelEdit();
                    EditingCellDoubleVascheImbL.this.textField.setText("");
                }
            }
        });
        this.textField.focusedProperty().addListener((ChangeListener)new ChangeListener<Boolean>(){

            public void changed(ObservableValue<? extends Boolean> observable, Boolean oldValue, Boolean newValue) {
                if (!newValue.booleanValue() && EditingCellDoubleVascheImbL.this.textField != null) {
                    try {
                        String val = EditingCellDoubleVascheImbL.this.textField.getText().toString();
                        if (!val.equals("")) {
                            HashMap lis;
                            boolean GESTIONE_VASCHE;
                            Double valore = Double.parseDouble(val);
                            Double giacenza = ((ColumnTablePoolCompleta)EditingCellDoubleVascheImbL.this.controller.table_1.getSelectionModel().getSelectedItem()).getColumn_giacenza();
                            String prodotto = EditingCellDoubleVascheImbL.this.controller.editText_prodotto1.getText().trim();
                            String sian = FXMLDocumentController.ricerca.getSianAnaProdotto(prodotto);
                            String categoria = FXMLDocumentController.ricerca.getCategoriaProdottofromProdotto(prodotto);
                            String um = FXMLDocumentController.ricerca.getUMfromCategoriaProdotto(categoria);
                            double massa = 0.0;
                            if (!sian.contains("#ERR")) {
                                JSONArray ar = FXMLDocumentController.jsonUtil.strJsonToJSONArray(sian);
                                for (int i = 0; i < ar.length(); ++i) {
                                    JSONObject obj = ar.getJSONObject(i);
                                    massa = obj.getDouble("sian_massa_volumica");
                                }
                            }
                            if ((GESTIONE_VASCHE = ((Boolean)(lis = EditingCellDoubleVascheImbL.this.util.getParameters()).get("GESTIONE_VASCHE")).booleanValue()) && valore > giacenza) {
                                FXMLDocumentController.toast.startToast("La qta(l) deve essere inferiore o uguale alla giacenza ", "ERRORE", "ERRORE");
                                return;
                            }
                            EditingCellDoubleVascheImbL.this.commitEdit(valore);
                            if (um.toLowerCase().equals("kg") && massa > 0.0) {
                                if (massa < 99.0) {
                                    ((ColumnTablePoolCompleta)EditingCellDoubleVascheImbL.this.controller.table_1.getSelectionModel().getSelectedItem()).setColumn_qtaKg(FXMLDocumentController.util.MyMathRound(valore * massa, 3));
                                } else {
                                    ((ColumnTablePoolCompleta)EditingCellDoubleVascheImbL.this.controller.table_1.getSelectionModel().getSelectedItem()).setColumn_qtaKg(FXMLDocumentController.util.MyMathRound(valore, 3));
                                }
                            } else {
                                ((ColumnTablePoolCompleta)EditingCellDoubleVascheImbL.this.controller.table_1.getSelectionModel().getSelectedItem()).setColumn_qtaKg(FXMLDocumentController.util.MyMathRound(valore, 3));
                            }
                            Double litri = 0.0;
                            for (int i = 0; i < EditingCellDoubleVascheImbL.this.controller.lista_1.size(); ++i) {
                                litri = ((ColumnTablePoolCompleta)EditingCellDoubleVascheImbL.this.controller.lista_1.get(i)).getColumn_qtaL() + litri;
                            }
                            Double qtaimb = 0.0;
                            Double cali = 0.0;
                            if (EditingCellDoubleVascheImbL.this.controller.editText_qtalitritotimbottigliati_imb.getText().equals("")) {
                                qtaimb = 0.0;
                                EditingCellDoubleVascheImbL.this.controller.editText_qtalitricali_imb.setText("0.0");
                            } else {
                                qtaimb = Double.parseDouble(EditingCellDoubleVascheImbL.this.controller.editText_qtalitritotimbottigliati_imb.getText());
                                if (litri >= qtaimb) {
                                    cali = litri - qtaimb;
                                    EditingCellDoubleVascheImbL.this.controller.editText_qtalitricali_imb.setText(FXMLDocumentController.util.MyMathRound(cali, 3) + "");
                                } else {
                                    EditingCellDoubleVascheImbL.this.controller.editText_qtalitricali_imb.setText("0.0");
                                }
                            }
                            EditingCellDoubleVascheImbL.this.controller.editText_qtalitritotsfusi_imb.setText(FXMLDocumentController.util.MyMathRound(litri, 3) + "");
                        }
                        EditingCellDoubleVascheImbL.this.controller.table_1.refresh();
                        EditingCellDoubleVascheImbL.this.textField.setText("");
                    }
                    catch (IOException | URISyntaxException | JSONException ex) {
                        Logger.getLogger(EditingCellDoubleVascheImbL.class.getName()).log(Level.SEVERE, null, ex);
                    }
                }
            }
        });
    }

    private String getString() {
        return this.getItem() == null ? "" : this.getItem().toString();
    }
}

