/*
 * Decompiled with CFR 0.152.
 */
package vin.Class;

import java.io.IOException;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.event.EventHandler;
import javafx.scene.Node;
import javafx.scene.control.ContentDisplay;
import javafx.scene.control.TableCell;
import javafx.scene.control.TextField;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import vin.Class.ColumnTableGridSearchVasca;
import vin.Class.ColumnTablePoolCompleta;
import vin.Uility.Utility;
import vin.controller.FXMLDocumentController;
import vin.controller.ToastFXMessages;
import vin.operazioni.TabUSSDController;

public class EditingCellDoubleVascaVE
extends TableCell<ColumnTableGridSearchVasca, Double> {
    private TextField textField;
    public String error = "";
    ToastFXMessages tx = new ToastFXMessages();
    Utility util;
    Double esistenza = 0.0;
    TabUSSDController controller = null;

    public EditingCellDoubleVascaVE(TabUSSDController controller) {
        try {
            this.util = new Utility();
            this.controller = controller;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void startEdit() {
        super.startEdit();
        if (this.textField == null) {
            this.createTextField();
        }
        this.setText(null);
        this.setGraphic((Node)this.textField);
        this.setContentDisplay(ContentDisplay.GRAPHIC_ONLY);
        this.textField.requestFocus();
    }

    public void cancelEdit() {
        super.cancelEdit();
        this.setText(String.valueOf(this.getItem()));
        this.setContentDisplay(ContentDisplay.TEXT_ONLY);
        this.setGraphic(null);
    }

    public void updateItem(Double item, boolean empty) {
        super.updateItem((Object)item, empty);
        if (empty) {
            this.setText(null);
            this.setGraphic(null);
        } else {
            String d = "";
            if (this.isEditing()) {
                if (this.textField != null) {
                    this.textField.setText(this.getString());
                }
                this.setText(null);
                this.setGraphic((Node)this.textField);
                this.setContentDisplay(ContentDisplay.GRAPHIC_ONLY);
            } else {
                this.setText(this.getString());
                this.setContentDisplay(ContentDisplay.TEXT_ONLY);
            }
        }
    }

    private void createTextField() {
        this.textField = new TextField(this.getString());
        this.textField.setMinWidth(this.getWidth() - this.getGraphicTextGap() * 2.0);
        this.textField.textProperty().addListener((ChangeListener)new ChangeListener<String>(){

            public void changed(ObservableValue<? extends String> observable, String oldValue, String newValue) {
                String val = newValue.replaceAll("[A-z,]", "");
                EditingCellDoubleVascaVE.this.textField.setText(val);
            }
        });
        this.textField.setOnKeyReleased((EventHandler)new EventHandler<KeyEvent>(){

            public void handle(KeyEvent t) {
                if (t.getCode() == KeyCode.ENTER) {
                    EditingCellDoubleVascaVE.this.controller.table_vasca_ve.requestFocus();
                } else if (t.getCode() == KeyCode.ESCAPE) {
                    EditingCellDoubleVascaVE.this.cancelEdit();
                    EditingCellDoubleVascaVE.this.textField.setText("0.0");
                }
            }
        });
        this.textField.focusedProperty().addListener((ChangeListener)new ChangeListener<Boolean>(){

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public void changed(ObservableValue<? extends Boolean> observable, Boolean oldValue, Boolean newValue) {
                if (newValue != false) return;
                if (EditingCellDoubleVascaVE.this.textField == null) return;
                try {
                    String val = EditingCellDoubleVascaVE.this.textField.getText().toString();
                    if (val.equals("")) return;
                    int idx = EditingCellDoubleVascaVE.this.controller.table_vasca_ve.getSelectionModel().getSelectedIndex();
                    double residuo = ((ColumnTablePoolCompleta)EditingCellDoubleVascaVE.this.controller.lista_vasca_ve.get(idx)).getColumn_giacenza();
                    String nomeColonna = EditingCellDoubleVascaVE.this.getTableColumn().getText();
                    if (val.equals("")) {
                        val = "0.0";
                    }
                    String prodotto = ((ColumnTablePoolCompleta)EditingCellDoubleVascaVE.this.controller.lista_vasca_ve.get(idx)).getColumn_prodotto().trim();
                    String sian = FXMLDocumentController.ricerca.getSianAnaProdotto(prodotto);
                    String categoria = FXMLDocumentController.ricerca.getCategoriaProdottofromProdotto(prodotto);
                    String um = FXMLDocumentController.ricerca.getUMfromCategoriaProdotto(categoria);
                    double massa = 0.0;
                    if (!sian.contains("#ERR")) {
                        JSONArray ar = FXMLDocumentController.jsonUtil.strJsonToJSONArray(sian);
                        for (int i = 0; i < ar.length(); ++i) {
                            JSONObject obj = ar.getJSONObject(i);
                            massa = obj.getDouble("sian_massa_volumica");
                        }
                    }
                    double qtaKg = 0.0;
                    double qtaL = 0.0;
                    if (nomeColonna.toLowerCase().contains("kg")) {
                        qtaKg = Double.parseDouble(val);
                        qtaL = um.toLowerCase().equals("kg") && massa > 0.0 ? FXMLDocumentController.util.MyMathRound(qtaKg / massa, 3) : qtaKg;
                    } else {
                        qtaL = Double.parseDouble(val);
                        qtaKg = um.toLowerCase().equals("kg") && massa > 0.0 ? FXMLDocumentController.util.MyMathRound(qtaL * massa, 3) : qtaL;
                    }
                    HashMap lis = FXMLDocumentController.util.getParameters();
                    boolean GESTIONE_VASCHE = (Boolean)lis.get("GESTIONE_VASCHE");
                    boolean KG_ROUNDUP = (Boolean)lis.get("KG_ROUNDUP");
                    if (GESTIONE_VASCHE) {
                        if (um.toLowerCase().equals("kg") && massa > 0.0 || um.toLowerCase().equals("l")) {
                            if (!(qtaL <= residuo)) {
                                EditingCellDoubleVascaVE.this.error = "La Qta inserita non pu\u00f2 essere superiore alla Giacenza.";
                                EditingCellDoubleVascaVE.this.tx.startToast(EditingCellDoubleVascaVE.this.error, "ERRORE", "ERRORE");
                                return;
                            }
                            EditingCellDoubleVascaVE.this.commitEdit(Double.parseDouble(val));
                        } else {
                            EditingCellDoubleVascaVE.this.commitEdit(Double.parseDouble(val));
                        }
                    } else {
                        EditingCellDoubleVascaVE.this.commitEdit(Double.parseDouble(val));
                    }
                    if (nomeColonna.toLowerCase().contains("kg")) {
                        ((ColumnTablePoolCompleta)EditingCellDoubleVascaVE.this.controller.lista_vasca_ve.get(idx)).setColumn_qtaL(qtaL);
                    } else {
                        if (KG_ROUNDUP) {
                            qtaKg = FXMLDocumentController.util.RoundUpCeiling(qtaKg);
                        }
                        ((ColumnTablePoolCompleta)EditingCellDoubleVascaVE.this.controller.lista_vasca_ve.get(idx)).setColumn_qtaKg(qtaKg);
                    }
                    EditingCellDoubleVascaVE.this.controller.table_vasca_ve.refresh();
                    EditingCellDoubleVascaVE.this.textField.setText("");
                    return;
                }
                catch (JSONException ex) {
                    EditingCellDoubleVascaVE.this.cancelEdit();
                    EditingCellDoubleVascaVE.this.textField.setText("0.0");
                    ToastFXMessages toast = new ToastFXMessages();
                    toast.startToast(ex.toString(), "ERRORE", "ERRORE");
                    return;
                }
                catch (IOException ex) {
                    Logger.getLogger(EditingCellDoubleVascaVE.class.getName()).log(Level.SEVERE, null, ex);
                    return;
                }
                catch (URISyntaxException ex) {
                    Logger.getLogger(EditingCellDoubleVascaVE.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
        });
    }

    private String getString() {
        return this.getItem() == null ? "" : ((Double)this.getItem()).toString();
    }
}

