/*
 * Decompiled with CFR 0.152.
 */
package vin.Class;

import javafx.application.Platform;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.event.EventHandler;
import javafx.scene.Node;
import javafx.scene.control.ContentDisplay;
import javafx.scene.control.TableCell;
import javafx.scene.control.TextField;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import vin.Class.ColumnTableGridSearchVasca;
import vin.Class.ColumnTableIdoneitaImb;
import vin.Uility.Utility;
import vin.controller.ToastFXMessages;

public class EditingCellDoubleVascaCASD
extends TableCell<ColumnTableIdoneitaImb, Double> {
    private TextField textField;
    public String error = "";
    ToastFXMessages tx = new ToastFXMessages();
    ObservableList<ColumnTableGridSearchVasca> list = FXCollections.observableArrayList();
    Utility util;
    Double esistenza = 0.0;

    public EditingCellDoubleVascaCASD() {
        try {
            this.util = new Utility();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void startEdit() {
        super.startEdit();
        if (this.textField == null) {
            this.createTextField();
        }
        this.setText(null);
        this.setGraphic((Node)this.textField);
        this.setContentDisplay(ContentDisplay.GRAPHIC_ONLY);
        Platform.runLater((Runnable)new Runnable(){

            @Override
            public void run() {
                EditingCellDoubleVascaCASD.this.textField.requestFocus();
                EditingCellDoubleVascaCASD.this.textField.selectAll();
            }
        });
    }

    public void cancelEdit() {
        super.cancelEdit();
        this.setText(String.valueOf(this.getItem()));
        this.setContentDisplay(ContentDisplay.TEXT_ONLY);
        this.setGraphic(null);
    }

    public void updateItem(Double item, boolean empty) {
        super.updateItem((Object)item, empty);
        if (empty) {
            this.setText(null);
            this.setGraphic(null);
        } else {
            String c = "";
            if (this.isEditing()) {
                if (this.textField != null) {
                    this.textField.setText(this.getString());
                }
                this.setText(null);
                this.setGraphic((Node)this.textField);
                this.setContentDisplay(ContentDisplay.GRAPHIC_ONLY);
            } else {
                this.setText(this.getString());
                this.setContentDisplay(ContentDisplay.TEXT_ONLY);
            }
        }
    }

    private void createTextField() {
        this.textField = new TextField(this.getString());
        this.textField.setMinWidth(this.getWidth() - this.getGraphicTextGap() * 2.0);
        this.textField.textProperty().addListener((ChangeListener)new ChangeListener<String>(){

            public void changed(ObservableValue<? extends String> observable, String oldValue, String newValue) {
                String val = newValue.replaceAll("[A-z,]", "");
                EditingCellDoubleVascaCASD.this.textField.setText(val);
            }
        });
        this.textField.focusedProperty().addListener((ChangeListener)new ChangeListener<Boolean>(){

            public void changed(ObservableValue<? extends Boolean> arg0, Boolean arg1, Boolean arg2) {
                if (!arg2.booleanValue()) {
                    String tax = EditingCellDoubleVascaCASD.this.textField.getText();
                    if (tax.equals("")) {
                        tax = "0";
                    }
                    double d = Double.parseDouble(tax);
                }
            }
        });
        this.textField.setOnKeyReleased((EventHandler)new EventHandler<KeyEvent>(){

            public void handle(KeyEvent t) {
                if (t.getCode() == KeyCode.ENTER) {
                    String tax = EditingCellDoubleVascaCASD.this.textField.getText();
                    if (tax.equals("")) {
                        tax = "0";
                    }
                    double d = Double.parseDouble(tax);
                } else if (t.getCode() == KeyCode.ESCAPE) {
                    EditingCellDoubleVascaCASD.this.cancelEdit();
                    EditingCellDoubleVascaCASD.this.textField.setText("");
                }
            }
        });
    }

    private String getString() {
        return this.getItem() == null ? "" : ((Double)this.getItem()).toString();
    }
}

