/*
 * Decompiled with CFR 0.152.
 */
package vin.Class;

import java.io.IOException;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.event.EventHandler;
import javafx.scene.Node;
import javafx.scene.control.ContentDisplay;
import javafx.scene.control.TableCell;
import javafx.scene.control.TextField;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import vin.Class.ColumnTablePoolCompleta;
import vin.Uility.Utility;
import vin.controller.FXMLDocumentController;
import vin.controller.ToastFXMessages;
import vin.operazioni.TabCASDController;

public class EditingCellDoubleVascaAQ
extends TableCell<ColumnTablePoolCompleta, Double> {
    private TextField textField;
    public String error = "";
    ToastFXMessages tx = new ToastFXMessages();
    Utility util;
    Double esistenza = 0.0;
    TabCASDController controller = null;

    public EditingCellDoubleVascaAQ(TabCASDController controller) {
        try {
            this.util = new Utility();
            this.controller = controller;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void startEdit() {
        super.startEdit();
        if (this.textField == null) {
            this.createTextField();
        }
        this.setText(null);
        this.setGraphic((Node)this.textField);
        this.setContentDisplay(ContentDisplay.GRAPHIC_ONLY);
        this.textField.requestFocus();
    }

    public void cancelEdit() {
        super.cancelEdit();
        this.setText(String.valueOf(this.getItem()));
        this.setContentDisplay(ContentDisplay.TEXT_ONLY);
        this.setGraphic(null);
    }

    public void updateItem(Double item, boolean empty) {
        super.updateItem((Object)item, empty);
        if (empty) {
            this.setText(null);
            this.setGraphic(null);
        } else {
            String d = "";
            if (this.isEditing()) {
                if (this.textField != null) {
                    this.textField.setText(this.getString());
                }
                this.setText(null);
                this.setGraphic((Node)this.textField);
                this.setContentDisplay(ContentDisplay.GRAPHIC_ONLY);
            } else {
                this.setText(this.getString());
                this.setContentDisplay(ContentDisplay.TEXT_ONLY);
            }
        }
    }

    private void createTextField() {
        this.textField = new TextField(this.getString());
        this.textField.setMinWidth(this.getWidth() - this.getGraphicTextGap() * 2.0);
        this.textField.textProperty().addListener((ChangeListener)new ChangeListener<String>(){

            public void changed(ObservableValue<? extends String> observable, String oldValue, String newValue) {
                String val = newValue.replaceAll("[A-z,]", "");
                EditingCellDoubleVascaAQ.this.textField.setText(val);
            }
        });
        this.textField.setOnKeyReleased((EventHandler)new EventHandler<KeyEvent>(){

            public void handle(KeyEvent t) {
                if (t.getCode() == KeyCode.ENTER) {
                    EditingCellDoubleVascaAQ.this.controller.table_vasca_aq.requestFocus();
                } else if (t.getCode() == KeyCode.ESCAPE) {
                    EditingCellDoubleVascaAQ.this.cancelEdit();
                    EditingCellDoubleVascaAQ.this.textField.setText("0.0");
                }
            }
        });
        this.textField.focusedProperty().addListener((ChangeListener)new ChangeListener<Boolean>(){

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public void changed(ObservableValue<? extends Boolean> observable, Boolean oldValue, Boolean newValue) {
                if (newValue != false) return;
                if (EditingCellDoubleVascaAQ.this.textField == null) return;
                try {
                    String val = EditingCellDoubleVascaAQ.this.textField.getText().toString();
                    if (val.equals("")) return;
                    int idx = EditingCellDoubleVascaAQ.this.controller.table_vasca_aq.getSelectionModel().getSelectedIndex();
                    double residuo = ((ColumnTablePoolCompleta)EditingCellDoubleVascaAQ.this.controller.lista_vasca_aq.get(idx)).getColumn_residuo();
                    String nomeColonna = EditingCellDoubleVascaAQ.this.getTableColumn().getText();
                    if (val.equals("")) {
                        val = "0.0";
                    }
                    String prodotto = ((ColumnTablePoolCompleta)EditingCellDoubleVascaAQ.this.controller.lista_vasca_aq.get(idx)).getColumn_prodotto().trim();
                    String sian = FXMLDocumentController.ricerca.getSianAnaProdotto(prodotto);
                    String categoria = FXMLDocumentController.ricerca.getCategoriaProdottofromProdotto(prodotto);
                    String um = FXMLDocumentController.ricerca.getUMfromCategoriaProdotto(categoria);
                    double massa = 0.0;
                    if (!sian.contains("#ERR")) {
                        JSONArray ar = FXMLDocumentController.jsonUtil.strJsonToJSONArray(sian);
                        for (int i = 0; i < ar.length(); ++i) {
                            JSONObject obj = ar.getJSONObject(i);
                            massa = obj.getDouble("sian_massa_volumica");
                        }
                    }
                    double qtaKg = 0.0;
                    double qtaL = 0.0;
                    if (nomeColonna.toLowerCase().contains("kg")) {
                        qtaKg = Double.parseDouble(val);
                        qtaL = um.toLowerCase().equals("kg") && massa > 0.0 ? FXMLDocumentController.util.MyMathRound(qtaKg / massa, 3) : qtaKg;
                    } else {
                        qtaL = Double.parseDouble(val);
                        qtaKg = um.toLowerCase().equals("kg") && massa > 0.0 ? FXMLDocumentController.util.MyMathRound(qtaL * massa, 3) : qtaL;
                    }
                    HashMap lis = FXMLDocumentController.util.getParameters();
                    boolean GESTIONE_VASCHE = (Boolean)lis.get("GESTIONE_VASCHE");
                    boolean KG_ROUNDUP = (Boolean)lis.get("KG_ROUNDUP");
                    if (GESTIONE_VASCHE) {
                        if (um.toLowerCase().equals("kg") && massa > 0.0 || um.toLowerCase().equals("l")) {
                            if (!(qtaL <= residuo * 100.0)) {
                                EditingCellDoubleVascaAQ.this.error = "La Qta inserita non pu\u00f2 essere superiore al residuo.";
                                EditingCellDoubleVascaAQ.this.tx.startToast(EditingCellDoubleVascaAQ.this.error, "ERRORE", "ERRORE");
                                return;
                            }
                            EditingCellDoubleVascaAQ.this.commitEdit(Double.parseDouble(val));
                        } else {
                            EditingCellDoubleVascaAQ.this.commitEdit(Double.parseDouble(val));
                        }
                    } else {
                        EditingCellDoubleVascaAQ.this.commitEdit(Double.parseDouble(val));
                    }
                    if (nomeColonna.toLowerCase().contains("kg")) {
                        ((ColumnTablePoolCompleta)EditingCellDoubleVascaAQ.this.controller.lista_vasca_aq.get(idx)).setColumn_qtaL(qtaL);
                    } else {
                        if (KG_ROUNDUP) {
                            qtaKg = FXMLDocumentController.util.RoundUpCeiling(qtaKg);
                        }
                        ((ColumnTablePoolCompleta)EditingCellDoubleVascaAQ.this.controller.lista_vasca_aq.get(idx)).setColumn_qtaKg(qtaKg);
                    }
                    EditingCellDoubleVascaAQ.this.controller.table_vasca_aq.refresh();
                    EditingCellDoubleVascaAQ.this.textField.setText("");
                    return;
                }
                catch (JSONException ex) {
                    EditingCellDoubleVascaAQ.this.cancelEdit();
                    EditingCellDoubleVascaAQ.this.textField.setText("0.0");
                    ToastFXMessages toast = new ToastFXMessages();
                    toast.startToast(ex.toString(), "ERRORE", "ERRORE");
                    return;
                }
                catch (IOException ex) {
                    Logger.getLogger(EditingCellDoubleVascaAQ.class.getName()).log(Level.SEVERE, null, ex);
                    return;
                }
                catch (URISyntaxException ex) {
                    Logger.getLogger(EditingCellDoubleVascaAQ.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
        });
    }

    private String getString() {
        return this.getItem() == null ? "" : ((Double)this.getItem()).toString();
    }
}

