/*
 * Decompiled with CFR 0.152.
 */
package vin.Class;

import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.application.Platform;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.event.EventHandler;
import javafx.scene.Node;
import javafx.scene.control.ContentDisplay;
import javafx.scene.control.Label;
import javafx.scene.control.TableCell;
import javafx.scene.control.TextField;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import vin.Class.ColumnTablePoolImboCarico;
import vin.Class.ColumnTableProdottoImb;
import vin.Uility.Utility;
import vin.controller.FXMLDocumentController;
import vin.controller.ToastFXMessages;
import vin.operazioni.TabIMBOController;

public class EditingCellDoubleQtaProdottoImb
extends TableCell<ColumnTableProdottoImb, Integer> {
    private TextField textField;
    private Label fieldControl;
    private Label editText_qtalitrisfusi;
    private Label editText_cali;
    public String error = "";
    ToastFXMessages tx = new ToastFXMessages();
    Utility util;
    Double esistenza = 0.0;
    TabIMBOController controller = null;

    public EditingCellDoubleQtaProdottoImb(Label editText_qtalitriimb, Label cali, Label qtalitrisfusi, TabIMBOController controller) {
        try {
            this.util = new Utility();
            this.fieldControl = editText_qtalitriimb;
            this.editText_cali = cali;
            this.editText_qtalitrisfusi = qtalitrisfusi;
            this.controller = controller;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void startEdit() {
        super.startEdit();
        if (this.textField == null) {
            this.createTextField();
        }
        this.setText(null);
        this.setGraphic((Node)this.textField);
        this.setContentDisplay(ContentDisplay.GRAPHIC_ONLY);
        Platform.runLater((Runnable)new Runnable(){

            @Override
            public void run() {
                EditingCellDoubleQtaProdottoImb.this.textField.requestFocus();
                EditingCellDoubleQtaProdottoImb.this.textField.selectAll();
            }
        });
    }

    public void cancelEdit() {
        super.cancelEdit();
        this.setText(String.valueOf(this.getItem()));
        this.setContentDisplay(ContentDisplay.TEXT_ONLY);
        this.setGraphic(null);
    }

    public void updateItem(Integer item, boolean empty) {
        super.updateItem((Object)item, empty);
        if (empty) {
            this.setText(null);
            this.setGraphic(null);
        } else {
            String c = "";
            if (this.isEditing()) {
                if (this.textField != null) {
                    this.textField.setText(this.getString());
                }
                this.setText(null);
                this.setGraphic((Node)this.textField);
                this.setContentDisplay(ContentDisplay.GRAPHIC_ONLY);
            } else {
                this.setText(this.getString());
                this.setContentDisplay(ContentDisplay.TEXT_ONLY);
            }
        }
    }

    private void createTextField() {
        this.textField = new TextField(this.getString());
        this.textField.setMinWidth(this.getWidth() - this.getGraphicTextGap() * 2.0);
        this.textField.textProperty().addListener((ChangeListener)new ChangeListener<String>(){

            public void changed(ObservableValue<? extends String> observable, String oldValue, String newValue) {
                String val = newValue.replaceAll("[A-z,.]", "");
                EditingCellDoubleQtaProdottoImb.this.textField.setText(val);
            }
        });
        this.textField.setOnKeyReleased((EventHandler)new EventHandler<KeyEvent>(){

            public void handle(KeyEvent t) {
                if (t.getCode() == KeyCode.ENTER) {
                    EditingCellDoubleQtaProdottoImb.this.controller.table_2.requestFocus();
                } else if (t.getCode() == KeyCode.ESCAPE) {
                    EditingCellDoubleQtaProdottoImb.this.cancelEdit();
                    EditingCellDoubleQtaProdottoImb.this.textField.setText("");
                }
            }
        });
        this.textField.focusedProperty().addListener((ChangeListener)new ChangeListener<Boolean>(){

            public void changed(ObservableValue<? extends Boolean> observable, Boolean oldValue, Boolean newValue) {
                if (!newValue.booleanValue() && EditingCellDoubleQtaProdottoImb.this.textField != null) {
                    try {
                        int item = EditingCellDoubleQtaProdottoImb.this.controller.table_2.getSelectionModel().getSelectedIndex();
                        String val = EditingCellDoubleQtaProdottoImb.this.textField.getText();
                        if (val.equals("")) {
                            val = "0";
                        }
                        EditingCellDoubleQtaProdottoImb.this.commitEdit(Integer.parseInt(val));
                        String prodotto = ((ColumnTablePoolImboCarico)EditingCellDoubleQtaProdottoImb.this.controller.lista_2.get(item)).getColumn_codice();
                        String sian = FXMLDocumentController.ricerca.getSianAnaProdotto(prodotto);
                        String categoria = FXMLDocumentController.ricerca.getCategoriaProdottofromProdotto(prodotto);
                        String um = FXMLDocumentController.ricerca.getUMfromCategoriaProdotto(categoria);
                        double massa = 0.0;
                        if (!sian.contains("#ERR")) {
                            JSONArray ar = FXMLDocumentController.jsonUtil.strJsonToJSONArray(sian);
                            for (int i = 0; i < ar.length(); ++i) {
                                JSONObject obj = ar.getJSONObject(i);
                                massa = obj.getDouble("sian_massa_volumica");
                            }
                        }
                        double kg = 0.0;
                        Double litri = 0.0;
                        litri = (double)Integer.parseInt(val) * ((ColumnTablePoolImboCarico)EditingCellDoubleQtaProdottoImb.this.controller.lista_2.get(item)).getColumn_volumenominale();
                        if (um.toLowerCase().equals("kg") && massa > 0.0) {
                            if (massa < 99.0) {
                                kg = massa * litri;
                            }
                        } else {
                            kg = litri;
                        }
                        ((ColumnTablePoolImboCarico)EditingCellDoubleQtaProdottoImb.this.controller.lista_2.get(item)).setColumn_qtaL(FXMLDocumentController.util.MyMathRound(litri, 3));
                        ((ColumnTablePoolImboCarico)EditingCellDoubleQtaProdottoImb.this.controller.lista_2.get(item)).setColumn_qtaKg(FXMLDocumentController.util.MyMathRound(kg, 3));
                        Double totlitri = 0.0;
                        for (int i = 0; i < EditingCellDoubleQtaProdottoImb.this.controller.lista_2.size(); ++i) {
                            totlitri = ((ColumnTablePoolImboCarico)EditingCellDoubleQtaProdottoImb.this.controller.lista_2.get(i)).getColumn_qtaL() + totlitri;
                        }
                        Double qtasfusi = 0.0;
                        Double cali = 0.0;
                        if (EditingCellDoubleQtaProdottoImb.this.editText_qtalitrisfusi.getText().equals("")) {
                            qtasfusi = 0.0;
                            EditingCellDoubleQtaProdottoImb.this.editText_cali.setText("0.0");
                        } else {
                            qtasfusi = Double.parseDouble(EditingCellDoubleQtaProdottoImb.this.editText_qtalitrisfusi.getText());
                            if (qtasfusi >= totlitri) {
                                cali = qtasfusi - totlitri;
                                EditingCellDoubleQtaProdottoImb.this.editText_cali.setText(FXMLDocumentController.util.MyMathRound(cali, 3) + "");
                            } else {
                                EditingCellDoubleQtaProdottoImb.this.editText_cali.setText("0.0");
                            }
                        }
                        EditingCellDoubleQtaProdottoImb.this.fieldControl.setText(FXMLDocumentController.util.MyMathRound(totlitri, 3) + "");
                        EditingCellDoubleQtaProdottoImb.this.controller.table_2.refresh();
                    }
                    catch (JSONException ex) {
                        Logger.getLogger(EditingCellDoubleQtaProdottoImb.class.getName()).log(Level.SEVERE, null, ex);
                    }
                }
                EditingCellDoubleQtaProdottoImb.this.textField.setText("");
            }
        });
    }

    private String getString() {
        return this.getItem() == null ? "" : ((Integer)this.getItem()).toString();
    }
}

