/*
 * Decompiled with CFR 0.152.
 */
package vin.Class;

import java.io.IOException;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.event.EventHandler;
import javafx.scene.Node;
import javafx.scene.control.ContentDisplay;
import javafx.scene.control.TableCell;
import javafx.scene.control.TextField;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import vin.Class.ColumnTableGridSearchVasoImb;
import vin.Class.ColumnTablePoolCompleta;
import vin.Class.ColumnTablePoolImboCarico;
import vin.Uility.Utility;
import vin.controller.FXMLDocumentController;
import vin.controller.ToastFXMessages;
import vin.operazioni.TabIMBOController;

public class EditingCellDoubleProdottoImbCL
extends TableCell<ColumnTableGridSearchVasoImb, Double> {
    private TextField textField;
    public String error = "";
    ToastFXMessages tx = new ToastFXMessages();
    Utility util;
    Double esistenza = 0.0;
    TabIMBOController controller = null;

    public EditingCellDoubleProdottoImbCL(TabIMBOController controller) {
        try {
            this.util = new Utility();
            this.controller = controller;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void startEdit() {
        super.startEdit();
        if (this.textField == null) {
            this.createTextField();
        }
        this.setText(null);
        this.setGraphic((Node)this.textField);
        this.setContentDisplay(ContentDisplay.GRAPHIC_ONLY);
        this.textField.requestFocus();
    }

    public void cancelEdit() {
        super.cancelEdit();
        this.setText(String.valueOf(this.getItem()));
        this.setContentDisplay(ContentDisplay.TEXT_ONLY);
        this.setGraphic(null);
    }

    public void updateItem(Double item, boolean empty) {
        super.updateItem((Object)item, empty);
        if (empty) {
            this.setText(null);
            this.setGraphic(null);
        } else {
            String h = "";
            if (this.isEditing()) {
                if (this.textField != null) {
                    this.textField.setText(this.getString());
                }
                this.setText(null);
                this.setGraphic((Node)this.textField);
                this.setContentDisplay(ContentDisplay.GRAPHIC_ONLY);
            } else {
                this.setText(this.getString());
                this.setContentDisplay(ContentDisplay.TEXT_ONLY);
            }
        }
    }

    private void createTextField() {
        this.textField = new TextField(this.getString());
        this.textField.setMinWidth(this.getWidth() - this.getGraphicTextGap() * 2.0);
        this.textField.textProperty().addListener((ChangeListener)new ChangeListener<String>(){

            public void changed(ObservableValue<? extends String> observable, String oldValue, String newValue) {
                String val = newValue.replaceAll("[A-z,]", "");
                EditingCellDoubleProdottoImbCL.this.textField.setText(val);
            }
        });
        this.textField.setOnKeyReleased((EventHandler)new EventHandler<KeyEvent>(){

            public void handle(KeyEvent t) {
                if (t.getCode() == KeyCode.ENTER) {
                    EditingCellDoubleProdottoImbCL.this.controller.table_2.requestFocus();
                } else if (t.getCode() == KeyCode.ESCAPE) {
                    EditingCellDoubleProdottoImbCL.this.cancelEdit();
                    EditingCellDoubleProdottoImbCL.this.textField.setText("");
                }
            }
        });
        this.textField.focusedProperty().addListener((ChangeListener)new ChangeListener<Boolean>(){

            public void changed(ObservableValue<? extends Boolean> observable, Boolean oldValue, Boolean newValue) {
                if (!newValue.booleanValue() && EditingCellDoubleProdottoImbCL.this.textField != null) {
                    try {
                        String val = EditingCellDoubleProdottoImbCL.this.textField.getText().toString();
                        if (!val.equals("")) {
                            Double valore = Double.parseDouble(val);
                            String prodotto = EditingCellDoubleProdottoImbCL.this.controller.editText_prodotto1.getText().trim();
                            String sian = FXMLDocumentController.ricerca.getSianAnaProdotto(prodotto);
                            String categoria = FXMLDocumentController.ricerca.getCategoriaProdottofromProdotto(prodotto);
                            String um = FXMLDocumentController.ricerca.getUMfromCategoriaProdotto(categoria);
                            int index = EditingCellDoubleProdottoImbCL.this.controller.table_2.getSelectionModel().getSelectedIndex();
                            double massa = 0.0;
                            if (!sian.contains("#ERR")) {
                                JSONArray ar = FXMLDocumentController.jsonUtil.strJsonToJSONArray(sian);
                                for (int i = 0; i < ar.length(); ++i) {
                                    JSONObject obj = ar.getJSONObject(i);
                                    massa = obj.getDouble("sian_massa_volumica");
                                }
                            }
                            HashMap lis = EditingCellDoubleProdottoImbCL.this.util.getParameters();
                            boolean GESTIONE_VASCHE = (Boolean)lis.get("GESTIONE_VASCHE");
                            boolean IMBO_DALAB = (Boolean)lis.get("IMBO_DALAB");
                            EditingCellDoubleProdottoImbCL.this.commitEdit(valore);
                            if (um.toLowerCase().equals("kg") && massa > 0.0) {
                                if (massa < 99.0) {
                                    ((ColumnTablePoolImboCarico)EditingCellDoubleProdottoImbCL.this.controller.lista_2.get(index)).setColumn_qtaKg(FXMLDocumentController.util.MyMathRound(valore * massa, 3));
                                } else {
                                    ((ColumnTablePoolImboCarico)EditingCellDoubleProdottoImbCL.this.controller.lista_2.get(index)).setColumn_qtaKg(FXMLDocumentController.util.MyMathRound(valore, 3));
                                }
                            } else {
                                ((ColumnTablePoolImboCarico)EditingCellDoubleProdottoImbCL.this.controller.lista_2.get(index)).setColumn_qtaKg(FXMLDocumentController.util.MyMathRound(valore, 3));
                            }
                            Double litri = 0.0;
                            for (int i = 0; i < EditingCellDoubleProdottoImbCL.this.controller.lista_1.size(); ++i) {
                                litri = litri + ((ColumnTablePoolCompleta)EditingCellDoubleProdottoImbCL.this.controller.lista_1.get(i)).getColumn_qtaL();
                            }
                            Double qtaimb = 0.0;
                            for (int i = 0; i < EditingCellDoubleProdottoImbCL.this.controller.lista_2.size(); ++i) {
                                qtaimb = qtaimb + ((ColumnTablePoolImboCarico)EditingCellDoubleProdottoImbCL.this.controller.lista_2.get(i)).getColumn_qtaL();
                            }
                            if (IMBO_DALAB) {
                                BigDecimal volnom = new BigDecimal(((ColumnTablePoolImboCarico)EditingCellDoubleProdottoImbCL.this.controller.lista_2.get(index)).getColumn_volumenominale());
                                BigDecimal pezzi = new BigDecimal(qtaimb).divide(volnom, 0, RoundingMode.HALF_DOWN);
                                ((ColumnTablePoolImboCarico)EditingCellDoubleProdottoImbCL.this.controller.lista_2.get(index)).setColumn_nconfezioni(pezzi.intValue());
                            }
                            EditingCellDoubleProdottoImbCL.this.controller.editText_qtalitritotimbottigliati_imb.setText(FXMLDocumentController.util.MyMathRound(qtaimb, 3) + "");
                            Double cali = litri - qtaimb;
                            EditingCellDoubleProdottoImbCL.this.controller.editText_qtalitricali_imb.setText(FXMLDocumentController.util.MyMathRound(cali, 3) + "");
                            EditingCellDoubleProdottoImbCL.this.controller.editText_qtalitritotsfusi_imb.setText(FXMLDocumentController.util.MyMathRound(litri, 3) + "");
                        }
                        EditingCellDoubleProdottoImbCL.this.controller.table_2.refresh();
                        EditingCellDoubleProdottoImbCL.this.textField.setText("");
                    }
                    catch (IOException | URISyntaxException | JSONException ex) {
                        Logger.getLogger(EditingCellDoubleProdottoImbCL.class.getName()).log(Level.SEVERE, null, ex);
                    }
                }
            }
        });
    }

    private String getString() {
        return this.getItem() == null ? "" : ((Double)this.getItem()).toString();
    }
}

