/*
 * Decompiled with CFR 0.152.
 */
package vin.Class;

import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.scene.Node;
import javafx.scene.control.ContentDisplay;
import javafx.scene.control.TableCell;
import javafx.scene.control.TextField;
import javafx.scene.input.KeyCode;
import vin.Class.ColumnTablePoolCompleta;

public class EditingCellDoublePoolCompleta
extends TableCell<ColumnTablePoolCompleta, Double> {
    private TextField textField;
    public String error = "";

    public void startEdit() {
        super.startEdit();
        if (this.textField == null) {
            this.createTextField();
        }
        this.setText(null);
        this.setGraphic((Node)this.textField);
        this.setContentDisplay(ContentDisplay.GRAPHIC_ONLY);
        this.textField.requestFocus();
    }

    public void cancelEdit() {
        super.cancelEdit();
        this.setText(String.valueOf(this.getItem()));
        this.setContentDisplay(ContentDisplay.TEXT_ONLY);
        this.setGraphic(null);
    }

    public void updateItem(Double item, boolean empty) {
        super.updateItem((Object)item, empty);
        if (empty) {
            this.setText(null);
            this.setGraphic(null);
        } else {
            String h = "";
            if (this.isEditing()) {
                if (this.textField != null) {
                    this.textField.setText(this.getString());
                }
                this.setText(null);
                this.setGraphic((Node)this.textField);
                this.setContentDisplay(ContentDisplay.GRAPHIC_ONLY);
            } else {
                this.setText(this.getString());
                this.setContentDisplay(ContentDisplay.TEXT_ONLY);
            }
        }
    }

    private void createTextField() {
        this.textField = new TextField(this.getString());
        this.textField.setMinWidth(this.getWidth() - this.getGraphicTextGap() * 2.0);
        this.textField.textProperty().addListener((ChangeListener)new ChangeListener<String>(){

            public void changed(ObservableValue<? extends String> observable, String oldValue, String newValue) {
                String val = newValue.replaceAll("[A-z,]", "");
                EditingCellDoublePoolCompleta.this.textField.setText(val);
            }
        });
        this.textField.focusedProperty().addListener((observable, oldValue, newValue) -> {
            if (!newValue.booleanValue() && this.textField != null) {
                try {
                    String val = this.textField.getText().trim();
                    if (val.equals("")) {
                        val = "0.0";
                    }
                    this.commitEdit(Double.parseDouble(val));
                    this.getTableView().refresh();
                }
                catch (Exception ex) {
                    System.out.println(ex.toString());
                }
            }
        });
        this.textField.setOnKeyReleased(t -> {
            if (t.getCode() == KeyCode.ENTER) {
                super.getTableView().requestFocus();
            } else if (t.getCode() == KeyCode.ESCAPE) {
                this.cancelEdit();
                this.textField.setText("");
            }
        });
    }

    private String getString() {
        return this.getItem() == null ? "" : ((Double)this.getItem()).toString();
    }
}

