/*
 * Decompiled with CFR 0.152.
 */
package vin.Class;

import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.event.EventHandler;
import javafx.scene.Node;
import javafx.scene.control.ContentDisplay;
import javafx.scene.control.Label;
import javafx.scene.control.TableCell;
import javafx.scene.control.TextField;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import vin.Class.ColumnTableLottoDocumenti;
import vin.Uility.Utility;
import vin.controller.ToastFXMessages;
import vin.operazioni.TabGIINController;

public class EditingCellDoubleLottoGIIN
extends TableCell<ColumnTableLottoDocumenti, Double> {
    private TextField textField;
    private Label fieldControl;
    private Label fieldControl2;
    public String error = "";
    ToastFXMessages tx = new ToastFXMessages();
    Utility util;
    Double esistenza = 0.0;
    TabGIINController controller = null;

    public EditingCellDoubleLottoGIIN(TabGIINController controller) {
        try {
            this.util = new Utility();
            this.controller = controller;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void startEdit() {
        super.startEdit();
        if (this.textField == null) {
            this.createTextField();
        }
        this.setText(null);
        this.setGraphic((Node)this.textField);
        this.setContentDisplay(ContentDisplay.GRAPHIC_ONLY);
        this.textField.requestFocus();
    }

    public void cancelEdit() {
        super.cancelEdit();
        this.setText(String.valueOf(this.getItem()));
        this.setContentDisplay(ContentDisplay.TEXT_ONLY);
        this.setGraphic(null);
    }

    public void updateItem(Double item, boolean empty) {
        super.updateItem((Object)item, empty);
        if (empty) {
            this.setText(null);
            this.setGraphic(null);
        } else {
            String d = "";
            if (this.isEditing()) {
                if (this.textField != null) {
                    this.textField.setText(this.getString());
                }
                this.setText(null);
                this.setGraphic((Node)this.textField);
                this.setContentDisplay(ContentDisplay.GRAPHIC_ONLY);
            } else {
                this.setText(this.getString());
                this.setContentDisplay(ContentDisplay.TEXT_ONLY);
            }
        }
    }

    private void createTextField() {
        this.textField = new TextField(this.getString());
        this.textField.setMinWidth(this.getWidth() - this.getGraphicTextGap() * 2.0);
        this.textField.textProperty().addListener((ChangeListener)new ChangeListener<String>(){

            public void changed(ObservableValue<? extends String> observable, String oldValue, String newValue) {
                String val = newValue.replaceAll("[A-z,]", "");
                EditingCellDoubleLottoGIIN.this.textField.setText(val);
            }
        });
        this.textField.setOnKeyReleased((EventHandler)new EventHandler<KeyEvent>(){

            public void handle(KeyEvent t) {
                if (t.getCode() == KeyCode.ENTER) {
                    EditingCellDoubleLottoGIIN.this.controller.table_lotto_giacenza.requestFocus();
                } else if (t.getCode() == KeyCode.ESCAPE) {
                    EditingCellDoubleLottoGIIN.this.cancelEdit();
                    EditingCellDoubleLottoGIIN.this.textField.setText("0.0");
                }
            }
        });
        this.textField.focusedProperty().addListener((ChangeListener)new ChangeListener<Boolean>(){

            public void changed(ObservableValue<? extends Boolean> observable, Boolean oldValue, Boolean newValue) {
                if (!newValue.booleanValue() && EditingCellDoubleLottoGIIN.this.textField != null) {
                    Double valore = Double.parseDouble(EditingCellDoubleLottoGIIN.this.textField.getText().toString());
                    EditingCellDoubleLottoGIIN.this.commitEdit(valore);
                    EditingCellDoubleLottoGIIN.this.controller.table_lotto_giacenza.refresh();
                }
            }
        });
    }

    private String getString() {
        return this.getItem() == null ? "" : ((Double)this.getItem()).toString();
    }
}

