/*
 * Decompiled with CFR 0.152.
 */
package vin.Class;

import java.io.IOException;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.application.Platform;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.event.EventHandler;
import javafx.scene.Node;
import javafx.scene.control.ContentDisplay;
import javafx.scene.control.TableCell;
import javafx.scene.control.TextField;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import vin.Class.ColumnTablePoolCompleta;
import vin.Class.ColumnTablePoolSimple;
import vin.controller.FXMLDocumentController;
import vin.operazioni.TabGIINController;

public class EditingCellDoubleLGIIN
extends TableCell<ColumnTablePoolSimple, Double> {
    private TextField textField;
    public String error = "";
    ObservableList<ColumnTablePoolCompleta> list = FXCollections.observableArrayList();
    TabGIINController controller = null;
    Double esistenza = 0.0;

    public EditingCellDoubleLGIIN(TabGIINController val) {
        try {
            this.controller = val;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void startEdit() {
        super.startEdit();
        if (this.textField == null) {
            this.createTextField();
        }
        this.setText(null);
        this.setGraphic((Node)this.textField);
        this.setContentDisplay(ContentDisplay.GRAPHIC_ONLY);
        Platform.runLater((Runnable)new Runnable(){

            @Override
            public void run() {
                EditingCellDoubleLGIIN.this.textField.requestFocus();
                EditingCellDoubleLGIIN.this.textField.selectAll();
            }
        });
    }

    public void cancelEdit() {
        super.cancelEdit();
        this.setText(String.valueOf(this.getItem()));
        this.setContentDisplay(ContentDisplay.TEXT_ONLY);
        this.setGraphic(null);
    }

    public void updateItem(Double item, boolean empty) {
        super.updateItem((Object)item, empty);
        if (empty) {
            this.setText(null);
            this.setGraphic(null);
        } else {
            String c = "";
            if (this.isEditing()) {
                if (this.textField != null) {
                    this.textField.setText(this.getString());
                }
                this.setText(null);
                this.setGraphic((Node)this.textField);
                this.setContentDisplay(ContentDisplay.GRAPHIC_ONLY);
            } else {
                this.setText(this.getString());
                this.setContentDisplay(ContentDisplay.TEXT_ONLY);
            }
        }
    }

    private void createTextField() {
        this.textField = new TextField(this.getString());
        this.textField.setMinWidth(this.getWidth() - this.getGraphicTextGap() * 2.0);
        this.textField.textProperty().addListener((ChangeListener)new ChangeListener<String>(){

            public void changed(ObservableValue<? extends String> observable, String oldValue, String newValue) {
                String val = newValue.replaceAll("[A-z,]", "");
                EditingCellDoubleLGIIN.this.textField.setText(val);
            }
        });
        this.textField.focusedProperty().addListener((ChangeListener)new ChangeListener<Boolean>(){

            public void changed(ObservableValue<? extends Boolean> observable, Boolean oldValue, Boolean newValue) {
                if (!newValue.booleanValue() && EditingCellDoubleLGIIN.this.textField != null) {
                    try {
                        EditingCellDoubleLGIIN.this.esistenza = ((ColumnTablePoolSimple)EditingCellDoubleLGIIN.this.controller.table_vasca_giacenza.getSelectionModel().getSelectedItem()).getColumn_residuo();
                        String tax = EditingCellDoubleLGIIN.this.textField.getText();
                        if (tax.equals("")) {
                            tax = "0";
                        }
                        String prodotto = EditingCellDoubleLGIIN.this.controller.editText_tipovino_giacenza1.getText().trim();
                        String massa = FXMLDocumentController.ricerca.getSianAnaProdotto(prodotto);
                        String categoria = FXMLDocumentController.ricerca.getCategoriaProdottofromProdotto(prodotto);
                        String um = FXMLDocumentController.ricerca.getUMfromCategoriaProdotto(categoria);
                        double massa_vol = 0.0;
                        JSONArray ar = FXMLDocumentController.jsonUtil.strJsonToJSONArray(massa);
                        for (int i = 0; i < ar.length(); ++i) {
                            JSONObject obj = ar.getJSONObject(i);
                            massa_vol = obj.getDouble("sian_massa_volumica");
                        }
                        double val = Double.parseDouble(tax);
                        double Kg = 0.0;
                        Kg = um.toLowerCase().equals("kg") && massa_vol > 0.0 ? (massa_vol < 99.0 ? val * massa_vol : val) : val;
                        HashMap lis = FXMLDocumentController.util.getParameters();
                        String gestione_vasche = lis.get("GESTIONE_VASCHE").toString();
                        int id = EditingCellDoubleLGIIN.this.controller.table_vasca_giacenza.getSelectionModel().getSelectedIndex();
                        if (um.toLowerCase().equals("l") || um.toLowerCase().equals("kg") && massa_vol > 0.0) {
                            if (Boolean.parseBoolean(gestione_vasche)) {
                                if (val <= EditingCellDoubleLGIIN.this.esistenza * 100.0) {
                                    EditingCellDoubleLGIIN.this.commitEdit(FXMLDocumentController.util.MyMathRound(val, 3));
                                    ((ColumnTablePoolSimple)EditingCellDoubleLGIIN.this.controller.lista_vasca_giacenza.get(id)).setColumn_qtaL(FXMLDocumentController.util.MyMathRound(val, 3));
                                    ((ColumnTablePoolSimple)EditingCellDoubleLGIIN.this.controller.lista_vasca_giacenza.get(id)).setColumn_qtaKg(FXMLDocumentController.util.MyMathRound(Kg, 3));
                                    EditingCellDoubleLGIIN.this.controller.table_vasca_giacenza.refresh();
                                } else {
                                    EditingCellDoubleLGIIN.this.error = "La Qta inserita non pu\u00f2 essere superiore alla Giacenza.";
                                    FXMLDocumentController.toast.startToast(EditingCellDoubleLGIIN.this.error, "ERRORE", "ERRORE");
                                }
                            } else {
                                EditingCellDoubleLGIIN.this.commitEdit(FXMLDocumentController.util.MyMathRound(val, 3));
                                ((ColumnTablePoolSimple)EditingCellDoubleLGIIN.this.controller.lista_vasca_giacenza.get(id)).setColumn_qtaL(FXMLDocumentController.util.MyMathRound(val, 3));
                                ((ColumnTablePoolSimple)EditingCellDoubleLGIIN.this.controller.lista_vasca_giacenza.get(id)).setColumn_qtaKg(FXMLDocumentController.util.MyMathRound(Kg, 3));
                                EditingCellDoubleLGIIN.this.controller.table_vasca_giacenza.refresh();
                            }
                        } else {
                            EditingCellDoubleLGIIN.this.commitEdit(FXMLDocumentController.util.MyMathRound(val, 3));
                            ((ColumnTablePoolSimple)EditingCellDoubleLGIIN.this.controller.lista_vasca_giacenza.get(id)).setColumn_qtaL(FXMLDocumentController.util.MyMathRound(val, 3));
                            ((ColumnTablePoolSimple)EditingCellDoubleLGIIN.this.controller.lista_vasca_giacenza.get(id)).setColumn_qtaKg(FXMLDocumentController.util.MyMathRound(Kg, 3));
                            EditingCellDoubleLGIIN.this.controller.table_vasca_giacenza.refresh();
                        }
                        double qtaL = 0.0;
                        double qtaKg = 0.0;
                        for (int i = 0; i < EditingCellDoubleLGIIN.this.controller.lista_vasca_giacenza.size(); ++i) {
                            qtaL += ((ColumnTablePoolSimple)EditingCellDoubleLGIIN.this.controller.lista_vasca_giacenza.get(i)).getColumn_qtaL();
                            qtaKg += ((ColumnTablePoolSimple)EditingCellDoubleLGIIN.this.controller.lista_vasca_giacenza.get(i)).getColumn_qtaKg();
                        }
                        EditingCellDoubleLGIIN.this.controller.editText_qta_giacenza.setText(FXMLDocumentController.util.MyMathRound(qtaKg, 3) + "");
                        EditingCellDoubleLGIIN.this.controller.editText_qtalitri_giacenza.setText(FXMLDocumentController.util.MyMathRound(qtaL, 3) + "");
                        EditingCellDoubleLGIIN.this.controller.editText_capcitatipovino_giacenza.setText("0");
                        EditingCellDoubleLGIIN.this.controller.table_vasca_giacenza.refresh();
                    }
                    catch (IOException ex) {
                        Logger.getLogger(EditingCellDoubleLGIIN.class.getName()).log(Level.SEVERE, null, ex);
                    }
                    catch (URISyntaxException ex) {
                        Logger.getLogger(EditingCellDoubleLGIIN.class.getName()).log(Level.SEVERE, null, ex);
                    }
                    catch (JSONException ex) {
                        Logger.getLogger(EditingCellDoubleLGIIN.class.getName()).log(Level.SEVERE, null, ex);
                    }
                }
            }
        });
        this.textField.setOnKeyReleased((EventHandler)new EventHandler<KeyEvent>(){

            public void handle(KeyEvent t) {
                if (t.getCode() == KeyCode.ENTER) {
                    EditingCellDoubleLGIIN.this.controller.table_vasca_giacenza.requestFocus();
                } else if (t.getCode() == KeyCode.ESCAPE) {
                    EditingCellDoubleLGIIN.this.cancelEdit();
                    EditingCellDoubleLGIIN.this.textField.setText("0.0");
                }
            }
        });
    }

    private String getString() {
        return this.getItem() == null ? "" : ((Double)this.getItem()).toString();
    }
}

