/*
 * Decompiled with CFR 0.152.
 */
package vin.Class;

import javafx.scene.Node;
import javafx.scene.control.ContentDisplay;
import javafx.scene.control.TableCell;
import javafx.scene.control.TextField;
import javafx.scene.input.KeyCode;
import vin.Class.Ricerca;
import vin.Uility.JsonUtils;
import vin.Uility.Utility;
import vin.controller.ToastFXMessages;

public class EditingCellDoubleCarico3
extends TableCell {
    private TextField textField;
    public String error = "";
    ToastFXMessages tx = new ToastFXMessages();
    Ricerca ricerca = new Ricerca();
    Utility util;
    Double esistenza = 0.0;
    String prodotto = "";
    JsonUtils jsonUtil = new JsonUtils();

    public EditingCellDoubleCarico3(String prodotto) {
        try {
            this.util = new Utility();
            this.prodotto = prodotto;
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
        }
    }

    public void startEdit() {
        super.startEdit();
        if (this.textField == null) {
            this.createTextField();
        }
        this.setText(null);
        this.setGraphic((Node)this.textField);
        this.setContentDisplay(ContentDisplay.GRAPHIC_ONLY);
        this.textField.requestFocus();
    }

    public void cancelEdit() {
        super.cancelEdit();
        this.setText(String.valueOf(this.getItem()));
        this.setContentDisplay(ContentDisplay.TEXT_ONLY);
        this.setGraphic(null);
    }

    protected void updateItem(Object item, boolean empty) {
        super.updateItem(item, empty);
        if (empty) {
            this.setText(null);
            this.setGraphic(null);
        } else {
            String h = "";
            if (this.isEditing()) {
                if (this.textField != null) {
                    this.textField.setText(this.getString());
                }
                this.setText(null);
                this.setGraphic((Node)this.textField);
                this.setContentDisplay(ContentDisplay.GRAPHIC_ONLY);
            } else {
                this.setText(this.getString());
                this.setContentDisplay(ContentDisplay.TEXT_ONLY);
            }
        }
    }

    private void createTextField() {
        this.textField = new TextField(this.getString());
        this.textField.setMinWidth(this.getWidth() - this.getGraphicTextGap() * 2.0);
        this.textField.textProperty().addListener((observable, oldValue, newValue) -> {
            String val = newValue.replaceAll("[A-z,]", "");
            this.textField.setText(val);
        });
        this.textField.setOnKeyReleased(t -> {
            if (t.getCode() == KeyCode.ENTER) {
                super.getTableView().requestFocus();
            } else if (t.getCode() == KeyCode.ESCAPE) {
                this.cancelEdit();
                this.textField.setText("");
            }
        });
        this.textField.focusedProperty().addListener((observable, oldValue, newValue) -> {
            if (!newValue.booleanValue() && this.textField != null) {
                try {
                    String val = this.textField.getText().trim();
                    if (val.equals("")) {
                        val = "0.0";
                    }
                    if (!val.equals("")) {
                        this.commitEdit(Double.parseDouble(val));
                        this.getTableView().refresh();
                        this.textField.setText("");
                    }
                }
                catch (Exception ex) {
                    System.out.println(ex.getMessage());
                }
            }
        });
    }

    private String getString() {
        return this.getItem() == null ? "" : this.getItem().toString();
    }
}

