/*
 * Decompiled with CFR 0.152.
 */
package vin.Class;

import java.io.IOException;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.event.EventHandler;
import javafx.scene.Node;
import javafx.scene.control.ContentDisplay;
import javafx.scene.control.TableCell;
import javafx.scene.control.TextField;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import vin.Class.ColumnTablePoolSimple;
import vin.Uility.Utility;
import vin.controller.FXMLDocumentController;
import vin.controller.ToastFXMessages;
import vin.operazioni.TabDERIController;

public class EditingCellDoubleCDERI
extends TableCell<ColumnTablePoolSimple, Double> {
    private TextField textField;
    public String error = "";
    ToastFXMessages tx = new ToastFXMessages();
    Utility util;
    Double esistenza = 0.0;
    TabDERIController controller = null;

    public EditingCellDoubleCDERI(TabDERIController controller) {
        try {
            this.util = new Utility();
            this.controller = controller;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void startEdit() {
        super.startEdit();
        if (this.textField == null) {
            this.createTextField();
        }
        this.setText(null);
        this.setGraphic((Node)this.textField);
        this.setContentDisplay(ContentDisplay.GRAPHIC_ONLY);
        this.textField.requestFocus();
    }

    public void cancelEdit() {
        super.cancelEdit();
        this.setText(String.valueOf(this.getItem()));
        this.setContentDisplay(ContentDisplay.TEXT_ONLY);
        this.setGraphic(null);
    }

    public void updateItem(Double item, boolean empty) {
        super.updateItem((Object)item, empty);
        if (empty) {
            this.setText(null);
            this.setGraphic(null);
        } else {
            String h = "";
            if (this.isEditing()) {
                if (this.textField != null) {
                    this.textField.setText(this.getString());
                }
                this.setText(null);
                this.setGraphic((Node)this.textField);
                this.setContentDisplay(ContentDisplay.GRAPHIC_ONLY);
            } else {
                this.setText(this.getString());
                this.setContentDisplay(ContentDisplay.TEXT_ONLY);
            }
        }
    }

    private void createTextField() {
        this.textField = new TextField(this.getString());
        this.textField.setMinWidth(this.getWidth() - this.getGraphicTextGap() * 2.0);
        this.textField.textProperty().addListener((ChangeListener)new ChangeListener<String>(){

            public void changed(ObservableValue<? extends String> observable, String oldValue, String newValue) {
                String val = newValue.replaceAll("[A-z,]", "");
                EditingCellDoubleCDERI.this.textField.setText(val);
            }
        });
        this.textField.setOnKeyReleased((EventHandler)new EventHandler<KeyEvent>(){

            public void handle(KeyEvent t) {
                if (t.getCode() == KeyCode.ENTER) {
                    EditingCellDoubleCDERI.this.controller.table_vascaC_deri.requestFocus();
                } else if (t.getCode() == KeyCode.ESCAPE) {
                    EditingCellDoubleCDERI.this.cancelEdit();
                    EditingCellDoubleCDERI.this.textField.setText("");
                }
            }
        });
        this.textField.focusedProperty().addListener((ChangeListener)new ChangeListener<Boolean>(){

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public void changed(ObservableValue<? extends Boolean> observable, Boolean oldValue, Boolean newValue) {
                if (newValue != false) return;
                if (EditingCellDoubleCDERI.this.textField == null) return;
                try {
                    String val = EditingCellDoubleCDERI.this.textField.getText().toString();
                    if (!val.equals("")) {
                        int idx = EditingCellDoubleCDERI.this.controller.table_vascaC_deri.getSelectionModel().getSelectedIndex();
                        double residuo = ((ColumnTablePoolSimple)EditingCellDoubleCDERI.this.controller.lista_table_vascaC_deri.get(idx)).getColumn_residuo();
                        String nomeColonna = EditingCellDoubleCDERI.this.getTableColumn().getText();
                        if (val.equals("")) {
                            val = "0.0";
                        }
                        String prodotto = EditingCellDoubleCDERI.this.controller.editText_prodottoC_deri.getText().trim();
                        String sian = FXMLDocumentController.ricerca.getSianAnaProdotto(prodotto);
                        String categoria = FXMLDocumentController.ricerca.getCategoriaProdottofromProdotto(prodotto);
                        String um = FXMLDocumentController.ricerca.getUMfromCategoriaProdotto(categoria);
                        double massa = 0.0;
                        if (!sian.contains("#ERR")) {
                            JSONArray ar = FXMLDocumentController.jsonUtil.strJsonToJSONArray(sian);
                            for (int i = 0; i < ar.length(); ++i) {
                                JSONObject obj = ar.getJSONObject(i);
                                massa = obj.getDouble("sian_massa_volumica");
                            }
                        }
                        double qtaKg = 0.0;
                        double qtaL = 0.0;
                        if (nomeColonna.toLowerCase().contains("kg")) {
                            qtaKg = Double.parseDouble(val);
                            qtaL = um.toLowerCase().equals("kg") && massa > 0.0 ? (massa < 99.0 ? FXMLDocumentController.util.MyMathRound(qtaKg / massa, 3) : qtaKg) : qtaKg;
                        } else {
                            qtaL = Double.parseDouble(val);
                            qtaKg = um.toLowerCase().equals("kg") && massa > 0.0 ? FXMLDocumentController.util.MyMathRound(qtaL * massa, 3) : qtaL;
                        }
                        HashMap lis = FXMLDocumentController.util.getParameters();
                        boolean GESTIONE_VASCHE = (Boolean)lis.get("GESTIONE_VASCHE");
                        boolean KG_ROUNDUP = (Boolean)lis.get("KG_ROUNDUP");
                        if (GESTIONE_VASCHE) {
                            if (um.toLowerCase().equals("kg") && massa > 0.0 || um.toLowerCase().equals("l")) {
                                double fr = FXMLDocumentController.util.MyMathRound(residuo * 100.0, 3);
                                if (!(qtaL <= fr)) {
                                    EditingCellDoubleCDERI.this.error = "La Qta inserita non pu\u00f2 essere superiore al residuo.";
                                    EditingCellDoubleCDERI.this.tx.startToast(EditingCellDoubleCDERI.this.error, "ERRORE", "ERRORE");
                                    return;
                                }
                                EditingCellDoubleCDERI.this.commitEdit(Double.parseDouble(val));
                            } else {
                                EditingCellDoubleCDERI.this.commitEdit(Double.parseDouble(val));
                            }
                        } else {
                            EditingCellDoubleCDERI.this.commitEdit(Double.parseDouble(val));
                        }
                        if (nomeColonna.toLowerCase().contains("kg")) {
                            ((ColumnTablePoolSimple)EditingCellDoubleCDERI.this.controller.lista_table_vascaC_deri.get(idx)).setColumn_qtaL(qtaL);
                        } else {
                            if (KG_ROUNDUP) {
                                qtaKg = FXMLDocumentController.util.RoundUpCeiling(qtaKg);
                            }
                            ((ColumnTablePoolSimple)EditingCellDoubleCDERI.this.controller.lista_table_vascaC_deri.get(idx)).setColumn_qtaKg(qtaKg);
                        }
                    }
                    EditingCellDoubleCDERI.this.controller.table_vascaC_deri.refresh();
                    EditingCellDoubleCDERI.this.textField.setText("");
                    return;
                }
                catch (IOException ex) {
                    Logger.getLogger(EditingCellDoubleCDERI.class.getName()).log(Level.SEVERE, null, ex);
                    return;
                }
                catch (URISyntaxException ex) {
                    Logger.getLogger(EditingCellDoubleCDERI.class.getName()).log(Level.SEVERE, null, ex);
                    return;
                }
                catch (JSONException ex) {
                    Logger.getLogger(EditingCellDoubleCDERI.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
        });
    }

    private String getString() {
        return this.getItem() == null ? "" : ((Double)this.getItem()).toString();
    }
}

