/*
 * Decompiled with CFR 0.152.
 */
package vin.Class;

import java.io.IOException;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.event.EventHandler;
import javafx.scene.Node;
import javafx.scene.control.ContentDisplay;
import javafx.scene.control.TableCell;
import javafx.scene.control.TextField;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import org.json.JSONException;
import vin.Class.ColumnTableIdoneitaImb;
import vin.Uility.Utility;
import vin.controller.ToastFXMessages;

public class EditingCellDouble
extends TableCell<ColumnTableIdoneitaImb, Double> {
    private TextField textField;
    private TextField fieldControl;
    public String error = "";
    ToastFXMessages tx = new ToastFXMessages();
    ObservableList<ColumnTableIdoneitaImb> list = FXCollections.observableArrayList();
    Utility util;
    Double esistenza = 0.0;

    public EditingCellDouble(TextField controlField) {
        try {
            this.util = new Utility();
            this.fieldControl = controlField;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void startEdit() {
        super.startEdit();
        if (this.textField == null) {
            this.createTextField();
        }
        this.setText(null);
        this.setGraphic((Node)this.textField);
        this.setContentDisplay(ContentDisplay.GRAPHIC_ONLY);
        this.textField.requestFocus();
    }

    public void cancelEdit() {
        super.cancelEdit();
        this.setText(String.valueOf(this.getItem()));
        this.setContentDisplay(ContentDisplay.TEXT_ONLY);
        this.setGraphic(null);
    }

    public void updateItem(Double item, boolean empty) {
        super.updateItem((Object)item, empty);
        if (empty) {
            this.setText(null);
            this.setGraphic(null);
        } else if (this.isEditing()) {
            if (this.textField != null) {
                this.textField.setText(this.getString());
            }
            this.setText(null);
            this.setGraphic((Node)this.textField);
            this.setContentDisplay(ContentDisplay.GRAPHIC_ONLY);
        } else {
            this.setText(this.getString());
            this.setContentDisplay(ContentDisplay.TEXT_ONLY);
        }
    }

    private void createTextField() {
        this.textField = new TextField(this.getString());
        this.textField.setMinWidth(this.getWidth() - this.getGraphicTextGap() * 2.0);
        this.textField.textProperty().addListener((ChangeListener)new ChangeListener<String>(){

            public void changed(ObservableValue<? extends String> observable, String oldValue, String newValue) {
                String val = newValue.replaceAll("[A-z,]", "");
                EditingCellDouble.this.textField.setText(val);
            }
        });
        this.textField.setOnKeyReleased((EventHandler)new EventHandler<KeyEvent>(){

            public void handle(KeyEvent t) {
                if (t.getCode() == KeyCode.ENTER) {
                    block11: {
                        if (EditingCellDouble.this.fieldControl != null) {
                            String val = EditingCellDouble.this.fieldControl.getText();
                            if (!val.equals("0.0") && !val.equals("")) {
                                try {
                                    HashMap lis = EditingCellDouble.this.util.getParameters();
                                    boolean GESTIONE_VASCHE = (Boolean)lis.get("GESTIONE_VASCHE");
                                    if (GESTIONE_VASCHE) {
                                        if (!(Double.parseDouble(EditingCellDouble.this.textField.getText()) <= Double.parseDouble(val))) {
                                            EditingCellDouble.this.error = "La Qta non pu\u00f2 essere minore della somma della \n qta delle idoneit\u00e0.";
                                            EditingCellDouble.this.tx.startToast(EditingCellDouble.this.error, "ERRORE", "ERRORE");
                                        }
                                        break block11;
                                    }
                                    EditingCellDouble.this.commitEdit(Double.parseDouble(EditingCellDouble.this.textField.getText()));
                                }
                                catch (IOException | URISyntaxException | JSONException ex) {
                                    Logger.getLogger(EditingCellDouble.class.getName()).log(Level.SEVERE, null, ex);
                                }
                            } else {
                                EditingCellDouble.this.error = "Campo (Qta) obbligatorio.";
                                EditingCellDouble.this.tx.startToast(EditingCellDouble.this.error, "ERRORE", "ERRORE");
                            }
                        } else {
                            EditingCellDouble.this.commitEdit(Double.parseDouble(EditingCellDouble.this.textField.getText()));
                            EditingCellDouble.this.textField.setText("");
                        }
                    }
                    EditingCellDouble.this.textField.setText("");
                } else if (t.getCode() == KeyCode.ESCAPE) {
                    EditingCellDouble.this.cancelEdit();
                    EditingCellDouble.this.textField.setText("");
                }
            }
        });
    }

    private String getString() {
        return this.getItem() == null ? "" : ((Double)this.getItem()).toString();
    }
}

