/*
 * Decompiled with CFR 0.152.
 */
package vin.Class;

import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.time.ZoneId;
import java.util.Date;
import javafx.event.EventHandler;
import javafx.scene.Node;
import javafx.scene.control.DatePicker;
import javafx.scene.control.TableCell;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import vin.Class.ColumnTableLottoDocumenti;

public class DatePickerCell<S, T>
extends TableCell<ColumnTableLottoDocumenti, Date> {
    private DatePicker datePicker;

    public void startEdit() {
        if (!this.isEmpty()) {
            super.startEdit();
            this.createDatePicker();
            this.setText(null);
            this.setGraphic((Node)this.datePicker);
        }
    }

    public void cancelEdit() {
        super.cancelEdit();
        this.setText(this.getDate().toString());
        this.setGraphic(null);
    }

    public void updateItem(Date item, boolean empty) {
        super.updateItem((Object)item, empty);
        if (empty) {
            this.setText(null);
            this.setGraphic(null);
        } else if (this.isEditing()) {
            if (this.datePicker != null) {
                this.datePicker.setValue((Object)this.getDate());
            }
            this.setText(null);
            this.setGraphic((Node)this.datePicker);
        } else {
            String h = "";
            if (item != null) {
                SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd");
                LocalDate dtd = this.getDate();
                if (dtd != null) {
                    this.setText(this.getDate().toString());
                } else {
                    this.setText("");
                }
                this.setGraphic(null);
            } else {
                this.commitEdit(null);
                this.setText(null);
                this.setGraphic(null);
            }
        }
    }

    private void createDatePicker() {
        this.datePicker = new DatePicker(this.getDate());
        this.datePicker.setMinWidth(this.getWidth() - this.getGraphicTextGap() * 2.0);
        this.datePicker.setOnAction(e -> {
            LocalDate d = (LocalDate)this.datePicker.getValue();
            if (d != null) {
                this.commitEdit(Date.from(((LocalDate)this.datePicker.getValue()).atStartOfDay(ZoneId.systemDefault()).toInstant()));
            } else {
                this.commitEdit(null);
                this.datePicker.setValue(null);
                this.setText(null);
                this.setGraphic(null);
            }
        });
        this.datePicker.setOnKeyReleased((EventHandler)new EventHandler<KeyEvent>(){

            public void handle(KeyEvent t) {
                if (t.getCode() == KeyCode.ENTER) {
                    LocalDate d = (LocalDate)DatePickerCell.this.datePicker.getValue();
                    if (d != null) {
                        DatePickerCell.this.commitEdit(Date.from(((LocalDate)DatePickerCell.this.datePicker.getValue()).atStartOfDay(ZoneId.systemDefault()).toInstant()));
                    } else {
                        DatePickerCell.this.commitEdit(null);
                        DatePickerCell.this.datePicker.setValue(null);
                        DatePickerCell.this.setText(null);
                        DatePickerCell.this.setGraphic(null);
                    }
                } else if (t.getCode() == KeyCode.ESCAPE) {
                    LocalDate d = (LocalDate)DatePickerCell.this.datePicker.getValue();
                    if (d != null) {
                        DatePickerCell.this.commitEdit(Date.from(((LocalDate)DatePickerCell.this.datePicker.getValue()).atStartOfDay(ZoneId.systemDefault()).toInstant()));
                    } else {
                        DatePickerCell.this.commitEdit(null);
                        DatePickerCell.this.datePicker.setValue(null);
                        DatePickerCell.this.setText(null);
                        DatePickerCell.this.setGraphic(null);
                    }
                }
            }
        });
        this.datePicker.focusedProperty().addListener((observable, oldValue, newValue) -> {
            if (!newValue.booleanValue()) {
                LocalDate d = (LocalDate)this.datePicker.getValue();
                if (d != null) {
                    this.commitEdit(Date.from(((LocalDate)this.datePicker.getValue()).atStartOfDay(ZoneId.systemDefault()).toInstant()));
                } else {
                    this.commitEdit(null);
                    this.datePicker.setValue(null);
                    this.setText(null);
                    this.setGraphic(null);
                }
            }
        });
    }

    private LocalDate getDate() {
        return this.getItem() == null ? LocalDate.now() : ((Date)this.getItem()).toInstant().atZone(ZoneId.systemDefault()).toLocalDate();
    }
}

