/*
 * Decompiled with CFR 0.152.
 */
package vin.Class;

import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.time.ZoneId;
import java.util.Date;
import javafx.scene.Node;
import javafx.scene.control.DatePicker;
import javafx.scene.control.TableCell;
import vin.Class.ColumnTablePoolCompleta;

class DateEditingCell
extends TableCell<ColumnTablePoolCompleta, Date> {
    private DatePicker datePicker;

    private DateEditingCell() {
    }

    public void startEdit() {
        if (!this.isEmpty()) {
            super.startEdit();
            this.createDatePicker();
            this.setText(null);
            this.setGraphic((Node)this.datePicker);
        }
    }

    public void cancelEdit() {
        super.cancelEdit();
        String dat = new SimpleDateFormat("dd-MM-yyyy").format(this.getDate());
        this.setText(dat);
        this.setGraphic(null);
    }

    public void updateItem(Date item, boolean empty) {
        super.updateItem((Object)item, empty);
        if (empty) {
            this.setText(null);
            this.setGraphic(null);
        } else if (this.isEditing()) {
            if (this.datePicker != null) {
                this.datePicker.setValue((Object)this.getDate());
            }
            String dat = new SimpleDateFormat("dd-MM-yyyy").format(this.getDate());
            this.setText(dat);
            this.setGraphic(null);
        } else {
            String h = "";
            if (item != null) {
                String dat = new SimpleDateFormat("dd-MM-yyyy").format(this.getDate());
                this.setText(dat);
                this.setGraphic(null);
            } else {
                this.commitEdit(null);
                this.setText(null);
                this.setGraphic(null);
            }
        }
    }

    private void createDatePicker() {
        this.datePicker = new DatePicker(this.getDate());
        this.datePicker.setMinWidth(this.getWidth() - this.getGraphicTextGap() * 2.0);
        this.datePicker.setOnAction(e -> {
            System.out.println("Committed: " + ((LocalDate)this.datePicker.getValue()).toString());
            this.commitEdit(Date.from(((LocalDate)this.datePicker.getValue()).atStartOfDay(ZoneId.systemDefault()).toInstant()));
        });
    }

    private LocalDate getDate() {
        return this.getItem() == null ? LocalDate.now() : ((Date)this.getItem()).toInstant().atZone(ZoneId.systemDefault()).toLocalDate();
    }
}

