/*
 * Decompiled with CFR 0.152.
 */
package vin.Class;

import javafx.collections.ObservableList;
import javafx.scene.Node;
import javafx.scene.control.ComboBox;
import javafx.scene.control.ListCell;
import javafx.scene.control.TableCell;
import vin.Class.CodiceDescrizione;

public class ComboBoxCell
extends TableCell<ObservableList, CodiceDescrizione> {
    private ComboBox<CodiceDescrizione> comboBox;
    ObservableList lista = null;

    public ComboBoxCell(ObservableList list) {
        this.lista = list;
    }

    public void startEdit() {
        if (!this.isEmpty()) {
            super.startEdit();
            this.createComboBox();
            this.setText(null);
            this.setGraphic((Node)this.comboBox);
        }
    }

    public void cancelEdit() {
        super.cancelEdit();
        this.setText(this.getTyp().getCodice());
        this.setGraphic(null);
    }

    protected void updateItem(CodiceDescrizione t, boolean bln) {
        super.updateItem((Object)t, bln);
        if (bln) {
            this.setText(null);
            this.setGraphic(null);
        } else if (this.isEditing()) {
            if (this.comboBox != null) {
                this.comboBox.setValue((Object)this.getTyp());
            }
            this.setText(this.getTyp().getDescrizione());
            this.setGraphic((Node)this.comboBox);
        } else {
            String h = "";
            if (t != null) {
                this.setText(this.getTyp().getDescrizione());
                this.setGraphic(null);
            } else {
                this.commitEdit(null);
                this.setText(null);
                this.setGraphic(null);
            }
        }
    }

    private void createComboBox() {
        this.comboBox = new ComboBox(this.lista);
        this.comboBox.valueProperty().set((Object)this.getTyp());
        this.comboBox.setMinWidth(this.getWidth() - this.getGraphicTextGap() * 2.0);
        this.comboBox.setOnAction(e -> {
            if (this.comboBox.getSelectionModel().getSelectedItem() != null) {
                System.out.println("Committed: " + this.comboBox.getSelectionModel().getSelectedItem());
                this.commitEdit(new CodiceDescrizione(((CodiceDescrizione)this.comboBox.getSelectionModel().getSelectedItem()).getCodice(), ((CodiceDescrizione)this.comboBox.getSelectionModel().getSelectedItem()).getDescrizione()));
            } else {
                this.commitEdit(null);
            }
        });
    }

    private void comboBoxConverter(ComboBox<CodiceDescrizione> comboBox) {
        comboBox.setCellFactory(c -> new ListCell<CodiceDescrizione>(){

            protected void updateItem(CodiceDescrizione item, boolean empty) {
                super.updateItem((Object)item, empty);
                if (item == null || empty) {
                    this.setText(null);
                } else {
                    this.setText(item.toString());
                }
            }
        });
    }

    public CodiceDescrizione getTyp() {
        return this.getItem() == null ? new CodiceDescrizione("", "") : (CodiceDescrizione)this.getItem();
    }
}

