/*
 * Decompiled with CFR 0.152.
 */
package vin.Class;

import com.jfoenix.controls.JFXComboBox;
import com.sun.javafx.scene.control.skin.ComboBoxListViewSkin;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.event.EventHandler;
import javafx.scene.control.ListView;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;

public class AutoCompleter<T>
implements EventHandler<KeyEvent> {
    private JFXComboBox comboBox;
    private StringBuilder sb;
    private ObservableList<T> data;
    private boolean moveCaretToPos = false;
    private int caretPos;

    public AutoCompleter(final JFXComboBox comboBox) {
        this.comboBox = comboBox;
        this.sb = new StringBuilder();
        this.data = comboBox.getItems();
        this.comboBox.setEditable(true);
        this.comboBox.setOnKeyPressed((EventHandler)new EventHandler<KeyEvent>(){

            public void handle(KeyEvent t) {
                comboBox.hide();
            }
        });
        this.comboBox.setOnKeyReleased((EventHandler)this);
    }

    public void handle(KeyEvent event) {
        ListView lv = ((ComboBoxListViewSkin)this.comboBox.getSkin()).getListView();
        if (event.getCode() == KeyCode.UP) {
            this.caretPos = -1;
            this.moveCaret(this.comboBox.getEditor().getText().length());
            return;
        }
        if (event.getCode() == KeyCode.DOWN) {
            if (!this.comboBox.isShowing()) {
                this.comboBox.show();
            }
            this.caretPos = -1;
            this.moveCaret(this.comboBox.getEditor().getText().length());
            return;
        }
        if (event.getCode() == KeyCode.BACK_SPACE) {
            this.moveCaretToPos = true;
            this.caretPos = this.comboBox.getEditor().getCaretPosition();
        } else if (event.getCode() == KeyCode.DELETE) {
            this.moveCaretToPos = true;
            this.caretPos = this.comboBox.getEditor().getCaretPosition();
        }
        if (event.getCode() == KeyCode.RIGHT || event.getCode() == KeyCode.LEFT || event.isControlDown() || event.getCode() == KeyCode.HOME || event.getCode() == KeyCode.END || event.getCode() == KeyCode.TAB) {
            return;
        }
        ObservableList list = FXCollections.observableArrayList();
        if (this.data != null) {
            for (int i = 0; i < this.data.size(); ++i) {
                if (this.data.get(i) == null || !this.data.get(i).toString().toLowerCase().startsWith(this.comboBox.getEditor().getText().toLowerCase())) continue;
                list.add(this.data.get(i));
            }
        }
        String t = this.comboBox.getEditor().getText();
        this.comboBox.setItems(list);
        this.comboBox.getEditor().setText(t);
        if (!this.moveCaretToPos) {
            this.caretPos = -1;
        }
        this.moveCaret(t.length());
        if (!list.isEmpty()) {
            this.comboBox.show();
        }
    }

    private void moveCaret(int textLength) {
        if (this.caretPos == -1) {
            this.comboBox.getEditor().positionCaret(textLength);
        } else {
            this.comboBox.getEditor().positionCaret(this.caretPos);
        }
        this.moveCaretToPos = false;
    }
}

