/*
 * Decompiled with CFR 0.152.
 */
package vin.Class;

import javafx.collections.ObservableList;
import javafx.collections.transformation.FilteredList;
import javafx.collections.transformation.SortedList;
import javafx.scene.control.ComboBox;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.scene.input.MouseEvent;
import javafx.util.StringConverter;

public class AutoCompleteComboBox<T>
extends ComboBox<T> {
    private FilteredList<T> filteredItems;
    private SortedList<T> sortedItems;

    public AutoCompleteComboBox(StringConverter<T> converter) {
        this.setEditable(true);
        this.setOnKeyReleased(e -> this.handleOnKeyReleasedEvent((KeyEvent)e));
        this.setOnMouseClicked(e -> this.handleOnMouseClicked((MouseEvent)e));
        super.setConverter(converter);
    }

    private void handleOnMouseClicked(MouseEvent e) {
        this.getItems().stream().filter(item -> item.toString().equals(this.getEditor().getText())).forEach(item -> this.getSelectionModel().select(item));
        this.setCaretPositionToEnd();
    }

    private void handleOnKeyReleasedEvent(KeyEvent e) {
        if (e.getCode() == KeyCode.UP || e.getCode() == KeyCode.DOWN) {
            this.getItems().stream().filter(item -> item.toString().equals(this.getEditor().getText())).forEach(item -> this.getSelectionModel().select(item));
            this.show();
            this.setCaretPositionToEnd();
        } else if (e.getCode() == KeyCode.ENTER || e.getCode() == KeyCode.TAB) {
            String editorStr = this.getEditor().getText();
            this.getSelectionModel().clearSelection();
            this.getEditor().setText(editorStr);
            this.setItems((ObservableList)this.sortedItems);
            this.getItems().stream().filter(item -> item.toString().equals(editorStr)).forEach(item -> this.getSelectionModel().select(item));
            this.getEditor().selectEnd();
            if (e.getCode() == KeyCode.ENTER) {
                this.getEditor().deselect();
            }
            this.hide();
        } else if (e.getText().length() == 1) {
            this.getSelectionModel().clearSelection();
            if (this.getEditor().getText().length() == 0) {
                this.getEditor().setText(e.getText());
            }
            this.filterSelectionList();
            this.show();
        } else if (e.getCode() == KeyCode.BACK_SPACE && this.getEditor().getText().length() > 0) {
            String editorStr = this.getEditor().getText();
            this.getSelectionModel().clearSelection();
            this.getEditor().setText(editorStr);
            int beforeFilter = this.getItems().size();
            this.filterSelectionList();
            int afterFilter = this.getItems().size();
            if (afterFilter > beforeFilter) {
                this.hide();
            }
            this.show();
        } else if (e.getCode() == KeyCode.BACK_SPACE && this.getEditor().getText().length() == 0) {
            this.clearSelection();
            this.hide();
            this.show();
        }
    }

    private void filterSelectionList() {
        this.setFilteredItems();
        this.setCaretPositionToEnd();
    }

    private void setFilteredItems() {
        this.filteredItems.setPredicate(item -> item.toString().toLowerCase().startsWith(this.getEditor().getText().toLowerCase()));
    }

    private void setCaretPositionToEnd() {
        this.getEditor().selectEnd();
        this.getEditor().deselect();
    }

    public void setInitItems(ObservableList<T> values) {
        this.filteredItems = new FilteredList(values);
        this.sortedItems = new SortedList(this.filteredItems);
        this.setItems((ObservableList)this.sortedItems);
    }

    public void clearSelection() {
        this.getSelectionModel().clearSelection();
        this.getEditor().clear();
        if (this.filteredItems != null) {
            this.filteredItems.setPredicate(item -> true);
        }
    }

    public T getSelectedItem() {
        Object selectedItem = null;
        if (this.getSelectionModel().getSelectedIndex() > -1) {
            selectedItem = this.getItems().get(this.getSelectionModel().getSelectedIndex());
        }
        return (T)selectedItem;
    }

    public void select(String value) {
        if (!value.isEmpty()) {
            this.getItems().stream().filter(item -> value.equals(item.toString())).findFirst().ifPresent(item -> this.getSelectionModel().select(item));
        }
    }
}

