/*
 * Decompiled with CFR 0.152.
 */
package accise.controller.anagrafiche;

import accise.classi.ColumnTableNazioneAccisa;
import java.net.URL;
import java.time.LocalDate;
import java.time.LocalTime;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.application.Platform;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.control.TableCell;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.cell.PropertyValueFactory;
import javafx.util.Callback;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import vin.Class.CodiceDescrizione;
import vin.Class.ComboBoxCell;
import vin.Class.EditingCellStringDouble;
import vin.Class.WorkIndicatorDialog;
import vin.controller.FXMLDocumentController;

public class TabellaAcciseNazioniController
implements Initializable {
    @FXML
    private TableView<ColumnTableNazioneAccisa> table;
    @FXML
    private TableColumn<ColumnTableNazioneAccisa, CodiceDescrizione> column_nazione;
    @FXML
    private TableColumn<ColumnTableNazioneAccisa, CodiceDescrizione> column_cpa;
    @FXML
    private TableColumn<ColumnTableNazioneAccisa, String> column_gradomin;
    @FXML
    private TableColumn<ColumnTableNazioneAccisa, String> column_gradomax;
    @FXML
    private TableColumn<ColumnTableNazioneAccisa, String> column_aliquota;
    public ObservableList<CodiceDescrizione> lista_cpa = FXCollections.observableArrayList();
    public ObservableList<ColumnTableNazioneAccisa> lista = FXCollections.observableArrayList();
    public ObservableList<CodiceDescrizione> lista_nazione = FXCollections.observableArrayList();
    WorkIndicatorDialog wd = null;

    public void initialize(URL url, ResourceBundle rb) {
        Platform.runLater((Runnable)new Runnable(){

            @Override
            public void run() {
                try {
                    TabellaAcciseNazioniController.this.setListaNazione();
                    TabellaAcciseNazioniController.this.setListaCPA();
                    TabellaAcciseNazioniController.this.refreshList();
                }
                catch (JSONException ex) {
                    Logger.getLogger(TabellaAcciseNazioniController.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
        });
        this.column_aliquota.setCellValueFactory((Callback)new PropertyValueFactory("column_aliquota"));
        this.column_cpa.setCellValueFactory((Callback)new PropertyValueFactory("column_cpa"));
        this.column_gradomax.setCellValueFactory((Callback)new PropertyValueFactory("column_gradomax"));
        this.column_gradomin.setCellValueFactory((Callback)new PropertyValueFactory("column_gradomin"));
        this.column_nazione.setCellValueFactory((Callback)new PropertyValueFactory("column_nazione"));
        Callback<TableColumn<ColumnTableNazioneAccisa, String>, TableCell<ColumnTableNazioneAccisa, String>> cellFactodrwygiacenzaf = new Callback<TableColumn<ColumnTableNazioneAccisa, String>, TableCell<ColumnTableNazioneAccisa, String>>(){

            public TableCell call(TableColumn p) {
                return new EditingCellStringDouble();
            }
        };
        Callback<TableColumn<ColumnTableNazioneAccisa, CodiceDescrizione>, TableCell<ColumnTableNazioneAccisa, CodiceDescrizione>> cpacell = new Callback<TableColumn<ColumnTableNazioneAccisa, CodiceDescrizione>, TableCell<ColumnTableNazioneAccisa, CodiceDescrizione>>(){

            public TableCell call(TableColumn p) {
                return new ComboBoxCell(TabellaAcciseNazioniController.this.lista_cpa);
            }
        };
        Callback<TableColumn<ColumnTableNazioneAccisa, CodiceDescrizione>, TableCell<ColumnTableNazioneAccisa, CodiceDescrizione>> nazionecell = new Callback<TableColumn<ColumnTableNazioneAccisa, CodiceDescrizione>, TableCell<ColumnTableNazioneAccisa, CodiceDescrizione>>(){

            public TableCell call(TableColumn p) {
                return new ComboBoxCell(TabellaAcciseNazioniController.this.lista_nazione);
            }
        };
        this.column_cpa.setCellFactory((Callback)cpacell);
        this.column_cpa.setOnEditCommit((EventHandler)new EventHandler<TableColumn.CellEditEvent<ColumnTableNazioneAccisa, CodiceDescrizione>>(){

            public void handle(TableColumn.CellEditEvent<ColumnTableNazioneAccisa, CodiceDescrizione> t) {
                try {
                    String codice = "";
                    if (t.getNewValue() != null) {
                        codice = ((CodiceDescrizione)t.getNewValue()).getCodice();
                    }
                    String id = ((ColumnTableNazioneAccisa)t.getTableView().getItems().get(t.getTablePosition().getRow())).getColumn_id();
                    ColumnTableNazioneAccisa obj = (ColumnTableNazioneAccisa)t.getTableView().getItems().get(t.getTablePosition().getRow());
                    obj.setColumn_nazione((CodiceDescrizione)t.getNewValue());
                    TabellaAcciseNazioniController.this.saveCPA(codice, id);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
        this.column_nazione.setCellFactory((Callback)nazionecell);
        this.column_nazione.setOnEditCommit((EventHandler)new EventHandler<TableColumn.CellEditEvent<ColumnTableNazioneAccisa, CodiceDescrizione>>(){

            public void handle(TableColumn.CellEditEvent<ColumnTableNazioneAccisa, CodiceDescrizione> t) {
                try {
                    String codice = "";
                    if (t.getNewValue() != null) {
                        codice = ((CodiceDescrizione)t.getNewValue()).getCodice();
                    }
                    String id = ((ColumnTableNazioneAccisa)t.getTableView().getItems().get(t.getTablePosition().getRow())).getColumn_id();
                    ColumnTableNazioneAccisa obj = (ColumnTableNazioneAccisa)t.getTableView().getItems().get(t.getTablePosition().getRow());
                    obj.setColumn_nazione((CodiceDescrizione)t.getNewValue());
                    TabellaAcciseNazioniController.this.saveNazione(codice, id);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
        this.column_gradomax.setCellFactory((Callback)cellFactodrwygiacenzaf);
        this.column_gradomax.setOnEditCommit((EventHandler)new EventHandler<TableColumn.CellEditEvent<ColumnTableNazioneAccisa, String>>(){

            public void handle(TableColumn.CellEditEvent<ColumnTableNazioneAccisa, String> t) {
                ((ColumnTableNazioneAccisa)t.getTableView().getItems().get(t.getTablePosition().getRow())).setColumn_gradomax((String)t.getNewValue());
                String id = ((ColumnTableNazioneAccisa)t.getTableView().getItems().get(t.getTablePosition().getRow())).getColumn_id();
                String codice = "";
                if (t.getNewValue() != null) {
                    codice = (String)t.getNewValue();
                }
                TabellaAcciseNazioniController.this.saveGradoMax(codice, id);
            }
        });
        this.column_gradomin.setCellFactory((Callback)cellFactodrwygiacenzaf);
        this.column_gradomin.setOnEditCommit((EventHandler)new EventHandler<TableColumn.CellEditEvent<ColumnTableNazioneAccisa, String>>(){

            public void handle(TableColumn.CellEditEvent<ColumnTableNazioneAccisa, String> t) {
                ((ColumnTableNazioneAccisa)t.getTableView().getItems().get(t.getTablePosition().getRow())).setColumn_gradomin((String)t.getNewValue());
                String id = ((ColumnTableNazioneAccisa)t.getTableView().getItems().get(t.getTablePosition().getRow())).getColumn_id();
                String codice = "";
                if (t.getNewValue() != null) {
                    codice = (String)t.getNewValue();
                }
                TabellaAcciseNazioniController.this.saveGradoMin(codice, id);
            }
        });
        this.column_aliquota.setCellFactory((Callback)cellFactodrwygiacenzaf);
        this.column_aliquota.setOnEditCommit((EventHandler)new EventHandler<TableColumn.CellEditEvent<ColumnTableNazioneAccisa, String>>(){

            public void handle(TableColumn.CellEditEvent<ColumnTableNazioneAccisa, String> t) {
                ((ColumnTableNazioneAccisa)t.getTableView().getItems().get(t.getTablePosition().getRow())).setColumn_aliquota((String)t.getNewValue());
                String id = ((ColumnTableNazioneAccisa)t.getTableView().getItems().get(t.getTablePosition().getRow())).getColumn_id();
                String codice = "";
                if (t.getNewValue() != null) {
                    codice = (String)t.getNewValue();
                }
                TabellaAcciseNazioniController.this.saveAliquota(codice, id);
            }
        });
        this.table.setItems(this.lista);
    }

    private void saveNazione(String codice, String id) {
        this.wd = new WorkIndicatorDialog(this.table.getScene().getWindow(), "Caricamento in corso...");
        this.wd.addTaskEndNotification(result -> {
            if (this.wd != null && this.wd.labelWord != null && !this.wd.labelWord.contains("OK")) {
                FXMLDocumentController.toast.startToast(this.wd.labelWord, "ERRORE", "ERRORE");
            }
        });
        this.wd.exec("123", inputParam -> {
            try {
                ArrayList<String> tipoSQL = new ArrayList<String>();
                ArrayList<String> strSQL = new ArrayList<String>();
                ArrayList<Integer> lenghtBidimensionalArray = new ArrayList<Integer>();
                ArrayList<Boolean> lastID = new ArrayList<Boolean>();
                String data_select = "";
                lastID.add(false);
                String str = "UPDATE accise_t_accisanazione SET nazione='" + codice + "' WHERE id=" + id;
                strSQL.add(str);
                tipoSQL.add("update");
                lenghtBidimensionalArray.add(0);
                String strJson = FXMLDocumentController.util.makeStringJsonDB("OFF", tipoSQL, strSQL, null, null, lastID, lenghtBidimensionalArray);
                this.wd.labelWord = data_select = FXMLDocumentController.sk1Comm.ServerEsecuteRequest(FXMLDocumentController.GLOBAL_IP, FXMLDocumentController.GLOBAL_PORT, "dbInteraction#@" + strJson);
            }
            catch (Exception ex) {
                this.wd.labelWord = ex.getMessage();
            }
            return 1;
        });
    }

    private void saveGradoMax(String codice, String id) {
        this.wd = new WorkIndicatorDialog(this.table.getScene().getWindow(), "Caricamento in corso...");
        this.wd.addTaskEndNotification(result -> {
            if (this.wd != null && this.wd.labelWord != null && !this.wd.labelWord.contains("OK")) {
                FXMLDocumentController.toast.startToast(this.wd.labelWord, "ERRORE", "ERRORE");
            }
        });
        this.wd.exec("123", inputParam -> {
            try {
                ArrayList<String> tipoSQL = new ArrayList<String>();
                ArrayList<String> strSQL = new ArrayList<String>();
                ArrayList<Integer> lenghtBidimensionalArray = new ArrayList<Integer>();
                ArrayList<Boolean> lastID = new ArrayList<Boolean>();
                String data_select = "";
                lastID.add(false);
                String str = "UPDATE accise_t_accisanazione SET grado_max='" + codice + "' WHERE id=" + id;
                strSQL.add(str);
                tipoSQL.add("update");
                lenghtBidimensionalArray.add(0);
                String strJson = FXMLDocumentController.util.makeStringJsonDB("OFF", tipoSQL, strSQL, null, null, lastID, lenghtBidimensionalArray);
                this.wd.labelWord = data_select = FXMLDocumentController.sk1Comm.ServerEsecuteRequest(FXMLDocumentController.GLOBAL_IP, FXMLDocumentController.GLOBAL_PORT, "dbInteraction#@" + strJson);
            }
            catch (Exception ex) {
                this.wd.labelWord = ex.getMessage();
            }
            return 1;
        });
    }

    private void saveAliquota(String codice, String id) {
        this.wd = new WorkIndicatorDialog(this.table.getScene().getWindow(), "Caricamento in corso...");
        this.wd.addTaskEndNotification(result -> {
            if (this.wd != null && this.wd.labelWord != null && !this.wd.labelWord.contains("OK")) {
                FXMLDocumentController.toast.startToast(this.wd.labelWord, "ERRORE", "ERRORE");
            }
        });
        this.wd.exec("123", inputParam -> {
            try {
                ArrayList<String> tipoSQL = new ArrayList<String>();
                ArrayList<String> strSQL = new ArrayList<String>();
                ArrayList<Integer> lenghtBidimensionalArray = new ArrayList<Integer>();
                ArrayList<Boolean> lastID = new ArrayList<Boolean>();
                String data_select = "";
                lastID.add(false);
                String str = "UPDATE accise_t_accisanazione SET aliquota='" + codice + "' WHERE id=" + id;
                strSQL.add(str);
                tipoSQL.add("update");
                lenghtBidimensionalArray.add(0);
                String strJson = FXMLDocumentController.util.makeStringJsonDB("OFF", tipoSQL, strSQL, null, null, lastID, lenghtBidimensionalArray);
                this.wd.labelWord = data_select = FXMLDocumentController.sk1Comm.ServerEsecuteRequest(FXMLDocumentController.GLOBAL_IP, FXMLDocumentController.GLOBAL_PORT, "dbInteraction#@" + strJson);
            }
            catch (Exception ex) {
                this.wd.labelWord = ex.getMessage();
            }
            return 1;
        });
    }

    private void saveGradoMin(String codice, String id) {
        this.wd = new WorkIndicatorDialog(this.table.getScene().getWindow(), "Caricamento in corso...");
        this.wd.addTaskEndNotification(result -> {
            if (this.wd != null && this.wd.labelWord != null && !this.wd.labelWord.contains("OK")) {
                FXMLDocumentController.toast.startToast(this.wd.labelWord, "ERRORE", "ERRORE");
            }
        });
        this.wd.exec("123", inputParam -> {
            try {
                ArrayList<String> tipoSQL = new ArrayList<String>();
                ArrayList<String> strSQL = new ArrayList<String>();
                ArrayList<Integer> lenghtBidimensionalArray = new ArrayList<Integer>();
                ArrayList<Boolean> lastID = new ArrayList<Boolean>();
                String data_select = "";
                lastID.add(false);
                String str = "UPDATE accise_t_accisanazione SET grado_min='" + codice + "' WHERE id=" + id;
                strSQL.add(str);
                tipoSQL.add("update");
                lenghtBidimensionalArray.add(0);
                String strJson = FXMLDocumentController.util.makeStringJsonDB("OFF", tipoSQL, strSQL, null, null, lastID, lenghtBidimensionalArray);
                this.wd.labelWord = data_select = FXMLDocumentController.sk1Comm.ServerEsecuteRequest(FXMLDocumentController.GLOBAL_IP, FXMLDocumentController.GLOBAL_PORT, "dbInteraction#@" + strJson);
            }
            catch (Exception ex) {
                this.wd.labelWord = ex.getMessage();
            }
            return 1;
        });
    }

    private void saveCPA(String codice, String id) {
        this.wd = new WorkIndicatorDialog(this.table.getScene().getWindow(), "Caricamento in corso...");
        this.wd.addTaskEndNotification(result -> {
            if (this.wd != null && this.wd.labelWord != null && !this.wd.labelWord.contains("OK")) {
                FXMLDocumentController.toast.startToast(this.wd.labelWord, "ERRORE", "ERRORE");
            }
        });
        this.wd.exec("123", inputParam -> {
            try {
                ArrayList<String> tipoSQL = new ArrayList<String>();
                ArrayList<String> strSQL = new ArrayList<String>();
                ArrayList<Integer> lenghtBidimensionalArray = new ArrayList<Integer>();
                ArrayList<Boolean> lastID = new ArrayList<Boolean>();
                String data_select = "";
                lastID.add(false);
                String str = "UPDATE accise_t_accisanazione SET cpa='" + codice + "' WHERE id=" + id;
                strSQL.add(str);
                tipoSQL.add("update");
                lenghtBidimensionalArray.add(0);
                String strJson = FXMLDocumentController.util.makeStringJsonDB("OFF", tipoSQL, strSQL, null, null, lastID, lenghtBidimensionalArray);
                this.wd.labelWord = data_select = FXMLDocumentController.sk1Comm.ServerEsecuteRequest(FXMLDocumentController.GLOBAL_IP, FXMLDocumentController.GLOBAL_PORT, "dbInteraction#@" + strJson);
            }
            catch (Exception ex) {
                this.wd.labelWord = ex.getMessage();
            }
            return 1;
        });
    }

    @FXML
    private void btnAggiungi(ActionEvent event) {
        try {
            this.insert("", "", "0", "0", "0");
            this.refreshList();
        }
        catch (JSONException ex) {
            Logger.getLogger(TabellaAcciseNazioniController.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    private void insert(String cpa, String nazione, String grado_min, String grado_max, String aliquota) throws JSONException {
        String[] res = new String[1];
        ArrayList<String> tipoSQL = new ArrayList<String>();
        ArrayList<String> strSQL = new ArrayList<String>();
        ArrayList<Integer> lenghtBidimensionalArray = new ArrayList<Integer>();
        ArrayList<Boolean> lastID = new ArrayList<Boolean>();
        String str = "";
        int iterator = 0;
        String data_select = "";
        String[][] tipo_ins = null;
        String[][] valore = null;
        HashMap<Integer, String[]> ipos = new HashMap<Integer, String[]>();
        HashMap<Integer, String[]> alores = new HashMap<Integer, String[]>();
        LocalDate data_oper = LocalDate.now();
        LocalTime ora_oper = LocalTime.now();
        FXMLDocumentController.sqlUtil.insert_t_accisenazione(nazione, cpa, grado_min, grado_max, aliquota);
        strSQL.addAll(FXMLDocumentController.sqlUtil.strSQL);
        tipoSQL.addAll(FXMLDocumentController.sqlUtil.tipoinsSQL);
        lenghtBidimensionalArray.addAll(FXMLDocumentController.sqlUtil.lengthSQL);
        lastID.addAll(FXMLDocumentController.sqlUtil.lastID);
        ipos.put(iterator, FXMLDocumentController.sqlUtil.tipovaloreSQL.toArray(new String[0]));
        alores.put(iterator, FXMLDocumentController.sqlUtil.valoreSQL.toArray(new String[0]));
        ++iterator;
        tipo_ins = FXMLDocumentController.util.HashMapBidimensionalTOArrayBidimensional(ipos);
        valore = FXMLDocumentController.util.HashMapBidimensionalTOArrayBidimensional(alores);
        String strJson = FXMLDocumentController.util.makeStringJsonDB("ON", tipoSQL, strSQL, tipo_ins, valore, lastID, lenghtBidimensionalArray);
        data_select = FXMLDocumentController.sk1Comm.ServerEsecuteRequest(FXMLDocumentController.GLOBAL_IP, FXMLDocumentController.GLOBAL_PORT, "dbInteraction#@" + strJson);
    }

    @FXML
    private void btnElimina(ActionEvent event) {
        ColumnTableNazioneAccisa codf = (ColumnTableNazioneAccisa)this.table.getSelectionModel().getSelectedItem();
        if (codf != null) {
            try {
                this.delete(codf.getColumn_id());
            }
            catch (JSONException ex) {
                Logger.getLogger(TabellaAcciseNazioniController.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }

    private void delete(String id) throws JSONException {
        ArrayList<String> tipoSQL = new ArrayList<String>();
        ArrayList<String> strSQL = new ArrayList<String>();
        ArrayList<Integer> lenghtBidimensionalArray = new ArrayList<Integer>();
        ArrayList<Boolean> lastID = new ArrayList<Boolean>();
        String data_select = "";
        lastID.add(false);
        strSQL.add("DELETE FROM accise_t_accisanazione WHERE id=" + id);
        tipoSQL.add("delete");
        lenghtBidimensionalArray.add(0);
        String strJson = FXMLDocumentController.util.makeStringJsonDB("OFF", tipoSQL, strSQL, null, null, lastID, lenghtBidimensionalArray);
        data_select = FXMLDocumentController.sk1Comm.ServerEsecuteRequest(FXMLDocumentController.GLOBAL_IP, FXMLDocumentController.GLOBAL_PORT, "dbInteraction#@" + strJson);
        if (!data_select.contains("#ERR:")) {
            FXMLDocumentController.toast.startToast("Operazione completata con successo", "SUCCESSO", "SUCCESSO");
            this.refreshList();
        }
    }

    private void setListaNazione() throws JSONException {
        this.lista_nazione.clear();
        this.lista_nazione.add(null);
        ArrayList<String> tipoSQL = new ArrayList<String>();
        ArrayList<String> strSQL = new ArrayList<String>();
        ArrayList<Integer> lenghtBidimensionalArray = new ArrayList<Integer>();
        ArrayList<Boolean> lastID = new ArrayList<Boolean>();
        String data_select = "";
        lastID.add(false);
        String str = "SELECT codice,descrizione  FROM  accise_t_a06 ORDER BY codice DESC";
        strSQL.add(str);
        tipoSQL.add("select");
        lenghtBidimensionalArray.add(0);
        String strJson = FXMLDocumentController.util.makeStringJsonDB("OFF", tipoSQL, strSQL, null, null, lastID, lenghtBidimensionalArray);
        data_select = FXMLDocumentController.sk1Comm.ServerEsecuteRequest(FXMLDocumentController.GLOBAL_IP, FXMLDocumentController.GLOBAL_PORT, "dbInteraction#@" + strJson);
        if (!data_select.contains("#ERR:")) {
            JSONArray arrayJson = FXMLDocumentController.jsonUtil.strJsonToJSONArray(data_select);
            for (int i = 0; i < arrayJson.length(); ++i) {
                JSONObject rec = arrayJson.getJSONObject(i);
                String codice = rec.get("codice").toString().toUpperCase();
                String descrizione = rec.get("descrizione").toString();
                this.lista_nazione.add((Object)new CodiceDescrizione(codice, descrizione));
            }
        }
    }

    private void setListaCPA() throws JSONException {
        this.lista_cpa.clear();
        this.lista_cpa.add(null);
        ArrayList<String> tipoSQL = new ArrayList<String>();
        ArrayList<String> strSQL = new ArrayList<String>();
        ArrayList<Integer> lenghtBidimensionalArray = new ArrayList<Integer>();
        ArrayList<Boolean> lastID = new ArrayList<Boolean>();
        String data_select = "";
        lastID.add(false);
        String str = "SELECT cpa,descrizione  FROM  accise_t_012 ";
        strSQL.add(str);
        tipoSQL.add("select");
        lenghtBidimensionalArray.add(0);
        String strJson = FXMLDocumentController.util.makeStringJsonDB("OFF", tipoSQL, strSQL, null, null, lastID, lenghtBidimensionalArray);
        data_select = FXMLDocumentController.sk1Comm.ServerEsecuteRequest(FXMLDocumentController.GLOBAL_IP, FXMLDocumentController.GLOBAL_PORT, "dbInteraction#@" + strJson);
        if (!data_select.contains("#ERR:")) {
            JSONArray arrayJson = FXMLDocumentController.jsonUtil.strJsonToJSONArray(data_select);
            for (int i = 0; i < arrayJson.length(); ++i) {
                JSONObject rec = arrayJson.getJSONObject(i);
                String codice = rec.get("cpa").toString();
                String descrizione = rec.get("descrizione").toString();
                this.lista_cpa.add((Object)new CodiceDescrizione(codice, descrizione));
            }
        }
    }

    private void refreshList() {
        this.wd = new WorkIndicatorDialog(this.table.getScene().getWindow(), "Caricamento in corso...");
        this.wd.addTaskEndNotification(result -> {
            if (this.wd.labelWord != null && !this.wd.labelWord.equals("")) {
                FXMLDocumentController.toast.startToast(this.wd.labelWord, "ERRORE", "ERRORE");
            }
            this.wd = null;
            this.table.refresh();
        });
        this.wd.exec("123", inputParam -> {
            try {
                this.wd.labelWord = "";
                this.lista.clear();
                ArrayList<String> tipoSQL = new ArrayList<String>();
                ArrayList<String> strSQL = new ArrayList<String>();
                ArrayList<Integer> lenghtBidimensionalArray = new ArrayList<Integer>();
                ArrayList<Boolean> lastID = new ArrayList<Boolean>();
                String data_select = "";
                lastID.add(false);
                String str = "SELECT id,nazione,b.descrizione AS descr_naz,bb.descrizione AS descr_cpa,a.cpa,grado_min,grado_max,aliquota  FROM accise_t_accisanazione AS a LEFT JOIN  accise_t_a06 AS b ON a.nazione=b.codice LEFT JOIN  accise_t_012 AS bb ON a.cpa=bb.cpa ORDER BY b.descrizione DESC";
                strSQL.add(str);
                tipoSQL.add("select");
                lenghtBidimensionalArray.add(0);
                String strJson = FXMLDocumentController.util.makeStringJsonDB("OFF", tipoSQL, strSQL, null, null, lastID, lenghtBidimensionalArray);
                data_select = FXMLDocumentController.sk1Comm.ServerEsecuteRequest(FXMLDocumentController.GLOBAL_IP, FXMLDocumentController.GLOBAL_PORT, "dbInteraction#@" + strJson);
                if (!data_select.contains("#ERR:")) {
                    JSONArray arrayJson = FXMLDocumentController.jsonUtil.strJsonToJSONArray(data_select);
                    for (int i = 0; i < arrayJson.length(); ++i) {
                        JSONObject rec = arrayJson.getJSONObject(i);
                        String nazione = rec.get("nazione").toString();
                        String descr_cpa = rec.get("descr_cpa").toString();
                        String descr_naz = rec.get("descr_naz").toString();
                        String id = rec.get("id").toString();
                        String cpa = rec.get("cpa").toString();
                        String grado_min = rec.get("grado_min").toString();
                        String grado_max = rec.get("grado_max").toString();
                        String aliquota = rec.get("aliquota").toString();
                        CodiceDescrizione naz = new CodiceDescrizione(nazione, descr_naz);
                        CodiceDescrizione cp = new CodiceDescrizione(cpa, descr_cpa);
                        this.lista.add((Object)new ColumnTableNazioneAccisa(id, naz, cp, grado_min, grado_max, aliquota));
                    }
                }
            }
            catch (Exception ex) {
                this.wd.labelWord = ex.getMessage();
            }
            return 1;
        });
    }
}

