/*
 * Decompiled with CFR 0.152.
 */
package accise.controller.anagrafiche;

import accise.classi.ColumnTableDestinatari;
import accise.controller.SearchButtonCliente;
import accise.controller.SearchSoggettoEAD;
import accise.controller.anagrafiche.DestinatariController;
import com.jfoenix.controls.JFXButton;
import com.jfoenix.controls.JFXDialog;
import com.jfoenix.controls.JFXDialogLayout;
import com.jfoenix.controls.JFXTextField;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Optional;
import java.util.ResourceBundle;
import java.util.function.ToIntFunction;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.application.Platform;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.fxml.FXML;
import javafx.fxml.FXMLLoader;
import javafx.fxml.Initializable;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Label;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.TextField;
import javafx.scene.control.TextInputDialog;
import javafx.scene.control.cell.PropertyValueFactory;
import javafx.scene.input.DragEvent;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Pane;
import javafx.scene.layout.Region;
import javafx.scene.layout.StackPane;
import javafx.scene.text.Text;
import javafx.stage.Modality;
import javafx.stage.Stage;
import javafx.stage.StageStyle;
import javafx.util.Callback;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import vin.Class.CodiceDescrizioneComboBox;
import vin.Class.WorkIndicatorDialog;
import vin.Uility.ImportFileCSV;
import vin.Uility.Utility;
import vin.conf.ConfConferimentiController;
import vin.controller.FXMLDocumentController;

public class SpeditoriController
implements Initializable {
    @FXML
    private TableView<ColumnTableDestinatari> table;
    @FXML
    private TableColumn<ColumnTableDestinatari, String> column_codice;
    @FXML
    private TableColumn<ColumnTableDestinatari, String> column_codicemexal;
    @FXML
    private TableColumn<ColumnTableDestinatari, String> column_denominazione;
    @FXML
    private TableColumn<ColumnTableDestinatari, String> column_id;
    @FXML
    private TableColumn<ColumnTableDestinatari, String> column_indirizzo;
    @FXML
    private TextField editText_codice;
    @FXML
    private TextField editText_codicecli;
    @FXML
    private TextField editText_denominazione;
    @FXML
    private TextField editText_indirizzo;
    @FXML
    private TextField editText_numerocivico;
    @FXML
    private TextField editText_cap;
    @FXML
    private TextField editText_citta;
    @FXML
    private TextField editText_codiceidentificativo;
    @FXML
    private ComboBox<CodiceDescrizioneComboBox> cmbx_linguadescr;
    @FXML
    StackPane stack;
    ObservableList<ColumnTableDestinatari> lista = FXCollections.observableArrayList();
    ObservableList<CodiceDescrizioneComboBox> lista_linguadescr = FXCollections.observableArrayList();
    double xOffset = 0.0;
    double yOffset = 0.0;
    WorkIndicatorDialog wd = null;
    boolean flg_modifica = false;
    boolean duplica = false;

    @FXML
    void btnCercaCliente(ActionEvent event) throws IOException {
        FXMLLoader loader = new FXMLLoader(this.getClass().getResource("/accise/view/SearchCliente.fxml"));
        Stage stage = new Stage();
        stage.setMaximized(false);
        stage.setTitle("CLIENTI/FORNITORI");
        stage.setScene(new Scene((Parent)((Pane)loader.load())));
        SearchSoggettoEAD controller = (SearchSoggettoEAD)loader.getController();
        stage.initModality(Modality.APPLICATION_MODAL);
        controller.setRICERCA_ACCISE_MEXAL(true);
        stage.setResizable(false);
        stage.showAndWait();
        String codice = controller.getCodice();
        String cap = controller.getCap();
        String descrizione = controller.getDescrizione();
        String indirizzo = controller.getIndirizzo();
        String citta = controller.getCitta();
        if (!codice.equals("")) {
            this.editText_codicecli.setText(codice);
            this.editText_cap.setText(cap);
            this.editText_citta.setText(citta);
            this.editText_denominazione.setText(descrizione);
            this.editText_indirizzo.setText(indirizzo);
            this.editText_codice.setText(codice);
        }
    }

    @FXML
    void btnElimina(ActionEvent event) {
        ColumnTableDestinatari oper = (ColumnTableDestinatari)this.table.getSelectionModel().getSelectedItem();
        if (oper != null) {
            TextInputDialog dialogim = new TextInputDialog("");
            dialogim.setTitle("SICUREZZA");
            dialogim.setHeaderText("Confermare la cancellazione dell'anagrafica " + oper.getColumn_codice() + " ?");
            dialogim.setContentText("Password (PROCEDI):");
            Optional resultim = dialogim.showAndWait();
            if (resultim.isPresent() && ((String)resultim.get()).trim().trim().equals("PROCEDI")) {
                this.wd = new WorkIndicatorDialog(this.table.getScene().getWindow(), "Caricamento in corso...");
                this.wd.addTaskEndNotification(result -> {
                    if (this.wd.labelWord.contains("#ERR")) {
                        String h = this.wd.labelWord;
                        this.wd = null;
                        FXMLDocumentController.util.alertWindow(this.stack, h, "ERRORE", "ERRORE");
                    } else {
                        this.flg_modifica = false;
                        FXMLDocumentController.toast.startToast("Operazione correttamente eseguita", "SUCCESSO", "SUCCESSO");
                        this.clearField();
                        this.wd = null;
                        this.refreshList("");
                    }
                });
                this.wd.exec("123", inputParam -> {
                    try {
                        this.elimina(oper.getColumn_id());
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    return 1;
                });
            }
        }
    }

    @FXML
    void btnModifica(ActionEvent event) {
        this.wd = new WorkIndicatorDialog(this.table.getScene().getWindow(), "Caricamento in corso...");
        this.wd.addTaskEndNotification(result -> {
            if (this.wd.labelWord != null && this.wd.labelWord.contains("#ERR:")) {
                FXMLDocumentController.util.alertWindow(this.stack, this.wd.labelWord, "ERRORE", "ERRORE");
            }
            this.wd = null;
            this.table.refresh();
        });
        this.wd.exec("123", new ToIntFunction(){

            public int applyAsInt(Object value) {
                try {
                    ColumnTableDestinatari dest = (ColumnTableDestinatari)SpeditoriController.this.table.getSelectionModel().getSelectedItem();
                    if (dest != null) {
                        SpeditoriController.this.modifica(dest.getColumn_id());
                    }
                }
                catch (Exception ex) {
                    SpeditoriController.this.wd.labelWord = "#ERR:" + ex.toString();
                }
                return 1;
            }
        });
    }

    @FXML
    void btnResetta(ActionEvent event) {
        this.clearField();
        this.flg_modifica = false;
        this.duplica = false;
        this.refreshList("");
    }

    @FXML
    void btnSalva(ActionEvent event) {
        this.wd = new WorkIndicatorDialog(this.table.getScene().getWindow(), "Caricamento in corso...");
        this.wd.addTaskEndNotification(result -> {
            if (this.wd.labelWord != null) {
                if (this.wd.labelWord.contains("#ERR:")) {
                    FXMLDocumentController.util.alertWindow(this.stack, this.wd.labelWord, "ERRORE", "ERRORE");
                } else {
                    this.wd = null;
                    this.refreshList("");
                    this.flg_modifica = false;
                    this.clearField();
                }
            } else {
                this.wd = null;
                this.refreshList("");
                this.flg_modifica = false;
                this.clearField();
            }
            this.table.refresh();
        });
        this.wd.exec("123", new ToIntFunction(){

            public int applyAsInt(Object value) {
                try {
                    SpeditoriController.this.salva();
                }
                catch (Exception ex) {
                    SpeditoriController.this.wd.labelWord = "#ERR:" + ex.toString();
                }
                return 1;
            }
        });
    }

    @FXML
    void btnRicerca(ActionEvent event) throws IOException {
        FXMLLoader loader = new FXMLLoader(this.getClass().getResource("/accise/view/SearchButtonCliente.fxml"));
        final Stage stage = new Stage();
        stage.setMaximized(false);
        stage.setTitle("Ricerca Trasportatori");
        stage.setScene(new Scene((Parent)((Pane)loader.load())));
        SearchButtonCliente controller = (SearchButtonCliente)loader.getController();
        controller.parent.setOnMousePressed((EventHandler)new EventHandler<MouseEvent>(){

            public void handle(MouseEvent event) {
                SpeditoriController.this.xOffset = event.getSceneX();
                SpeditoriController.this.yOffset = event.getSceneY();
            }
        });
        controller.parent.setOnMouseDragged((EventHandler)new EventHandler<MouseEvent>(){

            public void handle(MouseEvent event) {
                stage.setX(event.getScreenX() - SpeditoriController.this.xOffset);
                stage.setY(event.getScreenY() - SpeditoriController.this.yOffset);
                stage.setOpacity((double)0.8f);
            }
        });
        controller.parent.setOnDragDone((EventHandler)new EventHandler<DragEvent>(){

            public void handle(DragEvent event) {
                stage.setOpacity(1.0);
            }
        });
        controller.parent.setOnMouseReleased((EventHandler)new EventHandler<MouseEvent>(){

            public void handle(MouseEvent event) {
                stage.setOpacity(1.0);
            }
        });
        stage.initModality(Modality.APPLICATION_MODAL);
        stage.initStyle(StageStyle.UNDECORATED);
        stage.initOwner(((Node)event.getSource()).getScene().getWindow());
        stage.setResizable(false);
        stage.showAndWait();
        String ander = "";
        String codice = controller.getCodice();
        String codice_mexal = controller.getCodice_mexal();
        String denominazione = controller.getDenominazione();
        String indirizzo = controller.getIndirizzo();
        String citta = controller.getCitta();
        if (!codice.equals("")) {
            ander = " AND codice LIKE '%" + codice + "%' ";
        }
        if (!codice_mexal.equals("")) {
            ander = " AND codice_mexal LIKE '%" + codice_mexal + "%' ";
        }
        if (!denominazione.equals("")) {
            ander = " AND denominazione LIKE '%" + denominazione + "%' ";
        }
        if (!indirizzo.equals("")) {
            ander = " AND indirizzo LIKE '%" + indirizzo + "%' ";
        }
        if (!citta.equals("")) {
            ander = " AND citta LIKE '%" + citta + "%' ";
        }
        if (!ander.equals("")) {
            this.refreshList(ander);
        }
    }

    public void initialize(URL url, ResourceBundle rb) {
        this.column_codicemexal.setCellValueFactory((Callback)new PropertyValueFactory("column_codicemexal"));
        this.column_codice.setCellValueFactory((Callback)new PropertyValueFactory("column_codice"));
        this.column_denominazione.setCellValueFactory((Callback)new PropertyValueFactory("column_denominazione"));
        this.column_id.setCellValueFactory((Callback)new PropertyValueFactory("column_id"));
        this.column_indirizzo.setCellValueFactory((Callback)new PropertyValueFactory("column_indirizzo"));
        this.cmbx_linguadescr.setItems(this.lista_linguadescr);
        this.table.setItems(this.lista);
        Platform.runLater((Runnable)new Runnable(){

            @Override
            public void run() {
                SpeditoriController.this.fillListLinguaDescr();
                SpeditoriController.this.refreshList("");
            }
        });
    }

    public boolean elimina(String id) {
        try {
            int iterator = 0;
            ArrayList<String> tipoSQL = new ArrayList<String>();
            ArrayList<String> strSQL = new ArrayList<String>();
            ArrayList<Integer> lenghtBidimensionalArray = new ArrayList<Integer>();
            ArrayList<Boolean> lastID = new ArrayList<Boolean>();
            String str = "";
            String data_select = "";
            String[][] tipo_ins = null;
            String[][] valore = null;
            HashMap<Integer, String[]> ipos = new HashMap<Integer, String[]>();
            HashMap<Integer, String[]> alores = new HashMap<Integer, String[]>();
            FXMLDocumentController.sqlUtil.delete_gen_ana_accise_speditore(id);
            strSQL.addAll(FXMLDocumentController.sqlUtil.strSQL);
            tipoSQL.addAll(FXMLDocumentController.sqlUtil.tipoinsSQL);
            lenghtBidimensionalArray.addAll(FXMLDocumentController.sqlUtil.lengthSQL);
            lastID.addAll(FXMLDocumentController.sqlUtil.lastID);
            ipos.put(iterator, FXMLDocumentController.sqlUtil.tipovaloreSQL.toArray(new String[0]));
            alores.put(iterator, FXMLDocumentController.sqlUtil.valoreSQL.toArray(new String[0]));
            ++iterator;
            tipo_ins = FXMLDocumentController.util.HashMapBidimensionalTOArrayBidimensional(ipos);
            valore = FXMLDocumentController.util.HashMapBidimensionalTOArrayBidimensional(alores);
            String strJson = FXMLDocumentController.util.makeStringJsonDB("ON", tipoSQL, strSQL, tipo_ins, valore, lastID, lenghtBidimensionalArray);
            this.wd.labelWord = data_select = FXMLDocumentController.sk1Comm.ServerEsecuteRequest(FXMLDocumentController.GLOBAL_IP, FXMLDocumentController.GLOBAL_PORT, "dbInteraction#@" + strJson);
        }
        catch (Exception ex) {
            this.wd.labelWord = "#ERR:" + ex.toString();
        }
        return false;
    }

    private void modifica(String id) throws JSONException {
        ArrayList<String> tipoSQL = new ArrayList<String>();
        ArrayList<String> strSQL = new ArrayList<String>();
        ArrayList<Integer> lenghtBidimensionalArray = new ArrayList<Integer>();
        ArrayList<Boolean> lastID = new ArrayList<Boolean>();
        String data_select = "";
        lastID.add(false);
        String str = "SELECT codice,codice_mexal,denominazione,indirizzo,numero_civico,cap,citta,lingua_descr,codice_identificativo FROM gen_ana_accise_speditore WHERE id=" + id;
        strSQL.add(str);
        tipoSQL.add("select");
        lenghtBidimensionalArray.add(0);
        String strJson = FXMLDocumentController.util.makeStringJsonDB("OFF", tipoSQL, strSQL, null, null, lastID, lenghtBidimensionalArray);
        data_select = FXMLDocumentController.sk1Comm.ServerEsecuteRequest(FXMLDocumentController.GLOBAL_IP, FXMLDocumentController.GLOBAL_PORT, "dbInteraction#@" + strJson);
        if (!data_select.contains("#ERR:")) {
            JSONArray arrayJson = FXMLDocumentController.jsonUtil.strJsonToJSONArray(data_select);
            for (int i = 0; i < arrayJson.length(); ++i) {
                JSONObject rec = arrayJson.getJSONObject(i);
                final String codice = rec.getString("codice");
                final String codice_mexal = rec.getString("codice_mexal");
                final String denominazione = rec.getString("denominazione");
                final String indirizzo = rec.getString("indirizzo");
                final String numero_civico = rec.getString("numero_civico");
                final String cap = rec.getString("cap");
                final String citta = rec.getString("citta");
                String lingua_descr = rec.getString("lingua_descr");
                final String codice_identificativo = rec.getString("codice_identificativo");
                String descr_lingua = "";
                if (!codice.equals("")) {
                    descr_lingua = FXMLDocumentController.ricerca.getDescrizioneT001(lingua_descr);
                }
                final CodiceDescrizioneComboBox lingua = new CodiceDescrizioneComboBox(lingua_descr, descr_lingua);
                Platform.runLater((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        SpeditoriController.this.editText_cap.setText(cap);
                        SpeditoriController.this.editText_citta.setText(citta);
                        SpeditoriController.this.editText_codice.setText(codice);
                        SpeditoriController.this.editText_codicecli.setText(codice_mexal);
                        SpeditoriController.this.editText_denominazione.setText(denominazione);
                        SpeditoriController.this.editText_codiceidentificativo.setText(codice_identificativo);
                        SpeditoriController.this.editText_indirizzo.setText(indirizzo);
                        SpeditoriController.this.editText_numerocivico.setText(numero_civico);
                        SpeditoriController.this.cmbx_linguadescr.getSelectionModel().clearSelection();
                        SpeditoriController.this.cmbx_linguadescr.getSelectionModel().select((Object)lingua);
                    }
                });
                if (!this.duplica) {
                    this.flg_modifica = true;
                    this.editText_codice.setEditable(false);
                    continue;
                }
                this.flg_modifica = false;
                this.editText_codice.setEditable(true);
            }
        }
    }

    private void salva() throws JSONException {
        String cap = this.editText_cap.getText().trim();
        String citta = this.editText_citta.getText().trim();
        String codice_identificativo = this.editText_codiceidentificativo.getText().trim();
        String codice = this.editText_codice.getText().trim();
        String codice_mexal = this.editText_codicecli.getText().trim();
        String denominazione = this.editText_denominazione.getText().trim();
        String indirizzo = this.editText_indirizzo.getText().trim();
        String numero_civico = this.editText_numerocivico.getText().trim();
        String lingua_descr = "";
        CodiceDescrizioneComboBox lingua = (CodiceDescrizioneComboBox)this.cmbx_linguadescr.getSelectionModel().getSelectedItem();
        if (lingua != null) {
            lingua_descr = lingua.getCodice();
        }
        if (!codice.equals("")) {
            boolean controllo_codice = this.checkIfExistCiente(codice);
            if (codice.length() <= 3) {
                this.wd.labelWord = "#ERR: Lunghezza codice errata, minimo 4 caratteri !";
                return;
            }
            if (controllo_codice && !this.flg_modifica) {
                this.wd.labelWord = "#ERR: Codice gi\u00e0 utilizzato !";
            } else if (this.flg_modifica) {
                this.update(denominazione, codice, codice_mexal, indirizzo, numero_civico, cap, citta, lingua_descr, codice_identificativo);
            } else {
                this.insert(denominazione, codice, codice_mexal, indirizzo, numero_civico, cap, citta, lingua_descr, codice_identificativo);
            }
        } else {
            this.wd.labelWord = "#ERR: Campo Codice obbligatorio !";
        }
    }

    private void update(String denominazione, String codice, String codice_mexal, String indirizzo, String numero_civico, String cap, String citta, String lingua_descr, String codice_identificativo) throws JSONException {
        int iterator = 0;
        ArrayList<String> tipoSQL = new ArrayList<String>();
        ArrayList<String> strSQL = new ArrayList<String>();
        ArrayList<Integer> lenghtBidimensionalArray = new ArrayList<Integer>();
        ArrayList<Boolean> lastID = new ArrayList<Boolean>();
        String str = "";
        String data_select = "";
        String[][] tipo_ins = null;
        String[][] valore = null;
        HashMap<Integer, String[]> ipos = new HashMap<Integer, String[]>();
        HashMap<Integer, String[]> alores = new HashMap<Integer, String[]>();
        FXMLDocumentController.sqlUtil.update_gen_ana_accise_speditore(FXMLDocumentController.GLOBAL_AZIENDA, FXMLDocumentController.GLOBAL_SOTTOAZZ, denominazione, codice, codice_mexal, indirizzo, numero_civico, cap, citta, lingua_descr, codice_identificativo);
        strSQL.addAll(FXMLDocumentController.sqlUtil.strSQL);
        tipoSQL.addAll(FXMLDocumentController.sqlUtil.tipoinsSQL);
        lenghtBidimensionalArray.addAll(FXMLDocumentController.sqlUtil.lengthSQL);
        lastID.addAll(FXMLDocumentController.sqlUtil.lastID);
        ipos.put(iterator, FXMLDocumentController.sqlUtil.tipovaloreSQL.toArray(new String[0]));
        alores.put(iterator, FXMLDocumentController.sqlUtil.valoreSQL.toArray(new String[0]));
        ++iterator;
        tipo_ins = FXMLDocumentController.util.HashMapBidimensionalTOArrayBidimensional(ipos);
        valore = FXMLDocumentController.util.HashMapBidimensionalTOArrayBidimensional(alores);
        String strJson = FXMLDocumentController.util.makeStringJsonDB("ON", tipoSQL, strSQL, tipo_ins, valore, lastID, lenghtBidimensionalArray);
        this.wd.labelWord = data_select = FXMLDocumentController.sk1Comm.ServerEsecuteRequest(FXMLDocumentController.GLOBAL_IP, FXMLDocumentController.GLOBAL_PORT, "dbInteraction#@" + strJson);
    }

    private void insert(String denominazione, String codice, String codice_mexal, String indirizzo, String numero_civico, String cap, String citta, String lingua_descr, String codice_identificativo) throws JSONException {
        int iterator = 0;
        ArrayList<String> tipoSQL = new ArrayList<String>();
        ArrayList<String> strSQL = new ArrayList<String>();
        ArrayList<Integer> lenghtBidimensionalArray = new ArrayList<Integer>();
        ArrayList<Boolean> lastID = new ArrayList<Boolean>();
        String str = "";
        String data_select = "";
        String[][] tipo_ins = null;
        String[][] valore = null;
        HashMap<Integer, String[]> ipos = new HashMap<Integer, String[]>();
        HashMap<Integer, String[]> alores = new HashMap<Integer, String[]>();
        FXMLDocumentController.sqlUtil.insert_gen_ana_accise_speditore(FXMLDocumentController.GLOBAL_AZIENDA, FXMLDocumentController.GLOBAL_SOTTOAZZ, codice, denominazione, codice, codice_mexal, indirizzo, numero_civico, cap, citta, lingua_descr, codice_identificativo);
        strSQL.addAll(FXMLDocumentController.sqlUtil.strSQL);
        tipoSQL.addAll(FXMLDocumentController.sqlUtil.tipoinsSQL);
        lenghtBidimensionalArray.addAll(FXMLDocumentController.sqlUtil.lengthSQL);
        lastID.addAll(FXMLDocumentController.sqlUtil.lastID);
        ipos.put(iterator, FXMLDocumentController.sqlUtil.tipovaloreSQL.toArray(new String[0]));
        alores.put(iterator, FXMLDocumentController.sqlUtil.valoreSQL.toArray(new String[0]));
        ++iterator;
        tipo_ins = FXMLDocumentController.util.HashMapBidimensionalTOArrayBidimensional(ipos);
        valore = FXMLDocumentController.util.HashMapBidimensionalTOArrayBidimensional(alores);
        String strJson = FXMLDocumentController.util.makeStringJsonDB("ON", tipoSQL, strSQL, tipo_ins, valore, lastID, lenghtBidimensionalArray);
        this.wd.labelWord = data_select = FXMLDocumentController.sk1Comm.ServerEsecuteRequest(FXMLDocumentController.GLOBAL_IP, FXMLDocumentController.GLOBAL_PORT, "dbInteraction#@" + strJson);
    }

    private boolean checkIfExistCiente(String codice) throws JSONException {
        boolean ret = false;
        ArrayList<String> tipoSQL = new ArrayList<String>();
        ArrayList<String> strSQL = new ArrayList<String>();
        ArrayList<Integer> lenghtBidimensionalArray = new ArrayList<Integer>();
        ArrayList<Boolean> lastID = new ArrayList<Boolean>();
        String data_select = "";
        lastID.add(false);
        String str = "SELECT IFNULL(id,0) AS id FROM gen_ana_accise_speditore WHERE codice='" + codice + "' AND azienda='" + FXMLDocumentController.GLOBAL_AZIENDA + "' AND sotto_az='" + FXMLDocumentController.GLOBAL_SOTTOAZZ + "' ";
        strSQL.add(str);
        tipoSQL.add("select");
        lenghtBidimensionalArray.add(0);
        String strJson = FXMLDocumentController.util.makeStringJsonDB("OFF", tipoSQL, strSQL, null, null, lastID, lenghtBidimensionalArray);
        data_select = FXMLDocumentController.sk1Comm.ServerEsecuteRequest(FXMLDocumentController.GLOBAL_IP, FXMLDocumentController.GLOBAL_PORT, "dbInteraction#@" + strJson);
        if (!data_select.contains("#ERR:")) {
            JSONArray arrayJson = FXMLDocumentController.jsonUtil.strJsonToJSONArray(data_select);
            for (int i = 0; i < arrayJson.length(); ++i) {
                JSONObject rec = arrayJson.getJSONObject(i);
                int ids = rec.getInt("id");
                if (ids <= 0) continue;
                ret = true;
            }
        }
        return ret;
    }

    private void fillListLinguaDescr() {
        this.wd = new WorkIndicatorDialog(this.table.getScene().getWindow(), "Caricamento in corso...");
        this.wd.addTaskEndNotification(result -> {
            if (this.wd != null && this.wd.labelWord != null && !this.wd.labelWord.equals("")) {
                FXMLDocumentController.toast.startToast(this.wd.labelWord, "ERRORE", "ERRORE");
            }
            this.table.refresh();
        });
        this.wd.exec("123", inputParam -> {
            try {
                ArrayList<String> tipoSQL = new ArrayList<String>();
                ArrayList<String> strSQL = new ArrayList<String>();
                ArrayList<Integer> lenghtBidimensionalArray = new ArrayList<Integer>();
                ArrayList<Boolean> lastID = new ArrayList<Boolean>();
                String data_select = "";
                lastID.add(false);
                this.lista_linguadescr.clear();
                this.lista_linguadescr.add(null);
                String str = "SELECT codice,descrizione FROM accise_t_001 ORDER BY descrizione ASC";
                strSQL.add(str);
                tipoSQL.add("select");
                lenghtBidimensionalArray.add(0);
                String strJson = FXMLDocumentController.util.makeStringJsonDB("OFF", tipoSQL, strSQL, null, null, lastID, lenghtBidimensionalArray);
                data_select = FXMLDocumentController.sk1Comm.ServerEsecuteRequest(FXMLDocumentController.GLOBAL_IP, FXMLDocumentController.GLOBAL_PORT, "dbInteraction#@" + strJson);
                if (!data_select.contains("#ERR:")) {
                    JSONArray arrayJson = FXMLDocumentController.jsonUtil.strJsonToJSONArray(data_select);
                    for (int i = 0; i < arrayJson.length(); ++i) {
                        JSONObject rec = arrayJson.getJSONObject(i);
                        String codice = rec.getString("codice");
                        String descrizione = rec.getString("descrizione");
                        this.lista_linguadescr.add((Object)new CodiceDescrizioneComboBox(codice, descrizione));
                    }
                }
            }
            catch (Exception ex) {
                this.wd.labelWord = ex.getMessage();
            }
            return 1;
        });
    }

    private void refreshList(String ander) {
        this.wd = new WorkIndicatorDialog(this.table.getScene().getWindow(), "Caricamento in corso...");
        this.wd.addTaskEndNotification(result -> {
            if (this.wd.labelWord != null && !this.wd.labelWord.equals("")) {
                FXMLDocumentController.toast.startToast(this.wd.labelWord, "ERRORE", "ERRORE");
            }
            this.wd = null;
            this.table.refresh();
        });
        this.wd.exec("123", inputParam -> {
            try {
                this.wd.labelWord = "";
                ArrayList<String> tipoSQL = new ArrayList<String>();
                ArrayList<String> strSQL = new ArrayList<String>();
                ArrayList<Integer> lenghtBidimensionalArray = new ArrayList<Integer>();
                ArrayList<Boolean> lastID = new ArrayList<Boolean>();
                String data_select = "";
                lastID.add(false);
                this.lista.clear();
                String str = "SELECT id,codice,codice_mexal,denominazione,indirizzo,numero_civico,cap,citta,lingua_descr,codice_identificativo FROM gen_ana_accise_speditore WHERE azienda='" + FXMLDocumentController.GLOBAL_AZIENDA + "' AND sotto_az='" + FXMLDocumentController.GLOBAL_SOTTOAZZ + "' " + ander;
                strSQL.add(str);
                tipoSQL.add("select");
                lenghtBidimensionalArray.add(0);
                String strJson = FXMLDocumentController.util.makeStringJsonDB("OFF", tipoSQL, strSQL, null, null, lastID, lenghtBidimensionalArray);
                data_select = FXMLDocumentController.sk1Comm.ServerEsecuteRequest(FXMLDocumentController.GLOBAL_IP, FXMLDocumentController.GLOBAL_PORT, "dbInteraction#@" + strJson);
                if (!data_select.contains("#ERR:")) {
                    JSONArray arrayJson = FXMLDocumentController.jsonUtil.strJsonToJSONArray(data_select);
                    for (int i = 0; i < arrayJson.length(); ++i) {
                        JSONObject rec = arrayJson.getJSONObject(i);
                        String id = rec.get("id").toString();
                        String codice = rec.getString("codice");
                        String codice_mexal = rec.getString("codice_mexal");
                        String denominazione = rec.getString("denominazione");
                        String indirizzo = rec.getString("indirizzo");
                        String numero_civico = rec.getString("numero_civico");
                        String cap = rec.getString("cap");
                        String citta = rec.getString("citta");
                        String lingua_descr = rec.getString("lingua_descr");
                        String codice_identificativo = rec.getString("codice_identificativo");
                        this.lista.add((Object)new ColumnTableDestinatari(id, codice, codice_mexal, denominazione, codice_identificativo, indirizzo, cap, numero_civico, citta, lingua_descr));
                    }
                }
            }
            catch (Exception ex) {
                this.wd.labelWord = ex.getMessage();
            }
            return 1;
        });
    }

    private void clearField() {
        this.editText_codiceidentificativo.setText("");
        this.editText_cap.setText("");
        this.editText_citta.setText("");
        this.editText_codice.setText("");
        this.editText_codicecli.setText("");
        this.editText_denominazione.setText("");
        this.editText_indirizzo.setText("");
        this.editText_numerocivico.setText("");
        this.cmbx_linguadescr.getSelectionModel().clearSelection();
        this.cmbx_linguadescr.getSelectionModel().selectFirst();
        this.editText_codice.setEditable(true);
    }

    @FXML
    private void btnImport(ActionEvent event) throws IOException {
        JFXDialogLayout dialogLayout = new JFXDialogLayout();
        dialogLayout.setHeading(new Node[]{new Text("PROCEDERE CON L'IMPORT ?")});
        Label txt = new Label("DIGITARE PROCEDI ");
        final JFXTextField edit = new JFXTextField();
        HBox lolo2 = new HBox();
        lolo2.getChildren().add((Object)txt);
        lolo2.getChildren().add((Object)edit);
        lolo2.setSpacing(5.0);
        lolo2.setAlignment(Pos.CENTER);
        dialogLayout.setBody(new Node[]{lolo2});
        final JFXDialog dialog = new JFXDialog(this.stack, (Region)dialogLayout, JFXDialog.DialogTransition.CENTER);
        dialog.setStyle("-fx-background-color: rgba(221,75,57,0.7);");
        JFXButton btn = new JFXButton("OK");
        btn.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent event) {
                String res = edit.getText().trim();
                if (res.equals("PROCEDI")) {
                    try {
                        ImportFileCSV csv = new ImportFileCSV();
                        csv.getFile();
                        csv.addExtFilter("CSV files (*.csv)", "*.csv");
                        File file = csv.open();
                        SpeditoriController.this.wd = new WorkIndicatorDialog(SpeditoriController.this.editText_cap.getScene().getWindow(), "Caricamento in corso...");
                        SpeditoriController.this.wd.addTaskEndNotification(result -> {
                            try {
                                if (SpeditoriController.this.wd.labelWord.contains("#ERR")) {
                                    FXMLDocumentController.util.alertWindow(SpeditoriController.this.stack, SpeditoriController.this.wd.labelWord, "ERRORE", "ERRORE");
                                    SpeditoriController.this.wd = null;
                                } else {
                                    FXMLDocumentController.toast.startToast("Import Completato con successo", "SUCCESSO", "SUCCESSO");
                                    SpeditoriController.this.wd = null;
                                    SpeditoriController.this.refreshList("");
                                }
                            }
                            catch (Exception ex) {
                                Logger.getLogger(ConfConferimentiController.class.getName()).log(Level.SEVERE, null, ex);
                            }
                        });
                        SpeditoriController.this.wd.exec("123", inputParam -> {
                            try {
                                if (file != null) {
                                    if (file.getName().contains("ANAG_SPEDITORI")) {
                                        SpeditoriController.this.importSoggetto(file);
                                    } else {
                                        SpeditoriController.this.wd.labelWord = "#ERR: File csv errato";
                                    }
                                } else {
                                    SpeditoriController.this.wd.labelWord = "#ERR: File csv errato";
                                }
                            }
                            catch (Exception ex) {
                                SpeditoriController.this.wd.labelWord = "#ERR:" + ex.getMessage();
                            }
                            return new Integer(1);
                        });
                    }
                    catch (IOException ex) {
                        Logger.getLogger(DestinatariController.class.getName()).log(Level.SEVERE, null, ex);
                    }
                }
                dialog.close();
            }
        });
        JFXButton btn2 = new JFXButton("ANNULLA");
        btn2.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent event) {
                dialog.close();
            }
        });
        btn.setPadding(new Insets(5.0));
        btn2.setPadding(new Insets(5.0));
        btn.setStyle("-fx-background-color: #00A65A;-fx-text-fill: #FFFFFF;-fx-font-weight: bold;-fx-font-size: 14px;");
        btn2.setStyle("-fx-background-color: #ACACAC;-fx-text-fill: #FFFFFF;-fx-font-weight: bold;-fx-font-size: 14px;");
        HBox lolo = new HBox();
        lolo.getChildren().add((Object)btn);
        lolo.getChildren().add((Object)btn2);
        lolo.setSpacing(5.0);
        dialogLayout.setActions(new Node[]{lolo});
        dialog.setDialogContainer(this.stack);
        dialog.show();
    }

    private void importSoggetto(File file) throws IOException {
        if (file != null) {
            String[] res = new String[1];
            ArrayList<String> tipoSQLmx = new ArrayList<String>();
            ArrayList<String> strSQLmx = new ArrayList<String>();
            ArrayList<Integer> lenghtBidimensionalArraymx = new ArrayList<Integer>();
            ArrayList<Boolean> lastIDmx = new ArrayList<Boolean>();
            String[][] tipo_insmx = null;
            String[][] valoremx = null;
            HashMap<Integer, String[]> ipos = new HashMap<Integer, String[]>();
            HashMap<Integer, String[]> alores = new HashMap<Integer, String[]>();
            int iterator = 0;
            int iso = 0;
            try (BufferedReader br = new BufferedReader(new FileReader(file));){
                String line;
                while ((line = br.readLine()) != null) {
                    String[] colonne;
                    if (iso > 0 && (colonne = line.split(";", -1)).length == 11) {
                        boolean controllo_codice;
                        String id = colonne[0].trim();
                        String codice = Utility.padLeftZeros(id, 5);
                        String denominazione = colonne[1].trim();
                        String indirizzo = colonne[2].trim();
                        String codice_identificativo = colonne[3].trim();
                        String partita_iva = colonne[4].trim();
                        String numero_civico = colonne[5].trim();
                        String cap = colonne[6].trim();
                        String citta = colonne[7].trim().replace(",", ".");
                        String lingua = colonne[8].trim().replace(",", ".");
                        String data_cancellazione = colonne[9].trim();
                        String id_utente = colonne[10].trim();
                        if (codice_identificativo.equals("")) {
                            codice_identificativo = partita_iva;
                        }
                        if (controllo_codice = this.checkIfExistCiente(codice)) {
                            this.wd.labelWord = this.wd.labelWord + "#ERR: " + codice + " - Codice gi\u00e0 utilizzato !";
                        } else {
                            FXMLDocumentController.sqlUtil.insert_gen_ana_accise_speditore(FXMLDocumentController.GLOBAL_AZIENDA, FXMLDocumentController.GLOBAL_SOTTOAZZ, codice, denominazione, codice, "", indirizzo, numero_civico, cap, citta, lingua, codice_identificativo);
                            strSQLmx.addAll(FXMLDocumentController.sqlUtil.strSQL);
                            tipoSQLmx.addAll(FXMLDocumentController.sqlUtil.tipoinsSQL);
                            lenghtBidimensionalArraymx.addAll(FXMLDocumentController.sqlUtil.lengthSQL);
                            lastIDmx.addAll(FXMLDocumentController.sqlUtil.lastID);
                            ipos.put(iterator, FXMLDocumentController.sqlUtil.tipovaloreSQL.toArray(new String[0]));
                            alores.put(iterator, FXMLDocumentController.sqlUtil.valoreSQL.toArray(new String[0]));
                            ++iterator;
                        }
                    }
                    ++iso;
                }
                tipo_insmx = FXMLDocumentController.util.HashMapBidimensionalTOArrayBidimensional(ipos);
                valoremx = FXMLDocumentController.util.HashMapBidimensionalTOArrayBidimensional(alores);
                String strJson = FXMLDocumentController.util.makeStringJsonDB("ON", tipoSQLmx, strSQLmx, tipo_insmx, valoremx, lastIDmx, lenghtBidimensionalArraymx);
                String data_select = FXMLDocumentController.sk1Comm.ServerEsecuteRequest(FXMLDocumentController.GLOBAL_IP, FXMLDocumentController.GLOBAL_PORT, "dbInteraction#@" + strJson);
                if (data_select.contains("#ERR:")) {
                    this.wd.labelWord = data_select;
                }
            }
            catch (Exception ex) {
                Logger.getLogger(ConfConferimentiController.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }

    @FXML
    private void btnDuplicate(ActionEvent event) {
        this.wd = new WorkIndicatorDialog(this.table.getScene().getWindow(), "Caricamento in corso...");
        this.wd.addTaskEndNotification(result -> {
            if (this.wd.labelWord != null) {
                if (this.wd.labelWord.contains("#ERR:")) {
                    FXMLDocumentController.util.alertWindow(this.stack, this.wd.labelWord, "ERRORE", "ERRORE");
                } else {
                    this.duplica = false;
                }
            }
            this.wd = null;
            this.table.refresh();
        });
        this.wd.exec("123", new ToIntFunction(){

            public int applyAsInt(Object value) {
                try {
                    ColumnTableDestinatari dest = (ColumnTableDestinatari)SpeditoriController.this.table.getSelectionModel().getSelectedItem();
                    if (dest != null) {
                        SpeditoriController.this.duplica = true;
                        SpeditoriController.this.modifica(dest.getColumn_id());
                    }
                }
                catch (Exception ex) {
                    SpeditoriController.this.wd.labelWord = "#ERR:" + ex.toString();
                }
                return 1;
            }
        });
    }
}

