/*
 * Decompiled with CFR 0.152.
 */
package accise.controller.anagrafiche;

import accise.classi.ColumnTableArticoli;
import accise.classi.ColumnTableImbo;
import accise.controller.FinestraArtiImbController;
import accise.controller.SearchButtonArticoli;
import accise.controller.SearchButtonCPA;
import accise.controller.SearchButtonProdottiMexal;
import accise.controller.anagrafiche.DestinatariController;
import com.jfoenix.controls.JFXButton;
import com.jfoenix.controls.JFXCheckBox;
import com.jfoenix.controls.JFXDialog;
import com.jfoenix.controls.JFXDialogLayout;
import com.jfoenix.controls.JFXTextField;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.ResourceBundle;
import java.util.function.ToIntFunction;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.application.Platform;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.fxml.FXML;
import javafx.fxml.FXMLLoader;
import javafx.fxml.Initializable;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Label;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.TextField;
import javafx.scene.control.TextInputDialog;
import javafx.scene.control.cell.PropertyValueFactory;
import javafx.scene.input.DragEvent;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Pane;
import javafx.scene.layout.Region;
import javafx.scene.layout.StackPane;
import javafx.scene.text.Text;
import javafx.stage.Modality;
import javafx.stage.Stage;
import javafx.stage.StageStyle;
import javafx.util.Callback;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import vin.Class.CodiceDescrizioneComboBox;
import vin.Class.WorkIndicatorDialog;
import vin.Uility.ImportFileCSV;
import vin.Uility.Utility;
import vin.conf.ConfConferimentiController;
import vin.controller.FXMLDocumentController;

public class ArticoliController
implements Initializable {
    @FXML
    private TableView<ColumnTableArticoli> table;
    @FXML
    private TableColumn<ColumnTableArticoli, String> column_codice;
    @FXML
    private TableColumn<ColumnTableArticoli, String> column_codicemexal;
    @FXML
    private TableColumn<ColumnTableArticoli, String> column_descrizione;
    @FXML
    private TableColumn<ColumnTableArticoli, String> column_id;
    @FXML
    private TextField editText_codice;
    @FXML
    private TextField editText_codicecli;
    @FXML
    private TextField editText_cn;
    @FXML
    private TextField editText_cadd;
    @FXML
    private TextField editText_taric;
    @FXML
    private TextField editText_aams;
    @FXML
    private TextField editText_capacita;
    @FXML
    private TextField editText_densita;
    @FXML
    private TextField editText_descrizione;
    @FXML
    private TextField editText_cpa;
    @FXML
    private TextField editText_pesolordo;
    @FXML
    private TextField editText_pesonetto;
    @FXML
    private TextField editText_gradoalcolico;
    @FXML
    private TextField editText_gradoplato;
    @FXML
    private TextField editText_dimensioniprodotto;
    @FXML
    private ComboBox<CodiceDescrizioneComboBox> cmbx_zonacoltivazione;
    @FXML
    private ComboBox<CodiceDescrizioneComboBox> cmbx_categoriavino;
    @FXML
    StackPane stack;
    double xOffset = 0.0;
    double yOffset = 0.0;
    @FXML
    private TextField editText__codiceprod;
    @FXML
    private ComboBox<CodiceDescrizioneComboBox> cmbx_tipostoccaggio;
    @FXML
    private Label text_codprod;
    @FXML
    private TableView<ColumnTableImbo> table_imb;
    @FXML
    private TableColumn<ColumnTableImbo, String> column_codiceimb;
    @FXML
    private TableColumn<ColumnTableImbo, String> column_descrizioneimb;
    @FXML
    private TableColumn<ColumnTableImbo, String> column_nrimb;
    @FXML
    private JFXCheckBox chk_prodotto_sfuso;
    @FXML
    private TextField editText_descrizionecomm;
    @FXML
    private ComboBox<CodiceDescrizioneComboBox> cmbx_lingdescrcomm;
    @FXML
    private TextField editText_marchiprod;
    @FXML
    private ComboBox<CodiceDescrizioneComboBox> cmbx_linguamarchioprod;
    HashMap<String, String> lista_docmex = new HashMap();
    ObservableList<ColumnTableArticoli> lista = FXCollections.observableArrayList();
    ObservableList<ColumnTableImbo> lista_imballaggi = FXCollections.observableArrayList();
    ObservableList<CodiceDescrizioneComboBox> lista_zonacoltivazione = FXCollections.observableArrayList();
    ObservableList<CodiceDescrizioneComboBox> lista_categoriavino = FXCollections.observableArrayList();
    ObservableList<CodiceDescrizioneComboBox> lista_ta16 = FXCollections.observableArrayList();
    ObservableList<CodiceDescrizioneComboBox> lista_t01 = FXCollections.observableArrayList();
    WorkIndicatorDialog wd = null;
    boolean flg_modifica = false;

    @FXML
    void btnSvuotaCPA(ActionEvent event) throws IOException {
        this.editText_cpa.setText("");
        this.editText_cadd.setText("");
        this.editText_cn.setText("");
        this.editText_taric.setText("");
        this.editText__codiceprod.setText("");
    }

    @FXML
    void btnCercaCPA(ActionEvent event) throws IOException {
        FXMLLoader loader = new FXMLLoader(this.getClass().getResource("/accise/view/SearchButtonCPA.fxml"));
        final Stage stage = new Stage();
        stage.setMaximized(false);
        stage.setTitle("CPA");
        stage.setScene(new Scene((Parent)((Pane)loader.load())));
        SearchButtonCPA controller = (SearchButtonCPA)loader.getController();
        stage.initStyle(StageStyle.UNDECORATED);
        stage.initOwner(((Node)event.getSource()).getScene().getWindow());
        stage.setMaximized(true);
        controller.getParent().setOnMousePressed((EventHandler)new EventHandler<MouseEvent>(){

            public void handle(MouseEvent event) {
                ArticoliController.this.xOffset = event.getSceneX();
                ArticoliController.this.yOffset = event.getSceneY();
            }
        });
        controller.getParent().setOnMouseDragged((EventHandler)new EventHandler<MouseEvent>(){

            public void handle(MouseEvent event) {
                stage.setX(event.getScreenX() - ArticoliController.this.xOffset);
                stage.setY(event.getScreenY() - ArticoliController.this.yOffset);
                stage.setOpacity((double)0.8f);
            }
        });
        controller.getParent().setOnDragDone((EventHandler)new EventHandler<DragEvent>(){

            public void handle(DragEvent event) {
                stage.setOpacity(1.0);
            }
        });
        controller.getParent().setOnMouseReleased((EventHandler)new EventHandler<MouseEvent>(){

            public void handle(MouseEvent event) {
                stage.setOpacity(1.0);
            }
        });
        stage.showAndWait();
        stage.setResizable(false);
        String cpa = controller.getCpa();
        String taric = controller.getTaric();
        String cadd = controller.getCadd();
        String nc = controller.getNc();
        String aams = controller.getAams();
        if (cpa != null && !cpa.equals("")) {
            this.editText_cpa.setText(cpa);
            this.editText_cadd.setText(cadd);
            this.editText_cn.setText(nc);
            this.editText_taric.setText(taric);
            if (cpa.contains("T")) {
                this.editText__codiceprod.setText(aams);
                this.editText_aams.setText(aams);
            }
        }
    }

    @FXML
    void btnRicerca(ActionEvent event) throws IOException {
        FXMLLoader loader = new FXMLLoader(this.getClass().getResource("/accise/view/SearchButtonArticoli.fxml"));
        final Stage stage = new Stage();
        stage.setMaximized(false);
        stage.setTitle("Ricerca Prodotti");
        stage.setScene(new Scene((Parent)((Pane)loader.load())));
        SearchButtonArticoli controller = (SearchButtonArticoli)loader.getController();
        controller.parent.setOnMousePressed((EventHandler)new EventHandler<MouseEvent>(){

            public void handle(MouseEvent event) {
                ArticoliController.this.xOffset = event.getSceneX();
                ArticoliController.this.yOffset = event.getSceneY();
            }
        });
        controller.parent.setOnMouseDragged((EventHandler)new EventHandler<MouseEvent>(){

            public void handle(MouseEvent event) {
                stage.setX(event.getScreenX() - ArticoliController.this.xOffset);
                stage.setY(event.getScreenY() - ArticoliController.this.yOffset);
                stage.setOpacity((double)0.8f);
            }
        });
        controller.parent.setOnDragDone((EventHandler)new EventHandler<DragEvent>(){

            public void handle(DragEvent event) {
                stage.setOpacity(1.0);
            }
        });
        controller.parent.setOnMouseReleased((EventHandler)new EventHandler<MouseEvent>(){

            public void handle(MouseEvent event) {
                stage.setOpacity(1.0);
            }
        });
        stage.initModality(Modality.APPLICATION_MODAL);
        stage.initStyle(StageStyle.UNDECORATED);
        stage.initOwner(((Node)event.getSource()).getScene().getWindow());
        stage.setResizable(false);
        stage.showAndWait();
        String ander = "";
        String codice = controller.getCodice();
        String codice_mexal = controller.getCodice_mexal();
        String denominazione = controller.getDenominazione();
        if (!codice.equals("")) {
            ander = " AND codice LIKE '%" + codice + "%' ";
        }
        if (!codice_mexal.equals("")) {
            ander = " AND codice_mexal LIKE '%" + codice_mexal + "%' ";
        }
        if (!denominazione.equals("")) {
            ander = " AND descrizione LIKE '%" + denominazione + "%' ";
        }
        if (!ander.equals("")) {
            this.refreshList(ander);
        }
    }

    @FXML
    void btnCercaCliente(ActionEvent event) throws IOException {
        FXMLLoader loader = new FXMLLoader(this.getClass().getResource("/accise/view/SearchButtonProdottiMexal.fxml"));
        final Stage stage = new Stage();
        stage.setMaximized(false);
        stage.setTitle("Articoli");
        stage.setScene(new Scene((Parent)((Pane)loader.load())));
        SearchButtonProdottiMexal controller = (SearchButtonProdottiMexal)loader.getController();
        stage.initStyle(StageStyle.UNDECORATED);
        stage.initOwner(((Node)event.getSource()).getScene().getWindow());
        controller.parent.setOnMousePressed((EventHandler)new EventHandler<MouseEvent>(){

            public void handle(MouseEvent event) {
                ArticoliController.this.xOffset = event.getSceneX();
                ArticoliController.this.yOffset = event.getSceneY();
            }
        });
        controller.parent.setOnMouseDragged((EventHandler)new EventHandler<MouseEvent>(){

            public void handle(MouseEvent event) {
                stage.setX(event.getScreenX() - ArticoliController.this.xOffset);
                stage.setY(event.getScreenY() - ArticoliController.this.yOffset);
                stage.setOpacity((double)0.8f);
            }
        });
        controller.parent.setOnDragDone((EventHandler)new EventHandler<DragEvent>(){

            public void handle(DragEvent event) {
                stage.setOpacity(1.0);
            }
        });
        controller.parent.setOnMouseReleased((EventHandler)new EventHandler<MouseEvent>(){

            public void handle(MouseEvent event) {
                stage.setOpacity(1.0);
            }
        });
        stage.showAndWait();
        stage.setResizable(false);
        String codice = controller.getCodice();
        String descr = controller.getDesString();
        String iva = controller.getIva();
        String um = controller.getUm();
        String cod_alt = controller.getCodAlt();
        if (!codice.equals("")) {
            try {
                boolean controllo_codice = this.checkIfExistCodiceMexal(codice);
                if (controllo_codice && !this.flg_modifica) {
                    FXMLDocumentController.toast.startToast("Codice Mexal gi\u00e0 utilizzato !", "ERRORE", "ERRORE");
                } else {
                    this.lista_docmex.clear();
                    this.lista_docmex.put("codice", codice);
                    this.lista_docmex.put("descrizione", descr);
                    this.lista_docmex.put("iva", iva);
                    this.lista_docmex.put("um", um);
                    this.lista_docmex.put("cod_alt", cod_alt);
                    this.editText_codice.setText(codice);
                    this.editText_codicecli.setText(codice);
                    this.editText_descrizione.setText(descr);
                }
            }
            catch (JSONException jSONException) {
                // empty catch block
            }
        }
    }

    @FXML
    void btnElimina(ActionEvent event) {
        ColumnTableArticoli oper = (ColumnTableArticoli)this.table.getSelectionModel().getSelectedItem();
        if (oper != null) {
            TextInputDialog dialogim = new TextInputDialog("");
            dialogim.setTitle("SICUREZZA");
            dialogim.setHeaderText("Confermare la cancellazione dell'anagrafica " + oper.getColumn_codice() + " ?");
            dialogim.setContentText("Password (PROCEDI):");
            Optional resultim = dialogim.showAndWait();
            if (resultim.isPresent() && ((String)resultim.get()).trim().trim().equals("PROCEDI")) {
                this.wd = new WorkIndicatorDialog(this.table.getScene().getWindow(), "Caricamento in corso...");
                this.wd.addTaskEndNotification(result -> {
                    if (this.wd.labelWord.contains("#ERR")) {
                        String h = this.wd.labelWord;
                        this.wd = null;
                        FXMLDocumentController.util.alertWindow(this.stack, h, "ERRORE", "ERRORE");
                    } else {
                        this.flg_modifica = false;
                        FXMLDocumentController.toast.startToast("Operazione correttamente eseguita", "SUCCESSO", "SUCCESSO");
                        this.svuota();
                        this.wd = null;
                        this.refreshList("");
                    }
                });
                this.wd.exec("123", inputParam -> {
                    try {
                        this.elimina(oper.getColumn_id());
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    return 1;
                });
            }
        }
    }

    public boolean elimina(String id) {
        try {
            int iterator = 0;
            ArrayList<String> tipoSQL = new ArrayList<String>();
            ArrayList<String> strSQL = new ArrayList<String>();
            ArrayList<Integer> lenghtBidimensionalArray = new ArrayList<Integer>();
            ArrayList<Boolean> lastID = new ArrayList<Boolean>();
            String str = "";
            String data_select = "";
            String[][] tipo_ins = null;
            String[][] valore = null;
            HashMap<Integer, String[]> ipos = new HashMap<Integer, String[]>();
            HashMap<Integer, String[]> alores = new HashMap<Integer, String[]>();
            FXMLDocumentController.sqlUtil.delete_gen_ana_accise_articoli(id);
            strSQL.addAll(FXMLDocumentController.sqlUtil.strSQL);
            tipoSQL.addAll(FXMLDocumentController.sqlUtil.tipoinsSQL);
            lenghtBidimensionalArray.addAll(FXMLDocumentController.sqlUtil.lengthSQL);
            lastID.addAll(FXMLDocumentController.sqlUtil.lastID);
            ipos.put(iterator, FXMLDocumentController.sqlUtil.tipovaloreSQL.toArray(new String[0]));
            alores.put(iterator, FXMLDocumentController.sqlUtil.valoreSQL.toArray(new String[0]));
            ++iterator;
            FXMLDocumentController.sqlUtil.delete_gen_ana_accise_articoli_imballaggi(id);
            strSQL.addAll(FXMLDocumentController.sqlUtil.strSQL);
            tipoSQL.addAll(FXMLDocumentController.sqlUtil.tipoinsSQL);
            lenghtBidimensionalArray.addAll(FXMLDocumentController.sqlUtil.lengthSQL);
            lastID.addAll(FXMLDocumentController.sqlUtil.lastID);
            ipos.put(iterator, FXMLDocumentController.sqlUtil.tipovaloreSQL.toArray(new String[0]));
            alores.put(iterator, FXMLDocumentController.sqlUtil.valoreSQL.toArray(new String[0]));
            ++iterator;
            FXMLDocumentController.sqlUtil.delete_gen_ana_accise_articoli_mx(id);
            strSQL.addAll(FXMLDocumentController.sqlUtil.strSQL);
            tipoSQL.addAll(FXMLDocumentController.sqlUtil.tipoinsSQL);
            lenghtBidimensionalArray.addAll(FXMLDocumentController.sqlUtil.lengthSQL);
            lastID.addAll(FXMLDocumentController.sqlUtil.lastID);
            ipos.put(iterator, FXMLDocumentController.sqlUtil.tipovaloreSQL.toArray(new String[0]));
            alores.put(iterator, FXMLDocumentController.sqlUtil.valoreSQL.toArray(new String[0]));
            ++iterator;
            tipo_ins = FXMLDocumentController.util.HashMapBidimensionalTOArrayBidimensional(ipos);
            valore = FXMLDocumentController.util.HashMapBidimensionalTOArrayBidimensional(alores);
            String strJson = FXMLDocumentController.util.makeStringJsonDB("ON", tipoSQL, strSQL, tipo_ins, valore, lastID, lenghtBidimensionalArray);
            this.wd.labelWord = data_select = FXMLDocumentController.sk1Comm.ServerEsecuteRequest(FXMLDocumentController.GLOBAL_IP, FXMLDocumentController.GLOBAL_PORT, "dbInteraction#@" + strJson);
        }
        catch (Exception ex) {
            this.wd.labelWord = "#ERR:" + ex.toString();
        }
        return false;
    }

    @FXML
    void btnModifica(ActionEvent event) {
        this.svuota();
        this.wd = new WorkIndicatorDialog(this.table.getScene().getWindow(), "Caricamento in corso...");
        this.wd.addTaskEndNotification(result -> {
            if (this.wd.labelWord != null && this.wd.labelWord.contains("#ERR:")) {
                FXMLDocumentController.util.alertWindow(this.stack, this.wd.labelWord, "ERRORE", "ERRORE");
            }
            this.wd = null;
            this.table.refresh();
            this.table_imb.refresh();
        });
        this.wd.exec("123", new ToIntFunction(){

            public int applyAsInt(Object value) {
                try {
                    ColumnTableArticoli dest = (ColumnTableArticoli)ArticoliController.this.table.getSelectionModel().getSelectedItem();
                    if (dest != null) {
                        ArticoliController.this.modifica(dest.getColumn_id(), false);
                    }
                }
                catch (Exception ex) {
                    ArticoliController.this.wd.labelWord = "#ERR:" + ex.toString();
                }
                return 1;
            }
        });
    }

    @FXML
    void btnResetta(ActionEvent event) {
        this.svuota();
    }

    @FXML
    void btnSalva(ActionEvent event) {
        this.wd = new WorkIndicatorDialog(this.table.getScene().getWindow(), "Caricamento in corso...");
        this.wd.addTaskEndNotification(result -> {
            if (this.wd.labelWord != null) {
                if (this.wd.labelWord.contains("#ERR:")) {
                    FXMLDocumentController.util.alertWindow(this.stack, this.wd.labelWord, "ERRORE", "ERRORE");
                } else {
                    this.wd = null;
                    this.refreshList("");
                    this.flg_modifica = false;
                    this.svuota();
                }
            } else {
                this.wd = null;
                this.refreshList("");
                this.flg_modifica = false;
                this.svuota();
            }
            this.table.refresh();
        });
        this.wd.exec("123", new ToIntFunction(){

            public int applyAsInt(Object value) {
                try {
                    ArticoliController.this.salva();
                }
                catch (Exception ex) {
                    ArticoliController.this.wd.labelWord = "#ERR:" + ex.toString();
                }
                return 1;
            }
        });
    }

    public void initialize(URL url, ResourceBundle rb) {
        this.editText__codiceprod.setManaged(false);
        this.editText__codiceprod.setVisible(false);
        this.text_codprod.setVisible(false);
        this.text_codprod.setManaged(false);
        this.column_codicemexal.setCellValueFactory((Callback)new PropertyValueFactory("column_codicemexal"));
        this.column_codice.setCellValueFactory((Callback)new PropertyValueFactory("column_codice"));
        this.column_id.setCellValueFactory((Callback)new PropertyValueFactory("column_id"));
        this.column_descrizione.setCellValueFactory((Callback)new PropertyValueFactory("column_descrizione"));
        FXMLDocumentController.util.addOnlyNumber(this.editText_capacita);
        this.editText_capacita.textProperty().addListener((observable, oldValue, newValue) -> {
            if (newValue != null) {
                try {
                    boolean field_sfuso = this.chk_prodotto_sfuso.selectedProperty().get();
                    if (!field_sfuso) {
                        this.editText_pesonetto.setText(newValue);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
        Platform.runLater((Runnable)new Runnable(){

            @Override
            public void run() {
                try {
                    ArticoliController.this.fillComboBoxZonaColtivazione();
                    ArticoliController.this.fillComboBoxCategoriaVino();
                    ArticoliController.this.fillComboBoxTA16();
                    ArticoliController.this.fillComboBoxT01();
                    ArticoliController.this.refreshList("");
                }
                catch (Exception ex) {
                    ArticoliController.this.wd.labelWord = ex.getMessage();
                }
            }
        });
        this.cmbx_zonacoltivazione.setItems(this.lista_zonacoltivazione);
        this.cmbx_categoriavino.setItems(this.lista_categoriavino);
        this.cmbx_lingdescrcomm.setItems(this.lista_t01);
        this.cmbx_linguamarchioprod.setItems(this.lista_t01);
        this.cmbx_tipostoccaggio.setItems(this.lista_ta16);
        this.table.setItems(this.lista);
        this.column_nrimb.setCellValueFactory((Callback)new PropertyValueFactory("column_nrimb"));
        this.column_codiceimb.setCellValueFactory((Callback)new PropertyValueFactory("column_codice"));
        this.column_descrizioneimb.setCellValueFactory((Callback)new PropertyValueFactory("column_descrizione"));
        this.table_imb.setItems(this.lista_imballaggi);
    }

    private void svuota() {
        this.lista_imballaggi.clear();
        this.chk_prodotto_sfuso.selectedProperty().setValue(Boolean.FALSE);
        this.lista_docmex.clear();
        this.cmbx_categoriavino.getSelectionModel().selectFirst();
        this.cmbx_zonacoltivazione.getSelectionModel().selectFirst();
        this.cmbx_lingdescrcomm.getSelectionModel().selectFirst();
        this.cmbx_linguamarchioprod.getSelectionModel().selectFirst();
        this.cmbx_tipostoccaggio.getSelectionModel().selectFirst();
        this.editText_descrizionecomm.setText("");
        this.editText_marchiprod.setText("");
        this.editText_cadd.setText("");
        this.editText_aams.setText("");
        this.editText_capacita.setText("");
        this.editText__codiceprod.setText("");
        this.editText_cn.setText("");
        this.editText_codice.setText("");
        this.editText_codicecli.setText("");
        this.editText_cpa.setText("");
        this.editText_densita.setText("");
        this.editText_descrizione.setText("");
        this.editText_dimensioniprodotto.setText("");
        this.editText_gradoalcolico.setText("");
        this.editText_gradoalcolico.setText("");
        this.editText_gradoplato.setText("");
        this.editText_pesolordo.setText("");
        this.editText_pesonetto.setText("");
        this.editText_taric.setText("");
    }

    private void fillComboBoxZonaColtivazione() throws JSONException {
        ArrayList<String> tipoSQL = new ArrayList<String>();
        ArrayList<String> strSQL = new ArrayList<String>();
        ArrayList<Integer> lenghtBidimensionalArray = new ArrayList<Integer>();
        ArrayList<Boolean> lastID = new ArrayList<Boolean>();
        String data_select = "";
        lastID.add(false);
        this.lista_zonacoltivazione.clear();
        this.lista_zonacoltivazione.add(null);
        String str = "SELECT codice_std,codice,descrizione FROM accise_t_019  ";
        strSQL.add(str);
        tipoSQL.add("select");
        lenghtBidimensionalArray.add(0);
        String strJson = FXMLDocumentController.util.makeStringJsonDB("OFF", tipoSQL, strSQL, null, null, lastID, lenghtBidimensionalArray);
        data_select = FXMLDocumentController.sk1Comm.ServerEsecuteRequest(FXMLDocumentController.GLOBAL_IP, FXMLDocumentController.GLOBAL_PORT, "dbInteraction#@" + strJson);
        if (!data_select.contains("#ERR:")) {
            JSONArray arrayJson = FXMLDocumentController.jsonUtil.strJsonToJSONArray(data_select);
            for (int i = 0; i < arrayJson.length(); ++i) {
                JSONObject rec = arrayJson.getJSONObject(i);
                String codice = rec.getString("codice");
                String codice_std = rec.getString("codice_std");
                String descrizione = rec.getString("descrizione");
                this.lista_zonacoltivazione.add((Object)new CodiceDescrizioneComboBox(codice, codice_std + " - " + descrizione));
            }
        }
    }

    private void fillComboBoxCategoriaVino() throws JSONException {
        ArrayList<String> tipoSQL = new ArrayList<String>();
        ArrayList<String> strSQL = new ArrayList<String>();
        ArrayList<Integer> lenghtBidimensionalArray = new ArrayList<Integer>();
        ArrayList<Boolean> lastID = new ArrayList<Boolean>();
        String data_select = "";
        lastID.add(false);
        this.lista_categoriavino.clear();
        this.lista_categoriavino.add(null);
        String str = "SELECT codice,descrizione FROM accise_t_018  ";
        strSQL.add(str);
        tipoSQL.add("select");
        lenghtBidimensionalArray.add(0);
        String strJson = FXMLDocumentController.util.makeStringJsonDB("OFF", tipoSQL, strSQL, null, null, lastID, lenghtBidimensionalArray);
        data_select = FXMLDocumentController.sk1Comm.ServerEsecuteRequest(FXMLDocumentController.GLOBAL_IP, FXMLDocumentController.GLOBAL_PORT, "dbInteraction#@" + strJson);
        if (!data_select.contains("#ERR:")) {
            JSONArray arrayJson = FXMLDocumentController.jsonUtil.strJsonToJSONArray(data_select);
            for (int i = 0; i < arrayJson.length(); ++i) {
                JSONObject rec = arrayJson.getJSONObject(i);
                String codice = rec.getString("codice");
                String descrizione = rec.getString("descrizione");
                this.lista_categoriavino.add((Object)new CodiceDescrizioneComboBox(codice, descrizione));
            }
        }
    }

    private void fillComboBoxT01() throws JSONException {
        ArrayList<String> tipoSQL = new ArrayList<String>();
        ArrayList<String> strSQL = new ArrayList<String>();
        ArrayList<Integer> lenghtBidimensionalArray = new ArrayList<Integer>();
        ArrayList<Boolean> lastID = new ArrayList<Boolean>();
        String data_select = "";
        lastID.add(false);
        this.lista_t01.clear();
        this.lista_t01.add(null);
        String str = "SELECT codice,descrizione FROM accise_t_001 ORDER BY descrizione ASC";
        strSQL.add(str);
        tipoSQL.add("select");
        lenghtBidimensionalArray.add(0);
        String strJson = FXMLDocumentController.util.makeStringJsonDB("OFF", tipoSQL, strSQL, null, null, lastID, lenghtBidimensionalArray);
        data_select = FXMLDocumentController.sk1Comm.ServerEsecuteRequest(FXMLDocumentController.GLOBAL_IP, FXMLDocumentController.GLOBAL_PORT, "dbInteraction#@" + strJson);
        if (!data_select.contains("#ERR:")) {
            JSONArray arrayJson = FXMLDocumentController.jsonUtil.strJsonToJSONArray(data_select);
            for (int i = 0; i < arrayJson.length(); ++i) {
                JSONObject rec = arrayJson.getJSONObject(i);
                String codice = rec.getString("codice");
                String descrizione = rec.getString("descrizione");
                this.lista_t01.add((Object)new CodiceDescrizioneComboBox(codice, descrizione));
            }
        }
    }

    private void fillComboBoxTA16() throws JSONException {
        ArrayList<String> tipoSQL = new ArrayList<String>();
        ArrayList<String> strSQL = new ArrayList<String>();
        ArrayList<Integer> lenghtBidimensionalArray = new ArrayList<Integer>();
        ArrayList<Boolean> lastID = new ArrayList<Boolean>();
        String data_select = "";
        lastID.add(false);
        this.lista_ta16.clear();
        this.lista_ta16.add(null);
        String str = "SELECT codice,descrizione FROM accise_t_a16  ";
        strSQL.add(str);
        tipoSQL.add("select");
        lenghtBidimensionalArray.add(0);
        String strJson = FXMLDocumentController.util.makeStringJsonDB("OFF", tipoSQL, strSQL, null, null, lastID, lenghtBidimensionalArray);
        data_select = FXMLDocumentController.sk1Comm.ServerEsecuteRequest(FXMLDocumentController.GLOBAL_IP, FXMLDocumentController.GLOBAL_PORT, "dbInteraction#@" + strJson);
        if (!data_select.contains("#ERR:")) {
            JSONArray arrayJson = FXMLDocumentController.jsonUtil.strJsonToJSONArray(data_select);
            for (int i = 0; i < arrayJson.length(); ++i) {
                JSONObject rec = arrayJson.getJSONObject(i);
                String codice = rec.getString("codice");
                String descrizione = rec.getString("descrizione");
                this.lista_ta16.add((Object)new CodiceDescrizioneComboBox(codice, descrizione));
            }
        }
    }

    private void refreshList(String ander) {
        this.wd = new WorkIndicatorDialog(this.table.getScene().getWindow(), "Caricamento in corso...");
        this.wd.addTaskEndNotification(result -> {
            if (this.wd.labelWord != null && !this.wd.labelWord.equals("")) {
                FXMLDocumentController.toast.startToast(this.wd.labelWord, "ERRORE", "ERRORE");
            }
            this.wd = null;
            this.table.refresh();
        });
        this.wd.exec("123", inputParam -> {
            try {
                this.wd.labelWord = "";
                ArrayList<String> tipoSQL = new ArrayList<String>();
                ArrayList<String> strSQL = new ArrayList<String>();
                ArrayList<Integer> lenghtBidimensionalArray = new ArrayList<Integer>();
                ArrayList<Boolean> lastID = new ArrayList<Boolean>();
                String data_select = "";
                lastID.add(false);
                this.lista.clear();
                String str = "SELECT id,codice,codice_mexal,descrizione,cadd,codice_nomenclatura,taric,grado_plato,grado_alcolico,cpa,densita,peso_lordo,peso_netto,categoria_vino,zona_coltivazione,dimensioni_produttore,IFNULL(codice_prodotto,'') AS codice_prodotto  FROM gen_ana_accise_articoli WHERE azienda='" + FXMLDocumentController.GLOBAL_AZIENDA + "' AND sotto_az='" + FXMLDocumentController.GLOBAL_SOTTOAZZ + "' AND cod_accisa='" + FXMLDocumentController.GLOBAL_ICQRF + "' " + ander;
                strSQL.add(str);
                tipoSQL.add("select");
                lenghtBidimensionalArray.add(0);
                String strJson = FXMLDocumentController.util.makeStringJsonDB("OFF", tipoSQL, strSQL, null, null, lastID, lenghtBidimensionalArray);
                data_select = FXMLDocumentController.sk1Comm.ServerEsecuteRequest(FXMLDocumentController.GLOBAL_IP, FXMLDocumentController.GLOBAL_PORT, "dbInteraction#@" + strJson);
                if (!data_select.contains("#ERR:")) {
                    JSONArray arrayJson = FXMLDocumentController.jsonUtil.strJsonToJSONArray(data_select);
                    for (int i = 0; i < arrayJson.length(); ++i) {
                        JSONObject rec = arrayJson.getJSONObject(i);
                        String id = rec.get("id").toString();
                        String codice = rec.getString("codice");
                        String codice_mexal = rec.getString("codice_mexal");
                        String descrizione = rec.getString("descrizione");
                        String cadd = rec.getString("cadd");
                        String codice_nomenclatura = rec.getString("codice_nomenclatura");
                        String codice_prodotto = rec.getString("codice_prodotto");
                        String taric = rec.getString("taric");
                        BigDecimal grado_plato = new BigDecimal(rec.get("grado_plato").toString()).setScale(2, RoundingMode.HALF_UP);
                        BigDecimal grado_alcolico = new BigDecimal(rec.get("grado_alcolico").toString()).setScale(2, RoundingMode.HALF_UP);
                        String cpa = rec.getString("cpa");
                        BigDecimal densita = new BigDecimal(rec.get("densita").toString()).setScale(2, RoundingMode.HALF_UP);
                        BigDecimal peso_lordo = new BigDecimal(rec.get("peso_lordo").toString()).setScale(2, RoundingMode.HALF_UP);
                        BigDecimal peso_netto = new BigDecimal(rec.get("peso_netto").toString()).setScale(2, RoundingMode.HALF_UP);
                        String zona_coltivazione = rec.getString("zona_coltivazione");
                        int categoria_vino = rec.getInt("categoria_vino");
                        String dimensioni_produttore = rec.getString("dimensioni_produttore");
                        this.lista.add((Object)new ColumnTableArticoli(id, codice, codice_mexal, descrizione));
                    }
                }
            }
            catch (Exception ex) {
                this.wd.labelWord = ex.getMessage();
            }
            return 1;
        });
    }

    private void modifica(String id, boolean duplica) throws JSONException {
        ArrayList<String> tipoSQL = new ArrayList<String>();
        ArrayList<String> strSQL = new ArrayList<String>();
        ArrayList<Integer> lenghtBidimensionalArray = new ArrayList<Integer>();
        ArrayList<Boolean> lastID = new ArrayList<Boolean>();
        String data_select = "";
        lastID.add(false);
        String str = "SELECT a.id,a.codice,a.codice_mexal,a.descrizione,a.cadd,a.codice_nomenclatura,a.taric,a.grado_plato,a.grado_alcolico,a.cpa,a.densita,a.peso_lordo,a.peso_netto,a.categoria_vino,a.zona_coltivazione,a.dimensioni_produttore,a.aams,a.capacita,IFNULL(a.codice_prodotto,'') AS codice_prodotto,a.tipo_stoccaggio,IFNULL(b.um,'') AS um,IFNULL(b.iva,'') AS iva,IFNULL(b.cod_alternativo,'') AS codice_alternativo,IFNULL(b.descrizione,'') AS descrizione_mexal,flg_sfuso,a.descrizione_commerciale,lingua_descrcomm,marchio_prod,lingua_marchioprod  FROM gen_ana_accise_articoli AS a LEFT JOIN gen_ana_accise_articoli_mx AS b ON a.id=b.id_tipo_vino_ana WHERE a.id=" + id;
        strSQL.add(str);
        tipoSQL.add("select");
        lenghtBidimensionalArray.add(0);
        String strJson = FXMLDocumentController.util.makeStringJsonDB("OFF", tipoSQL, strSQL, null, null, lastID, lenghtBidimensionalArray);
        data_select = FXMLDocumentController.sk1Comm.ServerEsecuteRequest(FXMLDocumentController.GLOBAL_IP, FXMLDocumentController.GLOBAL_PORT, "dbInteraction#@" + strJson);
        if (!data_select.contains("#ERR:")) {
            JSONArray arrayJson = FXMLDocumentController.jsonUtil.strJsonToJSONArray(data_select);
            for (int i = 0; i < arrayJson.length(); ++i) {
                JSONObject rec = arrayJson.getJSONObject(i);
                final String codice = rec.getString("codice");
                final String flg_sfuso = rec.get("flg_sfuso").toString();
                final String codice_mexal = rec.getString("codice_mexal");
                final String descrizione = rec.getString("descrizione");
                String descrizione_mexal = rec.getString("descrizione_mexal");
                String codice_alternativo = rec.getString("codice_alternativo");
                String um = rec.getString("um");
                String iva = rec.getString("iva");
                final String aams = rec.getString("aams");
                String tipo_stoccaggio = rec.getString("tipo_stoccaggio");
                final String codice_prodotto = rec.getString("codice_prodotto");
                final String cadd = rec.getString("cadd");
                final String codice_nomenclatura = rec.getString("codice_nomenclatura");
                final String taric = rec.getString("taric");
                String lingua_marchioprod = rec.getString("lingua_marchioprod");
                final String marchio_prod = rec.getString("marchio_prod");
                String lingua_descrcomm = rec.getString("lingua_descrcomm");
                final String descrizione_commerciale = rec.getString("descrizione_commerciale");
                String descr_linguadescrcomm = "";
                String descr_linguamarchioprod = "";
                if (!lingua_marchioprod.equals("")) {
                    descr_linguamarchioprod = FXMLDocumentController.ricerca.getDescrizioneT001(lingua_marchioprod);
                }
                if (!lingua_descrcomm.equals("")) {
                    descr_linguadescrcomm = FXMLDocumentController.ricerca.getDescrizioneT001(lingua_descrcomm);
                }
                final BigDecimal capacita = new BigDecimal(rec.get("capacita").toString()).setScale(4, RoundingMode.HALF_UP);
                final BigDecimal grado_plato = new BigDecimal(rec.get("grado_plato").toString()).setScale(2, RoundingMode.HALF_UP);
                final BigDecimal grado_alcolico = new BigDecimal(rec.get("grado_alcolico").toString()).setScale(2, RoundingMode.HALF_UP);
                final String cpa = rec.getString("cpa");
                final BigDecimal densita = new BigDecimal(rec.get("densita").toString()).setScale(2, RoundingMode.HALF_UP);
                final BigDecimal peso_lordo = new BigDecimal(rec.get("peso_lordo").toString()).setScale(3, RoundingMode.HALF_UP);
                final BigDecimal peso_netto = new BigDecimal(rec.get("peso_netto").toString()).setScale(3, RoundingMode.HALF_UP);
                String zona_coltivazione = rec.getString("zona_coltivazione");
                int categoria_vino = rec.getInt("categoria_vino");
                final String dimensioni_produttore = rec.getString("dimensioni_produttore");
                String descr_zonacolt = "";
                if (!zona_coltivazione.equals("")) {
                    descr_zonacolt = FXMLDocumentController.ricerca.getDescrizioneZonaColtivazione(zona_coltivazione);
                }
                String descr_tipoprod = "";
                if (!tipo_stoccaggio.equals("")) {
                    descr_tipoprod = FXMLDocumentController.ricerca.getDescrizioneTipoStoccaggio(tipo_stoccaggio);
                }
                String descr_cvino = "";
                if (categoria_vino > 0) {
                    descr_cvino = FXMLDocumentController.ricerca.getDescrizioneCategoriaVino(String.valueOf(categoria_vino));
                }
                final CodiceDescrizioneComboBox cmg = new CodiceDescrizioneComboBox(zona_coltivazione, descr_zonacolt);
                final CodiceDescrizioneComboBox cmgd = new CodiceDescrizioneComboBox(String.valueOf(categoria_vino), descr_cvino);
                final CodiceDescrizioneComboBox cmgds = new CodiceDescrizioneComboBox(String.valueOf(tipo_stoccaggio), descr_tipoprod);
                final CodiceDescrizioneComboBox cmgdsd = new CodiceDescrizioneComboBox(lingua_descrcomm, descr_linguadescrcomm);
                final CodiceDescrizioneComboBox cmgdssd = new CodiceDescrizioneComboBox(lingua_marchioprod, descr_linguamarchioprod);
                if (!codice_mexal.equals("")) {
                    this.lista_docmex.clear();
                    this.lista_docmex.put("codice", codice);
                    this.lista_docmex.put("descrizione", descrizione_mexal);
                    this.lista_docmex.put("iva", iva);
                    this.lista_docmex.put("um", um);
                    this.lista_docmex.put("cod_alt", codice_alternativo);
                }
                this.lista_imballaggi.addAll(this.getListaImballaggi(id));
                Platform.runLater((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        if (flg_sfuso.equals("0")) {
                            ArticoliController.this.chk_prodotto_sfuso.selectedProperty().setValue(Boolean.FALSE);
                        } else {
                            ArticoliController.this.chk_prodotto_sfuso.selectedProperty().setValue(Boolean.TRUE);
                        }
                        ArticoliController.this.editText__codiceprod.setText(codice_prodotto);
                        ArticoliController.this.editText_codice.setText(codice);
                        ArticoliController.this.editText_codicecli.setText(codice_mexal);
                        ArticoliController.this.editText_descrizionecomm.setText(descrizione_commerciale);
                        ArticoliController.this.editText_marchiprod.setText(marchio_prod);
                        ArticoliController.this.cmbx_lingdescrcomm.getSelectionModel().clearSelection();
                        ArticoliController.this.cmbx_linguamarchioprod.getSelectionModel().clearSelection();
                        ArticoliController.this.cmbx_linguamarchioprod.getSelectionModel().select((Object)cmgdssd);
                        ArticoliController.this.cmbx_lingdescrcomm.getSelectionModel().select((Object)cmgdsd);
                        ArticoliController.this.cmbx_categoriavino.getSelectionModel().clearSelection();
                        ArticoliController.this.cmbx_categoriavino.getSelectionModel().select((Object)cmgd);
                        ArticoliController.this.cmbx_zonacoltivazione.getSelectionModel().clearSelection();
                        ArticoliController.this.cmbx_zonacoltivazione.getSelectionModel().select((Object)cmg);
                        ArticoliController.this.cmbx_tipostoccaggio.getSelectionModel().clearSelection();
                        ArticoliController.this.cmbx_tipostoccaggio.getSelectionModel().select((Object)cmgds);
                        ArticoliController.this.editText_aams.setText(aams);
                        ArticoliController.this.editText_cadd.setText(cadd);
                        ArticoliController.this.editText_capacita.setText(capacita.toString());
                        ArticoliController.this.editText_cn.setText(codice_nomenclatura);
                        ArticoliController.this.editText_cpa.setText(cpa);
                        ArticoliController.this.editText_densita.setText(densita.toString());
                        ArticoliController.this.editText_descrizione.setText(descrizione);
                        ArticoliController.this.editText_dimensioniprodotto.setText(dimensioni_produttore);
                        ArticoliController.this.editText_gradoalcolico.setText(grado_alcolico.toString());
                        ArticoliController.this.editText_gradoplato.setText(grado_plato.toString());
                        ArticoliController.this.editText_pesolordo.setText(peso_lordo.toString());
                        ArticoliController.this.editText_pesonetto.setText(peso_netto.toString());
                        ArticoliController.this.editText_taric.setText(taric);
                    }
                });
                if (!duplica) {
                    this.flg_modifica = true;
                    this.editText_codice.setEditable(false);
                    continue;
                }
                this.flg_modifica = false;
                this.editText_codice.setEditable(true);
            }
        }
    }

    private ObservableList<ColumnTableImbo> getListaImballaggi(String id) throws JSONException {
        ObservableList ret = FXCollections.observableArrayList();
        ArrayList<String> tipoSQL = new ArrayList<String>();
        ArrayList<String> strSQL = new ArrayList<String>();
        ArrayList<Integer> lenghtBidimensionalArray = new ArrayList<Integer>();
        ArrayList<Boolean> lastID = new ArrayList<Boolean>();
        String data_select = "";
        lastID.add(false);
        String str = "SELECT id,codice,descrizione,nr_imballaggi  FROM gen_ana_accise_articoli_imballaggi WHERE id_articolo=" + id;
        strSQL.add(str);
        tipoSQL.add("select");
        lenghtBidimensionalArray.add(0);
        String strJson = FXMLDocumentController.util.makeStringJsonDB("OFF", tipoSQL, strSQL, null, null, lastID, lenghtBidimensionalArray);
        data_select = FXMLDocumentController.sk1Comm.ServerEsecuteRequest(FXMLDocumentController.GLOBAL_IP, FXMLDocumentController.GLOBAL_PORT, "dbInteraction#@" + strJson);
        if (!data_select.contains("#ERR:")) {
            JSONArray arrayJson = FXMLDocumentController.jsonUtil.strJsonToJSONArray(data_select);
            for (int i = 0; i < arrayJson.length(); ++i) {
                JSONObject rec = arrayJson.getJSONObject(i);
                String id_ = rec.get("id").toString();
                String codice = rec.getString("codice");
                String descrizione = rec.getString("descrizione");
                String nr_imballaggi = rec.getString("nr_imballaggi");
                ret.add((Object)new ColumnTableImbo(id_, codice, descrizione, nr_imballaggi, id));
            }
        }
        return ret;
    }

    private void salva() throws JSONException {
        String aams = this.editText_aams.getText().trim();
        String codice_prodotto = this.editText__codiceprod.getText().trim();
        String taric = this.editText_taric.getText().trim();
        String cadd = this.editText_cadd.getText().trim();
        String codice = this.editText_codice.getText().trim();
        String codice_mexal = this.editText_codicecli.getText().trim();
        String codice_nomenclatura = this.editText_cn.getText().trim();
        String descrizione = this.editText_descrizione.getText().trim();
        String descrizione_commerciale = this.editText_descrizionecomm.getText().trim();
        String marchio_prod = this.editText_marchiprod.getText().trim();
        String cpa = this.editText_cpa.getText().trim();
        String capacita = this.editText_capacita.getText().trim();
        String grado_plato = this.editText_gradoplato.getText().trim();
        String grado_alcolico = this.editText_gradoalcolico.getText().trim();
        String densita = this.editText_densita.getText().trim();
        String peso_lordo = this.editText_pesolordo.getText().trim();
        String peso_netto = this.editText_pesonetto.getText().trim();
        String dimensioni_produttore = this.editText_dimensioniprodotto.getText().trim();
        String zona_coltivazione = "";
        String categoria_vino = "";
        String tipo_stoccaggio = "";
        String lingua_descrcomm = "";
        String lingua_marchioprod = "";
        boolean check_sfuso = this.chk_prodotto_sfuso.selectedProperty().getValue();
        String check_prodotto_sfuso = "0";
        if (check_sfuso) {
            check_prodotto_sfuso = "1";
        }
        CodiceDescrizioneComboBox cvino = (CodiceDescrizioneComboBox)this.cmbx_categoriavino.getSelectionModel().getSelectedItem();
        CodiceDescrizioneComboBox zcolt = (CodiceDescrizioneComboBox)this.cmbx_zonacoltivazione.getSelectionModel().getSelectedItem();
        CodiceDescrizioneComboBox tipst = (CodiceDescrizioneComboBox)this.cmbx_tipostoccaggio.getSelectionModel().getSelectedItem();
        CodiceDescrizioneComboBox mproddes = (CodiceDescrizioneComboBox)this.cmbx_linguamarchioprod.getSelectionModel().getSelectedItem();
        CodiceDescrizioneComboBox dproddes = (CodiceDescrizioneComboBox)this.cmbx_lingdescrcomm.getSelectionModel().getSelectedItem();
        if (cvino != null) {
            categoria_vino = cvino.getCodice();
        }
        if (zcolt != null) {
            zona_coltivazione = zcolt.getCodice();
        }
        if (tipst != null) {
            tipo_stoccaggio = tipst.getCodice();
        }
        if (mproddes != null) {
            lingua_marchioprod = mproddes.getCodice();
        }
        if (dproddes != null) {
            lingua_descrcomm = dproddes.getCodice();
        }
        if (grado_alcolico.equals("")) {
            grado_alcolico = "0";
        }
        if (grado_plato.equals("")) {
            grado_plato = "0";
        }
        if (densita.equals("")) {
            densita = "0";
        }
        if (peso_netto.equals("")) {
            peso_netto = "0";
        }
        if (peso_lordo.equals("")) {
            peso_lordo = "0";
        }
        if (capacita.equals("")) {
            capacita = "0";
        }
        if (categoria_vino.equals("")) {
            categoria_vino = "0";
        }
        if (!codice.equals("")) {
            boolean controllo_codice = this.checkIfExistCiente(codice);
            if (controllo_codice && !this.flg_modifica) {
                this.wd.labelWord = "#ERR: Codice gi\u00e0 utilizzato !";
            } else if (this.flg_modifica) {
                this.update(codice, codice_mexal, descrizione, cpa, codice_nomenclatura, cadd, taric, aams, grado_alcolico, grado_plato, densita, peso_lordo, peso_netto, categoria_vino, zona_coltivazione, dimensioni_produttore, capacita, codice_prodotto, tipo_stoccaggio, check_prodotto_sfuso, descrizione_commerciale, lingua_descrcomm, marchio_prod, lingua_marchioprod);
            } else {
                this.insert(codice, codice_mexal, descrizione, cpa, codice_nomenclatura, cadd, taric, aams, grado_alcolico, grado_plato, densita, peso_lordo, peso_netto, categoria_vino, zona_coltivazione, dimensioni_produttore, capacita, codice_prodotto, tipo_stoccaggio, check_prodotto_sfuso, descrizione_commerciale, lingua_descrcomm, marchio_prod, lingua_marchioprod);
            }
        } else {
            this.wd.labelWord = "#ERR: Campo Codice obbligatorio !";
        }
    }

    private void update(String codice, String codice_mexal, String descrizione, String cpa, String codice_nomenclatura, String cadd, String taric, String aams, String grado_alcolico, String grado_plato, String densita, String peso_lordo, String peso_netto, String categoria_vino, String zona_coltivazione, String dimensioni_produttore, String capacita, String codice_prodotto, String tipo_stoccaggio, String flg_sfuso, String descrizione_commerciale, String lingua_descrcomm, String marchio_prod, String lingua_marchioprod) throws JSONException {
        int iterator = 0;
        ArrayList<String> tipoSQL = new ArrayList<String>();
        ArrayList<String> strSQL = new ArrayList<String>();
        ArrayList<Integer> lenghtBidimensionalArray = new ArrayList<Integer>();
        ArrayList<Boolean> lastID = new ArrayList<Boolean>();
        String str = "";
        String data_select = "";
        String[][] tipo_ins = null;
        String[][] valore = null;
        HashMap<Integer, String[]> ipos = new HashMap<Integer, String[]>();
        HashMap<Integer, String[]> alores = new HashMap<Integer, String[]>();
        String[] res = new String[1];
        FXMLDocumentController.sqlUtil.delete_gen_ana_accise_articoli(FXMLDocumentController.GLOBAL_AZIENDA, FXMLDocumentController.GLOBAL_SOTTOAZZ, FXMLDocumentController.GLOBAL_ICQRF, codice);
        strSQL.addAll(FXMLDocumentController.sqlUtil.strSQL);
        tipoSQL.addAll(FXMLDocumentController.sqlUtil.tipoinsSQL);
        lenghtBidimensionalArray.addAll(FXMLDocumentController.sqlUtil.lengthSQL);
        lastID.addAll(FXMLDocumentController.sqlUtil.lastID);
        ipos.put(iterator, FXMLDocumentController.sqlUtil.tipovaloreSQL.toArray(new String[0]));
        alores.put(iterator, FXMLDocumentController.sqlUtil.valoreSQL.toArray(new String[0]));
        ++iterator;
        FXMLDocumentController.sqlUtil.insert_gen_ana_accise_articoli(FXMLDocumentController.GLOBAL_AZIENDA, FXMLDocumentController.GLOBAL_SOTTOAZZ, FXMLDocumentController.GLOBAL_ICQRF, codice, codice_mexal, descrizione, cpa, codice_nomenclatura, cadd, taric, aams, grado_alcolico, grado_plato, densita, peso_lordo, peso_netto, categoria_vino, zona_coltivazione, dimensioni_produttore, capacita, codice_prodotto, tipo_stoccaggio, flg_sfuso, descrizione_commerciale, lingua_descrcomm, marchio_prod, lingua_marchioprod);
        strSQL.addAll(FXMLDocumentController.sqlUtil.strSQL);
        tipoSQL.addAll(FXMLDocumentController.sqlUtil.tipoinsSQL);
        lenghtBidimensionalArray.addAll(FXMLDocumentController.sqlUtil.lengthSQL);
        lastID.addAll(FXMLDocumentController.sqlUtil.lastID);
        ipos.put(iterator, FXMLDocumentController.sqlUtil.tipovaloreSQL.toArray(new String[0]));
        alores.put(iterator, FXMLDocumentController.sqlUtil.valoreSQL.toArray(new String[0]));
        ++iterator;
        lastID.add(false);
        tipoSQL.add("insert");
        strSQL.add("SET @id_testata:=(LAST_INSERT_ID());");
        lenghtBidimensionalArray.add(0);
        res[0] = "";
        ipos.put(iterator, res);
        alores.put(iterator, res);
        ++iterator;
        if (!codice_mexal.equals("")) {
            String um = "";
            String iva = "";
            String cod_alt = "";
            String descr = "";
            for (Map.Entry<String, String> entry : this.lista_docmex.entrySet()) {
                String key = entry.getKey();
                String val = entry.getValue();
                switch (key) {
                    case "descrizione": {
                        descr = val;
                        break;
                    }
                    case "um": {
                        um = val;
                        break;
                    }
                    case "iva": {
                        iva = val;
                        break;
                    }
                    case "cod_alt": {
                        cod_alt = val;
                    }
                }
            }
            FXMLDocumentController.sqlUtil.delete_gen_ana_accise_articoli_mx(FXMLDocumentController.GLOBAL_AZIENDA, FXMLDocumentController.GLOBAL_SOTTOAZZ, FXMLDocumentController.GLOBAL_ICQRF, codice);
            strSQL.addAll(FXMLDocumentController.sqlUtil.strSQL);
            tipoSQL.addAll(FXMLDocumentController.sqlUtil.tipoinsSQL);
            lenghtBidimensionalArray.addAll(FXMLDocumentController.sqlUtil.lengthSQL);
            lastID.addAll(FXMLDocumentController.sqlUtil.lastID);
            ipos.put(iterator, FXMLDocumentController.sqlUtil.tipovaloreSQL.toArray(new String[0]));
            alores.put(iterator, FXMLDocumentController.sqlUtil.valoreSQL.toArray(new String[0]));
            ++iterator;
            FXMLDocumentController.sqlUtil.insert_gen_ana_accise_articoli_mx(FXMLDocumentController.GLOBAL_AZIENDA, FXMLDocumentController.GLOBAL_SOTTOAZZ, FXMLDocumentController.GLOBAL_ICQRF, "@id_testata", codice_mexal, descr, iva, um, cod_alt);
            strSQL.addAll(FXMLDocumentController.sqlUtil.strSQL);
            tipoSQL.addAll(FXMLDocumentController.sqlUtil.tipoinsSQL);
            lenghtBidimensionalArray.addAll(FXMLDocumentController.sqlUtil.lengthSQL);
            lastID.addAll(FXMLDocumentController.sqlUtil.lastID);
            ipos.put(iterator, FXMLDocumentController.sqlUtil.tipovaloreSQL.toArray(new String[0]));
            alores.put(iterator, FXMLDocumentController.sqlUtil.valoreSQL.toArray(new String[0]));
            ++iterator;
        }
        for (int i = 0; i < this.lista_imballaggi.size(); ++i) {
            String id_articolo = "@id_testata";
            String codice_imb = ((ColumnTableImbo)this.lista_imballaggi.get(i)).getColumn_codice();
            String descrizione_imb = ((ColumnTableImbo)this.lista_imballaggi.get(i)).getColumn_descrizione();
            String nr_imb = ((ColumnTableImbo)this.lista_imballaggi.get(i)).getColumn_nrimb();
            FXMLDocumentController.sqlUtil.insert_gen_ana_accise_articoli_imballaggi(FXMLDocumentController.GLOBAL_AZIENDA, FXMLDocumentController.GLOBAL_SOTTOAZZ, FXMLDocumentController.GLOBAL_ICQRF, id_articolo, codice_imb, descrizione_imb, nr_imb);
            strSQL.addAll(FXMLDocumentController.sqlUtil.strSQL);
            tipoSQL.addAll(FXMLDocumentController.sqlUtil.tipoinsSQL);
            lenghtBidimensionalArray.addAll(FXMLDocumentController.sqlUtil.lengthSQL);
            lastID.addAll(FXMLDocumentController.sqlUtil.lastID);
            ipos.put(iterator, FXMLDocumentController.sqlUtil.tipovaloreSQL.toArray(new String[0]));
            alores.put(iterator, FXMLDocumentController.sqlUtil.valoreSQL.toArray(new String[0]));
            ++iterator;
        }
        tipo_ins = FXMLDocumentController.util.HashMapBidimensionalTOArrayBidimensional(ipos);
        valore = FXMLDocumentController.util.HashMapBidimensionalTOArrayBidimensional(alores);
        String strJson = FXMLDocumentController.util.makeStringJsonDB("ON", tipoSQL, strSQL, tipo_ins, valore, lastID, lenghtBidimensionalArray);
        this.wd.labelWord = data_select = FXMLDocumentController.sk1Comm.ServerEsecuteRequest(FXMLDocumentController.GLOBAL_IP, FXMLDocumentController.GLOBAL_PORT, "dbInteraction#@" + strJson);
    }

    private void insert(String codice, String codice_mexal, String descrizione, String cpa, String codice_nomenclatura, String cadd, String taric, String aams, String grado_alcolico, String grado_plato, String densita, String peso_lordo, String peso_netto, String categoria_vino, String zona_coltivazione, String dimensioni_produttore, String capacita, String codice_prodotto, String tipo_stoccaggio, String flg_sfuso, String descrizione_commerciale, String lingua_descrcomm, String marchio_prod, String lingua_marchioprod) throws JSONException {
        int iterator = 0;
        ArrayList<String> tipoSQL = new ArrayList<String>();
        ArrayList<String> strSQL = new ArrayList<String>();
        ArrayList<Integer> lenghtBidimensionalArray = new ArrayList<Integer>();
        ArrayList<Boolean> lastID = new ArrayList<Boolean>();
        String str = "";
        String data_select = "";
        String[][] tipo_ins = null;
        String[][] valore = null;
        HashMap<Integer, String[]> ipos = new HashMap<Integer, String[]>();
        HashMap<Integer, String[]> alores = new HashMap<Integer, String[]>();
        String[] res = new String[1];
        FXMLDocumentController.sqlUtil.insert_gen_ana_accise_articoli(FXMLDocumentController.GLOBAL_AZIENDA, FXMLDocumentController.GLOBAL_SOTTOAZZ, FXMLDocumentController.GLOBAL_ICQRF, codice, codice_mexal, descrizione, cpa, codice_nomenclatura, cadd, taric, aams, grado_alcolico, grado_plato, densita, peso_lordo, peso_netto, categoria_vino, zona_coltivazione, dimensioni_produttore, capacita, codice_prodotto, tipo_stoccaggio, flg_sfuso, descrizione_commerciale, lingua_descrcomm, marchio_prod, lingua_marchioprod);
        strSQL.addAll(FXMLDocumentController.sqlUtil.strSQL);
        tipoSQL.addAll(FXMLDocumentController.sqlUtil.tipoinsSQL);
        lenghtBidimensionalArray.addAll(FXMLDocumentController.sqlUtil.lengthSQL);
        lastID.addAll(FXMLDocumentController.sqlUtil.lastID);
        ipos.put(iterator, FXMLDocumentController.sqlUtil.tipovaloreSQL.toArray(new String[0]));
        alores.put(iterator, FXMLDocumentController.sqlUtil.valoreSQL.toArray(new String[0]));
        ++iterator;
        lastID.add(false);
        tipoSQL.add("insert");
        strSQL.add("SET @id_testata:=(LAST_INSERT_ID());");
        lenghtBidimensionalArray.add(0);
        res[0] = "";
        ipos.put(iterator, res);
        alores.put(iterator, res);
        ++iterator;
        if (!codice_mexal.equals("")) {
            String um = "";
            String iva = "";
            String cod_alt = "";
            String descr = "";
            for (Map.Entry<String, String> entry : this.lista_docmex.entrySet()) {
                String key = entry.getKey();
                String val = entry.getValue();
                switch (key) {
                    case "descrizione": {
                        descr = val;
                        break;
                    }
                    case "um": {
                        um = val;
                        break;
                    }
                    case "iva": {
                        iva = val;
                        break;
                    }
                    case "cod_alt": {
                        cod_alt = val;
                    }
                }
            }
            FXMLDocumentController.sqlUtil.insert_gen_ana_accise_articoli_mx(FXMLDocumentController.GLOBAL_AZIENDA, FXMLDocumentController.GLOBAL_SOTTOAZZ, FXMLDocumentController.GLOBAL_ICQRF, "@id_testata", codice_mexal, descr, iva, um, cod_alt);
            strSQL.addAll(FXMLDocumentController.sqlUtil.strSQL);
            tipoSQL.addAll(FXMLDocumentController.sqlUtil.tipoinsSQL);
            lenghtBidimensionalArray.addAll(FXMLDocumentController.sqlUtil.lengthSQL);
            lastID.addAll(FXMLDocumentController.sqlUtil.lastID);
            ipos.put(iterator, FXMLDocumentController.sqlUtil.tipovaloreSQL.toArray(new String[0]));
            alores.put(iterator, FXMLDocumentController.sqlUtil.valoreSQL.toArray(new String[0]));
            ++iterator;
        }
        for (int i = 0; i < this.lista_imballaggi.size(); ++i) {
            String id_articolo = "@id_testata";
            String codice_imb = ((ColumnTableImbo)this.lista_imballaggi.get(i)).getColumn_codice();
            String descrizione_imb = ((ColumnTableImbo)this.lista_imballaggi.get(i)).getColumn_descrizione();
            String nr_imb = ((ColumnTableImbo)this.lista_imballaggi.get(i)).getColumn_nrimb();
            FXMLDocumentController.sqlUtil.insert_gen_ana_accise_articoli_imballaggi(FXMLDocumentController.GLOBAL_AZIENDA, FXMLDocumentController.GLOBAL_SOTTOAZZ, FXMLDocumentController.GLOBAL_ICQRF, id_articolo, codice_imb, descrizione_imb, nr_imb);
            strSQL.addAll(FXMLDocumentController.sqlUtil.strSQL);
            tipoSQL.addAll(FXMLDocumentController.sqlUtil.tipoinsSQL);
            lenghtBidimensionalArray.addAll(FXMLDocumentController.sqlUtil.lengthSQL);
            lastID.addAll(FXMLDocumentController.sqlUtil.lastID);
            ipos.put(iterator, FXMLDocumentController.sqlUtil.tipovaloreSQL.toArray(new String[0]));
            alores.put(iterator, FXMLDocumentController.sqlUtil.valoreSQL.toArray(new String[0]));
            ++iterator;
        }
        tipo_ins = FXMLDocumentController.util.HashMapBidimensionalTOArrayBidimensional(ipos);
        valore = FXMLDocumentController.util.HashMapBidimensionalTOArrayBidimensional(alores);
        String strJson = FXMLDocumentController.util.makeStringJsonDB("ON", tipoSQL, strSQL, tipo_ins, valore, lastID, lenghtBidimensionalArray);
        this.wd.labelWord = data_select = FXMLDocumentController.sk1Comm.ServerEsecuteRequest(FXMLDocumentController.GLOBAL_IP, FXMLDocumentController.GLOBAL_PORT, "dbInteraction#@" + strJson);
    }

    private boolean checkIfExistCiente(String codice) throws JSONException {
        boolean ret = false;
        ArrayList<String> tipoSQL = new ArrayList<String>();
        ArrayList<String> strSQL = new ArrayList<String>();
        ArrayList<Integer> lenghtBidimensionalArray = new ArrayList<Integer>();
        ArrayList<Boolean> lastID = new ArrayList<Boolean>();
        String data_select = "";
        lastID.add(false);
        String str = "SELECT IFNULL(id,0) AS id FROM gen_ana_accise_articoli WHERE codice='" + codice + "' AND azienda='" + FXMLDocumentController.GLOBAL_AZIENDA + "' AND sotto_az='" + FXMLDocumentController.GLOBAL_SOTTOAZZ + "' AND cod_accisa='" + FXMLDocumentController.GLOBAL_ICQRF + "' ";
        strSQL.add(str);
        tipoSQL.add("select");
        lenghtBidimensionalArray.add(0);
        String strJson = FXMLDocumentController.util.makeStringJsonDB("OFF", tipoSQL, strSQL, null, null, lastID, lenghtBidimensionalArray);
        data_select = FXMLDocumentController.sk1Comm.ServerEsecuteRequest(FXMLDocumentController.GLOBAL_IP, FXMLDocumentController.GLOBAL_PORT, "dbInteraction#@" + strJson);
        if (!data_select.contains("#ERR:")) {
            JSONArray arrayJson = FXMLDocumentController.jsonUtil.strJsonToJSONArray(data_select);
            for (int i = 0; i < arrayJson.length(); ++i) {
                JSONObject rec = arrayJson.getJSONObject(i);
                int ids = rec.getInt("id");
                if (ids <= 0) continue;
                ret = true;
            }
        }
        return ret;
    }

    private boolean checkIfExistCodiceMexal(String codice) throws JSONException {
        boolean ret = false;
        ArrayList<String> tipoSQL = new ArrayList<String>();
        ArrayList<String> strSQL = new ArrayList<String>();
        ArrayList<Integer> lenghtBidimensionalArray = new ArrayList<Integer>();
        ArrayList<Boolean> lastID = new ArrayList<Boolean>();
        String data_select = "";
        lastID.add(false);
        String str = "SELECT IFNULL(id,0) AS id FROM gen_ana_accise_articoli_mx WHERE codice='" + codice + "' AND azienda='" + FXMLDocumentController.GLOBAL_AZIENDA + "' AND sotto_az='" + FXMLDocumentController.GLOBAL_SOTTOAZZ + "' AND cod_accisa='" + FXMLDocumentController.GLOBAL_ICQRF + "' ";
        strSQL.add(str);
        tipoSQL.add("select");
        lenghtBidimensionalArray.add(0);
        String strJson = FXMLDocumentController.util.makeStringJsonDB("OFF", tipoSQL, strSQL, null, null, lastID, lenghtBidimensionalArray);
        data_select = FXMLDocumentController.sk1Comm.ServerEsecuteRequest(FXMLDocumentController.GLOBAL_IP, FXMLDocumentController.GLOBAL_PORT, "dbInteraction#@" + strJson);
        if (!data_select.contains("#ERR:")) {
            JSONArray arrayJson = FXMLDocumentController.jsonUtil.strJsonToJSONArray(data_select);
            for (int i = 0; i < arrayJson.length(); ++i) {
                JSONObject rec = arrayJson.getJSONObject(i);
                int ids = rec.getInt("id");
                if (ids <= 0) continue;
                ret = true;
            }
        }
        return ret;
    }

    @FXML
    private void btnDuplica(ActionEvent event) {
        this.svuota();
        this.wd = new WorkIndicatorDialog(this.table.getScene().getWindow(), "Caricamento in corso...");
        this.wd.addTaskEndNotification(result -> {
            if (this.wd.labelWord != null && this.wd.labelWord.contains("#ERR:")) {
                FXMLDocumentController.util.alertWindow(this.stack, this.wd.labelWord, "ERRORE", "ERRORE");
            }
            this.wd = null;
            this.table.refresh();
        });
        this.wd.exec("123", new ToIntFunction(){

            public int applyAsInt(Object value) {
                try {
                    ColumnTableArticoli dest = (ColumnTableArticoli)ArticoliController.this.table.getSelectionModel().getSelectedItem();
                    if (dest != null) {
                        ArticoliController.this.modifica(dest.getColumn_id(), true);
                    }
                }
                catch (Exception ex) {
                    ArticoliController.this.wd.labelWord = "#ERR:" + ex.toString();
                }
                return 1;
            }
        });
    }

    @FXML
    private void btnAggiungiImbo(ActionEvent event) throws IOException {
        FXMLLoader loader = new FXMLLoader(this.getClass().getResource("/accise/view/FinestraArticoloImb.fxml"));
        final Stage stage = new Stage();
        stage.setMaximized(false);
        stage.setTitle("Articolo Imballaggi");
        stage.setScene(new Scene((Parent)((Pane)loader.load())));
        FinestraArtiImbController controller = (FinestraArtiImbController)loader.getController();
        controller.getParent().setOnMousePressed((EventHandler)new EventHandler<MouseEvent>(){

            public void handle(MouseEvent event) {
                ArticoliController.this.xOffset = event.getSceneX();
                ArticoliController.this.yOffset = event.getSceneY();
            }
        });
        controller.getParent().setOnMouseDragged((EventHandler)new EventHandler<MouseEvent>(){

            public void handle(MouseEvent event) {
                stage.setX(event.getScreenX() - ArticoliController.this.xOffset);
                stage.setY(event.getScreenY() - ArticoliController.this.yOffset);
                stage.setOpacity((double)0.8f);
            }
        });
        controller.getParent().setOnDragDone((EventHandler)new EventHandler<DragEvent>(){

            public void handle(DragEvent event) {
                stage.setOpacity(1.0);
            }
        });
        controller.getParent().setOnMouseReleased((EventHandler)new EventHandler<MouseEvent>(){

            public void handle(MouseEvent event) {
                stage.setOpacity(1.0);
            }
        });
        stage.initModality(Modality.APPLICATION_MODAL);
        stage.initStyle(StageStyle.UNDECORATED);
        stage.initOwner(this.cmbx_tipostoccaggio.getScene().getWindow());
        stage.setResizable(false);
        stage.showAndWait();
        String codice = controller.getCodice();
        String descrizione = controller.getDescrizione();
        String nr_imballaggi = controller.getNr_imballaggi();
        if (!codice.equals("")) {
            this.lista_imballaggi.add((Object)new ColumnTableImbo("0", codice, descrizione, nr_imballaggi, "0"));
        }
        this.table_imb.refresh();
    }

    @FXML
    private void btnEliminaImbo(ActionEvent event) {
        ColumnTableImbo oper = (ColumnTableImbo)this.table_imb.getSelectionModel().getSelectedItem();
        if (oper != null) {
            this.lista_imballaggi.remove((Object)oper);
        }
        this.table_imb.refresh();
    }

    @FXML
    private void btnImport(ActionEvent event) throws IOException {
        ImportFileCSV csv = new ImportFileCSV();
        csv.getFile();
        csv.addExtFilter("CSV files (*.csv)", "*.csv");
        final File file = csv.open();
        if (file != null) {
            if (file.getName().contains("ANAG_ARTICOLI")) {
                JFXDialogLayout dialogLayout = new JFXDialogLayout();
                dialogLayout.setHeading(new Node[]{new Text("PROCEDERE CON L'IMPORT ?")});
                Label txt = new Label("DIGITARE PROCEDI ");
                final JFXTextField edit = new JFXTextField();
                HBox lolo2 = new HBox();
                lolo2.getChildren().add((Object)txt);
                lolo2.getChildren().add((Object)edit);
                lolo2.setSpacing(5.0);
                lolo2.setAlignment(Pos.CENTER);
                dialogLayout.setBody(new Node[]{lolo2});
                final JFXDialog dialog = new JFXDialog(this.stack, (Region)dialogLayout, JFXDialog.DialogTransition.CENTER);
                dialog.setStyle("-fx-background-color: rgba(221,75,57,0.7);");
                JFXButton btn = new JFXButton("OK");
                btn.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

                    public void handle(ActionEvent event) {
                        String res = edit.getText().trim();
                        if (res.equals("PROCEDI")) {
                            try {
                                ArticoliController.this.wd = new WorkIndicatorDialog(ArticoliController.this.table.getScene().getWindow(), "Caricamento in corso...");
                                ArticoliController.this.wd.addTaskEndNotification(result -> {
                                    if (ArticoliController.this.wd.labelWord != null) {
                                        if (ArticoliController.this.wd.labelWord.contains("#ERR:")) {
                                            FXMLDocumentController.util.alertWindow(ArticoliController.this.stack, ArticoliController.this.wd.labelWord, "ERRORE", "ERRORE");
                                        } else {
                                            ArticoliController.this.refreshList("");
                                        }
                                    }
                                    ArticoliController.this.wd = null;
                                    ArticoliController.this.table.refresh();
                                });
                                ArticoliController.this.wd.exec("123", new ToIntFunction(){

                                    public int applyAsInt(Object value) {
                                        try {
                                            ArticoliController.this.importArticoli(file);
                                        }
                                        catch (Exception ex) {
                                            ArticoliController.this.wd.labelWord = "#ERR:" + ex.toString();
                                        }
                                        return 1;
                                    }
                                });
                            }
                            catch (Exception ex) {
                                Logger.getLogger(DestinatariController.class.getName()).log(Level.SEVERE, null, ex);
                            }
                        }
                        dialog.close();
                    }
                });
                JFXButton btn2 = new JFXButton("ANNULLA");
                btn2.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

                    public void handle(ActionEvent event) {
                        dialog.close();
                    }
                });
                btn.setPadding(new Insets(5.0));
                btn2.setPadding(new Insets(5.0));
                btn.setStyle("-fx-background-color: #00A65A;-fx-text-fill: #FFFFFF;-fx-font-weight: bold;-fx-font-size: 14px;");
                btn2.setStyle("-fx-background-color: #ACACAC;-fx-text-fill: #FFFFFF;-fx-font-weight: bold;-fx-font-size: 14px;");
                HBox lolo = new HBox();
                lolo.getChildren().add((Object)btn);
                lolo.getChildren().add((Object)btn2);
                lolo.setSpacing(5.0);
                dialogLayout.setActions(new Node[]{lolo});
                dialog.setDialogContainer(this.stack);
                dialog.show();
            } else {
                String labelWord = "File csv errato";
                FXMLDocumentController.util.alertWindow(this.stack, labelWord, "ERRORE", "ERRORE");
            }
        } else {
            String labelWord = "File csv errato";
            FXMLDocumentController.util.alertWindow(this.stack, labelWord, "ERRORE", "ERRORE");
        }
    }

    private void importArticoli(File file) throws IOException {
        if (file != null) {
            String[] res = new String[1];
            ArrayList<String> tipoSQLmx = new ArrayList<String>();
            ArrayList<String> strSQLmx = new ArrayList<String>();
            ArrayList<Integer> lenghtBidimensionalArraymx = new ArrayList<Integer>();
            ArrayList<Boolean> lastIDmx = new ArrayList<Boolean>();
            String[][] tipo_insmx = null;
            String[][] valoremx = null;
            HashMap<Integer, String[]> ipos = new HashMap<Integer, String[]>();
            HashMap<Integer, String[]> alores = new HashMap<Integer, String[]>();
            int iterator = 0;
            int iso = 0;
            try (BufferedReader br = new BufferedReader(new FileReader(file));){
                String line;
                while ((line = br.readLine()) != null) {
                    String[] colonne;
                    if (iso > 0 && (colonne = line.split(";", -1)).length == 19) {
                        boolean controllo_codice;
                        String id = colonne[0].trim();
                        String codice = Utility.padLeftZeros(id, 5);
                        String denominazione = colonne[1].trim();
                        String cpa = colonne[2].trim();
                        String nomenclatura = colonne[3].trim();
                        String taric = colonne[4].trim();
                        String cadd = colonne[5].trim();
                        String aams = colonne[6].trim();
                        String grado_alcolico = colonne[7].trim().replace(",", ".");
                        String grado_plato = colonne[8].trim().replace(",", ".");
                        String data_cancellazione = colonne[9].trim();
                        String id_utente = colonne[10].trim();
                        String densita = colonne[11].trim();
                        String dimensioni = colonne[12].trim();
                        String tip_imb = colonne[13].trim();
                        String categoria_vino = colonne[14].trim();
                        if (categoria_vino.equals("-")) {
                            categoria_vino = "0";
                        } else if (categoria_vino.equals("")) {
                            categoria_vino = "0";
                        }
                        String zona = colonne[15].trim();
                        String peso_lordo = colonne[16].trim().replace(",", ".");
                        String peso_netto = colonne[17].trim().replace(",", ".");
                        String capacita = colonne[18].trim().replace(",", ".");
                        if (capacita.equals("")) {
                            capacita = "0";
                        }
                        String tipo_stoccaggio = "S";
                        String flg_sfuso = "1";
                        if (Double.parseDouble(capacita) > 0.0) {
                            tipo_stoccaggio = "N";
                            flg_sfuso = "0";
                        }
                        if (zona.equals("-1")) {
                            zona = "";
                        }
                        if (tip_imb.equals("-1")) {
                            tip_imb = "";
                        }
                        if (controllo_codice = this.checkIfExistCiente(codice)) {
                            this.wd.labelWord = this.wd.labelWord + "#ERR: " + codice + " - Codice gi\u00e0 utilizzato !";
                        } else {
                            FXMLDocumentController.sqlUtil.insert_gen_ana_accise_articoli(FXMLDocumentController.GLOBAL_AZIENDA, FXMLDocumentController.GLOBAL_SOTTOAZZ, FXMLDocumentController.GLOBAL_ICQRF, codice, "", denominazione, cpa, nomenclatura, cadd, taric, aams, grado_alcolico, grado_plato, densita, peso_lordo, peso_netto, categoria_vino, zona, dimensioni, capacita, "", tipo_stoccaggio, flg_sfuso, "", "", "", "");
                            strSQLmx.addAll(FXMLDocumentController.sqlUtil.strSQL);
                            tipoSQLmx.addAll(FXMLDocumentController.sqlUtil.tipoinsSQL);
                            lenghtBidimensionalArraymx.addAll(FXMLDocumentController.sqlUtil.lengthSQL);
                            lastIDmx.addAll(FXMLDocumentController.sqlUtil.lastID);
                            ipos.put(iterator, FXMLDocumentController.sqlUtil.tipovaloreSQL.toArray(new String[0]));
                            alores.put(iterator, FXMLDocumentController.sqlUtil.valoreSQL.toArray(new String[0]));
                            ++iterator;
                            lastIDmx.add(false);
                            tipoSQLmx.add("insert");
                            strSQLmx.add("SET @id_testata:=(LAST_INSERT_ID());");
                            lenghtBidimensionalArraymx.add(0);
                            res[0] = "";
                            ipos.put(iterator, res);
                            alores.put(iterator, res);
                            ++iterator;
                            if (!tip_imb.equals("")) {
                                String id_articolo = "@id_testata";
                                String codice_imb = tip_imb;
                                String descrizione_imb = FXMLDocumentController.ricerca.getDescrizioneT010(tip_imb);
                                String nr_imb = "1";
                                FXMLDocumentController.sqlUtil.insert_gen_ana_accise_articoli_imballaggi(FXMLDocumentController.GLOBAL_AZIENDA, FXMLDocumentController.GLOBAL_SOTTOAZZ, FXMLDocumentController.GLOBAL_ICQRF, id_articolo, codice_imb, descrizione_imb, nr_imb);
                                strSQLmx.addAll(FXMLDocumentController.sqlUtil.strSQL);
                                tipoSQLmx.addAll(FXMLDocumentController.sqlUtil.tipoinsSQL);
                                lenghtBidimensionalArraymx.addAll(FXMLDocumentController.sqlUtil.lengthSQL);
                                lastIDmx.addAll(FXMLDocumentController.sqlUtil.lastID);
                                ipos.put(iterator, FXMLDocumentController.sqlUtil.tipovaloreSQL.toArray(new String[0]));
                                alores.put(iterator, FXMLDocumentController.sqlUtil.valoreSQL.toArray(new String[0]));
                                ++iterator;
                            }
                        }
                    }
                    ++iso;
                }
                tipo_insmx = FXMLDocumentController.util.HashMapBidimensionalTOArrayBidimensional(ipos);
                valoremx = FXMLDocumentController.util.HashMapBidimensionalTOArrayBidimensional(alores);
                String strJson = FXMLDocumentController.util.makeStringJsonDB("ON", tipoSQLmx, strSQLmx, tipo_insmx, valoremx, lastIDmx, lenghtBidimensionalArraymx);
                String data_select = FXMLDocumentController.sk1Comm.ServerEsecuteRequest(FXMLDocumentController.GLOBAL_IP, FXMLDocumentController.GLOBAL_PORT, "dbInteraction#@" + strJson);
                if (data_select.contains("#ERR:")) {
                    this.wd.labelWord = data_select;
                }
            }
            catch (Exception ex) {
                Logger.getLogger(ConfConferimentiController.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }
}

