/*
 * Decompiled with CFR 0.152.
 */
package accise.controller;

import com.jfoenix.controls.JFXButton;
import de.jensd.fx.glyphs.fontawesome.FontAwesomeIconView;
import java.net.URL;
import java.util.ArrayList;
import java.util.ResourceBundle;
import javafx.application.Platform;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.collections.transformation.FilteredList;
import javafx.collections.transformation.SortedList;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.TextField;
import javafx.scene.control.cell.PropertyValueFactory;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.AnchorPane;
import javafx.stage.Stage;
import javafx.util.Callback;
import org.json.JSONArray;
import org.json.JSONObject;
import vin.Class.ColumnTableCodiceDescrizione;
import vin.Class.WorkIndicatorDialog;
import vin.controller.FXMLDocumentController;

public class SearchButtonTipoImballaggio
implements Initializable {
    @FXML
    private AnchorPane parent;
    @FXML
    private FontAwesomeIconView btn_close;
    @FXML
    private TextField editText_searcharticolo;
    @FXML
    private TableView<ColumnTableCodiceDescrizione> table;
    @FXML
    private TableColumn<ColumnTableCodiceDescrizione, String> column_codice;
    @FXML
    private TableColumn<ColumnTableCodiceDescrizione, String> column_descrizione;
    @FXML
    private JFXButton btn_salva;
    FilteredList<ColumnTableCodiceDescrizione> filteredData = null;
    ObservableList<ColumnTableCodiceDescrizione> lista = FXCollections.observableArrayList();
    WorkIndicatorDialog wd = null;
    String descrizione;
    String codice = "";

    @FXML
    void btnClose(MouseEvent event) {
        Stage stage = (Stage)this.table.getScene().getWindow();
        stage.close();
    }

    public String getCodice() {
        return this.codice;
    }

    @FXML
    void btnSalva(ActionEvent event) {
        ColumnTableCodiceDescrizione f = (ColumnTableCodiceDescrizione)this.table.getSelectionModel().getSelectedItem();
        if (f != null) {
            this.codice = f.getColumn_codice();
            this.descrizione = f.getColumn_descrizione();
            Stage stage = (Stage)this.table.getScene().getWindow();
            stage.close();
        }
    }

    public void initialize(URL location, ResourceBundle resources) {
        this.column_descrizione.setCellValueFactory((Callback)new PropertyValueFactory("column_descrizione"));
        this.column_codice.setCellValueFactory((Callback)new PropertyValueFactory("column_codice"));
        Platform.runLater((Runnable)new Runnable(){

            @Override
            public void run() {
                SearchButtonTipoImballaggio.this.search();
            }
        });
        this.filteredData = new FilteredList(this.lista, p -> true);
        this.editText_searcharticolo.textProperty().addListener((observable, oldValue, newValue) -> this.filteredData.setPredicate(person -> {
            if (newValue == null || newValue.isEmpty()) {
                return true;
            }
            String lowerCaseFilter = newValue.toLowerCase();
            if (person.getColumn_codice().toLowerCase().contains(lowerCaseFilter)) {
                return true;
            }
            return person.getColumn_descrizione().toLowerCase().contains(lowerCaseFilter);
        }));
        SortedList sortedData = new SortedList(this.filteredData);
        sortedData.comparatorProperty().bind((ObservableValue)this.table.comparatorProperty());
        this.table.setItems((ObservableList)sortedData);
        this.table.setOnMousePressed((EventHandler)new EventHandler<MouseEvent>(){

            public void handle(MouseEvent e) {
                if (e.isPrimaryButtonDown() && e.getClickCount() == 2) {
                    ColumnTableCodiceDescrizione f = (ColumnTableCodiceDescrizione)SearchButtonTipoImballaggio.this.table.getSelectionModel().getSelectedItem();
                    SearchButtonTipoImballaggio.this.codice = f.getColumn_codice();
                    SearchButtonTipoImballaggio.this.descrizione = f.getColumn_descrizione();
                    Stage stage = (Stage)SearchButtonTipoImballaggio.this.table.getScene().getWindow();
                    stage.close();
                }
            }
        });
    }

    public AnchorPane getParent() {
        return this.parent;
    }

    public String getDescrizione() {
        return this.descrizione;
    }

    private void search() {
        this.wd = new WorkIndicatorDialog(this.table.getScene().getWindow(), "Caricamento in corso...");
        this.wd.addTaskEndNotification(result -> {
            if (this.wd != null && this.wd.labelWord != null && !this.wd.labelWord.equals("")) {
                FXMLDocumentController.toast.startToast(this.wd.labelWord, "ERRORE", "ERRORE");
            }
            this.table.refresh();
        });
        this.wd.exec("123", inputParam -> {
            try {
                ArrayList<String> tipoSQL = new ArrayList<String>();
                ArrayList<String> strSQL = new ArrayList<String>();
                ArrayList<Integer> lenghtBidimensionalArray = new ArrayList<Integer>();
                ArrayList<Boolean> lastID = new ArrayList<Boolean>();
                String data_select = "";
                lastID.add(false);
                this.lista.clear();
                String str = "SELECT codice,descrizione_italiana AS descrizione FROM accise_t_010  ";
                strSQL.add(str);
                tipoSQL.add("select");
                lenghtBidimensionalArray.add(0);
                String strJson = FXMLDocumentController.util.makeStringJsonDB("OFF", tipoSQL, strSQL, null, null, lastID, lenghtBidimensionalArray);
                data_select = FXMLDocumentController.sk1Comm.ServerEsecuteRequest(FXMLDocumentController.GLOBAL_IP, FXMLDocumentController.GLOBAL_PORT, "dbInteraction#@" + strJson);
                if (!data_select.contains("#ERR:")) {
                    JSONArray arrayJson = FXMLDocumentController.jsonUtil.strJsonToJSONArray(data_select);
                    for (int i = 0; i < arrayJson.length(); ++i) {
                        JSONObject rec = arrayJson.getJSONObject(i);
                        String codice = rec.getString("codice");
                        String descrizione = rec.getString("descrizione");
                        this.lista.add((Object)new ColumnTableCodiceDescrizione(0, codice, descrizione));
                    }
                }
            }
            catch (Exception ex) {
                this.wd.labelWord = ex.getMessage();
            }
            return 1;
        });
    }

    @FXML
    private void btnSearch(ActionEvent event) {
        this.search();
    }
}

