/*
 * Decompiled with CFR 0.152.
 */
package accise.controller;

import accise.classi.ColumnTableDettDAA;
import accise.classi.ColumnTableImballaggi;
import accise.classi.ColumnTableImbo;
import accise.classi.ColumnTableVino;
import accise.classi.Condizioni;
import accise.classi.Regole;
import accise.controller.FinestraImballaggiController;
import accise.controller.FinestraVinoDAAController;
import accise.controller.NavigatorAcciseController;
import accise.controller.SearchButtonCPA;
import accise.controller.SearchProdottoEAD;
import com.jfoenix.controls.JFXButton;
import com.jfoenix.controls.JFXCheckBox;
import de.jensd.fx.glyphs.fontawesome.FontAwesomeIconView;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.application.Platform;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.fxml.FXML;
import javafx.fxml.FXMLLoader;
import javafx.fxml.Initializable;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Alert;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Label;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.TextField;
import javafx.scene.control.TextInputDialog;
import javafx.scene.control.cell.PropertyValueFactory;
import javafx.scene.input.DragEvent;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.AnchorPane;
import javafx.scene.layout.Pane;
import javafx.scene.layout.StackPane;
import javafx.stage.Stage;
import javafx.stage.StageStyle;
import javafx.util.Callback;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import vin.Class.CodiceDescrizione;
import vin.Class.CodiceDescrizioneComboBox;
import vin.Class.WorkIndicatorDialog;
import vin.controller.FXMLDocumentController;

public class FinestraDettDAAController
implements Initializable {
    @FXML
    private AnchorPane parent;
    @FXML
    private FontAwesomeIconView btn_close;
    @FXML
    private TextField editText_codice;
    @FXML
    private TextField editText_cpa;
    @FXML
    private TextField editText_cn;
    @FXML
    private TextField editText_cadd;
    @FXML
    private TextField editText_taric;
    @FXML
    private TextField editText_aams;
    @FXML
    private TextField editText_capacita;
    @FXML
    private TextField editText_densita;
    @FXML
    private TextField editText_descrizione;
    @FXML
    private TextField editText_pesolordo;
    @FXML
    private TextField editText_pesonetto;
    @FXML
    private TextField editText_gradoalcolico;
    @FXML
    private TextField editText_gradoplato;
    @FXML
    private TextField editText_dimensioniprodotto;
    @FXML
    private ComboBox<CodiceDescrizioneComboBox> cmbx_categoriavino;
    @FXML
    private ComboBox<CodiceDescrizioneComboBox> cmbx_zonacoltivazione;
    @FXML
    private TableView<CodiceDescrizione> table_vino;
    @FXML
    private TableColumn<CodiceDescrizione, String> column_idvino;
    @FXML
    private TableColumn<CodiceDescrizione, String> column_codicevino;
    @FXML
    private TableView<ColumnTableImballaggi> table_imb;
    @FXML
    private TableColumn<ColumnTableImballaggi, String> column_idimb;
    @FXML
    private TableColumn<ColumnTableImballaggi, String> column_tipoimb;
    @FXML
    private TableColumn<ColumnTableImballaggi, String> column_numeroimb;
    @FXML
    private TableColumn<ColumnTableImballaggi, String> column_identcommsigilli;
    @FXML
    private TableColumn<ColumnTableImballaggi, String> column_infsigimb;
    @FXML
    private TableColumn<ColumnTableImballaggi, String> column_linguainfsigimb;
    @FXML
    private TableColumn<ColumnTableImballaggi, String> column_identimb;
    @FXML
    private JFXButton btn_salva;
    @FXML
    private TextField editText_marchioprodotto;
    @FXML
    private ComboBox<CodiceDescrizioneComboBox> cmbx_linguamarchioprod;
    @FXML
    private TextField editText_contrfisc;
    @FXML
    private ComboBox<CodiceDescrizioneComboBox> cmbx_linguacontrfisc;
    @FXML
    private TextField editText_usocontrfisc;
    @FXML
    private TextField editText_denominazioneorigine;
    @FXML
    private ComboBox<CodiceDescrizioneComboBox> cmbx_linguadenominazione;
    @FXML
    private TextField editText_descrizionecomm;
    @FXML
    private ComboBox<CodiceDescrizioneComboBox> cmbx_linguadescrcomm;
    @FXML
    private ComboBox<CodiceDescrizioneComboBox> cmbx_paeseterzo;
    @FXML
    private TextField editText_altreinf;
    @FXML
    private ComboBox<CodiceDescrizioneComboBox> cmbx_linguaaltreinf;
    double xOffset = 0.0;
    double yOffset = 0.0;
    ObservableList<CodiceDescrizioneComboBox> lista_t_001 = FXCollections.observableArrayList();
    ObservableList<CodiceDescrizioneComboBox> lista_t_005 = FXCollections.observableArrayList();
    ObservableList<CodiceDescrizioneComboBox> lista_t018 = FXCollections.observableArrayList();
    ObservableList<CodiceDescrizioneComboBox> lista_t019 = FXCollections.observableArrayList();
    ObservableList<CodiceDescrizioneComboBox> lista_ta16 = FXCollections.observableArrayList();
    ObservableList<CodiceDescrizione> lista_vinotrattamento = FXCollections.observableArrayList();
    ObservableList<ColumnTableImballaggi> lista_imb = FXCollections.observableArrayList();
    ObservableList<ColumnTableDettDAA> lista_dettdaa = FXCollections.observableArrayList();
    WorkIndicatorDialog wd = null;
    boolean flg_modifica = false;
    public String stato_calcoloaccisa = "";
    @FXML
    private TextField editText_codiceprodotto;
    @FXML
    private Label text_codiceprod;
    @FXML
    private ComboBox<CodiceDescrizioneComboBox> cmbx_tipostoccaggio;
    @FXML
    private JFXButton btn_cercarticolo;
    @FXML
    private JFXButton btn_svuotaarticolo;
    @FXML
    private TextField editText_nrbottiglie;
    @FXML
    private JFXCheckBox chk_prodotto_sfuso;
    @FXML
    private TextField editText_quantita;
    @FXML
    private StackPane stack;
    List<String> errori = new ArrayList<String>();
    String id = "";
    boolean import_doc = false;
    Regole regole = new Regole();

    public void setStato_calcoloaccisa(String stato_calcoloaccisa) {
        this.stato_calcoloaccisa = stato_calcoloaccisa;
    }

    public ObservableList<ColumnTableDettDAA> getLista_dettdaa() {
        return this.lista_dettdaa;
    }

    public AnchorPane getParent() {
        return this.parent;
    }

    public void initialize(URL url, ResourceBundle rb) {
        this.editText_codiceprodotto.setVisible(false);
        this.editText_codiceprodotto.setManaged(false);
        this.text_codiceprod.setVisible(false);
        this.text_codiceprod.setManaged(false);
        FXMLDocumentController.util.addOnlyNumber(this.editText_nrbottiglie);
        FXMLDocumentController.util.addOnlyNumber(this.editText_capacita);
        this.editText_nrbottiglie.textProperty().addListener((observable, oldValue, newValue) -> {
            if (newValue != null) {
                try {
                    this.calcola();
                }
                catch (JSONException ex) {
                    Logger.getLogger(FinestraDettDAAController.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
        });
        Platform.runLater((Runnable)new Runnable(){

            @Override
            public void run() {
                FinestraDettDAAController.this.wd = new WorkIndicatorDialog(FinestraDettDAAController.this.cmbx_categoriavino.getScene().getWindow(), "Caricamento in corso...");
                FinestraDettDAAController.this.wd.addTaskEndNotification(result -> {
                    if (FinestraDettDAAController.this.wd != null && FinestraDettDAAController.this.wd.labelWord != null && !FinestraDettDAAController.this.wd.labelWord.equals("")) {
                        FXMLDocumentController.toast.startToast(FinestraDettDAAController.this.wd.labelWord, "ERRORE", "ERRORE");
                    }
                });
                FinestraDettDAAController.this.wd.exec("123", inputParam -> {
                    try {
                        FinestraDettDAAController.this.fillComboBoxZonaColtivazione();
                        FinestraDettDAAController.this.fillComboBoxCategoriaVino();
                        FinestraDettDAAController.this.fillComboBoxLinguadescr();
                        FinestraDettDAAController.this.fillComboBoxT005();
                        FinestraDettDAAController.this.fillComboBoxTa16();
                    }
                    catch (JSONException ex) {
                        FinestraDettDAAController.this.wd.labelWord = ex.getMessage();
                    }
                    return 1;
                });
            }
        });
        this.cmbx_linguaaltreinf.setItems(this.lista_t_001);
        this.cmbx_linguacontrfisc.setItems(this.lista_t_001);
        this.cmbx_linguadenominazione.setItems(this.lista_t_001);
        this.cmbx_linguadescrcomm.setItems(this.lista_t_001);
        this.cmbx_linguamarchioprod.setItems(this.lista_t_001);
        this.cmbx_categoriavino.setItems(this.lista_t018);
        this.cmbx_zonacoltivazione.setItems(this.lista_t019);
        this.cmbx_paeseterzo.setItems(this.lista_t_005);
        this.cmbx_tipostoccaggio.setItems(this.lista_ta16);
        this.column_codicevino.setCellValueFactory((Callback)new PropertyValueFactory("descrizione"));
        this.table_vino.setItems(this.lista_vinotrattamento);
        this.column_identimb.setCellValueFactory((Callback)new PropertyValueFactory("column_identificativoimb"));
        this.column_identcommsigilli.setCellValueFactory((Callback)new PropertyValueFactory("column_identificazionecomm"));
        this.column_idimb.setCellValueFactory((Callback)new PropertyValueFactory("column_id"));
        this.column_infsigimb.setCellValueFactory((Callback)new PropertyValueFactory("column_infsigilli"));
        this.column_linguainfsigimb.setCellValueFactory((Callback)new PropertyValueFactory("column_linguainfsig"));
        this.column_numeroimb.setCellValueFactory((Callback)new PropertyValueFactory("column_numeroimballaggi"));
        this.column_tipoimb.setCellValueFactory((Callback)new PropertyValueFactory("column_tipoimballaggio"));
        this.table_imb.setItems(this.lista_imb);
        this.editText_aams.setOnKeyPressed((EventHandler)new EventHandler<KeyEvent>(){

            public void handle(KeyEvent event) {
                if (event.getCode() == KeyCode.F1 && FinestraDettDAAController.this.editText_aams.isFocused()) {
                    FXMLDocumentController.util.alertWindow(FinestraDettDAAController.this.stack, "Per i prodotti alcolici i campi Codice TARIC e Codice CADD, unitamente ai campi CPA - Categoria merceologica e Codice NC,\n devono essere coerenti e validi temporalmente rispetto alla stessa riga della tabella TA20 alla data di spedizione, cio\u00e8 in corrispondenza \ndella NC indicata nel dettaglio dell\u2019e-AD. Per i prodotti energetici i campi Codice TARIC e Codice CADD, unitamente ai campi CPA - Categoria\n merceologica e Codice NC, devono essere coerenti e validi temporalmente rispetto alla stessa riga della tabella TA13 alla data di spedizione, \ncio\u00e8 in corrispondenza della NC indicata nel dettaglio dell\u2019e-AD. Per i tabacchi indicare un codice AAMS valido alla data di spedizione.\n Per i prodotti energetici e gli impieghi previsti dal punto 11 della Tabella A del D.Lgs. 504/95, il campo \"Codice prodotto AAMS\" \u00e8 utilizzato \nper indicare l'uso agevolato. Pu\u00f2 assumere il valore \u201c1\u201c seguito da 4 spazi per \u201cproduzione di energia elettrica\u201d, \u201c2\u201d seguito da 4 spazi per \n\u201cautoproduzione di energia elettrica\u201d, deve essere vuoto in tutti gli altri casi.", "R020", "information");
                }
            }
        });
    }

    private void fillComboBoxLinguadescr() throws JSONException {
        ArrayList<String> tipoSQL = new ArrayList<String>();
        ArrayList<String> strSQL = new ArrayList<String>();
        ArrayList<Integer> lenghtBidimensionalArray = new ArrayList<Integer>();
        ArrayList<Boolean> lastID = new ArrayList<Boolean>();
        String data_select = "";
        lastID.add(false);
        this.lista_t_001.clear();
        this.lista_t_001.add(null);
        String str = "SELECT codice,descrizione FROM accise_t_001 ORDER BY descrizione ASC";
        strSQL.add(str);
        tipoSQL.add("select");
        lenghtBidimensionalArray.add(0);
        String strJson = FXMLDocumentController.util.makeStringJsonDB("OFF", tipoSQL, strSQL, null, null, lastID, lenghtBidimensionalArray);
        data_select = FXMLDocumentController.sk1Comm.ServerEsecuteRequest(FXMLDocumentController.GLOBAL_IP, FXMLDocumentController.GLOBAL_PORT, "dbInteraction#@" + strJson);
        if (!data_select.contains("#ERR:")) {
            JSONArray arrayJson = FXMLDocumentController.jsonUtil.strJsonToJSONArray(data_select);
            for (int i = 0; i < arrayJson.length(); ++i) {
                JSONObject rec = arrayJson.getJSONObject(i);
                String codice = rec.get("codice").toString();
                String descrizione = rec.getString("descrizione");
                this.lista_t_001.add((Object)new CodiceDescrizioneComboBox(codice, descrizione));
            }
        }
    }

    private void fillComboBoxT005() throws JSONException {
        ArrayList<String> tipoSQL = new ArrayList<String>();
        ArrayList<String> strSQL = new ArrayList<String>();
        ArrayList<Integer> lenghtBidimensionalArray = new ArrayList<Integer>();
        ArrayList<Boolean> lastID = new ArrayList<Boolean>();
        String data_select = "";
        lastID.add(false);
        this.lista_t_005.clear();
        this.lista_t_005.add(null);
        String str = "SELECT codice,descrizione FROM accise_t_005 ORDER BY descrizione ASC";
        strSQL.add(str);
        tipoSQL.add("select");
        lenghtBidimensionalArray.add(0);
        String strJson = FXMLDocumentController.util.makeStringJsonDB("OFF", tipoSQL, strSQL, null, null, lastID, lenghtBidimensionalArray);
        data_select = FXMLDocumentController.sk1Comm.ServerEsecuteRequest(FXMLDocumentController.GLOBAL_IP, FXMLDocumentController.GLOBAL_PORT, "dbInteraction#@" + strJson);
        if (!data_select.contains("#ERR:")) {
            JSONArray arrayJson = FXMLDocumentController.jsonUtil.strJsonToJSONArray(data_select);
            for (int i = 0; i < arrayJson.length(); ++i) {
                JSONObject rec = arrayJson.getJSONObject(i);
                String codice = rec.get("codice").toString();
                String descrizione = rec.getString("descrizione");
                this.lista_t_005.add((Object)new CodiceDescrizioneComboBox(codice, descrizione));
            }
        }
    }

    private void fillComboBoxTa16() throws JSONException {
        ArrayList<String> tipoSQL = new ArrayList<String>();
        ArrayList<String> strSQL = new ArrayList<String>();
        ArrayList<Integer> lenghtBidimensionalArray = new ArrayList<Integer>();
        ArrayList<Boolean> lastID = new ArrayList<Boolean>();
        String data_select = "";
        lastID.add(false);
        this.lista_ta16.clear();
        this.lista_ta16.add(null);
        String str = "SELECT codice,descrizione FROM accise_t_a16 ORDER BY descrizione ASC";
        strSQL.add(str);
        tipoSQL.add("select");
        lenghtBidimensionalArray.add(0);
        String strJson = FXMLDocumentController.util.makeStringJsonDB("OFF", tipoSQL, strSQL, null, null, lastID, lenghtBidimensionalArray);
        data_select = FXMLDocumentController.sk1Comm.ServerEsecuteRequest(FXMLDocumentController.GLOBAL_IP, FXMLDocumentController.GLOBAL_PORT, "dbInteraction#@" + strJson);
        if (!data_select.contains("#ERR:")) {
            JSONArray arrayJson = FXMLDocumentController.jsonUtil.strJsonToJSONArray(data_select);
            for (int i = 0; i < arrayJson.length(); ++i) {
                JSONObject rec = arrayJson.getJSONObject(i);
                String codice = rec.get("codice").toString();
                String descrizione = rec.getString("descrizione");
                this.lista_ta16.add((Object)new CodiceDescrizioneComboBox(codice, descrizione));
            }
        }
    }

    private void fillComboBoxZonaColtivazione() throws JSONException {
        ArrayList<String> tipoSQL = new ArrayList<String>();
        ArrayList<String> strSQL = new ArrayList<String>();
        ArrayList<Integer> lenghtBidimensionalArray = new ArrayList<Integer>();
        ArrayList<Boolean> lastID = new ArrayList<Boolean>();
        String data_select = "";
        lastID.add(false);
        this.lista_t019.clear();
        this.lista_t019.add(null);
        String str = "SELECT codice_std,codice,descrizione FROM accise_t_019  ";
        strSQL.add(str);
        tipoSQL.add("select");
        lenghtBidimensionalArray.add(0);
        String strJson = FXMLDocumentController.util.makeStringJsonDB("OFF", tipoSQL, strSQL, null, null, lastID, lenghtBidimensionalArray);
        data_select = FXMLDocumentController.sk1Comm.ServerEsecuteRequest(FXMLDocumentController.GLOBAL_IP, FXMLDocumentController.GLOBAL_PORT, "dbInteraction#@" + strJson);
        if (!data_select.contains("#ERR:")) {
            JSONArray arrayJson = FXMLDocumentController.jsonUtil.strJsonToJSONArray(data_select);
            for (int i = 0; i < arrayJson.length(); ++i) {
                JSONObject rec = arrayJson.getJSONObject(i);
                String codice = rec.getString("codice");
                String codice_std = rec.getString("codice_std");
                String descrizione = rec.getString("descrizione");
                this.lista_t019.add((Object)new CodiceDescrizioneComboBox(codice, codice_std + " - " + descrizione));
            }
        }
    }

    private void fillComboBoxCategoriaVino() throws JSONException {
        ArrayList<String> tipoSQL = new ArrayList<String>();
        ArrayList<String> strSQL = new ArrayList<String>();
        ArrayList<Integer> lenghtBidimensionalArray = new ArrayList<Integer>();
        ArrayList<Boolean> lastID = new ArrayList<Boolean>();
        String data_select = "";
        lastID.add(false);
        this.lista_t018.clear();
        this.lista_t018.add(null);
        String str = "SELECT codice,descrizione FROM accise_t_018  ";
        strSQL.add(str);
        tipoSQL.add("select");
        lenghtBidimensionalArray.add(0);
        String strJson = FXMLDocumentController.util.makeStringJsonDB("OFF", tipoSQL, strSQL, null, null, lastID, lenghtBidimensionalArray);
        data_select = FXMLDocumentController.sk1Comm.ServerEsecuteRequest(FXMLDocumentController.GLOBAL_IP, FXMLDocumentController.GLOBAL_PORT, "dbInteraction#@" + strJson);
        if (!data_select.contains("#ERR:")) {
            JSONArray arrayJson = FXMLDocumentController.jsonUtil.strJsonToJSONArray(data_select);
            for (int i = 0; i < arrayJson.length(); ++i) {
                JSONObject rec = arrayJson.getJSONObject(i);
                String codice = rec.getString("codice");
                String descrizione = rec.getString("descrizione");
                this.lista_t018.add((Object)new CodiceDescrizioneComboBox(codice, descrizione));
            }
        }
    }

    @FXML
    private void btnClose(MouseEvent event) {
        Stage stage = (Stage)this.btn_close.getScene().getWindow();
        stage.close();
    }

    @FXML
    private void btnCercaArticolo(ActionEvent event) throws IOException, FileNotFoundException, URISyntaxException, JSONException {
        int i;
        FXMLLoader loader = new FXMLLoader(this.getClass().getResource("/accise/view/SearchProdottoEAD.fxml"));
        final Stage stage = new Stage();
        stage.setMaximized(false);
        stage.setTitle("Prodotto");
        stage.setScene(new Scene((Parent)((Pane)loader.load())));
        SearchProdottoEAD controller = (SearchProdottoEAD)loader.getController();
        stage.initStyle(StageStyle.UNDECORATED);
        stage.initOwner(((Node)event.getSource()).getScene().getWindow());
        controller.getParent().setOnMousePressed((EventHandler)new EventHandler<MouseEvent>(){

            public void handle(MouseEvent event) {
                FinestraDettDAAController.this.xOffset = event.getSceneX();
                FinestraDettDAAController.this.yOffset = event.getSceneY();
            }
        });
        controller.getParent().setOnMouseDragged((EventHandler)new EventHandler<MouseEvent>(){

            public void handle(MouseEvent event) {
                stage.setX(event.getScreenX() - FinestraDettDAAController.this.xOffset);
                stage.setY(event.getScreenY() - FinestraDettDAAController.this.yOffset);
                stage.setOpacity((double)0.8f);
            }
        });
        controller.getParent().setOnDragDone((EventHandler)new EventHandler<DragEvent>(){

            public void handle(DragEvent event) {
                stage.setOpacity(1.0);
            }
        });
        controller.getParent().setOnMouseReleased((EventHandler)new EventHandler<MouseEvent>(){

            public void handle(MouseEvent event) {
                stage.setOpacity(1.0);
            }
        });
        stage.showAndWait();
        stage.setResizable(false);
        this.resetta();
        String id = controller.getId();
        final String aams = controller.getAams();
        final String cadd = controller.getCadd();
        final String capacita = controller.getCapacita();
        final String catvino = controller.getCategoria_vino();
        final String codice = controller.getCodice();
        final String codicenc = controller.getCodicenc();
        final String cpa = controller.getCpa();
        final String densita = controller.getDensita();
        final String descrizione = controller.getDescrizione();
        final String dim_prod = controller.getDimensioni_produttore();
        final String grado_alcolico = controller.getGrado_alcolico();
        final String grado_plato = controller.getGrado_plato();
        final String peso_lordo = controller.getPeso_lordo();
        final String peso_netto = controller.getPeso_netto();
        final String taric = controller.getTaric();
        final String codice_prodotto = controller.getCodice_prodotto();
        final String zona_coltivazione = controller.getZona_coltivazione();
        final String tipo_stoccString = controller.getTipo_stoccaggio();
        final String marchio_prod = controller.getMarchio_prod();
        final String lingua_marchioprod = controller.getLingua_marchioprod();
        final String descrizione_commerciale = controller.getDescrizione_commerciale();
        final String lingua_descrcomm = controller.getLingua_descrcomm();
        List<ColumnTableImbo> lista_imbo = controller.getLista_imbo();
        String descr_tipostoc = "";
        if (!tipo_stoccString.equals("")) {
            try {
                descr_tipostoc = FXMLDocumentController.ricerca.getDescrizioneTipoStoccaggio(tipo_stoccString);
            }
            catch (JSONException ex) {
                Logger.getLogger(FinestraDettDAAController.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        String descr_linguadescrcomm = "";
        String descr_linguamarchiprod = "";
        if (!lingua_descrcomm.equals("")) {
            try {
                descr_linguadescrcomm = FXMLDocumentController.ricerca.getDescrizioneT001(lingua_descrcomm);
            }
            catch (JSONException ex) {
                Logger.getLogger(FinestraDettDAAController.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        if (!lingua_marchioprod.equals("")) {
            try {
                descr_linguamarchiprod = FXMLDocumentController.ricerca.getDescrizioneT001(lingua_marchioprod);
            }
            catch (JSONException ex) {
                Logger.getLogger(FinestraDettDAAController.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        final CodiceDescrizioneComboBox dfgdd = new CodiceDescrizioneComboBox(lingua_descrcomm, descr_linguadescrcomm);
        final CodiceDescrizioneComboBox dfgddd = new CodiceDescrizioneComboBox(lingua_marchioprod, descr_linguamarchiprod);
        final CodiceDescrizioneComboBox dfgd = new CodiceDescrizioneComboBox(tipo_stoccString, descr_tipostoc);
        if (this.import_doc) {
            for (i = 0; i < lista_imbo.size(); ++i) {
                String nr_imb;
                String codice_imb = lista_imbo.get(i).getColumn_codice();
                String descr_imb = lista_imbo.get(i).getColumn_descrizione();
                String tipoimb = nr_imb = lista_imbo.get(i).getColumn_nrimb();
                if (nr_imb.equals(NavigatorAcciseController.LABEL_CONFEZ) || nr_imb.equals(NavigatorAcciseController.LABEL_BOTT)) {
                    nr_imb = "1";
                }
                if (tipoimb.equals(NavigatorAcciseController.LABEL_BOTT)) {
                    this.editText_nrbottiglie.setText(nr_imb);
                }
                this.lista_imb.add((Object)new ColumnTableImballaggi("", codice_imb, nr_imb, "", "", "", ""));
            }
        } else {
            for (i = 0; i < lista_imbo.size(); ++i) {
                String nr_imb;
                String codice_imb = lista_imbo.get(i).getColumn_codice();
                String descr_imb = lista_imbo.get(i).getColumn_descrizione();
                String tipoimb = nr_imb = lista_imbo.get(i).getColumn_nrimb();
                if (nr_imb.equals(NavigatorAcciseController.LABEL_CONFEZ) || nr_imb.equals(NavigatorAcciseController.LABEL_BOTT)) {
                    nr_imb = "1";
                }
                TextInputDialog dialogim = new TextInputDialog("");
                dialogim.setTitle("SICUREZZA");
                dialogim.setHeaderText("Confermare l'import imballaggio " + codice_imb + " - " + descr_imb + "?");
                dialogim.setContentText("Qta :");
                Optional resultim = dialogim.showAndWait();
                if (!resultim.isPresent()) continue;
                nr_imb = ((String)resultim.get()).equals("0") ? "1" : (String)resultim.get();
                if (tipoimb.equals(NavigatorAcciseController.LABEL_BOTT)) {
                    this.editText_nrbottiglie.setText(nr_imb);
                }
                this.lista_imb.add((Object)new ColumnTableImballaggi("", codice_imb, nr_imb, "", "", "", ""));
            }
        }
        this.table_imb.refresh();
        if (cpa != null && !cpa.equals("")) {
            try {
                Platform.runLater((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        try {
                            CodiceDescrizioneComboBox dfg;
                            String descr_zona;
                            if (!tipo_stoccString.equals("")) {
                                FinestraDettDAAController.this.cmbx_tipostoccaggio.getSelectionModel().select((Object)dfgd);
                            } else {
                                FinestraDettDAAController.this.cmbx_tipostoccaggio.getSelectionModel().selectFirst();
                            }
                            FinestraDettDAAController.this.editText_aams.setText(aams);
                            FinestraDettDAAController.this.editText_cadd.setText(cadd);
                            FinestraDettDAAController.this.editText_cn.setText(codicenc);
                            FinestraDettDAAController.this.editText_cpa.setText(cpa);
                            FinestraDettDAAController.this.editText_densita.setText(densita);
                            FinestraDettDAAController.this.editText_descrizione.setText(descrizione);
                            FinestraDettDAAController.this.editText_dimensioniprodotto.setText(dim_prod);
                            FinestraDettDAAController.this.editText_gradoalcolico.setText(grado_alcolico);
                            FinestraDettDAAController.this.editText_gradoplato.setText(grado_plato);
                            FinestraDettDAAController.this.editText_pesolordo.setText(peso_lordo);
                            FinestraDettDAAController.this.editText_pesonetto.setText(peso_netto);
                            FinestraDettDAAController.this.editText_capacita.setText(capacita);
                            FinestraDettDAAController.this.editText_codice.setText(codice);
                            FinestraDettDAAController.this.editText_taric.setText(taric);
                            FinestraDettDAAController.this.editText_codiceprodotto.setText(codice_prodotto);
                            FinestraDettDAAController.this.editText_descrizionecomm.setText(descrizione_commerciale);
                            HashMap lis = FXMLDocumentController.util.getParameters();
                            boolean DESCR_AUTOMATICA_ARTICOLI_17P = Boolean.parseBoolean(lis.get("DESCR_AUTOMATICA_ARTICOLI_17P").toString());
                            if (DESCR_AUTOMATICA_ARTICOLI_17P) {
                                FinestraDettDAAController.this.editText_descrizionecomm.setText(descrizione);
                                CodiceDescrizioneComboBox dfgdds = new CodiceDescrizioneComboBox("it", "Italiano");
                                FinestraDettDAAController.this.cmbx_linguadescrcomm.getSelectionModel().select((Object)dfgdds);
                            }
                            FinestraDettDAAController.this.editText_marchioprodotto.setText(marchio_prod);
                            if (!zona_coltivazione.equals("")) {
                                try {
                                    descr_zona = FXMLDocumentController.ricerca.getDescrizioneZonaColtivazione(zona_coltivazione);
                                    dfg = new CodiceDescrizioneComboBox(zona_coltivazione, descr_zona);
                                    FinestraDettDAAController.this.cmbx_zonacoltivazione.getSelectionModel().select((Object)dfg);
                                }
                                catch (JSONException ex) {
                                    Logger.getLogger(FinestraDettDAAController.class.getName()).log(Level.SEVERE, null, ex);
                                }
                            }
                            if (!catvino.equals("")) {
                                try {
                                    descr_zona = FXMLDocumentController.ricerca.getDescrizioneCategoriaVino(catvino);
                                    dfg = new CodiceDescrizioneComboBox(catvino, descr_zona);
                                    FinestraDettDAAController.this.cmbx_categoriavino.getSelectionModel().select((Object)dfg);
                                }
                                catch (JSONException ex) {
                                    Logger.getLogger(FinestraDettDAAController.class.getName()).log(Level.SEVERE, null, ex);
                                }
                            }
                            if (!lingua_descrcomm.equals("")) {
                                FinestraDettDAAController.this.cmbx_linguadescrcomm.getSelectionModel().select((Object)dfgdd);
                            }
                            if (!lingua_marchioprod.equals("")) {
                                FinestraDettDAAController.this.cmbx_linguamarchioprod.getSelectionModel().select((Object)dfgddd);
                            }
                            FinestraDettDAAController.this.calcola();
                        }
                        catch (JSONException ex) {
                            Logger.getLogger(FinestraDettDAAController.class.getName()).log(Level.SEVERE, null, ex);
                        }
                        catch (IOException ex) {
                            Logger.getLogger(FinestraDettDAAController.class.getName()).log(Level.SEVERE, null, ex);
                        }
                        catch (URISyntaxException ex) {
                            Logger.getLogger(FinestraDettDAAController.class.getName()).log(Level.SEVERE, null, ex);
                        }
                    }
                });
            }
            catch (Exception ex) {
                Logger.getLogger(FinestraDettDAAController.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }

    @FXML
    private void btnSvuotaArticolo(ActionEvent event) {
        this.editText_codice.setText("");
    }

    private void resetta() {
        this.cmbx_tipostoccaggio.getSelectionModel().selectFirst();
        this.editText_aams.setText("");
        this.editText_cadd.setText("");
        this.editText_cn.setText("");
        this.editText_cpa.setText("");
        this.editText_densita.setText("");
        this.editText_descrizione.setText("");
        this.editText_dimensioniprodotto.setText("");
        this.editText_gradoalcolico.setText("");
        this.editText_gradoplato.setText("");
        this.editText_pesolordo.setText("");
        this.editText_pesonetto.setText("");
        this.editText_capacita.setText("");
        this.editText_codice.setText("");
        this.editText_taric.setText("");
        this.editText_codiceprodotto.setText("");
        this.editText_descrizionecomm.setText("");
        this.editText_marchioprodotto.setText("");
        this.cmbx_zonacoltivazione.getSelectionModel().selectFirst();
        this.cmbx_categoriavino.getSelectionModel().selectFirst();
        this.cmbx_linguadescrcomm.getSelectionModel().selectFirst();
        this.cmbx_linguamarchioprod.getSelectionModel().selectFirst();
        this.lista_imb.clear();
    }

    @FXML
    private void btnAggiungiVino(ActionEvent event) throws IOException {
        FXMLLoader loader = new FXMLLoader(this.getClass().getResource("/accise/view/FinestraVinoDAA.fxml"));
        final Stage stage = new Stage();
        stage.setMaximized(false);
        stage.setTitle("Trattamento");
        stage.setScene(new Scene((Parent)((Pane)loader.load())));
        FinestraVinoDAAController controller = (FinestraVinoDAAController)loader.getController();
        stage.initStyle(StageStyle.UNDECORATED);
        stage.initOwner(((Node)event.getSource()).getScene().getWindow());
        controller.getParent().setOnMousePressed((EventHandler)new EventHandler<MouseEvent>(){

            public void handle(MouseEvent event) {
                FinestraDettDAAController.this.xOffset = event.getSceneX();
                FinestraDettDAAController.this.yOffset = event.getSceneY();
            }
        });
        controller.getParent().setOnMouseDragged((EventHandler)new EventHandler<MouseEvent>(){

            public void handle(MouseEvent event) {
                stage.setX(event.getScreenX() - FinestraDettDAAController.this.xOffset);
                stage.setY(event.getScreenY() - FinestraDettDAAController.this.yOffset);
                stage.setOpacity((double)0.8f);
            }
        });
        controller.getParent().setOnDragDone((EventHandler)new EventHandler<DragEvent>(){

            public void handle(DragEvent event) {
                stage.setOpacity(1.0);
            }
        });
        controller.getParent().setOnMouseReleased((EventHandler)new EventHandler<MouseEvent>(){

            public void handle(MouseEvent event) {
                stage.setOpacity(1.0);
            }
        });
        stage.showAndWait();
        stage.setResizable(false);
        String codice = controller.getCodice();
        String descrizione = controller.getDescrizione();
        if (!codice.equals("")) {
            this.lista_vinotrattamento.add((Object)new CodiceDescrizione(codice, descrizione));
            this.table_vino.refresh();
        }
    }

    @FXML
    private void btnEliminaVino(ActionEvent event) {
        CodiceDescrizione comf = (CodiceDescrizione)this.table_vino.getSelectionModel().getSelectedItem();
        if (comf != null) {
            this.lista_vinotrattamento.remove((Object)comf);
        }
    }

    @FXML
    private void btnAggiungiImb(ActionEvent event) throws IOException {
        FXMLLoader loader = new FXMLLoader(this.getClass().getResource("/accise/view/FinestraImballaggi.fxml"));
        final Stage stage = new Stage();
        stage.setMaximized(false);
        stage.setTitle("Imballaggi");
        stage.setScene(new Scene((Parent)((Pane)loader.load())));
        FinestraImballaggiController controller = (FinestraImballaggiController)loader.getController();
        stage.initStyle(StageStyle.UNDECORATED);
        stage.initOwner(((Node)event.getSource()).getScene().getWindow());
        controller.getParent().setOnMousePressed((EventHandler)new EventHandler<MouseEvent>(){

            public void handle(MouseEvent event) {
                FinestraDettDAAController.this.xOffset = event.getSceneX();
                FinestraDettDAAController.this.yOffset = event.getSceneY();
            }
        });
        controller.getParent().setOnMouseDragged((EventHandler)new EventHandler<MouseEvent>(){

            public void handle(MouseEvent event) {
                stage.setX(event.getScreenX() - FinestraDettDAAController.this.xOffset);
                stage.setY(event.getScreenY() - FinestraDettDAAController.this.yOffset);
                stage.setOpacity((double)0.8f);
            }
        });
        controller.getParent().setOnDragDone((EventHandler)new EventHandler<DragEvent>(){

            public void handle(DragEvent event) {
                stage.setOpacity(1.0);
            }
        });
        controller.getParent().setOnMouseReleased((EventHandler)new EventHandler<MouseEvent>(){

            public void handle(MouseEvent event) {
                stage.setOpacity(1.0);
            }
        });
        stage.showAndWait();
        stage.setResizable(false);
        String identificativoimb = controller.getIdentificativoimb();
        String identificativosig = controller.getIdentificativosig();
        String linguadescrinfsig = controller.getLingua_descrinfsig();
        String tipo_imbdescr = controller.getTipo_imbdescr();
        String infsig = controller.getInfsig();
        String lingua_infsig = controller.getLingua_infsig();
        String numeroimb = controller.getNumero_imb();
        String tipo_imb = controller.getTipo_imb();
        if (tipo_imb != null && !tipo_imb.equals("")) {
            this.lista_imb.add((Object)new ColumnTableImballaggi("", tipo_imb, numeroimb, identificativosig, infsig, lingua_infsig, identificativoimb));
            this.table_imb.refresh();
        }
    }

    @FXML
    private void btnEliminaImb(ActionEvent event) {
        ColumnTableImballaggi drt = (ColumnTableImballaggi)this.table_imb.getSelectionModel().getSelectedItem();
        if (drt != null) {
            this.lista_imb.remove((Object)drt);
        }
        this.table_imb.refresh();
    }

    @FXML
    private void btnSalva(ActionEvent event) {
        try {
            String tipo_prodotto;
            ArrayList<ColumnTableImballaggi> listas_imb = new ArrayList<ColumnTableImballaggi>();
            for (int i = 0; i < this.lista_imb.size(); ++i) {
                listas_imb.add((ColumnTableImballaggi)this.lista_imb.get(i));
            }
            ArrayList<CodiceDescrizione> listas_vino = new ArrayList<CodiceDescrizione>();
            for (int i = 0; i < this.lista_vinotrattamento.size(); ++i) {
                listas_vino.add((CodiceDescrizione)this.lista_vinotrattamento.get(i));
            }
            CodiceDescrizioneComboBox catvino = (CodiceDescrizioneComboBox)this.cmbx_categoriavino.getSelectionModel().getSelectedItem();
            CodiceDescrizioneComboBox zoncolt = (CodiceDescrizioneComboBox)this.cmbx_zonacoltivazione.getSelectionModel().getSelectedItem();
            CodiceDescrizioneComboBox paeseterzo = (CodiceDescrizioneComboBox)this.cmbx_paeseterzo.getSelectionModel().getSelectedItem();
            CodiceDescrizioneComboBox linguaaltrinfvino = (CodiceDescrizioneComboBox)this.cmbx_linguaaltreinf.getSelectionModel().getSelectedItem();
            CodiceDescrizioneComboBox tipostoc = (CodiceDescrizioneComboBox)this.cmbx_tipostoccaggio.getSelectionModel().getSelectedItem();
            String tipo_stoccaggio = "";
            String categoria_vino = "";
            String zona_coltivazione = "";
            String paese_terzo = "";
            String lingua_altreingvino = "";
            String altre_infovino = this.editText_altreinf.getText().trim();
            if (tipostoc != null) {
                tipo_stoccaggio = tipostoc.getCodice();
            }
            if (catvino != null) {
                categoria_vino = catvino.getCodice();
            }
            if (zoncolt != null) {
                zona_coltivazione = zoncolt.getCodice();
            }
            if (paeseterzo != null) {
                paese_terzo = paeseterzo.getCodice();
            }
            if (linguaaltrinfvino != null) {
                lingua_altreingvino = linguaaltrinfvino.getCodice();
            }
            String codice = this.editText_codice.getText().trim();
            String descrizione = this.editText_descrizione.getText().trim();
            String contrassegno_fiscale = this.editText_contrfisc.getText().trim();
            String cpa = this.editText_cpa.getText().trim();
            String peso_lordo = this.editText_pesolordo.getText().trim();
            String codice_nomenclatura = this.editText_cn.getText().trim();
            String cadd = this.editText_cadd.getText().trim();
            String taric = this.editText_taric.getText().trim();
            String codice_prodotto = this.editText_codiceprodotto.getText().trim();
            String aams = this.editText_aams.getText().trim();
            String capacita = this.editText_capacita.getText().trim();
            String densita = this.editText_densita.getText().trim();
            String peso_netto = this.editText_pesonetto.getText().trim();
            String grado_alcolico = this.editText_gradoalcolico.getText().trim();
            String grado_plato = this.editText_gradoplato.getText().trim();
            String dim_prod = this.editText_dimensioniprodotto.getText().trim();
            String marchio_prodotto = this.editText_marchioprodotto.getText().trim();
            String uso_contrfisc = this.editText_usocontrfisc.getText().trim();
            String denom_origine = this.editText_denominazioneorigine.getText().trim();
            String descr_comm = this.editText_descrizionecomm.getText().trim();
            String quantita = this.editText_quantita.getText().trim();
            String bottiglie = this.editText_nrbottiglie.getText().trim();
            if (bottiglie.equals("")) {
                bottiglie = "0";
            }
            String lingua_marchioprod = "";
            String lingua_contrfisc = "";
            String lingua_denomori = "";
            String lingua_descrcomm = "";
            CodiceDescrizioneComboBox marchioprod = (CodiceDescrizioneComboBox)this.cmbx_linguamarchioprod.getSelectionModel().getSelectedItem();
            CodiceDescrizioneComboBox contrfisc = (CodiceDescrizioneComboBox)this.cmbx_linguacontrfisc.getSelectionModel().getSelectedItem();
            CodiceDescrizioneComboBox denomori = (CodiceDescrizioneComboBox)this.cmbx_linguadenominazione.getSelectionModel().getSelectedItem();
            CodiceDescrizioneComboBox descrcomm = (CodiceDescrizioneComboBox)this.cmbx_linguadescrcomm.getSelectionModel().getSelectedItem();
            if (marchioprod != null) {
                lingua_marchioprod = marchioprod.getCodice();
            }
            if (contrfisc != null) {
                lingua_contrfisc = contrfisc.getCodice();
            }
            if (denomori != null) {
                lingua_denomori = denomori.getCodice();
            }
            if (descrcomm != null) {
                lingua_descrcomm = descrcomm.getCodice();
            }
            boolean check_sfuso = this.chk_prodotto_sfuso.selectedProperty().get();
            this.errori.clear();
            String ret = "";
            Condizioni cond = new Condizioni();
            if (densita.equals("")) {
                densita = "0";
            }
            if (grado_alcolico.equals("")) {
                grado_alcolico = "0";
            }
            if (grado_plato.equals("")) {
                grado_plato = "0";
            }
            String valoreT012 = "";
            if (capacita.equals("")) {
                capacita = "0.0";
            }
            if (!check_sfuso && Double.parseDouble(capacita) <= 0.0) {
                ret = "Campo Capacit\u00e0 bloccante ";
                this.errori.add(ret);
            }
            if ((ret = cond.C027(valoreT012 = FXMLDocumentController.ricerca.getT012D(cpa), densita)).contains("#ERR:")) {
                ret = "Dettagli DAA (Densit\u00e0 in Kg/mc) " + ret.substring(4, ret.length());
                this.errori.add(ret);
            }
            if ((ret = cond.C026(valoreT012 = cpa.equals("B000") ? "B000" : FXMLDocumentController.ricerca.getT012A(cpa), grado_alcolico)).contains("#ERR:")) {
                ret = "Dettagli DAA (Grado alcolico) " + ret.substring(4, ret.length());
                this.errori.add(ret);
            }
            if ((ret = cond.C063(cpa, grado_plato)).contains("#ERR:")) {
                ret = "Dettagli DAA (Grado plato) " + ret.substring(4, ret.length());
                this.errori.add(ret);
            }
            int sizer = 0;
            if (!contrassegno_fiscale.equals("")) {
                ++sizer;
            }
            if ((ret = cond.C012(lingua_contrfisc, sizer)).contains("#ERR:")) {
                ret = "Dettagli DAA (Lingua contrassegno fiscale) " + ret.substring(4, ret.length());
                this.errori.add(ret);
            }
            sizer = 0;
            if (!denom_origine.equals("")) {
                ++sizer;
            }
            if ((ret = cond.C012(lingua_denomori, sizer)).contains("#ERR:")) {
                ret = "Dettagli DAA (Lingua denominazione d'origine) " + ret.substring(4, ret.length());
                this.errori.add(ret);
            }
            if (!cpa.equals("") && (ret = cond.C059(aams, tipo_prodotto = FXMLDocumentController.ricerca.getCategoriaCPA(cpa))).contains("#ERR:")) {
                ret = "Dettagli DAA (Grado plato) " + ret.substring(4, ret.length());
                this.errori.add(ret);
            }
            sizer = 0;
            if (!descr_comm.equals("")) {
                ++sizer;
            }
            if ((ret = cond.C012(lingua_descrcomm, sizer)).contains("#ERR:")) {
                ret = "Dettagli DAA (Lingua descrizione commerciale) " + ret.substring(4, ret.length());
                this.errori.add(ret);
            }
            sizer = 0;
            if (!marchio_prodotto.equals("")) {
                ++sizer;
            }
            if ((ret = cond.C012(lingua_marchioprod, sizer)).contains("#ERR:")) {
                ret = "Dettagli DAA (Lingua marchio prodotto) " + ret.substring(4, ret.length());
                this.errori.add(ret);
            }
            if ((ret = cond.C029(categoria_vino, paese_terzo)).contains("#ERR:")) {
                ret = "Vino (Paese terzo d\u2019origine) " + ret.substring(4, ret.length());
                this.errori.add(ret);
            }
            sizer = 0;
            if (!altre_infovino.equals("")) {
                ++sizer;
            }
            if ((ret = cond.C012(lingua_altreingvino, sizer)).contains("#ERR:")) {
                ret = "Vino (Lingua altre informazioni) " + ret.substring(4, ret.length());
                this.errori.add(ret);
            }
            if (this.errori.size() > 0) {
                StringBuilder builder = new StringBuilder();
                for (int i = 0; i < this.errori.size(); ++i) {
                    String s = this.errori.get(i);
                    if (s == null) continue;
                    builder.append(s + "\r\n");
                }
                FXMLDocumentController.util.alertWindow(Alert.AlertType.ERROR, "ERRORE", "ERRORE", builder.toString());
            } else {
                boolean salva = false;
                BigDecimal bigDecimal = new BigDecimal(quantita);
                if (bigDecimal.doubleValue() <= 0.0) {
                    TextInputDialog dialogim = new TextInputDialog("");
                    dialogim.setTitle("SICUREZZA");
                    dialogim.setHeaderText("Attenzione quantita a 0 , confermare il salvataggio  ?");
                    dialogim.setContentText("Password (PROCEDI):");
                    Optional resultim = dialogim.showAndWait();
                    if (resultim.isPresent() && ((String)resultim.get()).trim().trim().equals("PROCEDI")) {
                        salva = true;
                    }
                } else {
                    salva = true;
                }
                if (salva) {
                    String importo_accisa;
                    BigDecimal tot_litriacc = new BigDecimal(0);
                    if (quantita.equals("")) {
                        quantita = "0";
                    }
                    BigDecimal accisa = new BigDecimal(0);
                    BigDecimal litri = new BigDecimal(quantita);
                    if (cpa.equals("B000")) {
                        importo_accisa = FXMLDocumentController.ricerca.getImportoAccisa(this.stato_calcoloaccisa, cpa, grado_plato);
                        tot_litriacc = litri.multiply(new BigDecimal(grado_plato)).divide(new BigDecimal(100), 4, RoundingMode.HALF_UP);
                        accisa = tot_litriacc.multiply(new BigDecimal(importo_accisa)).setScale(4, RoundingMode.HALF_UP);
                    } else {
                        importo_accisa = FXMLDocumentController.ricerca.getImportoAccisa(this.stato_calcoloaccisa, cpa, grado_alcolico);
                        tot_litriacc = litri.divide(new BigDecimal(100), 4, RoundingMode.HALF_UP).multiply(new BigDecimal(importo_accisa));
                        accisa = tot_litriacc.divide(new BigDecimal(100), 4, RoundingMode.HALF_UP).multiply(new BigDecimal(10)).setScale(4, RoundingMode.HALF_UP);
                    }
                    ColumnTableVino vino = new ColumnTableVino(categoria_vino, zona_coltivazione, paese_terzo, altre_infovino, lingua_altreingvino, listas_vino);
                    ColumnTableDettDAA detDaa = new ColumnTableDettDAA(this.id, codice, cpa, codice_nomenclatura, quantita, peso_lordo, peso_netto, densita, grado_alcolico, grado_plato, contrassegno_fiscale, lingua_contrfisc, uso_contrfisc, denom_origine, lingua_denomori, dim_prod, taric, cadd, aams, descr_comm, lingua_descrcomm, marchio_prodotto, lingua_marchioprod, listas_imb, vino, capacita, descrizione, accisa.toString(), codice_prodotto, tipo_stoccaggio, bottiglie, check_sfuso, this.id);
                    this.lista_dettdaa.add((Object)detDaa);
                    Stage stage = (Stage)this.btn_close.getScene().getWindow();
                    stage.close();
                }
            }
        }
        catch (JSONException ex) {
            Logger.getLogger(FinestraDettDAAController.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    @FXML
    private void btnCercaCPA(ActionEvent event) throws IOException {
        FXMLLoader loader = new FXMLLoader(this.getClass().getResource("/accise/view/SearchButtonCPA.fxml"));
        final Stage stage = new Stage();
        stage.setMaximized(false);
        stage.setTitle("CPA");
        stage.setScene(new Scene((Parent)((Pane)loader.load())));
        SearchButtonCPA controller = (SearchButtonCPA)loader.getController();
        stage.initStyle(StageStyle.UNDECORATED);
        stage.initOwner(((Node)event.getSource()).getScene().getWindow());
        stage.setMaximized(true);
        controller.getParent().setOnMousePressed((EventHandler)new EventHandler<MouseEvent>(){

            public void handle(MouseEvent event) {
                FinestraDettDAAController.this.xOffset = event.getSceneX();
                FinestraDettDAAController.this.yOffset = event.getSceneY();
            }
        });
        controller.getParent().setOnMouseDragged((EventHandler)new EventHandler<MouseEvent>(){

            public void handle(MouseEvent event) {
                stage.setX(event.getScreenX() - FinestraDettDAAController.this.xOffset);
                stage.setY(event.getScreenY() - FinestraDettDAAController.this.yOffset);
                stage.setOpacity((double)0.8f);
            }
        });
        controller.getParent().setOnDragDone((EventHandler)new EventHandler<DragEvent>(){

            public void handle(DragEvent event) {
                stage.setOpacity(1.0);
            }
        });
        controller.getParent().setOnMouseReleased((EventHandler)new EventHandler<MouseEvent>(){

            public void handle(MouseEvent event) {
                stage.setOpacity(1.0);
            }
        });
        stage.showAndWait();
        stage.setResizable(false);
        String cpa = controller.getCpa();
        String taric = controller.getTaric();
        String cadd = controller.getCadd();
        String nc = controller.getNc();
        String aams = controller.getAams();
        if (!cpa.equals("")) {
            this.editText_cpa.setText(cpa);
            this.editText_cadd.setText(cadd);
            this.editText_cn.setText(nc);
            this.editText_taric.setText(taric);
            this.editText_codiceprodotto.setText(aams);
        }
    }

    @FXML
    private void btnSvuotaCPA(ActionEvent event) {
        this.editText_cpa.setText("");
        this.editText_cadd.setText("");
        this.editText_cn.setText("");
        this.editText_taric.setText("");
    }

    public void setFlgImportDoc(boolean flg_importdoc) {
        this.editText_quantita.setEditable(!flg_importdoc);
        this.editText_codice.setEditable(!flg_importdoc);
        this.btn_svuotaarticolo.setDisable(flg_importdoc);
        this.btn_cercarticolo.setDisable(flg_importdoc);
        this.import_doc = true;
    }

    public void setModifica(ColumnTableDettDAA dettdaa) throws JSONException {
        final List<ColumnTableImballaggi> listas_imb = dettdaa.getColumn_imballaggi();
        final ColumnTableVino vino = dettdaa.getColumn_vino();
        final String codice = dettdaa.getColumn_codice();
        final String descrizione = dettdaa.getColumn_descrizione();
        final String contrassegno_fiscale = dettdaa.getColumn_contrassegnofiscale();
        final String cpa = dettdaa.getColumn_cpa();
        final String peso_lordo = dettdaa.getColumn_pesolordo();
        final String codice_nomenclatura = dettdaa.getColumn_nc();
        final String codice_prodotto = dettdaa.getColumn_codiceprodotto();
        final String cadd = dettdaa.getColumn_cadd();
        final String taric = dettdaa.getColumn_tarica();
        final String aams = dettdaa.getColumn_aams();
        final String capacita = dettdaa.getColumn_capacita();
        final String densita = dettdaa.getColumn_densita();
        final String peso_netto = dettdaa.getColumn_pesonetto();
        final String grado_alcolico = dettdaa.getColumn_gradoalcolico();
        final String grado_plato = dettdaa.getColumn_gradoplato();
        final String dim_prod = dettdaa.getColumn_dimensioniproduttore();
        final String marchio_prodotto = dettdaa.getColumn_marchioprodotti();
        String uso_contrfisc = dettdaa.getColumn_usocontrassegnofiscale();
        final String denom_origine = dettdaa.getColumn_denominazioneorigine();
        final String descr_comm = dettdaa.getColumn_descrcomm();
        final String quantita = dettdaa.getColumn_quantita();
        final String lingua_marchioprod = dettdaa.getColumn_linguamarchioprodotti();
        final String lingua_contrfisc = dettdaa.getColumn_linguacontrassegnofiscale();
        final String lingua_denomori = dettdaa.getColumn_linguadenominazioneorigine();
        final String lingua_descrcomm = dettdaa.getColumn_linguadescrcomm();
        final String tipo_stoccaggio = dettdaa.getColumn_tipostoccaggio();
        final String nr_bottiglie = dettdaa.getColumn_nrbottiglie();
        final boolean flg_sfuso = dettdaa.getColumn_flgsfuso();
        this.id = dettdaa.getColumn_id();
        Platform.runLater((Runnable)new Runnable(){

            @Override
            public void run() {
                try {
                    String descr;
                    List<Object> listas_vinotrattamenti = new ArrayList();
                    if (vino != null && vino.getColumn_trattamentivino() != null) {
                        listas_vinotrattamenti = vino.getColumn_trattamentivino();
                    }
                    String categoria_vino = "";
                    String zona_coltivazione = "";
                    String paese_terzo = "";
                    String lingua_altreingvino = "";
                    String altre_infovino = "";
                    if (vino != null) {
                        categoria_vino = vino.getColumn_categoriavino();
                        zona_coltivazione = vino.getColumn_zonacoltivazione();
                        paese_terzo = vino.getColumn_paeseterzo();
                        lingua_altreingvino = vino.getColumn_linguaaltreinf();
                        altre_infovino = vino.getColumn_altreinf();
                    }
                    FinestraDettDAAController.this.lista_imb.clear();
                    FinestraDettDAAController.this.lista_vinotrattamento.clear();
                    if (listas_imb != null) {
                        FinestraDettDAAController.this.lista_imb.setAll((Collection)listas_imb);
                    }
                    if (listas_vinotrattamenti != null) {
                        FinestraDettDAAController.this.lista_vinotrattamento.addAll(listas_vinotrattamenti);
                    }
                    CodiceDescrizioneComboBox catvino = null;
                    CodiceDescrizioneComboBox zoncolt = null;
                    CodiceDescrizioneComboBox paeseterzo = null;
                    CodiceDescrizioneComboBox linguaaltrinfvino = null;
                    CodiceDescrizioneComboBox marchioprod = null;
                    CodiceDescrizioneComboBox contrfisc = null;
                    CodiceDescrizioneComboBox denomori = null;
                    CodiceDescrizioneComboBox descrcomm = null;
                    CodiceDescrizioneComboBox tipostoc = null;
                    FinestraDettDAAController.this.chk_prodotto_sfuso.selectedProperty().set(flg_sfuso);
                    FinestraDettDAAController.this.editText_nrbottiglie.setText(nr_bottiglie);
                    FinestraDettDAAController.this.editText_aams.setText(aams);
                    FinestraDettDAAController.this.editText_codiceprodotto.setText(codice_prodotto);
                    FinestraDettDAAController.this.editText_altreinf.setText(altre_infovino);
                    FinestraDettDAAController.this.editText_cadd.setText(cadd);
                    FinestraDettDAAController.this.editText_capacita.setText(capacita);
                    FinestraDettDAAController.this.editText_cn.setText(codice_nomenclatura);
                    FinestraDettDAAController.this.editText_codice.setText(codice);
                    FinestraDettDAAController.this.editText_contrfisc.setText(contrassegno_fiscale);
                    FinestraDettDAAController.this.editText_cpa.setText(cpa);
                    FinestraDettDAAController.this.editText_denominazioneorigine.setText(denom_origine);
                    FinestraDettDAAController.this.editText_densita.setText(densita);
                    FinestraDettDAAController.this.editText_descrizione.setText(descrizione);
                    FinestraDettDAAController.this.editText_descrizionecomm.setText(descr_comm);
                    FinestraDettDAAController.this.editText_dimensioniprodotto.setText(dim_prod);
                    FinestraDettDAAController.this.editText_gradoalcolico.setText(grado_alcolico);
                    FinestraDettDAAController.this.editText_gradoplato.setText(grado_plato);
                    FinestraDettDAAController.this.editText_marchioprodotto.setText(marchio_prodotto);
                    FinestraDettDAAController.this.editText_pesolordo.setText(peso_lordo);
                    FinestraDettDAAController.this.editText_pesonetto.setText(peso_netto);
                    FinestraDettDAAController.this.editText_quantita.setText(quantita);
                    FinestraDettDAAController.this.editText_taric.setText(taric);
                    if (!tipo_stoccaggio.equals("")) {
                        descr = FXMLDocumentController.ricerca.getDescrizioneTipoStoccaggio(tipo_stoccaggio);
                        tipostoc = new CodiceDescrizioneComboBox(tipo_stoccaggio, descr);
                    }
                    if (!lingua_marchioprod.equals("")) {
                        descr = FXMLDocumentController.ricerca.getDescrizioneT001(lingua_marchioprod);
                        marchioprod = new CodiceDescrizioneComboBox(lingua_marchioprod, descr);
                    }
                    if (!lingua_contrfisc.equals("")) {
                        descr = FXMLDocumentController.ricerca.getDescrizioneT001(lingua_contrfisc);
                        contrfisc = new CodiceDescrizioneComboBox(lingua_contrfisc, descr);
                    }
                    if (!lingua_denomori.equals("")) {
                        descr = FXMLDocumentController.ricerca.getDescrizioneT001(lingua_denomori);
                        denomori = new CodiceDescrizioneComboBox(lingua_denomori, descr);
                    }
                    if (!lingua_descrcomm.equals("")) {
                        descr = FXMLDocumentController.ricerca.getDescrizioneT001(lingua_descrcomm);
                        descrcomm = new CodiceDescrizioneComboBox(lingua_descrcomm, descr);
                    }
                    if (!categoria_vino.equals("")) {
                        String descr_catvino = FXMLDocumentController.ricerca.getDescrizioneCategoriaVino(categoria_vino);
                        catvino = new CodiceDescrizioneComboBox(categoria_vino, descr_catvino);
                    }
                    String descr_zonacolt = "";
                    if (!zona_coltivazione.equals("")) {
                        descr_zonacolt = FXMLDocumentController.ricerca.getDescrizioneZonaColtivazione(zona_coltivazione);
                        zoncolt = new CodiceDescrizioneComboBox(zona_coltivazione, descr_zonacolt);
                    }
                    String descr_paeseterzo = "";
                    if (!paese_terzo.equals("")) {
                        descr_paeseterzo = FXMLDocumentController.ricerca.getDescrizionePaeseTerzo(paese_terzo);
                        paeseterzo = new CodiceDescrizioneComboBox(paese_terzo, descr_paeseterzo);
                    }
                    String descr_linguaaltreingvino = "";
                    if (!lingua_altreingvino.equals("")) {
                        descr_linguaaltreingvino = FXMLDocumentController.ricerca.getDescrizioneT001(lingua_altreingvino);
                        linguaaltrinfvino = new CodiceDescrizioneComboBox(lingua_altreingvino, descr_linguaaltreingvino);
                    }
                    FinestraDettDAAController.this.cmbx_tipostoccaggio.getSelectionModel().select((Object)tipostoc);
                    FinestraDettDAAController.this.cmbx_categoriavino.getSelectionModel().select((Object)catvino);
                    FinestraDettDAAController.this.cmbx_linguaaltreinf.getSelectionModel().select((Object)linguaaltrinfvino);
                    FinestraDettDAAController.this.cmbx_linguacontrfisc.getSelectionModel().select((Object)contrfisc);
                    FinestraDettDAAController.this.cmbx_linguadenominazione.getSelectionModel().select((Object)denomori);
                    FinestraDettDAAController.this.cmbx_linguadescrcomm.getSelectionModel().select((Object)descrcomm);
                    FinestraDettDAAController.this.cmbx_linguamarchioprod.getSelectionModel().select((Object)marchioprod);
                    FinestraDettDAAController.this.cmbx_paeseterzo.getSelectionModel().select((Object)paeseterzo);
                    FinestraDettDAAController.this.cmbx_zonacoltivazione.getSelectionModel().select((Object)zoncolt);
                    FinestraDettDAAController.this.table_imb.refresh();
                    FinestraDettDAAController.this.table_vino.refresh();
                }
                catch (Exception ex) {
                    System.out.println(ex.toString());
                }
            }
        });
    }

    @FXML
    private void btnRMistoCpa(ActionEvent event) {
        FXMLDocumentController.util.alertWindow(this.stack, this.regole.R047() + this.regole.R048() + this.regole.R070() + this.regole.R072(), "R047-R048-R070-R072", "information");
    }

    @FXML
    private void btnR19(ActionEvent event) {
        FXMLDocumentController.util.alertWindow(this.stack, this.regole.R019(), "R019", "information");
    }

    @FXML
    private void btnR20(ActionEvent event) {
        FXMLDocumentController.util.alertWindow(this.stack, this.regole.R020(), "R020", "information");
    }

    @FXML
    private void btnR22(ActionEvent event) {
        FXMLDocumentController.util.alertWindow(this.stack, this.regole.R022(), "R020", "information");
    }

    @FXML
    private void btnR23(ActionEvent event) {
        FXMLDocumentController.util.alertWindow(this.stack, this.regole.R023(), "R023", "information");
    }

    @FXML
    private void btnR24(ActionEvent event) {
        FXMLDocumentController.util.alertWindow(this.stack, this.regole.R024(), "R024", "information");
    }

    @FXML
    private void btnR21(ActionEvent event) {
        FXMLDocumentController.util.alertWindow(this.stack, this.regole.R021(), "R021", "information");
    }

    @FXML
    private void btnCalculate(ActionEvent event) throws JSONException {
        this.calcola();
    }

    private void calcola() throws JSONException {
        String nrbottiglie = this.editText_nrbottiglie.getText().trim();
        String codice_prodotto = this.editText_codice.getText().trim();
        String peso_lordo = FXMLDocumentController.ricerca.getPesoLordoAccise(FXMLDocumentController.GLOBAL_AZIENDA, FXMLDocumentController.GLOBAL_SOTTOAZZ, FXMLDocumentController.GLOBAL_ICQRF, codice_prodotto);
        String peso_netto = FXMLDocumentController.ricerca.getPesoNettoAccise(FXMLDocumentController.GLOBAL_AZIENDA, FXMLDocumentController.GLOBAL_SOTTOAZZ, FXMLDocumentController.GLOBAL_ICQRF, codice_prodotto);
        if (nrbottiglie.equals("")) {
            nrbottiglie = "0";
        }
        BigDecimal bt = new BigDecimal(nrbottiglie);
        BigDecimal pn = new BigDecimal(peso_netto);
        BigDecimal pl = new BigDecimal(peso_lordo);
        BigDecimal qta = bt.multiply(pn).setScale(2, RoundingMode.HALF_UP);
        BigDecimal qta_lordo = bt.multiply(pl).setScale(2, RoundingMode.HALF_UP);
        this.editText_pesolordo.setText(qta_lordo.toString());
        this.editText_pesonetto.setText(qta.toString());
        this.editText_quantita.setText(qta.toString());
    }

    @FXML
    private void btnModificaImb(ActionEvent event) throws IOException, JSONException {
        ColumnTableImballaggi oper = (ColumnTableImballaggi)this.table_imb.getSelectionModel().getSelectedItem();
        if (oper != null) {
            FXMLLoader loader = new FXMLLoader(this.getClass().getResource("/accise/view/FinestraImballaggi.fxml"));
            final Stage stage = new Stage();
            stage.setMaximized(false);
            stage.setTitle("Imballaggi");
            stage.setScene(new Scene((Parent)((Pane)loader.load())));
            FinestraImballaggiController controller = (FinestraImballaggiController)loader.getController();
            String tipo_imb = oper.getColumn_tipoimballaggio();
            String numero_imballaggi = oper.getColumn_numeroimballaggi();
            String identificativosig = oper.getColumn_identificazionecomm();
            String infsig = oper.getColumn_infsigilli();
            String identificativoimb = oper.getColumn_identificativoimb();
            String lingua_infsig = oper.getColumn_linguainfsig();
            String lingua_descrinfsig = oper.getColumn_linguainfsig();
            controller.setModifica(tipo_imb, numero_imballaggi, identificativosig, infsig, identificativoimb, lingua_infsig, lingua_descrinfsig);
            stage.initStyle(StageStyle.UNDECORATED);
            stage.initOwner(((Node)event.getSource()).getScene().getWindow());
            controller.getParent().setOnMousePressed((EventHandler)new EventHandler<MouseEvent>(){

                public void handle(MouseEvent event) {
                    FinestraDettDAAController.this.xOffset = event.getSceneX();
                    FinestraDettDAAController.this.yOffset = event.getSceneY();
                }
            });
            controller.getParent().setOnMouseDragged((EventHandler)new EventHandler<MouseEvent>(){

                public void handle(MouseEvent event) {
                    stage.setX(event.getScreenX() - FinestraDettDAAController.this.xOffset);
                    stage.setY(event.getScreenY() - FinestraDettDAAController.this.yOffset);
                    stage.setOpacity((double)0.8f);
                }
            });
            controller.getParent().setOnDragDone((EventHandler)new EventHandler<DragEvent>(){

                public void handle(DragEvent event) {
                    stage.setOpacity(1.0);
                }
            });
            controller.getParent().setOnMouseReleased((EventHandler)new EventHandler<MouseEvent>(){

                public void handle(MouseEvent event) {
                    stage.setOpacity(1.0);
                }
            });
            stage.showAndWait();
            stage.setResizable(false);
            identificativoimb = controller.getIdentificativoimb();
            identificativosig = controller.getIdentificativosig();
            String linguadescrinfsig = controller.getLingua_descrinfsig();
            String tipo_imbdescr = controller.getTipo_imbdescr();
            infsig = controller.getInfsig();
            lingua_infsig = controller.getLingua_infsig();
            String numeroimb = controller.getNumero_imb();
            tipo_imb = controller.getTipo_imb();
            if (tipo_imb != null && !tipo_imb.equals("")) {
                this.lista_imb.remove((Object)oper);
                this.lista_imb.add((Object)new ColumnTableImballaggi("", tipo_imb, numeroimb, identificativosig, infsig, lingua_infsig, identificativoimb));
                this.table_imb.refresh();
            }
        }
    }
}

