/*
 * Decompiled with CFR 0.152.
 */
package WbsClientUpd;

import WbsClientUpd.WbsClientUpd;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import net.lingala.zip4j.core.ZipFile;
import net.lingala.zip4j.exception.ZipException;
import net.lingala.zip4j.model.ZipParameters;
import org.apache.commons.lang3.SystemUtils;

public class ZipUtility {
    boolean isLinux = SystemUtils.IS_OS_LINUX;
    boolean isWindows = SystemUtils.IS_OS_WINDOWS;

    public void unzip(String zipFilePath, String saveDir, String zipPassword) {
        try {
            ZipFile zipFile = new ZipFile(zipFilePath);
            if (zipFile.isEncrypted()) {
                zipFile.setPassword(zipPassword);
            }
            zipFile.extractAll(saveDir);
            System.out.println("Files extract completato");
        }
        catch (ZipException ex) {
            WbsClientUpd.log.error("Class:UnzipUtility - unzip() - " + ex);
        }
    }

    public void zip(String path, String dir2zip) {
        try {
            String sep = "";
            if (this.isWindows) {
                sep = "\\";
            }
            if (this.isLinux) {
                sep = "/";
            }
            DateTimeFormatter formatter = DateTimeFormatter.ofPattern("ddMMyyyy_HH_mm_ss");
            LocalDateTime today = LocalDateTime.now();
            String formattedDateTime = today.format(formatter);
            String nameZipFile = sep + formattedDateTime + ".zip";
            ZipFile zipFile = new ZipFile(dir2zip + nameZipFile);
            String folderToAdd = path;
            ZipParameters parameters = new ZipParameters();
            parameters.setCompressionMethod(8);
            parameters.setCompressionLevel(5);
            zipFile.addFolder(folderToAdd, parameters);
        }
        catch (Exception ex) {
            WbsClientUpd.log.error("Class:UnzipUtility - zip() - " + ex);
        }
    }
}

